/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.worker.handler;

import com.google.caliper.bridge.WorkerRequest;
import com.google.caliper.worker.handler.RequestHandler;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;

public final class RequestDispatcher {
    private final ImmutableMap<Class<? extends WorkerRequest>, Provider<RequestHandler>> requestHandlers;

    @Inject
    RequestDispatcher(Map<Class<? extends WorkerRequest>, Provider<RequestHandler>> requestHandlers) {
        this.requestHandlers = ImmutableMap.copyOf(requestHandlers);
    }

    public void dispatch(WorkerRequest request) throws Exception {
        Class requestType = request.type();
        Provider handlerProvider = (Provider)Preconditions.checkNotNull((Object)((Provider)this.requestHandlers.get((Object)requestType)), (String)"No handler found for request of type %s", (Object)requestType.getName());
        ((RequestHandler)handlerProvider.get()).handleRequest(request);
    }
}

