Project: /_project.yaml
Book: /_book.yaml

# Build Event Protocol Glossary

{% include "_buttons.html" %}

Each BEP event type has its own semantics, minimally documented in
[build\_event\_stream.proto](https://github.com/bazelbuild/bazel/blob/master/src/main/java/com/google/devtools/build/lib/buildeventstream/proto/build_event_stream.proto){: .external}.
The following glossary describes each event type.

## Aborted {:#aborted}

Unlike other events, `Aborted` does not have a corresponding ID type, because
the `Aborted` event *replaces* events of other types. This event indicates that
the build terminated early and the event ID it appears under was not produced
normally. `Aborted` contains an enum and human-friendly description to explain
why the build did not complete.

For example, if a build is evaluating a target when the user interrupts Bazel,
BEP contains an event like the following:

```json
{
  "id": {
    "targetCompleted": {
      "label": "//:foo",
      "configuration": {
        "id": "544e39a7f0abdb3efdd29d675a48bc6a"
      }
    }
  },
  "aborted": {
    "reason": "USER_INTERRUPTED"
  }
}
```

## ActionExecuted {:#actionexecuted}

Provides details about the execution of a specific
[Action](/rules/lib/actions) in a build. By default, this event is
included in the BEP only for failed actions, to support identifying the root cause
of build failures. Users may set the `--build_event_publish_all_actions` flag
to include all `ActionExecuted` events.

## BuildFinished {:#buildfinished}

A single `BuildFinished` event is sent after the command is complete and
includes the exit code for the command. This event provides authoritative
success/failure information.

## BuildMetadata {:#buildmetadata}

Contains the parsed contents of the `--build_metadata` flag. This event exists
to support Bazel integration with other tooling by plumbing external data (such as
identifiers).

## BuildMetrics {:#buildmetrics}

A single `BuildMetrics` event is sent at the end of every command and includes
counters/gauges useful for quantifying the build tool's behavior during the
command. These metrics indicate work actually done and does not count cached
work that is reused.

Note that `memory_metrics` may not be populated if there was no Java garbage
collection during the command's execution. Users may set the
`--memory_profile=/dev/null` option which forces the garbage
collector to run at the end of the command to populate `memory_metrics`.

```json
{
  "id": {
    "buildMetrics": {}
  },
  "buildMetrics": {
    "actionSummary": {
      "actionsExecuted": "1"
    },
    "memoryMetrics": {},
    "targetMetrics": {
      "targetsLoaded": "9",
      "targetsConfigured": "19"
    },
    "packageMetrics": {
      "packagesLoaded": "5"
    },
    "timingMetrics": {
      "cpuTimeInMs": "1590",
      "wallTimeInMs": "359"
    }
  }
}
```

## BuildStarted {:#buildstarted}

The first event in a BEP stream, `BuildStarted` includes metadata describing the
command before any meaningful work begins.

## BuildToolLogs {:#buildtoollogs}

A single `BuildToolLogs` event is sent at the end of a command, including URIs
of files generated by the build tool that may aid in understanding or debugging
build tool behavior. Some information may be included inline.

```json
{
  "id": {
    "buildToolLogs": {}
  },
  "lastMessage": true,
  "buildToolLogs": {
    "log": [
      {
        "name": "elapsed time",
        "contents": "MC4xMjEwMDA="
      },
      {
        "name": "process stats",
        "contents": "MSBwcm9jZXNzOiAxIGludGVybmFsLg=="
      },
      {
        "name": "command.profile.gz",
        "uri": "file:///tmp/.cache/bazel/_bazel_foo/cde87985ad0bfef34eacae575224b8d1/command.profile.gz"
      }
    ]
  }
}
```

## CommandLine {:#commandline}

The BEP contains multiple `CommandLine` events containing representations of all
command-line arguments (including options and uninterpreted arguments).
Each `CommandLine` event has a label in its `StructuredCommandLineId` that
indicates which representation it conveys; three such events appear in the BEP:

* `"original"`: Reconstructed commandline as Bazel received it from the Bazel
  client, without startup options sourced from .rc files.
* `"canonical"`: The effective commandline with .rc files expanded and
  invocation policy applied.
* `"tool"`: Populated from the `--experimental_tool_command_line` option. This
  is useful to convey the command-line of a tool wrapping Bazel through the BEP.
  This could be a base64-encoded `CommandLine` binary protocol buffer message
  which is used directly, or a string which is parsed but not interpreted (as
  the tool's options may differ from Bazel's).

## Configuration {:#configuration}

A `Configuration` event is sent for every [`configuration`](/extending/config)
used in the top-level targets in a build. At least one configuration event is
always be present. The `id` is reused by the `TargetConfigured` and
`TargetComplete` event IDs and is necessary to disambiguate those events in
multi-configuration builds.

```json
{
  "id": {
    "configuration": {
      "id": "a5d130b0966b4a9ca2d32725aa5baf40e215bcfc4d5cdcdc60f5cc5b4918903b"
    }
  },
  "configuration": {
    "mnemonic": "k8-fastbuild",
    "platformName": "k8",
    "cpu": "k8",
    "makeVariable": {
      "COMPILATION_MODE": "fastbuild",
      "TARGET_CPU": "k8",
      "GENDIR": "bazel-out/k8-fastbuild/bin",
      "BINDIR": "bazel-out/k8-fastbuild/bin"
    }
  }
}
```

## ConvenienceSymlinksIdentified {:#conveniencesymlinksidentified}

**Experimental.** If the `--experimental_convenience_symlinks_bep_event`
option is set, a single `ConvenienceSymlinksIdentified` event is produced by
`build` commands to indicate how symlinks in the workspace should be managed.
This enables building tools that invoke Bazel remotely then arrange the local
workspace as if Bazel had been run locally.

```json
{
  "id": {
    "convenienceSymlinksIdentified":{}
  },
  "convenienceSymlinksIdentified": {
    "convenienceSymlinks": [
      {
        "path": "bazel-bin",
        "action": "CREATE",
        "target": "execroot/google3/bazel-out/k8-fastbuild/bin"
      },
      {
        "path": "bazel-genfiles",
        "action": "CREATE",
        "target": "execroot/google3/bazel-out/k8-fastbuild/genfiles"
      },
      {
        "path": "bazel-out",
        "action": "CREATE",
        "target": "execroot/google3/bazel-out"
      }
    ]
  }
}
```

## Fetch {:#fetch}

Indicates that a Fetch operation occurred as a part of the command execution.
Unlike other events, if a cached fetch result is re-used, this event does not
appear in the BEP stream.

## NamedSetOfFiles {:#namedsetoffiles}

`NamedSetOfFiles` events report a structure matching a
[`depset`](/extending/depsets) of files produced during command evaluation.
Transitively included depsets are identified by `NamedSetOfFilesId`.

For more information on interpreting a stream's `NamedSetOfFiles` events, see the
[BEP examples page](/remote/bep-examples#consuming-namedsetoffiles).

## OptionsParsed {:#optionsparsed}

A single `OptionsParsed` event lists all options applied to the command,
separating startup options from command options. It also includes the
[InvocationPolicy](/reference/command-line-reference#flag--invocation_policy), if any.

```json
{
  "id": {
    "optionsParsed": {}
  },
  "optionsParsed": {
    "startupOptions": [
      "--max_idle_secs=10800",
      "--noshutdown_on_low_sys_mem",
      "--connect_timeout_secs=30",
      "--output_user_root=/tmp/.cache/bazel/_bazel_foo",
      "--output_base=/tmp/.cache/bazel/_bazel_foo/a61fd0fbee3f9d6c1e30d54b68655d35",
      "--deep_execroot",
      "--expand_configs_in_place",
      "--idle_server_tasks",
      "--write_command_log",
      "--nowatchfs",
      "--nofatal_event_bus_exceptions",
      "--nowindows_enable_symlinks",
      "--noclient_debug",
    ],
    "cmdLine": [
      "--enable_platform_specific_config",
      "--build_event_json_file=/tmp/bep.json"
    ],
    "explicitCmdLine": [
      "--build_event_json_file=/tmp/bep.json"
    ],
    "invocationPolicy": {}
  }
}
```

## PatternExpanded {:#patternexpanded}

`PatternExpanded` events indicate the set of all targets that match the patterns
supplied on the commandline. For successful commands, a single event is present
with all patterns in the `PatternExpandedId` and all targets in the
`PatternExpanded` event's *children*. If the pattern expands to any
`test_suite`s the set of test targets included by the `test_suite`. For each
pattern that fails to resolve, BEP contains an additional [`Aborted`](#aborted)
event with a `PatternExpandedId` identifying the pattern.

```json
{
  "id": {
    "pattern": {
      "pattern":["//base:all"]
    }
  },
  "children": [
    {"targetConfigured":{"label":"//base:foo"}},
    {"targetConfigured":{"label":"//base:foobar"}}
  ],
  "expanded": {
    "testSuiteExpansions": {
      "suiteLabel": "//base:suite",
      "testLabels": "//base:foo_test"
    }
  }
}
```

## Progress {:#progress}

Progress events contain the standard output and standard error produced by Bazel
during command execution. These events are also auto-generated as needed to
announce events that have not been announced by a logical "parent" event (in
particular, [NamedSetOfFiles](#namedsetoffiles).)

## TargetComplete {:#targetcomplete}

For each `(target, configuration, aspect)` combination that completes the
execution phase, a `TargetComplete` event is included in BEP. The event contains
the target's success/failure and the target's requested output groups.

```json
{
  "id": {
    "targetCompleted": {
      "label": "//examples/py:bep",
      "configuration": {
        "id": "a5d130b0966b4a9ca2d32725aa5baf40e215bcfc4d5cdcdc60f5cc5b4918903b"
      }
    }
  },
  "completed": {
    "success": true,
    "outputGroup": [
      {
        "name": "default",
        "fileSets": [
          {
            "id": "0"
          }
        ]
      }
    ]
  }
}
```

## TargetConfigured {:#targetconfigured}

For each Target that completes the analysis phase, a `TargetConfigured` event is
included in BEP. This is the authoritative source for a target's "rule kind"
attribute. The configuration(s) applied to the target appear in the announced
*children* of the event.

For example, building with the `--experimental_multi_cpu` options may produce
the following `TargetConfigured` event for a single target with two
configurations:

```json
{
  "id": {
    "targetConfigured": {
      "label": "//starlark_configurations/multi_arch_binary:foo"
    }
  },
  "children": [
    {
      "targetCompleted": {
        "label": "//starlark_configurations/multi_arch_binary:foo",
        "configuration": {
          "id": "c62b30c8ab7b9fc51a05848af9276529842a11a7655c71327ade26d7c894c818"
        }
      }
    },
    {
      "targetCompleted": {
        "label": "//starlark_configurations/multi_arch_binary:foo",
        "configuration": {
          "id": "eae0379b65abce68d54e0924c0ebcbf3d3df26c6e84ef7b2be51e8dc5b513c99"
        }
      }
    }
  ],
  "configured": {
    "targetKind": "foo_binary rule"
  }
}
```

## TargetSummary {:#targetsummary}

For each `(target, configuration)` pair that is executed, a `TargetSummary`
event is included with an aggregate success result encompassing the configured
target's execution and all aspects applied to that configured target.

## TestResult {:#testresult}

If testing is requested, a `TestResult` event is sent for each test attempt,
shard, and run per test. This allows BEP consumers to identify precisely which
test actions failed their tests and identify the test outputs (such as logs,
test.xml files) for each test action.

## TestSummary {:#testsummary}

If testing is requested, a `TestSummary` event is sent for each test `(target,
configuration)`, containing information necessary to interpret the test's
results. The number of attempts, shards and runs per test are included to enable
BEP consumers to differentiate artifacts across these dimensions.  The attempts
and runs per test are considered while producing the aggregate `TestStatus` to
differentiate `FLAKY` tests from `FAILED` tests.

## UnstructuredCommandLine {:#unstructuredcommandline}

Unlike [CommandLine](#commandline), this event carries the unparsed commandline
flags in string form as encountered by the build tool after expanding all
[`.bazelrc`](/run/bazelrc) files and
considering the `--config` flag.

The `UnstructuredCommandLine` event may be relied upon to precisely reproduce a
given command execution.

## WorkspaceConfig {:#workspaceconfig}

A single `WorkspaceConfig` event contains configuration information regarding the
workspace, such as the execution root.

## WorkspaceStatus {:#workspacestatus}

A single `WorkspaceStatus` event contains the result of the [workspace status
command](/docs/user-manual#workspace-status).
