Project: /_project.yaml
Book: /_book.yaml

# JavaScript and Bazel

{% include "_buttons.html" %}

This page contains resources that help you use Bazel with JavaScript projects.
It links to build rules and other information specific to building JavaScript
with Bazel.

The following resources will help you work with Bazel on JavaScript projects:

*  [NodeJS toolchain](https://github.com/bazelbuild/rules_nodejs){: .external}
*  [rules_js](https://github.com/aspect-build/rules_js){: .external} - Bazel rules for building JavaScript programs
*  [rules_esbuild](https://github.com/aspect-build/rules_esbuild){: .external} - Bazel rules for [esbuild](https://esbuild.github.io) JS bundler
*  [rules_terser](https://github.com/aspect-build/rules_terser){: .external} - Bazel rules for [Terser](https://terser.org) - a JavaScript minifier
*  [rules_swc](https://github.com/aspect-build/rules_swc){: .external} - Bazel rules for [swc](https://swc.rs)
*  [rules_ts](https://github.com/aspect-build/rules_ts){: .external} - Bazel rules for [TypeScript](http://typescriptlang.org)
*  [rules_webpack](https://github.com/aspect-build/rules_webpack){: .external} - Bazel rules for [Webpack](https://webpack.js.org)
*  [rules_rollup](https://github.com/aspect-build/rules_rollup){: .external} - Bazel rules for [Rollup](https://rollupjs.org) - a JavaScript bundler
*  [rules_jest](https://github.com/aspect-build/rules_jest){: .external} - Bazel rules to run tests using [Jest](https://jestjs.io)
*  [rules_jasmine](https://github.com/aspect-build/rules_jasmine){: .external} - Bazel rules to run tests using [Jasmine](https://jasmine.github.io/)
*  [rules_cypress](https://github.com/aspect-build/rules_cypress){: .external} - Bazel rules to run tests using [Cypress](https://cypress.io)
*  [rules_deno](https://github.com/aspect-build/rules_deno){: .external} - Bazel rules for [Deno](http://deno.land)
