## Release 7.1.2 (2024-05-08)

```
Baseline:  d798ebde6c6394203a87b5f1a6b62ecfc3880991

Release Notes:

+ Consider MODULE.bazel for workspace detection in bazel.sh (#20594)
+ Auto-create deploy jars for Bazel `java_test` targets if requested (#20602)
+ `java_binary` wrapper should forward `restricted_to` (#20611)
+ Mount user-specified bind mounts before Bazel's own magic. (#20609)
+ Fix bootstrapped Bazel binary (#20612)
+ Modify the error message that occurs when a requested target does not… (#20636)
+ Cherry-pick all presubmit.yml changes (#20736)
+ Accept labels of aliases in config_setting. (#20649)
+ Improve `use_repo_rule` error when not referencing a `repository_rule` (#20732)
+ Attempt to make main repo mapping inverse more efficient (#20633)
+ Retry binding to ipv6 localhost (#20755)
+ Print interactive sandboxed shell command with `--sandbox_debug` (#20769)
+ Fix two issues with --incompatible_sandbox_hermetic_tmp that manifested themselves when the output base was under /tmp (#20766)
+ Optimize prefetchInputs. (#20719)
+ Fix crash on `bazel mod` error containing `%` (#20651)
+ Cover missing cases during module extension label normalization (#20630)
+ Do not print errors when repository rules are interrupted (#20662)
+ Restart at most once when prepopulating repository rule environment (#20643)
+ Add profiles to the call sites of `updateRunfiles` (#20803)
+ Fixes for Bazel's own integration tests fail locally on Linux (#20822)
+ Remove unnecessary `cc_test` coverage handling (#20641)
+ Fix NPE in BzlmodRepoRuleFunction (#20829)
+ Return labels instead of strings from DescribableExecutionUnit methods. (#20788)
+ Introduce a SpawnLogContext interface. (#20842)
+ Fix `common` `.bazelrc` behavior for flag expansions (#20844)
+ Add a profiler span for fetching repositories. (#20852)
+ Make Bazel's RAM estimate container aware (#20644)
+ Auto-create deploy jars for Bazel `java_test` targets if requested (#20762)
+ Ignore read-only errors when updating the `mtime` of the `install_base` (#20648)
+ Add profiling to `remoteActionBuildingSemaphore.acquire()` (#20645)
+ DigestUtils: avoid throwing on invalid digest function name (#20650)
+ Use a larger buffer size for `java.util.zip.*Stream` classes (#20642)
+ Flip flag `--experimental_use_semaphore_for_jobs`. (#20646)
+ RemoteSpawnRunner: record inbetween phases in timing profile (#20647)
+ Add fastutil 7.2.1 dependency (#20854)
+ Allow repo rules to download multiple things in parallel. (#20856)
+ Add support for tmpfs mounts under `/tmp` with hermetic tmp (#20859)
+ Add new flag `--enable_workspace` that allows us to disable WORKSPACE… (#20855)
+ Add support for bind mounts under `/tmp` with hermetic tmp (#20772)
+ Document `--digest_function` startup flag (#20864)
+ Add flag `experimental_throttle_remote_action_building` (#20858)
+ Remove suffix from fastutil alias. (#20872)
+ Move StableSort into the exec package.
+ Test that missing spawn outputs are logged correctly.
+ Simplify computeDigest.
+ Add SpawnBuilder#with{Inputs,Tools} overloads accepting a NestedSet.
+ Correctly log paths for runfiles and filesets.
+ Report empty files in the spawn log.
+ Propagate the tool bit to logged directory inputs.
+ Move some more common logic into SpawnLogContext.
+ Introduce a new compact execution log format.
+ Apply zstd compression to the compact execution log.
+ Avoid unnecessary overhead when determining whether an action input is a directory.
+ Offer Shell completion for top-level packages without subpackages (#20879)
+ Increase maximal length of profile span for repository function calls (#20907)
+ Still generate a WORKSPACE file in repo rules if --enable_workspace is set (#20914)
+ Read authentication information from .netrc (#20915)
+ deps: rules_python 0.4.0 -> 0.22.0 (#20916)
+ Avoid emitting canonical labels into generated repos (#20917)
+ python: make incompatible_python_disallow_native_rules work for top-level external repo targets (#20923)
+ Remove flag guarding for the AndroidIdeInfo provider (#20932)
+ Point _virtual_includes to stable locations so IDE integrations survive builds (#20946)
+ [rfc] Allow repository rules to lazily declare environment variable deps (#20944)
+ Replaced usage of rev with awk in bash runfiles (#20934)
+ Cherry pick a few changes to address flaky tests (#20956)
+ Cherry-pick the change to reduce repository invalidations to Bazel 7.1 (#20949)
+ The label API shakeup & docs cleanup (#20977)
+ New docs for labels, repos, etc (#20978)
+ Add support for arbitrary headers to rctx.download[_and_extract] (#20979)
+ Show a warning message when the credential helper invocation fails (#20992)
+ Fix singlejar resource mapping for external repositories (#20989)
+ Remove user specific path from the lockfile (Fixes #19621) (#21009)
+ Also report cycles involving WORKSPACE from BzlmodRepoCycleReporter (#21013)
+ Fix -fatal_warnings on macOS (#21018)
+ Cherry-picks for module extension repo mapping usage tracking (#21033)
+ bzlmod: support git repos in source.json (#21036)
+ Add `bazel mod dump_repo_mapping` (#21023)
+ Cherry-picks for elimination of repo rule restarts (#21082)
+ Fix inconsistent dep graph stubs in Bzlmod tests (#21085)
+ Distinguish the disk and remote caches in the action progress status. (#21084)
+ Clarify where to find the definition of the --experimental_remote_scrubbing_config configuration format. (#21089)
+ Disable `--legacy_external_runfiles` in Bazel tests (#21086)
+ Follow directory symlink in RemoteActionFileSystem#getDirectoryEntries(). (#21088)
+ Treat the inability to load the Windows filesystem JNI as an error. (#21090)
+ Fix up permissions error in getInputStream, like we already do for getOutputStream. (#21087)
+ Force output checking for incremental run commands without the bytes. (#20988)
+ Remove visionos_x86_64 CPUs (#21022)
+ Close test.err before deleteing it (#21020)
+ Fix linker feature detection being performed on wrong linker (#20990)
+ Add an option to set a minimum size threshold for zstd blob compression. (#21124)
+ Publish RCs to GitHub (#21127)
+ Avoid using `InputStream.available()` to detect EOF while reading delimited protos. (#21143)
+ Starlark: reuse positional array in native calls where possible (#21144)
+ Harmonize BUILD files. (#21145)
+ Add bash completion for external targets (#21149)
+ Make some minor adjustments to the compact execution log format and document it better. (#21146)
+ Optimize the execution log sorter by using reference equality. (#21147)
+ Update to Turbine 0.4.0 (#21161)
+ Split StableSort into a separate target. (#21152)
+ Document that the compact execution log isn't guaranteed to be serialized in increasing ID order. (#21165)
+ Fix the comment for MessageOutputStream#write(). (#21166)
+ Make repo marker files sensitive to repo mapping changes (#21172)
+ Include the digest hash function in the compact execution log. (#21174)
+ Report unresolved symlinks as such in the execution log. (#21177)
+ Correctly handle unresolved symlinks when they appear in the inputs. (#21181)
+ Add missing close(). (#21183)
+ Add a profile span for building the upload manifest. (#21184)
+ Remove obsolete comments and dividers. (#21185)
+ Implement a new execution log conversion tool. (#21187)
+ Implement a new execution log conversion tool. (#21192)
+ Introduce a MessageInputStream abstraction, mirroring MessageOutputStream. (#21207)
+ Upgrade to use Bazel 7.0.2 (#21208)
+ Do not store the repository name in `RepoSpec` (#21209)
+ Make sure we build as well as test //src/tools/execlog/... on CI. (#21216)
+ Teach ExecLogConverter to read the compact format. (#21223)
+ Switch macOS minimum version flag to gcc compatible version (#21219)
+ Update default visionOS CPU to sim_arm64 (#21240)
+ Avoid exception-based control flow in RemoteActionFileSystem#stat. (#21236)
+ Cherry-pick: linker_param_file only added to command line if it starts with "@" (#21235)
+ Fixes for experimental extend rule and subrule functionality (#21237)
+ Fix NPE in ResourceManager when collecting local resource estimation in the profiler. (#21229)
+ Optimize RemoteActionFileSystem#readdir for the tree artifact input case. (#21251)
+ Document --incompatible_disallow_unsound_directory_outputs. (#21252)
+ Also path map transitive header jar paths with direct classpath optimization (#21227)
+ Error on invalid path characters in `.bazelignore` (#21259)
+ Mark gcc-<version> as `gcc` instead of `compiler` in Unix CC toolchain (#21224)
+ Avoid exception-based control flow in RAFS#getDigest and RAFS#getFastDigest. (#21264)
+ Add `add_exports/add_opens` to bazel java_binary deploy jars (#21270)
+ Manipulate the local filesystem directly in the writeLocalFile test helper. (#21272)
+ Improve the documentation for PathFragment methods dealing with segments. (#21275)
+ Canonicalize the parent path in RemoteActionFileSystem#delete. (#21282)
+ Revert "Also path map transitive header jar paths with direct classpath optimization" (#21281)
+ Make it possible to toggle cache key scrubbing by rule kind (#21276)
+ Fix a hanging issue with skymeld & `--combined_report=lcov`. (#21271)
+ Canonicalize the parent path in RemoteActionFileSystem#renameTo. (#21285)
+ Exclude `//src/test/py/bazel:mod_command_test` from RBE tests due to frequent flaky timeouts.
+ Add `bazel mod tidy` (#21265)
+ Don't use worker threads for repo fetching during Skyframe er… (#21305)
+ Fix flakiness in //src/test/shell/bazel:starlark_repository_test (#21309)
+ Document best practice of avoiding extensions directly specifying repository names (#21300)
+ Allow `@repo_name` labels in override attributes (#21313)
+ Reproducible extension (#21306)
+ Omit unique module versions from canonical repo names (#21316)
+ Add `Label.to_display_form()` (#21312)
+ Clarify the purpose and overall behavior of RemoteActionFileSystem. (#21294)
+ Make SpawnLogConvert an abstract class instead of an interface. (#21325)
+ Add support for additional command profiler event types. (#21327)
+ Remove the fileSize parameter from DigestUtils. (#21328)
+ Optimize RemoteActionFileSystem#resolveSymbolicLinks by caching intermediate results in a trie. (#21333)
+ Mark `use_repo_rule` extension as reproducible (#21335)
+ Make SpawnLogContext interruptible. (#21337)
+ Document --cache_computed_file_digests. (#21326)
+ Generate a lockfile for the distribution archive on the fly (#21338)
+ Introduce --local_resources flag (#21331)
+ Cherry-pick recent changes to fix CI flakiness and breakages (#21349)
+ Clear the file digests cache on clean. (#21346)
+ Parallelize TreeArtifactValue.visitTree across files instead of subdirectories. (#21347)
+ Temporarily hardcode rules_java repository name (#21356)
+ Remove unnecessary test assertions to fix flakiness. (#21354)
+ Make it possible to avoid an extra stat() when obtaining a digest from the cache. (#21353)
+ Collect directory contents in parallel in CompactSpawnLogContext. (#21361)
+ Introduce --default_test_resources flag (#21311)
+ python: rules_python 0.22.0 -> 0.22.1 soas to register Python toolchain by default (#21369)
+ Add vendor mode (#21366)
+ Clarify the behavior of --incompatible_remote_symlinks in the presence of a dangling symlink. (#21363)
+ Handle symlinks in a more consistent manner in UploadManifest. (#21371)
+ Set the executable bit on files in output directories uploaded to a disk or remote cache. (#21376)
+ Call out that TreeArtifactVisitor.visit is called in a nondeterministic order. (#21377)
+ Optimize out a stat call. (#21388)
+ Compute output directories in parallel when building the upload manifest. (#21386)
+ Fix rule definition environment for repo rules (#21397)
+ Share classpath `NestedSet` between full and header compile actions (#21389)
+ Emit labels in display form in Java rules (#21395)
+ Fetch refactor and mod command fix (#21385)
+ Implement `describeKey` for more actions (#21421)
+ Let scrubbed actions fall back to local execution when remote execution is enabled. (#21384)
+ Publish the new execution log format to the build event protocol. (#21417)
+ Ensure that the mtime of an AC entry is smaller, not larger, than the CAS blobs it references. (#21416)
+ Pass the name of the classpath manifest jar to JacocoCoverageRunner (#21413)
+ Traverse symlinks to directories while collecting a TreeArtifactValue. (#21418)
+ Correctly handle file inputs/outputs with directory contents in the execution log. (#21427)
+ Upgrade to async-profiler v3.0. (#21428)
+ Avoid a superfluous stat() in DigestUtil. (#21400)
+ [credentialhelper] Respect `expires` field from helper (#21429)
+ Improve performance of --reuse_sandbox_directories (#21433)
+ [credentialhelper] Update flag doc to point to more convenient usage instructions (#21441)
+ Repo file/dir watching API (#21435)
+ Clarify the meaning of Dirent.Type.UNKNOWN. (#21434)
+ Add a native image of turbine to the prebuilt Java tools (#21426)
+ Update java_tools v13.4 / rules_java 7.4.0 (#21359)
+ Automated rollback of commit b11fa7a7c7fdb37012c7a442b16f6fdcf90b9177. (#21448)
+ Remove the restriction that relative symlinks in a tree artifact may not point outside the tree. (#21449)
+ Revert "Add `Label.to_display_form()`" (#21454)
+ Do not record any repo mapping entries in the RepoMappingRecorder for WORKSPACE repo rules (#21457)
+ Reland "Also path map transitive header jar paths with direct classpath optimization" (#21458)
+ Backport CI test configs (#21456)
+ Use execution info instead of hard-coded mnemonics for Java path mapping (#21461)
+ Always decide whether to scrub an input by its effective path. (#21472)
+ Set RC branch when creating GitHub releases (#21477)
+ Fix vendor existing repo (#21487)
+ [test][windows] Export BAZEL_TEST=1 on windows (#21494)
+ Enable aar_import JNI libs to work with --android_platforms. (#21502)
+ Fix stale trash dir not cleaned up on worker creation (#21510)
+ Fix genrule autostamping in bazel (#21512)
+ Remove --host_jvm_args=-Djava.net.preferIPv6Addresses=true (#21546)
+ Passthrough HTTP headers to remote downloader service (#21503)
+ [credentialhelper] Support paths relative to `%install_base%` (#21532)
+ Update LibrariesToLinkCollector.java for .dll suffix stripping (#21524)
+ Backport changes for updating default lockfile used in integration tests. (#21547)
+ Fix a flaky test by avoiding leaking the eager capability RPC thread. (#21550)
+ Add a profiler span for the findMissingDigests call associated with an upload. (#21552)
+ Move the disk cache reads and writes into a thread pool. (#21551)
+ Lazily open files to be uploaded to an HTTP cache. (#21549)
+ Exclude convenience symlinks after changing the output base (#21505)
+ StarlarkBaseExternalContext.java: propagate error message when deleting temporary directory failed (#21555)
+ Fix `bazel fetch` by replacing query with cquery for underlying implementation (#21567)
+ Fix watching paths in undefined repos in repo rules (#21575)
+ Implicit dependencies should be visible to rule/aspect definitions in `.bzl` files in the same package (#21577)
+ Disable some tests because of JDK21 (#21595)
+ Expose the ApkInfo provider constructor to Starlark. (#21588)
+ Add multiplex sandboxing support to JavaBuilder (#21598)
+ Attempt to fix cancellation crash in repo fetching w/ worker thread (#21599)
+ Move compile StarlarkMethod back to CcModuleAPI (#21605)
+ Expose AndroidIdeInfo in android_common (#21607)
+ Release 7.1.0 (2024-03-11)
+ Update centos7 platform in build_bazel_binaries.yml (#21644)
+ Fix `bazel mod tidy` failure with no changes (#21662)
+ Update .bazelversion to 7.1.0 (#21664)
+ Let native Turbine image find `ct.sym` with non-hermetic `java_runtime` (#21670)
+ Actually use shouldPublish() to determine whether to publish the execution log to the BEP. (#21671)
+ Also inject a failure for createWritableDirectory when testing that ActionOutputDirectoryHelper propagates exceptions. (#21683)
+ Fix race condition and add more logging for null entry error message (#21692)
+ Allow any canonical repo name to be used with `bazel mod show_repo` (#21694)
+ Fix two `bazel mod tidy` crashes (#21700)
+ Cherry-pick Java execution info improvements (#21703)
+ Disable //src/test/shell/bazel:srcs_test on Intel macOS (#21707)
+ Fix sandbox cleanup crashing after server restart (#21733)
+ Revert "Fix `bazel fetch` by replacing query with cquery for … (#21735)
+ Release 7.1.1 (2024-03-21)
+ Implement RemoteActionFileSystem#statIfFound correctly when the path cannot be canonicalized (#21889)
+ Don't upload remote input to remote cache (#21941)
+ Do not watch `.netrc` in `read_netrc` (#22186)
+ Set public visibility for R8 desugar binary (#22176)

Acknowledgements:

This release contains contributions from many people at Google, as well as Alessandro Patti, Artem V. Navrotskiy, bazel.build machine account, Brentley Jones, Cameron Martin, Chi Wawng, Christian Scott, Cristin Donoso, David Ostrovsky, Ed Schouten, Fabian Meumertzheim, Gunnar Wagenknecht, Jordan Mele, Keith Smiley, lberki, Nikhil Kalige, oquenchil, Patrick Balestra, Rahul Butani, Ryan Beasley, Siddhartha Bagaria, Son Luong Ngoc, Sushain Cherivirala, thesayyn, Tianyu Geng, Viktor Kustov, Xdng Yng, Xùdōng Yáng, Yannic, Yannic Bonenberger.
```

## Release 7.0.0 (2023-12-11)

```
Baseline:  d60ce2c7c86393638c77698c00c2168a7a936a53

Release Notes:

+ **[Incompatible]** This has the side effect of changing the message on unsuccessful builds from ``` FAILED: Build did NOT complete successfully (0 packages loaded) ``` to ``` ERROR: Build did NOT complete successfully ```
+ The new path variable `$(rlocationpath ...)` and its plural form `$(rlocationpaths ...)` can be used to expand labels to the paths accepted by the `Rlocation` function of runfiles libraries. This is the preferred way to access data dependencies at runtime and works on all platforms, even when runfiles are not enabled (e.g., on Windows by default).
+ The `aquery` and `cquery` commands now respect the `--query_file` flag just like the `query` command.
+ **[Incompatible]** the --experimental_async_execution flag is now a no-op.
+ **[Incompatible]** --experimental_replay_action_out_err is not a no-op.
+ **[Incompatible]** `cquery --output=files` also outputs source files.
+ removed outdated ctx.host_fragments
+ **[Incompatible]** When multiple --deleted_packages options are passed on the command line, they will be concatenated instead of the latest one taking effect.
+ removed outdated ctx.host_configuration
+ **[Incompatible]** JSON profile: Use doubles instead of strings for counter series.
+ Now that the host configuration is finished, `genrule` should prefer the use of `tools` and stop using `exec_tools`.
+ **[Incompatible]** --experimental_build_transitive_python_runfiles is flipped to false. See #16303 for details
+ **[Incompatible]** --incompatible_python_disable_py2 is flipped to true. See #17293 for details.
+ Update Android manifest merger to v30.1.3, and also drop support for legacy (pre-D8) desugaring.
+ Correctly encode double value positive infinity as "inf" instead of "+inf" for textprotos.
+ **[Incompatible]** When remote cache evicts blobs, Bazel will exit with code 39.
+ Add --use_target_platform_for_tests which uses the target platform for executing tests instead of the execution platform.
+ **[Incompatible]** `--features` only applies to targets built in the target configuration, and `--host_features` is used for the host / exec configuration (gated behind `--incompatible_use_host_features`)
+ Custom C++ rules on Windows calling cc_common.create_linking_context_from_compilation_outputs should review whether each target of the rule type should produce a dynamic library since a condition which blocked their creation has been moved to the rules from behind the API.
+ Add flag `--experimental_remote_cache_ttl` and set the default value to 3 hours.
+ making --incompatible_use_platforms_repo_for_constraints do nothing. Using constraints from @bazel_tools//platforms with or without the flag will throw error with message "Constraints from @bazel_tools//platforms have been removed. Please use constraints from @platforms repository embedded in Bazel, or preferably declare dependency on https://github.com/bazelbuild/platforms"
+ **[Incompatible]** Bazel's local CPU resource on Linux is now container aware. Use `--local_cpu_resources`, `--loading_phase_threads` or `--jobs` to override.
+ Subsequent settings of --extra_execution_platforms now override previous settings, instead of adding them to a list. If you currently set --extra_execution_platforms more than once, please migrate by passing a list of values to --extra_execution_platforms instead so that earlier values aren't overwritten.
+ @bazel_tools//config:common_settings.bzl has been removed. Use @bazel_skylib//rules:common_settings.bzl instead.
+ **[Incompatible]** `copy_from_rule` is exec_groups is deprecated (https://github.com/bazelbuild/bazel/issues/17668).
+ cc_shared_library is no longer experimental, see https://github.com/bazelbuild/bazel/issues/16709 for details
+ **[Incompatible]** --legacy_bazel_java_test is now a no-op
+ The flag `--distinct_host_configuration` is removed. It has been a no-op since Bazel 6.0.0.
+ Add `--skip_incompatible_explicit_targets` option
+ **[Incompatible]** `--experimental_execution_graph_log` no longer exists. Current users that want local logs need to pass `--experimental_enable_execution_graph_log --experimental_execution_graph_log_path=/some/local/path`. Current users that want logs uploaded to BEP need to pass `--experimental_enable_execution_graph_log --experimental_stream_log_file_uploads`.
+ Remove 'darwin' as a CPU value, use 'darwin_x86_64' instead
+ **[Incompatible]** Remove 'darwin' as a CPU value, use 'darwin_x86_64' instead
+ cc_test can now be configured by using a native.toolchain().
+ The location of rules that explicitly specify `generator_name` and/or `generator_function` attributes (typically because they are incidentally copied from `native.existing_rule()`) is now the top-level call in the `BUILD` file, which is consistent with rules that do not explicitly specify these attributes.
+ Warnings (most notably those associated with the `deprecation` rule attribute) are no longer replayed on subsequent invocations unless the target in question is re-analyzed. Warnings are purely informational, so this change has no bearing on the correctness of the build. Downstream tests that break due to this change should update their expectations.
+ `--experimental_remote_build_event_upload` has been renamed to `--remote_build_event_upload`
+ **[Incompatible]** Remove high priority workers functionality from blaze.
+ [Breaking change] platform, constraint_setting, and constraint_value can no longer take an applicable_licenses value. Remediation is to remove the attribute and rely on the package level default.
+ `--experimental_action_cache_store_output_metadata` has been renamed to `--action_cache_store_output_metadata`
+ Changed the default value for `--remote_build_event_upload` to `minimal`.
+ `--experimental_remote_cache_compression` has been renamed to `--remote_cache_compression`
+ Added a new `max_compatibility_level` attribute to the `bazel_dep` directive, which allows version selection to upgrade a dependency up to the specified compatibility level.
+ `--experimental_remote_grpc_log` has been renamed to `--remote_grpc_log`
+ `--incompatible_remote_build_event_upload_respect_no_cache` is now a no-op.
+ json.decode now takes an optional `default` positional parameter; if this parameter is specified and decoding fails, json.decode will return the `default` value instead of failing Starlark evaluation.
+ --experimental_repository_disable_download is now promoted to stable and is also available under the name --repository_disable_download .
+ `applicable_licenses` is no longer allowed on the `platform` rule. Additionally, `default_package_metadata` from any `package` rule will not be applied.
+ **[Incompatible]** Duplicates in <rule-inputs> when using `query --output=xml --aspect_deps=precise` are removed. Added flag `--proto:include_attribute_source_aspects` that will include a new field `source_aspect_name` to the `Attribute` message that indicates the source aspect that the attribute comes from.
+ Options specified on the pseudo-command `common` in `.rc` files are now ignored by commands that do not support them as long as they are valid options for *any* Bazel command. Previously, commands that did not support all options given for `common` would fail to run. These previous semantics of `common` are now available via the new `always` pseudo-command.
+ **[Incompatible]** `--incompatible_check_sharding_support` is enabled by default. Sharded tests with test runners that do not properly advertise support for test sharding will fail. Refer to https://github.com/bazelbuild/bazel/issues/18339 for migration advice.
+ the 'default' param of json.decode can now be used as a keyword parameter.
+ As a transitional step in a larger refactoring, rule transitions are applied twice. Once during dependency resolution and once right before analysis of those rules. After the refactoring is complete, rule transitions will be applied only once.
+ Add aquery --output=streamed_proto which writes a stream of length delimited ActionGraphContainer containing a single Artifact, Action, Target, DepSetOfFiles, Configuration, AspectDescriptor, RuleClass, PathFragment proto. This breaks up the ActionGraphContainer into multiple which will prevent large protos from crashing blaze.
+ (BEP) TargetConfigured events will be marked aborted instead of published when there is an analysis error. This is motivated by a low level Blaze change aimed at improving scalability.
+ **[Incompatible]** cc_binary targets with dynamic_deps attributes no longer link indirect dynamic_deps on Unix. This might be an incompatible change if you are using RUNPATHs (instead of RPATHs) in your cc_shared_libraries. Enable the feature "exclude_bazel_rpaths_in_transitive_libs" or "use_rpath_instead_of_runpath" for those cc_shared_libraries.
+ Enable starlark_doc_extract - a native rule for Starlark documentation extraction. This rule is intended mainly for internal use by Stardoc.
+ **[Incompatible]** Remove deprecated and unused `--experimental_show_artifacts` flag.
+ Added the target path of an UnresolvedSymlink action to the aquery results
+ Additional source inputs can now be specified for compilation in cc_library targets using the additional_compiler_inputs attribute, and these inputs can be used in the $(location) function.
+ More descriptive error messages for unexpected cc absolute includes; unexpected absolute includes for cc compiles shouldn't be reported as "undeclared inclusion(s)"
+ Enable C++ branch coverage if gcov version is 8 or newer.
+ Deduplicates the result of split transitions uniformly, regardless of whether they are Starlark or native transitions. This used to apply only if either the attribute or rule transition contained a Starlark transition.
+ Support for optimizers rewriting baseline profiles.
+ This is a breaking change. `cc_host_toolchain_alias` rule is obsolete and can be interchangeably used with `cc_toolchain_alias` rule.
+ Fixes non-ascii arguments written to parameter files as mojibake.
+ NA
+ The `genrule` attribute `exec_tools` will be removed in a future Bazel release. Please follow directions at #19132 to migrate away from it.
+ **[Incompatible]** Removed multi_arch_split, use transition_support.apple_platform_split_transition from rules_apple instead.
+ Supports for android_binary.startup_profiles attribute.
+ **[Incompatible]** Removed apple_crosstool_transition, use transition_support.apple_rule_transition from rules_apple instead.
+ **[Incompatible]** Drop deprecated 'transitive_deps', 'transitive_runtime_deps' from JavaInfo
+ **[Incompatible]** The --android_include_proguard_location_references flag is not supported anymore.
+ **[Incompatible]** The --apple_compiler command line option is not available anymore.
+ `rule()` and `attr.*` can no longer be (pointlessly) called during WORKSPACE evaluation and repository rule evaluation.
+ Expands baseline profile wildcards before optimizer tools see them.
+ **[Incompatible]** --no_proguard_location_reference is now added unconditionally to the command line of aapt2.
+ **[Incompatible]** The command line flag --apple_enable_auto_dsym_dbg is not supported anymore.
+ **[Incompatible]** The --apple_compiler command line option is not available anymore.
+ **[Incompatible]** py_transitions top-level was removed.
+ Android resources will no longer propagate through neverlinked libraries by default.
+ Set Android Databinding to v2 and Databinging AndroidX to true and remove support for Databinding V1.
+ Added whether or not a FileWrite action's output is executable to the aquery results
+ --use_single_jar_apk_builder is removed. It's been a no-op for years.
+ **[Incompatible]** --incompatible_merge_fixed_and_default_shell_env is flipped to true. See #19317 for details.
+ JVM options in environment variables JAVA_TOOL_OPTIONS and JDK_JAVA_OPTIONS now do not get to the server; use --host_jvm_args instead.
+ --remote_download_minimal no longer implies --nobuild_runfile_links.
+ attr objects in Starlark now use value equality rather than reference equality.
+ **[Incompatible]** `cmd_helper` module was removed
+ **[Incompatible]** `ctx.new_file` was removed, `ctx.actions.declare_file` is to be used instead.
+ **[Incompatible]** Fails on unknown attributes (even when set to None). See https://github.com/bazelbuild/bazel/issues/19403
+ Change output paths to consistently start with [cpu]-[compilation_mode] along with other cleanups to output path generation logic.
+ Compilation actions using the auto-configured MSVC toolchain are forced to emit error messages in English if the English language pack for Visual Studio is installed.
+ **[Incompatible]** Flip incompatible_enable_cc_toolchain_resolution (https://github.com/bazelbuild/bazel/issues/7260)
+ The new `--consistent_labels` option on `query`, `cquery`, and `aquery` can be used to force consistent label formatting across all output modes that is also compatible with `str(Label(...))` in Starlark.
+ **[Incompatible]** proto_compiler attribute removed from proto_lang_toolchain (it was recently introduced, and there is no evidence of use)
+ **[Incompatible]** --experimental_genquery_use_graphless_query is made to be a NO-OP.
+ **[Incompatible]** The --call_count_output_path command line option is not supported anymore.
+ **[Incompatible]** The no-op --dynamic_worker_strategy command line option is no available anymore.
+ **[Incompatible]** the --experimental_allow_top_level_aspects_parameters, --experimental_async_execution, --experimental_availability_info_exempt, --experimental_dynamic_execution_cpu_limited, --experimental_dynamic_skip_first_build, --experimental_keep_config_nodes_on_analysis_discard, --experimental_local_memory_estimate, --experimental_multi_cpu, --experimental_multi_threaded_digest, --experimental_replay_action_out_err and --experimental_shortened_obj_file_path command line options are not available anymore.
+ **[Incompatible]** The --experimental_cc_shared_library_debug command line flag is not available anymore.
+ **[Incompatible]** testing.analysis_test is not experimental anymore
+ **[Incompatible]** The (no-op) --android_include_proguard_location_references flag is not available anymore.
+ **[Incompatible]** The --experimental_android_local_test_binary_resources command line option is not available anymore.
+ **[Incompatible]** The --experimental_includes_attribute_subpackage_traversal command line option is not available anymore.
+ **[Incompatible]** The --debug_print_action_contexts command line option is not available anymore.
+ **[Incompatible]** The --experimental_skyframe_include_scanning command line option is not available anymore.
+ **[Incompatible]** The --experimental_supports_info_crosstool_configuration command line option is not available anymore.
+ **[Incompatible]** THe --incompatible_avoid_conflict_dlls command line option is not available anymore.
+ **[Incompatible]** The --experimental_prioritize_local_actions command line option is not available anymore.
+ **[Incompatible]** The following command line options are not supported anymore: --incompatible_disable_cc_configuration_make_variables, --incompatible_disable_cc_toolchain_label_from_crosstool_proto, --incompatible_disable_crosstool_file, --incompatible_disable_depset_in_cc_user_flags, --incompatible_disable_legacy_cpp_toolchain_skylark_api, --incompatible_disable_legacy_cpp_toolchain_skylark_api, incompatible_disable_legacy_flags_cc_toolchain_api, --incompatible_disable_managed_directories, --incompatible_disable_runtimes_filegroups, --incompatible_disable_sysroot_from_configuration, --incompatible_disable_tools_defaults_package, --incompatible_disallow_legacy_javainfo, --incompatible_dont_emit_static_libgcc, --incompatible_enable_legacy_cpp_toolchain_skylark_api, --incompatible_linkopts_in_user_link_flags, --incompatible_provide_cc_toolchain_info_from_cc_toolchain_suite, --incompatible_require_feature_configuration_for_pic .
+ **[Incompatible]** The --experimental_execution_graph_log_cached and --experimental_execution_graph_log_missed command line options are not available anymore.
+ **[Incompatible]** The --experimental_use_sh_binary_stub_script command line option is not available anymore.
+ **[Incompatible]** The --incompatible_disable_expand_if_all_available_in_flag_set command line option is not available anymore.
+ default_applicable_licenses in package() now applies to the entire BUILD file, regardless of where in the BUILD that package() is called.
+ **[Incompatible]** The --incompatible_load_cc_rules_from_bzl command line option is not available anymore.
+ **[Incompatible]** The --incompatible_display_source_file_location command line option is not available anymore.
+ **[Incompatible]** The --experimental_repository_hash_file and --experimental_verify_repository_rules command line options are not available anymore.
+ **[Incompatible]** The following previously no-op command line options are not available anymore: --legacy_spawn_scheduler, --use_workers_with_dexbuilder, --print_workspace_in_output_paths_if_needed, --watchos_simulator_version, --watchos_simulator_device, --tvos_simulator_version, --tvos_simulator_device.
+ **[Incompatible]** The --show_warnings command line option of the command "canonicalize-flags" is not available anymore.
+ **[Incompatible]** The command line option --remove_all_convenience_symlinks is not available anymore.
+ **[Incompatible]** java_test doesn't produce deploy jars anymore
+ **[Incompatible]** The lazy template expansion is not experimental anymore (--experimental_lazy_template_expansion command line option is not available anymore).
+ **[Incompatible]** The --incompatible_disallow_legacy_javainfo command line option is not available anymore.
+ **[Incompatible]** The --incompatible_remove_cpu_and_compiler_attributes_from_cc_toolchain command line option is not available anymore. Using the "cpu" and "compiler" options of the cc_toolchain rule now results in a slightly different error that is signaled earlier.
+ **[Incompatible]** THe --incompatible_force_strict_header_check_from_starlark command line option is not available anymore.
+ **[Incompatible]** --incompatible_visibility_private_attributes_at_definition is flipped to true. See https://github.com/bazelbuild/bazel/issues/19330 for details.
+ **[Incompatible]** The --experimental_java_proto_library_default_has_services command line option and the Starlark symbol java_common.experimental_java_proto_library_default_has_services function are not available anymore.
+ **[Incompatible]** The no-op --experimental_cpp_compile_argv_ignore_param_file command line option is not available anymore.
+ Make variable expansion of `objc_library` produces better error messages.
+ **[Incompatible]** rule function takes only implementation function positionally, other parameters have to be named
+ **[Incompatible]** The --incompatible_genquery_use_graphless_query command line options is not available anymore.
+ Added support for a new directive `use_repo_rule` in MODULE.bazel files, which allows you to conveniently declare repos that are only visible within your module.
+ Bazel now throws an error if the root module specifies overrides on nonexistent modules.
+ Fix includes attribute of `objc_library` when sibling repository layout is used.
+ Directories used by sandboxed non-worker execution may be reused to avoid unnecessary setup costs. Disable behavior with --noreuse_sandbox_directories.
+ **[Incompatible]** The sandboxfs sandboxing strategy is removed. It hadn't been maintained for a long time, it didn't work for most users and it was not consistently faster while being complex to set up. sandboxfs performance is heavily dependent on the specific setup (setup costs are lower, but you have to pay a penalty for the use of each input) and there are scenarios where it is faster and scenarios where it is slower. Overall it is not worth its weight.
+ Symlink trees created by sandboxing will be deleted asynchronously. Disable behavior with --experimental_sandbox_async_tree_delete_idle_threads=0.
+ **[Incompatible]** Bzlmod is enabled by default, please consider migrating your external dependencies from WORKSPACE to MODULE.bazel. Find more details at https://github.com/bazelbuild/bazel/issues/18958
+ Enable Platforms and Toolchains for Android. Android projects will need to stop passing the legacy flag `--fat_apk_cpu`, and instead use `--android_platforms` using platforms defined with the `@platforms//os:android` constraint. The https://github.com/bazelbuild/rules_android repository defines four standard Android platforms for projects that use those rules, `@rules_android//:armeabi-v7a`, `@rules_android//:arm64-v8a`, `@rules_android//:x86`, `@rules_android//:x86_64`.
+ **[Incompatible]** Java runtime toolchains created via `local_java_repository` from `@bazel_tools//tools/jdk:local_java_repository.bzl`, which includes `local_jdk`, now have `target_compatible_with` set to the auto-detected host constraints. This can result in errors about toolchain resolution failures for `@bazel_tools//tools/jdk:runtime_toolchain_type`, especially when cross-compiling. These failures can be fixed in the following ways (listed in decreasing order of preference): * Replace `java_binary` targets that aren't meant to be run with `bazel run` or as tools during the build with `java_single_jar` (available in `@rules_java//java:java_single_jar.bzl`). Such targets do not require a Java runtime for the target configuration. * Set `--java_runtime_version=remotejdk_N` for some Java version `N` to let Bazel choose and download an appropriate remote JDK for the current target platform. This setting defaults to `local_jdk`, which means that Bazel can only use the local JDK, which isn't compatible with any other platform. * Manually define and register a `local_java_runtime` with no value set for `exec_compatible_with` (defaults to `[]`) and select it by setting `--java_runtime_version` to its `name`. This fully restores the previous behavior, but can result in incorrect results when cross-compiling (see #18265). Closes #18262. Commit https://github.com/bazelbuild/bazel/commit/f79ca0275e14d7c8fb478bd910ad7fb127440fd8
+ none Commit https://github.com/bazelbuild/bazel/commit/7d87996d2c2018f0c6dd9b200482320d0e40f024
+ None Commit https://github.com/bazelbuild/bazel/commit/0a1dce27650a233d8acb1f09a1181279f510cae8
+ **[Incompatible]** The attribute `new_local_repository.build_file` no longer accepts a path; a label must be passed instead. Closes #19992. Commit https://github.com/bazelbuild/bazel/commit/76d71d93c5baa233bd1dca3f2862eebe827a1eb4
+ **[Incompatible]** Delete the --experimental_execution_log_file flag. Use --execution_log_binary_file in conjunction with --noexecution_log_sort instead.
+ **[Incompatible]** transition is removed from objc_library (https://github.com/bazelbuild/bazel/issues/19688) (cherry picked from commit b4292d2ee1154c15d1f099b3e8941c3c448725ba) Co-authored-by: Googler <ilist@google.com>
+ **[Incompatible]** All labels in Bazel error messages, log output, Build Event Protocol, etc. are now prefixed with double-at (`@@`) instead of single-at (`@`) where applicable, to properly denote that they contain canonical repo names.
+ None. Commit https://github.com/bazelbuild/bazel/commit/491284b0c782e0df25dd0a8bc921a9c2de0e6881
+ **[Incompatible]** `--incompatible_sandbox_hermetic_tmp` is enabled by default. See #19915 for migration advice. Closes #19943. Commit https://github.com/bazelbuild/bazel/commit/e2c0276d1fd69c19d6946fb17f9e983e9ea68025
+ **[Incompatible]** The `--experimental_repository_cache_urls_as_default_canonical_id` flag is no longer available. Instead, the `http_archive`, `http_file`, `http_jar`, `jvm_maven_import_external`, and `jvm_import_external` repository rules now use the URLs as the canonical ID if none is provided explicitly. If this behavior is not desired, it can be disabled via `--repo_env=BAZEL_HTTP_RULES_URLS_AS_DEFAULT_CANONICAL_ID=0`. Fixes #19749 Closes #20047.
+ None Commit https://github.com/bazelbuild/bazel/commit/65f847a0103329f684e4313d49154583de15d164
+ None Commit https://github.com/bazelbuild/bazel/commit/9bbc2cbebf5c395c5504db7dfcfc5bda7e00bd3c
+ none Fixes #19920 Commit https://github.com/bazelbuild/bazel/commit/886b13fd00b5a17161d9558b6b11dd135355e5cb
+ **[Incompatible]** The `BAZEL_CURRENT_REPOSITORY` preprocessor variable, which holds the canonical name of the Bazel repository containing a `cc_*` target, is now only set during compilation if the target depends on the C/C++ runfiles library `@bazel_tools//tools/cpp/runfiles` via `deps` or `implementation_deps`. Fixes #20371 Closes #20388. Commit https://github.com/bazelbuild/bazel/commit/454b5506d82584616fcd707ed2e9bd1fe627c974
+ `--zip_undeclared_test_outputs` now preserves symlinks when zipping `$TEST_UNDECLARED_OUTPUTS_DIR`. Closes #19948. Change-Id: Ia4a8a9699e4e2f40498342af55babc5554a9ac93 Commit https://github.com/bazelbuild/bazel/commit/8e639dfa8c7aa0723123ee90dc933d528a4f2b68
+ **[Incompatible]** Toolchains and execution platforms are now registered in the following order with `--enable_bzlmod`: 1. root module's module file 2. `WORKSPACE` or `WORKSPACE.bzlmod` 3. non-root modules' module files 4. default toolchains registered by Bazel (does not apply with `WORKSPACE.bzlmod` or execution platforms) Fixes #20354 Closes #20407. Commit https://github.com/bazelbuild/bazel/commit/96b361205ee05dcacdcf5055ca9cc3e5ca5d126c#diff-a8d3aed419e661d4dbecb2dc6668444212d7b1707ff61330b7d8aae61e75d4df

Acknowledgements:

This release contains contributions from many people at Google, as well as Adam Lavin, Adrian Imboden, Alan Falloon, Alessandro Patti, Alex Eagle, Alexander Grund, AlexTereshenkov, Amanda L Martin, Amet Umerov, Andreas Herrmann, Andy Hamon, andyrinne12, Ankit Agarwal, Ankush Goyal, Anshuman Mishra, Anthony Ter-Saakov, Antoine Musso, Artem Zinnatullin, arun.sampathkumar, aryeh, Austin Schuh, bazel.build machine account, Ben Lee, Benjamin Lee, Benjamin Peterson, Benjamin Sigonneau, Boleyn Su, Brentley Jones, Cameron Martin, Chirag Ramani, Chris Sauer, Christopher Peterson Sauer, Christopher Rydell, Christopher Sauer, Conall O'Brien, Daniel Grunwald, Daniel KT, Daniel Wagner-Hall, David Ostrovsky, dhmemi, Dimi Shahbaz, eareilg, Ed Schouten, Emil Kattainen, Ezekiel Warren, Fabian Meumertzheim, Fahrzin Hemmati, Gaspare Vitta, George Gensure, Greg, Greg Magolan, Grzegorz Lukasik, Guillaume Maudoux, Gunnar Wagenknecht, Halil Sener, Hao Yuan, hvadehra, hvd, Ilan Keshet, Ivan Golub, Jack Dai, James Ma, Jason Mobarak, Jasper, Jay Conrod, Jeff Hodges, Jeremy Volkman, Jimm chja20, Joel Jeske, John Hinnegan, Jon Landis, Jon Parise, jonrose-dev, Joseph Lisee, Joseph Tilahun, Julio Merino, Kai Zhang, keertk, Keith Smiley, Konstantin Erman, Krzysztof Naglik, kshyanashree, Kun-Lu, Laurenz Altenmller, Lee Mracek, Letu Ren, lripoche, Maksim, Malte Poll, Marc Redemske, Marc Zych, Matt Mackay, Matt Vollmer, Mauricio G, Mauricio Galindo, Maxim Matyunin, Maxwell Elliott, mohamadk, Nathan (Blaise) Bruer, nathyong, NelsonLi0701, nglevin, Nicholas Junge, Nick Biryulin, Nick Korostelev, Oliver Lee, Orion Hodson, Oscar Garzon, Patrice Duroux, Patrick Balestra, Peter Lobsinger, Philipp Schrader, Rasrack, Red Daly, redwrasse, Robin Tweedie, robincaloudis, Roger Hu, Romain Chossart, Roman Salvador, Sagar Pathare, Saleem Abdulrasool, Sam Shadwell, Sara Adams, Sascha Moecker, Scott Minor, Severin Strobl, Shaygan Hooshyari, Siddhesh Bhupendra Kuakde, Simon Mavi Stewart, something_vague, Son Luong Ngoc, Steve Barrau, Stiopa Koltsov, stoozy, Sushain Cherivirala, Takeo Sawada, Taylor Barrella, tbaing, Ted Kaplan, Ted Logan, Thi Don, Thulio Ferraz Assis, Timothy Gu, Tom Cnops, Tyler Williams, Ulf Adams, Ulrik Falklof, Uri Baghin, Vertexwahn, Xavier Bonaventura, Xdng Yng, Xiangquan Xiao, Xùdōng Yáng, Yannic, Yannic Bonenberger, Yi Cheng, Yuval Kaplan, yuzhy8701, Zheng Wei Tan.
```

## Release 8.0.0-pre.20231030.2 (2023-11-14)

```
Baseline: 8cab6aa21fa765985a962e59264e12251e4d479f

Cherry picks:

   + d78bdd2f7143da31087c3ab88298b52defb90fdc:
     Temporarily disable `BaselineOptionsFunction` + Starlark exec
     transition.
```

Incompatible changes:

  - Java runtime toolchains created via `local_java_repository` from
    `@bazel_tools//tools/jdk:local_java_repository.bzl`, which
    includes `local_jdk`, now have `target_compatible_with` set to
    the auto-detected host constraints. This can result in errors
    about toolchain resolution failures for
    `@bazel_tools//tools/jdk:runtime_toolchain_type`, especially when
    cross-compiling. These failures can be fixed in the following
    ways (listed in decreasing order of preference):
    * Replace `java_binary` targets that aren't meant to be run with
    `bazel run` or as tools during the build with `java_single_jar`
    (available in `@rules_java//java:java_single_jar.bzl`). Such
    targets do not require a Java runtime for the target
    configuration.
    * Set `--java_runtime_version=remotejdk_N` for some Java version
    `N` to let Bazel choose and download an appropriate remote JDK
    for the current target platform. This setting defaults to
    `local_jdk`, which means that Bazel can only use the local JDK,
    which isn't compatible with any other platform.
    * Manually define and register a `local_java_runtime` with no
    value set for `exec_compatible_with` (defaults to `[]`) and
    select it by setting `--java_runtime_version` to its `name`. This
    fully restores the previous behavior, but can result in incorrect
    results when cross-compiling (see #18265).
  - transition is removed from objc_library
    (https://github.com/bazelbuild/bazel/issues/19688)

New features:

  - "bazel aquery" now returns the headers C++ compilation actions
    can include if the --include_scheduling_dependencies command line
    option is set.

Important changes:

  - Enable Platforms and Toolchains for Android. Android projects
    will need to stop passing the legacy flag `--fat_apk_cpu`, and
    instead use `--android_platforms` using platforms defined with
    the `@platforms//os:android` constraint. The
    https://github.com/bazelbuild/rules_android repository defines
    four standard Android platforms for projects that use those
    rules, `@rules_android//:armeabi-v7a`,
    `@rules_android//:arm64-v8a`, `@rules_android//:x86`,
    `@rules_android//:x86_64`.

This release contains contributions from many people at Google, as well as Benjamin Peterson, Fabian Meumertzheim, Fredrik Medley, Guillaume Maudoux, Ulf Adams, Wade Carpenter.

## Release 7.0.0-pre.20231018.3 (2023-11-07)

```
Baseline: eeb9c911bf16271f807c687e8eae246edaecd005

Cherry picks:

   + bb7fb2d32f055f2a70a5ab394cf5aef29bc74b2e:
     Automatically add function transition allow list when needed
   + c59739e72a2b4ee50f4ba205fb1561f10f0b344d:
     Automated rollback of commit
     f7946d0107dd75b2f45bcc79b91c016d075a756d.
   + f6eabdc51eb54416361be4b3528d67717a11fdfd:
     Automated rollback of commit
     774fdb4be128b642332531f1d0376810b4c5377f.
```

Incompatible changes:

  - The sandboxfs sandboxing strategy is removed. It hadn't been
    maintained for a long time, it didn't work for most users and it
    was not consistently faster while being complex to set up.
    sandboxfs performance is heavily dependent on the specific setup
    (setup costs are lower, but you have to pay a penalty for the use
    of each input) and there are scenarios where it is faster and
    scenarios where it is slower. Overall it is not worth its weight.
  - Bzlmod is enabled by default, please consider migrating your
    external dependencies from WORKSPACE to MODULE.bazel. Find more
    details at https://github.com/bazelbuild/bazel/issues/18958

Important changes:

  - Directories used by sandboxed non-worker execution may be reused
    to
    avoid unnecessary setup costs. Disable behavior with
    --noreuse_sandbox_directories.
  - Symlink trees created by sandboxing will be deleted
    asynchronously.
    Disable behavior with
    --experimental_sandbox_async_tree_delete_idle_threads=0.

This release contains contributions from many people at Google, as well as Antoine Musso, Benjamin Peterson, Fabian Meumertzheim, Nick Biryulin, Steve Barrau, Thi Don.

## Release 7.0.0-pre.20231011.2 (2023-10-23)

```
Baseline: e66a10f473ed853393061633e3803a8f71e47bff
```

Initial release.

## Release 6.4.0 (2023-10-19)

```
Baseline:  0f231ac8acabcd8aa309da041c98ab90a1552418

Release Notes:

+ Support multiple remote execution digest functions (#19042)
+ Release 6.4.0 remote (#18959)
+ Move BazelFileSystemModule into bazel package (#19043)
+ Fix a bug where frozen targets list was mutated while expanding env attribute (#19053)
+ Mark isolated extension usages as experimental (#19065)
+ Add the remote_require_cached flag (#19075)
+ Advertise CcInfo from cc_import (#19086) (#19088)
+ Update java_tools version to 12.6 (#19092)
+ Set the digest_function field as part of all relevant gRPC requests (#19049)
+ Merge `use_repo` buildifier fixups into a single command (#19134)
+ Ensure that extension unique names followed by `~` are prefix-free (#19164)
+ Lockfile updates & fixes (#19153)
+ Switch xcode_autoconf to use 'configure = True' (#19174)
+ Cherry pick Add a Starlark flag that allows disabling proguard. This will be useful for testing later. (#19179)
+ Update CODEOWNERS for 6.4.0 (#19194)
+ Friendlier error message for `bazel_dep`s without `version` (#19196)
+ Always check `$config_dependencies` visibility at use (#19197)
+ Add support for the BLAKE3 digest function (#19191)
+ Enable cc toolchain resolution when cross compiling to windows arm64. (#19198)
+ Ensure disk cache root exists (#19225)
+ Fix valid json when using jsonproto output in queries  with new `--ouput=streamed_jsonproto` implementation. (#19226)
+ Add toolchain type for Java bootstrap runtime (#19220)
+ Add Starlark implementation for several CcCommon methods. (#19076)
+ Rename `cc_test_wrapper` to `cc_test` (#19231)
+ Cherry-pick commits to fix a Windows issue (#19232)
+ Add support for more workspace boundary files to bash completion (#19281)
+ Use `debugPrint` instead of `str` for `fail` arguments (#19283)
+ Include name in `repr` of exported `rule`s (#19229)
+ Download `BazelRegistryJson` only once per registry (#19300)
+ Make module extension tag's `debugPrint` useful for error messages (#19285)
+ Intern repository mapping entries (#19293)
+ Add `additional_linker_inputs` option to `cc_library` rule (#19264)
+ Do not rerun module extensions when only imports or locations change (#19284)
+ Add profiling for Bzlmod operations (#19313)
+ Retry on javax.net.ssl.SSLException ... BAD_DECRYPT (#19346)
+ Fetch `RepoSpecs` in parallel (#19354)
+ Make `MODULE.bazel.lock` deterministic (#19370)
+ Ensure lockfile is updated after reset to pre-build state (#19371)
+ build-runfiles: remove temporary file prior to creating it (#19386)
+ Always fail on unknown attributes (#19404)
+ Ignore Starlark options on commands with `allowResidue = False` (#19417)
+ Separate PackageSpecificationProvider from its target (PackageGroupConfiguredTarget) (#19420)
+ Expose PackageSpecificationInfo provider as a top level symbol (#19422)
+ Revert "Report remote execution messages as events" (#19415)
+ [6.4] Add --incompatible_disable_objc_library_transition (#19393)
+ Create .bazelversion to address postsubmit timeout issues (#19435)
+ Add `contains` method inside `PackageSpecificationProvider`  (#19425)
+ Wrong include path to Clang 16 on Windows (#19430)
+ Simplify release notes by just printing the first line of the commit … (#19448)
+ Remove PackageGroupConfiguredTarget.isAvailableFor function (#19444)
+ Remove default -s flag from macOS libtool invocation (#19454)
+ Turn off lockfile feature by default (#19462)
+ Take the no-remote-exec tag into account when computing the action salt (#19457)
+ Add `--incompatible_merge_fixed_and_default_shell_env` (#19319)
+ Improve error when a label is provided in `config_setting`'s `values` (#19484)
+ Mark tool inputs in the execution log. (#19483)
+ Add visionOS support (#19436)
+ Intern empty `Depset`s (#19443)
+ Do not allow applicable_licenses on platform. (#19426)
+ Cherry pick Bzlmod fixes (#19494)
+ Optimize classpath pre-processing in java_stub_template.txt (#19491)
+ Add output name to CacheNotFoundException (#19452)
+ feat: add option to exit early if analysis cache is discarded (#19503)
+ Cherry pick platform dependent lockfile (#19498)
+ Print Passed and Failed methods in detailed test summary (#19505)
+ Add formatted timestamp entries to volatile workspace status file. (#19499)
+ Write an explicit line ending to the lockfile (#19519)
+ Only use `/showIncludes` if supported (#19521)
+ Also apply `NestedSet` optimizations to `Depset` (#19492)
+ Add diff_against_dynamic_baseline option to experimental_output_direc… (#19514)
+ Update java_tools to v12.7 (#19522)
+ Advertise CcInfo from cc_proto_library (#19534)
+ Update unknown Xcode version error message and provide an environment variable to force re-evaluation (#19540)
+ Print dep chain leading to a module that is in error (#19543)
+ Show fetch progress for the `mod` command (#19542)
+ Revert "Switch xcode_autoconf to use 'configure = True' (#19174)" (#19550)
+ Explain the use of `str(Label(...))` in the docs (#19554)
+ Add `--consistent_labels` flag to all query commands (#19567)
+ Inject builtin modules at the end of the MODULE.bazel file (#19573)
+ Disable bzlmod_query_test for RBE build (#19585)
+ Clear runfiles environment variables for `bazel run` (#19606)
+ cc_library: propagate data dependencies via implementation_deps. (#19590)
+ Error on potential unsupported `/showIncludes` lines (#19611)
+ Use case-insensitive comparison for Windows paths in `runfiles.bash`  (#19626)
+ Show test labels in summaries in display form (#19625)
+ Remove stale extension entries from lockfile (#19683)
+ Keep leading zero in formatted date (#19694)
+ Bzlmod lockfile: fix pretty printing for attributes  (#19691)
+ MODULE.bazel.lock file contains user specific paths (#19698)
+ Consider RCs equivalent to release for `bazel_compatibility` (#19689)
+ Use `Label` in `@bazel_tools//tools/jdk` macros (#19675)
+ Remove stale extension entries from lockfile if module order changes (#19730)
+ Update rules_java 5.5.1 (#19701)
+ Fix Java compilation for jdk21 (#19735)
+ Fix output materialized as symlink when building without the bytes. (#19739)
+ Make lockfile's `RepoSpec` attributes more readable (#19748)
+ Merge rule and aspect validation output groups (#19745)
+ Fix handling of non-ASCII characters in archive entry file names (#19765)
+ Raise an early error on invalid labels in transitions inputs/outputs (#19764)
+ Handle synthetic method parameters entries that don't have names (#19758)
+ Bazel release process: Fix push justification. (#19768)
+ Flip --experimental_cc_implementation_deps (#19751)
+ Add blake3 NEON instructions on linux arm64 (#19804)
+ Fix crash when `environ` contains duplicate entries (#19827)
+ Bump c++ standard to c++14 per default (#19794)
+ Collect debug info context from implementation deps (#19836)
+ Fix unconditional Skyframe invalidation with --lockfile_mode=… (#19848)

Acknowledgements:

This release contains contributions from many people at Google, as well as Andreas Herrmann, bazel.build machine account, Brentley Jones, buildbreaker2021, Chirag Ramani, David Ostrovsky, Ed Schouten, Fabian Meumertzheim, George Gensure, Greg, John Laxson, Julio Merino, Keith Smiley, Matt Mackay, Mauricio G, NelsonLi0701, nglevin, Nicholas Junge, oquenchil, Orion Hodson, Roman Salvador, Ted Kaplan, Thi Doan, Thi Don, Tyler Williams, Xùdōng Yáng.
```

## Release 7.0.0-pre.20230926.1 (2023-10-06)

```
Baseline: ea4ab7d8e696f48253fd172fcfbd37661e4710d5

Cherry picks:

   + 3453d035bb335a0e792fb379807dbdb812065619:
     Keep leading zero in formatted date
   + 8893f2ee0efbdeb0816b13e7cb57c69d70b941c6:
     Bazel release process: Fix broken "git push" by setting direct
     push justification.
   + 3f8e0964f4525cee71f8b7051e6996a906dd78d0:
     Bazel release process: Fix push justification. (#19754)
   + 95296e81853a4c93a47fba1812e1f849b6b16480:
     Release 7.0.0-pre.20230926.1 (2023-10-06)
   + fbcc487642c567a63f6503670d6d4f46f98308c1:
     Release 7.0.0-pre.20230926.1 (2023-10-06)
   + 3f9dc1c789e4bb2523fcd5236f53db8b3edb4733:
     Release 7.0.0-pre.20230926.1 (2023-10-06)
   + f46bf7067991fea6c650cb1fb75d1f7844916ff0:
     Release 7.0.0-pre.20230926.1 (2023-10-06)
```

This release contains contributions from many people at Google, as well as .

## Release 7.0.0-pre.20230926.1 (2023-10-06)

```
Baseline: ea4ab7d8e696f48253fd172fcfbd37661e4710d5

Cherry picks:

   + 3453d035bb335a0e792fb379807dbdb812065619:
     Keep leading zero in formatted date
   + 5b7da83d94d94204d1d95cbe3ed361ec742f8acb:
     Bazel release process: Fix broken "git push" by setting direct
     push j… (#19747)
   + 2bf83ab8e58b96df994e59ffbe93d6d28a0f7897:
     Release 7.0.0-pre.20230926.1 (2023-10-06)
   + 0cc1b4e0aa2d3937bd47ca8d7506f4ca88453a26:
     Release 7.0.0-pre.20230926.1 (2023-10-06)
```

This release contains contributions from many people at Google, as well as .

## Release 7.0.0-pre.20230926.1 (2023-10-05)

```
Baseline: ea4ab7d8e696f48253fd172fcfbd37661e4710d5

Cherry picks:

   + 3453d035bb335a0e792fb379807dbdb812065619:
     Keep leading zero in formatted date
   + b63af1ec3c09d50e7b96dd496874c98ca2907209:
     Release 7.0.0-pre.20230926.1 (2023-10-05)
   + dc23c2fbc5ae5ef14d59afbedd3e0d29d2ee3d6b:
     Release 7.0.0-pre.20230926.1 (2023-10-05)
```

Incompatible changes:

  - proto_compiler attribute removed from proto_lang_toolchain
    (it was recently introduced, and there is no evidence of use)
  - --experimental_genquery_use_graphless_query is made to be a NO-OP.

Important changes:

  - The new `--consistent_labels` option on `query`, `cquery`, and
    `aquery` can be used to force consistent label formatting across
    all output modes that is also compatible with `str(Label(...))`
    in Starlark.

This release contains contributions from many people at Google, as well as Alexander Grund, Fabian Meumertzheim, Joseph Lisee, Patrick Balestra, Son Luong Ngoc, Zheng Wei Tan.

## Release  (2023-10-05)

```
Error: Not a release branch.
```

## Release  (2023-10-05)

```
Error: Not a release branch.
```

## Release 7.0.0-pre.20230917.3 (2023-09-22)

```
Baseline: 1cf392ff3918386858b8c038f82c013b1e04be98

Cherry picks:

   + 32563ca1728a69437b26efa19d18eebfcecc4765:
     [Skymeld] Avoid printing extra WARNINGS for execution failures
     in -k.
   + 19f5e933d3fc91848b2b786cb11a6decaa96cf6e:
     Automated rollback of commit
     f06418470988721c8c3efe38723f910989180ad4.
```

Incompatible changes:

  - `cmd_helper` module was removed
  - `ctx.new_file` was removed, `ctx.actions.declare_file` is to be
    used instead.
  - Fails on unknown attributes (even when set to None). See
    https://github.com/bazelbuild/bazel/issues/19403
  - Flip incompatible_enable_cc_toolchain_resolution
    (https://github.com/bazelbuild/bazel/issues/7260)

Important changes:

  - Change output paths to consistently start with
    [cpu]-[compilation_mode] along with other cleanups to output path
    generation logic.
  - Compilation actions using the auto-configured MSVC toolchain are
    forced to emit error messages in English if the English language
    pack for Visual Studio is installed.

This release contains contributions from many people at Google, as well as Benjamin Peterson, Boleyn Su, Brentley Jones, Daniel Wagner-Hall, Fabian Meumertzheim, Keith Smiley, Roman Salvador, Timothy Gu.

## Release 7.0.0-pre.20230906.2 (2023-09-14)

```
Baseline: 08070932379cd3dafaefe5b546c84ad26cd72951

Cherry picks:

   + 4fb701adb5cdf4a87d7457bfe75b76338a8d351a:
     fix forward for
     https://github.com/bazelbuild/bazel/commit/ceddfb1ece1f8ed7ff8155
     8fa1751e6526df031b. Make sure the use the appropriate check for
     alias + feature flag so trimming does not get applied
```

Incompatible changes:

  - --incompatible_merge_fixed_and_default_shell_env is flipped to
    true. See #19317 for details.
  - Fails on unknown attributes (even when set to None)

Important changes:

  - Set Android Databinding to v2 and Databinging AndroidX to true
    and remove support for Databinding V1.
  - Added whether or not a FileWrite action's output is executable to
    the aquery results
  - --use_single_jar_apk_builder is removed. It's been a no-op for
    years.
  - JVM options in environment variables JAVA_TOOL_OPTIONS and
    JDK_JAVA_OPTIONS now do not get to the server; use
    --host_jvm_args instead.
  - --remote_download_minimal no longer implies
    --nobuild_runfile_links.
  - attr objects in Starlark now use value equality rather than
    reference
    equality.

This release contains contributions from many people at Google, as well as Benjamin Lee, Benjamin Peterson, Ed Schouten, Fabian Meumertzheim, Keith Smiley, Letu Ren, Mauricio Galindo, Mauricio G, Orion Hodson, Shaygan Hooshyari.

## Release 7.0.0-pre.20230823.4 (2023-08-30)

```
Baseline: d55c11b658255a4574e0b3eb50d76dd6123866e6

Cherry picks:

   + 34c5ef22e88eba60238ad3735b74ea71db1c993e:
     make sure IdempotencyChecker use the correct rule transition and
     remove redundant computeTransition calls.
   + 32d018ea402a5acbb574b7f4bf600b3cc040778c:
     Make targets in analysis completed events visible.
```

Incompatible changes:

  - The --apple_compiler command line option is not available anymore.
  - py_transitions top-level was removed.

Important changes:

  - Android resources will no longer propagate through neverlinked
    libraries by default.

This release contains contributions from many people at Google, as well as Alex Eagle, arun.sampathkumar, Benjamin Lee, Fabian Meumertzheim, Gunnar Wagenknecht, Julio Merino, Keith Smiley, Nicholas Junge.

## Release 7.0.0-pre.20230816.3 (2023-08-25)

```
Baseline: 27aaccccb674090493d52d3340b7df69f5ed43f8

Cherry picks:

   + baace69c0c7cb2fe927214dae78c43bd10865c43:
     Automated rollback of commit
     37268de708224bba900036b8b3fe9e123d2eae6d.
```

Incompatible changes:

  - The --android_include_proguard_location_references flag is not
    supported anymore.
  - The --apple_compiler command line option is not available anymore.
  - --no_proguard_location_reference is now added unconditionally to
    the command line of aapt2.
  - The command line flag --apple_enable_auto_dsym_dbg is not
    supported anymore.

Important changes:

  - `rule()` and `attr.*` can no longer be (pointlessly) called
    during WORKSPACE evaluation and repository rule evaluation.
  - Expands baseline profile wildcards before optimizer tools see
    them.

This release contains contributions from many people at Google, as well as Chirag Ramani, Fabian Meumertzheim, Keith Smiley, nglevin, Tyler Williams.

## Release 7.0.0-pre.20230810.1 (2023-08-22)

```
Baseline: c279c7b2f125fcb5a7e67595c0044c32fe944aa9

Cherry picks:

   + 4d157ee3530762c9392ccc08a0073103293a6391:
     Cherry-pick required commits into 7.0.0-pre.20230810.1rc1
     (#19298)
```

Initial release.

## Release 6.3.2 (2023-08-08)

```
Baseline:  283ed362e6ccceb047553c2517a0331afd02db90

Release Notes:

+ Ensure that extension unique names followed by `~` are prefix-free (#19167)
+ Lockfile updates & fixes (#19153) (#19175)
+ Empty commit to try to fix CI issue (#19177)

Acknowledgements:

This release contains contributions from many people at Google, as well as bazel.build machine account, Fabian Meumertzheim.
```

## Release 7.0.0-pre.20230724.1 (2023-08-07)

```
Baseline: f6344ffcacdea6c4a61e112d0f60beda8068eac5
```

Initial release.

## Release 6.3.1 (2023-07-31)

```
Baseline:  0f231ac8acabcd8aa309da041c98ab90a1552418

Release Notes:

+ Mark isolated extension usages as experimental (#19050)
+ Fix a bug where frozen targets list was mutated while expanding env attribute (#19052)
+ Add documentation for --experimental_isolated_extension_usage (#19071)
+ Advertise CcInfo from cc_import (#19086)
+ Create .bazelversion to address postsubmit issues (#19089)
+ Update java_tools version to 12.6 (#19091)
+ Disable lockfiles by default (#19106)

Acknowledgements:

This release contains contributions from many people at Google, as well as Brentley Jones, Fabian Meumertzheim, oquenchil, Xùdōng Yáng.
```

## Release 7.0.0-pre.20230710.5 (2023-07-28)

```
Baseline: 7845acae9769a72dc507dc2f57c4e032ebf429d3

Cherry picks:

   + d9e2f9181f8fa283e3986ee3b261e610c41cf61b:
     Avoid overcounting in ActionLookupValueProgressReceiver.
   + da23370dcdf6ea19545002fb86bd5d3e6519cdf6:
     Fix crash for top level aspects on targets with non-idempotent
     rule transitions.
   + 4714cd70c83de43ba7ab10c29e63af716216770a:
     Reuse the built set of tools in `SpawnAction.Builder`.
   + 0a1d50533078283fab93024681c917303a91c46c:
     Correctly handle symlinks when prefetching.
```

Initial release.

## Release 6.3.0 (2023-07-24)

```
Baseline:  758b44dab552f31b378874b5bf4c0609bfef6f5d

Release Notes:

+ Automatic code cleanup. (#18417)
+ Update CODEOWNERS for 6.3.0 (#18369)
+ Overrides specified by non-root modules no longer cause an error, and are silently ignored instead. They were originally treated as an error to allow for the future possibility of overrides in the transitive dependency graph working together; but we've deemed that infeasible (and even if it was, it'd be so complicated and confusing to users that it would not be a good addition). (#18388)
+ Add implementation deps support for Objective-C (#18372)
+ Update release notes scripts (#18400)
+ Prevent CredentialHelperEnvironment crash when invoking Bazel outside of a workspace. (#18430)
+ Use wall-time for credential helper invalidation (#18413)
+ blaze_util_posix: handle killpg failures (#18403)
+ Pass version to java_runtimes created by local_java_repository (#18415)
+ Add jsonproto option to query --output flag (#18438)
+ Don't eagerly flatten a `NestedSet` in `RepoMappingManifestAction` (#18419)
+ rules_go & rules_python are failing in Downstream CI with Bazel@HEAD (#18447)
+ Move credential helper setup into remote_helpers.sh so it can be reused by other shell tests. (#18453)
+ Wire credential helper to repository fetching. (#18429)
+ Updates/fixes to relnotes script (#18470)
+ Report percentual download progress in repository rules (#18471)
+ Support remote symlink outputs when building without the bytes. (#18476)
+ Enrich local BEP upload errors with file path and digest possible. (#18481)
+ Set `GTEST_SHARD_STATUS_FILE` in test setup (#18482)
+ Fix relnotes script (#18491)
+ Fix Xcode 14.3 compatibility (#18490)
+ Fix https://github.com/bazelbuild/bazel/issues/18493. (#18514)
+ Extend the credential helper default timeout to 10s. (#18527)
+ Fix formatting of release notes (#18534)
+ Use extension rather than local names in ModuleExtensionMetadata (#18536)
+ [credentialhelper] Ignore all errors when writing stdin (#18540)
+ Improve error on invalid `-//foo` and `-@repo//foo` options (#18516)
+ Implement failure circuit breaker (#18541)
+ Actually check `TEST_SHARD_STATUS_FILE` has been touched (#18418)
+ Ignore hash string casing (#18414)
+ Error if repository name isn't supplied (#18425)
+ Track repo rule label attributes after the first non-existent one (#18412)
+ Add ServerCapabilities into RemoteExecutionClient (#18442)
+ RemoteExecutionService: support output_symlinks in ActionResult (#18441)
+ RemoteExecutionService: Action.Command to set output_paths (#18440)
+ Use local_termination_grace_seconds when testing LinuxSandbox availability (#18568)
+ Fix dangling string literal in `extension_metadata` docs (#18598)
+ Include actual MODULE.bazel location in stack traces (#18612)
+ Make cpp file extensions case sensitive again (#18552)
+ Fix error when script is run after the final tag is created. (#18638)
+ Fix WORKSPACE toolchain resolution with `--enable_bzlmod` (#18649)
+ Add `ActionExecutionMetadata` as a parameter to `ActionInputPrefetcher#prefetchFiles`. (#18656)
+ Use failure_rate instead of failure count for circuit breaker  (#18559)
+ Update ignored_error logic for circuit_breaker (#18662)
+ Don't rewind the build if invocation id stays the same (#18670)
+ Fix potential memory leak in UI (#18659)
+ Test that a credential helper can supply credentials for bzlmod. (#18663)
+ Add flag --experimental_collect_code_coverage_for_generated_files. (#18664)
+ Options specified on the pseudo-command `common` in `.rc` files are now ignored by commands that do not support them as long as they are valid options for *any* Bazel command. Previously, commands that did not support all options given for `common` would fail to run. These previous semantics of `common` are now available via the new `always` pseudo-command. Closes #18130. (#18609)
+ Fix split post-processing of LLVM-based coverage (#18737)
+ Allow module extension usages to be isolated (#18727)
+ BEGIN_PUBLIC (#18729)
+ Declare credential helpers to be a stable feature. (#18752)
+ Add a new provider for injecting native libs in android_binary (#18753)
+ Properly handle invalid credential files (#18779)
+ The REPO.bazel and MODULE.bazel files are now also considered workspace boundary markers. (#18787)
+ Report remote execution messages as events (#18780)
+ Fail on isolated extension usages without imports (#18793)
+ Add changes to cc_shared_library from head to 6.3 (#18606)
+ Remove option to disable FJP. (#18791)
+ Update to latest turbine version (#18803)
+ None. None (#18808)
+ Wait for outputs downloads before emitting local BEP events that reference these outputs. (#18815)
+ Perform builtins injection for WORKSPACE-loaded bzl files. (#18819)
+ Fix non-declared symlink issue for local actions when BwoB. (#18817)
+ Make grep_includes optional inside cc_common.register_linkstamp_compile_action (#18823)
+ add feature on windows toolchain with right tag (#18654)
+ coverage_common.instrumented_files_info now has a metadata_files argument (#18838)
+ Download directory output for test actions (#18846)
+ Teach DexMapper to not separate synthetic classes from their context … (#18853)
+ **[Incompatible]** query --output=proto --order_output=deps now returns targets in topological order (previously there was no ordering). (#18870)
+ Revert "Don't eagerly flatten a `NestedSet` in `RepoMappingManifestAction` (#18419)" (#18886)
+ Additional source inputs can now be specified for compilation in cc_library targets using the additional_compiler_inputs attribute, and these inputs can be used in the $(location) function. Fixes #18766. (#18882)
+ Open-source Google test `ConvenienceSymlinkTest` (#18890)
+ Update Error Prone to 2.20.0 (#18885)
+ Check if json.gz files exist, not the gcov version. (#18889)
+ Lockfile updates (#18894)
+ handle exception instead of crashing (#18895)
+ Add a new provider for passing dex related artifacts in android_binary (#18899)
+ Prevent most side effects of yanked modules (#18908)
+ Restore the classic desugar tool in the Bazel 6.3.0 branch so that the Bazel Android tools can be built for 6.3.0 without breaking backwards compatibility (#18909)
+ Update java_tools to v12.5 (#18868)
+ Add ActionCacheStatistics to BEP (#18914)
+ Adjust --top_level_targets_for_symlinks (#18916)
+ Track dev/non-dev `use_extension` calls (#18918)
+ Overrides specified by non-root modules no longer cause an error, and are silently ignored instead. They were originally treated as an error to allow for the future possibility of overrides in the transitive dependency graph working together; but we've deemed that infeasible (and even if it was, it'd be so complicated and confusing to users that it would not be a good addition). (#18921)
+ Rollforward of https://github.com/bazelbuild/bazel/commit/482d2be27ab… (#18773)
+ Update Android tools to 0.27.2 for fixes to DexMapper for https://gith... (#18891)
+ Report dev/non-dev deps imported via non-dev/dev usages (#18922)
+ Add reverted 'isolate' changes (#18928)
+ Identify isolated extensions by exported name (#18923)
+ test-setup.sh: Attempt to raise the original signal once more (#18932)
+ Ignore broken classic desugar tests (#18933)
+ Disable UseCorrectAssertInTests by default (#18948)
+ Fix VS 2022 autodetection (#18960)
+ Fix absolute file paths showing up in lockfiles (#18993)
+ Add support for isolated extension usages to the lockfile (#19008)

Acknowledgements:

This release contains contributions from many people at Google, as well as amishra-u, Andreas Herrmann, Andy Hamon, andyrinne12, Benjamin Lee, Benjamin Peterson, Brentley Jones, Chirag Ramani, Christopher Rydell, Daniel Wagner-Hall, Ed Schouten, Fabian Brandstetter, Fabian Meumertzheim, Greg, Ivan Golub, Jon Landis, JY Lin, Kai Zhang, Keith Smiley, kotlaja, lripoche, oquenchil, Pavan Singh, Rasrack, Son Luong Ngoc, Takeo Sawada, Vertexwahn, Xùdōng Yáng, Yannic.
```

## Release 7.0.0-pre.20230628.2 (2023-07-12)

```
Baseline: 604a9ef6332d49110d14d427317bd726225fff1d

Cherry picks:

   + 15c412eb9aa38e1b81f7dd2047849bbb55417a83:
     Automated rollback of commit
     52dbdc7a92cedfa212ef681f88e0b733cb5280e0.
   + 990d97e576d4ec7d0c45f3efa5732171492d50b1:
     Automated rollback of commit
     0bda661e589ded1caad9edd58c9bebc3f647e41d.
   + 6c393ec5539b34e9708b43b0145488b9df1c0878:
     Add temporary rules_go bazel_dep to restore CI
```

Incompatible changes:

  - Loading `.bzl` files under `@bazel_tools//tools/jdk` in WORKSPACE
    now requires `rules_java` to be defined in advance.
  - cc_binary targets with dynamic_deps attributes no longer link
    indirect dynamic_deps on Unix. This might be an incompatible
    change if you are using RUNPATHs (instead of RPATHs) in your
    cc_shared_libraries. Enable the feature
    "exclude_bazel_rpaths_in_transitive_libs" or
    "use_rpath_instead_of_runpath" for those cc_shared_libraries.

Important changes:

  - Add aquery --output=streamed_proto which writes a stream of
    length delimited ActionGraphContainer containing a single
    Artifact, Action, Target, DepSetOfFiles, Configuration,
    AspectDescriptor, RuleClass, PathFragment proto. This breaks up
    the ActionGraphContainer into multiple which will prevent large
    protos from crashing blaze.
  - (BEP) TargetConfigured events will be marked aborted instead
    of published when there is an analysis error. This is motivated
    by a
    low level Blaze change aimed at improving scalability.
  - Add flag --experimental_collect_code_coverage_for_generated_files.
  - Added a new output format for cquery --output=streamed_proto that
    writes multiple length-delimited CqueryResult protos, each
    containing a single ConfiguredTarget or Configuration. This
    allows us to "bypass" the hard limit of 2GB on the size of
    protocol buffers by splitting it up into multiple.
  - Enable starlark_doc_extract - a native rule for Starlark
    documentation
    extraction. This rule is intended mainly for internal use by
    Stardoc.

This release contains contributions from many people at Google, as well as Anshuman Mishra, Benjamin Peterson, Benjamin Peterson, Daniel Wagner-Hall, Fabian Meumertzheim, Jay Conrod, Maksim, Rasrack, Sam Shadwell, Son Luong Ngoc, Takeo Sawada, Tyler Williams, Xavier Bonaventura, Yannic, Yuval Kaplan.

## Release 7.0.0-pre.20230530.3 (2023-06-09)

```
Baseline: 67446d625e4daafadcb5918a88ed52f517a8871f

Cherry picks:

   + 4344a0358f44c0290f85f8d90dede5824593ce77:
     Automated rollback of commit
     00a4fefe594069d47d1bde99b28c6b8dcca0a7c1.
```

Incompatible changes:

  - `--incompatible_check_sharding_support` is enabled by default.
    Sharded tests with test runners that do not properly advertise
    support for test sharding will fail. Refer to
    https://github.com/bazelbuild/bazel/issues/18339 for migration
    advice.

Important changes:

  - Options specified on the pseudo-command `common` in `.rc` files
    are now ignored by commands that do not support them as long as
    they are valid options for *any* Bazel command. Previously,
    commands that did not support all options given for `common`
    would fail to run. These previous semantics of `common` are now
    available via the new `always` pseudo-command.
  - the 'default' param of json.decode can now be used as a keyword
    parameter.
  - As a transitional step in a larger refactoring, rule transitions
    are applied twice. Once during dependency resolution and once
    right before
    analysis of those rules. After the refactoring is complete, rule
    transitions
    will be applied only once.

This release contains contributions from many people at Google, as well as Fabian Meumertzheim, Jimm chja20, Keith Smiley.

## Release 7.0.0-pre.20230524.3 (2023-06-05)

```
Baseline: ea2d5043113a34ce341c53168141f13f14053240

Cherry picks:

   + 2e34965242280d861f688628ed2bbc5209350d9f:
     Have `Package#defaultPackageMetadata` be in the same order that
     the `package.default_applicable_licenses` list was in.
```

Initial release.

## Release 6.2.1 (2023-06-02)

```
Baseline:  758b44dab552f31b378874b5bf4c0609bfef6f5d

Release Notes:

+ Automatic code cleanup. (#18504)
+ Update relnotes scripts (#18503)
+ Fix https://github.com/bazelbuild/bazel/issues/18493. (#18512)
+ Fix formatting of release notes (#18533)
+ Use extension rather than local names in ModuleExtensionMetadata (#18535)

Acknowledgements:

This release contains contributions from many people at Google, as well as Fabian Meumertzheim, Pavan Singh.
```

## Release 7.0.0-pre.20230517.4 (2023-05-26)

```
Baseline: 267ac1f14f733a41380c1f70d095f096b8798c6b

Cherry picks:

   + 98d5d5f6980ec8513dc5c0ee95fcabe3b80beb47:
     Download outputs that were not downloaded during spawn execution
     in `finalizeAction`.
   + 02853f888cd8cea6a0e06b0ca417e0470de2cec0:
     Fix non-determinism in the `FailureDetail` produced for a
     package with multiple label crosses subpackage boundary errors.
```

Incompatible changes:

  - This has the side effect of changing the message on unsuccessful
    builds from
    ```
    FAILED: Build did NOT complete successfully (0 packages loaded)
    ```
    to
    ```
    ERROR: Build did NOT complete successfully
    ```
  - Bazel no longer increases the delay between progress updates when
    there is no cursor control.
  - This has the side effect of changing the message on unsuccessful
    builds from
    ```
    FAILED: Build did NOT complete successfully (0 packages loaded)
    ```
    to
    ```
    ERROR: Build did NOT complete successfully
    ```
  - the --experimental_async_execution flag is now a no-op.
  - --experimental_replay_action_out_err is not a no-op.
  - `cquery --output=files` also outputs source files.
  - `--incompatible_strict_conflict_checks` is flipped to true. See
    https://github.com/bazelbuild/bazel/issues/16729 for details.
  - `--incompatible_strict_conflict_checks` is flipped to true. See
    https://github.com/bazelbuild/bazel/issues/16729 for details.
  - `--incompatible_always_include_files_in_data` is flipped to true.
    See https://github.com/bazelbuild/bazel/issues/16654 for details.
  - This changes the behavior of Python version in exec/host
    configuration. Mitigation is to set Python version on the targets.
  - When multiple --deleted_packages options are passed on the
    command line, they will be concatenated instead of the latest one
    taking effect.
  - This has the side effect of changing the message on unsuccessful
    builds from
  - JSON profile: Use doubles instead of strings for counter series.
  - query --output=proto --order_output=deps now returns targets in
    topological order (previously there was no ordering).
  - --experimental_build_transitive_python_runfiles is flipped to
    false. See #16303 for details
  - --incompatible_python_disable_py2 is flipped to true. See #17293
    for details.
  - When remote cache evicts blobs, Bazel will exit with code 39.
  - `--features` only applies to targets built in the target
    configuration, and `--host_features` is used for the host / exec
    configuration (gated behind `--incompatible_use_host_features`)
  - `--incompatible_strict_conflict_checks` is flipped to true. See
    https://github.com/bazelbuild/bazel/issues/16729 for details.
  - Bazel's local CPU resource on Linux is now container aware. Use
    `--local_cpu_resources`, `--loading_phase_threads` or `--jobs` to
    override.
  - `copy_from_rule` is exec_groups is deprecated
    (https://github.com/bazelbuild/bazel/issues/17668).
  - --legacy_bazel_java_test is now a no-op
  - --legacy_bazel_java_test is now a no-op
  - --legacy_bazel_java_test is now a no-op
  - `--experimental_execution_graph_log` no longer exists. Current
    users that want local logs need to pass
    `--experimental_enable_execution_graph_log
    --experimental_execution_graph_log_path=/some/local/path`.
    Current users that want logs uploaded to BEP need to pass
    `--experimental_enable_execution_graph_log
    --experimental_stream_log_file_uploads`.
  - Remove 'darwin' as a CPU value, use 'darwin_x86_64' instead
  - Remove high priority workers functionality from blaze.
  - Renamed PackageMetrics proto message to PackageLoadMetrics. The
    formats should be wire compatible.

New features:

  - The `aquery` and `cquery` commands now respect the
    `--query_file` flag just like the `query` command.
  - --experimental_repository_disable_download is now promoted to
    stable and is also available under the name
    --repository_disable_download .

Important changes:

  - The new path variable `$(rlocationpath ...)` and its plural form
    `$(rlocationpaths ...)` can be used to expand labels to the paths
    accepted by the `Rlocation` function of runfiles libraries. This
    is the preferred way to access data dependencies at runtime and
    works on all platforms, even when runfiles are not enabled (e.g.,
    on Windows by default).
  - Starlark `print()` statements are now emitted iff the line of
    code is executed. They are no longer replayed on subsequent
    invocations unless the Starlark code is re-executed.
    Additionally, multiple identical `print()` statements (same
    string from the same line of code, e.g. from a loop) are all
    emitted and no longer deduplicated.
  - Fixes a bug where some compilation flags would not be applied to
    a cc_test
  - removed outdated ctx.host_fragments
  - removed outdated ctx.host_configuration
  - Now that the host configuration is finished, `genrule` should
    prefer the use of `tools` and stop using `exec_tools`.
  - Added a `native.package_relative_label()` function, which
    converts a label string to a Label object in the context of the
    calling package, in contrast to `Label()`, which does so in the
    context of the current .bzl file. Both functions now also accept
    relative labels such as `:foo`, and are idempotent.
  - Update Android manifest merger to v30.1.3, and also drop support
    for legacy (pre-D8) desugaring.
  - Adds coverage metric support to android_local_test
  - Correctly encode double value positive infinity as "inf" instead
    of "+inf" for textprotos.
  - Add --use_target_platform_for_tests which uses the target
    platform for executing tests instead of the execution platform.
  - Custom C++ rules on Windows calling
    cc_common.create_linking_context_from_compilation_outputs should
    review whether each target of the rule type should produce a
    dynamic library since a condition which blocked their creation
    has been moved to the rules from behind the API.
  - Add flag `--experimental_remote_cache_ttl` and set the default
    value to 3 hours.
  - making --incompatible_use_platforms_repo_for_constraints do
    nothing. Using constraints from @bazel_tools//platforms with or
    without the flag will throw error with message "Constraints from
    @bazel_tools//platforms have been removed. Please use constraints
    from @platforms repository embedded in Bazel, or preferably
    declare dependency on https://github.com/bazelbuild/platforms"
  - Fixed an issue where WORKSPACE and WORKSPACE-loaded .bzl files
    couldn't see the Bzlmod root module's mappings when Bzlmod is
    enabled.
  - Subsequent settings of --extra_execution_platforms now override
    previous settings, instead of adding them to a list. If you
    currently set --extra_execution_platforms more than once, please
    migrate by passing a list of values to
    --extra_execution_platforms instead so that earlier values aren't
    overwritten.
  - @bazel_tools//config:common_settings.bzl has been removed.
    Use @bazel_skylib//rules:common_settings.bzl instead.
  - cc_shared_library is no longer experimental, see
    https://github.com/bazelbuild/bazel/issues/16709 for details
  - The flag `--distinct_host_configuration` is removed. It has been
    a no-op since Bazel 6.0.0.
  - Added `native.module_name()` and `native.module_version()` to
    allow BUILD macro authors to acquire information about which
    Bazel module the current repo is associated with.
  - Add `--skip_incompatible_explicit_targets` option
  - Remove 'darwin' as a CPU value, use 'darwin_x86_64' instead
  - cc_test can now be configured by using a native.toolchain().
  - `@foo` labels can now be used on the command line as the
    top-level target (that is, `bazel build @foo` now works).
    Double-dot syntax is now forbidden (`bazel build ../foo` will no
    longer work).
  - The location of rules that explicitly specify `generator_name`
    and/or `generator_function` attributes (typically because they
    are incidentally copied from `native.existing_rule()`) is now the
    top-level call in the `BUILD` file, which is consistent with
    rules that do not explicitly specify these attributes.
  - Warnings (most notably those associated with the `deprecation`
    rule attribute) are no longer replayed on subsequent invocations
    unless the target in question is re-analyzed. Warnings are purely
    informational, so this change has no bearing on the correctness
    of the build. Downstream tests that break due to this change
    should update their expectations.
  - `--experimental_remote_build_event_upload` has been renamed to
    `--remote_build_event_upload`
  - [Breaking change] platform, constraint_setting, and
    constraint_value can no longer take an applicable_licenses value.
    Remediation is to remove the attribute and rely on the package
    level default.
  - `--experimental_action_cache_store_output_metadata` has been
    renamed to `--action_cache_store_output_metadata`
  - Changed the default value for `--remote_build_event_upload` to
    `minimal`.
  - `--experimental_remote_cache_compression` has been renamed to
    `--remote_cache_compression`
  - The REPO.bazel and MODULE.bazel files are now also considered
    workspace boundary markers.
  - Added a new `max_compatibility_level` attribute to the
    `bazel_dep` directive, which allows version selection to upgrade
    a dependency up to the specified compatibility level.
  - `--experimental_remote_grpc_log` has been renamed to
    `--remote_grpc_log`
  - `--incompatible_remote_build_event_upload_respect_no_cache` is
    now a no-op.
  - json.decode now takes an optional `default` positional parameter;
    if this parameter is specified and decoding fails, json.decode
    will return
    the `default` value instead of failing Starlark evaluation.
  - Overrides specified by non-root modules no longer cause an error,
    and are silently ignored instead. They were originally treated as
    an error to allow for the future possibility of overrides in the
    transitive dependency graph working together; but we've deemed
    that infeasible (and even if it was, it'd be so complicated and
    confusing to users that it would not be a good addition).
  - `applicable_licenses` is no longer allowed on the `platform` rule.
    Additionally, `default_package_metadata` from any `package` rule
    will not be applied.

This release contains contributions from many people at Google, as well as Adam Lavin, Alessandro Patti, Alex Eagle, AlexTereshenkov, Amanda L Martin, Andreas Herrmann, Andy Hamon, Ankit Agarwal, Ankush Goyal, Anthony Ter-Saakov, Artem Zinnatullin, aryeh, Austin Schuh, Benjamin Lee, Benjamin Peterson, Benjamin Peterson, Benjamin Sigonneau, Ben Lee, Brentley Jones, Cameron Martin, Chirag Ramani, Chirag Ramani, Chris Sauer, Christopher Peterson Sauer, Christopher Rydell, Christopher Sauer, Daniel Grunwald, Daniel KT, Daniel Wagner-Hall, David Ostrovsky, Dimi Shahbaz, eareilg, Ed Schouten, Emil Kattainen, Ezekiel Warren, Fabian Meumertzheim, Fabian Meumertzheim, Fahrzin Hemmati, Fahrzin Hemmati, Gaspare Vitta, George Gensure, Greg, Greg Magolan, Halil Sener, Hao Yuan, hvadehra, hvd, Ivan Golub, Jack Dai, James Ma, Jasper, Jeff Hodges, Jeremy Volkman, Joel Jeske, John Hinnegan, Jon Landis, Jon Parise, jonrose-dev, Joseph Tilahun, Julio Merino, Kai Zhang, keertk, Keith Smiley, Konstantin Erman, Krzysztof Naglik, kshyanashree, Kun-Lu, Lee Mracek, lripoche, Malte Poll, Marc Redemske, Marc Zych, Matt Mackay, Mauricio Galindo, Maxwell Elliott, mohamadk, nathyong, Nick Korostelev, Oliver Lee, Oscar Garzon, Patrick Balestra, Patrick Balestra, Philipp Schrader, Red Daly, redwrasse, robincaloudis, Robin Tweedie, Roger Hu, Sagar Pathare, Saleem Abdulrasool, Sara Adams, Sascha Moecker, Severin Strobl, Siddhesh Bhupendra Kuakde, Simon Mavi Stewart, something_vague, Son Luong Ngoc, Stiopa Koltsov, stoozy, Sushain Cherivirala, tbaing, Ted Kaplan, Ted Kaplan, Ted Logan, Thulio Ferraz Assis, Tom Cnops, Ulf Adams, Ulf Adams, Ulrik Falklof, Uri Baghin, Xavier Bonaventura, Xdng Yng, Xiangquan Xiao, Yannic Bonenberger, Yannic, Yi Cheng, yuzhy8701.

## Release 6.2.0 (2023-05-09)

```
Baseline: d60ce2c7c86393638c77698c00c2168a7a936a53

Cherry picks:

   + 490f8badf4f6f4ae8b96697f08267fdb083ccf5f:
     kshyanashree is the release manager of 6.0.0
   + 4e66d9340037f0be83d7bc0fdd809a09344ab83f:
     Automated rollback of commit
     2a2890913eb8f39299aa4b614ba96266ea8749f6.
   + 48a8d01b05149757f69a6a65a22a280bf003cd24:
     Allow C/C++ coverage collection for external targets
   + ec7be346adc00c4bde22d116fca80ef59da66121:
     Temporarily set parent directory of the input to writable if it
     is not.
   + b0984342eef068640a57aab584dd4c118f0dd394:
     Infer CPUs for tvOS and watchOS when on Apple Silicon
   + 5cea7dda5b632703cf4e0424ba09cd7c5bd6fc06:
     Improve the documentation for ctx.actions.symlink.
   + a82d26f17a99b5417b2212a0ce3a1bbc0285e5c4:
     Add quotes to "Tip"
   + 75b0f3aa95bc34f6620ea74e47d4822bd985efdd:
     Write a repo mapping manifest in the runfiles directory (#16555)
   + 07c5c1aa6d0b63605ae793dce78d26122af64a84:
     Ensure repository names don't start with `~`
   + 30f6c8238f39c4a396b3cb56a98c1a2e79d10bb9:
     Escape tilde more gracefully
   + cf3f48ca49f089615417636763d753811acf717f:
     Relax `Label` repo visibility validation
   + 4477823e2c2bc3d0335c41f971364dda72a3f69a:
     Use "apparent name" instead of "local name" in Bzlmod docs
   + 55f4f4834ef30321a00dab5b58202dd1e9716fd9:
     Bazel DevSite: Add required css file.
   + a706994ac69e3f3fed361c61378de847b50d3b12:
     Remove logic that increases delay between progress updates over
     time
   + 1d514ab05896f34ec91c2145f4dffafd3364030f:
     Remove references to io_bazel repository
   + b0357bd3831b26b5116dc120807e8264acf139db:
     Relnotes python script
   + 8f956511bb115c39ac683a1e78971fcf9dce5deb:
     Allow Java coverage collection for external targets
   + bddb191d3f99402330c67b89375409c31ee22daa:
     Fix race condition in package-bazel.sh
   + a75785279f543f4e33c697dd9e8873a6504b7818:
     Decanonicalize labels emitted by {a,c,}query if possible
   + 9d250edb63f27f9f4591bb5a71059710cc6dca9e:
     Add uniquify parameter to TemplateDict.add_joined
   + f02bcf8d8b0d00ecdd06ea0a45ba4f52e436597c:
     Fix identical gcov json file name problem
   + a1593309f66f892871e334013815b05350b4188f:
     Add `$(rlocationpath(s) ...)` expansion
   + 56f54daf9ff3b1177eee31e342e8d6b959d5ac34:
     Rollup of SBOM correctness fixes (#16655)
   + 72e6e948d30dec9dec60d78efef4eeda5b764a8f:
     [cc] Add cc toolchain to starlark cc_proto_library (#16661)
   + 8f28513893969b6346d965cab12aac69cb246ced:
     Make C++ runfiles library repo mapping aware
   + 95f9adc5ac544b1161d69a7ca74432479fdc29b3:
     Always collect FileProvider's filesToBuild as data runfiles
   + 4959d34e844714b793b2c6fa05016a9a6eaa7044:
     fix: export constraints.bzl file from @local_config_platform so
     it can be used in downstream bzl_library targets
   + 4919d4a61d8506d175b25a035500842b8bfe3d0d:
     Add --host_per_file_copt (#16695)
   + 0a23d46976c3fc999d44fbd1e37732ec2442d485:
     Moving some tests for `RemoteActionFileSystem` of BwoB to a base
     class.
   + 9296068be5e3808eb03a3b61f3af3a2c88f7ab7d:
     [remote/downloader] Don't include headers in `FetchBlobRequest`
   + 128d833fee99f8a43bc4de82cbec752e4ce6fb47:
     [remote] Respect whether the server supports action cache updates
   + 38c501912fc4efc14abc0741d19f5f8e8763afcb:
     [remote/downloader] Migrate `Downloader` to take `Credentials`
     (#16732)
   + 5929cb72aa01768e6352898b1a056ef678c81d90:
     Stage repository mapping manifest as a root symlink (#16733)
   + 455454a56e961affb041a1d4a9214f7f313a05aa:
     Expose current repository name to Java with @AutoBazelRepository
   + 97dea593e568f776361397f7280d6a16eee2efeb:
     Implement getDirectoryEntries and readdir for
     RemoteActionFileSystem.
   + aa45f5f3301c5005294df084cdf99c45d6f95d53:
     Move integration tests for BwoB to a base class and add more
     tests there.
   + 1b073ac0a719a09c9b2d1a52680517ab22dc971e:
     Make Java runfiles library repo mapping aware
   + 148bbb1c025a628643698f65627333d86975c1d7:
     Use `_repo_mapping` in C++ runfiles library (#16752)
   + 25558ada3fb377cfc2c965d3a93250ca28ce0fc1:
     Add --experimental_action_cache_store_output_metadata to the
     expansio…
   + 6e945e8ab422ca0a195d09899cce61ba6c0cfa59:
     Treat `DEBUG` events as progress-like.
   + 1940c5d68136ce2079efa8ff74d4e5fdf63ee3e6:
     redact 'token' strings from logging
   + 0b645254b41edc738c6641fd192fca86203ff2e2:
     Make Bash runfiles library repo mapping aware (#16753)
   + 4caae75b49e815ad2cf1d805f316bc374f03f2ae:
     Automated rollback of commit
     8f956511bb115c39ac683a1e78971fcf9dce5deb.
   + 13ff6d9e37999e00fda9a6cef278c7c924924f34:
     Fix Bash rlocation failure with stricter Bash options
   + bd88c7e47b911e5fa1f8a3c26d0f8317943c43ce:
     Make bazel Android remote deps compatible with bzlmod (#16772)
   + 6f6d4cca36a3b64009ed9c8b3fb13cb3c7ed915a:
     Flip `--incompatible_always_include_files_in_data`
   + 94355b1b1c4f7ef923457b8b2a070e5c6528240a:
     Add required `--add-opens` server JVM args also with
     non-embedded JDK
   + 8349c95fc98beb4008085942a67a57f0c4da074b:
     Also collect clang resource directory with
     `-no-canonical-prefixes`
   + dce6ed777d958d65c7f3d4a2f54f8117778a449e:
     Make `bazel run` works with minimal mode
   + ca8674cc4879ed1846bf015c33fe7d920a3f66ab:
     Include source files with `cquery --output=files` (#16826)
   + 9cb5e0a31665d3b3f25bf58ec2dee696e828d8b9:
     Fsync before rename after copy in DiskCacheClient
   + 23ffce53b92ef96432d8c6c58cc95ac362bab1bc:
     Update GetActionResult for disk cache to check referenced files
     when …
   + 0bc0ff5244142eb3348d42025ce21eeb337ad189:
     Make Java runfiles library compilable with JDK 8
   + fe169654a29d8ad33105d5d0034a7857834fed5d:
     [6.0.0] Default --incompatible_strict_conflict_checks to true.
     (#16864)
   + 99ca86f7c2968741ac3a9b20c3375fc992d49e66:
     Revert "[6.0.0] Default --incompatible_strict_conflict_checks to
     true. (#16864)" (#16872)
   + 312238f2b1414c98ed7d7d51dc4e18278edb2540:
     Make C++ runfiles library build with `-Werror=shadow`
   + 2baa5a4284467d70f1b31ea779b79d38ef07d164:
     Keep credentials cached across build commands.
   + 8818a57fce32a7872f045f03a334e1c9403724d3:
     [6.0.0] Only inject metadata for outputs that cannot be
     reconstructed by skyf… (#16879)
   + 31e4bf409eed71e8fb626092189eacb95f80fed9:
     Update java_tools v11.9
   + cd40666001e8d599bb61735898c195c6d2fae55b:
     replace _get_canonical_form(label) with str(label)
   + e2bc2374188b41924223385ad943db610e92e6c4:
     Avoid exceptions from hermetic sandbox for unsupported artifact
     subclasses
   + b564d145218e58b0440ffad82b3d1d54eef15d22:
     Remove warnings about ignored starlark options
   + 7ccc66108f08f7b6c6f6e5229f70f29962ea19ce:
     [6.0.0] Emit Tree objects in topological order (#16904)
   + 86dee6d2ecb269e0c41a97718812054394ee51a4:
     Correctly match regex with tree artifact
   + 14925b574aa63aad098f2c3d95e14b46ffd295ec:
     Always use target's attributes to set Python version (#16959)
   + a247502d28d8d70d648390de52952189b99a0bb7:
     Add 'toolchain' parameter to actions.{run,run_shell}
   + 497b7e403d6e5523bd1310bd1fe83c4ce1a6b1ec:
     Fix Bash `runfiles_current_repository` with RBE
   + 0a2c4edbc86398266525f31948d67a5736890bfe:
     Fix corner cases in Bash runfiles library
   + 33b514b25963452be71a015e08d4e890405b00a3:
     Fix runfiles creation with MANIFEST when building without the
     bytes
   + 3a13af41034e1f80cc0fbc1634cf8f724a85b78f:
     Remove LCOV merger dependency of `cc_test` without coverage
     (#17004)
   + 25ba76c1b8d420ebae43c1f59890ae46153c2240:
     Include full tree artifact in inputs when prefetcher doesn't
     support partial tree artifacts.
   + 06deebfb5b73f848de5a0ea0e00fcfaa26788d1f:
     Release 6.0.0 (2022-12-19)
   + c2bfb2e98d133c62be328e6e93c4b4bdf766d82c:
     Enable git_submodules tests and merge git_repository and
     starlark_git_repository (#17247)
   + e8182ce32931560406fee1c30745e56a2ee9a6b3:
     have 'bazel test' non-test targets depend on
     --remote_download_output
   + c3245cd028977877aa9e485451b29c7736ebcae0:
     Add `SpellChecker` suggestions for common Bzlmod errors
   + 8ec874348226995c4101b2173a465ddc65cab591:
     Use xcrun to invoke install_name_tool
   + 2b2bea4ee9d51ad875a8d273aa344ac9c5b6742c:
     Extra resources
   + 5b4de12b37cb4ba921b6bdfe810bbb47921ab3a6:
     Do not clear `--platforms` on no-op change to `--cpu`
   + db3c0130b3363485a366897e1c1f2adc5d41fde6:
     Report `AspectCreationException` to the user
   + 53e9fea30e58ab479e5cd7a6c804634f56fc2ddb:
     Use long executable path instead of `argv[0]` in all launchers
   + abae5ca3e8142f93cf0c2597e3410ed955c4dd59:
     Add sanitizer features to unix_cc_toolchain_config
   + db684196afd3b1a0a0e7d883674324bd161ae8bf:
     Allow `map_each` to return `None` in `TemplateDict#add_joined`
   + 66b58ee904efa22696edc1b78a59bac91da9ed8d:
     Always emit trailing zero in human-readable download progress
   + 17b8e448a5e5589f96c2794cb38c86b0c64e86c0:
     Upload all logs in BEP even with minimal upload
   + 28d2daae70be6ee97b876b0568796ceb87af9523:
     Set `--experimental_action_listeners` to default in `exec` config
   + 16427c9050db140d6cb90d7d6324d4a2ff1e249a:
     Do not count tests as failed that have not started
   + 094a0aabed1e018e6503bc3ac844c8022b71a527:
     Accept tildes in --override_module
   + 5f2866f8434ce9a17cf82c001efb7b236f189115:
     Do the AC integrity check for disk part of the combined cache.
   + cd10d508e20a4964586b46f7edea8a6dc900157c:
     Fix `--nozip_undeclared_test_outputs` on Windows
   + 073f54b9a7c46afd2c28b4a99a235bdd6b63bb5f:
     Allow pyd in extensions of dynamic libraries
   + ac504cbb463e76b1374d0060534acabbccb408d2:
     Register JavaCompileActionContext in Bazel.
   + f090433fcf0f42639608b9c5f0243018c1bb9ac7:
     Rollback #14510 because it causes remote test execution to fail
   + 942dddaaad9bf4fbb20b66535aad4fc464ad69ba:
     Prepare backwards compatible usage of optional C++ toolchain
   + 88b51f57d09e43dec31a84d4b636595924d5bfef:
     Emit LLVM coverage for source file paths with a `tmp` segment
   + bb0b886271d45209e3bef476da37811b9dd2afe5:
     Enable archive_param_file feature by default for Windows
   + baf97c00c891acf844a29b4cc31abb45b5c434e5:
     Allow `TemplateDict#map_each` callback to return a list of
     strings (#17306)
   + fcb007749f7f24b36c2b7c4284378bba20fc8b69:
     Only try to create groups of test actions in the ui.
   + 3c47b4716e6eca2b8ab06253915ef8d1bdd28038:
     Find `libtool` when using `BAZEL_USE_CPP_ONLY_TOOLCHAIN`.
   + 1da8a825c0fba882f33ea6998a76ff8265fcd32c:
     Add -dead_strip in default opt link flags for darwin
   + b0c5eb30b2738bf6454c3026a3e0f37579d5854c:
     Dont query remote cache but always use bytestream protocol
   + 00e9af1985cc0227599516fe7568785ca4334050:
     Allow Java coverage collection for external targets.
   + dd24a0022a0ff959598da2c9bc097d27083be1a0:
     Test and fix root symlink edge case in runfiles library
   + af97d9830d3207893cc6f5c851431a28f1721acb:
     [6.1.0] Fix broken CI (#17422)
   + b859571804f2095caaf018b172b59c90f185fd51:
     Add `native.package_relative_label` function
   + 82168d44ee1d49cf2f406903b6d8b9fde0e66cf2:
     Make Bazel more responsive and use less memory when --jobs is
     high (#17398)
   + 84c1ed430405b154b6e9eb2c28281f450e250eff:
     Multiplex worker fixes and tests for Android busybox tools
     (#17371)
   + 07590818d6ce0d0e66c2377db7e73fb6ee6702e5:
     Improve error message for concurrent modifications (#17396)
   + 27bc896f36f0e0ea5dbeaaa16f3a124e38a7284a:
     [6.1.0] Make bazel coverage work with minimal mode (#17397)
   + 544b8164ca352cf06dda0849a589b825631428af:
     [6.1.0] Fix cc_binary bug related to cc_shared_library on
     Windows and prepare for future removal of
     --experimental_cc_shared_library flag (#17445)
   + 9a7aa21c8cd6f38d10e23e265dd650bf031f9b7c:
     Fix Bash `runfiles_current_repository` for tools
   + 911eedc0badcefdbc60a936ae73972772042fc8a:
     Fix label unambiguous canonical form to correctly report
     non-visible repo names
   + e132653ead5e50f4226dbff7776466fef1918f49:
     Remove O1 from sanitizer feature flag defaults
   + ba9e2f8fe666b4fc6110d86ea93cc11779e77068:
     Remove usage of gRPC Context cancellation in the remote
     execution client.
   + de03a2363d016782c5dfe7c55b5cf06cb610f6a2:
     Allow -v to libtool
   + 4e35c02c7c400bfbbfa69164a1ec3bd51966ca79:
     Prettify labels in action progress messages with Bzlmod (#17278)
   + 1be0ac3e73698e31a349ece629c887b06e102a0b:
     Expand tree outputs before eagerly prefetching them for local
     actions. (#17494)
   + c26665102d0d524bb42be8cd205c7b31a22a75c9:
     Fix Java coverage collection with Java 8 runtime
   + 1a6ffe6d453708e3cefc98a07965c680e48d6bac:
     Add a flag to disable execution log sorting.
   + fbec8e2ad1dcbebbbc96491f8b6b208f5b3ac91f:
     Reduce flakiness on Windows for BwoB tests
   + 420659a9ad2a98f57e057d8c22eb621e3b12803e:
     Make AutoBazelRepositoryProcessor compatible with Java 8
   + dde6d20b3fd1d7a14825649c9c89d1c4d2d5242b:
     Do not recommend `shallow_since` for `git_repository`
   + f76fc61640825dd7cf83ce02ba48a4e4f95b66ff:
     Allow the timeout value for execute calls on a mac to be set via
     an environment variable
   + 773d232f528276338098578a28c19c742e3b4e7e:
     Fix RPATHs for cc toolchain solib when sibling layout is used
   + 5932b3b8886ddb5aba271fd907f1371e67960a44:
     [6.1.0] Add --host_features (#17528)
   + a0fa77cc36d02f5f230335556a1829b298b2f219:
     Exit with code 39 if remote cache evicted blobs that Bazel need
     during an invocation (#17496)
   + 1a438b41b74d94fd8b6ff4dcf20b4526530e3c6e:
     Only fetch @remote_coverage_tools when collecting coverage
     (#17512)
   + ee1daaf9852d568dcf38357eadd77b9de953db36:
     [6.1.0]Only fetch @remote_coverage_tools when collecting
     coverage (#17287)
   + 350e32952bdd639969e2aff7887c5dc34c21bce6:
     [6.1.0]Fix symlink file creation overhead (#17488)
   + 5406c953574d48434d33b1cf49b70b718795d783:
     [6.1.0] Cleanup stale state when remote cache evicted (#17538)
   + 2d1b570e976773134a6244dd012e93a5478f6d4a:
     Bump version number in runfiles.bash init code
   + 3ab8a0a5d628a0d958fb2eb1c0d5bb76b442e2f2:
     [6.1.0]Let `aquery` print effective environment for all
     `CommandAction`s (#17274)
   + 51e6c38ae808df4f2bf8fb29b4c5173e06ac014a:
     Properly report repo fetch progress during main repo mapping
     computation
   + 744108e88681e770982f148161d328c9b77319a1:
     [docs] Update migrating to Xcode tutorial (#17563)
   + 9dc7a7e6881f58965103b42390560589e0f38b48:
     Update //third_party:jsr305 (#17557)
   + 43dadb275b3f9690242bf2d94a0757c721d231a9:
     Bump minimum supported macOS versions to 10.13
   + 7d9d23c1ac1b7fcaa461f902e286f50fbb7cb116:
     Correctly set default subprocess factory when loading class
     `SubprocessBuilder`.
   + 77f82f4fab189fd042754be0a7747042d9b01b8f:
     Add an --incompatible_strict_conflict_checks alias for
     --experimental_strict_conflict_checks.
   + e05345dec405a0333c48ff188d2d9a1be90dad53:
     Add support for wrapping system streams in WorkRequestHandler
   + 68e1924cdab69ab92b8acf2f6e9324d11e00b267:
     Also handle remote cache eviction for tree artifacts. (#17601)
   + 4a6d056a8d058ab98a01348fb0c046660ee99a71:
     Add host transition to lcov_merger in Java version of py_test
   + 546e9e2942cb2e98b4c93065cc2d2910878dc900:
     Fix Bazel 6.0 crash regression (#17613)
   + 7e328bb71004e1976525d8b813ca0d616e2af74b:
     Include Bazel version information in profile metadata. (#17616)
   + aafe1235c55f6cdcfc577a40736aaeb9ebaca23b:
     [6.1.0] Handle remote cache eviction when uploading inputs for
     remote actions. (#17605)
   + 938e34823206a2644d538ba655d20ac553352975:
     [6.1.0] Rerun the artifact conflict check when
     --incompatible_strict_conflict_checks changes. (#17592)
   + 034a2815a1e18be5c8b36c6a78f44bb849dff437:
     Report background download for BwoB (#17619)
   + 5afbce52c70cf974eaa4a3bbbc376f398271427d:
     [6.1.0] Flag for writable outputs (experimental) (#17617)
   + d4105e658001677929338835eb970e6595e66b3c:
     [6.1.0] Allow .wasm cc executable and dynamic library extension
     (#17440)
   + a306f4f7fd440d006aa6ae9234b4430f13bc8cf9:
     make desugar dependencies deterministic
   + 37953c56ea77c7aa7bea677f3481557fdb2c2a15:
     Apply exec transition to lcov_merger in sh_test and cc_test
   + 1d73d72a45598e38c51b2618bb6fe4f27b390cb8:
     [6.1.0]Fix --host_features with multiple transitions (#17641)
   + 755cd4bcd48adf752bd8c161454e53a0f5b6a2fa:
     Release 6.1.0 (2023-03-06)
   + 885ae7ef3afd88e21c33579bcd64ee3136bd8715:
     Revert "Add -dead_strip in default opt link flags for darwin
     (#17312)" (#17696)
   + 94c519bcc555195d061e1a63f0e4235795bec5be:
     Skip empty directories instead of throwing in prefetcher.
     (#17718)
   + 60749d53dfb56068050edabbf7be11675841c112:
     [6.2.0] Remove actionId from RemoteFileArtifactValue. (#17724)
   + 52deefe54124c3cff0dd708704381aa4ac69c01d:
     Correctly handle templated tree artifacts in the prefetcher.
   + 10587b1b819c8b1ae15d064a7bb3d2a7ac2149da:
     Silence setlocale warnings in Java stub
   + 3ad392776bebbfd2a9584dd221f34494f424a53a:
     Force the Bazel server Java runtime to use the root locale
   + 7c235ff15190b1eefdbd34696a55272bbb221435:
     [credentialhelper] Ignore failing to provide request
   + daa3dbe22adb03338c75b53ea97954c9434099b4:
     [remote] upload: treat `ALREADY_EXISTS` as success
   + e0cdaced03750823021b8b1f5b82a71170d67642:
     Fix data race in prefetcher.
   + c9e3eeb2f34d66e2c8bcccd32786ea75c357497e:
     [6.2.0] Update java_tools v11.12 (#17761)
   + 6c8930347025ef22e21d7793dd9202033dd79151:
     python: Remove temporary module space created for zip-based
     binaries (#17764)
   + b874e5fd7ed6f1cb2ac4b858bd28b46ae97350e0:
     [6.2.0]Add test coverage support to android_local_test (#17467)
   + 6fc9bedb3e26479df62b82d281854aed4a916fa9:
     Fix wasm dynamic library extension crash (#17765)
   + 38ece3c04105698fc84daa89ba30c5fa692e0403:
     Handle `SIGWINCH` under `bazel run //some:test` (i.e. test
     rules) correctly.
   + 49a9502312b6af391a10e1a5c3e05d245ad54899:
     Clear all remote metadata if any of them are evicted from remote
     cache
   + 8fab22e64035561fdb1c96d4e507b78a02cb5e39:
     Include build-tools/X.Y.Z/{lib,lib64}/** in the minimal set of
     SDK files used by the Android integration tests.
   + 3a7236beb8c0692c327aaeb5341801280d0cd870:
     Allow WORKSPACE and WORKSPACE-loaded .bzl files to see Bzlmod
     root module's mappings (#17818)
   + a87b8e0b6b17feed7e649a85f17162510fa8d652:
     [6.2.0]Add support for alias targets to cquery's `providers`
     (#17786)
   + ee32efffe4c407d7fe54b287a80a3b0a115040c6:
     [6.2.0] Allows --query_file to be used for cquery and aquery
     too. (#17823)
   + cfef67da634996f09e5f2509e198cc73c88ce8b2:
     Fix seeking of empty chunkers.
   + 50ec6bbff08cc00de4dfdea68e7483f383674222:
     Rework ByteStreamUploader early return logic.
   + 745ca288770253225d5d96069038a5d735eda69b:
     Suggest alternatives for typoed rule attribute names
   + 8548e202a6871a17f0d097e2cedc9ff8064ef962:
     Relax JSON parser, ensure duplicate keys are overridden
   + c04f0d41317bfe1f6ff42da94dddb4023587fc26:
     Use less subshells and `tee`s in running tests with `bazel run`.
   + 8c6d02e00777c0cc12e97fccc5f4fb6e8109a5bd:
     Upgrade Azul JDK 17 archives. (#17852)
   + 3c1c0c09e68420c813d6258b90ff96641dbd1151:
     Add suggestions to invalid tag class errors
   + 99b3f38649dc82efde6c570e80ce4f3abbc4ac43:
     [6.2.0] Add native.module_{name,version} (#17893)
   + f7627e00bf96c9159ab79a32afc4f6a622f0deeb:
     Support (workspace) relative paths in --override_module closes
     https://github.com/bazelbuild/bazel/issues/17551
   + 109b29019882811d1beb97a60f8cda668442e8e8:
     Fail early if `use_extension` has a bad label
   + f63ce7973b8f3f2560f41daf7321a40d20b22fab:
     Avoid unnecessary copying when building Merkle trees.
   + 3ea18cc033ed078f83fc6644c9d20fb69d6d2657:
     [6.2.0]Add `module_ctx.is_dev_dependency` (#17934)
   + 2d04c91327cadb3f0d53bceea117d3939a25e143:
     [6.2.0] Add version to JavaRuntimeInfo (#17913)
   + 2c1a63bc1df727ee26526eec27c5a92fc0c20649:
     Fix CI breakages for release-6.2.0 (#17969)
   + 788801a8fd30985a1831de805172d257c6f63691:
     Enable C++ deps pruning on Windows when PARSE_SHOWINCLUDES is
     available.
   + fb4a0c288ba5ee14e47c7879a6be3eefb44bfe9f:
     [6.2.0] TargetPattern parsing fixes (#17945)
   + 70ce8378638290295e17fb62e735a239f22672e6:
     Add attribute 'provides = [CcInfo]' to '_cc_proto_aspect'
   + 6e18829339a5ba839ab129c64bd9333d3d8c1e5a:
     [6.2.0]Expose cc_proto_aspect as a toplevel symbol. (#17980)
   + 0f55d124c05ee2654c3ff56e0332e71ff1eb437c:
     Cache Merkle trees for tree artifacts.
   + 6d6fa81e47591f41b9dce5e2a9a8512ec13d3f4a:
     Deduplicate concurrent computations of the same Merkle tree.
   + 1f2b3ed4ac717b814d02a0d125f160ddabe78003:
     Patch zlib to fix compatibility with latest Xcode
   + 27e4c6243524156d880bd04e834db5ebdb0a69af:
     Add exception message to 'failed to create output directory'
   + 405012066d2394ad9986830ca028badd3c65ad38:
     Prevent failures creating output directories
   + 1474b5b5b41dfb680674e37975b6e1754c3a7445:
     Allow multiple matching select branches if they resolve to the
     same value (#18066)
   + 5ddef4716e33b12f5dc1386abdb48ba8ab9ff7ab:
     Turn applicable_licenses on platform() into a no-op. (#18089)
   + e00509bd5f1dee6fcaf495893c5bb5ae385ea8ea:
     Use ctime in file digest cache key (#18105)
   + ca30372e210a638cfce8334b6dc3396c83424baa:
     Gracefully handle output symlinks with BwoB
   + a0cb57fd7e7dfafd54070b5fdfbd4b4254ce6e95:
     [6.2.0] profile: add profile_finish_ts (#18129)
   + 1a60fad7d0a8d04399cca0e5bc5d9ee5b01858eb:
     fix(python): Set envvar for runfiles manifest, not runfiles dir,
     when using a manifest (#18133)
   + 5e9fa3967cf0288083638aec3b34328ab8a90a51:
     Add attribute validation to IncompatibleTargetChecker. (#18135)
   + 97312f328f735ab8bcc28674e84450313f7667bf:
     [6.2.0] Update CODEOWNERS (#18149)
   + 76ad4a9b8e1b5a5cc5ed5edaad9b438cd9d8ef66:
     [6.2.0]Fix worker and multiplex workers for DexBuilder and
     Desugar actions (#17965)
   + 5afb8b61fab4671cb9a756fdb8fc275ee2fa4d19:
     Lockfile cherry picks (#18143)
   + 1940dfb07424ff7ac6d1d8cf7b776b4dc04b21e8:
     Automatically retry the build if encountered remote cache
     eviction error (#18171)
   + 755cf95b0df132c1d3fb80ccff6d5b52de708514:
     [6.2.0]Allow remote retry max delay to be user configurable
     (#18061)
   + 6c6111085e57f4b8869a5d2bdead0f8a536950ea:
     Add `module_ctx.extension_metadata` (#18174)
   + c1fea137312248d606bbb73bac1ab4a4e87557a2:
     Introduce max_compatibility_level for bazel_dep (#18178)
   + f95b80d166eb46ba4e4c0fb4b998f6e12206ee17:
     Include cause when reporting `ActionExecutionException`
   + 8a41be90cf24258db14a8ca1be7c4334d0076dd5:
     Check for the nullness of AspectValue.
   + 271512031d1a43f85eede12cd05b0ebeec66bc9a:
     Rename `--experimental_remote_grpc_log` to `--remote_grpc_log`
   + e4682f6c6fa5d8d67d667aa6593a34370e689cf5:
     [6.2.0] Update java_tools v12.1 (#18197)
   + d94dee2b6b382ec2835f9871b34b3e703bcc49a7:
     Construct TreeArtifactValues on multiple threads. (#18194)
   + 519eef48ee166cfcc4fb8e92d4728483ecc4fd40:
     Fix crash on multiple output symlinks with BwoB
   + 2442a2e9c064781120b78efe554ca3617bee8769:
     [6.2.0] default_java_toolchain.bzl cherry-picks to fix
     regression (#18225)
   + e4f3d4ddfb54419bd5bb793a29b83ff26c82d9ce:
     Fix message generation of `ActionExecutionException`
   + f39454f0eb85e08f849c8c76123191205224d269:
     Add `dev_dependency` to
     `register_{execution_platforms,toolchains}`
   + bf188c12cb8ad9164ab78564d142699fdc37efaa:
     Fine tune the number of test jobs running in parallel to avoid
     timeout on Intel macOS platform
   + e0242479af14aeb3d8444947cdaf540d8ec7ff3a:
     Update java_tools v12.2
   + 2dca98231b02ad8531608183c1e14c5492c62da0:
     Update java_tools v12.3
```

Incompatible changes:

  - Bazel no longer increases the delay between progress updates when
    there is no cursor control.
  - `--incompatible_always_include_files_in_data` is flipped
    to true. See https://github.com/bazelbuild/bazel/issues/16654 for
    details.
  - `cquery --output=files` also outputs source files.
    
    Closes #16602.
  - `--incompatible_strict_conflict_checks` is flipped to true. See
    https://github.com/bazelbuild/bazel/issues/16729 for details.
  - This changes the behavior of Python version in exec/host
    configuration. Mitigation is to set Python version on the targets.
  - `--features` only applies to targets built in the target
    configuration, and `--host_features` is used for the host / exec
    configuration (gated behind `--incompatible_use_host_features`)
    
    Fixes https://github.com/bazelbuild/bazel/issues/13839
    
    Closes #16626.

New features:

  - The aquery and cquery commands now respect the --query_file flag
    just like the query command.

Important changes:

  - The new path variable `$(rlocationpath ...)` and its plural form
    `$(rlocationpaths ...)` can be used to expand labels to the paths
    accepted by the `Rlocation` function of runfiles libraries. This
    is the preferred way to access data dependencies at runtime and
    works on all platforms, even when runfiles are not enabled (e.g.,
    on Windows by default).
    
    Work towards #16124
    Fixes #10923
    
    Closes #16428.
  - Starlark `print()` statements are now emitted iff the line of
    code is executed. They are no longer replayed on subsequent
    invocations unless the Starlark code is re-executed.
    Additionally, multiple identical `print()` statements (same
    string from the same line of code, e.g. from a loop) are all
    emitted and no longer deduplicated.
  - Fixes a bug where some compilation flags would not be applied to
    a cc_test
  - Added a `native.package_relative_label()` function, which
    converts a label string to a Label object in the context of the
    calling package, in contrast to `Label()`, which does so in the
    context of the current .bzl file. Both functions now also accept
    relative labels such as `:foo`, and are idempotent.
  - Adds coverage metric support to android_local_test
  - Fixed an issue where WORKSPACE and WORKSPACE-loaded .bzl files
    couldn't see the Bzlmod root module's mappings when Bzlmod is
    enabled.
  - Added `native.module_name()` and `native.module_version()` to
    allow BUILD macro authors to acquire information about which
    Bazel module the current repo is associated with.
  - `@foo` labels can now be used on the command line as the
    top-level target (that is, `bazel build @foo` now works).
    Double-dot syntax is now forbidden (`bazel build ../foo` will no
    longer work).
  - Added preliminary support for a lockfile for Bzlmod. It's
    disabled by default; use `--lockfile_mode=update` to enable it.
    This lockfile contains only Bazel module information; it does not
    involve module extensions.
  - Added a new `max_compatibility_level` attribute to the
    `bazel_dep` directive, which allows version selection to upgrade
    a dependency up to the specified compatibility level.
    
    Co-authored-by: Brentley Jones <github@brentleyjones.com>
  - `--experimental_remote_grpc_log` has been renamed to
    `--remote_grpc_log`
    
    Closes #18180.

This release contains contributions from many people at Google, as well as Ben Lee, Brentley Jones, Ezekiel Warren, Fabian Meumertzheim, keertk, Keith Smiley, Krzysztof Naglik, kshyanashree, lunch-glide-pepper, oquenchil, Patrick Balestra, Son Luong Ngoc, Ted Kaplan, Ted Kaplan, UebelAndre, Xùdōng Yáng, Yannic, yuzhy8701.

## Release 7.0.0-pre.20230502.1 (2023-05-05)

```
Baseline: a0cd355347b57b17f28695a84af168f9fd200ba1
```

Important changes:

  - json.decode now takes an optional `default` positional parameter;
    if this parameter is specified and decoding fails, json.decode
    will return
    the `default` value instead of failing Starlark evaluation.

This release contains contributions from many people at Google, as well as Benjamin Peterson, David Ostrovsky, eareilg, Fabian Meumertzheim, Son Luong Ngoc.

## Release 7.0.0-pre.20230426.1 (2023-05-03)

```
Baseline: dc724e4e8041a9357c6b82af0749def4174f21f2
```

Important changes:

  - Added a new `max_compatibility_level` attribute to the
    `bazel_dep` directive, which allows version selection to upgrade
    a dependency up to the specified compatibility level.
  - `--experimental_remote_grpc_log` has been renamed to
    `--remote_grpc_log`
  - `--incompatible_remote_build_event_upload_respect_no_cache` is
    now a no-op.

This release contains contributions from many people at Google, as well as Benjamin Peterson, Brentley Jones, Fabian Meumertzheim, George Gensure, Kai Zhang, Oscar Garzon.

## Release 7.0.0-pre.20230420.2 (2023-04-27)

```
Baseline: 7fb50baaa00f92c6f009dcf1684427fc8fa1f301

Cherry picks:

   + 0ebf7bc8376f8ca9e865b81658c2f2b29aaf7f4d:
     Automated rollback of commit
     1acc7a843bf0996c26a1e3d74bb64514395b7e7f.
```

Incompatible changes:

  - Renamed PackageMetrics proto message to PackageLoadMetrics. The
    formats should be wire compatible.

This release contains contributions from many people at Google, as well as Ankit Agarwal, Benjamin Peterson, Fabian Meumertzheim, Jasper, Son Luong Ngoc, Xdng Yng.

## Release 7.0.0-pre.20230417.1 (2023-04-25)

```
Baseline: 0a47a1fb04efef598376d4ee7b383add1febcc6c
```

Incompatible changes:

  - Removing java_common.javac_jar Starlark call.
  - native.existing_rule now returns select values in a form that is
    accepted by rule instantiation. This is a breaking API change
    because there is some code that relies on the precise type
    returned, including brittle workarounds for this bug specifically
    and insufficiently flexible workarounds for other issues with the
    intersection of select and native.existing_rule.
  - flipped incompatible_use_toolchain_resolution_for_java_rules, see
    #7849
  - Query output=xml/proto/location for source files will now show
    the location of line 1 of the source file (as the new default)
    instead of its location in the BUILD file.
  - Specifying a target pattern underneath a directory specified by
    .bazelignore will now emit a warning, not an error.
  - Query `--order_output=auto` will now sort lexicographically.
    However, when `somepath` is used as a top level function (e.g.
    `query 'somepath(a, b)'`), it will continue to output in
    dependency order. If you do not want the lexicographical output
    ordering, specify another `--order_output` value (`no`, `deps` or
    `full`) based on what ordering you require.
  - In the build event stream,
    BuildMetrics.TargetMetrics.targets_loaded is no longer populated.
    Its value was always mostly meaningless.
    BuildMetrics.TargetMetrics.targets_configured and
    BuildMetrics.ActionSummary.actions_created now include configured
    aspect data.
  - //visibility:legacy_public has been removed.
  - Flip and remove incompatible_dont_collect_so_artifacts
    (https://github.com/bazelbuild/bazel/issues/13043).
  - Remove flag --experimental_no_product_name_out_symlink: it is
    always true.
  - The Starlark method generate_dsym in objc fragment has
    been deleted.  Please use the equivalent apple_generate_dsym in
    cpp
    fragment instead.
  - Native libraries in data attribute are not collected. See
    https://github.com/bazelbuild/bazel/issues/13550 for details
  - Enforce the `--profile` path to be absolute.
  - Enforce the --memory_profile path to be absolute.
  - JavaToolchainInfo.jvm_opt returns Depset instead of a list.
  - --apple_sdk has been deleted.  It is a no-op.
  - --bep_publish_used_heap_size_post_build is now a no-op and will
    be deleted in a future release. Use --memory_profile=/dev/null
    instead.
  - Flipped --incompatible_disallow_resource_jars (see
    https://github.com/bazelbuild/bazel/issues/13221).
  - Remove --bep_publish_used_heap_size_post_build
  - JSON trace profile: rename counter names.
  - Removed --action_graph from the dump command.
  - Remove `--{experimental_,}json_trace_compression` option.
  - Remove `--experimental_profile_cpu_usage`.
  - flipped --incompatible_java_common_parameters (see #12373)
  - this incompatible change breaks old instances of http_archive
    that specified netrc as an absolute path. It is unlikely there
    are many instances in the wild since the path would refer to a
    netrc file inside the external repository by absolute path.
    Migration should be straightforward.
  - genrule switched to use exec transition instead of host. This can
    break targets with hardcoded output paths. To avoid using
    hardcoded paths use make variables, see
    https://docs.bazel.build/versions/4.2.2/be/make-variables.html#pre
    defined_label_variables
  - this incompatible change breaks old instances of http_archive
    that specified netrc as an absolute path. It is unlikely there
    are many instances in the wild since...
  - Error Prone now checks for unused return values of additional
    methods on `java.lang.Object`, which can be disabled using
    `--javacopts=-Xep:ReturnValueIgnored:OFF`
  - Error Prone now checks for unused return values of additional
    methods on `java.lang.Object`, which can be disabled using
    `--javacopts=-Xep:ReturnValueIgnored:OFF`
  - The --incompatible_existing_rules_immutable_view flag has been
    flipped to true. See
    https://github.com/bazelbuild/bazel/issues/13907 for
    migration notes.
  - Split up the C++ archive from the C++ link action and set
    `CppArchive` as mnemonic.
  - workspace(managed_directories=) is not available anymore.
  - --legacy_important_outputs now has a default of false.
  - --legacy_important_outputs default reverted to true.
  - objc_library now requires CcInfo in its deps.  If this breaks
    you, add empty CcInfo() to your rule.
  - Flag --experimental_local_memory_estimate removed.
  - Added a new flag
    --incompatible_unambiguous_label_stringification, which causes
    labels in the main repo to stringify into unambiguous forms
    starting with an @. See
    https://github.com/bazelbuild/bazel/issues/15916 for more
    information.
  - analysis_test moved into testing.analysis_test
  - Flip incompatible_enable_cc_toolchain_resolution
    (https://github.com/bazelbuild/bazel/issues/7260)
  - (Rollback) Flip incompatible_enable_cc_toolchain_resolution
    (https://github.com/bazelbuild/bazel/issues/7260)
  - name parameter is removed from rule call
    (https://github.com/bazelbuild/bazel/issues/16301)
  - name parameter is removed from rule call
    (https://github.com/bazelbuild/bazel/issues/16301)
  - name parameter is removed from rule call
    (https://github.com/bazelbuild/bazel/issues/16301)
  - --incompatible_remote_downloader_send_all_headers is flipped to
    true. See #16356 for details.
  - GrpcRemoteDownloader only includes relevant headers instead of
    sending all credentials.
  - In package_group's `packages` attribute, the syntax "//..." now
    refers to all packages in the same repository as the package
    group, rather than all packages everywhere. The new item "public"
    can be used instead to obtain the old behavior. In `bazel query
    --output=proto` (and `--output=xml`), the `packages` attribute
    now serializes with the leading double slash included (for
    instance, `//foo/bar/...` instead of `foo/bar/...`). See also
    #16355, #16323, and #16391.
  - This has the side effect of changing the message on unsuccessful
    builds from
    ```
    FAILED: Build did NOT complete successfully (0 packages loaded)
    ```
    to
    ```
    ERROR: Build did NOT complete successfully
    ```
  - Bazel no longer increases the delay between progress updates when
    there is no cursor control.
  - This has the side effect of changing the message on unsuccessful
    builds from
    ```
    FAILED: Build did NOT complete successfully (0 packages loaded)
    ```
    to
    ```
    ERROR: Build did NOT complete successfully
    ```
  - the --experimental_async_execution flag is now a no-op.
  - --experimental_replay_action_out_err is not a no-op.
  - `cquery --output=files` also outputs source files.
  - `--incompatible_strict_conflict_checks` is flipped to true. See
    https://github.com/bazelbuild/bazel/issues/16729 for details.
  - `--incompatible_strict_conflict_checks` is flipped to true. See
    https://github.com/bazelbuild/bazel/issues/16729 for details.
  - `--incompatible_always_include_files_in_data` is flipped to true.
    See https://github.com/bazelbuild/bazel/issues/16654 for details.
  - This changes the behavior of Python version in exec/host
    configuration. Mitigation is to set Python version on the targets.
  - When multiple --deleted_packages options are passed on the
    command line, they will be concatenated instead of the latest one
    taking effect.
  - This has the side effect of changing the message on unsuccessful
    builds from
  - JSON profile: Use doubles instead of strings for counter series.
  - query --output=proto --order_output=deps now returns targets in
    topological order (previously there was no ordering).
  - --experimental_build_transitive_python_runfiles is flipped to
    false. See #16303 for details
  - --incompatible_python_disable_py2 is flipped to true. See #17293
    for details.
  - When remote cache evicts blobs, Bazel will exit with code 39.
  - `--features` only applies to targets built in the target
    configuration, and `--host_features` is used for the host / exec
    configuration (gated behind `--incompatible_use_host_features`)
  - `--incompatible_strict_conflict_checks` is flipped to true. See
    https://github.com/bazelbuild/bazel/issues/16729 for details.
  - Bazel's local CPU resource on Linux is now container aware. Use
    `--local_cpu_resources`, `--loading_phase_threads` or `--jobs` to
    override.
  - `copy_from_rule` is exec_groups is deprecated
    (https://github.com/bazelbuild/bazel/issues/17668).
  - --legacy_bazel_java_test is now a no-op
  - --legacy_bazel_java_test is now a no-op
  - --legacy_bazel_java_test is now a no-op
  - `--experimental_execution_graph_log` no longer exists. Current
    users that want local logs need to pass
    `--experimental_enable_execution_graph_log
    --experimental_execution_graph_log_path=/some/local/path`.
    Current users that want logs uploaded to BEP need to pass
    `--experimental_enable_execution_graph_log
    --experimental_stream_log_file_uploads`.
  - Remove 'darwin' as a CPU value, use 'darwin_x86_64' instead
  - Remove high priority workers functionality from blaze.

New features:

  - Args.add_all and Args.add_joined can now accept closures in
    map_each if explicitly enabled via allow_closure.
  - Add `--bes_header` flag to pass extra headers to the BES server.
  - Support local_repository in Bazel Registry's source.json file
  - The `aquery` and `cquery` commands now respect the
    `--query_file` flag just like the `query` command.

Important changes:

  - Flag --incompatible_objc_compile_info_migration is removed.  See
    #10854.
  - Flag --incompatible_objc_compile_info_migration is removed.  See
    #10854.
  - Flag --incompatible_objc_compile_info_migration is removed.  See
    #10854.
  - none
    PAIR=cmita
  - The --incompatible_load_python_rules_from_bzl flag is now a no-op.
  - Filter all (instead of just C++) source files for coverage output
    according to --instrumentation_filter and
    --instrument_test_targets.
  - The `--incompatible_disable_native_apple_binary_rule` flag has
    been added which disables the native `apple_binary` rule. Users
    who need to use `apple_binary` directly (if they cannot use one
    of the more specific Apple rules) should load it from
    https://github.com/bazelbuild/rules_apple.
  - The Android rules' --use_singlejar_apkbuilder is now a no-op.
    SingleJar will always be used to build APKs.
  - dict.setdefault(key, ...) now fails if dict is frozen, even if it
    already contains key. This is an incompatible API change.
  - Flag --incompatible_objc_provider_remove_compile_info is removed.
     See #11359.
  - Starlark now permits def statements to be nested (closures).
  - native.existing_rule now returns select values in a form that is
    accepted by rule instantiation. This is a breaking API change,
    though the fallout is expected to be small.
  - Starlark now supports lambda (anonymous function) expressions.
  - The "test" and "coverage" commands no longer return 3 when a
    test action fails because of a system error. Instead, the exit
    code
    reflects the type of system error.
  - The undocumented ctx.expand feature no longer exists.
  - Make --legacy_dynamic_scheduler a no-op flag.
  - Multiplex persistent workers can now use the JSON protocol.
  - native.existing_rule now returns a mutable list, not a tuple, for
    a list-valued attributes. This is an incompatible API change.
  - Roll back change to have native.existing_rules use list instead
    of tuple.
  - BEP includes test suite expansions.
  - config_setting now honors `visibility` attribute (and defaults to
    `//visibility:public`)
  - Change the MultiArchSplitTransitionProvider to be based on
    platform type + CPU instead of fixed "ios_" + cpu.
  - enforce config_setting visibility. See
    https://github.com/bazelbuild/bazel/issues/12932 for details.
  - add a flag to build v4 signature file
  - Added _direct_source_jars output group to Java related targets.
    END_PUBLIC
  - pkg_deb is no longer part of @bazel_tools//build_defs/pkg:pkg.bzl.
    Use https://github.com/bazelbuild/rules_pkg/tree/main/pkg instead
  - Allowing the lipo operations to be conditional in the
    linkMultiArchBinary API for Apple binaries. Single architecture
    slices are now returned through AppleBinaryOutput and the
    Starlark API.
  - Release restriction for "-" in the package name for Python
    sources. Now `py_binary` and `py_test` targets can have main
    source file with "-" in the path.
  - Users consuming BEP may assume that a `named_set_of_files` event
    will
    appear before any event referencing that `named_set` by ID. This
    allows consumers
    to process the files for such events (eg. `TargetCompleted`)
    immediately.
  - BEP includes all files from successful actions in requested
    output groups.
    Previously, an output group's files were excluded if any file in
    the output group
    was not produced due to a failing action. Users can expect BEP
    output to be larger
    for failed builds.
  - In BEP, TargetComplete.output_group has a new field `incomplete`
    indicating that the file_sets field is missing one or more
    declared artifacts
    whose generating actions failed.
  - The flag `--toolchain_resolution_debug` now takes a regex
    argument, which is used to check which toolchain types should
    have debug info printed. You may use `.*` as an argument to keep
    the current behavior of debugging every toolchain type.
  - Add runfiles.merge_all() for merging a sequence of runfiles
    objects.
  - runfiles.merge() and merge_all() now respect
    --nested_set_depth_limit.
    If you hit the depth limit because you were calling merge() in a
    loop, use
    merge_all() on a sequence of runfiles objects instead.
  - Bazel will no longer create a bazel-out symlink if
    --symlink_prefix is specified: the directory pointed to via the
    bazel-out symlink is accessible via ${symlink_prefix}-out. If
    this causes problems for you, set
    --experimental_no_product_name_out_symlink=false in your builds
    and file an issue.
  - Updates worker protocol with cancellation fields, and adds
    experimental_worker_cancellation flag to control cancellation.
  - Simplify build failure output by always using `NNN arguments`.
  - trim_test_configuration now defaults to on
  - Mark genrule.srcs as a source attribute for coverage.
  - When using --allow_analysis_failures (for example, via
    bazel-skylib's
    analysistest with `expect_failure = True`), analysis-time
    failures in aspect
    implementation functions will now be propagated and saved in
    AnalysisFailureInfo, just like analysis-time failures in rules.
  - cquery --noimplicit_deps now correctly filters out resolved
    cc_toolchains
  - Sign apks deterministically.
  - Make gcov optional in cc_toolchain tools.
  - If --experimental_prefer_mutual_xcode is passed, Bazel will
    choose the local default (instead of the newest mutually
    available version) if it's available both locally and remotely.
  - Remove java_lite_proto_library.strict_deps attribute.
  - Generate proguard configurations deterministically.
  - Adds a new flag, `--incompatible_enable_cc_test_feature` which
    switches from the use of build variables to the feature of the
    same name.
  - Dropped fragile xz support from built in pkg_tar. Users requiring
    xz
    compression should switch to bazlebuild/rules_pkg.
  - If all strategies of one branch (the local or remote execution
    branch) of the `dynamic` strategy fail to even accept (via the
    response they give from `canExec`) the action, `dynamic` will now
    try to see if the other branch can accept it. (Trying to run it
    and it failing will still cause a failure if it was the first
    result, this is about strategies claiming they can't even try the
    action)
  - Add `disable_annotation_processing` option to
    `java_common.compile`, which disables any annotation processors
    passed to `plugins` or in `exported_plugins` of `deps`
  - Remove obsolete --incompatible_prohibit_aapt1
  - The minimum Android build tools version for the Android rules is
    now 30.0.0
  - Adds --experimental_reuse_sandbox_directories flag to reuse
    already-created non-worker sandboxes with cleanup.
  - --experimental_force_gc_after_build is deprecated and will be
    removed soon. Use --bep_publish_used_heap_size_post_build instead
  - Forward coverage-instrumented files from non-tool dependencies by
    default.
  - The used_heap_size_post_build field in BEP is populated when the
    --memory_profile flag is set
  - --run_validations defaults to true.
  - Consider label_keyed_string_dict attributes when gathering
    instrumented files for coverage.
  - Remove flag
    --experimental_forward_instrumented_files_info_by_default, now
    that this behavior is the default.
  - When using MemoryProfiler with multiple GCs via the
    --memory_profile_stable_heap_parameters flag, we do a more
    precise calculation of heap used at the end of the build. This
    will generally result in lower values.
  - --bep_publish_used_heap_size_post_build is deprecated. Use
    --memory_profile=/dev/null instead.
  - Disable --all_incompatible_changes flag.
  - The --all_incompatible_changes flag is now a no-op
  - The `--toolchain_resolution_debug` flag now accepts regexes
    matching targets, as well as toolchain types, when choosing what
    debug messages to print.
  - Adds --experimental_existing_rules_immutable_view flag to make the
    native.existing_rule and native.existing_rules functions more
    efficient by
    returning immutable, lightweight dict-like view objects instead
    of mutable
    dicts.
  - Add support to length-delimited protos as undeclared output
    annotations []
  - The deprecated "relative_to_caller_repository" parameter has been
    removed from the Label constructor.
  - The toolchain transition is now enabled for all toolchains.
  - incompatible_disable_depset_items is flipped
  - The --experimental_existing_rules_immutable_view flag has been
    renamed to  --incompatible_existing_rules_immutable_view
  - Bazel no longer supports Java 8. From this version on, the
    minimum required JDK is OpenJDK 11.
  - Deprecate --incompatible_applicable_licenses flag, in preparation
    for removal in Bazel 6.x.
  - Treat py_*.srcs_version="PY2" the same as "PY2ONLY".
  - The Build Event Protocol now contains file digests and sizes
    along with the file name and URI.
  - Refactor system suspend event handling.
  - alias() can now select() directly on constraint_value()
  - Allow \a \b \f \v escape sequences in Starlark.
  - Match remote and local xcode version by most granular version.
  - Adds `--experimental_worker_multiplex_sandboxing` flag that
    controls whether to sandbox multiplex workers that support it.
  - provider() has a new parameter: init, a callback for performing
    pre-processing and validation of field values. Iff this parameter
    is set,
    provider() returns a tuple of 2 elements: the usual provider
    symbol (which,
    when called, invokes init) and a raw constructor (which bypasses
    init).
  - Tests that fail to create or complete their
    `TestAttemptContinuation` by
    throwing an `ExecException` will report an `INCOMPLETE` status.
    Previously, Bazel
    would fail to report any status for the test attempt.
  - Fixed an issue where Bazel could erroneously report a test passes
    in coverage mode without actually running the test.
  - Include more information about configurations in cquery proto
    formatted output. This deprecates the configuration field of
    AnalysisProtosV2.ConfiguredTarget, and adds a new field,
    configuration_id, to
    be used instead.
  - experimental cc_library.implementation_deps inverted to
    interface_deps
  - In aquery and cquery proto output, indicate if a configuration is
    a
    tool or non-tool configuration.
  - Include complete configurations in cquery proto output.
  - experimental cc_library.implementation_deps inverted to
    interface_deps
  - Make protocOpts() publicly accessible.
  - Add some documentation about how configuration information is
    conveyed in cquery proto output.
  - Introduces experimental static library linking API under
    apple_common.link_multi_arch_static_library
  - Further deprecation and removal of pkg_tar. Stop supporting
    legacy use of 'files' attribute, where it could be a list of
    labels instead of a map of paths to labels.
  - Removed --incompatible_no_build_defs_pkg flag. It never fulfilled
    its purpose because --all_incompatible_changes would never set
    it. The last rule it gated (pkg_tar) is scheduled to be removed
    in Bazel 6.x.
  - Add coverage configuration fragment, used to expose
    output_generator label.
  - Bazel now no longer includes system headers on macOS in coverage
    reports (#14969).
  - android_sdk_repository read $ANDROID_SDK_ROOT in addition to
    $ANDROID_HOME.
  - The default dexer is now d8. dx can be optionally enabled using:
      --define=android_dexmerger_tool=dx_dexmerger \
      --define=android_incremental_dexing_tool=dx_dexbuilder \
      --define=android_standalone_dexing_tool=dx_compat_dx \
      --use_workers_with_dexbuilder
  - Packaging support for deploy JAR embedded JDK files (hermetic
    Java).
  - Don't stamp cc_common.link actions for tool dependencies.
  - Starlark test rules can use the new inherited_environment
    parameter of testing.TestEnvironment to specify environment
    variables
    whose values should be inherited from the shell environment.
  - Enable merging permissions during Android manifest merging with
    the --merge_android_manifest_permissions flag.
  - Allow specialization to work with constraint_values.
  - Bazel uses the D8 jar from Maven instead of the SDK.
  - Make ijar / java_import preserve classes with `@kotlin.Metadata`
    annotations
  - Switch cc_test implementation to Starlark. Note: cc_test will now
    link statically when _targeting_ Windows regardless of host
    platform (rather than always linking statically when Windows is
    the _host_).
  - Switch cc_test implementation to Starlark. Note: cc_test will now
    link statically when _targeting_ Windows regardless of host
    platform (rather than always linking statically when Windows is
    the _host_).
  - Add devtools/build/lib/worker:work_request_handlers to the remote
    android tools release package. This will be transitively packaged
    into all_android_tools.
  - Bazel uses the D8 jar from Maven instead of the SDK.
  - android_sdk_repository read $ANDROID_SDK_ROOT in addition to
    $ANDROID_HOME.
  - Advance android_tools_pkg version to 0.24.0.
  - Switch cc_test implementation to Starlark. Note: cc_test will now
    link statically when _targeting_ Windows regardless of host
    platform (rather
    than always linking statically when Windows is the _host_).
  - Bazel uses the D8 jar from Maven instead of the SDK.
  - "blaze config" now only reports info from the last build. To
    compare configurations across multiple builds, redirect "blaze
    config" output to a file and run your favorite diff tool.
  - The --incompatible_override_toolchain_transition flag is now
    always set, and will be removed in the future. Thus,
    --noincompatible_override_toolchain_transition has no effect, and
    the value of the incompatible_use_toolchain_transition parameter
    in aspect() and rule() builtins is ignored.
  - Switch cc_test implementation to Starlark. Note: cc_test will now
    link statically when _targeting_ Windows regardless of host
    platform (rather
    than always linking statically when Windows is the _host_).
  - Toolchain types may now be optional, in addition to mandatory.
    See https://bazel.build/docs/toolchains#optional-toolchains for
    further details.
  - Add six to deps of has_services=1 py_proto_librarys.
  - pkg_tar(symlinks) has been removed. Users needing that feature
    should
    migrate to @rules_pkg.
  - Aspects can now define and use exec groups using the same API as
    rules.
  - Removed the obsolete --incompatible_applicable_licenses flag. The
    feature is permanently enabled.
  - embedded_tools packages R8 desugarer again
  - Bazel now selects sh path based on execution platform instead of
    host platform, making it possible to execute sh actions in
    multiplatform builds. --shell_executable now only applies to
    actions configured for host.
  - labels in genquery.scope are no longer configured.
  - When Bzlmod is enabled, all Bzlmod-generated repos will have an
    extra '@' prepended to their names. This effectively enables the
    canonical label literal syntax for Bzlmod-generated repos
    (`@@canonicalRepoName//pkg:target`; see
    https://docs.google.com/document/d/1N81qfCa8oskCk5LqTW-LNthy6EBrDo
    t7bdUsjz6JFC4/edit?usp=sharing).
  - Exposed `CcSharedLibraryInfo` to Starlark builtins.
  - Enable --use_top_level_targets_for_symlinks by default.
  - Singlejar accepts runtime Created-By field
  - --noincompatible_disable_managed_directories, and with that,
    workspace(managed_directories=) is not supported anymore.
  - Bazel supports D8 desugaring, albeit without persistent workers
  - Remove mtime options from pkg_tar. Users should migrate to
    @rules_pkg.
  - Test for experimental multiplexed persistent resource processor.
  - Added new register_{execution_platforms,toolchains} directives to
    the MODULE.bazel file, to replace the
    {execution_platforms,toolchains}_to_register attributes on the
    module() directive.
  - The legacy pkg_tar no longer supports the ability to untar and
    repackage an input tar file (`deps` attribute). Users needed that
    capability must switch to github.com/bazelbuild/rules_pkg.
  - `cquery`'s new output mode
    [`--output=files`](https://bazel.build/docs/cquery#files-output)
    lists the output files of the targets matching the query. It
    takes the current value of `--output_groups` into account.
  - Change singlejar metadata to report Created-By Bazel
  - Add support for fetching RPC credentials from credential helper.
  - Revert interface_deps back to implementation_deps after problem
    reported in. Use `buildozer 'rename deps implementation_deps'
    //...:%cc_library; buildozer 'rename interface_deps deps'
    //...:%cc_library`
  - Fix for desugaring failure on Bazel+Android+Windows build
    scenario.
  - D8 is the default desugarer
  - Migrate main_dex_list_creator to D8 (DX deprecation)
  - --experimental_enable_bzlmod has been renamed --enable_bzlmod,
    and still defaults to false.
  - selects() no longer produce irrelevant duplicate label checks
  - Adds a dexer output cache to CompatDexBuilder to improve build
    speed.
  - Improved error messages when analyzing inline bzl code
  - Improved error messages when analyzing inline bzl code
  - The `@bazel_tools//tools/cpp:compiler` flag now has the value
    `gcc` if the configured compiler is detected to be gcc rather
    than the generic value `compiler`. A branch for `gcc` may have to
    be added to `select` statements that do not have a default case
    that handles gcc appropriately.
  - The `get_child` method of `path` now accepts an arbitrary
    number of relative path strings as positional arguments.
  - SourceManifestAction supports `Action.content`
  - Add --incompatible_build_transitive_python_runfiles alias. See
    #16303
  - The @bazel_tools//tools/cpp:compiler flag now has the value
    `clang` for the auto-configured Xcode toolchain rather than the
    generic value compiler. A branch for `clang` may have to be added
    to select statements that do not have a default case that handles
    this toolchain appropriately.
  - added additional debug message to warn of skipped toolchains
    during resolution
  - The deprecated --remote_allow_symlink_upload flag has been
    removed. Symlinks in local action outputs are always permitted,
    even with remote caching. Whether they're uploaded as symlinks or
    as the files/directories they point to is still determined by the
    --incompatible_remote_symlinks flag.
  - Added `struct`, `json`, `proto`, and `depset` to the starlark
    environment of Bazel's cquery (--output=starlark) command
  - Added three `package_group`-related flags:
    `--incompatible_package_group_includes_double_slash` (#16391),
    `--incompatible_package_group_has_public_syntax` (#16355), and
    `--incompatible_fix_package_group_reporoot_syntax` (#16323). With
    these flags, `package_group` can now easily specify "all
    packages", "no packages", and "all packages in the current repo".
  - Record hermetic packaged JDK modules file size in deploy JAR
    manifest 'JDK-Lib-Modules-Size' attribute.
  - .bzl files may now set a visibility to guard what other .bzl and
    BUILD files may load them. See [...] for more information.
  - Deletes the --extra_proguard_specs Blaze flag
  - The new path variable `$(rlocationpath ...)` and its plural form
    `$(rlocationpaths ...)` can be used to expand labels to the paths
    accepted by the `Rlocation` function of runfiles libraries. This
    is the preferred way to access data dependencies at runtime and
    works on all platforms, even when runfiles are not enabled (e.g.,
    on Windows by default).
  - Starlark `print()` statements are now emitted iff the line of
    code is executed. They are no longer replayed on subsequent
    invocations unless the Starlark code is re-executed.
    Additionally, multiple identical `print()` statements (same
    string from the same line of code, e.g. from a loop) are all
    emitted and no longer deduplicated.
  - Fixes a bug where some compilation flags would not be applied to
    a cc_test
  - removed outdated ctx.host_fragments
  - removed outdated ctx.host_configuration
  - Now that the host configuration is finished, `genrule` should
    prefer the use of `tools` and stop using `exec_tools`.
  - Added a `native.package_relative_label()` function, which
    converts a label string to a Label object in the context of the
    calling package, in contrast to `Label()`, which does so in the
    context of the current .bzl file. Both functions now also accept
    relative labels such as `:foo`, and are idempotent.
  - Update Android manifest merger to v30.1.3, and also drop support
    for legacy (pre-D8) desugaring.
  - Adds coverage metric support to android_local_test
  - Correctly encode double value positive infinity as "inf" instead
    of "+inf" for textprotos.
  - Add --use_target_platform_for_tests which uses the target
    platform for executing tests instead of the execution platform.
  - Custom C++ rules on Windows calling
    cc_common.create_linking_context_from_compilation_outputs should
    review whether each target of the rule type should produce a
    dynamic library since a condition which blocked their creation
    has been moved to the rules from behind the API.
  - Add flag `--experimental_remote_cache_ttl` and set the default
    value to 3 hours.
  - making --incompatible_use_platforms_repo_for_constraints do
    nothing. Using constraints from @bazel_tools//platforms with or
    without the flag will throw error with message "Constraints from
    @bazel_tools//platforms have been removed. Please use constraints
    from @platforms repository embedded in Bazel, or preferably
    declare dependency on https://github.com/bazelbuild/platforms"
  - Fixed an issue where WORKSPACE and WORKSPACE-loaded .bzl files
    couldn't see the Bzlmod root module's mappings when Bzlmod is
    enabled.
  - Subsequent settings of --extra_execution_platforms now override
    previous settings, instead of adding them to a list. If you
    currently set --extra_execution_platforms more than once, please
    migrate by passing a list of values to
    --extra_execution_platforms instead so that earlier values aren't
    overwritten.
  - @bazel_tools//config:common_settings.bzl has been removed.
    Use @bazel_skylib//rules:common_settings.bzl instead.
  - cc_shared_library is no longer experimental, see
    https://github.com/bazelbuild/bazel/issues/16709 for details
  - The flag `--distinct_host_configuration` is removed. It has been
    a no-op since Bazel 6.0.0.
  - Added `native.module_name()` and `native.module_version()` to
    allow BUILD macro authors to acquire information about which
    Bazel module the current repo is associated with.
  - Add `--skip_incompatible_explicit_targets` option
  - Remove 'darwin' as a CPU value, use 'darwin_x86_64' instead
  - cc_test can now be configured by using a native.toolchain().
  - `@foo` labels can now be used on the command line as the
    top-level target (that is, `bazel build @foo` now works).
    Double-dot syntax is now forbidden (`bazel build ../foo` will no
    longer work).
  - The location of rules that explicitly specify `generator_name`
    and/or `generator_function` attributes (typically because they
    are incidentally copied from `native.existing_rule()`) is now the
    top-level call in the `BUILD` file, which is consistent with
    rules that do not explicitly specify these attributes.
  - Warnings (most notably those associated with the `deprecation`
    rule attribute) are no longer replayed on subsequent invocations
    unless the target in question is re-analyzed. Warnings are purely
    informational, so this change has no bearing on the correctness
    of the build. Downstream tests that break due to this change
    should update their expectations.
  - `--experimental_remote_build_event_upload` has been renamed to
    `--remote_build_event_upload`
  - [Breaking change] platform, constraint_setting, and
    constraint_value can no longer take an applicable_licenses value.
    Remediation is to remove the attribute and rely on the package
    level default.
  - `--experimental_action_cache_store_output_metadata` has been
    renamed to `--action_cache_store_output_metadata`
  - Changed the default value for `--remote_build_event_upload` to
    `minimal`.
  - `--experimental_remote_cache_compression` has been renamed to
    `--remote_cache_compression`
  - The REPO.bazel and MODULE.bazel files are now also considered
    workspace boundary markers.

This release contains contributions from many people at Google, as well as Adam Azarchs, Adam Lavin, Adam Liddell, Adam Singer, Adam Wolf, Albert Lloveras, Alessandro Patti, Alex Eagle, Alex Eagle, Alex Eagle, Alex Scott, AlexTereshenkov, Alex Torok, Amanda L Martin, Andreas Fuchs, Andreas Herrmann, Andreas Herrmann, Andrew Katson, Andrew Klotz, Andy Hamon, Ankush Goyal, Anthony Pratti, Anthony Ter-Saakov, Ara Nguyen, Artem V. Navrotskiy, Artem Zinnatullin, arunkumar9t2, arun.sampathkumar, aryeh, Ast-x64, Austin Schuh, Benedek Thaler, Benjamin Lee, Benjamin Peterson, Benjamin Peterson, Benjamin Sigonneau, Ben Lee, Bohdan Vanieiev, Bo Zhang, Bo Zhang, Bradley Burns, Brandon Duffany, Brandon Jacklyn, Brentley Jones, Brentley Jones, bromano, Cameron Mulhern, Chad Miller, Charles-Francois Natali, Chirag Ramani, Chris Clearwater, Chris Fredrickson, Christopher Peterson Sauer, Christopher Rydell, Christopher Sauer, ckiffel, Cristian Hancila, crydell-ericsson, Dan Bamikiya, Dan Fleming, Daniel Grunwald, Daniel KT, Daniel McCarney, Daniel Wagner-Hall, Danny Wolf, Dave MacLachlan, Dave Nicponski, David Cummings, David, David Ostrovsky, David Sanderson, Delwin9999, Denys Kurylenko, dhmemi, Dimi Shahbaz, divanorama, dmaclach, Dmitry Ivankov, dorranh, ecngtng, Ed Schouten, Eitan Adler, Elliotte Rusty Harold, Emil Kattainen, erenon, Eric Cousineau, Eric Song, Eric Wendelin, Ethan Steinberg, Ezekiel Warren, Fabian Brandstetter, Fabian Meumertzheim, Fabian Meumertzheim, FaBrand, Fahrzin Hemmati, Fahrzin Hemmati, Felix Ehrenpfort, Finn Ball, floriographygoth, frazze-jobb, Fredrik Medley, Garrett Holmstrom, Gaspare Vitta, Gautam Korlam, George Gensure, George Prekas, gkgoat1, gkorlam, goodspark, Greg Estren, Greg, Greg Magolan, Gregory Fong, Greg Roodt, Grzegorz Lukasik, Grzegorz Lukasik, Halil Sener, Halil Sener, Hannes Kufler, Hao Yuan, homuler, hvadehra, hvd, Igor Nazarenko, Ikko Ashimine, Jack Dai, James Broadhead, James Ma, Jan, Jason Tan, Jay Bazuzi, Jeremy Volkman, Jesse Chan, jheaff1, Jiawen Chen, Joe Lencioni, Joel Jeske, Joel Williamson, Johannes Abt, John Hinnegan, John Laxson, John Laxson, John Millikin, Jonathan Gerrish, Jonathan Schear, Jon Landis, Jon Parise, jonrose-dev, Jon Shea, Jordan, juanchoviedo, Julio Merino, Justus Tumacder, Kaiqin Chen, keertk, Keith Smiley, kekxv, Ken Micklas, Kevin Hogeland, Kevin Lin, Kirill Zabelin, Kiron, Konstantin Erman, Krishna Ersson, Krzysztof Naglik, kshyanashree, Kun-Lu, Lauri Peltonen, Lee Mracek, lihu, Liu Liu, lripoche, Lszl Csomor, Luc Bertrand, Luis Fernando Pino Duque, m, Malte Poll, Marc Zych, Marc Zych, Marek uppa, Mark Karpov, Masoud Koleini, Mathieu Olivari, Matt Clarkson, Matt Mackay, Mauricio Galindo, Max Liu, Maxwell Elliott, Menny Even Danan, menny, Michael Chinen, Michael P. Nitowski, Mikhail Balabin, mohamadk, Mostyn Bramley-Moore, Nathaniel Brough, nathyong, Nick Korostelev, Niek Peeters, Nikolay Shelukhin, Nitesh Anandan, Niyas Sait, Noa Resare, odisseus, Oleh Stolyar, Olek Wojnar, Oliver Lee, Olle Lundberg, Omar Zuniga, Oscar Bonilla, Patrick Balestra, Patrick Balestra, Paul Gschwendtner, Paul Tarjan, Peter Kasting, Peter Mounce, Philipp Schrader, Pras Velagapudi, Qais Patankar, Rabi Shanker Guha, Rahul Butani, Rai, Rajeshwar Reddy T, Red Daly, redwrasse, Rifqi Mulya Fahmi, robincaloudis, Robin Tweedie, Roger Hu, Roman Salvador, ron-stripe, rustberry, Ryan Beasley, Ryan Schmidt, Sagar Pathare, Sahin Yort, Saleem Abdulrasool, samhowes, Samuel Giddins, Sara Adams, Sascha Moecker, Sebastian Olsson, Sergey Tyurin, Severin Strobl, Shuai Zhang, Siddhesh Bhupendra Kuakde, Simon Bjorklen, Simon Mavi Stewart, something_vague, Son Luong Ngoc, Stephan Wolski, Steve Siano, steve-the-bayesian, Steve Vermeulen, Stiopa Koltsov, susinmotion, Sven Tiffe, Takeo Sawada, Tao Wang, tatiana, tbaing, Ted Kaplan, Ted Kaplan, Tetsuo Kiso, Thaler Benedek, Thi Doan, Thi Doan, Thi Don, Thomas Carmet, Thomas Chen, ThomasCJY, Thomas, Thomas Zayouna, Thulio Ferraz Assis, Timothe Peignier, Timothy Klim, Tobi, Tomas Volf, Tom Cnops, Tom de Goede, Torgil Svensson, Trustin Lee, Ulf Adams, Ulf Adams, Ulrik Falklof, Uri Baghin, Vaidas Pilkauskas, vardaro, Vasilios Pantazopoulos, Vertexwahn, Vladimir Tagakov, Waleed Khan, William Muir, wisechengyi, Wren Turkal, Xavier Bonaventura, Xdng Yng, Xiangquan Xiao, Yannic Bonenberger, Yannic Bonenberger, Yannic, Yannic, Yesudeep Mangalapilly, Yi Cheng, Yury Evtikhov, Yuval Kaplan, Yuval K, Yuval, yuzhy8701, Zhongpeng Lin, [zqzzq].

## Release 4.2.4 (2023-04-20)

```
Baseline: 37a429ad12b4c9e6a62dbae4881a1ff03b81ab40

Cherry picks:

   + a689d673abadf80f1efaf8ddaeee92d56fc2847b:
     Use getRunfilesPath for run_under executable path generation.
     getRootRelativePath doesn't return a valid runfiles path for
     external source files anymore after the recent external source
     root change. Also, it won't work for external labels either once
     the --nolegacy_external_runfiles becomes default. This fixes
     issue #12545.
   + d90ec67fdab9710f649a3c1d374fb6b938b9271a:
     Fix NPE when coveragerunner is not set on the toolchain.
   + 8555789dd239a5ac229c1d9cee80b2a9f30b3bf7:
     Fix the classic query package-loading cutoff optimization with
     external workspaces.
   + d113d7454127bba78aa618dac81e5d164920b662:
     Update turbine
   + 1489f0f4cae3e9247a70e4003ab76bef45c5b986:
     Support Scala3 .tasty files
   + 0d2d95cd7e34b4061c8e5fdfd21ba0ab8818c685:
     Update to java_tools javac11 release 10.5 (#12647)
   + a9419f38d5f29af31a6c8ebda09a6e0303a6ba54:
     Fix common prefix for instrumentation filter
   + 84fadcf81f81b2d7343ca4151a5639be7f2263ee:
     Fix builds for filegroup targets with incompatible dependencies
   + e43825d0bef359f645e1cabf2164fd2db6ee4a35:
     Revert "Remove
     --incompatible_blacklisted_protos_requires_proto_info"
   + 082d58de852ebaa640bcf13cf419cbb94eec2b26:
     Transform roots along with paths during output deletion.
   + e8835c1c221d76a2d5532d18083eaa04401619b3:
     AttributeContainer.Large now handles more than 127 attributes.
   + e1e87349335ac59f9b3df47cee8b999faeaa6d11:
     Add an env attribute to all test and binary rule classes
   + a87d7ed2411d5382bac58a20b79e09c464ad13b9:
     Take no action to prefetch empty artifacts.
   + 3e969ff24a6a0e03139b9f288c88451a7dfa97cd:
     Fix a couple of bugs with Incompatible Target Skipping
   + e6670825b1e183f81f5c864aafd425d512fa9ff5:
     Pass --host_action_env to host options hostActionEnvironment
     attribute
   + 07400c0392e7be163f8a3396fa5cf89ce6705412:
     Add --{no,}autodetect_server_javabase.
   + c83366064621d5a265eba14d93a03deff58fe6d8:
     Only treat "env" and "env_inherit" attrs specially for native
     rules
   + 6a60b30cd0f22d0ab84b2ddd658d5ccb899a8a76:
     Fix coverage support when using default_java_toolchain. (#12801)
   + 4158a6f512e52516437e00f8d9609a91be7fc195:
     Revert JacocoCoverage target to remote_java_tools_java_import
     and add a new target for remore_java_tools_filegroup. (#12813)
   + f6d30cf5ef9a8a39fea7072317f89a872387b790:
     Add windows_msvc back to conditions in bazel_tools.
   + 6b33bdb1e22514304c0e35ce8e067f2175685245:
     Release 4.0.0 (2021-01-21)
   + 8811e27353c2c10980faf7e4c5e44b431d2d4f1c:
     Fix error message from getPrerequisites to not print internal
     details.
   + 27e15ad11410eb1014f5247fd0eeb31a46733c07:
     Clean up ConfiguredTargetValueAccessor and
     ConfiguredTargetAccessor
   + e87feb8ac9573cef993824f82370d0389570521d:
     Move getConfigConditions into ConfiguredTarget.
   + 34d98234324da83e93ba0d5ef5702880d5ac7c5c:
     Change ConfiguredTargetQuery to use KeyedConfiguredTarget as a
     value.
   + 079bb7d69931705bb2b092c9017090e224ef3043:
     Clean up old dependencies that are unused since
     https://github.com/bazelbuild/bazel/commit/34d98234324da83e93ba0d
     5ef5702880d5ac7c5c.
   + e03cb63e059420847d6578d7cbfe93f05615c95e:
     Update bazelbuild/platforms to a current release. - Roll forward
     https://github.com/bazelbuild/bazel/commit/0a4533420a3de467fd211d
     7f925cf88e0cd5b76a  with kythe fix.
   + 2eb1bf53d5fef13b89ee440af4f83003d1d0b50a:
     Update docs and tests to use the @platforms//:incompatible
     constraint
   + c71697cf33b0fbbb42fc2910bac83960edc7e855:
     Clarify test_suite behaviour in the Platforms docs
   + dfb70ea4cae2ffffb76e9741d86c96505a6d05ad:
     Enable toolchain resolution for filegroup targets.
   + 24d086446f74606819dc53c3a436caa056ff05b7:
     PlatformProviderUtils should ignore targets that don't have the
     needed
   + ba60c0b3f9bbd00975c984244839b155e84b4c5d:
     ijar: fix manifest sections handling
   + 58bb42ad7ca263a75c6eeef51482f805726663a5:
     Revert "Switch to -fdebug-compilation-dir"
   + bef4bbbb47d47befe3711d06f358782ee12554f9:
     Update turbine
   + ad241fbebd90a9f0ad65ccd0658838f57030db68:
     Allow cquery to filter out incompatible targets
   + 1782f0ae751569607ef88930c822ac460a1f8bb3:
     Patch grpc to fix cares selecting the wrong source when building
     for darwin_arm64 cpu.
   + 8f7bc2f67fafcaa8d25cfc77eaaedbf8eed2984a:
     [1/3] Bump grpc to 1.33.1 to fix corruption when downloading CAS
     blobs
   + 848a51747a460ab4c5185e4c61ab522a9981cbea:
     [2/3] Bump grpc to 1.33.1 to fix corruption when downloading CAS
     blobs
   + 9b30172547f2093acb56aedf159a77d5dceffda2:
     [3/3] Bump grpc to 1.33.1 to fix corruption when downloading CAS
     blobs
   + 1e258d2a7a5221613047e5cee0aaec5b56045d2b:
     Allow exec groups to inherit from the rule or other exec groups.
   + d0676693310215407224c1b8e8aea9e3eddc183d:
     Support execution constraints per exec group
   + f1e0d346c8235c855e61afc2adb870e4b895e002:
     Clean up RuleContext to use a Table instead of a Map of Maps.
   + 8186fbb47ab964a9affa9a0fc6315fcdbde2b5aa:
     Documentation for #13110
   + 321fe3b6b4e892821ee7dbf2d17dd8ae6a541913:
     Prevent --repo_env from triggering unnecessary fetches
   + 3ebf658cba43bbab1efc36518f0795a7d65e2d46:
     Prevent a crash when using --repo_env=VAR without a value
   + 913a985a5c2fc3842b12c6e5f29af0fa1bccfd6a:
     Report digest of failed uploads
   + 5122617b8a22fee7acd86c9c48f2c2737709ca3f:
     Status error presentation with details
   + 9a70805db543e2fb910e1c55ef3b3567362adf30:
     Fix double shutdown of BuildEventArtifactUploader when BES+File
     output enabled.
   + 325eb956c92530bdfda54a36a186cae4245a4f7b:
     Add rxjava3 to third_party
   + ceaac966a7b977461b69ce9501df6a467f4a93b2:
     remote: set executable bit of an input file based on its real
     value
   + 5b786da75837c5e29714e1d708c3cdf9a67ed32d:
     Remote: correctly implement equals and hashCode.
   + 48648503729d53fdee1322fde2c8e6c05e99cff9:
     Fixed an error that bazel binary is not executable when testing
     with remote execution.
   + bc54c648aa1f99509c7c36d5e6b570d066689209:
     Remote: Use parameters instead of thread-local storage to
     provide tracing metadata.
   + 92955e617b5c41713a5163dc0437c2a024b31815:
     Remote: Use parameters instead of thread-local storage to
     provide tracing metadata. (Part 2)
   + 75bd1ff8ab56d241916bde36291301fa026b2bab:
     Remote: Use parameters instead of thread-local storage to
     provide tracing metadata. (Part 3)
   + 37ee252f3744abc4511f55b5089cc52abd3ba09d:
     Remote: Use parameters instead of thread-local storage to
     provide tracing metadata. (Part 4)
   + 71e35b165f924e2649a078fcf6007645d58039af:
     Remote: Use parameters instead of thread-local storage to
     provide tracing metadata. (Part 5)
   + 32fc451600b6e94a015263eb1c8a63e974f6f4cc:
     Write/QueryWriteStatus logging refinement/addition
   + 97963c5bb24ac79eb3646dd61bfcf2f8a648af54:
     Remote: gRPC load balancing. (Part 1)
   + e2b9a42a61596b0d24f0cadd6b7157b7f1efb221:
     Remote: gRPC load balancing. (Part 2)
   + 6667ad7dd77f8d97952133052c17e7779c1430ec:
     Remote: gRPC load balancing. (Part 3)
   + 7c081eb020186bfb16d4ef1c3832a8e946e99da1:
     Remote: gRPC load balancing. (Part 4)
   + 17afbe4e224b359fee6415a5bd71bbedaa7843eb:
     Implement getMessage for BulkTransferException
   + a6293b3df521aea9075b2ebbcdb675a7d02d3c32:
     Remote: gRPC load balancing. (Part 5)
   + 7a62c2d4e27e398f440910c81eacc384f38ca8be:
     Remote: Add interoperability between Rx and ListenableFuture.
   + 1fcb18a0b455bfcb8e9940778f37d8c82c5ed5a0:
     Update to latest remote-execution proto
   + dad96301d12aa77eb67399e08265a5f30f5ffd6a:
     Set Platform on Action not just Command
   + 6c5a3ee0dcbb4b804f4aa85c038a378fb70eb1f9:
     Remote: Add AsyncTaskCache which is used to deduplicate task
     executions and cache the results.
   + 9d0c7325ac810febe565a62fdd875ae0c240b274:
     Remote: Use AsyncTaskCache inside RemoteActionInputFetcher.
   + f54fe07209acc25340df8d2e02993b1add2deafa:
     Add --experimental_repository_disable_download to allow users
     disable download for external repos
   + b243584a479eb4481a9bf4f69acc899610a3b630:
     Report errors parsing rewriter config file
   + 63bc1c7d0853dc187e4b96a490d733fb29f79664:
     Downloader rewriter config has all_blocked_message
   + 495ac923f398443be45c20ab29d183fe47e08911:
     Allow UrlRewriter to change protocol, i.e. https->http, and
     http->https
   + 8dbbde0037264c1db4b229a09f98a61ab4ca06b0:
     Allow overriding the hostname and instance name in bytestream://
     URIs
   + 0881c80d29acecdfbb58c49156f805e8c50db117:
     Don't set requestId on non-multiplex requests.
   + e3b7e17b05f13ff183a4d7efec8ec797f3f5eaa3:
     When generating a symlink in _virtual_includes, add the original
     header to the 'allowed to use' set too
   + f8f66f36ad299a0ea019c94100d5a8e2018f5ab5:
     Make SimpleLogHandler not swallow interrupts.
   + f8606e5e76579442a1c6563e718ea54c673f1a04:
     linux-sandbox: don't assume -lrt, -D__STDC_FORMAT_MACROS
   + dac0d40d0eb903f5cb70341398d1a333c19adf3a:
     Improve "Common Attributes" section
   + a607d9dc70ac67f1aa2c32ca954177f9c77860be:
     Never create more than one process per WorkerMultiplexer.
   + 80c03ef14a1842d1e3475b1adf98adeb05df33f9:
     Move sending requests and reading responses for multiplex
     workers into separate subthreads.
   + 003cfcde3fd3901c1279ba1db3db3a14536248b4:
     Allow use of JSON protocol in multiplex workers.
   + 308bce36cba46095fe41866e703710035ddddada:
     Actively kill off still-active workers when stopping work on
     interrupt.
   + 8959dff512fe4505af786bcf2ef981ec7082a913:
     Add sanitizer support to Apple platforms
   + 32f16e9360f3e1856db1775eb5014b930da2a303:
     Fix a Google-internal broken link.
   + c9e2be52a067dd9abf5efa4f5f55bb5b98cf5d3b:
     Add SHA-1 to subresource integrity format for download()
     checksums
   + 3b3e6424c6fbd51d4c4ebb6aa25f1d1f4720221c:
     Remove fallback strategy support for workers, add flag for it in
     sandbox.
   + 3457f2ae11e4543de0a5e6e8e37c3aff067891fd:
     Update to java_tools javac11 10.6 (#13245)
   + 4928295b236ec8f590a7e9d863502bc2f50a77d9:
     Allow .S files in C++ Starlark cc_common.compile.
   + 1b18d65227c127fe946d3fcde4586158bc7e5fcb:
     Automatic code cleanup.
   + b5d6c38535c7f6f1eab3fd4c8d3d2da91d0b0f8a:
     Change short output of worker type to have the same logic as the
     worker creation for sandboxing vs. multiplex.
   + e7a0a71f50b69df5d38a8a85fefd36d211e12e8d:
     More properly destroy workers on interrupt.
   + 7056711eb11b672133274eb29fc93b01dcf088d5:
     Make WorkRequestHandler do a GC after some amount of CPU time
     has been used on requests. For Bazel and Blaze, defaults to 10s
     based on benchmarking.
   + 596653d3cf76e7b208da343e1fde5fe20273a5ff:
     Allow tree artifacts to be source or header inputs to
     cc_common.compile()
   + 055c93d11ab20cc4479539b24bbdfa5cab78a342:
     Switch to path autocompletion after -- for bazel run commands.
   + 807f2a1929e23b60b237c63fadb25af81de2e3c3:
     Fix Incompatible Target Skipping for test args
   + 9a5cd854e0613f91d52075973e2454b1e009e1ef:
     Fix order of build request id and command id
   + 706f5acd02363e48076dc97e37613fd968932d03:
     Fix bazel crash when passing config_setting to
     target_compatible_with
   + 61da1d2bf10eabba4c75de959b0374f302d89d70:
     Support multiple --bazelrc on command line
   + 5593358a58b66f06c4e421bb48856de94c3fd625:
     Update ConfiguredTargetFunction.computeUnloadedToolchainContexts
     to
   + 662cf54de7a103db30e04ebae2d2b919437c4846:
     Remote: Fix an issue that a failed action could lead to
     RuntimeException caused by InterruptedException thrown when
     acquiring gRPC connections.
     https://github.com/bazelbuild/bazel/issues/13239
   + a3a1763212f29932618b9b9b2f929976ae0e3b6e:
     Pass more `--add-exports=` flags
   + d2b942879471786e82f1c96eea8722bbe7919fc1:
     Remote: Fixed a bug that remote cache is missed due to
     executable bit is changed
   + 616dc264f02907d7b7887285d22307dfe6d097b6:
     Fix Bazel Coverage with C++ to work with Remote Execution
   + 5f40d12e741aa30d506eaa15673fb2ae76d29468:
     Fix external_path_test with newer Xcode versions.
   + b416193075642017e13c774422b49cb07fb65c23:
     Allow using embedded tools in sandboxed spawn runners.
   + eb762d4e7431637e607146b1c191485795047ef9:
     Fix racy write of temporary files while staging virtual inputs
     for the sandbox.
   + f31e86768579ad7ec57ba13f4c3c1348f5c2702e:
     Update platforms_test to not rely on filegroup not using
     toolchain
   + 13031e5b3bd7c8f29b96b2fee1b380160e0e27fc:
     Update SkyframeTests to not rely on filegroup not using toolchain
   + 11651824a9d0ffb9adb9611dcd39f4c95a59d750:
     Update ConfigurableAttributesTest to not rely on filegroup not
     using …
   + 4b68532e7ea5eb80c926b7b8e2ec2be300004628:
     Make WorkerExecRoot not be a subclass of SandboxedSpawn.
   + 31db460a45767de0bcd664a6efbe9d163b85b802:
     Make WorkerExecRoot not be re-created on each createFileSystem()
     call. Preparation for holding a map of existing links, but also
     just nicer.
   + a2cc0460dc84ad2dc88019af2fe2a65ce80c61e5:
     Start the file existence check traversal from the execroot base
     instead of execroot so that external repo files at
     "<execroot>/../<path>" are correctly handled when the sibling
     repository layout is enabled.
   + b048282c7893231d3a7191b251804973917b07a4:
     Use readdir for cleanExisting in WorkerExecRoot.
   + 270f00dd01fa06cf3e813da5a406be3446de7377:
     Add native support for Apple Silicon
   + 8e56b9423e8ad2f7323fb90b19b73858def81e39:
     Explicitly state that embedding macOS OpenJDK is for x86_64
   + 09c621e4cf5b968f4c6cdf905ab142d5961f9ddc:
     Remote: Fix a race that AsyncTaskCache#Execution could be reused
     after disposed which results in
     CancellationException("disposed") propagated to downstream.
   + 0299cd7e17203a4ce0ea947b62a7c55f1afb8225:
     Remove wrapped_clang params files after use
   + 47edc57806056f3c8764241ed41b8acc72bd2ebf:
     Silence swiftmodule timestamp warnings
   + f6e1074b09ebefba185c0531e9cea26b9596c8a9:
     Remote: Use shutdownNow() instead of shutdown() in
     ChannelConnection#close() as a workaround to a gRPC bug.
   + 71be4ea9e3d20bf90129e34a6a2899fe8401be36:
     And mnemonic and label to remote metadata
   + 615e1b16a81b0defc15699ec8027d6ddd70366d1:
     Change `set -x` in coverage to be set by var
   + fe4daea99c8cd163793eca84bfb12c8fc437616b:
     Bump minimal JDK install base maximum size from 290 to 295 MB.
   + 4840a68cd273a429e46d4114a3973fd11d0e3583:
     Remote: Check the return value of ActionOwner.getLabel() since
     it could be `null`.
   + 14abe4fd7c3967686a3536939fdc3882e691bca2:
     Allow `DiffAwareness` to share precomputed information about the
     workspace and propagate it to the `WorkspaceStatusAction`.
   + 082d98772690946ed29c157e60640c97a6e1195b:
     Implement available() method for Windows subprocesses.
   + c2bdd034014f66ce14529cc353cda18a32320f6c:
     Move --repo_env to common options
   + e09f2743738044095b9d784ea62df16b7f5750e6:
     Revert "Documentation for #13110"
   + a165baa250652fdc865ae0df39160be1f7f74c47:
     Revert "Clean up RuleContext to use a Table instead of a Map of
     Maps."
   + 51fb9e13a864f4f704ae378ea632433bae7ddc31:
     Revert "Support execution constraints per exec group"
   + cb6e5c24b82e0e20a243145fb6ea32b09e3d1de3:
     Revert "Allow exec groups to inherit from the rule or other exec
     groups."
   + 2ac6581aeaab33ba506fce96dfa6a75eaa819233:
     Release 4.1.0 (2021-05-21)
   + 7a0f36e3f0a21fed8857efbaa51ded2dbdeefab6:
     Change gceMachineType of highcpu platform from n1-highcpu-32 to
     e2-highcpu-32
   + 19491a91143f0c6132aca62c5ae40ab72e9dc0e2:
     Fix #10127: Remove Python 2 dependency from tools/android.
   + 80c59dea59d4dce39d4b5d21665c3d7313197358:
     fix main repo starlark options parsing - now flags passed on the
     command line as --@main_workspace//flag and --//flag will both
     parse to --//flag. Before this CL, the former maintained its
     workspace prefix and we would get different entries for these
     two formats.
   + 451b296c3aceb127ebb4a313b6e9608854fa68fa:
     Update threshold for long path shortening to be MAX_PATH - 4
   + 671e0489a5bd6d5abb4dcd9bcfc85134cee38385:
     Force source files to be readable before copying them from
     sandbox.
   + 6080c1e07f4229ea72eacd04faa9302e44955a84:
     Let workers finish lost races without delaying dynamic execution.
   + ee738dacb5d0089d3f57b15305057cb9ba675e74:
     Fix label_flag and label_setting to not have a dependency on the
     default
   + 74de0ba4e79341c77b8b85ff4485f92287b6854c:
     Java coverage: fix handling of external files
   + 48eee8b4b447a2ad11df28dd81a2ccb65562b5f5:
     [Bazel] Fix mobile-install for python2
   + 763dd0ce6e1644bf895231432f616427a11d385a:
     Add `stub_shebang` to `py_runtime`
   + b2231c56d78c6d37bcb6f11e1e50fe68ee336b4a:
     Move use of legacy sandbox -> local fallback to only be used
     after all strategies have been tried, and improve messages
     around it.
   + 6dc941e58dfc1d4a9714a76b921fbe11fce658ed:
     Remove restriction on generate_pdb_file to be only used in dbg
     and fastbuild mode
   + 5b95d9162b56b51c8e8f66258981ddf3c5d96765:
     Check the result of Future.cancel() when cancelling the other
     branch of dynamic execution.
   + aaae8ce2881c8c1a5d4ad64f20d6e71aa372cf2e:
     Update DEFAULT_MACOS_CPU to match host
   + 2f0927a4fd9342f4dcfd43475d3f1c90c523584f:
     Fix symlink creation on older Windows versions
   + fd9cffdcaf05551126e66f1cd62815eaa1af6bd9:
     Suppress interrupted status during pool closure
   + 33903d28bcea0005adf9b2a8cc4659c5e2999bbe:
     Fix Windows developer mode symlinks
   + 0cd1666721bdbe988dc361c085bb43cbd41a27f3:
     Respect Starlark options with values in `removeStarlarkOptions()`
   + 7920ffef472b25db3f4e564e5a3a28a4664c666e:
     cquery inherits from `test` not `build`
   + 1e258d2a7a5221613047e5cee0aaec5b56045d2b:
     Allow exec groups to inherit from the rule or other exec groups.
   + d0676693310215407224c1b8e8aea9e3eddc183d:
     Support execution constraints per exec group
   + f1e0d346c8235c855e61afc2adb870e4b895e002:
     Clean up RuleContext to use a Table instead of a Map of Maps.
   + 8186fbb47ab964a9affa9a0fc6315fcdbde2b5aa:
     Documentation for #13110
   + e376580ae4e9ad5bddc196bfb6ad3127e3ff561b:
     Split ExecGroup into a new target.
   + 0cbb8a863522d2f77ab6b67a01e39b19a9a81807:
     Create a new interface to allow Starlark objects to get a thread
     when getIndex is called.
   + d2e21cec31f09b27ef3589f47b0779f34077ca7e:
     Renamed ExecGroupCollection to clarify that it is only for
     Starlark usage.
   + b9519f92f8ce096107164ca5075feced0e989de7:
     Make StarlarkExecGroupContext use AutoValue.
   + 52b1b748b2368820bac2ca94323fb82c39c00e51:
     Use a dummy toolchain context for rules that don't have one.
   + 41877d0fefe3f021f3ff6d4ce398d0deb27157e6:
     Extract a separate StarlarkToolchainContext for starlark-only
     operations.
   + b120d4febc571f17e12501ad87fbff32ef94e9bb:
     Fix toolchains to support type lookup.
   + dc140d0b6119950dd4a7d71b125b15a78bacc8ce:
     Move DEFAULT_EXEC_GROUP_NAME from ToolchainCollection to
     ExecGroup.
   + 9b18d951a52819f1998ddfdc1739fa1b5bf0353d:
     Rename ToolchainCollection.getExecGroups to getExecGroupNames.
   + 10d4473bf476a587e3d9f9b2214581ec420c1919:
     BuildViewForTesting should directly call into
     ConfiguredTargetFunction.
   + 58a6fb1f8739e39125cc8c647f28cff2e79fe9aa:
     Move exec group tests out of platforms_test and into integration.
   + 7d5493d922761c3ce0037f0025912cc532c55ad7:
     Update creating exec groups that explicitly copy from defaults.
   + 8c6382a81237e72dbec24b3850df9481461e0015:
     Create a new ExecGroupCollection container to manage exec group
     inheritance and exec property parsing.
   + b4b0c321910bc968736ef48e8140528ea7d323cd:
     Fix unix toolchain for macos arm64 platform
   + f64f071f44394a33a1be40cb7642e2c881d1e9bb:
     Add `required_providers` attribute to Starlark defined aspects.
   + f2cbdcf67ac1990f05a8241ba8dae65795edac82:
     Don't ever claim /dev/null is an execpath.
   + ceec93c35ead1bd487e96a5fee46e8d080f88858:
     Don't ever claim /dev/null is an execpath.
   + 1f3f9f4c4b2eded90518aacd1b0b80c1b0dfd1c5:
     Use the parent directory of the exec root as the input root on
     RBE.
   + 4efeac9cb5f85325ed73f64e133a078c483cac01:
     Make the Merkle tree computation work in the wake of
     https://github.com/bazelbuild/bazel/commit/7149f578006a4ad0d51df6
     9830a6986749b34df5 .
   + b56a2aa709dcb681cfc3faa148a702015ec631d5:
     Remote: Use execRoot as input root and do NOT set working
     directory by default.
   + ae53991f2e207edacd1352ba94261e2473b79f14:
     Remote: Add RemoteExecutionService as a layer between spawn
     execution and remote execution.
   + 0c07c2e6571dd4806552213b2237ecb7a908afa4:
     Remote: Add remoteCacheable key to execution log
   + 5e617d83f3aab1fd36b07be4b58aba58604cc46e:
     Remote: Register "remote" strategy even if remote execution is
     not available.
   + 4ca8946a8e1c4c2fd48d8fb8ce38adb8b282fef0:
     Remote: Add --experimental_capture_corrupted_outputs flag.
   + 97d7b4c277814d73b50450b03f4bb160ce7e99b4:
     Remote: Report checking cache status before the action is
     scheduled to run remotely.
   + ba5b2a7c9448a3681a0d86d80670447e338a06dc:
     when writing to local disk cache, open files later in order to
     avoid "too many open files"
   + 3551898849a93306ad9b4dfdd7d4667913098efe:
     Propagate test envs to xml generation action
   + 9f8c678d7054548865f56f3464f778c751657074:
     Remote: Fix a bug that the XML generation is executed even if
     test.xml is generated when build with --remote_download_minimal.
   + af42653e6f6bd229142f4678bb256a8c397b4d8d:
     Automatic code cleanup.
   + 07a84ce31d9b09853c63c7e373418696dd285dc5:
     Remote: Another attempt to fix the CancellationException error
     in AsyncTaskCache caused by a race condition.
   + 0f812eb5e561cc5415d0c9931675e58dc37a5850:
     Remote: Display download progress when actions are downloading
     outputs from remote cache.
   + 18c82168433719b400a705a4a0222969a7a026ba:
     Remote: Do not upload empty output to remote cache.
   + 6a138a60e562beeef36003c4814a6b8ce9f253f6:
     Fix compiling errors
   + bcce6dd026e90336e80616a8c1004a79a2f8640c:
     Add the TEMP_FAILURE_RETRY macro to linux-sandbox-pid1.cc.
   + c8c0d94a49e1b865d95c6d245c2d152c7c7c9722:
     Export proguard specs from aar_import
   + 1a0285c3b64b121268ced3eb9ad9d5ba396b4905:
     Fix stripping of macOS loadable bundles
   + 0d3c231f5a08861d28e987703e9196890e6164bf:
     Roll forward config_setting visibility enforcement behind a flag.
   + bb7a01027242390da1c18fbf87c274cc34c11b79:
     Fix merge conflicts.
   + 8b8e77ea226aaa12e79580422bc5984e80ce048b:
     Remove redundant declaration.
   + 7c92cfcf9a88933c29334f6271ad3f086f7f36f4:
     Ignore empty virtual artifacts when spawn-logging inputs.
   + 4158b61211e099db780565d064a1c1a80c91bd2a:
     Use correct exit code on invalid aquery --output
   + b51b31dbe75a5bc73227fccb4484f3454df81b42:
     Remote: Fix a race when reporting action progresses.
   + 0e652737988e3c115e98e1552f6fada52bc2b9a2:
     Change MIN_BUILD_TOOLS_REVISION to 30.0.0
   + 6f9909c04b1e00faa510b38ccabac78821046cf9:
     Update Android remote tools to ensure Bazel uses the latest
     Android tooling that has been updated to support AndroidX
     databinding generation.
   + 31d88c629dff2c5f8e8a4baf8c89fd3349c9783e:
     Automated rollback of commit
     9a1d428e33bfae1ec5b68250d4732b72346b8b39.
   + 951a3023fbcdbe025e350590e6fa86097da3fe05:
     Increase allowed size of the install_base.
   + a7845f65befbeb65a28ec53e62458211a7bc3f8e:
     Increase allowed size for install base again.
   + affc27f9d18f9781437e91a3f36c73962a56f261:
     Bump version of java allocation instrumenter.
   + 7efabba19cf6400bf9e707f53b40a6dd7110fafb:
     Reference the correct version of the java allocation
     instrumenter.
   + 9055c67b17abf5fed487ae44d0e22f1c6ea1e50c:
     Support extracting aar files.
   + 861c3caa85e47da35a8a4f1512e57d43b9263c37:
     Revert "Remote: Fix a race when reporting action progresses."
   + 92ec798ddc1f38fb4868af08c1d818639283f501:
     Revert "Remote: Display download progress when actions are
     downloading outputs from remote cache."
   + ce091abb290d1d753f480cdee0e69748eb20db52:
     Revert "Fix compiling errors"
   + 1b19cd310418b850e8e0ca2086ffe50755c9ed7e:
     Revert "Remote: Fix a bug that the XML generation is executed
     even if test.xml is generated when build with
     --remote_download_minimal."
   + 988b56f5916e024d10695797a7f963b30fc998c7:
     Revert "Remote: Report checking cache status before the action
     is scheduled to run remotely."
   + 35c98d07b21785efae57a7c4230cc1e452f74fd2:
     Revert "Let workers finish lost races without delaying dynamic
     execution."
   + c4e22b9ace07f5d360c5327a38f9ae4ab24b7109:
     Migrate ExampleWorker to use WorkRequestHandler.
   + 230be161176bd6f1251077af7674f80d38ff1e25:
     Do not interleave readdir() calls with deletion of directory
     entries.
   + 3cc8ce6ba0934b1a4d9db184daf055c1207ef105:
     Propagate OOME if NewByteArray allocation failed
   + 19fc15ebbf6c63fcce90a038e91c5ec726852848:
     Create helper method for sandbox tests, transform existing tests
     into using it.
   + deb1006c0778692f7eaef4cbcf7eeb8112b55e91:
     Cleanup: Replace NULL with nullptr
   + f4b5e0233341977aaa76593ca032d9ac4eba7444:
     Let workers finish lost races without delaying dynamic execution.
   + 186decab01ee247c7453baf19dac778545ec4937:
     Interface and flag specification for worker cancellation.
   + 5894a8544d51c99f1356130b8b487bc93299fedd:
     Create BUILD file in worker tests directory instead of running
     tests from the parent directory.
   + e9e6978809b0214e336fee05047d5befe4f4e0c3:
     Server-side implementation of worker cancellation.
   + 5103662238f2df2038c7dff079e9c655e08ba654:
     Add builder for WorkRequestHandler.
   + 1a519bb66c3fa3e4ef3b9a9a556597920751fbcd:
     Makes singleplex requests be handled in separate threads in
     WorkRequestHandler.
   + 779d66019210f54e10a1343ee004df72a8dec812:
     Only allow worker async finishing when sandboxed.
   + a698bef6146a807fd82ee4402d89c23c83802e33:
     Support for cancellation in WorkRequestHandler.
   + 9dc95af4c7ef10979f21173260f5433006116096:
     Make workers restart on flags that affect their
     creation/behaviour.
   + 7e5cd529e9f8c9cb67900af36182f00ef7316654:
     Remote: Report checking cache status before the action is
     scheduled to run remotely.
   + 6e134a1b68418fba9992692901efa77a80c346f7:
     Remote: Fix a bug that the XML generation is executed even if
     test.xml is generated when build with --remote_download_minimal.
   + d4d071401acadb0d8977850a9439474e60fd7bb9:
     Fix compiling errors
   + 2579c9a18360955699d028426b45d381ff53783c:
     Eagerly initialize JNI copies of Java classes: doing lazy
     initialization on a per-method basis doesn't save anything and
     adds a tiny bit of overhead to every one of these calls.
   + 0f812eb5e561cc5415d0c9931675e58dc37a5850:
     Remote: Display download progress when actions are downloading
     outputs from remote cache.
   + 3835d9b21ad524d06873dfbf465ffd2dfb635ba8:
     Update the WorkRequestHandler to use callbacks of type:
     BiFunction<WorkRequest, PrintWriter, Integer>:  - Mark
     constructors that use BiFunction<List<String>, PrintWriter,
     Integer> callback as deprecated.  - Use a wrapper class for the
     BiFunction<WorkRequest, PrintWriter, Integer>. Suggesting this
     to avoid having two constructors that takes a BiFunction, as it
     creates a confusion between the deprecated and new constructor
     when given a lambda expressions.
   + 5e352afe2b35487ea2ced85ca79bd9f79858e648:
     Fix bug in WorkRequestHandler's handling of singleplex requests
     that would cause occasional hangs.
   + b51b31dbe75a5bc73227fccb4484f3454df81b42:
     Remote: Fix a race when reporting action progresses.
   + c9d823e42796962eed039b8122528c2a1541190f:
     Disable flaky test.
   + e6809c90ecc0ef5783faa39e63188fc33a79b80e:
     Revert "Check the result of Future.cancel() when cancelling the
     other branch of dynamic execution."
   + be4cbc7a67196414e3d3f323be8ab55fb5e530f7:
     Revert "Move use of legacy sandbox -> local fallback to only be
     used after all strategies have been tried, and improve messages
     around it."
   + b32349f50ff3d958613aef9275751ad9d50d344c:
     Set a fallback dynamic local strategy even when the
     dynamic_local_strategy flag is passed.
   + f395157c95692565bc220c7ccf788974fe0885fd:
     Allow running an extra spawn for local branch of dynamic
     execution.
   + 039461c76113ab3f165132dd26d0c58eb3e45cae:
     Adding debugging information for case when two branches
     apparently cancel each other.
   + b2231c56d78c6d37bcb6f11e1e50fe68ee336b4a:
     Move use of legacy sandbox -> local fallback to only be used
     after all strategies have been tried, and improve messages
     around it.
   + 5b95d9162b56b51c8e8f66258981ddf3c5d96765:
     Check the result of Future.cancel() when cancelling the other
     branch of dynamic execution.
   + 1962a59a5478f5ad374700b0abf0a718b1b3a7d3:
     Fix the case where if all strategies for one branch of `dynamic`
     execution fail to accept (that is, refuse to even take) the
     action given, the whole action fails. Instead of seeing whether
     the other branch can run and the action that that it succeeded.
   + b7c1ad2aff91105659299723a712b72eea943040:
     Fix rare crash in dynamic execution where both branches got
     cancelled.
   + 2c3cff5422b115d7bb86ed28a056f3d368ebceeb:
     Check if `treeDeleter` is actually async before casting it.
     Fixes #13240.
   + 1a89ce1757e75f8ba9bda76d7373a7e8527bcfc5:
     Make worker JSON protocol properly ignore unknown fields.
   + 4b12fc80abf4152815f09e473a972e52a1fe8b51:
     Fix test_source_file_does_not_override_standard_library to work
     with Python 3.9.
   + f4e10367df2d881f05e3ddd5bd0531b390a845fe:
     Removing line ending matches in tests to be compatible on Windows
   + ba74df07ced96226d78851e11d1df03147f1cc1f:
     Refactors CompilationSupport for objc to use existing API
   + a04cb1bfad4734f801c48bae3070a799067bda4e:
     Release 4.2.0 (2021-08-18)
   + ba8678077024e1b4e5d7419c758a97e8dc9fceea:
     Revert "fix main repo starlark options parsing.
   + 9f67cdf3d51c05bc2209786aa24b72658b61362c:
     cquery: disable `--build_tests_only`.
   + 02ad3e3bc6970db11fe80f966da5707a6c389fdd:
     Release 4.2.1 (2021-08-30)
   + ae0a6c98d4f94abedbedb2d51c27de5febd7df67:
     Enable user_link_flags_feature for macosx cc_toolchain_config
   + af74287f125b93119415ba35429b8638d7a986ea:
     Remote: Limit max number of gRPC connections by
     --remote_max_connections. (#14318)
   + 639f89d7682cadff723ac210fa37101f37762a9d:
     Fix [Prepa] actions stuck in active state
   + 3069ac4e33dcca6f3d1abf55940cdd764d03bdbf:
     Delete marker file before fetching an external repository
   + e6c8e8d1ba89df5cf624e7147cee6b8246a9a490:
     CI configs: switch centos to centos7_java11_devtoolset10
   + 15371720ae0c40ffc97b74c871d1b38851ef6410:
     Release 4.2.2 (2021-12-02)
   + f64b7553607e1d3572611cc5011c498e3cd4505c:
     [4.2.3] Update GrpcRemoteDownloader to only include relevant
     headers. (#16450) (#16459)
   + ad6d3d59ab6706999fe9e604f350bdcbfe501db2:
     Release 4.2.3 (2022-10-18)
   + 12f79d36d52fa0ab5e590a2c6c181162c19e0c7f:
     [4.2.4] Disable some failing tests (#18046)
   + 1f2b3ed4ac717b814d02a0d125f160ddabe78003:
     Patch zlib to fix compatibility with latest Xcode
   + 9fef2346027fdaa130768c042380d4cdc28e66b6:
     [4.2.4] Bump minimum supported macOS versions to 10.13 (#18047)
```

Incompatible changes:

  - GrpcRemoteDownloader only includes relevant headers instead of
    sending all credentials.
    
    Closes #16439.

Important changes:

  - Multiplex persistent workers can now use the JSON protocol.
  - enforce config_setting visibility. See
    https://github.com/bazelbuild/bazel/issues/12932 for details.
  - The minimum Android build tools version for the Android rules is
    now 30.0.0
  - Updates worker protocol with cancellation fields, and adds
    experimental_worker_cancellation flag to control cancellation.
  - If all strategies of one branch (the local or remote execution
    branch) of the `dynamic` strategy fail to even accept (via the
    response they give from `canExec`) the action, `dynamic` will now
    try to see if the other branch can accept it. (Trying to run it
    and it failing will still cause a failure if it was the first
    result, this is about strategies claiming they can't even try the
    action)

This release contains contributions from many people at Google, as well as Alex Eagle, Austin Schuh, Benjamin Peterson, bjacklyn, bromano, Christopher Peterson Sauer, Christopher Sauer, Cristian Hancila, Daniel Wagner-Hall, Denys Kurylenko, Ed Schouten, Fabian Meumertzheim, Finn Ball, George Gensure, Greg Estren, Johannes Abt, Keith Smiley, Kevin Hogeland, kshyanashree, Lauri Peltonen, Noa Resare, Philipp Schrader, Ryan Beasley, Thi Doan, ThomasCJY, Timothy Klim, Trustin Lee, Ulf Adams, Vaidas Pilkauskas, Vertexwahn, wisechengyi, Xavier Bonaventura, Yannic Bonenberger, Yuval Kaplan, Yuval.

## Release 5.4.1 (2023-04-19)

```
Baseline: 8d66a4171baddcbe1569972f019e54130111202c

Cherry picks:

   + becd1494481b96d2bc08055d3d9d4d7968d9702e:
     Remote: Cache merkle trees
   + d7628e1b566be353fe7172241ac8f15d5f8e7ff5:
     Update DEFAULT_IOS_CPU for M1 arm64 simulator support
   + 80c56ff7b603fcfff02a5f97829a2a5935f360a0:
     Compile Apple tools as fat binaries if possible
   + 3c09f3438a966b49a7c1726022c898b390b3a6e5:
     Add protobuf as a well known module
   + 3a5b3606a6f5433467a5b49f0188c41411684bf5:
     Remote: Merge target-level exec_properties with
     --remote_default_exec_properties
   + 917e15ea408e1d3d25574edbb466b39cfbcb61fe:
     Add -no_uuid for hermetic macOS toolchain setup
   + f5cf8b076bc913dbe021104d5f6837fb4a6cd8b3:
     Remote: Fixes an issue when --experimental_remote_cache_async
     encounter flaky tests.
   + 77a002cce050e861fcc87c89acf7768aa5c97124:
     Remove DigestUtils.getDigestInExclusiveMode() now that SsdModule
     has …
   + 557a7e71eeb5396f2c87c909ddc025fde2678780:
     Fixes for the Starlark transition hash computation (#14251)
   + 34c71465f84fa780217926db2e8e5ca3d6d4568c:
     Do location expansion in copts of objc_library
   + 50274a9f714616d4735a560db7f617e53fb8d01b:
     [5.x] Remote: Add support for compression on gRPC cache (#14277)
   + 61bf2e5b5181cbe34a2f0d584053570943881804:
     Automated rollback of commit
     34c71465f84fa780217926db2e8e5ca3d6d4568c.
   + 79888fe7369479c398bafe064daa19a7ae30f710:
     Silence a zstd-jni GCC warning.
   + 063b5c9c2c09b4794010b9a169b44890ffc79ec4:
     Remote: Limit max number of gRPC connections by
     --remote_max_connections.
   + fd727ec96d861573dcbad3249d727a94eff84789:
     Do location expansion in copts of objc_library
   + 23d096931be9b7247eafa750999dd7feadde14c1:
     Fix _is_shared_library_extension_valid
   + 5cf1d6e1f78bc860fcd0e2e86eff6fe43ab4a5a2:
     Remove merging of java_outputs in JavaPluginInfo.
   + cea5f4f499aa832cf90c68898671869ce79d63f2:
     Cherrypick Bzlmod documentation (#14301)
   + 227e49e28e5122cddd6c4cb70686ff7bde3617ea:
     Format work requests according to ndjson spec
   + ae0a6c98d4f94abedbedb2d51c27de5febd7df67:
     Enable user_link_flags_feature for macosx cc_toolchain_config
   + 8c2c78cdc66cc9d5eb2cd59823c659892c1643a7:
     Remote: Use Action's salt field to differentiate cache across
     workspaces.
   + f94898915268be5670fb1e93a16c03e9b14d2a58:
     [5.x] Remote: Fix "file not found" error when remote cache is
     changed from enabled to disabled.  (#14321)
   + 3069ac4e33dcca6f3d1abf55940cdd764d03bdbf:
     Delete marker file before fetching an external repository
   + c05c6261cdb2cacb7c9881c255c0ada435ab5182:
     Remote: Fix file counting in merkletree.DirectoryTreeBuilder
   + d84f7998ef8f15e27376a0c8f25b320145c4ba9e:
     Fix remote spawn tests for remote_merkle_tree_cache=true
   + 59e16e944200555da377799aa0d9e8d0674d2e27:
     Show skipped tests as a warning
   + 76b3c242831f8e88835e3002a831a185a41fcc52:
     Build xcode-locator as a universal binary
   + aa52f2ddf9bab1ebd18e5431124061e813bfcd80:
     Exit collect_coverage.sh early if LCOV_MERGER is not set.
   + 4256d46327bad8638df91be1a5d4ef83b12b74c7:
     Automated rollback of commit
     d84f7998ef8f15e27376a0c8f25b320145c4ba9e.
   + dce24350befd08216b3910ae343670015444ff81:
     [apple] fix issues compiling C in objc_library for watchos/armv7k
   + bfc24139d93f8643686d91596ba347df2e01966a:
     5.x: Remote: Ignore blobs referenced in BEP if the generating
     action cannot be cached remotely. (#14389)
   + 5aef53a8884038f3c9f06e6dddb9372196253378:
     Remote: Don't blocking-get when acquiring gRPC connections.
     (#14420)
   + 005361c895da334beb873901e93aff06d180256e:
     Disable IncludeValidation for ObjC in bazel
   + d703b7b4f09fb3c389f99e52bac1f23930280b56:
     Update java_tools v11.6
   + 90965b072eb4a6dec8ff5b8abde3726732d37bdc:
     Stop remote blob upload if upload is complete. (#14467)
   + dc59d9e8f7937f2e317c042e8da8f97ba6b1237e:
     [5.x] Make remote BES uploader better (#14472)
   + 2edab739e1f61fe8813230b03396ca46f0790089:
     Avoid too verbose warnings in terminal when cache issues
   + 1160485192b5e6d95bcd426b55cc9a35fc6b8614:
     Rename --project_id to --bes_instance_name
   + c63d9ecbe5fcb5716a0be21d8fc781d7aa5bbc30:
     Automated rollback of commit
     bfdfa6ebfd21b388f1c91f512291c848e1a92a96.
   + b341802700484d11c775bf02d80f43ba3f33b218:
     [apple] support watchos_arm64 in toolchain
   + 43bcf80a3dfdc5ac89c1e4d615d6f29a495855fb:
     Disable implicitly collecting baseline coverage for toolchain
     targets.
   + 302971e1b3d803069ac949c0085c0d2a3916c8ab:
     Automated rollback of commit
     7d09b4a15985052670244c277e4357557b4d0039.
   + 62002024ca7012ffe0f4fc74ac20b5471513c8c8:
     Bzlmod: Starlarkify default attr values for TypeCheckedTags
   + 38117d491cbc4a5686e0bdb1e58f8946d96aed58:
     Fix build after rc4 cherrypicks (#14581)
   + 41feb616ae18e21fdba3868e4c298b0b83012f10:
     Release 5.0.0 (2022-01-19)
   + 486d153d1981c3f47129f675de20189667667fa7:
     Find runfiles in directories that are themselves runfiles
   + 0de7bb95022057e8b89334f44759cf6f950e131f:
     Don't resolve symlinks for --sandbox_base
   + 8b60c90f3641591b65c4e153113aea562f1fab94:
     Remove uses of -lstdc++ on darwin
   + 60f757c0831f9fbb2415fb0105f964201faa9fa0:
     Allow Label instances as keys in select (#14755)
   + 3836ad029f202ca13c64c9f07e4568ea8ab2d9a6:
     Remote: Only waits for background tasks from remote execution.
   + 8734ccf9847eafb7193388cd9c6fa78faa78283f:
     Add the default solib dir to the rpath for cc_imports with
     transitions
   + 9e16a6484e94c358aa77a6ed7b1ded3243b65e8f:
     Flip --experimental_worker_allow_json_protocol
   + fce7ea8d5e0facfc125ae7c37bfb4b9a7c586e40:
     Fix `ctx.fragments.apple.single_arch_cpu` returning incorrect
     cpu for tools when host cpu and exec cpu are different
   + 0c1d09e4dce4c3251c2be2c70d4575ec65b1d9d3:
     Propagate --experimental_cc_implementation_deps to host config
   + 1c3a2456c95fd19974a5b2bd33c5ebdb2b2277e4:
     Support select() on constraint_value for aliases.
   + 67a133b431ccece22b7dd9a72f0837cff77d4360:
     Improve documentation for select()
   + 5356fedd4b6079851b51db27077bf84c7bab16a4:
     Cherrypicks for experimental cc_shared_library (#14773)
   + ffdd633d7b9f21267f4f9759dd9833096dd4e3a2:
     [apple] support tvos_sim_arm64 in toolchain (#14779)
   + a58ddea50b2fd476d183e2e0c077ad6173039b89:
     Cherry pick win arm64 (#14794)
   + dc41a20bb045d221a43223a5db6b8b44cd8f1676:
     [5.1.0] cherrypick subpackages support (#14780)
   + 86e2db7d67ec52bfe11c1f517f650653cee3ea26:
     Add a helper method for rules to depend on the cpp toolchain
     type.
   + 6990c02644a71d5e7c95c9c234ecf39bb55c6ac4:
     UrlRewriter should be able to load credentials from .netrc
     (#14834)
   + 32d1606dac2fea730abe174c41870b7ee70ae041:
     Add "arch" struct field to repository_os
   + 2cfdceae971d09f50ceddc3d7ef723fb5f879957:
     [5.x] bzlmod: Add support for WORKSPACE.bzlmod (#14813)
   + c2ddbd1954af5baab63b93f2b055a410a27832c8:
     Ignore missing include directory in JDK distribution.
   + 16de03595e21f7bf31818e717505b23c953b3b7d:
     Fix bazel coverage false negative
   + 0c74741742301abcf67452a7f591daec1c3a7635:
     Remote: Postpone the block waiting in `afterCommand` to
     `BlockWaitingModule` (#14833)
   + 3297d9234e15515aa91cc887b3b12db7e1040b02:
     Switch to `ProcessHandle` for getting the PID (#14842)
   + a987b98ea0d6da2656c4115568ef9cbe8a164550:
     Fix uses of std++ on bsd
   + d184e4883bb7fc21de2f7aeea4304994de27e9ea:
     Remote: handle early return of compressed blobs uploads
   + 0b09e9e018c557da04c9f978d25a66d963cd6cb6:
     Add removeprefix/removesuffix to Starlark strings
   + d42ab0cfcce56b5e55c8bd94d0923d08758fdb5b:
     Fix default CPU for macOS and iOS (#14923)
   + cd24f39750d7b08f6f31c82d3a23cc329c7fc78e:
     Add paramfile support for def_parser, since in rare cases on
     Windows command line character limit was reached.
   + 0b1beefd1e7611dc9b9f559d00d8ff76aabb0f32:
     Normalize rpath entries to guard against missing default solib
     dir
   + 24e82426e689853b0d9a04e7b9b6f13e145cf2d6:
     Fix aggressive params file assumption
   + c45838bd3e51bcd0c8c3e1a9b4a0e55cdf4b4f59:
     Fix precompiled libs not in runfiles of cc_shared_library
     (#14943)
   + 764614e0f0287125269e7a92e909a44624bcb360:
     Bzlmod: Allow multiple `use_extension`s on the same extension
     (#14945)
   + fa761f84994f18db383fbe9aaea524e4385da13a:
     Fix typo in `apple_common.platform` docs
   + f7d8288bd7b16c7f2e010aa8ddc241cf2ba8e0d5:
     Yield a Proxy for addresses without protocol
   + 8cefb8bed4ac82df8640682517372a9249732352:
     Avoid merging URLs in HttpUtils
   + b4804807fc2c184cc36df9e69e472942c01941b8:
     Make protocOpts() public. (#14952)
   + 113eaca5862c48797654ae2a3acbb6e15d761485:
     Do not hide BulkTransferException messages when there were more
     than one exception
   + b1bf9d6c5f85fc4fda0dc48bc3d3e2fe26880867:
     merkle_tree_cache: change default size to 1000
   + f15e0c7224ecc5473d4972afc436e28df35c4e5a:
     Add --experimental_repository_cache_urls_as_default_canonical_id
     to help detect broken repository URLs (#14989)
   + f4214746fcd15f0ef8c4e747ef8e3edca9f112a5:
     Expose the logic to read user netrc file
   + b858ec39aebd7e586af5438aa2035db2adebf9a4:
     Correct cpu and os values of `local_config_cc_toolchains` targets
   + 5e79972c05d89280f0cf1fa620f807366847bac6:
     Expose CoverageOutputGenerator on a Fragment (#14997)
   + 78f03110e0dab42f37e427fd524e72706e036d74:
     Correct error runfiles cc_shared_library (#14998)
   + 7937dd14c3c632ffcfaea9073d5dec6dcac93845:
     [5.1] Adding Starlark dependencies to the package //external
     (#14991)
   + a73aa12be65454ac8cfb5a8f3e056c420402f997:
     Remote: Fix crashes with InterruptedException when using http
     cache.
   + f8707c07f153ac4ac2ec4b210321f1a16343006d:
     Account for interface libraries in cc_shared_library
   + a570f5fdb1618a6c272d18bebaa712d3b2af3975:
     Fix coverage runfiles directory issue
   + 95de355e4524a6339c0e807b60d333c36c40bdc7:
     Do not validate input-only settings in transitions (#15048)
   + 71747ccc9d0032a865854613329362563c0574df:
     Filter out system headers on macOS.
   + cb6500a9ce648a02154dca8d05a978ce9b10c4b4:
     Update Bazel bootstrap documentation and remove obsolete flags.
     (#15065)
   + 4c031d1030afb1cb48c7e6d71f83cc99fea607c1:
     [5.1] Undocument --bes_best_effort (#15066)
   + 267142f3dc6b8d32b07beb21e3b4ba6f471a69d8:
     Fix conflicting actions error when specifying
     --host_macos_minimum_os (#15068)
   + f1923627e85b1c1d60bcd928f90f116c3ade7a3a:
     [5.1] Remote: Action should not be successful and cached if
     outputs were not created (#15071)
   + 00d74ff737cccd60305ee58d85313556a077152a:
     Support decompressing zstd tar archives for repository rules.
   + f5857830bb68bd05ffc257506575ed37a8128933:
     Remote: Don't check TreeArtifact output
   + efb2b80953983dce499d453a9f55a74ffaf8c42d:
     osx_cc_wrapper: Only expand existing response files
   + c771c43b870fb8618db7bdab6725ab40cac4976d:
     Remote: Fix crashes by InterruptedException when dynamic
     execution is enabled. (#15091)
   + 3785677cc84fc4024fda85575c05efbde5d512fc:
     Use python3 on macOS
   + 815d9e499a32fd4d87525ac0c698c293cf26433d:
     Release 5.1.0 (2022-03-24)
   + 1fbb69e366034484887e00c6006c7b79508765ed:
     Prepare 5.1.1 release
   + df153df9656e0e197f67622bb11f7d77e19238a0:
     Fix CODEOWNERS syntax
   + 2b92a3111e83a4d14934059afd0f51161a41276f:
     Remote: Don't check declared outputs for failed action
   + b47aa71b21d93c9499103e9a37a6c2ffa79865b9:
     Upgrade abseil version to the latest
   + c49c45d8dac87d21cf2b6a176ddd07f2c9f63414:
     Revert default export all symbols on Windows
   + 7d3fb993f55b35081786c3fe00cf3bebb89574f3:
     Support ZIP files with total number of disks = 0
   + 0f5dc111be06b2ee8694640f400b58e12bfa5fea:
     Release 5.1.1 (2022-04-08)
   + 2422cfb3e5d92d46f9065b2b1e442823a965faf7:
     Update CODEOWNERS
   + bbcff1802423fca7ee5bd6a3e527c12d6d7d80ba:
     [5.2.0] Update java_tools 11.7.1 (#15231)
   + 9c98120f33579b72561e02826d9fccf222eccb3c:
     Add support for .ar archives (and .deb files)
   + d3435b09d89f25bf5008ef3b9c870c835d51a8da:
     Seperate GetSelfPath implementation for Blaze and Bazel
   + c94572bea5ce6bdc0ccda9789e5be6fb3f4c173b:
     Include jdk.crypto.mscapi in minimized Windows embedded JDK
   + 299022ca2dc49b6cb27b2674f933755306ae8b9b:
     remote: Proactively close the ZstdInputStream in
     ZstdDecompressingOutputStream.
   + 27707995cc6576ed1f51fbdb199ff8512e8418c9:
     Collect coverage from cc_binary data deps of java_test
   + 3442179d240e01ef13b0fa7814db7366bad5ffac:
     Configure Apple crosstool to return a complete target triple
     that includes minimum OS version and target environment
   + bb6f1a7ce79168055ccd62629da07d46a52b930d:
     Collect C++ lcov coverage if runtime object not in runfiles
   + dbb6e9954b6e4423f727feb2719ffc75a93b514b:
     Fixing dependencies of //external package
   + f0213bbf730c4a5d1a31e65bc9c01fbb55a6edb3:
     [5.2] Upgrade Google Auth Version (#15383)
   + a1a74c9919e03e09ef7c6ae13f38f48eea80ead1:
     Fix chocolatey package - docsUrl must not 404 (#15395)
   + fe644bee95c14d461e0d1e3cccaa8bbcd57bcd8d:
     Fix cache leak when applying transitions when only a rule's
     attributes change.
   + ad74d5243917bb27a37e38d151a4a3c8a49947eb:
     Fix checking remote cache for omitted files in buildevent file
     (#15405)
   + ac219103d8798965b775db548d7b9214ecd78f73:
     fix(bzlmod): throw on json parse exception
   + 3d85b88609a362857d8ee3c0432a37d30268a8a2:
     Add a flag to expose undeclared test outputs in unzipped form.
     (#15431)
   + abd7a9f70c3dfe96724a692dc7dc04ff33bdece1:
     Remove -U_FORTIFY_SOURCE when thin_lto is enabled (#15433)
   + 53b9cb8637c0faddc6b122a1daab72bcc274bdec:
     Catch NumberFormatException while trying to parse thread id.
   + 19740b55ebc283b7ec42b359bcd4c9096facfdd5:
     Improve the --sandbox_debug error message
   + 0a2a43f9aab1e3875f03f643f6414eb67834c883:
     Set keywords on appropriate lifecycle events.
   + 394ddb82b311ea7edbe2522736b0b0202903ddb6:
     Record additional profiling information for remotely executed
     actions.
   + 652b48e567fcb30768dfc2eddee5f04bf6b5d65b:
     Fix downloading remote execution output files inside output
     dirs. (#15444)
   + 73f1ecbc1cb00e16ceda4b582f4d57268f8701cd:
     Fix android emulator darwin_arm64 select
   + 2649c7c4adef0ebf9bca8fe46aa97304b22de522:
     Fix --use_top_level_targets_for_symlinks with aliases (#15446)
   + fa1081c1f3dce7324a1da59c40d1a1a3533c7047:
     Filter libtool warning about table of contents
   + 26f878325e915e0905626a0e4c8bbacffd72f875:
     Unify sandbox/remote handling of empty TreeArtifact inputs
     (#15449)
   + 6b21b7773157a1eebd3dfe79ff4c4ee750059daf:
     Revert "Fixes incorrect install names on darwin platforms"
   + e133e66f715bac17bf5848e4440c089a8c8d3fd9:
     config doesn't error on duplicate `--define` values (#15473)
   + 84d59176622b76223828e61709179dbd5f0c9f8d:
     Collect coverage from cc_binary data deps of py_test (#15298)
   + 519d2daacfff3de6ffabfc5827621fa835e1c815:
     SolibSymlinkAction does not need exec platform or properties
   + 6e54699884cfad49d4e8f6dd59a4050bc95c4edf:
     Let Starlark tests inherit env variables (#15217)
   + 9610ae889e6fd45280c5beb7fe8f5bef2d736878:
     Update PythonZipper action to use CommandLineItem.CapturingMapFn
   + 2f1ff6fa17c3c30b2533bffe81f40eab06b453b9:
     Make `coverage --combined_report=lcov` skip incompatible tests
   + 9fad5a3dc93cd436a5712c46e6c98d3995428ddb:
     Disable ReturnValueIgnored checks to unblock java_tools release
   + 0120118893261968bdf116ef215655c428428fa8:
     Bump the limit of Bazel install base size (#15585)
   + 668805aace9bf96f78595fc2a122027a3000ceac:
     Upgrade zlib to 1.2.12
   + 4d900ceea12919ad62012830a95e51f9ec1a48bb:
     [5.2] Remote: Fix a bug that outputs of actions tagged with
     no-remote are u... (#15453)
   + b703cb9b999e243d776b7620468e48f450c0ce3a:
     Add feature to produce serialized diagnostics files (#15600)
   + 2e8458b7810eab7829fc7d28af5c45b9af91ed7c:
     Release 5.2.0 (2022-06-07)
   + 536f8d97991d891fc7db333af1a5262497d85173:
     Fix fail message construction in cc_shared_library
   + 2d42925ae80c0fb007aa39f4e210122611897255:
     Define cc-compiler-darwin in Xcode toolchain
   + a1d7d1f69f82da1bdfa1cebd32356249127aea3b:
     Fix alwayslink in objc_import
   + d273cb62f43ef8169415cf60fc96e503ea2ad823:
     Unify URL/URLs parameter code across http_archive, http_file,
     http_jar
   + fea32be42928c84463aa1f335b5722a1f6b8c93a:
     Preserve --experimental_allow_unresolved_symlinks in exec cfg
   + e4bc370b226eb0cc536b55641640266345a214ec:
     Ck/cherry pick cc shared library (#15754)
   + dbdfa07e92f99497be9c14265611ad2920161483:
     Let Starlark executable rules specify their environment (#15766)
   + e2a6a2b130552db7521d3d4d854b9a651b1f4a3b:
     Fix string formatting when java_home path is missing.
   + d54a288e6c79c740b9c93dfc31ee345d6a5332af:
     Optionally enable LLVM profile continuous mode
   + ad17b44cdc192277fafb0d0e204962b2b924dba8:
     Print remote execution message when the action times out (#15772)
   + 240e3d1e1dbc74c7753dead6421d7c1b5fc28d09:
     Add missing line to cherrypick
     e4bc370b226eb0cc536b55641640266345a214ec (#15784)
   + 804b4747152a59bc2965be2db85839b8b2764fc7:
     Replace strdupa with strdup
   + 62be9ea29295fab5289bd5d1a0f13dc7d55a8bc0:
     Bzlmod: Better canonical repo names for modules with overrides
     (#15793)
   + d4663a1c950d618c5b15a3e00fb733987cbf45cc:
     Add repo env test (#15768)
   + 594962cb283dcd71b736e0450453903911a8c85a:
     Add is_root struct field to bazel_module (#15815)
   + 3dd2b932d42fe86112899550d21452409cb3c4b0:
     Fix null pointer crash with `bazel coverage` on only
     incompatible tests
   + 4175018b47800db28c390d39fefbd266b5d674bd:
     Add util for finding credential helper to use
   + 3ea9eb2e363860c9305a987fa22a059afd35598d:
     Merge ManifestMergerAction-related commits into release-5.3.0
     (#15824)
   + 64571a428ffe2bf09f1a5eea13e770a7d0381620:
     Ck/cherrypick 15669 (#15788)
   + 1404651cafe5c26c5dae469e9126de53c2f4f024:
     Create output directories for remote execution (#15818)
   + ae523f82d39daf01cf31e40733de0c6345f0935c:
     Use tree artifacts in bootclasspath rule
   + 37f181cb6ed0237f43d81159eb81b19d3b5f8e36:
     [credentialhelper] Add types to communicate with the subprocess
   + 06ca634e10f17023022ab591a55aabdd9fb57b12:
     Add a flag to force Bazel to download certain artifacts when
     using --remote_download_minimal (#15870)
   + d35f923b098e4dc9c90b1ab66b413c216bdee638:
     RemoteExecutionService: fix outputs not being uploaded
   + 78af34f9f25b0c8fbf597a794a5162f0014629c5:
     Cherry-pick proto_lang_toolchain Starlarkfication and
     proto_common module (#15854)
   + afb434da9da79b53da1ea4c7bcc00571dbea6d3f:
     Fix behavior of `print()` in module extensions
   + 6714c30507edc70ec84f8c97d47cffc497356c0b:
     [credentialhelper] Implement invoking credential helper as
     subprocess
   + 0f05904171d187e6abacb431b3d7494423b027ab:
     Add register_{execution_platforms,toolchains} directives to
     MODULE.bazel files (#15852)
   + 33516e27dc6ee6ab5c3b9dee739a267b08d26b6c:
     [remote] Improve .netrc test in RemoteModuleTest
   + aa2a1f3afe2f10baab5befcafb39df14cbffc743:
     Fix ZipDecompressor windows 0x80 (file attribute normal)
   + 30f16e53cb36a5d506665be7553e785d52772e2d:
     Replace uses of `cfg = "host"` with `cfg = "exec"` (#15922)
   + 2a8d0ad7103511a94382aef41821a315bf8144b7:
     target pattern file: allow comments
   + 6f732052654ec37192450c795bb28dd0aad559cd:
     Add factory for creating paths relative to well-known roots
     (#15931)
   + 32cc8e638b91816f427b74266f6a8da6fb605419:
     Update CODEOWNERS (#15910)
   + 63bc14b095f1ea4043024e7fe1f9c476968897c5:
     Implement native analysis_test call. (#15940)
   + 4df77f771e5cfdf4b614afd8934d00c2b2ff31d1:
     Increase osx_cc_configure timeouts
   + cdf01a39ab9def4d46f41595ac1ac9206a96d6f8:
     Allow string_list flags to be set via repeated flag uses
   + 05e758d4bc18fc9d9e189526381a06e4399056a2:
     [credentialhelper] Add parser for flag syntax (#15929)
   + e4ee34416ef18094496ab54446e70cb62cd509e6:
     Docs should mention the new no-remote-cache-upload tag (#15965)
   + 96d23d30cc80912b82a8fbab31c902e9db74b6ab:
     Add netrc support to --bes_backend (#15970)
   + c5bc34e5f1dd92703dd8f15f9f0409c49b778837:
     Add CommandLinePathFactory to CommandEnvironment (#15971)
   + 508f18576ab5327bd623db6b476511ac2089d0fa:
     Move newCredentialHelperProvider into GoogleAuthUtils (#15973)
   + 14c944a5386eccbcfbe8389afb6c518582b11270:
     Wire up credential helper to command-line flag(s) (#15976)
   + 04c373b708390341be4ceb8eb5b2f8561385cb11:
     Add `--output=files` mode to cquery (#15979)
   + edfe2a17e3434cce660757f59b14f2e9d6ab944e:
     Make cpp assembly file extensions case sensitive again
   + 4ae85387e69db73e507b4f18b36d3e2f799e5d34:
     Prevent aspects from executing on incompatible targets (#15984)
   + f440f8ec3f63e5d663e1f9d9614f05a39422102a:
     Remote: Fix performance regression in "upload missing inputs".
     (#15998)
   + 0109031a2818b217b78026055b972da5901656f5:
     Updated Codeowners file (#16032)
   + 6102d33bf0b72dc0fe9ada4c71113cbee3eb8187:
     Propagate the error message when a credential helper fails.
     (#16030)
   + a8dacc7832b04fe1756cd7adce72f2572f357eee:
     Migrate legacy desugar wrapper to new rlocation() (#16025)
   + 11368be4ac24108f18b1965162ad27f207c074f9:
     Correctly report errors thrown by CommandLinePathFactory#create.
   + 82452c7c372fb28485b0b5e0a98b471648f0dfd0:
     Fix an issue that
     `incompatible_remote_build_event_upload_respect_no_… (#16045)
   + e745468461f93839491a4f80d0c1883d9007f9c0:
     Fix rpath for binaries in external repositories (#16079)
   + 83041b145d3966eb353aacb22b7e33ad01d9a239:
     Refactor combined cache. (#16110)
   + c62496f7b76da473cb1102798373f552ba2f434d:
     C++: Add compound error linked statically but not exported
     (#16113)
   + 0f18786b09e9729d79c0f14f7843b4d8402b6115:
     Do not crash on URIs without a host component.
   + 9c0940df3c5962b2291e812600dd71731775d45b:
     Add profiler task for calling a credential helper.
   + 2ca1ab2c2c73d78021794f3099ee892cc73f515e:
     Make bazel_cc_code_coverage_test more robust against GCC version
     differences (#16254)
   + 1e25152906b668bbe56aa4c1773186af85335315:
     Fix local execution of external dynamically linked cc_* targets
     (#16253)
   + f6cccae5b6f9c0ad0e7d0bf7bd31ea1263449316:
     * add change to allow blaze info to skip Starlark build settings
     that start with --no prefix * add unit tests for both info and
     clean commands
   + 59b8b8f4dc098c31a372ad45adc2a48c5f1c4a9f:
     Release 5.3.1 (2022-09-19)
   + 77f0233420d141e36fbf86a62dff20285c7d8fdc:
     Update GrpcRemoteDownloader to only include relevant headers.
     (#16450)
   + 42ff95a1202cd18cc3348ed6a442de5eb95845bd:
     Avoid unnecessary iteration on action inputs.
   + d29034e43150f32bb02c2cff3774747e25e97de3:
     Update flag `--experimental_remote_download_regex` to accept
     multiple regular expressions. (#16478)
   + bc087f49584a6a60a5acb3612f6d714e315ab8b5:
     Release 5.3.2 (2022-10-19)
   + 0b914c6f2a5114f1b81f44bab348fb415177e53e:
     Send remote actions to specific worker pools instead of machine
     types.
   + ece17d5d4e74d67dd869cbd1951ca1001423b472:
     Add `$(rlocationpath(s) ...)` expansion (#16668)
   + f02bcf8d8b0d00ecdd06ea0a45ba4f52e436597c:
     Fix identical gcov json file name problem
   + 0696b8a728bd205c1a12cc5a3e0891c87113c95a:
     Upgrade google-http-client and google-http-client-gson.
   + 42a3dbb2d47a321d746ee0f1f89603da329f5852:
     Move analysis_test into testing.analysis_test (#16702)
   + b55f3222a5e9d1e4267ccf5cbf71643e8c492b32:
     Fix hanging issue when Bazel failed to upload action inputs
     (#16819)
   + 2f0f3e1253e1086496d4adf1a136b5473db5a693:
     [5.4.0] Add integration tests for
     --experimental_credential_helper. (#16880)
   + 6d2d68d95abedac6a646eafcca04e6856c87ab3c:
     [5.4.0] Keep credentials cached across build commands. (#16884)
   + 676a0c8dea0e7782e47a386396e386a51566087f:
     Update Bazel to depend on bazelbuild/platforms 0.0.5.
   + 0ea070be02e21c2418e967e3398251c3abba73e8:
     Backport recent package metadata and license check capabilities
     from Bazel 6.x. (#16892)
   + b51396a52efd8ff90063ac79e5a69b950cefd914:
     Add 'toolchain' parameter to actions.{run,run_shell} (#16964)
   + 312fcab532a50e63ae89c8d7f06142423bbe3f70:
     Release 5.4.0 (2022-12-15)
   + 0c4e292c5701f7d284bbe9150163a166243a17a9:
     Pin Bazel version to 5.4.0 (#17986)
   + 43dadb275b3f9690242bf2d94a0757c721d231a9:
     Bump minimum supported macOS versions to 10.13
   + 1f2b3ed4ac717b814d02a0d125f160ddabe78003:
     Patch zlib to fix compatibility with latest Xcode
   + a35f59286a412ab2e1b838f858ee818451c21534:
     Use ctime in file digest cache key (#18115)
   + e6af231a8fc2e78ef44bb74f5e52517c2d250fca:
     [5.4.1] Disable failing tests (#18123)
```

Incompatible changes:

  - GrpcRemoteDownloader only includes relevant headers instead of
    sending all credentials.
    
    Closes #16439.
  - analysis_test moved into testing.analysis_test

Important changes:

  - alias() can now select() directly on constraint_value()
    
    Fixes https://github.com/bazelbuild/bazel/issues/13047.
    
    Closes #14310.
  - Fixed an issue where Bazel could erroneously report a test passes
    in coverage mode without actually running the test.
  - Make protocOpts() publicly accessible.
  - Add coverage configuration fragment, used to expose
    output_generator label.
  - Bazel now no longer includes system headers on macOS in coverage
    reports (#14969).
    
    Closes #14971.
  - Starlark test rules can use the new inherited_environment
    parameter of testing.TestEnvironment to specify environment
    variables
    whose values should be inherited from the shell environment.
    
    Closes #14849.
  - none
    RELNOTES:none
  - Enable merging permissions during Android manifest merging with
    the --merge_android_manifest_permissions flag.
  - Added new register_{execution_platforms,toolchains} directives to
    the MODULE.bazel file, to replace the
    {execution_platforms,toolchains}_to_register attributes on the
    module() directive.
  - Add support for fetching RPC credentials from credential helper.
    
    Progress on https://github.com/bazelbuild/bazel/issues/15856
    
    Closes #15947.
  - `cquery`'s new output mode
    [`--output=files`](https://bazel.build/docs/cquery#files-output)
    lists the output files of the targets matching the query. It
    takes the current value of `--output_groups` into account.
    
    Closes #15552.
  - Fix for desugaring failure on Bazel+Android+Windows build
    scenario.
  - The new path variable `$(rlocationpath ...)` and its plural form
    `$(rlocationpaths ...)` can be used to expand labels to the paths
    accepted by the `Rlocation` function of runfiles libraries. This
    is the preferred way to access data dependencies at runtime and
    works on all platforms, even when runfiles are not enabled (e.g.,
    on Windows by default).
    
    Work towards #16124
    Fixes #10923
    
    Closes #16667.

This release contains contributions from many people at Google, as well as amberdixon, Andreas Fuchs, Benjamin Peterson, Brentley Jones, Chenchu Kolli, Dan Fleming, Danny Wolf, Emil Kattainen, Fabian Meumertzheim, Gowroji Sunil, hvadehra, Juh-Roch, Keith Smiley, Krzysztof Naglik, kshyanashree, Niyas Sait, Noa Resare, Oliver Eikemeier, oquenchil, Peter Mounce, Philipp Schrader, Ryan Beasley, Thi Doãn, Xùdōng Yáng, Yannic, Zhongpeng Lin.

## Release 6.1.2 (2023-04-18)

```
Baseline: d60ce2c7c86393638c77698c00c2168a7a936a53

Cherry picks:

   + 490f8badf4f6f4ae8b96697f08267fdb083ccf5f:
     kshyanashree is the release manager of 6.0.0
   + 4e66d9340037f0be83d7bc0fdd809a09344ab83f:
     Automated rollback of commit
     2a2890913eb8f39299aa4b614ba96266ea8749f6.
   + 48a8d01b05149757f69a6a65a22a280bf003cd24:
     Allow C/C++ coverage collection for external targets
   + ec7be346adc00c4bde22d116fca80ef59da66121:
     Temporarily set parent directory of the input to writable if it
     is not.
   + b0984342eef068640a57aab584dd4c118f0dd394:
     Infer CPUs for tvOS and watchOS when on Apple Silicon
   + 5cea7dda5b632703cf4e0424ba09cd7c5bd6fc06:
     Improve the documentation for ctx.actions.symlink.
   + a82d26f17a99b5417b2212a0ce3a1bbc0285e5c4:
     Add quotes to "Tip"
   + 75b0f3aa95bc34f6620ea74e47d4822bd985efdd:
     Write a repo mapping manifest in the runfiles directory (#16555)
   + 07c5c1aa6d0b63605ae793dce78d26122af64a84:
     Ensure repository names don't start with `~`
   + 30f6c8238f39c4a396b3cb56a98c1a2e79d10bb9:
     Escape tilde more gracefully
   + cf3f48ca49f089615417636763d753811acf717f:
     Relax `Label` repo visibility validation
   + 4477823e2c2bc3d0335c41f971364dda72a3f69a:
     Use "apparent name" instead of "local name" in Bzlmod docs
   + 55f4f4834ef30321a00dab5b58202dd1e9716fd9:
     Bazel DevSite: Add required css file.
   + a706994ac69e3f3fed361c61378de847b50d3b12:
     Remove logic that increases delay between progress updates over
     time
   + 1d514ab05896f34ec91c2145f4dffafd3364030f:
     Remove references to io_bazel repository
   + b0357bd3831b26b5116dc120807e8264acf139db:
     Relnotes python script
   + 8f956511bb115c39ac683a1e78971fcf9dce5deb:
     Allow Java coverage collection for external targets
   + bddb191d3f99402330c67b89375409c31ee22daa:
     Fix race condition in package-bazel.sh
   + a75785279f543f4e33c697dd9e8873a6504b7818:
     Decanonicalize labels emitted by {a,c,}query if possible
   + 9d250edb63f27f9f4591bb5a71059710cc6dca9e:
     Add uniquify parameter to TemplateDict.add_joined
   + f02bcf8d8b0d00ecdd06ea0a45ba4f52e436597c:
     Fix identical gcov json file name problem
   + a1593309f66f892871e334013815b05350b4188f:
     Add `$(rlocationpath(s) ...)` expansion
   + 56f54daf9ff3b1177eee31e342e8d6b959d5ac34:
     Rollup of SBOM correctness fixes (#16655)
   + 72e6e948d30dec9dec60d78efef4eeda5b764a8f:
     [cc] Add cc toolchain to starlark cc_proto_library (#16661)
   + 8f28513893969b6346d965cab12aac69cb246ced:
     Make C++ runfiles library repo mapping aware
   + 95f9adc5ac544b1161d69a7ca74432479fdc29b3:
     Always collect FileProvider's filesToBuild as data runfiles
   + 4959d34e844714b793b2c6fa05016a9a6eaa7044:
     fix: export constraints.bzl file from @local_config_platform so
     it can be used in downstream bzl_library targets
   + 4919d4a61d8506d175b25a035500842b8bfe3d0d:
     Add --host_per_file_copt (#16695)
   + 0a23d46976c3fc999d44fbd1e37732ec2442d485:
     Moving some tests for `RemoteActionFileSystem` of BwoB to a base
     class.
   + 9296068be5e3808eb03a3b61f3af3a2c88f7ab7d:
     [remote/downloader] Don't include headers in `FetchBlobRequest`
   + 128d833fee99f8a43bc4de82cbec752e4ce6fb47:
     [remote] Respect whether the server supports action cache updates
   + 38c501912fc4efc14abc0741d19f5f8e8763afcb:
     [remote/downloader] Migrate `Downloader` to take `Credentials`
     (#16732)
   + 5929cb72aa01768e6352898b1a056ef678c81d90:
     Stage repository mapping manifest as a root symlink (#16733)
   + 455454a56e961affb041a1d4a9214f7f313a05aa:
     Expose current repository name to Java with @AutoBazelRepository
   + 97dea593e568f776361397f7280d6a16eee2efeb:
     Implement getDirectoryEntries and readdir for
     RemoteActionFileSystem.
   + aa45f5f3301c5005294df084cdf99c45d6f95d53:
     Move integration tests for BwoB to a base class and add more
     tests there.
   + 1b073ac0a719a09c9b2d1a52680517ab22dc971e:
     Make Java runfiles library repo mapping aware
   + 148bbb1c025a628643698f65627333d86975c1d7:
     Use `_repo_mapping` in C++ runfiles library (#16752)
   + 25558ada3fb377cfc2c965d3a93250ca28ce0fc1:
     Add --experimental_action_cache_store_output_metadata to the
     expansio…
   + 6e945e8ab422ca0a195d09899cce61ba6c0cfa59:
     Treat `DEBUG` events as progress-like.
   + 1940c5d68136ce2079efa8ff74d4e5fdf63ee3e6:
     redact 'token' strings from logging
   + 0b645254b41edc738c6641fd192fca86203ff2e2:
     Make Bash runfiles library repo mapping aware (#16753)
   + 4caae75b49e815ad2cf1d805f316bc374f03f2ae:
     Automated rollback of commit
     8f956511bb115c39ac683a1e78971fcf9dce5deb.
   + 13ff6d9e37999e00fda9a6cef278c7c924924f34:
     Fix Bash rlocation failure with stricter Bash options
   + bd88c7e47b911e5fa1f8a3c26d0f8317943c43ce:
     Make bazel Android remote deps compatible with bzlmod (#16772)
   + 6f6d4cca36a3b64009ed9c8b3fb13cb3c7ed915a:
     Flip `--incompatible_always_include_files_in_data`
   + 94355b1b1c4f7ef923457b8b2a070e5c6528240a:
     Add required `--add-opens` server JVM args also with
     non-embedded JDK
   + 8349c95fc98beb4008085942a67a57f0c4da074b:
     Also collect clang resource directory with
     `-no-canonical-prefixes`
   + dce6ed777d958d65c7f3d4a2f54f8117778a449e:
     Make `bazel run` works with minimal mode
   + ca8674cc4879ed1846bf015c33fe7d920a3f66ab:
     Include source files with `cquery --output=files` (#16826)
   + 9cb5e0a31665d3b3f25bf58ec2dee696e828d8b9:
     Fsync before rename after copy in DiskCacheClient
   + 23ffce53b92ef96432d8c6c58cc95ac362bab1bc:
     Update GetActionResult for disk cache to check referenced files
     when …
   + 0bc0ff5244142eb3348d42025ce21eeb337ad189:
     Make Java runfiles library compilable with JDK 8
   + fe169654a29d8ad33105d5d0034a7857834fed5d:
     [6.0.0] Default --incompatible_strict_conflict_checks to true.
     (#16864)
   + 99ca86f7c2968741ac3a9b20c3375fc992d49e66:
     Revert "[6.0.0] Default --incompatible_strict_conflict_checks to
     true. (#16864)" (#16872)
   + 312238f2b1414c98ed7d7d51dc4e18278edb2540:
     Make C++ runfiles library build with `-Werror=shadow`
   + 2baa5a4284467d70f1b31ea779b79d38ef07d164:
     Keep credentials cached across build commands.
   + 8818a57fce32a7872f045f03a334e1c9403724d3:
     [6.0.0] Only inject metadata for outputs that cannot be
     reconstructed by skyf… (#16879)
   + 31e4bf409eed71e8fb626092189eacb95f80fed9:
     Update java_tools v11.9
   + cd40666001e8d599bb61735898c195c6d2fae55b:
     replace _get_canonical_form(label) with str(label)
   + e2bc2374188b41924223385ad943db610e92e6c4:
     Avoid exceptions from hermetic sandbox for unsupported artifact
     subclasses
   + b564d145218e58b0440ffad82b3d1d54eef15d22:
     Remove warnings about ignored starlark options
   + 7ccc66108f08f7b6c6f6e5229f70f29962ea19ce:
     [6.0.0] Emit Tree objects in topological order (#16904)
   + 86dee6d2ecb269e0c41a97718812054394ee51a4:
     Correctly match regex with tree artifact
   + 14925b574aa63aad098f2c3d95e14b46ffd295ec:
     Always use target's attributes to set Python version (#16959)
   + a247502d28d8d70d648390de52952189b99a0bb7:
     Add 'toolchain' parameter to actions.{run,run_shell}
   + 497b7e403d6e5523bd1310bd1fe83c4ce1a6b1ec:
     Fix Bash `runfiles_current_repository` with RBE
   + 0a2c4edbc86398266525f31948d67a5736890bfe:
     Fix corner cases in Bash runfiles library
   + 33b514b25963452be71a015e08d4e890405b00a3:
     Fix runfiles creation with MANIFEST when building without the
     bytes
   + 3a13af41034e1f80cc0fbc1634cf8f724a85b78f:
     Remove LCOV merger dependency of `cc_test` without coverage
     (#17004)
   + 25ba76c1b8d420ebae43c1f59890ae46153c2240:
     Include full tree artifact in inputs when prefetcher doesn't
     support partial tree artifacts.
   + 06deebfb5b73f848de5a0ea0e00fcfaa26788d1f:
     Release 6.0.0 (2022-12-19)
   + c2bfb2e98d133c62be328e6e93c4b4bdf766d82c:
     Enable git_submodules tests and merge git_repository and
     starlark_git_repository (#17247)
   + e8182ce32931560406fee1c30745e56a2ee9a6b3:
     have 'bazel test' non-test targets depend on
     --remote_download_output
   + c3245cd028977877aa9e485451b29c7736ebcae0:
     Add `SpellChecker` suggestions for common Bzlmod errors
   + 8ec874348226995c4101b2173a465ddc65cab591:
     Use xcrun to invoke install_name_tool
   + 2b2bea4ee9d51ad875a8d273aa344ac9c5b6742c:
     Extra resources
   + 5b4de12b37cb4ba921b6bdfe810bbb47921ab3a6:
     Do not clear `--platforms` on no-op change to `--cpu`
   + db3c0130b3363485a366897e1c1f2adc5d41fde6:
     Report `AspectCreationException` to the user
   + 53e9fea30e58ab479e5cd7a6c804634f56fc2ddb:
     Use long executable path instead of `argv[0]` in all launchers
   + abae5ca3e8142f93cf0c2597e3410ed955c4dd59:
     Add sanitizer features to unix_cc_toolchain_config
   + db684196afd3b1a0a0e7d883674324bd161ae8bf:
     Allow `map_each` to return `None` in `TemplateDict#add_joined`
   + 66b58ee904efa22696edc1b78a59bac91da9ed8d:
     Always emit trailing zero in human-readable download progress
   + 17b8e448a5e5589f96c2794cb38c86b0c64e86c0:
     Upload all logs in BEP even with minimal upload
   + 28d2daae70be6ee97b876b0568796ceb87af9523:
     Set `--experimental_action_listeners` to default in `exec` config
   + 16427c9050db140d6cb90d7d6324d4a2ff1e249a:
     Do not count tests as failed that have not started
   + 094a0aabed1e018e6503bc3ac844c8022b71a527:
     Accept tildes in --override_module
   + 5f2866f8434ce9a17cf82c001efb7b236f189115:
     Do the AC integrity check for disk part of the combined cache.
   + cd10d508e20a4964586b46f7edea8a6dc900157c:
     Fix `--nozip_undeclared_test_outputs` on Windows
   + 073f54b9a7c46afd2c28b4a99a235bdd6b63bb5f:
     Allow pyd in extensions of dynamic libraries
   + ac504cbb463e76b1374d0060534acabbccb408d2:
     Register JavaCompileActionContext in Bazel.
   + f090433fcf0f42639608b9c5f0243018c1bb9ac7:
     Rollback #14510 because it causes remote test execution to fail
   + 942dddaaad9bf4fbb20b66535aad4fc464ad69ba:
     Prepare backwards compatible usage of optional C++ toolchain
   + 88b51f57d09e43dec31a84d4b636595924d5bfef:
     Emit LLVM coverage for source file paths with a `tmp` segment
   + bb0b886271d45209e3bef476da37811b9dd2afe5:
     Enable archive_param_file feature by default for Windows
   + baf97c00c891acf844a29b4cc31abb45b5c434e5:
     Allow `TemplateDict#map_each` callback to return a list of
     strings (#17306)
   + fcb007749f7f24b36c2b7c4284378bba20fc8b69:
     Only try to create groups of test actions in the ui.
   + 3c47b4716e6eca2b8ab06253915ef8d1bdd28038:
     Find `libtool` when using `BAZEL_USE_CPP_ONLY_TOOLCHAIN`.
   + 1da8a825c0fba882f33ea6998a76ff8265fcd32c:
     Add -dead_strip in default opt link flags for darwin
   + b0c5eb30b2738bf6454c3026a3e0f37579d5854c:
     Dont query remote cache but always use bytestream protocol
   + 00e9af1985cc0227599516fe7568785ca4334050:
     Allow Java coverage collection for external targets.
   + dd24a0022a0ff959598da2c9bc097d27083be1a0:
     Test and fix root symlink edge case in runfiles library
   + af97d9830d3207893cc6f5c851431a28f1721acb:
     [6.1.0] Fix broken CI (#17422)
   + b859571804f2095caaf018b172b59c90f185fd51:
     Add `native.package_relative_label` function
   + 82168d44ee1d49cf2f406903b6d8b9fde0e66cf2:
     Make Bazel more responsive and use less memory when --jobs is
     high (#17398)
   + 84c1ed430405b154b6e9eb2c28281f450e250eff:
     Multiplex worker fixes and tests for Android busybox tools
     (#17371)
   + 07590818d6ce0d0e66c2377db7e73fb6ee6702e5:
     Improve error message for concurrent modifications (#17396)
   + 27bc896f36f0e0ea5dbeaaa16f3a124e38a7284a:
     [6.1.0] Make bazel coverage work with minimal mode (#17397)
   + 544b8164ca352cf06dda0849a589b825631428af:
     [6.1.0] Fix cc_binary bug related to cc_shared_library on
     Windows and prepare for future removal of
     --experimental_cc_shared_library flag (#17445)
   + 9a7aa21c8cd6f38d10e23e265dd650bf031f9b7c:
     Fix Bash `runfiles_current_repository` for tools
   + 911eedc0badcefdbc60a936ae73972772042fc8a:
     Fix label unambiguous canonical form to correctly report
     non-visible repo names
   + e132653ead5e50f4226dbff7776466fef1918f49:
     Remove O1 from sanitizer feature flag defaults
   + ba9e2f8fe666b4fc6110d86ea93cc11779e77068:
     Remove usage of gRPC Context cancellation in the remote
     execution client.
   + de03a2363d016782c5dfe7c55b5cf06cb610f6a2:
     Allow -v to libtool
   + 4e35c02c7c400bfbbfa69164a1ec3bd51966ca79:
     Prettify labels in action progress messages with Bzlmod (#17278)
   + 1be0ac3e73698e31a349ece629c887b06e102a0b:
     Expand tree outputs before eagerly prefetching them for local
     actions. (#17494)
   + c26665102d0d524bb42be8cd205c7b31a22a75c9:
     Fix Java coverage collection with Java 8 runtime
   + 1a6ffe6d453708e3cefc98a07965c680e48d6bac:
     Add a flag to disable execution log sorting.
   + fbec8e2ad1dcbebbbc96491f8b6b208f5b3ac91f:
     Reduce flakiness on Windows for BwoB tests
   + 420659a9ad2a98f57e057d8c22eb621e3b12803e:
     Make AutoBazelRepositoryProcessor compatible with Java 8
   + dde6d20b3fd1d7a14825649c9c89d1c4d2d5242b:
     Do not recommend `shallow_since` for `git_repository`
   + f76fc61640825dd7cf83ce02ba48a4e4f95b66ff:
     Allow the timeout value for execute calls on a mac to be set via
     an environment variable
   + 773d232f528276338098578a28c19c742e3b4e7e:
     Fix RPATHs for cc toolchain solib when sibling layout is used
   + 5932b3b8886ddb5aba271fd907f1371e67960a44:
     [6.1.0] Add --host_features (#17528)
   + a0fa77cc36d02f5f230335556a1829b298b2f219:
     Exit with code 39 if remote cache evicted blobs that Bazel need
     during an invocation (#17496)
   + 1a438b41b74d94fd8b6ff4dcf20b4526530e3c6e:
     Only fetch @remote_coverage_tools when collecting coverage
     (#17512)
   + ee1daaf9852d568dcf38357eadd77b9de953db36:
     [6.1.0]Only fetch @remote_coverage_tools when collecting
     coverage (#17287)
   + 350e32952bdd639969e2aff7887c5dc34c21bce6:
     [6.1.0]Fix symlink file creation overhead (#17488)
   + 5406c953574d48434d33b1cf49b70b718795d783:
     [6.1.0] Cleanup stale state when remote cache evicted (#17538)
   + 2d1b570e976773134a6244dd012e93a5478f6d4a:
     Bump version number in runfiles.bash init code
   + 3ab8a0a5d628a0d958fb2eb1c0d5bb76b442e2f2:
     [6.1.0]Let `aquery` print effective environment for all
     `CommandAction`s (#17274)
   + 51e6c38ae808df4f2bf8fb29b4c5173e06ac014a:
     Properly report repo fetch progress during main repo mapping
     computation
   + 744108e88681e770982f148161d328c9b77319a1:
     [docs] Update migrating to Xcode tutorial (#17563)
   + 9dc7a7e6881f58965103b42390560589e0f38b48:
     Update //third_party:jsr305 (#17557)
   + 43dadb275b3f9690242bf2d94a0757c721d231a9:
     Bump minimum supported macOS versions to 10.13
   + 7d9d23c1ac1b7fcaa461f902e286f50fbb7cb116:
     Correctly set default subprocess factory when loading class
     `SubprocessBuilder`.
   + 77f82f4fab189fd042754be0a7747042d9b01b8f:
     Add an --incompatible_strict_conflict_checks alias for
     --experimental_strict_conflict_checks.
   + e05345dec405a0333c48ff188d2d9a1be90dad53:
     Add support for wrapping system streams in WorkRequestHandler
   + 68e1924cdab69ab92b8acf2f6e9324d11e00b267:
     Also handle remote cache eviction for tree artifacts. (#17601)
   + 4a6d056a8d058ab98a01348fb0c046660ee99a71:
     Add host transition to lcov_merger in Java version of py_test
   + 546e9e2942cb2e98b4c93065cc2d2910878dc900:
     Fix Bazel 6.0 crash regression (#17613)
   + 7e328bb71004e1976525d8b813ca0d616e2af74b:
     Include Bazel version information in profile metadata. (#17616)
   + aafe1235c55f6cdcfc577a40736aaeb9ebaca23b:
     [6.1.0] Handle remote cache eviction when uploading inputs for
     remote actions. (#17605)
   + 938e34823206a2644d538ba655d20ac553352975:
     [6.1.0] Rerun the artifact conflict check when
     --incompatible_strict_conflict_checks changes. (#17592)
   + 034a2815a1e18be5c8b36c6a78f44bb849dff437:
     Report background download for BwoB (#17619)
   + 5afbce52c70cf974eaa4a3bbbc376f398271427d:
     [6.1.0] Flag for writable outputs (experimental) (#17617)
   + d4105e658001677929338835eb970e6595e66b3c:
     [6.1.0] Allow .wasm cc executable and dynamic library extension
     (#17440)
   + a306f4f7fd440d006aa6ae9234b4430f13bc8cf9:
     make desugar dependencies deterministic
   + 37953c56ea77c7aa7bea677f3481557fdb2c2a15:
     Apply exec transition to lcov_merger in sh_test and cc_test
   + 1d73d72a45598e38c51b2618bb6fe4f27b390cb8:
     [6.1.0]Fix --host_features with multiple transitions (#17641)
   + 755cd4bcd48adf752bd8c161454e53a0f5b6a2fa:
     Release 6.1.0 (2023-03-06)
   + 885ae7ef3afd88e21c33579bcd64ee3136bd8715:
     Revert "Add -dead_strip in default opt link flags for darwin
     (#17312)" (#17696)
   + e7fd4cf42e3e320dfac0400464a604c0d8b71a1d:
     Fix wasm dynamic library extension crash (#17757)
   + 1a90fe5fe3283e8e593b62173911e4c264a28b09:
     Release 6.1.1 (2023-03-15)
   + c0ae7becf8de993b9e862f3831889d96994dadbf:
     Bazel CI: Temporarily disable GitRepositoryBlackBoxTest (#18045)
   + 1f2b3ed4ac717b814d02a0d125f160ddabe78003:
     Patch zlib to fix compatibility with latest Xcode
   + 906812c9f93d072ddda732919d20306a50ca0261:
     Turn applicable_licenses on platforms into a no-op. (#18082)
   + 05984b980087371e6ff9b808e27b20294d017ad5:
     Use ctime in file digest cache key (#18101)
```

Incompatible changes:

  - Bazel no longer increases the delay between progress updates when
    there is no cursor control.
  - `--incompatible_always_include_files_in_data` is flipped
    to true. See https://github.com/bazelbuild/bazel/issues/16654 for
    details.
  - `cquery --output=files` also outputs source files.
    
    Closes #16602.
  - `--incompatible_strict_conflict_checks` is flipped to true. See
    https://github.com/bazelbuild/bazel/issues/16729 for details.
  - This changes the behavior of Python version in exec/host
    configuration. Mitigation is to set Python version on the targets.
  - `--features` only applies to targets built in the target
    configuration, and `--host_features` is used for the host / exec
    configuration (gated behind `--incompatible_use_host_features`)
    
    Fixes https://github.com/bazelbuild/bazel/issues/13839
    
    Closes #16626.

Important changes:

  - The new path variable `$(rlocationpath ...)` and its plural form
    `$(rlocationpaths ...)` can be used to expand labels to the paths
    accepted by the `Rlocation` function of runfiles libraries. This
    is the preferred way to access data dependencies at runtime and
    works on all platforms, even when runfiles are not enabled (e.g.,
    on Windows by default).
    
    Work towards #16124
    Fixes #10923
    
    Closes #16428.
  - Starlark `print()` statements are now emitted iff the line of
    code is executed. They are no longer replayed on subsequent
    invocations unless the Starlark code is re-executed.
    Additionally, multiple identical `print()` statements (same
    string from the same line of code, e.g. from a loop) are all
    emitted and no longer deduplicated.
  - Fixes a bug where some compilation flags would not be applied to
    a cc_test
  - Added a `native.package_relative_label()` function, which
    converts a label string to a Label object in the context of the
    calling package, in contrast to `Label()`, which does so in the
    context of the current .bzl file. Both functions now also accept
    relative labels such as `:foo`, and are idempotent.

This release contains contributions from many people at Google, as well as Brentley Jones, Ezekiel Warren, Fabian Meumertzheim, keertk, Keith Smiley, Krzysztof Naglik, kshyanashree, lunch-glide-pepper, oquenchil, Ted Kaplan, Ted Kaplan, UebelAndre, Xùdōng Yáng, Yannic, yuzhy8701.

## Release 7.0.0-pre.20230410.1 (2023-04-17)

```
Baseline: 237fb69ede58a7cb672363451c2cb455637fccfe
```

Incompatible changes:

  - Remove high priority workers functionality from blaze.

Important changes:

  - `--experimental_remote_build_event_upload` has been renamed to
    `--remote_build_event_upload`
  - [Breaking change] platform, constraint_setting, and
    constraint_value can no longer take an applicable_licenses value.
    Remediation is to remove the attribute and rely on the package
    level default.

This release contains contributions from many people at Google, as well as Brentley Jones, Fabian Meumertzheim, Philipp Schrader, Ulf Adams, Yannic Bonenberger.

## Release 7.0.0-pre.20230405.2 (2023-04-12)

```
Baseline: 177f0d49913d74e7b1a4aae52f835702d7e85401

Cherry picks:

   + 81ee0fc29fb538d0849c6e7ccfff925f99b87453:
     Remove globDeps containing some Glob skyKey check
```

Important changes:

  - cc_test can now be configured by using a native.toolchain().
  - `@foo` labels can now be used on the command line as the
    top-level target (that is, `bazel build @foo` now works).
    Double-dot syntax is now forbidden (`bazel build ../foo` will no
    longer work).
  - The location of rules that explicitly specify `generator_name`
    and/or `generator_function` attributes (typically because they
    are incidentally copied from `native.existing_rule()`) is now the
    top-level call in the `BUILD` file, which is consistent with
    rules that do not explicitly specify these attributes.
  - Warnings (most notably those associated with the `deprecation`
    rule attribute) are no longer replayed on subsequent invocations
    unless the target in question is re-analyzed. Warnings are purely
    informational, so this change has no bearing on the correctness
    of the build. Downstream tests that break due to this change
    should update their expectations.

This release contains contributions from many people at Google, as well as Fabian Meumertzheim, Jack Dai, Konstantin Erman.

## Release 7.0.0-pre.20230330.3 (2023-04-06)

```
Baseline: f7829f855bc31aaf0c0fcef55ef56adec84daa9e

Cherry picks:

   + eee0d9dfe3513042112a0f0ec519e2b232e5d203:
     Add an option retention option to proto_library.
```

Incompatible changes:

  - `--experimental_execution_graph_log` no longer exists. Current
    users that want local logs need to pass
    `--experimental_enable_execution_graph_log
    --experimental_execution_graph_log_path=/some/local/path`.
    Current users that want logs uploaded to BEP need to pass
    `--experimental_enable_execution_graph_log
    --experimental_stream_log_file_uploads`.
  - Remove 'darwin' as a CPU value, use 'darwin_x86_64' instead

Important changes:

  - Added `native.module_name()` and `native.module_version()` to
    allow BUILD macro authors to acquire information about which
    Bazel module the current repo is associated with.
  - Add `--skip_incompatible_explicit_targets` option
  - Remove 'darwin' as a CPU value, use 'darwin_x86_64' instead

This release contains contributions from many people at Google, as well as Benjamin Peterson, Benjamin Sigonneau, Ed Schouten, Fabian Meumertzheim, hvd, Keith Smiley, Malte Poll, Marc Zych.

## Release 7.0.0-pre.20230322.4 (2023-04-03)

```
Baseline: 65b394866a23faa09d22a9bb9defde2b6a57140d

Cherry picks:

   + b9bdcf8611e7e9937314a70380bc6391487e7d50:
     Enable
     experimental_execution_graph_enable_edges_from_filewrite_actions
     by default
   + 5a4a3404307c9dd4654866e5d225ac9ec7107970:
     Update documentation for cc_import deps attribute
   + 577c0621412a1db57e42139fdb149cf42f43be57:
     Automated rollback of commit
     ad380dddf49d51d86a8a1698efe76c340aada3c0.
   + 70c821ad1c2f8029643716cf738cf2aaca7a92a4:
     starlark: Reduce allocations for `find`/`indexof` without `end`
   + 233ee2930b66063f5ef2372f1889fe7779925173:
     Automated rollback of commit
     0d2e9dae9c64ef783fa79b5b97fe2682499e038e.
   + 788801a8fd30985a1831de805172d257c6f63691:
     Enable C++ deps pruning on Windows when PARSE_SHOWINCLUDES is
     available.
   + aa2407fe0a0162f3b075eb38b449d3baee3f9cf9:
     Remove "get" from field names in BzlmodFlagsAndEnvVars class
     Disable Html escaping for better format
   + 83c954de9ceeb9954be4921bfcbcf81a5814240a:
     [Skymeld] Gracefully handle --explain.
   + 842d23ea7b3227abb85f801c690e65bc2f886587:
     Automated rollback of commit
     24f6fe802ebb68da71e1e071c9e84c89b4aa0772.
   + c71b0b123e34cbbfe80482e85b2ad45e5a5e5ccc:
     Increase bazel_module_test timeout: it times out on macOS on
     Bazel CI
   + f3e11c5bca767489c677875dc218f30ddacf6b62:
     - Add team-Rules-Java and team-Android to PR labeler - Add
     awaiting-review to all PRs
   + 2e219de0206f533772d336facf51678e847dcb6d:
     Make lockfile human readable
   + 3b9ec35f5a18afe256f679df1e91796dae720fc3:
     Module Lockfile
   + 4c8535670c00116ce7c64f9b2555381b94b12cfc:
     Fix ProxyHelperTest on JDK@HEAD
   + b27d1a3b66628ec479cdc4dc8629a4bddc0320d1:
     Fix regression with implicit deps which Automatic Exec Groups
     caused
   + 24f6fe802ebb68da71e1e071c9e84c89b4aa0772:
     Switch TargetPattern.Parser to use LabelParser
   + dd822392db96bb7bccdb673414a20c4b91e3dbc1:
     Canonicalize use_extension label
   + e97f62d54585c759735487bec78cc2bb6a7d215b:
     This is specifically for android_binary rule. (prev change was
     for android_library rule
     https://github.com/bazelbuild/bazel/commit/98bd4ae81715742ae5aa6c
     91164cd37396cb7c91)
   + 75dce1eefd6139b8a395d9ac6ece211e809efe78:
     Generate loadable dummy .bzl/BUILD/WORKSPACE files
   + c024b8af09fb7d132a131f99ce5635e4623b8bb2:
     Automated rollback of commit
     b2844771164fff2ad6cb2c265ff0da0bd0828906.
   + 6f12510e39153e316f35ab0a1ec376ece7f1b0a9:
     Clarify responsibilities of the Configurability team.
   + 9f93780eafb4f98500f3bc6a828c43b6da363089:
     Create an option to enable `GcThrashingDetector`.
   + b2844771164fff2ad6cb2c265ff0da0bd0828906:
     Automated rollback of commit
     9353955f016b4b918c1543018379a933932586b8.
   + e2639459bde1283d72887cfa90d7558a4d22b3a7:
     Label Interner Part I -- Create `PooledInterner` and make
     `SkyKeyInterner` as its subclass
   + 99b672b631a075b25fe9215709f53703924dccf0:
     Simplify cc_test rules by leveraging optional toolchains.
   + e54564fdbce4a0aff6d753a383bce4ddeba5d16b:
     Restructure ActionStager and CommandAdjuster
   + 1a719cea3f9bf7ee427620d779b6c287f885eff8:
     Add `module_ctx.is_dev_dependency`
   + 986ef7b68d61b1573d9c2bb1200585d07ad24691:
     [Skymeld] Move the various skymeld flag check to SkymeldModule.
   + 03266a86fb9b52cfc45ad0b0404561bd7c218680:
     Tests for TargetPattern parsing, and some sanity fixes
   + 109b29019882811d1beb97a60f8cda668442e8e8:
     Fail early if `use_extension` has a bad label
   + 9353955f016b4b918c1543018379a933932586b8:
     Unconditionally clear the syscall cache at the end of the build.
   + 2aa06cf227fe349195191107286167035f0c5431:
     Expose cc_proto_aspect as a toplevel symbol.
   + 24b45890c431de98d586fdfe5777031612049135:
     Automatically retry the build if encountered remote cache
     eviction error
   + a9dfbae320da3a83c52359069ca7d2214514caaa:
     Increase the test size for //src/test/py/bazel:py_test to
     prevent flakily timing out on BazelCI.
   + f63ce7973b8f3f2560f41daf7321a40d20b22fab:
     Avoid unnecessary copying when building Merkle trees.
   + 6146e4a993c07713aca486fd58f29decfea94aa6:
     [Skymeld] Include the underlying IOException's details if it
     happens while planting the SymlinkForest.
   + 79e22a3278b084b386ce00bd33b31d9526884801:
     Update docs on cached print statement behavior
   + f7829f855bc31aaf0c0fcef55ef56adec84daa9e:
     Rename Factory-level ExecutionTransitionFactory.create to
     createFactory
   + 57426bcdd2853f65b6381b11f6253111abc8c8da:
     Fix iterating over string example
   + 4097d9c5e81413cdacb30d628340e15e06024402:
     Use `PercentageConverter` to automatically validate the value of
     `--experimental_oom_more_eagerly_threshold`.
   + 576a497d0215a0d05debd302b6c0aa74d49c7ee8:
     Delete unused PackageIdentifierAndLong
   + fa7bfa3512029e7abe0e67a9b7831595c30368c5:
     Automatic code cleanup.
   + c89ca0d4d772b08fd852bcd35efd077253b02cc9:
     Update D8/R8 dependency in bazel to 8.0.40
   + cee754ced7168f3cdac82ae0c578a4ea999d473e:
     Add team-Remote-Exec & team-Documentation to PR labeler
   + 0882effbc746c0a40cd21b9a8e06b2a060b32e1c:
     Include --bes_upload_mode in docs
   + d1b4fb746e7c1865ce9631636c227e1aaca732d0:
     Remove 'darwin' CPU value
   + 02846a81bbc75ee39cd065c6c91dcf72adbc3fd7:
     Remove 'darwin' CPU value
   + 0ddf9bf223616f91dc981ed6aea8866624ced3af:
     Remove unneeded use CompilationFailedException.
   + aaf1d0696ffe8a6abe66c3d40947ff4f88a11ca0:
     Don't intern `RootedPath` on Windows.
   + 98bd4ae81715742ae5aa6c91164cd37396cb7c91:
     Native changes required to support linking against resource apks.
   + 0a8380bec9dceae1bffabddcccd459e82d8674b1:
     Set the digest_function field as part of all relevant gRPC
     requests
   + 6e01b25954d974a36bd345be730611507df902cd:
     Add support for .tbz file extension in
     repository_ctx.download_and_extract
   + 8ab9c6e5497ccfe88fdedb2c86ce0ae9461115dc:
     Add a boolean flag which controls whether ExecutionGraphModule
     is on.
   + 753f5d38bc17c0c61fd50f02b106c8fe33d5035a:
     Enable heuristically dropping GENQUERY_SCOPE nodes
   + 57f954d34b8811af4c96ed5c492f59dac81b5abb:
     Update stale workflow #s
   + 8c712c824fbf8e6b5c48bece78e2cdd0c14906b7:
     Fix formatting issue in http.bzl
   + 0d2e9dae9c64ef783fa79b5b97fe2682499e038e:
     Automated rollback of commit
     f548d56bc7f5c664fe6de5070a47e24720d35597.
   + ad380dddf49d51d86a8a1698efe76c340aada3c0:
     Automated rollback of commit
     602794efa7fa2d56013e14903578a82860505006.
   + e69aad7a6f607ab310ae918b0271867cc7ea44c6:
     Automatic code cleanup.
   + a691e974d2e4c5fa4a469e1321b18d15ac7e9cfa:
     Create a `GcThrashingDetector`.
   + abc13e32c0c2cb3bb21efb497a788dec8dc8bd44:
     Release 7.0.0-pre.20230316.2 (2023-03-27)
   + f4b3165b58b4dfcd8305d268d5ffe4e55e8c525a:
     Detect when `GCLocker` defers a `System.gc()` call.
   + 3c1c0c09e68420c813d6258b90ff96641dbd1151:
     Add suggestions to invalid tag class errors
   + 81f312102ff25b89e3afadf05620785ace319ae0:
     [Skymeld] Don't use SkyKeyComputeState to manage conflict
     checking in BuildDriverFunction.
   + 602794efa7fa2d56013e14903578a82860505006:
     Flip Automatic Exec Groups inside java_binary
   + f7627e00bf96c9159ab79a32afc4f6a622f0deeb:
     Support (workspace) relative paths in --override_module closes
     https://github.com/bazelbuild/bazel/issues/17551
   + 16c639ca3a2dacf9ed47e60fc4e13d2983579e5e:
     Trigger labeler when a PR is ready for review (removed from
     draft mode)
   + 5a972e0ac2b55eebee29f61e7e7743cb85695f05:
     Set `use_default_shell_env` for windows launcher maker action
   + 165e7684a1c05d118baaf16449d97f895855db80:
     Fix windows launcher maker compilation with mingw-gcc
   + 136a1ee4be934f91bb1388dc289338f213fac181:
     Add `--skip_incompatible_explicit_targets` option
   + 130703a37382e411390e6db171e9100a8f95cf38:
     Delete old dependency to bazel's //tools/objc
   + 7917b9ae26d0d600ac10d600fc029291baf76e6b:
     Automated rollback of commit
     2a3ab5c45b42321cf1495be7e294e5ec01298ca1.
   + 33d2dc907d304679e303c37e9bfb69cba177bb8d:
     Shard bazel_module_test and py_test
   + 27a16f74a9fbd9ac85db7720322743bcb1d9d495:
     Increase test sizes and shard counts to prevent timing out on
     BazelCI.
   + 09adb348446ffc41f0c4da5c6a8dc97a27dcfd88:
     [Skymeld] Make the execution timer more precise.
   + aa4f3580d277e50757ea696e3a312c0921c304f2:
     Clean up third_party directory
   + d910f361ad05edfffeffdd751900c112aa293c63:
     Updates to PR labeler
   + f35fde47e6d8844816a6c08ee7a3cf33ead7681a:
     Update rules_java and remove references to
     "remote_java_tools_darwin"
   + 718a916236b90727b10622fa3f52fe8336d8cceb:
     Use concrete collections, not lazy set
     difference/intersection/filter views, on hot codepaths in the
     Skyframe engine code, when we'll be iterating more than once.
   + a30e2555e2f22b3d520a1ef460a9541f7e33c248:
     Fix code warnings around rule/package factories.
   + 2aee015fe6e2e0671241ac44c73e88fd7511fa2b:
     Optimize storage of output files in `Rule`.
   + 50e5e6ced388d1f66a395c3e75d3fbc12b45d6db:
     Updating assignees in all issue templates to individual GitHub
     handles.
   + 97aec0f2151194d6605d38c84840af1066da39b3:
     Update templates to include assignees & labels
   + 7556e1107b666d10b660470a571631463c7eb4ec:
     Add version to JavaRuntimeInfo.
   + bcf309b88949fe1bbff1776d88fdaa5c3e1d2d37:
     Add native.module_{name,version}
   + 144ad7b215d4a0fc77fec73fc5dd83a0bc386847:
     Ignore empty symlinks depsets in ctx.runfiles()
   + cb55c5b99e18e131d4f689062b68c11a4ec848e0:
     [Skymeld] Skip checking for external repos when it's clear that
     we don't expect any.
   + a151696e1aca27e85dee8e758f9abc73fc78933f:
     Mirgate jar dependencies for testing to rules_jvm_external
     (third_party)
   + 35f2d49e51a853bbf2261da0ae2ac658451e3883:
     Update issue templates to mention about GitHub Discussions
   + 6a174577835e713415d135ad476f7d27cd1f57a9:
     Introduce --experimental_parallel_aquery_output.
   + 70ce8378638290295e17fb62e735a239f22672e6:
     Add attribute 'provides = [CcInfo]' to '_cc_proto_aspect'
   + c04f0d41317bfe1f6ff42da94dddb4023587fc26:
     Use less subshells and `tee`s in running tests with `bazel run`.
   + c82168eea66609bd0fc3acbc02e837f6a65c3b1b:
     Avoid storing `LateBoundDefault` attribute values in `Rule`.
   + 745ca288770253225d5d96069038a5d735eda69b:
     Suggest alternatives for typoed rule attribute names
   + 187f3e499060a467db65087ef9dd89b172c8aa40:
     Add a cache for command lines of tools in Java toolchain.
   + 6cbe0f1ad6db2cacedd02e517f24f7d93df62803:
     Mirgate jar dependencies for testing to rules_jvm_external
   + 2a3ab5c45b42321cf1495be7e294e5ec01298ca1:
     Enable heuristically dropping GENQUERY_SCOPE nodes
   + 699e40373f95e42390a85f29dfa1098636336103:
     Automated rollback of commit
     a50cca561fe0a77c3750101e505171ddcc16db72.
   + b0fc11d8f386141d2c5efd39cbeed316d620888a:
     Add .bazelversion at the correct location
   + c8388e3dd5d9e6a371482133fb08ae37c2a4890c:
     Delete some dead code
   + a47a59237c816845b5881b7ce883e29702dc0267:
     Update ResolvedToolchainContext to take an ImmutableSet.
   + 0d2e9dae9c64ef783fa79b5b97fe2682499e038e:
     Automated rollback of commit
     f548d56bc7f5c664fe6de5070a47e24720d35597.
```

Incompatible changes:

  - --legacy_bazel_java_test is now a no-op
  - --legacy_bazel_java_test is now a no-op

Important changes:

  - The flag `--distinct_host_configuration` is removed. It has been
    a no-op since Bazel 6.0.0.

This release contains contributions from many people at Google, as well as Alessandro Patti, Alex Eagle, Benjamin Peterson, Ed Schouten, Fabian Meumertzheim, hvd, Jon Landis, something_vague.

## Release 7.0.0-pre.20230316.2 (2023-03-27)

```
Baseline: 8b68efeea23fdcd734bcb1f4bbd6754f11108405

Cherry picks:

   + 8a23169311142f49ceef076eb02e06f030e275ed:
     Automated rollback of commit
     08d31877bd5c1500e3ca67f47bcd3b79b4af226d.
```

Incompatible changes:

  - Bazel's local CPU resource on Linux is now container aware. Use
    `--local_cpu_resources`, `--loading_phase_threads` or `--jobs` to
    override.
  - `copy_from_rule` is exec_groups is deprecated
    (https://github.com/bazelbuild/bazel/issues/17668).
  - --legacy_bazel_java_test is now a no-op
  - --legacy_bazel_java_test is now a no-op

Important changes:

  - making --incompatible_use_platforms_repo_for_constraints do
    nothing. Using constraints from @bazel_tools//platforms with or
    without the flag will throw error with message "Constraints from
    @bazel_tools//platforms have been removed. Please use constraints
    from @platforms repository embedded in Bazel, or preferably
    declare dependency on https://github.com/bazelbuild/platforms"
  - Fixed an issue where WORKSPACE and WORKSPACE-loaded .bzl files
    couldn't see the Bzlmod root module's mappings when Bzlmod is
    enabled.
  - Subsequent settings of --extra_execution_platforms now override
    previous settings, instead of adding them to a list. If you
    currently set --extra_execution_platforms more than once, please
    migrate by passing a list of values to
    --extra_execution_platforms instead so that earlier values aren't
    overwritten.
  - @bazel_tools//config:common_settings.bzl has been removed.
    Use @bazel_skylib//rules:common_settings.bzl instead.
  - cc_shared_library is no longer experimental, see
    https://github.com/bazelbuild/bazel/issues/16709 for details

This release contains contributions from many people at Google, as well as Adam Lavin, Andy Hamon, Benjamin Peterson, Ezekiel Warren, Fabian Meumertzheim, Julio Merino, Keith Smiley, redwrasse, Sagar Pathare, something_vague, Yannic Bonenberger.

## Release 7.0.0-pre.20230306.4 (2023-03-17)

```
Baseline: 0ce17480390cdced2df8d59249561613e81f446f

Cherry picks:

   + 28dc0f93bf725d35124d3c17e8aaa654cfa3b498:
     Switch `RemoteFileArtifactValue` subclassing to optimize for
     memory cost.
   + e79de51b91263b33ced77f0a749a1856972510d1:
     Remove NO_EXPORTING tag from cc_shared_library
   + e0cdaced03750823021b8b1f5b82a71170d67642:
     Fix data race in prefetcher.
```

Incompatible changes:

  - This has the side effect of changing the message on unsuccessful
    builds from
    ```
    FAILED: Build did NOT complete successfully (0 packages loaded)
    ```
    to
    ```
    ERROR: Build did NOT complete successfully
    ```
  - Bazel no longer increases the delay between progress updates when
    there is no cursor control.
  - This has the side effect of changing the message on unsuccessful
    builds from
    ```
    FAILED: Build did NOT complete successfully (0 packages loaded)
    ```
    to
    ```
    ERROR: Build did NOT complete successfully
    ```
  - the --experimental_async_execution flag is now a no-op.
  - --experimental_replay_action_out_err is not a no-op.
  - `cquery --output=files` also outputs source files.
  - `--incompatible_strict_conflict_checks` is flipped to true. See
    https://github.com/bazelbuild/bazel/issues/16729 for details.
  - `--incompatible_strict_conflict_checks` is flipped to true. See
    https://github.com/bazelbuild/bazel/issues/16729 for details.
  - `--incompatible_always_include_files_in_data` is flipped to true.
    See https://github.com/bazelbuild/bazel/issues/16654 for details.
  - This changes the behavior of Python version in exec/host
    configuration. Mitigation is to set Python version on the targets.
  - When multiple --deleted_packages options are passed on the
    command line, they will be concatenated instead of the latest one
    taking effect.
  - This has the side effect of changing the message on unsuccessful
    builds from
  - JSON profile: Use doubles instead of strings for counter series.
  - query --output=proto --order_output=deps now returns targets in
    topological order (previously there was no ordering).
  - --experimental_build_transitive_python_runfiles is flipped to
    false. See #16303 for details
  - --incompatible_python_disable_py2 is flipped to true. See #17293
    for details.
  - When remote cache evicts blobs, Bazel will exit with code 39.
  - `--features` only applies to targets built in the target
    configuration, and `--host_features` is used for the host / exec
    configuration (gated behind `--incompatible_use_host_features`)
  - `--incompatible_strict_conflict_checks` is flipped to true. See
    https://github.com/bazelbuild/bazel/issues/16729 for details.

New features:

  - The `aquery` and `cquery` commands now respect the
    `--query_file` flag just like the `query` command.

Important changes:

  - The new path variable `$(rlocationpath ...)` and its plural form
    `$(rlocationpaths ...)` can be used to expand labels to the paths
    accepted by the `Rlocation` function of runfiles libraries. This
    is the preferred way to access data dependencies at runtime and
    works on all platforms, even when runfiles are not enabled (e.g.,
    on Windows by default).
  - Starlark `print()` statements are now emitted iff the line of
    code is executed. They are no longer replayed on subsequent
    invocations unless the Starlark code is re-executed.
    Additionally, multiple identical `print()` statements (same
    string from the same line of code, e.g. from a loop) are all
    emitted and no longer deduplicated.
  - Fixes a bug where some compilation flags would not be applied to
    a cc_test
  - removed outdated ctx.host_fragments
  - removed outdated ctx.host_configuration
  - Now that the host configuration is finished, `genrule` should
    prefer the use of `tools` and stop using `exec_tools`.
  - Added a `native.package_relative_label()` function, which
    converts a label string to a Label object in the context of the
    calling package, in contrast to `Label()`, which does so in the
    context of the current .bzl file. Both functions now also accept
    relative labels such as `:foo`, and are idempotent.
  - Update Android manifest merger to v30.1.3, and also drop support
    for legacy (pre-D8) desugaring.
  - Adds coverage metric support to android_local_test
  - Correctly encode double value positive infinity as "inf" instead
    of "+inf" for textprotos.
  - Add --use_target_platform_for_tests which uses the target
    platform for executing tests instead of the execution platform.
  - Custom C++ rules on Windows calling
    cc_common.create_linking_context_from_compilation_outputs should
    review whether each target of the rule type should produce a
    dynamic library since a condition which blocked their creation
    has been moved to the rules from behind the API.
  - Add flag `--experimental_remote_cache_ttl` and set the default
    value to 3 hours.

This release contains contributions from many people at Google, as well as Alex Eagle, Amanda L Martin, Andreas Herrmann, Ankush Goyal, Anthony Ter-Saakov, Artem Zinnatullin, aryeh, Austin Schuh, Benjamin Lee, Benjamin Peterson, Benjamin Peterson, Ben Lee, Brentley Jones, Chirag Ramani, Christopher Peterson Sauer, Christopher Sauer, Daniel Grunwald, Daniel KT, Daniel Wagner-Hall, Ed Schouten, Emil Kattainen, Ezekiel Warren, Fabian Meumertzheim, Fabian Meumertzheim, Fahrzin Hemmati, Fahrzin Hemmati, Gaspare Vitta, Greg Magolan, Halil Sener, Hao Yuan, hvadehra, hvd, James Ma, John Hinnegan, Jon Parise, jonrose-dev, keertk, Keith Smiley, Krzysztof Naglik, kshyanashree, Kun-Lu, Lee Mracek, lripoche, Matt Mackay, Maxwell Elliott, mohamadk, nathyong, Nick Korostelev, Oliver Lee, Patrick Balestra, Patrick Balestra, Red Daly, robincaloudis, Robin Tweedie, Roger Hu, Saleem Abdulrasool, Sara Adams, Sascha Moecker, Severin Strobl, Siddhesh Bhupendra Kuakde, Simon Mavi Stewart, Son Luong Ngoc, Stiopa Koltsov, tbaing, Ted Kaplan, Ted Kaplan, Thulio Ferraz Assis, Tom Cnops, Ulf Adams, Ulrik Falklof, Uri Baghin, Xavier Bonaventura, Xdng Yng, Xiangquan Xiao, Yannic Bonenberger, Yannic, Yi Cheng, yuzhy8701.

## Release 6.1.1 (2023-03-15)

```
Baseline: d60ce2c7c86393638c77698c00c2168a7a936a53

Cherry picks:

   + 490f8badf4f6f4ae8b96697f08267fdb083ccf5f:
     kshyanashree is the release manager of 6.0.0
   + 4e66d9340037f0be83d7bc0fdd809a09344ab83f:
     Automated rollback of commit
     2a2890913eb8f39299aa4b614ba96266ea8749f6.
   + 48a8d01b05149757f69a6a65a22a280bf003cd24:
     Allow C/C++ coverage collection for external targets
   + ec7be346adc00c4bde22d116fca80ef59da66121:
     Temporarily set parent directory of the input to writable if it
     is not.
   + b0984342eef068640a57aab584dd4c118f0dd394:
     Infer CPUs for tvOS and watchOS when on Apple Silicon
   + 5cea7dda5b632703cf4e0424ba09cd7c5bd6fc06:
     Improve the documentation for ctx.actions.symlink.
   + a82d26f17a99b5417b2212a0ce3a1bbc0285e5c4:
     Add quotes to "Tip"
   + 75b0f3aa95bc34f6620ea74e47d4822bd985efdd:
     Write a repo mapping manifest in the runfiles directory (#16555)
   + 07c5c1aa6d0b63605ae793dce78d26122af64a84:
     Ensure repository names don't start with `~`
   + 30f6c8238f39c4a396b3cb56a98c1a2e79d10bb9:
     Escape tilde more gracefully
   + cf3f48ca49f089615417636763d753811acf717f:
     Relax `Label` repo visibility validation
   + 4477823e2c2bc3d0335c41f971364dda72a3f69a:
     Use "apparent name" instead of "local name" in Bzlmod docs
   + 55f4f4834ef30321a00dab5b58202dd1e9716fd9:
     Bazel DevSite: Add required css file.
   + a706994ac69e3f3fed361c61378de847b50d3b12:
     Remove logic that increases delay between progress updates over
     time
   + 1d514ab05896f34ec91c2145f4dffafd3364030f:
     Remove references to io_bazel repository
   + b0357bd3831b26b5116dc120807e8264acf139db:
     Relnotes python script
   + 8f956511bb115c39ac683a1e78971fcf9dce5deb:
     Allow Java coverage collection for external targets
   + bddb191d3f99402330c67b89375409c31ee22daa:
     Fix race condition in package-bazel.sh
   + a75785279f543f4e33c697dd9e8873a6504b7818:
     Decanonicalize labels emitted by {a,c,}query if possible
   + 9d250edb63f27f9f4591bb5a71059710cc6dca9e:
     Add uniquify parameter to TemplateDict.add_joined
   + f02bcf8d8b0d00ecdd06ea0a45ba4f52e436597c:
     Fix identical gcov json file name problem
   + a1593309f66f892871e334013815b05350b4188f:
     Add `$(rlocationpath(s) ...)` expansion
   + 56f54daf9ff3b1177eee31e342e8d6b959d5ac34:
     Rollup of SBOM correctness fixes (#16655)
   + 72e6e948d30dec9dec60d78efef4eeda5b764a8f:
     [cc] Add cc toolchain to starlark cc_proto_library (#16661)
   + 8f28513893969b6346d965cab12aac69cb246ced:
     Make C++ runfiles library repo mapping aware
   + 95f9adc5ac544b1161d69a7ca74432479fdc29b3:
     Always collect FileProvider's filesToBuild as data runfiles
   + 4959d34e844714b793b2c6fa05016a9a6eaa7044:
     fix: export constraints.bzl file from @local_config_platform so
     it can be used in downstream bzl_library targets
   + 4919d4a61d8506d175b25a035500842b8bfe3d0d:
     Add --host_per_file_copt (#16695)
   + 0a23d46976c3fc999d44fbd1e37732ec2442d485:
     Moving some tests for `RemoteActionFileSystem` of BwoB to a base
     class.
   + 9296068be5e3808eb03a3b61f3af3a2c88f7ab7d:
     [remote/downloader] Don't include headers in `FetchBlobRequest`
   + 128d833fee99f8a43bc4de82cbec752e4ce6fb47:
     [remote] Respect whether the server supports action cache updates
   + 38c501912fc4efc14abc0741d19f5f8e8763afcb:
     [remote/downloader] Migrate `Downloader` to take `Credentials`
     (#16732)
   + 5929cb72aa01768e6352898b1a056ef678c81d90:
     Stage repository mapping manifest as a root symlink (#16733)
   + 455454a56e961affb041a1d4a9214f7f313a05aa:
     Expose current repository name to Java with @AutoBazelRepository
   + 97dea593e568f776361397f7280d6a16eee2efeb:
     Implement getDirectoryEntries and readdir for
     RemoteActionFileSystem.
   + aa45f5f3301c5005294df084cdf99c45d6f95d53:
     Move integration tests for BwoB to a base class and add more
     tests there.
   + 1b073ac0a719a09c9b2d1a52680517ab22dc971e:
     Make Java runfiles library repo mapping aware
   + 148bbb1c025a628643698f65627333d86975c1d7:
     Use `_repo_mapping` in C++ runfiles library (#16752)
   + 25558ada3fb377cfc2c965d3a93250ca28ce0fc1:
     Add --experimental_action_cache_store_output_metadata to the
     expansio…
   + 6e945e8ab422ca0a195d09899cce61ba6c0cfa59:
     Treat `DEBUG` events as progress-like.
   + 1940c5d68136ce2079efa8ff74d4e5fdf63ee3e6:
     redact 'token' strings from logging
   + 0b645254b41edc738c6641fd192fca86203ff2e2:
     Make Bash runfiles library repo mapping aware (#16753)
   + 4caae75b49e815ad2cf1d805f316bc374f03f2ae:
     Automated rollback of commit
     8f956511bb115c39ac683a1e78971fcf9dce5deb.
   + 13ff6d9e37999e00fda9a6cef278c7c924924f34:
     Fix Bash rlocation failure with stricter Bash options
   + bd88c7e47b911e5fa1f8a3c26d0f8317943c43ce:
     Make bazel Android remote deps compatible with bzlmod (#16772)
   + 6f6d4cca36a3b64009ed9c8b3fb13cb3c7ed915a:
     Flip `--incompatible_always_include_files_in_data`
   + 94355b1b1c4f7ef923457b8b2a070e5c6528240a:
     Add required `--add-opens` server JVM args also with
     non-embedded JDK
   + 8349c95fc98beb4008085942a67a57f0c4da074b:
     Also collect clang resource directory with
     `-no-canonical-prefixes`
   + dce6ed777d958d65c7f3d4a2f54f8117778a449e:
     Make `bazel run` works with minimal mode
   + ca8674cc4879ed1846bf015c33fe7d920a3f66ab:
     Include source files with `cquery --output=files` (#16826)
   + 9cb5e0a31665d3b3f25bf58ec2dee696e828d8b9:
     Fsync before rename after copy in DiskCacheClient
   + 23ffce53b92ef96432d8c6c58cc95ac362bab1bc:
     Update GetActionResult for disk cache to check referenced files
     when …
   + 0bc0ff5244142eb3348d42025ce21eeb337ad189:
     Make Java runfiles library compilable with JDK 8
   + fe169654a29d8ad33105d5d0034a7857834fed5d:
     [6.0.0] Default --incompatible_strict_conflict_checks to true.
     (#16864)
   + 99ca86f7c2968741ac3a9b20c3375fc992d49e66:
     Revert "[6.0.0] Default --incompatible_strict_conflict_checks to
     true. (#16864)" (#16872)
   + 312238f2b1414c98ed7d7d51dc4e18278edb2540:
     Make C++ runfiles library build with `-Werror=shadow`
   + 2baa5a4284467d70f1b31ea779b79d38ef07d164:
     Keep credentials cached across build commands.
   + 8818a57fce32a7872f045f03a334e1c9403724d3:
     [6.0.0] Only inject metadata for outputs that cannot be
     reconstructed by skyf… (#16879)
   + 31e4bf409eed71e8fb626092189eacb95f80fed9:
     Update java_tools v11.9
   + cd40666001e8d599bb61735898c195c6d2fae55b:
     replace _get_canonical_form(label) with str(label)
   + e2bc2374188b41924223385ad943db610e92e6c4:
     Avoid exceptions from hermetic sandbox for unsupported artifact
     subclasses
   + b564d145218e58b0440ffad82b3d1d54eef15d22:
     Remove warnings about ignored starlark options
   + 7ccc66108f08f7b6c6f6e5229f70f29962ea19ce:
     [6.0.0] Emit Tree objects in topological order (#16904)
   + 86dee6d2ecb269e0c41a97718812054394ee51a4:
     Correctly match regex with tree artifact
   + 14925b574aa63aad098f2c3d95e14b46ffd295ec:
     Always use target's attributes to set Python version (#16959)
   + a247502d28d8d70d648390de52952189b99a0bb7:
     Add 'toolchain' parameter to actions.{run,run_shell}
   + 497b7e403d6e5523bd1310bd1fe83c4ce1a6b1ec:
     Fix Bash `runfiles_current_repository` with RBE
   + 0a2c4edbc86398266525f31948d67a5736890bfe:
     Fix corner cases in Bash runfiles library
   + 33b514b25963452be71a015e08d4e890405b00a3:
     Fix runfiles creation with MANIFEST when building without the
     bytes
   + 3a13af41034e1f80cc0fbc1634cf8f724a85b78f:
     Remove LCOV merger dependency of `cc_test` without coverage
     (#17004)
   + 25ba76c1b8d420ebae43c1f59890ae46153c2240:
     Include full tree artifact in inputs when prefetcher doesn't
     support partial tree artifacts.
   + 06deebfb5b73f848de5a0ea0e00fcfaa26788d1f:
     Release 6.0.0 (2022-12-19)
   + c2bfb2e98d133c62be328e6e93c4b4bdf766d82c:
     Enable git_submodules tests and merge git_repository and
     starlark_git_repository (#17247)
   + e8182ce32931560406fee1c30745e56a2ee9a6b3:
     have 'bazel test' non-test targets depend on
     --remote_download_output
   + c3245cd028977877aa9e485451b29c7736ebcae0:
     Add `SpellChecker` suggestions for common Bzlmod errors
   + 8ec874348226995c4101b2173a465ddc65cab591:
     Use xcrun to invoke install_name_tool
   + 2b2bea4ee9d51ad875a8d273aa344ac9c5b6742c:
     Extra resources
   + 5b4de12b37cb4ba921b6bdfe810bbb47921ab3a6:
     Do not clear `--platforms` on no-op change to `--cpu`
   + db3c0130b3363485a366897e1c1f2adc5d41fde6:
     Report `AspectCreationException` to the user
   + 53e9fea30e58ab479e5cd7a6c804634f56fc2ddb:
     Use long executable path instead of `argv[0]` in all launchers
   + abae5ca3e8142f93cf0c2597e3410ed955c4dd59:
     Add sanitizer features to unix_cc_toolchain_config
   + db684196afd3b1a0a0e7d883674324bd161ae8bf:
     Allow `map_each` to return `None` in `TemplateDict#add_joined`
   + 66b58ee904efa22696edc1b78a59bac91da9ed8d:
     Always emit trailing zero in human-readable download progress
   + 17b8e448a5e5589f96c2794cb38c86b0c64e86c0:
     Upload all logs in BEP even with minimal upload
   + 28d2daae70be6ee97b876b0568796ceb87af9523:
     Set `--experimental_action_listeners` to default in `exec` config
   + 16427c9050db140d6cb90d7d6324d4a2ff1e249a:
     Do not count tests as failed that have not started
   + 094a0aabed1e018e6503bc3ac844c8022b71a527:
     Accept tildes in --override_module
   + 5f2866f8434ce9a17cf82c001efb7b236f189115:
     Do the AC integrity check for disk part of the combined cache.
   + cd10d508e20a4964586b46f7edea8a6dc900157c:
     Fix `--nozip_undeclared_test_outputs` on Windows
   + 073f54b9a7c46afd2c28b4a99a235bdd6b63bb5f:
     Allow pyd in extensions of dynamic libraries
   + ac504cbb463e76b1374d0060534acabbccb408d2:
     Register JavaCompileActionContext in Bazel.
   + f090433fcf0f42639608b9c5f0243018c1bb9ac7:
     Rollback #14510 because it causes remote test execution to fail
   + 942dddaaad9bf4fbb20b66535aad4fc464ad69ba:
     Prepare backwards compatible usage of optional C++ toolchain
   + 88b51f57d09e43dec31a84d4b636595924d5bfef:
     Emit LLVM coverage for source file paths with a `tmp` segment
   + bb0b886271d45209e3bef476da37811b9dd2afe5:
     Enable archive_param_file feature by default for Windows
   + baf97c00c891acf844a29b4cc31abb45b5c434e5:
     Allow `TemplateDict#map_each` callback to return a list of
     strings (#17306)
   + fcb007749f7f24b36c2b7c4284378bba20fc8b69:
     Only try to create groups of test actions in the ui.
   + 3c47b4716e6eca2b8ab06253915ef8d1bdd28038:
     Find `libtool` when using `BAZEL_USE_CPP_ONLY_TOOLCHAIN`.
   + 1da8a825c0fba882f33ea6998a76ff8265fcd32c:
     Add -dead_strip in default opt link flags for darwin
   + b0c5eb30b2738bf6454c3026a3e0f37579d5854c:
     Dont query remote cache but always use bytestream protocol
   + 00e9af1985cc0227599516fe7568785ca4334050:
     Allow Java coverage collection for external targets.
   + dd24a0022a0ff959598da2c9bc097d27083be1a0:
     Test and fix root symlink edge case in runfiles library
   + af97d9830d3207893cc6f5c851431a28f1721acb:
     [6.1.0] Fix broken CI (#17422)
   + b859571804f2095caaf018b172b59c90f185fd51:
     Add `native.package_relative_label` function
   + 82168d44ee1d49cf2f406903b6d8b9fde0e66cf2:
     Make Bazel more responsive and use less memory when --jobs is
     high (#17398)
   + 84c1ed430405b154b6e9eb2c28281f450e250eff:
     Multiplex worker fixes and tests for Android busybox tools
     (#17371)
   + 07590818d6ce0d0e66c2377db7e73fb6ee6702e5:
     Improve error message for concurrent modifications (#17396)
   + 27bc896f36f0e0ea5dbeaaa16f3a124e38a7284a:
     [6.1.0] Make bazel coverage work with minimal mode (#17397)
   + 544b8164ca352cf06dda0849a589b825631428af:
     [6.1.0] Fix cc_binary bug related to cc_shared_library on
     Windows and prepare for future removal of
     --experimental_cc_shared_library flag (#17445)
   + 9a7aa21c8cd6f38d10e23e265dd650bf031f9b7c:
     Fix Bash `runfiles_current_repository` for tools
   + 911eedc0badcefdbc60a936ae73972772042fc8a:
     Fix label unambiguous canonical form to correctly report
     non-visible repo names
   + e132653ead5e50f4226dbff7776466fef1918f49:
     Remove O1 from sanitizer feature flag defaults
   + ba9e2f8fe666b4fc6110d86ea93cc11779e77068:
     Remove usage of gRPC Context cancellation in the remote
     execution client.
   + de03a2363d016782c5dfe7c55b5cf06cb610f6a2:
     Allow -v to libtool
   + 4e35c02c7c400bfbbfa69164a1ec3bd51966ca79:
     Prettify labels in action progress messages with Bzlmod (#17278)
   + 1be0ac3e73698e31a349ece629c887b06e102a0b:
     Expand tree outputs before eagerly prefetching them for local
     actions. (#17494)
   + c26665102d0d524bb42be8cd205c7b31a22a75c9:
     Fix Java coverage collection with Java 8 runtime
   + 1a6ffe6d453708e3cefc98a07965c680e48d6bac:
     Add a flag to disable execution log sorting.
   + fbec8e2ad1dcbebbbc96491f8b6b208f5b3ac91f:
     Reduce flakiness on Windows for BwoB tests
   + 420659a9ad2a98f57e057d8c22eb621e3b12803e:
     Make AutoBazelRepositoryProcessor compatible with Java 8
   + dde6d20b3fd1d7a14825649c9c89d1c4d2d5242b:
     Do not recommend `shallow_since` for `git_repository`
   + f76fc61640825dd7cf83ce02ba48a4e4f95b66ff:
     Allow the timeout value for execute calls on a mac to be set via
     an environment variable
   + 773d232f528276338098578a28c19c742e3b4e7e:
     Fix RPATHs for cc toolchain solib when sibling layout is used
   + 5932b3b8886ddb5aba271fd907f1371e67960a44:
     [6.1.0] Add --host_features (#17528)
   + a0fa77cc36d02f5f230335556a1829b298b2f219:
     Exit with code 39 if remote cache evicted blobs that Bazel need
     during an invocation (#17496)
   + 1a438b41b74d94fd8b6ff4dcf20b4526530e3c6e:
     Only fetch @remote_coverage_tools when collecting coverage
     (#17512)
   + ee1daaf9852d568dcf38357eadd77b9de953db36:
     [6.1.0]Only fetch @remote_coverage_tools when collecting
     coverage (#17287)
   + 350e32952bdd639969e2aff7887c5dc34c21bce6:
     [6.1.0]Fix symlink file creation overhead (#17488)
   + 5406c953574d48434d33b1cf49b70b718795d783:
     [6.1.0] Cleanup stale state when remote cache evicted (#17538)
   + 2d1b570e976773134a6244dd012e93a5478f6d4a:
     Bump version number in runfiles.bash init code
   + 3ab8a0a5d628a0d958fb2eb1c0d5bb76b442e2f2:
     [6.1.0]Let `aquery` print effective environment for all
     `CommandAction`s (#17274)
   + 51e6c38ae808df4f2bf8fb29b4c5173e06ac014a:
     Properly report repo fetch progress during main repo mapping
     computation
   + 744108e88681e770982f148161d328c9b77319a1:
     [docs] Update migrating to Xcode tutorial (#17563)
   + 9dc7a7e6881f58965103b42390560589e0f38b48:
     Update //third_party:jsr305 (#17557)
   + 43dadb275b3f9690242bf2d94a0757c721d231a9:
     Bump minimum supported macOS versions to 10.13
   + 7d9d23c1ac1b7fcaa461f902e286f50fbb7cb116:
     Correctly set default subprocess factory when loading class
     `SubprocessBuilder`.
   + 77f82f4fab189fd042754be0a7747042d9b01b8f:
     Add an --incompatible_strict_conflict_checks alias for
     --experimental_strict_conflict_checks.
   + e05345dec405a0333c48ff188d2d9a1be90dad53:
     Add support for wrapping system streams in WorkRequestHandler
   + 68e1924cdab69ab92b8acf2f6e9324d11e00b267:
     Also handle remote cache eviction for tree artifacts. (#17601)
   + 4a6d056a8d058ab98a01348fb0c046660ee99a71:
     Add host transition to lcov_merger in Java version of py_test
   + 546e9e2942cb2e98b4c93065cc2d2910878dc900:
     Fix Bazel 6.0 crash regression (#17613)
   + 7e328bb71004e1976525d8b813ca0d616e2af74b:
     Include Bazel version information in profile metadata. (#17616)
   + aafe1235c55f6cdcfc577a40736aaeb9ebaca23b:
     [6.1.0] Handle remote cache eviction when uploading inputs for
     remote actions. (#17605)
   + 938e34823206a2644d538ba655d20ac553352975:
     [6.1.0] Rerun the artifact conflict check when
     --incompatible_strict_conflict_checks changes. (#17592)
   + 034a2815a1e18be5c8b36c6a78f44bb849dff437:
     Report background download for BwoB (#17619)
   + 5afbce52c70cf974eaa4a3bbbc376f398271427d:
     [6.1.0] Flag for writable outputs (experimental) (#17617)
   + d4105e658001677929338835eb970e6595e66b3c:
     [6.1.0] Allow .wasm cc executable and dynamic library extension
     (#17440)
   + a306f4f7fd440d006aa6ae9234b4430f13bc8cf9:
     make desugar dependencies deterministic
   + 37953c56ea77c7aa7bea677f3481557fdb2c2a15:
     Apply exec transition to lcov_merger in sh_test and cc_test
   + 1d73d72a45598e38c51b2618bb6fe4f27b390cb8:
     [6.1.0]Fix --host_features with multiple transitions (#17641)
   + 755cd4bcd48adf752bd8c161454e53a0f5b6a2fa:
     Release 6.1.0 (2023-03-06)
   + 885ae7ef3afd88e21c33579bcd64ee3136bd8715:
     Revert "Add -dead_strip in default opt link flags for darwin
     (#17312)" (#17696)
   + e7fd4cf42e3e320dfac0400464a604c0d8b71a1d:
     Fix wasm dynamic library extension crash (#17757)
```

Incompatible changes:

  - Bazel no longer increases the delay between progress updates when
    there is no cursor control.
  - `--incompatible_always_include_files_in_data` is flipped
    to true. See https://github.com/bazelbuild/bazel/issues/16654 for
    details.
  - `cquery --output=files` also outputs source files.
    
    Closes #16602.
  - `--incompatible_strict_conflict_checks` is flipped to true. See
    https://github.com/bazelbuild/bazel/issues/16729 for details.
  - This changes the behavior of Python version in exec/host
    configuration. Mitigation is to set Python version on the targets.
  - `--features` only applies to targets built in the target
    configuration, and `--host_features` is used for the host / exec
    configuration (gated behind `--incompatible_use_host_features`)
    
    Fixes https://github.com/bazelbuild/bazel/issues/13839
    
    Closes #16626.

Important changes:

  - The new path variable `$(rlocationpath ...)` and its plural form
    `$(rlocationpaths ...)` can be used to expand labels to the paths
    accepted by the `Rlocation` function of runfiles libraries. This
    is the preferred way to access data dependencies at runtime and
    works on all platforms, even when runfiles are not enabled (e.g.,
    on Windows by default).
    
    Work towards #16124
    Fixes #10923
    
    Closes #16428.
  - Starlark `print()` statements are now emitted iff the line of
    code is executed. They are no longer replayed on subsequent
    invocations unless the Starlark code is re-executed.
    Additionally, multiple identical `print()` statements (same
    string from the same line of code, e.g. from a loop) are all
    emitted and no longer deduplicated.
  - Fixes a bug where some compilation flags would not be applied to
    a cc_test
  - Added a `native.package_relative_label()` function, which
    converts a label string to a Label object in the context of the
    calling package, in contrast to `Label()`, which does so in the
    context of the current .bzl file. Both functions now also accept
    relative labels such as `:foo`, and are idempotent.

This release contains contributions from many people at Google, as well as Brentley Jones, Ezekiel Warren, Fabian Meumertzheim, keertk, Keith Smiley, Krzysztof Naglik, kshyanashree, lunch-glide-pepper, oquenchil, Ted Kaplan, Ted Kaplan, UebelAndre, Xùdōng Yáng, Yannic, yuzhy8701.

## Release 7.0.0-pre.20230302.1 (2023-03-13)

```
Baseline: c1382105d342e8e00f9e5ae079fb24cd54c72e78
```

Incompatible changes:

  - This has the side effect of changing the message on unsuccessful
    builds from
    ```
    FAILED: Build did NOT complete successfully (0 packages loaded)
    ```
    to
    ```
    ERROR: Build did NOT complete successfully
    ```
  - Bazel no longer increases the delay between progress updates when
    there is no cursor control.
  - This has the side effect of changing the message on unsuccessful
    builds from
    ```
    FAILED: Build did NOT complete successfully (0 packages loaded)
    ```
    to
    ```
    ERROR: Build did NOT complete successfully
    ```
  - the --experimental_async_execution flag is now a no-op.
  - --experimental_replay_action_out_err is not a no-op.
  - `cquery --output=files` also outputs source files.
  - `--incompatible_strict_conflict_checks` is flipped to true. See
    https://github.com/bazelbuild/bazel/issues/16729 for details.
  - `--incompatible_strict_conflict_checks` is flipped to true. See
    https://github.com/bazelbuild/bazel/issues/16729 for details.
  - `--incompatible_always_include_files_in_data` is flipped to true.
    See https://github.com/bazelbuild/bazel/issues/16654 for details.
  - This changes the behavior of Python version in exec/host
    configuration. Mitigation is to set Python version on the targets.
  - When multiple --deleted_packages options are passed on the
    command line, they will be concatenated instead of the latest one
    taking effect.
  - This has the side effect of changing the message on unsuccessful
    builds from
  - JSON profile: Use doubles instead of strings for counter series.
  - query --output=proto --order_output=deps now returns targets in
    topological order (previously there was no ordering).
  - --experimental_build_transitive_python_runfiles is flipped to
    false. See #16303 for details
  - --incompatible_python_disable_py2 is flipped to true. See #17293
    for details.
  - When remote cache evicts blobs, Bazel will exit with code 39.
  - `--features` only applies to targets built in the target
    configuration, and `--host_features` is used for the host / exec
    configuration (gated behind `--incompatible_use_host_features`)

New features:

  - The `aquery` and `cquery` commands now respect the
    `--query_file` flag just like the `query` command.

Important changes:

  - The new path variable `$(rlocationpath ...)` and its plural form
    `$(rlocationpaths ...)` can be used to expand labels to the paths
    accepted by the `Rlocation` function of runfiles libraries. This
    is the preferred way to access data dependencies at runtime and
    works on all platforms, even when runfiles are not enabled (e.g.,
    on Windows by default).
  - Starlark `print()` statements are now emitted iff the line of
    code is executed. They are no longer replayed on subsequent
    invocations unless the Starlark code is re-executed.
    Additionally, multiple identical `print()` statements (same
    string from the same line of code, e.g. from a loop) are all
    emitted and no longer deduplicated.
  - Fixes a bug where some compilation flags would not be applied to
    a cc_test
  - removed outdated ctx.host_fragments
  - removed outdated ctx.host_configuration
  - Now that the host configuration is finished, `genrule` should
    prefer the use of `tools` and stop using `exec_tools`.
  - Added a `native.package_relative_label()` function, which
    converts a label string to a Label object in the context of the
    calling package, in contrast to `Label()`, which does so in the
    context of the current .bzl file. Both functions now also accept
    relative labels such as `:foo`, and are idempotent.
  - Update Android manifest merger to v30.1.3, and also drop support
    for legacy (pre-D8) desugaring.
  - Adds coverage metric support to android_local_test
  - Correctly encode double value positive infinity as "inf" instead
    of "+inf" for textprotos.
  - Add --use_target_platform_for_tests which uses the target
    platform for executing tests instead of the execution platform.
  - Custom C++ rules on Windows calling
    cc_common.create_linking_context_from_compilation_outputs should
    review whether each target of the rule type should produce a
    dynamic library since a condition which blocked their creation
    has been moved to the rules from behind the API.

This release contains contributions from many people at Google, as well as Alex Eagle, Amanda L Martin, Andreas Herrmann, Ankush Goyal, Anthony Ter-Saakov, Artem Zinnatullin, aryeh, Austin Schuh, Benjamin Lee, Benjamin Peterson, Benjamin Peterson, Ben Lee, Brentley Jones, Chirag Ramani, Christopher Peterson Sauer, Christopher Sauer, Daniel Grunwald, Daniel KT, Daniel Wagner-Hall, Ed Schouten, Emil Kattainen, Ezekiel Warren, Fabian Meumertzheim, Fabian Meumertzheim, Fahrzin Hemmati, Fahrzin Hemmati, Gaspare Vitta, Greg Magolan, Halil Sener, Hao Yuan, hvadehra, hvd, James Ma, John Hinnegan, Jon Parise, jonrose-dev, keertk, Keith Smiley, Krzysztof Naglik, kshyanashree, Kun-Lu, Lee Mracek, lripoche, Matt Mackay, Maxwell Elliott, mohamadk, nathyong, Nick Korostelev, Oliver Lee, Patrick Balestra, Patrick Balestra, Red Daly, robincaloudis, Robin Tweedie, Roger Hu, Saleem Abdulrasool, Sara Adams, Sascha Moecker, Severin Strobl, Siddhesh Bhupendra Kuakde, Simon Mavi Stewart, Son Luong Ngoc, Stiopa Koltsov, tbaing, Ted Kaplan, Thulio Ferraz Assis, Tom Cnops, Ulf Adams, Ulrik Falklof, Uri Baghin, Xavier Bonaventura, Xdng Yng, Xiangquan Xiao, Yannic Bonenberger, Yannic, Yi Cheng, yuzhy8701.

## Release 6.1.0 (2023-03-06)

```
Baseline: d60ce2c7c86393638c77698c00c2168a7a936a53

Cherry picks:

   + 490f8badf4f6f4ae8b96697f08267fdb083ccf5f:
     kshyanashree is the release manager of 6.0.0
   + 4e66d9340037f0be83d7bc0fdd809a09344ab83f:
     Automated rollback of commit
     2a2890913eb8f39299aa4b614ba96266ea8749f6.
   + 48a8d01b05149757f69a6a65a22a280bf003cd24:
     Allow C/C++ coverage collection for external targets
   + ec7be346adc00c4bde22d116fca80ef59da66121:
     Temporarily set parent directory of the input to writable if it
     is not.
   + b0984342eef068640a57aab584dd4c118f0dd394:
     Infer CPUs for tvOS and watchOS when on Apple Silicon
   + 5cea7dda5b632703cf4e0424ba09cd7c5bd6fc06:
     Improve the documentation for ctx.actions.symlink.
   + a82d26f17a99b5417b2212a0ce3a1bbc0285e5c4:
     Add quotes to "Tip"
   + 75b0f3aa95bc34f6620ea74e47d4822bd985efdd:
     Write a repo mapping manifest in the runfiles directory (#16555)
   + 07c5c1aa6d0b63605ae793dce78d26122af64a84:
     Ensure repository names don't start with `~`
   + 30f6c8238f39c4a396b3cb56a98c1a2e79d10bb9:
     Escape tilde more gracefully
   + cf3f48ca49f089615417636763d753811acf717f:
     Relax `Label` repo visibility validation
   + 4477823e2c2bc3d0335c41f971364dda72a3f69a:
     Use "apparent name" instead of "local name" in Bzlmod docs
   + 55f4f4834ef30321a00dab5b58202dd1e9716fd9:
     Bazel DevSite: Add required css file.
   + a706994ac69e3f3fed361c61378de847b50d3b12:
     Remove logic that increases delay between progress updates over
     time
   + 1d514ab05896f34ec91c2145f4dffafd3364030f:
     Remove references to io_bazel repository
   + b0357bd3831b26b5116dc120807e8264acf139db:
     Relnotes python script
   + 8f956511bb115c39ac683a1e78971fcf9dce5deb:
     Allow Java coverage collection for external targets
   + bddb191d3f99402330c67b89375409c31ee22daa:
     Fix race condition in package-bazel.sh
   + a75785279f543f4e33c697dd9e8873a6504b7818:
     Decanonicalize labels emitted by {a,c,}query if possible
   + 9d250edb63f27f9f4591bb5a71059710cc6dca9e:
     Add uniquify parameter to TemplateDict.add_joined
   + f02bcf8d8b0d00ecdd06ea0a45ba4f52e436597c:
     Fix identical gcov json file name problem
   + a1593309f66f892871e334013815b05350b4188f:
     Add `$(rlocationpath(s) ...)` expansion
   + 56f54daf9ff3b1177eee31e342e8d6b959d5ac34:
     Rollup of SBOM correctness fixes (#16655)
   + 72e6e948d30dec9dec60d78efef4eeda5b764a8f:
     [cc] Add cc toolchain to starlark cc_proto_library (#16661)
   + 8f28513893969b6346d965cab12aac69cb246ced:
     Make C++ runfiles library repo mapping aware
   + 95f9adc5ac544b1161d69a7ca74432479fdc29b3:
     Always collect FileProvider's filesToBuild as data runfiles
   + 4959d34e844714b793b2c6fa05016a9a6eaa7044:
     fix: export constraints.bzl file from @local_config_platform so
     it can be used in downstream bzl_library targets
   + 4919d4a61d8506d175b25a035500842b8bfe3d0d:
     Add --host_per_file_copt (#16695)
   + 0a23d46976c3fc999d44fbd1e37732ec2442d485:
     Moving some tests for `RemoteActionFileSystem` of BwoB to a base
     class.
   + 9296068be5e3808eb03a3b61f3af3a2c88f7ab7d:
     [remote/downloader] Don't include headers in `FetchBlobRequest`
   + 128d833fee99f8a43bc4de82cbec752e4ce6fb47:
     [remote] Respect whether the server supports action cache updates
   + 38c501912fc4efc14abc0741d19f5f8e8763afcb:
     [remote/downloader] Migrate `Downloader` to take `Credentials`
     (#16732)
   + 5929cb72aa01768e6352898b1a056ef678c81d90:
     Stage repository mapping manifest as a root symlink (#16733)
   + 455454a56e961affb041a1d4a9214f7f313a05aa:
     Expose current repository name to Java with @AutoBazelRepository
   + 97dea593e568f776361397f7280d6a16eee2efeb:
     Implement getDirectoryEntries and readdir for
     RemoteActionFileSystem.
   + aa45f5f3301c5005294df084cdf99c45d6f95d53:
     Move integration tests for BwoB to a base class and add more
     tests there.
   + 1b073ac0a719a09c9b2d1a52680517ab22dc971e:
     Make Java runfiles library repo mapping aware
   + 148bbb1c025a628643698f65627333d86975c1d7:
     Use `_repo_mapping` in C++ runfiles library (#16752)
   + 25558ada3fb377cfc2c965d3a93250ca28ce0fc1:
     Add --experimental_action_cache_store_output_metadata to the
     expansio…
   + 6e945e8ab422ca0a195d09899cce61ba6c0cfa59:
     Treat `DEBUG` events as progress-like.
   + 1940c5d68136ce2079efa8ff74d4e5fdf63ee3e6:
     redact 'token' strings from logging
   + 0b645254b41edc738c6641fd192fca86203ff2e2:
     Make Bash runfiles library repo mapping aware (#16753)
   + 4caae75b49e815ad2cf1d805f316bc374f03f2ae:
     Automated rollback of commit
     8f956511bb115c39ac683a1e78971fcf9dce5deb.
   + 13ff6d9e37999e00fda9a6cef278c7c924924f34:
     Fix Bash rlocation failure with stricter Bash options
   + bd88c7e47b911e5fa1f8a3c26d0f8317943c43ce:
     Make bazel Android remote deps compatible with bzlmod (#16772)
   + 6f6d4cca36a3b64009ed9c8b3fb13cb3c7ed915a:
     Flip `--incompatible_always_include_files_in_data`
   + 94355b1b1c4f7ef923457b8b2a070e5c6528240a:
     Add required `--add-opens` server JVM args also with
     non-embedded JDK
   + 8349c95fc98beb4008085942a67a57f0c4da074b:
     Also collect clang resource directory with
     `-no-canonical-prefixes`
   + dce6ed777d958d65c7f3d4a2f54f8117778a449e:
     Make `bazel run` works with minimal mode
   + ca8674cc4879ed1846bf015c33fe7d920a3f66ab:
     Include source files with `cquery --output=files` (#16826)
   + 9cb5e0a31665d3b3f25bf58ec2dee696e828d8b9:
     Fsync before rename after copy in DiskCacheClient
   + 23ffce53b92ef96432d8c6c58cc95ac362bab1bc:
     Update GetActionResult for disk cache to check referenced files
     when …
   + 0bc0ff5244142eb3348d42025ce21eeb337ad189:
     Make Java runfiles library compilable with JDK 8
   + fe169654a29d8ad33105d5d0034a7857834fed5d:
     [6.0.0] Default --incompatible_strict_conflict_checks to true.
     (#16864)
   + 99ca86f7c2968741ac3a9b20c3375fc992d49e66:
     Revert "[6.0.0] Default --incompatible_strict_conflict_checks to
     true. (#16864)" (#16872)
   + 312238f2b1414c98ed7d7d51dc4e18278edb2540:
     Make C++ runfiles library build with `-Werror=shadow`
   + 2baa5a4284467d70f1b31ea779b79d38ef07d164:
     Keep credentials cached across build commands.
   + 8818a57fce32a7872f045f03a334e1c9403724d3:
     [6.0.0] Only inject metadata for outputs that cannot be
     reconstructed by skyf… (#16879)
   + 31e4bf409eed71e8fb626092189eacb95f80fed9:
     Update java_tools v11.9
   + cd40666001e8d599bb61735898c195c6d2fae55b:
     replace _get_canonical_form(label) with str(label)
   + e2bc2374188b41924223385ad943db610e92e6c4:
     Avoid exceptions from hermetic sandbox for unsupported artifact
     subclasses
   + b564d145218e58b0440ffad82b3d1d54eef15d22:
     Remove warnings about ignored starlark options
   + 7ccc66108f08f7b6c6f6e5229f70f29962ea19ce:
     [6.0.0] Emit Tree objects in topological order (#16904)
   + 86dee6d2ecb269e0c41a97718812054394ee51a4:
     Correctly match regex with tree artifact
   + 14925b574aa63aad098f2c3d95e14b46ffd295ec:
     Always use target's attributes to set Python version (#16959)
   + a247502d28d8d70d648390de52952189b99a0bb7:
     Add 'toolchain' parameter to actions.{run,run_shell}
   + 497b7e403d6e5523bd1310bd1fe83c4ce1a6b1ec:
     Fix Bash `runfiles_current_repository` with RBE
   + 0a2c4edbc86398266525f31948d67a5736890bfe:
     Fix corner cases in Bash runfiles library
   + 33b514b25963452be71a015e08d4e890405b00a3:
     Fix runfiles creation with MANIFEST when building without the
     bytes
   + 3a13af41034e1f80cc0fbc1634cf8f724a85b78f:
     Remove LCOV merger dependency of `cc_test` without coverage
     (#17004)
   + 25ba76c1b8d420ebae43c1f59890ae46153c2240:
     Include full tree artifact in inputs when prefetcher doesn't
     support partial tree artifacts.
   + 06deebfb5b73f848de5a0ea0e00fcfaa26788d1f:
     Release 6.0.0 (2022-12-19)
   + c2bfb2e98d133c62be328e6e93c4b4bdf766d82c:
     Enable git_submodules tests and merge git_repository and
     starlark_git_repository (#17247)
   + e8182ce32931560406fee1c30745e56a2ee9a6b3:
     have 'bazel test' non-test targets depend on
     --remote_download_output
   + c3245cd028977877aa9e485451b29c7736ebcae0:
     Add `SpellChecker` suggestions for common Bzlmod errors
   + 8ec874348226995c4101b2173a465ddc65cab591:
     Use xcrun to invoke install_name_tool
   + 2b2bea4ee9d51ad875a8d273aa344ac9c5b6742c:
     Extra resources
   + 5b4de12b37cb4ba921b6bdfe810bbb47921ab3a6:
     Do not clear `--platforms` on no-op change to `--cpu`
   + db3c0130b3363485a366897e1c1f2adc5d41fde6:
     Report `AspectCreationException` to the user
   + 53e9fea30e58ab479e5cd7a6c804634f56fc2ddb:
     Use long executable path instead of `argv[0]` in all launchers
   + abae5ca3e8142f93cf0c2597e3410ed955c4dd59:
     Add sanitizer features to unix_cc_toolchain_config
   + db684196afd3b1a0a0e7d883674324bd161ae8bf:
     Allow `map_each` to return `None` in `TemplateDict#add_joined`
   + 66b58ee904efa22696edc1b78a59bac91da9ed8d:
     Always emit trailing zero in human-readable download progress
   + 17b8e448a5e5589f96c2794cb38c86b0c64e86c0:
     Upload all logs in BEP even with minimal upload
   + 28d2daae70be6ee97b876b0568796ceb87af9523:
     Set `--experimental_action_listeners` to default in `exec` config
   + 16427c9050db140d6cb90d7d6324d4a2ff1e249a:
     Do not count tests as failed that have not started
   + 094a0aabed1e018e6503bc3ac844c8022b71a527:
     Accept tildes in --override_module
   + 5f2866f8434ce9a17cf82c001efb7b236f189115:
     Do the AC integrity check for disk part of the combined cache.
   + cd10d508e20a4964586b46f7edea8a6dc900157c:
     Fix `--nozip_undeclared_test_outputs` on Windows
   + 073f54b9a7c46afd2c28b4a99a235bdd6b63bb5f:
     Allow pyd in extensions of dynamic libraries
   + ac504cbb463e76b1374d0060534acabbccb408d2:
     Register JavaCompileActionContext in Bazel.
   + f090433fcf0f42639608b9c5f0243018c1bb9ac7:
     Rollback #14510 because it causes remote test execution to fail
   + 942dddaaad9bf4fbb20b66535aad4fc464ad69ba:
     Prepare backwards compatible usage of optional C++ toolchain
   + 88b51f57d09e43dec31a84d4b636595924d5bfef:
     Emit LLVM coverage for source file paths with a `tmp` segment
   + bb0b886271d45209e3bef476da37811b9dd2afe5:
     Enable archive_param_file feature by default for Windows
   + baf97c00c891acf844a29b4cc31abb45b5c434e5:
     Allow `TemplateDict#map_each` callback to return a list of
     strings (#17306)
   + fcb007749f7f24b36c2b7c4284378bba20fc8b69:
     Only try to create groups of test actions in the ui.
   + 3c47b4716e6eca2b8ab06253915ef8d1bdd28038:
     Find `libtool` when using `BAZEL_USE_CPP_ONLY_TOOLCHAIN`.
   + 1da8a825c0fba882f33ea6998a76ff8265fcd32c:
     Add -dead_strip in default opt link flags for darwin
   + b0c5eb30b2738bf6454c3026a3e0f37579d5854c:
     Dont query remote cache but always use bytestream protocol
   + 00e9af1985cc0227599516fe7568785ca4334050:
     Allow Java coverage collection for external targets.
   + dd24a0022a0ff959598da2c9bc097d27083be1a0:
     Test and fix root symlink edge case in runfiles library
   + af97d9830d3207893cc6f5c851431a28f1721acb:
     [6.1.0] Fix broken CI (#17422)
   + b859571804f2095caaf018b172b59c90f185fd51:
     Add `native.package_relative_label` function
   + 82168d44ee1d49cf2f406903b6d8b9fde0e66cf2:
     Make Bazel more responsive and use less memory when --jobs is
     high (#17398)
   + 84c1ed430405b154b6e9eb2c28281f450e250eff:
     Multiplex worker fixes and tests for Android busybox tools
     (#17371)
   + 07590818d6ce0d0e66c2377db7e73fb6ee6702e5:
     Improve error message for concurrent modifications (#17396)
   + 27bc896f36f0e0ea5dbeaaa16f3a124e38a7284a:
     [6.1.0] Make bazel coverage work with minimal mode (#17397)
   + 544b8164ca352cf06dda0849a589b825631428af:
     [6.1.0] Fix cc_binary bug related to cc_shared_library on
     Windows and prepare for future removal of
     --experimental_cc_shared_library flag (#17445)
   + 9a7aa21c8cd6f38d10e23e265dd650bf031f9b7c:
     Fix Bash `runfiles_current_repository` for tools
   + 911eedc0badcefdbc60a936ae73972772042fc8a:
     Fix label unambiguous canonical form to correctly report
     non-visible repo names
   + e132653ead5e50f4226dbff7776466fef1918f49:
     Remove O1 from sanitizer feature flag defaults
   + ba9e2f8fe666b4fc6110d86ea93cc11779e77068:
     Remove usage of gRPC Context cancellation in the remote
     execution client.
   + de03a2363d016782c5dfe7c55b5cf06cb610f6a2:
     Allow -v to libtool
   + 4e35c02c7c400bfbbfa69164a1ec3bd51966ca79:
     Prettify labels in action progress messages with Bzlmod (#17278)
   + 1be0ac3e73698e31a349ece629c887b06e102a0b:
     Expand tree outputs before eagerly prefetching them for local
     actions. (#17494)
   + c26665102d0d524bb42be8cd205c7b31a22a75c9:
     Fix Java coverage collection with Java 8 runtime
   + 1a6ffe6d453708e3cefc98a07965c680e48d6bac:
     Add a flag to disable execution log sorting.
   + fbec8e2ad1dcbebbbc96491f8b6b208f5b3ac91f:
     Reduce flakiness on Windows for BwoB tests
   + 420659a9ad2a98f57e057d8c22eb621e3b12803e:
     Make AutoBazelRepositoryProcessor compatible with Java 8
   + dde6d20b3fd1d7a14825649c9c89d1c4d2d5242b:
     Do not recommend `shallow_since` for `git_repository`
   + f76fc61640825dd7cf83ce02ba48a4e4f95b66ff:
     Allow the timeout value for execute calls on a mac to be set via
     an environment variable
   + 773d232f528276338098578a28c19c742e3b4e7e:
     Fix RPATHs for cc toolchain solib when sibling layout is used
   + 5932b3b8886ddb5aba271fd907f1371e67960a44:
     [6.1.0] Add --host_features (#17528)
   + a0fa77cc36d02f5f230335556a1829b298b2f219:
     Exit with code 39 if remote cache evicted blobs that Bazel need
     during an invocation (#17496)
   + 1a438b41b74d94fd8b6ff4dcf20b4526530e3c6e:
     Only fetch @remote_coverage_tools when collecting coverage
     (#17512)
   + ee1daaf9852d568dcf38357eadd77b9de953db36:
     [6.1.0]Only fetch @remote_coverage_tools when collecting
     coverage (#17287)
   + 350e32952bdd639969e2aff7887c5dc34c21bce6:
     [6.1.0]Fix symlink file creation overhead (#17488)
   + 5406c953574d48434d33b1cf49b70b718795d783:
     [6.1.0] Cleanup stale state when remote cache evicted (#17538)
   + 2d1b570e976773134a6244dd012e93a5478f6d4a:
     Bump version number in runfiles.bash init code
   + 3ab8a0a5d628a0d958fb2eb1c0d5bb76b442e2f2:
     [6.1.0]Let `aquery` print effective environment for all
     `CommandAction`s (#17274)
   + 51e6c38ae808df4f2bf8fb29b4c5173e06ac014a:
     Properly report repo fetch progress during main repo mapping
     computation
   + 744108e88681e770982f148161d328c9b77319a1:
     [docs] Update migrating to Xcode tutorial (#17563)
   + 9dc7a7e6881f58965103b42390560589e0f38b48:
     Update //third_party:jsr305 (#17557)
   + 43dadb275b3f9690242bf2d94a0757c721d231a9:
     Bump minimum supported macOS versions to 10.13
   + 7d9d23c1ac1b7fcaa461f902e286f50fbb7cb116:
     Correctly set default subprocess factory when loading class
     `SubprocessBuilder`.
   + 77f82f4fab189fd042754be0a7747042d9b01b8f:
     Add an --incompatible_strict_conflict_checks alias for
     --experimental_strict_conflict_checks.
   + e05345dec405a0333c48ff188d2d9a1be90dad53:
     Add support for wrapping system streams in WorkRequestHandler
   + 68e1924cdab69ab92b8acf2f6e9324d11e00b267:
     Also handle remote cache eviction for tree artifacts. (#17601)
   + 4a6d056a8d058ab98a01348fb0c046660ee99a71:
     Add host transition to lcov_merger in Java version of py_test
   + 546e9e2942cb2e98b4c93065cc2d2910878dc900:
     Fix Bazel 6.0 crash regression (#17613)
   + 7e328bb71004e1976525d8b813ca0d616e2af74b:
     Include Bazel version information in profile metadata. (#17616)
   + aafe1235c55f6cdcfc577a40736aaeb9ebaca23b:
     [6.1.0] Handle remote cache eviction when uploading inputs for
     remote actions. (#17605)
   + 938e34823206a2644d538ba655d20ac553352975:
     [6.1.0] Rerun the artifact conflict check when
     --incompatible_strict_conflict_checks changes. (#17592)
   + 034a2815a1e18be5c8b36c6a78f44bb849dff437:
     Report background download for BwoB (#17619)
   + 5afbce52c70cf974eaa4a3bbbc376f398271427d:
     [6.1.0] Flag for writable outputs (experimental) (#17617)
   + d4105e658001677929338835eb970e6595e66b3c:
     [6.1.0] Allow .wasm cc executable and dynamic library extension
     (#17440)
   + a306f4f7fd440d006aa6ae9234b4430f13bc8cf9:
     make desugar dependencies deterministic
   + 37953c56ea77c7aa7bea677f3481557fdb2c2a15:
     Apply exec transition to lcov_merger in sh_test and cc_test
   + 1d73d72a45598e38c51b2618bb6fe4f27b390cb8:
     [6.1.0]Fix --host_features with multiple transitions (#17641)
```

Incompatible changes:

  - Bazel no longer increases the delay between progress updates when
    there is no cursor control.
  - `--incompatible_always_include_files_in_data` is flipped
    to true. See https://github.com/bazelbuild/bazel/issues/16654 for
    details.
  - `cquery --output=files` also outputs source files.
    
    Closes #16602.
  - `--incompatible_strict_conflict_checks` is flipped to true. See
    https://github.com/bazelbuild/bazel/issues/16729 for details.
  - This changes the behavior of Python version in exec/host
    configuration. Mitigation is to set Python version on the targets.
  - `--features` only applies to targets built in the target
    configuration, and `--host_features` is used for the host / exec
    configuration (gated behind `--incompatible_use_host_features`)
    
    Fixes https://github.com/bazelbuild/bazel/issues/13839
    
    Closes #16626.

Important changes:

  - The new path variable `$(rlocationpath ...)` and its plural form
    `$(rlocationpaths ...)` can be used to expand labels to the paths
    accepted by the `Rlocation` function of runfiles libraries. This
    is the preferred way to access data dependencies at runtime and
    works on all platforms, even when runfiles are not enabled (e.g.,
    on Windows by default).
    
    Work towards #16124
    Fixes #10923
    
    Closes #16428.
  - Starlark `print()` statements are now emitted iff the line of
    code is executed. They are no longer replayed on subsequent
    invocations unless the Starlark code is re-executed.
    Additionally, multiple identical `print()` statements (same
    string from the same line of code, e.g. from a loop) are all
    emitted and no longer deduplicated.
  - Fixes a bug where some compilation flags would not be applied to
    a cc_test
  - Added a `native.package_relative_label()` function, which
    converts a label string to a Label object in the context of the
    calling package, in contrast to `Label()`, which does so in the
    context of the current .bzl file. Both functions now also accept
    relative labels such as `:foo`, and are idempotent.

This release contains contributions from many people at Google, as well as Brentley Jones, Ezekiel Warren, Fabian Meumertzheim, keertk, Keith Smiley, Krzysztof Naglik, kshyanashree, lunch-glide-pepper, oquenchil, Ted Kaplan, Ted Kaplan, UebelAndre, Xùdōng Yáng, Yannic, yuzhy8701.

## Release 6.1.0 (2023-03-06)

```
Baseline: d60ce2c7c86393638c77698c00c2168a7a936a53

Cherry picks:

   + 490f8badf4f6f4ae8b96697f08267fdb083ccf5f:
     kshyanashree is the release manager of 6.0.0
   + 4e66d9340037f0be83d7bc0fdd809a09344ab83f:
     Automated rollback of commit
     2a2890913eb8f39299aa4b614ba96266ea8749f6.
   + 48a8d01b05149757f69a6a65a22a280bf003cd24:
     Allow C/C++ coverage collection for external targets
   + ec7be346adc00c4bde22d116fca80ef59da66121:
     Temporarily set parent directory of the input to writable if it
     is not.
   + b0984342eef068640a57aab584dd4c118f0dd394:
     Infer CPUs for tvOS and watchOS when on Apple Silicon
   + 5cea7dda5b632703cf4e0424ba09cd7c5bd6fc06:
     Improve the documentation for ctx.actions.symlink.
   + a82d26f17a99b5417b2212a0ce3a1bbc0285e5c4:
     Add quotes to "Tip"
   + 75b0f3aa95bc34f6620ea74e47d4822bd985efdd:
     Write a repo mapping manifest in the runfiles directory (#16555)
   + 07c5c1aa6d0b63605ae793dce78d26122af64a84:
     Ensure repository names don't start with `~`
   + 30f6c8238f39c4a396b3cb56a98c1a2e79d10bb9:
     Escape tilde more gracefully
   + cf3f48ca49f089615417636763d753811acf717f:
     Relax `Label` repo visibility validation
   + 4477823e2c2bc3d0335c41f971364dda72a3f69a:
     Use "apparent name" instead of "local name" in Bzlmod docs
   + 55f4f4834ef30321a00dab5b58202dd1e9716fd9:
     Bazel DevSite: Add required css file.
   + a706994ac69e3f3fed361c61378de847b50d3b12:
     Remove logic that increases delay between progress updates over
     time
   + 1d514ab05896f34ec91c2145f4dffafd3364030f:
     Remove references to io_bazel repository
   + b0357bd3831b26b5116dc120807e8264acf139db:
     Relnotes python script
   + 8f956511bb115c39ac683a1e78971fcf9dce5deb:
     Allow Java coverage collection for external targets
   + bddb191d3f99402330c67b89375409c31ee22daa:
     Fix race condition in package-bazel.sh
   + a75785279f543f4e33c697dd9e8873a6504b7818:
     Decanonicalize labels emitted by {a,c,}query if possible
   + 9d250edb63f27f9f4591bb5a71059710cc6dca9e:
     Add uniquify parameter to TemplateDict.add_joined
   + f02bcf8d8b0d00ecdd06ea0a45ba4f52e436597c:
     Fix identical gcov json file name problem
   + a1593309f66f892871e334013815b05350b4188f:
     Add `$(rlocationpath(s) ...)` expansion
   + 56f54daf9ff3b1177eee31e342e8d6b959d5ac34:
     Rollup of SBOM correctness fixes (#16655)
   + 72e6e948d30dec9dec60d78efef4eeda5b764a8f:
     [cc] Add cc toolchain to starlark cc_proto_library (#16661)
   + 8f28513893969b6346d965cab12aac69cb246ced:
     Make C++ runfiles library repo mapping aware
   + 95f9adc5ac544b1161d69a7ca74432479fdc29b3:
     Always collect FileProvider's filesToBuild as data runfiles
   + 4959d34e844714b793b2c6fa05016a9a6eaa7044:
     fix: export constraints.bzl file from @local_config_platform so
     it can be used in downstream bzl_library targets
   + 4919d4a61d8506d175b25a035500842b8bfe3d0d:
     Add --host_per_file_copt (#16695)
   + 0a23d46976c3fc999d44fbd1e37732ec2442d485:
     Moving some tests for `RemoteActionFileSystem` of BwoB to a base
     class.
   + 9296068be5e3808eb03a3b61f3af3a2c88f7ab7d:
     [remote/downloader] Don't include headers in `FetchBlobRequest`
   + 128d833fee99f8a43bc4de82cbec752e4ce6fb47:
     [remote] Respect whether the server supports action cache updates
   + 38c501912fc4efc14abc0741d19f5f8e8763afcb:
     [remote/downloader] Migrate `Downloader` to take `Credentials`
     (#16732)
   + 5929cb72aa01768e6352898b1a056ef678c81d90:
     Stage repository mapping manifest as a root symlink (#16733)
   + 455454a56e961affb041a1d4a9214f7f313a05aa:
     Expose current repository name to Java with @AutoBazelRepository
   + 97dea593e568f776361397f7280d6a16eee2efeb:
     Implement getDirectoryEntries and readdir for
     RemoteActionFileSystem.
   + aa45f5f3301c5005294df084cdf99c45d6f95d53:
     Move integration tests for BwoB to a base class and add more
     tests there.
   + 1b073ac0a719a09c9b2d1a52680517ab22dc971e:
     Make Java runfiles library repo mapping aware
   + 148bbb1c025a628643698f65627333d86975c1d7:
     Use `_repo_mapping` in C++ runfiles library (#16752)
   + 25558ada3fb377cfc2c965d3a93250ca28ce0fc1:
     Add --experimental_action_cache_store_output_metadata to the
     expansio…
   + 6e945e8ab422ca0a195d09899cce61ba6c0cfa59:
     Treat `DEBUG` events as progress-like.
   + 1940c5d68136ce2079efa8ff74d4e5fdf63ee3e6:
     redact 'token' strings from logging
   + 0b645254b41edc738c6641fd192fca86203ff2e2:
     Make Bash runfiles library repo mapping aware (#16753)
   + 4caae75b49e815ad2cf1d805f316bc374f03f2ae:
     Automated rollback of commit
     8f956511bb115c39ac683a1e78971fcf9dce5deb.
   + 13ff6d9e37999e00fda9a6cef278c7c924924f34:
     Fix Bash rlocation failure with stricter Bash options
   + bd88c7e47b911e5fa1f8a3c26d0f8317943c43ce:
     Make bazel Android remote deps compatible with bzlmod (#16772)
   + 6f6d4cca36a3b64009ed9c8b3fb13cb3c7ed915a:
     Flip `--incompatible_always_include_files_in_data`
   + 94355b1b1c4f7ef923457b8b2a070e5c6528240a:
     Add required `--add-opens` server JVM args also with
     non-embedded JDK
   + 8349c95fc98beb4008085942a67a57f0c4da074b:
     Also collect clang resource directory with
     `-no-canonical-prefixes`
   + dce6ed777d958d65c7f3d4a2f54f8117778a449e:
     Make `bazel run` works with minimal mode
   + ca8674cc4879ed1846bf015c33fe7d920a3f66ab:
     Include source files with `cquery --output=files` (#16826)
   + 9cb5e0a31665d3b3f25bf58ec2dee696e828d8b9:
     Fsync before rename after copy in DiskCacheClient
   + 23ffce53b92ef96432d8c6c58cc95ac362bab1bc:
     Update GetActionResult for disk cache to check referenced files
     when …
   + 0bc0ff5244142eb3348d42025ce21eeb337ad189:
     Make Java runfiles library compilable with JDK 8
   + fe169654a29d8ad33105d5d0034a7857834fed5d:
     [6.0.0] Default --incompatible_strict_conflict_checks to true.
     (#16864)
   + 99ca86f7c2968741ac3a9b20c3375fc992d49e66:
     Revert "[6.0.0] Default --incompatible_strict_conflict_checks to
     true. (#16864)" (#16872)
   + 312238f2b1414c98ed7d7d51dc4e18278edb2540:
     Make C++ runfiles library build with `-Werror=shadow`
   + 2baa5a4284467d70f1b31ea779b79d38ef07d164:
     Keep credentials cached across build commands.
   + 8818a57fce32a7872f045f03a334e1c9403724d3:
     [6.0.0] Only inject metadata for outputs that cannot be
     reconstructed by skyf… (#16879)
   + 31e4bf409eed71e8fb626092189eacb95f80fed9:
     Update java_tools v11.9
   + cd40666001e8d599bb61735898c195c6d2fae55b:
     replace _get_canonical_form(label) with str(label)
   + e2bc2374188b41924223385ad943db610e92e6c4:
     Avoid exceptions from hermetic sandbox for unsupported artifact
     subclasses
   + b564d145218e58b0440ffad82b3d1d54eef15d22:
     Remove warnings about ignored starlark options
   + 7ccc66108f08f7b6c6f6e5229f70f29962ea19ce:
     [6.0.0] Emit Tree objects in topological order (#16904)
   + 86dee6d2ecb269e0c41a97718812054394ee51a4:
     Correctly match regex with tree artifact
   + 14925b574aa63aad098f2c3d95e14b46ffd295ec:
     Always use target's attributes to set Python version (#16959)
   + a247502d28d8d70d648390de52952189b99a0bb7:
     Add 'toolchain' parameter to actions.{run,run_shell}
   + 497b7e403d6e5523bd1310bd1fe83c4ce1a6b1ec:
     Fix Bash `runfiles_current_repository` with RBE
   + 0a2c4edbc86398266525f31948d67a5736890bfe:
     Fix corner cases in Bash runfiles library
   + 33b514b25963452be71a015e08d4e890405b00a3:
     Fix runfiles creation with MANIFEST when building without the
     bytes
   + 3a13af41034e1f80cc0fbc1634cf8f724a85b78f:
     Remove LCOV merger dependency of `cc_test` without coverage
     (#17004)
   + 25ba76c1b8d420ebae43c1f59890ae46153c2240:
     Include full tree artifact in inputs when prefetcher doesn't
     support partial tree artifacts.
   + 06deebfb5b73f848de5a0ea0e00fcfaa26788d1f:
     Release 6.0.0 (2022-12-19)
   + c2bfb2e98d133c62be328e6e93c4b4bdf766d82c:
     Enable git_submodules tests and merge git_repository and
     starlark_git_repository (#17247)
   + e8182ce32931560406fee1c30745e56a2ee9a6b3:
     have 'bazel test' non-test targets depend on
     --remote_download_output
   + c3245cd028977877aa9e485451b29c7736ebcae0:
     Add `SpellChecker` suggestions for common Bzlmod errors
   + 8ec874348226995c4101b2173a465ddc65cab591:
     Use xcrun to invoke install_name_tool
   + 2b2bea4ee9d51ad875a8d273aa344ac9c5b6742c:
     Extra resources
   + 5b4de12b37cb4ba921b6bdfe810bbb47921ab3a6:
     Do not clear `--platforms` on no-op change to `--cpu`
   + db3c0130b3363485a366897e1c1f2adc5d41fde6:
     Report `AspectCreationException` to the user
   + 53e9fea30e58ab479e5cd7a6c804634f56fc2ddb:
     Use long executable path instead of `argv[0]` in all launchers
   + abae5ca3e8142f93cf0c2597e3410ed955c4dd59:
     Add sanitizer features to unix_cc_toolchain_config
   + db684196afd3b1a0a0e7d883674324bd161ae8bf:
     Allow `map_each` to return `None` in `TemplateDict#add_joined`
   + 66b58ee904efa22696edc1b78a59bac91da9ed8d:
     Always emit trailing zero in human-readable download progress
   + 17b8e448a5e5589f96c2794cb38c86b0c64e86c0:
     Upload all logs in BEP even with minimal upload
   + 28d2daae70be6ee97b876b0568796ceb87af9523:
     Set `--experimental_action_listeners` to default in `exec` config
   + 16427c9050db140d6cb90d7d6324d4a2ff1e249a:
     Do not count tests as failed that have not started
   + 094a0aabed1e018e6503bc3ac844c8022b71a527:
     Accept tildes in --override_module
   + 5f2866f8434ce9a17cf82c001efb7b236f189115:
     Do the AC integrity check for disk part of the combined cache.
   + cd10d508e20a4964586b46f7edea8a6dc900157c:
     Fix `--nozip_undeclared_test_outputs` on Windows
   + 073f54b9a7c46afd2c28b4a99a235bdd6b63bb5f:
     Allow pyd in extensions of dynamic libraries
   + ac504cbb463e76b1374d0060534acabbccb408d2:
     Register JavaCompileActionContext in Bazel.
   + f090433fcf0f42639608b9c5f0243018c1bb9ac7:
     Rollback #14510 because it causes remote test execution to fail
   + 942dddaaad9bf4fbb20b66535aad4fc464ad69ba:
     Prepare backwards compatible usage of optional C++ toolchain
   + 88b51f57d09e43dec31a84d4b636595924d5bfef:
     Emit LLVM coverage for source file paths with a `tmp` segment
   + bb0b886271d45209e3bef476da37811b9dd2afe5:
     Enable archive_param_file feature by default for Windows
   + baf97c00c891acf844a29b4cc31abb45b5c434e5:
     Allow `TemplateDict#map_each` callback to return a list of
     strings (#17306)
   + fcb007749f7f24b36c2b7c4284378bba20fc8b69:
     Only try to create groups of test actions in the ui.
   + 3c47b4716e6eca2b8ab06253915ef8d1bdd28038:
     Find `libtool` when using `BAZEL_USE_CPP_ONLY_TOOLCHAIN`.
   + 1da8a825c0fba882f33ea6998a76ff8265fcd32c:
     Add -dead_strip in default opt link flags for darwin
   + b0c5eb30b2738bf6454c3026a3e0f37579d5854c:
     Dont query remote cache but always use bytestream protocol
   + 00e9af1985cc0227599516fe7568785ca4334050:
     Allow Java coverage collection for external targets.
   + dd24a0022a0ff959598da2c9bc097d27083be1a0:
     Test and fix root symlink edge case in runfiles library
   + af97d9830d3207893cc6f5c851431a28f1721acb:
     [6.1.0] Fix broken CI (#17422)
   + b859571804f2095caaf018b172b59c90f185fd51:
     Add `native.package_relative_label` function
   + 82168d44ee1d49cf2f406903b6d8b9fde0e66cf2:
     Make Bazel more responsive and use less memory when --jobs is
     high (#17398)
   + 84c1ed430405b154b6e9eb2c28281f450e250eff:
     Multiplex worker fixes and tests for Android busybox tools
     (#17371)
   + 07590818d6ce0d0e66c2377db7e73fb6ee6702e5:
     Improve error message for concurrent modifications (#17396)
   + 27bc896f36f0e0ea5dbeaaa16f3a124e38a7284a:
     [6.1.0] Make bazel coverage work with minimal mode (#17397)
   + 544b8164ca352cf06dda0849a589b825631428af:
     [6.1.0] Fix cc_binary bug related to cc_shared_library on
     Windows and prepare for future removal of
     --experimental_cc_shared_library flag (#17445)
   + 9a7aa21c8cd6f38d10e23e265dd650bf031f9b7c:
     Fix Bash `runfiles_current_repository` for tools
   + 911eedc0badcefdbc60a936ae73972772042fc8a:
     Fix label unambiguous canonical form to correctly report
     non-visible repo names
   + e132653ead5e50f4226dbff7776466fef1918f49:
     Remove O1 from sanitizer feature flag defaults
   + ba9e2f8fe666b4fc6110d86ea93cc11779e77068:
     Remove usage of gRPC Context cancellation in the remote
     execution client.
   + de03a2363d016782c5dfe7c55b5cf06cb610f6a2:
     Allow -v to libtool
   + 4e35c02c7c400bfbbfa69164a1ec3bd51966ca79:
     Prettify labels in action progress messages with Bzlmod (#17278)
   + 1be0ac3e73698e31a349ece629c887b06e102a0b:
     Expand tree outputs before eagerly prefetching them for local
     actions. (#17494)
   + c26665102d0d524bb42be8cd205c7b31a22a75c9:
     Fix Java coverage collection with Java 8 runtime
   + 1a6ffe6d453708e3cefc98a07965c680e48d6bac:
     Add a flag to disable execution log sorting.
   + fbec8e2ad1dcbebbbc96491f8b6b208f5b3ac91f:
     Reduce flakiness on Windows for BwoB tests
   + 420659a9ad2a98f57e057d8c22eb621e3b12803e:
     Make AutoBazelRepositoryProcessor compatible with Java 8
   + dde6d20b3fd1d7a14825649c9c89d1c4d2d5242b:
     Do not recommend `shallow_since` for `git_repository`
   + f76fc61640825dd7cf83ce02ba48a4e4f95b66ff:
     Allow the timeout value for execute calls on a mac to be set via
     an environment variable
   + 773d232f528276338098578a28c19c742e3b4e7e:
     Fix RPATHs for cc toolchain solib when sibling layout is used
   + 5932b3b8886ddb5aba271fd907f1371e67960a44:
     [6.1.0] Add --host_features (#17528)
   + a0fa77cc36d02f5f230335556a1829b298b2f219:
     Exit with code 39 if remote cache evicted blobs that Bazel need
     during an invocation (#17496)
   + 1a438b41b74d94fd8b6ff4dcf20b4526530e3c6e:
     Only fetch @remote_coverage_tools when collecting coverage
     (#17512)
   + ee1daaf9852d568dcf38357eadd77b9de953db36:
     [6.1.0]Only fetch @remote_coverage_tools when collecting
     coverage (#17287)
   + 350e32952bdd639969e2aff7887c5dc34c21bce6:
     [6.1.0]Fix symlink file creation overhead (#17488)
   + 5406c953574d48434d33b1cf49b70b718795d783:
     [6.1.0] Cleanup stale state when remote cache evicted (#17538)
   + 2d1b570e976773134a6244dd012e93a5478f6d4a:
     Bump version number in runfiles.bash init code
   + 3ab8a0a5d628a0d958fb2eb1c0d5bb76b442e2f2:
     [6.1.0]Let `aquery` print effective environment for all
     `CommandAction`s (#17274)
   + 51e6c38ae808df4f2bf8fb29b4c5173e06ac014a:
     Properly report repo fetch progress during main repo mapping
     computation
   + 744108e88681e770982f148161d328c9b77319a1:
     [docs] Update migrating to Xcode tutorial (#17563)
   + 9dc7a7e6881f58965103b42390560589e0f38b48:
     Update //third_party:jsr305 (#17557)
   + 43dadb275b3f9690242bf2d94a0757c721d231a9:
     Bump minimum supported macOS versions to 10.13
   + 7d9d23c1ac1b7fcaa461f902e286f50fbb7cb116:
     Correctly set default subprocess factory when loading class
     `SubprocessBuilder`.
   + 77f82f4fab189fd042754be0a7747042d9b01b8f:
     Add an --incompatible_strict_conflict_checks alias for
     --experimental_strict_conflict_checks.
   + e05345dec405a0333c48ff188d2d9a1be90dad53:
     Add support for wrapping system streams in WorkRequestHandler
   + 68e1924cdab69ab92b8acf2f6e9324d11e00b267:
     Also handle remote cache eviction for tree artifacts. (#17601)
   + 4a6d056a8d058ab98a01348fb0c046660ee99a71:
     Add host transition to lcov_merger in Java version of py_test
   + 546e9e2942cb2e98b4c93065cc2d2910878dc900:
     Fix Bazel 6.0 crash regression (#17613)
   + 7e328bb71004e1976525d8b813ca0d616e2af74b:
     Include Bazel version information in profile metadata. (#17616)
   + aafe1235c55f6cdcfc577a40736aaeb9ebaca23b:
     [6.1.0] Handle remote cache eviction when uploading inputs for
     remote actions. (#17605)
   + 938e34823206a2644d538ba655d20ac553352975:
     [6.1.0] Rerun the artifact conflict check when
     --incompatible_strict_conflict_checks changes. (#17592)
   + 034a2815a1e18be5c8b36c6a78f44bb849dff437:
     Report background download for BwoB (#17619)
   + 5afbce52c70cf974eaa4a3bbbc376f398271427d:
     [6.1.0] Flag for writable outputs (experimental) (#17617)
   + d4105e658001677929338835eb970e6595e66b3c:
     [6.1.0] Allow .wasm cc executable and dynamic library extension
     (#17440)
   + a306f4f7fd440d006aa6ae9234b4430f13bc8cf9:
     make desugar dependencies deterministic
   + 37953c56ea77c7aa7bea677f3481557fdb2c2a15:
     Apply exec transition to lcov_merger in sh_test and cc_test
   + 1d73d72a45598e38c51b2618bb6fe4f27b390cb8:
     [6.1.0]Fix --host_features with multiple transitions (#17641)
```

Incompatible changes:

  - Bazel no longer increases the delay between progress updates when
    there is no cursor control.
  - `--incompatible_always_include_files_in_data` is flipped
    to true. See https://github.com/bazelbuild/bazel/issues/16654 for
    details.
  - `cquery --output=files` also outputs source files.
    
    Closes #16602.
  - `--incompatible_strict_conflict_checks` is flipped to true. See
    https://github.com/bazelbuild/bazel/issues/16729 for details.
  - This changes the behavior of Python version in exec/host
    configuration. Mitigation is to set Python version on the targets.
  - `--features` only applies to targets built in the target
    configuration, and `--host_features` is used for the host / exec
    configuration (gated behind `--incompatible_use_host_features`)
    
    Fixes https://github.com/bazelbuild/bazel/issues/13839
    
    Closes #16626.

Important changes:

  - The new path variable `$(rlocationpath ...)` and its plural form
    `$(rlocationpaths ...)` can be used to expand labels to the paths
    accepted by the `Rlocation` function of runfiles libraries. This
    is the preferred way to access data dependencies at runtime and
    works on all platforms, even when runfiles are not enabled (e.g.,
    on Windows by default).
    
    Work towards #16124
    Fixes #10923
    
    Closes #16428.
  - Starlark `print()` statements are now emitted iff the line of
    code is executed. They are no longer replayed on subsequent
    invocations unless the Starlark code is re-executed.
    Additionally, multiple identical `print()` statements (same
    string from the same line of code, e.g. from a loop) are all
    emitted and no longer deduplicated.
  - Fixes a bug where some compilation flags would not be applied to
    a cc_test
  - Added a `native.package_relative_label()` function, which
    converts a label string to a Label object in the context of the
    calling package, in contrast to `Label()`, which does so in the
    context of the current .bzl file. Both functions now also accept
    relative labels such as `:foo`, and are idempotent.

This release contains contributions from many people at Google, as well as Brentley Jones, Ezekiel Warren, Fabian Meumertzheim, keertk, Keith Smiley, Krzysztof Naglik, kshyanashree, lunch-glide-pepper, oquenchil, Ted Kaplan, Ted Kaplan, UebelAndre, Xùdōng Yáng, Yannic, yuzhy8701.

## Release 7.0.0-pre.20230215.2 (2023-02-24)

```
Baseline: e8a69f5d5acaeb6af760631490ecbf73e8a04eeb

Cherry picks:

   + 4ef636552b86ddea01f36c9346b78016bdad7798:
     Check for ctx.configuration.coverage_enabled instead of
     ctx.coverage_instrumented() in cc_helper.
```

Incompatible changes:

  - When remote cache evicts blobs, Bazel will exit with code 39.

Important changes:

  - Update Android manifest merger to v30.1.3, and also drop support
    for legacy (pre-D8) desugaring.
  - Adds coverage metric support to android_local_test
  - Correctly encode double value positive infinity as "inf" instead
    of "+inf" for textprotos.

This release contains contributions from many people at Google, as well as Andreas Herrmann, Benjamin Lee, Daniel Grunwald, Emil Kattainen, Fabian Meumertzheim, hvd, keertk, Keith Smiley, kshyanashree, Kun-Lu.

## Release 7.0.0-pre.20230209.2 (2023-02-16)

```
Baseline: 66121a75d67b92990966fc94771a22b0b4a062e3

Cherry picks:

   + 534089ed10a253b31c499a284079f52a92bc0347:
     Automated rollback of commit
     02b1b78f0278e2d6d9f294b9cfe86f72f0c9a900.
```

Incompatible changes:

  - --incompatible_python_disable_py2 is flipped to true. See #17293
    for details.

Important changes:

  - Added a `native.package_relative_label()` function, which
    converts a label string to a Label object in the context of the
    calling package, in contrast to `Label()`, which does so in the
    context of the current .bzl file. Both functions now also accept
    relative labels such as `:foo`, and are idempotent.

This release contains contributions from many people at Google, as well as Benjamin Lee, Benjamin Peterson, Chirag Ramani, Ezekiel Warren, Fabian Meumertzheim, Jon Parise, jonrose-dev, keertk, Sara Adams, yuzhy8701.

## Release 7.0.0-pre.20230128.3 (2023-02-14)

```
Baseline: d13c9641a187b5a3026ebb9093aeb480fdfe1838
```

This release contains contributions from many people at Google, as well as Benjamin Lee, Benjamin Peterson, Ed Schouten, Fabian Meumertzheim, Lee Mracek, lripoche, Nick Korostelev, Saleem Abdulrasool, Sara Adams, Uri Baghin.

## Release 7.0.0-pre.20230123.5 (2023-02-02)

```
Baseline: 2f9c7d60ea676f9f8e929b20a3ff74e786995c91

Cherry picks:

   + 9d92e7189bd7996286cbc0b04ae5c3ef7894f23c:
     Small tweaks to platform documentation. - Point platform rules
     to the explanatory document which people should have read first.
     - Update the left nav to include the word "Toolchains" - move
     https://bazel.build/extending/platforms from Design Docs to
     Concepts
   + d5095dbfd320654298aaa1b412a7581b53792d3f:
     "bazel config" output tests: skip noconfig.
   + 923425002daae6f83cb0c6487cc3453b2dc89a43:
     Automated rollback of commit
     0fe4c36a7feb24444bc72731bf4839aa1ca926c6.
```

Incompatible changes:

  - --experimental_build_transitive_python_runfiles is flipped to
    false. See #16303 for details

Important changes:

  - Now that the host configuration is finished, `genrule` should
    prefer the use of `tools` and stop using `exec_tools`.

This release contains contributions from many people at Google, as well as Fabian Meumertzheim, Keith Smiley.

## Release 7.0.0-pre.20230118.2 (2023-01-26)

```
Baseline: b310a8aaf35d73d1310b2a914a459a9f32a04d0d

Cherry picks:

   + ab71a1002c9c53a8061336e40f91204a2a32c38e:
     Rollback
     https://github.com/bazelbuild/bazel/commit/414824173363e579d34afc
     1aa16bc97a220743dc to fix breakage in an internal use case
```

Incompatible changes:

  - query --output=proto --order_output=deps now returns targets in
    topological order (previously there was no ordering).

This release contains contributions from many people at Google, as well as Anthony Ter-Saakov, Benjamin Lee, Benjamin Peterson, Ben Lee, Brentley Jones, Ed Schouten, Emil Kattainen, Fabian Meumertzheim, Fabian Meumertzheim, Fahrzin Hemmati, Halil Sener, Keith Smiley, Maxwell Elliott, mohamadk, Oliver Lee, Patrick Balestra, Red Daly, Severin Strobl, Simon Mavi Stewart, Stiopa Koltsov, tbaing, Thulio Ferraz Assis, Ulf Adams, Xavier Bonaventura.

## Release 7.0.0-pre.20230104.2 (2023-01-23)

```
Baseline: 89d34ac23a8f46b3b89ac4730d7a20da375f5fae

Cherry picks:

   + cf95a2be1de5e29d38fc1f35e662c678bb70fcdd:
     Automated rollback of commit
     2f39c04ea4b93788bfef5c475b7dd40a8a289aef.
```

This release contains contributions from many people at Google, as well as .

## Release 7.0.0-pre.20230104.2 (2023-01-23)

```
Baseline: 89d34ac23a8f46b3b89ac4730d7a20da375f5fae

Cherry picks:

   + cf95a2be1de5e29d38fc1f35e662c678bb70fcdd:
     Automated rollback of commit
     2f39c04ea4b93788bfef5c475b7dd40a8a289aef.
```

Incompatible changes:

  - When multiple --deleted_packages options are passed on the
    command line, they will be concatenated instead of the latest one
    taking effect.
  - This has the side effect of changing the message on unsuccessful
    builds from
  - JSON profile: Use doubles instead of strings for counter series.

Important changes:

  - removed outdated ctx.host_configuration

This release contains contributions from many people at Google, as well as Amanda L Martin, Benjamin Lee, Benjamin Peterson, Benjamin Peterson, Fabian Meumertzheim, Fahrzin Hemmati, keertk, Patrick Balestra, Sara Adams, Sascha Moecker, Siddhesh Bhupendra Kuakde, Stiopa Koltsov.

## Release 7.0.0-pre.20221212.2 (2022-12-23)

```
Baseline: 09da33b417e798cd0059a88dcfd4634af91e6322

Cherry picks:

   + 152cdc96300ec8f331fd1b41cde4b9f00e2e1b11:
     Fix stamping of jars in java_import
```

Incompatible changes:

  - This has the side effect of changing the message on unsuccessful
    builds from
    ```
    FAILED: Build did NOT complete successfully (0 packages loaded)
    ```
    to
    ```
    ERROR: Build did NOT complete successfully
    ```
  - Bazel no longer increases the delay between progress updates when
    there is no cursor control.
  - This has the side effect of changing the message on unsuccessful
    builds from
    ```
    FAILED: Build did NOT complete successfully (0 packages loaded)
    ```
    to
    ```
    ERROR: Build did NOT complete successfully
    ```
  - the --experimental_async_execution flag is now a no-op.
  - --experimental_replay_action_out_err is not a no-op.
  - `cquery --output=files` also outputs source files.
  - `--incompatible_strict_conflict_checks` is flipped to true. See
    https://github.com/bazelbuild/bazel/issues/16729 for details.
  - `--incompatible_strict_conflict_checks` is flipped to true. See
    https://github.com/bazelbuild/bazel/issues/16729 for details.
  - `--incompatible_always_include_files_in_data` is flipped to true.
    See https://github.com/bazelbuild/bazel/issues/16654 for details.
  - This changes the behavior of Python version in exec/host
    configuration. Mitigation is to set Python version on the targets.

New features:

  - The `aquery` and `cquery` commands now respect the
    `--query_file` flag just like the `query` command.

Important changes:

  - The new path variable `$(rlocationpath ...)` and its plural form
    `$(rlocationpaths ...)` can be used to expand labels to the paths
    accepted by the `Rlocation` function of runfiles libraries. This
    is the preferred way to access data dependencies at runtime and
    works on all platforms, even when runfiles are not enabled (e.g.,
    on Windows by default).
  - Starlark `print()` statements are now emitted iff the line of
    code is executed. They are no longer replayed on subsequent
    invocations unless the Starlark code is re-executed.
    Additionally, multiple identical `print()` statements (same
    string from the same line of code, e.g. from a loop) are all
    emitted and no longer deduplicated.
  - Fixes a bug where some compilation flags would not be applied to
    a cc_test
  - removed outdated ctx.host_fragments

This release contains contributions from many people at Google, as well as Alex Eagle, Ankush Goyal, Artem Zinnatullin, aryeh, Benjamin Peterson, Christopher Peterson Sauer, Christopher Sauer, Daniel KT, Ed Schouten, Fabian Meumertzheim, Gaspare Vitta, Greg Magolan, hvadehra, John Hinnegan, keertk, Keith Smiley, Krzysztof Naglik, Matt Mackay, nathyong, Patrick Balestra, Robin Tweedie, Roger Hu, Tom Cnops, Ulrik Falklof, Xavier Bonaventura, Xdng Yng, Xiangquan Xiao, Yannic Bonenberger, Yannic, Yi Cheng.

## Release 6.0.0 (2022-12-19)

```
Baseline: d60ce2c7c86393638c77698c00c2168a7a936a53

Cherry picks:

   + 490f8badf4f6f4ae8b96697f08267fdb083ccf5f:
     kshyanashree is the release manager of 6.0.0
   + 4e66d9340037f0be83d7bc0fdd809a09344ab83f:
     Automated rollback of commit
     2a2890913eb8f39299aa4b614ba96266ea8749f6.
   + 48a8d01b05149757f69a6a65a22a280bf003cd24:
     Allow C/C++ coverage collection for external targets
   + ec7be346adc00c4bde22d116fca80ef59da66121:
     Temporarily set parent directory of the input to writable if it
     is not.
   + b0984342eef068640a57aab584dd4c118f0dd394:
     Infer CPUs for tvOS and watchOS when on Apple Silicon
   + 5cea7dda5b632703cf4e0424ba09cd7c5bd6fc06:
     Improve the documentation for ctx.actions.symlink.
   + a82d26f17a99b5417b2212a0ce3a1bbc0285e5c4:
     Add quotes to "Tip"
   + 75b0f3aa95bc34f6620ea74e47d4822bd985efdd:
     Write a repo mapping manifest in the runfiles directory (#16555)
   + 07c5c1aa6d0b63605ae793dce78d26122af64a84:
     Ensure repository names don't start with `~`
   + 30f6c8238f39c4a396b3cb56a98c1a2e79d10bb9:
     Escape tilde more gracefully
   + cf3f48ca49f089615417636763d753811acf717f:
     Relax `Label` repo visibility validation
   + 4477823e2c2bc3d0335c41f971364dda72a3f69a:
     Use "apparent name" instead of "local name" in Bzlmod docs
   + 55f4f4834ef30321a00dab5b58202dd1e9716fd9:
     Bazel DevSite: Add required css file.
   + a706994ac69e3f3fed361c61378de847b50d3b12:
     Remove logic that increases delay between progress updates over
     time
   + 1d514ab05896f34ec91c2145f4dffafd3364030f:
     Remove references to io_bazel repository
   + b0357bd3831b26b5116dc120807e8264acf139db:
     Relnotes python script
   + 8f956511bb115c39ac683a1e78971fcf9dce5deb:
     Allow Java coverage collection for external targets
   + bddb191d3f99402330c67b89375409c31ee22daa:
     Fix race condition in package-bazel.sh
   + a75785279f543f4e33c697dd9e8873a6504b7818:
     Decanonicalize labels emitted by {a,c,}query if possible
   + 9d250edb63f27f9f4591bb5a71059710cc6dca9e:
     Add uniquify parameter to TemplateDict.add_joined
   + f02bcf8d8b0d00ecdd06ea0a45ba4f52e436597c:
     Fix identical gcov json file name problem
   + a1593309f66f892871e334013815b05350b4188f:
     Add `$(rlocationpath(s) ...)` expansion
   + 56f54daf9ff3b1177eee31e342e8d6b959d5ac34:
     Rollup of SBOM correctness fixes (#16655)
   + 72e6e948d30dec9dec60d78efef4eeda5b764a8f:
     [cc] Add cc toolchain to starlark cc_proto_library (#16661)
   + 8f28513893969b6346d965cab12aac69cb246ced:
     Make C++ runfiles library repo mapping aware
   + 95f9adc5ac544b1161d69a7ca74432479fdc29b3:
     Always collect FileProvider's filesToBuild as data runfiles
   + 4959d34e844714b793b2c6fa05016a9a6eaa7044:
     fix: export constraints.bzl file from @local_config_platform so
     it can be used in downstream bzl_library targets
   + 4919d4a61d8506d175b25a035500842b8bfe3d0d:
     Add --host_per_file_copt (#16695)
   + 0a23d46976c3fc999d44fbd1e37732ec2442d485:
     Moving some tests for `RemoteActionFileSystem` of BwoB to a base
     class.
   + 9296068be5e3808eb03a3b61f3af3a2c88f7ab7d:
     [remote/downloader] Don't include headers in `FetchBlobRequest`
   + 128d833fee99f8a43bc4de82cbec752e4ce6fb47:
     [remote] Respect whether the server supports action cache updates
   + 38c501912fc4efc14abc0741d19f5f8e8763afcb:
     [remote/downloader] Migrate `Downloader` to take `Credentials`
     (#16732)
   + 5929cb72aa01768e6352898b1a056ef678c81d90:
     Stage repository mapping manifest as a root symlink (#16733)
   + 455454a56e961affb041a1d4a9214f7f313a05aa:
     Expose current repository name to Java with @AutoBazelRepository
   + 97dea593e568f776361397f7280d6a16eee2efeb:
     Implement getDirectoryEntries and readdir for
     RemoteActionFileSystem.
   + aa45f5f3301c5005294df084cdf99c45d6f95d53:
     Move integration tests for BwoB to a base class and add more
     tests there.
   + 1b073ac0a719a09c9b2d1a52680517ab22dc971e:
     Make Java runfiles library repo mapping aware
   + 148bbb1c025a628643698f65627333d86975c1d7:
     Use `_repo_mapping` in C++ runfiles library (#16752)
   + 25558ada3fb377cfc2c965d3a93250ca28ce0fc1:
     Add --experimental_action_cache_store_output_metadata to the
     expansio…
   + 6e945e8ab422ca0a195d09899cce61ba6c0cfa59:
     Treat `DEBUG` events as progress-like.
   + 1940c5d68136ce2079efa8ff74d4e5fdf63ee3e6:
     redact 'token' strings from logging
   + 0b645254b41edc738c6641fd192fca86203ff2e2:
     Make Bash runfiles library repo mapping aware (#16753)
   + 4caae75b49e815ad2cf1d805f316bc374f03f2ae:
     Automated rollback of commit
     8f956511bb115c39ac683a1e78971fcf9dce5deb.
   + 13ff6d9e37999e00fda9a6cef278c7c924924f34:
     Fix Bash rlocation failure with stricter Bash options
   + bd88c7e47b911e5fa1f8a3c26d0f8317943c43ce:
     Make bazel Android remote deps compatible with bzlmod (#16772)
   + 6f6d4cca36a3b64009ed9c8b3fb13cb3c7ed915a:
     Flip `--incompatible_always_include_files_in_data`
   + 94355b1b1c4f7ef923457b8b2a070e5c6528240a:
     Add required `--add-opens` server JVM args also with
     non-embedded JDK
   + 8349c95fc98beb4008085942a67a57f0c4da074b:
     Also collect clang resource directory with
     `-no-canonical-prefixes`
   + dce6ed777d958d65c7f3d4a2f54f8117778a449e:
     Make `bazel run` works with minimal mode
   + ca8674cc4879ed1846bf015c33fe7d920a3f66ab:
     Include source files with `cquery --output=files` (#16826)
   + 9cb5e0a31665d3b3f25bf58ec2dee696e828d8b9:
     Fsync before rename after copy in DiskCacheClient
   + 23ffce53b92ef96432d8c6c58cc95ac362bab1bc:
     Update GetActionResult for disk cache to check referenced files
     when …
   + 0bc0ff5244142eb3348d42025ce21eeb337ad189:
     Make Java runfiles library compilable with JDK 8
   + fe169654a29d8ad33105d5d0034a7857834fed5d:
     [6.0.0] Default --incompatible_strict_conflict_checks to true.
     (#16864)
   + 99ca86f7c2968741ac3a9b20c3375fc992d49e66:
     Revert "[6.0.0] Default --incompatible_strict_conflict_checks to
     true. (#16864)" (#16872)
   + 312238f2b1414c98ed7d7d51dc4e18278edb2540:
     Make C++ runfiles library build with `-Werror=shadow`
   + 2baa5a4284467d70f1b31ea779b79d38ef07d164:
     Keep credentials cached across build commands.
   + 8818a57fce32a7872f045f03a334e1c9403724d3:
     [6.0.0] Only inject metadata for outputs that cannot be
     reconstructed by skyf… (#16879)
   + 31e4bf409eed71e8fb626092189eacb95f80fed9:
     Update java_tools v11.9
   + cd40666001e8d599bb61735898c195c6d2fae55b:
     replace _get_canonical_form(label) with str(label)
   + e2bc2374188b41924223385ad943db610e92e6c4:
     Avoid exceptions from hermetic sandbox for unsupported artifact
     subclasses
   + b564d145218e58b0440ffad82b3d1d54eef15d22:
     Remove warnings about ignored starlark options
   + 7ccc66108f08f7b6c6f6e5229f70f29962ea19ce:
     [6.0.0] Emit Tree objects in topological order (#16904)
   + 86dee6d2ecb269e0c41a97718812054394ee51a4:
     Correctly match regex with tree artifact
   + 14925b574aa63aad098f2c3d95e14b46ffd295ec:
     Always use target's attributes to set Python version (#16959)
   + a247502d28d8d70d648390de52952189b99a0bb7:
     Add 'toolchain' parameter to actions.{run,run_shell}
   + 497b7e403d6e5523bd1310bd1fe83c4ce1a6b1ec:
     Fix Bash `runfiles_current_repository` with RBE
   + 0a2c4edbc86398266525f31948d67a5736890bfe:
     Fix corner cases in Bash runfiles library
   + 33b514b25963452be71a015e08d4e890405b00a3:
     Fix runfiles creation with MANIFEST when building without the
     bytes
   + 3a13af41034e1f80cc0fbc1634cf8f724a85b78f:
     Remove LCOV merger dependency of `cc_test` without coverage
     (#17004)
   + 25ba76c1b8d420ebae43c1f59890ae46153c2240:
     Include full tree artifact in inputs when prefetcher doesn't
     support partial tree artifacts.
```

Incompatible changes:

  - this incompatible change breaks old instances of http_archive
    that specified netrc as an absolute path. It is unlikely there
    are many instances in the wild since the path would refer to a
    netrc file inside the external repository by absolute path.
    Migration should be straightforward.
  - genrule switched to use exec transition instead of host. This can
    break targets with hardcoded output paths. To avoid using
    hardcoded paths use make variables, see
    https://docs.bazel.build/versions/4.2.2/be/make-variables.html#pre
    defined_label_variables
  - this incompatible change breaks old instances of http_archive
    that specified netrc as an absolute path. It is unlikely there
    are many instances in the wild since...
  - Error Prone now checks for unused return values of additional
    methods on `java.lang.Object`, which can be disabled using
    `--javacopts=-Xep:ReturnValueIgnored:OFF`
  - Error Prone now checks for unused return values of additional
    methods on `java.lang.Object`, which can be disabled using
    `--javacopts=-Xep:ReturnValueIgnored:OFF`
  - The --incompatible_existing_rules_immutable_view flag has been
    flipped to true. See
    https://github.com/bazelbuild/bazel/issues/13907 for
    migration notes.
  - Split up the C++ archive from the C++ link action and set
    `CppArchive` as mnemonic.
  - workspace(managed_directories=) is not available anymore.
  - --legacy_important_outputs now has a default of false.
  - --legacy_important_outputs default reverted to true.
  - objc_library now requires CcInfo in its deps.  If this breaks
    you, add empty CcInfo() to your rule.
  - Flag --experimental_local_memory_estimate removed.
  - Added a new flag
    --incompatible_unambiguous_label_stringification, which causes
    labels in the main repo to stringify into unambiguous forms
    starting with an @. See
    https://github.com/bazelbuild/bazel/issues/15916 for more
    information.
  - analysis_test moved into testing.analysis_test
  - Flip incompatible_enable_cc_toolchain_resolution
    (https://github.com/bazelbuild/bazel/issues/7260)
  - (Rollback) Flip incompatible_enable_cc_toolchain_resolution
    (https://github.com/bazelbuild/bazel/issues/7260)
  - name parameter is removed from rule call
    (https://github.com/bazelbuild/bazel/issues/16301)
  - name parameter is removed from rule call
    (https://github.com/bazelbuild/bazel/issues/16301)
  - name parameter is removed from rule call
    (https://github.com/bazelbuild/bazel/issues/16301)
  - --incompatible_remote_downloader_send_all_headers is flipped to
    true. See #16356 for details.
  - GrpcRemoteDownloader only includes relevant headers instead of
    sending all credentials.
  - In package_group's `packages` attribute, the syntax "//..." now
    refers to all packages in the same repository as the package
    group, rather than all packages everywhere. The new item "public"
    can be used instead to obtain the old behavior. In `bazel query
    --output=proto` (and `--output=xml`), the `packages` attribute
    now serializes with the leading double slash included (for
    instance, `//foo/bar/...` instead of `foo/bar/...`). See also
    #16355, #16323, and #16391.
  - Bazel no longer increases the delay between progress updates when
    there is no cursor control.
  - `--incompatible_always_include_files_in_data` is flipped
    to true. See https://github.com/bazelbuild/bazel/issues/16654 for
    details.
  - `cquery --output=files` also outputs source files.
    
    Closes #16602.
  - `--incompatible_strict_conflict_checks` is flipped to true. See
    https://github.com/bazelbuild/bazel/issues/16729 for details.
  - This changes the behavior of Python version in exec/host
    configuration. Mitigation is to set Python version on the targets.

New features:

  - Support local_repository in Bazel Registry's source.json file

Important changes:

  - Deprecate --incompatible_applicable_licenses flag, in preparation
    for removal in Bazel 6.x.
  - Treat py_*.srcs_version="PY2" the same as "PY2ONLY".
  - The Build Event Protocol now contains file digests and sizes
    along with the file name and URI.
  - Refactor system suspend event handling.
  - alias() can now select() directly on constraint_value()
  - Allow \a \b \f \v escape sequences in Starlark.
  - Match remote and local xcode version by most granular version.
  - Adds `--experimental_worker_multiplex_sandboxing` flag that
    controls whether to sandbox multiplex workers that support it.
  - provider() has a new parameter: init, a callback for performing
    pre-processing and validation of field values. Iff this parameter
    is set,
    provider() returns a tuple of 2 elements: the usual provider
    symbol (which,
    when called, invokes init) and a raw constructor (which bypasses
    init).
  - Tests that fail to create or complete their
    `TestAttemptContinuation` by
    throwing an `ExecException` will report an `INCOMPLETE` status.
    Previously, Bazel
    would fail to report any status for the test attempt.
  - Fixed an issue where Bazel could erroneously report a test passes
    in coverage mode without actually running the test.
  - Include more information about configurations in cquery proto
    formatted output. This deprecates the configuration field of
    AnalysisProtosV2.ConfiguredTarget, and adds a new field,
    configuration_id, to
    be used instead.
  - experimental cc_library.implementation_deps inverted to
    interface_deps
  - In aquery and cquery proto output, indicate if a configuration is
    a
    tool or non-tool configuration.
  - Include complete configurations in cquery proto output.
  - experimental cc_library.implementation_deps inverted to
    interface_deps
  - Make protocOpts() publicly accessible.
  - Add some documentation about how configuration information is
    conveyed in cquery proto output.
  - Introduces experimental static library linking API under
    apple_common.link_multi_arch_static_library
  - Further deprecation and removal of pkg_tar. Stop supporting
    legacy use of 'files' attribute, where it could be a list of
    labels instead of a map of paths to labels.
  - Removed --incompatible_no_build_defs_pkg flag. It never fulfilled
    its purpose because --all_incompatible_changes would never set
    it. The last rule it gated (pkg_tar) is scheduled to be removed
    in Bazel 6.x.
  - Add coverage configuration fragment, used to expose
    output_generator label.
  - Bazel now no longer includes system headers on macOS in coverage
    reports (#14969).
  - android_sdk_repository read $ANDROID_SDK_ROOT in addition to
    $ANDROID_HOME.
  - The default dexer is now d8. dx can be optionally enabled using:
      --define=android_dexmerger_tool=dx_dexmerger \
      --define=android_incremental_dexing_tool=dx_dexbuilder \
      --define=android_standalone_dexing_tool=dx_compat_dx \
      --use_workers_with_dexbuilder
  - Packaging support for deploy JAR embedded JDK files (hermetic
    Java).
  - Don't stamp cc_common.link actions for tool dependencies.
  - Starlark test rules can use the new inherited_environment
    parameter of testing.TestEnvironment to specify environment
    variables
    whose values should be inherited from the shell environment.
  - Enable merging permissions during Android manifest merging with
    the --merge_android_manifest_permissions flag.
  - Allow specialization to work with constraint_values.
  - Bazel uses the D8 jar from Maven instead of the SDK.
  - Make ijar / java_import preserve classes with `@kotlin.Metadata`
    annotations
  - Switch cc_test implementation to Starlark. Note: cc_test will now
    link statically when _targeting_ Windows regardless of host
    platform (rather than always linking statically when Windows is
    the _host_).
  - Switch cc_test implementation to Starlark. Note: cc_test will now
    link statically when _targeting_ Windows regardless of host
    platform (rather than always linking statically when Windows is
    the _host_).
  - Add devtools/build/lib/worker:work_request_handlers to the remote
    android tools release package. This will be transitively packaged
    into all_android_tools.
  - Bazel uses the D8 jar from Maven instead of the SDK.
  - android_sdk_repository read $ANDROID_SDK_ROOT in addition to
    $ANDROID_HOME.
  - Advance android_tools_pkg version to 0.24.0.
  - Switch cc_test implementation to Starlark. Note: cc_test will now
    link statically when _targeting_ Windows regardless of host
    platform (rather
    than always linking statically when Windows is the _host_).
  - Bazel uses the D8 jar from Maven instead of the SDK.
  - "blaze config" now only reports info from the last build. To
    compare configurations across multiple builds, redirect "blaze
    config" output to a file and run your favorite diff tool.
  - The --incompatible_override_toolchain_transition flag is now
    always set, and will be removed in the future. Thus,
    --noincompatible_override_toolchain_transition has no effect, and
    the value of the incompatible_use_toolchain_transition parameter
    in aspect() and rule() builtins is ignored.
  - Switch cc_test implementation to Starlark. Note: cc_test will now
    link statically when _targeting_ Windows regardless of host
    platform (rather
    than always linking statically when Windows is the _host_).
  - Toolchain types may now be optional, in addition to mandatory.
    See https://bazel.build/docs/toolchains#optional-toolchains for
    further details.
  - Add six to deps of has_services=1 py_proto_librarys.
  - pkg_tar(symlinks) has been removed. Users needing that feature
    should
    migrate to @rules_pkg.
  - Aspects can now define and use exec groups using the same API as
    rules.
  - Removed the obsolete --incompatible_applicable_licenses flag. The
    feature is permanently enabled.
  - embedded_tools packages R8 desugarer again
  - Bazel now selects sh path based on execution platform instead of
    host platform, making it possible to execute sh actions in
    multiplatform builds. --shell_executable now only applies to
    actions configured for host.
  - labels in genquery.scope are no longer configured.
  - When Bzlmod is enabled, all Bzlmod-generated repos will have an
    extra '@' prepended to their names. This effectively enables the
    canonical label literal syntax for Bzlmod-generated repos
    (`@@canonicalRepoName//pkg:target`; see
    https://docs.google.com/document/d/1N81qfCa8oskCk5LqTW-LNthy6EBrDo
    t7bdUsjz6JFC4/edit?usp=sharing).
  - Exposed `CcSharedLibraryInfo` to Starlark builtins.
  - Enable --use_top_level_targets_for_symlinks by default.
  - Singlejar accepts runtime Created-By field
  - --noincompatible_disable_managed_directories, and with that,
    workspace(managed_directories=) is not supported anymore.
  - Bazel supports D8 desugaring, albeit without persistent workers
  - Remove mtime options from pkg_tar. Users should migrate to
    @rules_pkg.
  - Test for experimental multiplexed persistent resource processor.
  - Added new register_{execution_platforms,toolchains} directives to
    the MODULE.bazel file, to replace the
    {execution_platforms,toolchains}_to_register attributes on the
    module() directive.
  - The legacy pkg_tar no longer supports the ability to untar and
    repackage an input tar file (`deps` attribute). Users needed that
    capability must switch to github.com/bazelbuild/rules_pkg.
  - `cquery`'s new output mode
    [`--output=files`](https://bazel.build/docs/cquery#files-output)
    lists the output files of the targets matching the query. It
    takes the current value of `--output_groups` into account.
  - Change singlejar metadata to report Created-By Bazel
  - Add support for fetching RPC credentials from credential helper.
  - Revert interface_deps back to implementation_deps after problem
    reported in. Use `buildozer 'rename deps implementation_deps'
    //...:%cc_library; buildozer 'rename interface_deps deps'
    //...:%cc_library`
  - Fix for desugaring failure on Bazel+Android+Windows build
    scenario.
  - D8 is the default desugarer
  - Migrate main_dex_list_creator to D8 (DX deprecation)
  - --experimental_enable_bzlmod has been renamed --enable_bzlmod,
    and still defaults to false.
  - selects() no longer produce irrelevant duplicate label checks
  - Adds a dexer output cache to CompatDexBuilder to improve build
    speed.
  - Improved error messages when analyzing inline bzl code
  - Improved error messages when analyzing inline bzl code
  - The `@bazel_tools//tools/cpp:compiler` flag now has the value
    `gcc` if the configured compiler is detected to be gcc rather
    than the generic value `compiler`. A branch for `gcc` may have to
    be added to `select` statements that do not have a default case
    that handles gcc appropriately.
  - The `get_child` method of `path` now accepts an arbitrary
    number of relative path strings as positional arguments.
  - SourceManifestAction supports `Action.content`
  - Add --incompatible_build_transitive_python_runfiles alias. See
    #16303
  - The @bazel_tools//tools/cpp:compiler flag now has the value
    `clang` for the auto-configured Xcode toolchain rather than the
    generic value compiler. A branch for `clang` may have to be added
    to select statements that do not have a default case that handles
    this toolchain appropriately.
  - added additional debug message to warn of skipped toolchains
    during resolution
  - The deprecated --remote_allow_symlink_upload flag has been
    removed. Symlinks in local action outputs are always permitted,
    even with remote caching. Whether they're uploaded as symlinks or
    as the files/directories they point to is still determined by the
    --incompatible_remote_symlinks flag.
  - Added `struct`, `json`, `proto`, and `depset` to the starlark
    environment of Bazel's cquery (--output=starlark) command
  - Added three `package_group`-related flags:
    `--incompatible_package_group_includes_double_slash` (#16391),
    `--incompatible_package_group_has_public_syntax` (#16355), and
    `--incompatible_fix_package_group_reporoot_syntax` (#16323). With
    these flags, `package_group` can now easily specify "all
    packages", "no packages", and "all packages in the current repo".
  - Record hermetic packaged JDK modules file size in deploy JAR
    manifest 'JDK-Lib-Modules-Size' attribute.
  - .bzl files may now set a visibility to guard what other .bzl and
    BUILD files may load them. See [...] for more information.
  - Deletes the --extra_proguard_specs Blaze flag
  - The new path variable `$(rlocationpath ...)` and its plural form
    `$(rlocationpaths ...)` can be used to expand labels to the paths
    accepted by the `Rlocation` function of runfiles libraries. This
    is the preferred way to access data dependencies at runtime and
    works on all platforms, even when runfiles are not enabled (e.g.,
    on Windows by default).
    
    Work towards #16124
    Fixes #10923
    
    Closes #16428.
  - Starlark `print()` statements are now emitted iff the line of
    code is executed. They are no longer replayed on subsequent
    invocations unless the Starlark code is re-executed.
    Additionally, multiple identical `print()` statements (same
    string from the same line of code, e.g. from a loop) are all
    emitted and no longer deduplicated.
  - Fixes a bug where some compilation flags would not be applied to
    a cc_test

This release contains contributions from many people at Google, as well as Adam Azarchs, Adam Singer, Adam Wolf, Albert Lloveras, Alessandro Patti, Alex Eagle, Alex Scott, Alex Torok, Andreas Fuchs, Andreas Herrmann, Andrew Katson, Andrew Klotz, Ara Nguyen, arunkumar9t2, arun.sampathkumar, Ast-x64, Benedek Thaler, Benjamin Lee, Benjamin Peterson, Ben Lee, Bohdan Vanieiev, Bo Zhang, Bo Zhang, Bradley Burns, Brandon Duffany, Brandon Jacklyn, Brentley Jones, Brentley Jones, Chad Miller, Charles-Francois Natali, Chris Clearwater, Chris Fredrickson, Christopher Peterson Sauer, Christopher Rydell, Christopher Sauer, ckiffel, Cristian Hancila, crydell-ericsson, Dan Fleming, Daniel Wagner-Hall, Danny Wolf, David Ostrovsky, David Sanderson, Denys Kurylenko, dhmemi, Dimi Shahbaz, divanorama, dmaclach, Ed Schouten, Emil Kattainen, Eric Song, Eric Wendelin, Fabian Brandstetter, Fabian Meumertzheim, floriographygoth, Fredrik Medley, George Prekas, gkgoat1, gkorlam, Greg Estren, Greg, Gregory Fong, Greg Roodt, Grzegorz Lukasik, Halil Sener, Hannes Kufler, homuler, hvadehra, hvd, Igor Nazarenko, James Broadhead, Jan, Jason Tan, Jay Bazuzi, Jeremy Volkman, jheaff1, Jiawen Chen, Joel Williamson, John Laxson, John Millikin, Jonathan Gerrish, Jon Shea, Jordan, juanchoviedo, Kaiqin Chen, Keith Smiley, Ken Micklas, Kevin Lin, Kirill Zabelin, Kiron, Krishna Ersson, Krzysztof Naglik, kshyanashree, lihu, Luc Bertrand, Luis Fernando Pino Duque, lunch-glide-pepper, Marek uppa, Matt Clarkson, Matt Mackay, Michael P. Nitowski, Mikhail Balabin, Mostyn Bramley-Moore, Nick Korostelev, Nitesh Anandan, Niyas Sait, Noa Resare, Olek Wojnar, Oscar Bonilla, Patrick Balestra, Paul Tarjan, Peter Mounce, Philipp Schrader, Pras Velagapudi, Rahul Butani, Rajeshwar Reddy T, Rifqi Mulya Fahmi, Roman Salvador, rustberry, Ryan Beasley, Ryan Schmidt, Sahin Yort, Saleem Abdulrasool, Sara Adams, Shuai Zhang, Simon Bjorklen, Son Luong Ngoc, Stephan Wolski, Steve Vermeulen, Stiopa Koltsov, Sven Tiffe, Takeo Sawada, Tao Wang, Ted Kaplan, Tetsuo Kiso, Thi Doan, Thomas Chen, ThomasCJY, Thomas, Thomas Zayouna, Timothe Peignier, Tomas Volf, Tom de Goede, UebelAndre, Ulf Adams, Ulrik Falklof, vardaro, Vasilios Pantazopoulos, Vladimir Tagakov, Waleed Khan, William Muir, Xavier Bonaventura, Xdng Yng, Xiangquan Xiao, Xùdōng Yáng, Yannic Bonenberger, Yannic Bonenberger, Yannic, Yannic, Yesudeep Mangalapilly, Yuval K, Zhongpeng Lin.

## Release 5.4.0 (2022-12-15)

```
Baseline: 8d66a4171baddcbe1569972f019e54130111202c

Cherry picks:

   + becd1494481b96d2bc08055d3d9d4d7968d9702e:
     Remote: Cache merkle trees
   + d7628e1b566be353fe7172241ac8f15d5f8e7ff5:
     Update DEFAULT_IOS_CPU for M1 arm64 simulator support
   + 80c56ff7b603fcfff02a5f97829a2a5935f360a0:
     Compile Apple tools as fat binaries if possible
   + 3c09f3438a966b49a7c1726022c898b390b3a6e5:
     Add protobuf as a well known module
   + 3a5b3606a6f5433467a5b49f0188c41411684bf5:
     Remote: Merge target-level exec_properties with
     --remote_default_exec_properties
   + 917e15ea408e1d3d25574edbb466b39cfbcb61fe:
     Add -no_uuid for hermetic macOS toolchain setup
   + f5cf8b076bc913dbe021104d5f6837fb4a6cd8b3:
     Remote: Fixes an issue when --experimental_remote_cache_async
     encounter flaky tests.
   + 77a002cce050e861fcc87c89acf7768aa5c97124:
     Remove DigestUtils.getDigestInExclusiveMode() now that SsdModule
     has …
   + 557a7e71eeb5396f2c87c909ddc025fde2678780:
     Fixes for the Starlark transition hash computation (#14251)
   + 34c71465f84fa780217926db2e8e5ca3d6d4568c:
     Do location expansion in copts of objc_library
   + 50274a9f714616d4735a560db7f617e53fb8d01b:
     [5.x] Remote: Add support for compression on gRPC cache (#14277)
   + 61bf2e5b5181cbe34a2f0d584053570943881804:
     Automated rollback of commit
     34c71465f84fa780217926db2e8e5ca3d6d4568c.
   + 79888fe7369479c398bafe064daa19a7ae30f710:
     Silence a zstd-jni GCC warning.
   + 063b5c9c2c09b4794010b9a169b44890ffc79ec4:
     Remote: Limit max number of gRPC connections by
     --remote_max_connections.
   + fd727ec96d861573dcbad3249d727a94eff84789:
     Do location expansion in copts of objc_library
   + 23d096931be9b7247eafa750999dd7feadde14c1:
     Fix _is_shared_library_extension_valid
   + 5cf1d6e1f78bc860fcd0e2e86eff6fe43ab4a5a2:
     Remove merging of java_outputs in JavaPluginInfo.
   + cea5f4f499aa832cf90c68898671869ce79d63f2:
     Cherrypick Bzlmod documentation (#14301)
   + 227e49e28e5122cddd6c4cb70686ff7bde3617ea:
     Format work requests according to ndjson spec
   + ae0a6c98d4f94abedbedb2d51c27de5febd7df67:
     Enable user_link_flags_feature for macosx cc_toolchain_config
   + 8c2c78cdc66cc9d5eb2cd59823c659892c1643a7:
     Remote: Use Action's salt field to differentiate cache across
     workspaces.
   + f94898915268be5670fb1e93a16c03e9b14d2a58:
     [5.x] Remote: Fix "file not found" error when remote cache is
     changed from enabled to disabled.  (#14321)
   + 3069ac4e33dcca6f3d1abf55940cdd764d03bdbf:
     Delete marker file before fetching an external repository
   + c05c6261cdb2cacb7c9881c255c0ada435ab5182:
     Remote: Fix file counting in merkletree.DirectoryTreeBuilder
   + d84f7998ef8f15e27376a0c8f25b320145c4ba9e:
     Fix remote spawn tests for remote_merkle_tree_cache=true
   + 59e16e944200555da377799aa0d9e8d0674d2e27:
     Show skipped tests as a warning
   + 76b3c242831f8e88835e3002a831a185a41fcc52:
     Build xcode-locator as a universal binary
   + aa52f2ddf9bab1ebd18e5431124061e813bfcd80:
     Exit collect_coverage.sh early if LCOV_MERGER is not set.
   + 4256d46327bad8638df91be1a5d4ef83b12b74c7:
     Automated rollback of commit
     d84f7998ef8f15e27376a0c8f25b320145c4ba9e.
   + dce24350befd08216b3910ae343670015444ff81:
     [apple] fix issues compiling C in objc_library for watchos/armv7k
   + bfc24139d93f8643686d91596ba347df2e01966a:
     5.x: Remote: Ignore blobs referenced in BEP if the generating
     action cannot be cached remotely. (#14389)
   + 5aef53a8884038f3c9f06e6dddb9372196253378:
     Remote: Don't blocking-get when acquiring gRPC connections.
     (#14420)
   + 005361c895da334beb873901e93aff06d180256e:
     Disable IncludeValidation for ObjC in bazel
   + d703b7b4f09fb3c389f99e52bac1f23930280b56:
     Update java_tools v11.6
   + 90965b072eb4a6dec8ff5b8abde3726732d37bdc:
     Stop remote blob upload if upload is complete. (#14467)
   + dc59d9e8f7937f2e317c042e8da8f97ba6b1237e:
     [5.x] Make remote BES uploader better (#14472)
   + 2edab739e1f61fe8813230b03396ca46f0790089:
     Avoid too verbose warnings in terminal when cache issues
   + 1160485192b5e6d95bcd426b55cc9a35fc6b8614:
     Rename --project_id to --bes_instance_name
   + c63d9ecbe5fcb5716a0be21d8fc781d7aa5bbc30:
     Automated rollback of commit
     bfdfa6ebfd21b388f1c91f512291c848e1a92a96.
   + b341802700484d11c775bf02d80f43ba3f33b218:
     [apple] support watchos_arm64 in toolchain
   + 43bcf80a3dfdc5ac89c1e4d615d6f29a495855fb:
     Disable implicitly collecting baseline coverage for toolchain
     targets.
   + 302971e1b3d803069ac949c0085c0d2a3916c8ab:
     Automated rollback of commit
     7d09b4a15985052670244c277e4357557b4d0039.
   + 62002024ca7012ffe0f4fc74ac20b5471513c8c8:
     Bzlmod: Starlarkify default attr values for TypeCheckedTags
   + 38117d491cbc4a5686e0bdb1e58f8946d96aed58:
     Fix build after rc4 cherrypicks (#14581)
   + 41feb616ae18e21fdba3868e4c298b0b83012f10:
     Release 5.0.0 (2022-01-19)
   + 486d153d1981c3f47129f675de20189667667fa7:
     Find runfiles in directories that are themselves runfiles
   + 0de7bb95022057e8b89334f44759cf6f950e131f:
     Don't resolve symlinks for --sandbox_base
   + 8b60c90f3641591b65c4e153113aea562f1fab94:
     Remove uses of -lstdc++ on darwin
   + 60f757c0831f9fbb2415fb0105f964201faa9fa0:
     Allow Label instances as keys in select (#14755)
   + 3836ad029f202ca13c64c9f07e4568ea8ab2d9a6:
     Remote: Only waits for background tasks from remote execution.
   + 8734ccf9847eafb7193388cd9c6fa78faa78283f:
     Add the default solib dir to the rpath for cc_imports with
     transitions
   + 9e16a6484e94c358aa77a6ed7b1ded3243b65e8f:
     Flip --experimental_worker_allow_json_protocol
   + fce7ea8d5e0facfc125ae7c37bfb4b9a7c586e40:
     Fix `ctx.fragments.apple.single_arch_cpu` returning incorrect
     cpu for tools when host cpu and exec cpu are different
   + 0c1d09e4dce4c3251c2be2c70d4575ec65b1d9d3:
     Propagate --experimental_cc_implementation_deps to host config
   + 1c3a2456c95fd19974a5b2bd33c5ebdb2b2277e4:
     Support select() on constraint_value for aliases.
   + 67a133b431ccece22b7dd9a72f0837cff77d4360:
     Improve documentation for select()
   + 5356fedd4b6079851b51db27077bf84c7bab16a4:
     Cherrypicks for experimental cc_shared_library (#14773)
   + ffdd633d7b9f21267f4f9759dd9833096dd4e3a2:
     [apple] support tvos_sim_arm64 in toolchain (#14779)
   + a58ddea50b2fd476d183e2e0c077ad6173039b89:
     Cherry pick win arm64 (#14794)
   + dc41a20bb045d221a43223a5db6b8b44cd8f1676:
     [5.1.0] cherrypick subpackages support (#14780)
   + 86e2db7d67ec52bfe11c1f517f650653cee3ea26:
     Add a helper method for rules to depend on the cpp toolchain
     type.
   + 6990c02644a71d5e7c95c9c234ecf39bb55c6ac4:
     UrlRewriter should be able to load credentials from .netrc
     (#14834)
   + 32d1606dac2fea730abe174c41870b7ee70ae041:
     Add "arch" struct field to repository_os
   + 2cfdceae971d09f50ceddc3d7ef723fb5f879957:
     [5.x] bzlmod: Add support for WORKSPACE.bzlmod (#14813)
   + c2ddbd1954af5baab63b93f2b055a410a27832c8:
     Ignore missing include directory in JDK distribution.
   + 16de03595e21f7bf31818e717505b23c953b3b7d:
     Fix bazel coverage false negative
   + 0c74741742301abcf67452a7f591daec1c3a7635:
     Remote: Postpone the block waiting in `afterCommand` to
     `BlockWaitingModule` (#14833)
   + 3297d9234e15515aa91cc887b3b12db7e1040b02:
     Switch to `ProcessHandle` for getting the PID (#14842)
   + a987b98ea0d6da2656c4115568ef9cbe8a164550:
     Fix uses of std++ on bsd
   + d184e4883bb7fc21de2f7aeea4304994de27e9ea:
     Remote: handle early return of compressed blobs uploads
   + 0b09e9e018c557da04c9f978d25a66d963cd6cb6:
     Add removeprefix/removesuffix to Starlark strings
   + d42ab0cfcce56b5e55c8bd94d0923d08758fdb5b:
     Fix default CPU for macOS and iOS (#14923)
   + cd24f39750d7b08f6f31c82d3a23cc329c7fc78e:
     Add paramfile support for def_parser, since in rare cases on
     Windows command line character limit was reached.
   + 0b1beefd1e7611dc9b9f559d00d8ff76aabb0f32:
     Normalize rpath entries to guard against missing default solib
     dir
   + 24e82426e689853b0d9a04e7b9b6f13e145cf2d6:
     Fix aggressive params file assumption
   + c45838bd3e51bcd0c8c3e1a9b4a0e55cdf4b4f59:
     Fix precompiled libs not in runfiles of cc_shared_library
     (#14943)
   + 764614e0f0287125269e7a92e909a44624bcb360:
     Bzlmod: Allow multiple `use_extension`s on the same extension
     (#14945)
   + fa761f84994f18db383fbe9aaea524e4385da13a:
     Fix typo in `apple_common.platform` docs
   + f7d8288bd7b16c7f2e010aa8ddc241cf2ba8e0d5:
     Yield a Proxy for addresses without protocol
   + 8cefb8bed4ac82df8640682517372a9249732352:
     Avoid merging URLs in HttpUtils
   + b4804807fc2c184cc36df9e69e472942c01941b8:
     Make protocOpts() public. (#14952)
   + 113eaca5862c48797654ae2a3acbb6e15d761485:
     Do not hide BulkTransferException messages when there were more
     than one exception
   + b1bf9d6c5f85fc4fda0dc48bc3d3e2fe26880867:
     merkle_tree_cache: change default size to 1000
   + f15e0c7224ecc5473d4972afc436e28df35c4e5a:
     Add --experimental_repository_cache_urls_as_default_canonical_id
     to help detect broken repository URLs (#14989)
   + f4214746fcd15f0ef8c4e747ef8e3edca9f112a5:
     Expose the logic to read user netrc file
   + b858ec39aebd7e586af5438aa2035db2adebf9a4:
     Correct cpu and os values of `local_config_cc_toolchains` targets
   + 5e79972c05d89280f0cf1fa620f807366847bac6:
     Expose CoverageOutputGenerator on a Fragment (#14997)
   + 78f03110e0dab42f37e427fd524e72706e036d74:
     Correct error runfiles cc_shared_library (#14998)
   + 7937dd14c3c632ffcfaea9073d5dec6dcac93845:
     [5.1] Adding Starlark dependencies to the package //external
     (#14991)
   + a73aa12be65454ac8cfb5a8f3e056c420402f997:
     Remote: Fix crashes with InterruptedException when using http
     cache.
   + f8707c07f153ac4ac2ec4b210321f1a16343006d:
     Account for interface libraries in cc_shared_library
   + a570f5fdb1618a6c272d18bebaa712d3b2af3975:
     Fix coverage runfiles directory issue
   + 95de355e4524a6339c0e807b60d333c36c40bdc7:
     Do not validate input-only settings in transitions (#15048)
   + 71747ccc9d0032a865854613329362563c0574df:
     Filter out system headers on macOS.
   + cb6500a9ce648a02154dca8d05a978ce9b10c4b4:
     Update Bazel bootstrap documentation and remove obsolete flags.
     (#15065)
   + 4c031d1030afb1cb48c7e6d71f83cc99fea607c1:
     [5.1] Undocument --bes_best_effort (#15066)
   + 267142f3dc6b8d32b07beb21e3b4ba6f471a69d8:
     Fix conflicting actions error when specifying
     --host_macos_minimum_os (#15068)
   + f1923627e85b1c1d60bcd928f90f116c3ade7a3a:
     [5.1] Remote: Action should not be successful and cached if
     outputs were not created (#15071)
   + 00d74ff737cccd60305ee58d85313556a077152a:
     Support decompressing zstd tar archives for repository rules.
   + f5857830bb68bd05ffc257506575ed37a8128933:
     Remote: Don't check TreeArtifact output
   + efb2b80953983dce499d453a9f55a74ffaf8c42d:
     osx_cc_wrapper: Only expand existing response files
   + c771c43b870fb8618db7bdab6725ab40cac4976d:
     Remote: Fix crashes by InterruptedException when dynamic
     execution is enabled. (#15091)
   + 3785677cc84fc4024fda85575c05efbde5d512fc:
     Use python3 on macOS
   + 815d9e499a32fd4d87525ac0c698c293cf26433d:
     Release 5.1.0 (2022-03-24)
   + 1fbb69e366034484887e00c6006c7b79508765ed:
     Prepare 5.1.1 release
   + df153df9656e0e197f67622bb11f7d77e19238a0:
     Fix CODEOWNERS syntax
   + 2b92a3111e83a4d14934059afd0f51161a41276f:
     Remote: Don't check declared outputs for failed action
   + b47aa71b21d93c9499103e9a37a6c2ffa79865b9:
     Upgrade abseil version to the latest
   + c49c45d8dac87d21cf2b6a176ddd07f2c9f63414:
     Revert default export all symbols on Windows
   + 7d3fb993f55b35081786c3fe00cf3bebb89574f3:
     Support ZIP files with total number of disks = 0
   + 0f5dc111be06b2ee8694640f400b58e12bfa5fea:
     Release 5.1.1 (2022-04-08)
   + 2422cfb3e5d92d46f9065b2b1e442823a965faf7:
     Update CODEOWNERS
   + bbcff1802423fca7ee5bd6a3e527c12d6d7d80ba:
     [5.2.0] Update java_tools 11.7.1 (#15231)
   + 9c98120f33579b72561e02826d9fccf222eccb3c:
     Add support for .ar archives (and .deb files)
   + d3435b09d89f25bf5008ef3b9c870c835d51a8da:
     Seperate GetSelfPath implementation for Blaze and Bazel
   + c94572bea5ce6bdc0ccda9789e5be6fb3f4c173b:
     Include jdk.crypto.mscapi in minimized Windows embedded JDK
   + 299022ca2dc49b6cb27b2674f933755306ae8b9b:
     remote: Proactively close the ZstdInputStream in
     ZstdDecompressingOutputStream.
   + 27707995cc6576ed1f51fbdb199ff8512e8418c9:
     Collect coverage from cc_binary data deps of java_test
   + 3442179d240e01ef13b0fa7814db7366bad5ffac:
     Configure Apple crosstool to return a complete target triple
     that includes minimum OS version and target environment
   + bb6f1a7ce79168055ccd62629da07d46a52b930d:
     Collect C++ lcov coverage if runtime object not in runfiles
   + dbb6e9954b6e4423f727feb2719ffc75a93b514b:
     Fixing dependencies of //external package
   + f0213bbf730c4a5d1a31e65bc9c01fbb55a6edb3:
     [5.2] Upgrade Google Auth Version (#15383)
   + a1a74c9919e03e09ef7c6ae13f38f48eea80ead1:
     Fix chocolatey package - docsUrl must not 404 (#15395)
   + fe644bee95c14d461e0d1e3cccaa8bbcd57bcd8d:
     Fix cache leak when applying transitions when only a rule's
     attributes change.
   + ad74d5243917bb27a37e38d151a4a3c8a49947eb:
     Fix checking remote cache for omitted files in buildevent file
     (#15405)
   + ac219103d8798965b775db548d7b9214ecd78f73:
     fix(bzlmod): throw on json parse exception
   + 3d85b88609a362857d8ee3c0432a37d30268a8a2:
     Add a flag to expose undeclared test outputs in unzipped form.
     (#15431)
   + abd7a9f70c3dfe96724a692dc7dc04ff33bdece1:
     Remove -U_FORTIFY_SOURCE when thin_lto is enabled (#15433)
   + 53b9cb8637c0faddc6b122a1daab72bcc274bdec:
     Catch NumberFormatException while trying to parse thread id.
   + 19740b55ebc283b7ec42b359bcd4c9096facfdd5:
     Improve the --sandbox_debug error message
   + 0a2a43f9aab1e3875f03f643f6414eb67834c883:
     Set keywords on appropriate lifecycle events.
   + 394ddb82b311ea7edbe2522736b0b0202903ddb6:
     Record additional profiling information for remotely executed
     actions.
   + 652b48e567fcb30768dfc2eddee5f04bf6b5d65b:
     Fix downloading remote execution output files inside output
     dirs. (#15444)
   + 73f1ecbc1cb00e16ceda4b582f4d57268f8701cd:
     Fix android emulator darwin_arm64 select
   + 2649c7c4adef0ebf9bca8fe46aa97304b22de522:
     Fix --use_top_level_targets_for_symlinks with aliases (#15446)
   + fa1081c1f3dce7324a1da59c40d1a1a3533c7047:
     Filter libtool warning about table of contents
   + 26f878325e915e0905626a0e4c8bbacffd72f875:
     Unify sandbox/remote handling of empty TreeArtifact inputs
     (#15449)
   + 6b21b7773157a1eebd3dfe79ff4c4ee750059daf:
     Revert "Fixes incorrect install names on darwin platforms"
   + e133e66f715bac17bf5848e4440c089a8c8d3fd9:
     config doesn't error on duplicate `--define` values (#15473)
   + 84d59176622b76223828e61709179dbd5f0c9f8d:
     Collect coverage from cc_binary data deps of py_test (#15298)
   + 519d2daacfff3de6ffabfc5827621fa835e1c815:
     SolibSymlinkAction does not need exec platform or properties
   + 6e54699884cfad49d4e8f6dd59a4050bc95c4edf:
     Let Starlark tests inherit env variables (#15217)
   + 9610ae889e6fd45280c5beb7fe8f5bef2d736878:
     Update PythonZipper action to use CommandLineItem.CapturingMapFn
   + 2f1ff6fa17c3c30b2533bffe81f40eab06b453b9:
     Make `coverage --combined_report=lcov` skip incompatible tests
   + 9fad5a3dc93cd436a5712c46e6c98d3995428ddb:
     Disable ReturnValueIgnored checks to unblock java_tools release
   + 0120118893261968bdf116ef215655c428428fa8:
     Bump the limit of Bazel install base size (#15585)
   + 668805aace9bf96f78595fc2a122027a3000ceac:
     Upgrade zlib to 1.2.12
   + 4d900ceea12919ad62012830a95e51f9ec1a48bb:
     [5.2] Remote: Fix a bug that outputs of actions tagged with
     no-remote are u... (#15453)
   + b703cb9b999e243d776b7620468e48f450c0ce3a:
     Add feature to produce serialized diagnostics files (#15600)
   + 2e8458b7810eab7829fc7d28af5c45b9af91ed7c:
     Release 5.2.0 (2022-06-07)
   + 536f8d97991d891fc7db333af1a5262497d85173:
     Fix fail message construction in cc_shared_library
   + 2d42925ae80c0fb007aa39f4e210122611897255:
     Define cc-compiler-darwin in Xcode toolchain
   + a1d7d1f69f82da1bdfa1cebd32356249127aea3b:
     Fix alwayslink in objc_import
   + d273cb62f43ef8169415cf60fc96e503ea2ad823:
     Unify URL/URLs parameter code across http_archive, http_file,
     http_jar
   + fea32be42928c84463aa1f335b5722a1f6b8c93a:
     Preserve --experimental_allow_unresolved_symlinks in exec cfg
   + e4bc370b226eb0cc536b55641640266345a214ec:
     Ck/cherry pick cc shared library (#15754)
   + dbdfa07e92f99497be9c14265611ad2920161483:
     Let Starlark executable rules specify their environment (#15766)
   + e2a6a2b130552db7521d3d4d854b9a651b1f4a3b:
     Fix string formatting when java_home path is missing.
   + d54a288e6c79c740b9c93dfc31ee345d6a5332af:
     Optionally enable LLVM profile continuous mode
   + ad17b44cdc192277fafb0d0e204962b2b924dba8:
     Print remote execution message when the action times out (#15772)
   + 240e3d1e1dbc74c7753dead6421d7c1b5fc28d09:
     Add missing line to cherrypick
     e4bc370b226eb0cc536b55641640266345a214ec (#15784)
   + 804b4747152a59bc2965be2db85839b8b2764fc7:
     Replace strdupa with strdup
   + 62be9ea29295fab5289bd5d1a0f13dc7d55a8bc0:
     Bzlmod: Better canonical repo names for modules with overrides
     (#15793)
   + d4663a1c950d618c5b15a3e00fb733987cbf45cc:
     Add repo env test (#15768)
   + 594962cb283dcd71b736e0450453903911a8c85a:
     Add is_root struct field to bazel_module (#15815)
   + 3dd2b932d42fe86112899550d21452409cb3c4b0:
     Fix null pointer crash with `bazel coverage` on only
     incompatible tests
   + 4175018b47800db28c390d39fefbd266b5d674bd:
     Add util for finding credential helper to use
   + 3ea9eb2e363860c9305a987fa22a059afd35598d:
     Merge ManifestMergerAction-related commits into release-5.3.0
     (#15824)
   + 64571a428ffe2bf09f1a5eea13e770a7d0381620:
     Ck/cherrypick 15669 (#15788)
   + 1404651cafe5c26c5dae469e9126de53c2f4f024:
     Create output directories for remote execution (#15818)
   + ae523f82d39daf01cf31e40733de0c6345f0935c:
     Use tree artifacts in bootclasspath rule
   + 37f181cb6ed0237f43d81159eb81b19d3b5f8e36:
     [credentialhelper] Add types to communicate with the subprocess
   + 06ca634e10f17023022ab591a55aabdd9fb57b12:
     Add a flag to force Bazel to download certain artifacts when
     using --remote_download_minimal (#15870)
   + d35f923b098e4dc9c90b1ab66b413c216bdee638:
     RemoteExecutionService: fix outputs not being uploaded
   + 78af34f9f25b0c8fbf597a794a5162f0014629c5:
     Cherry-pick proto_lang_toolchain Starlarkfication and
     proto_common module (#15854)
   + afb434da9da79b53da1ea4c7bcc00571dbea6d3f:
     Fix behavior of `print()` in module extensions
   + 6714c30507edc70ec84f8c97d47cffc497356c0b:
     [credentialhelper] Implement invoking credential helper as
     subprocess
   + 0f05904171d187e6abacb431b3d7494423b027ab:
     Add register_{execution_platforms,toolchains} directives to
     MODULE.bazel files (#15852)
   + 33516e27dc6ee6ab5c3b9dee739a267b08d26b6c:
     [remote] Improve .netrc test in RemoteModuleTest
   + aa2a1f3afe2f10baab5befcafb39df14cbffc743:
     Fix ZipDecompressor windows 0x80 (file attribute normal)
   + 30f16e53cb36a5d506665be7553e785d52772e2d:
     Replace uses of `cfg = "host"` with `cfg = "exec"` (#15922)
   + 2a8d0ad7103511a94382aef41821a315bf8144b7:
     target pattern file: allow comments
   + 6f732052654ec37192450c795bb28dd0aad559cd:
     Add factory for creating paths relative to well-known roots
     (#15931)
   + 32cc8e638b91816f427b74266f6a8da6fb605419:
     Update CODEOWNERS (#15910)
   + 63bc14b095f1ea4043024e7fe1f9c476968897c5:
     Implement native analysis_test call. (#15940)
   + 4df77f771e5cfdf4b614afd8934d00c2b2ff31d1:
     Increase osx_cc_configure timeouts
   + cdf01a39ab9def4d46f41595ac1ac9206a96d6f8:
     Allow string_list flags to be set via repeated flag uses
   + 05e758d4bc18fc9d9e189526381a06e4399056a2:
     [credentialhelper] Add parser for flag syntax (#15929)
   + e4ee34416ef18094496ab54446e70cb62cd509e6:
     Docs should mention the new no-remote-cache-upload tag (#15965)
   + 96d23d30cc80912b82a8fbab31c902e9db74b6ab:
     Add netrc support to --bes_backend (#15970)
   + c5bc34e5f1dd92703dd8f15f9f0409c49b778837:
     Add CommandLinePathFactory to CommandEnvironment (#15971)
   + 508f18576ab5327bd623db6b476511ac2089d0fa:
     Move newCredentialHelperProvider into GoogleAuthUtils (#15973)
   + 14c944a5386eccbcfbe8389afb6c518582b11270:
     Wire up credential helper to command-line flag(s) (#15976)
   + 04c373b708390341be4ceb8eb5b2f8561385cb11:
     Add `--output=files` mode to cquery (#15979)
   + edfe2a17e3434cce660757f59b14f2e9d6ab944e:
     Make cpp assembly file extensions case sensitive again
   + 4ae85387e69db73e507b4f18b36d3e2f799e5d34:
     Prevent aspects from executing on incompatible targets (#15984)
   + f440f8ec3f63e5d663e1f9d9614f05a39422102a:
     Remote: Fix performance regression in "upload missing inputs".
     (#15998)
   + 0109031a2818b217b78026055b972da5901656f5:
     Updated Codeowners file (#16032)
   + 6102d33bf0b72dc0fe9ada4c71113cbee3eb8187:
     Propagate the error message when a credential helper fails.
     (#16030)
   + a8dacc7832b04fe1756cd7adce72f2572f357eee:
     Migrate legacy desugar wrapper to new rlocation() (#16025)
   + 11368be4ac24108f18b1965162ad27f207c074f9:
     Correctly report errors thrown by CommandLinePathFactory#create.
   + 82452c7c372fb28485b0b5e0a98b471648f0dfd0:
     Fix an issue that
     `incompatible_remote_build_event_upload_respect_no_… (#16045)
   + e745468461f93839491a4f80d0c1883d9007f9c0:
     Fix rpath for binaries in external repositories (#16079)
   + 83041b145d3966eb353aacb22b7e33ad01d9a239:
     Refactor combined cache. (#16110)
   + c62496f7b76da473cb1102798373f552ba2f434d:
     C++: Add compound error linked statically but not exported
     (#16113)
   + 0f18786b09e9729d79c0f14f7843b4d8402b6115:
     Do not crash on URIs without a host component.
   + 9c0940df3c5962b2291e812600dd71731775d45b:
     Add profiler task for calling a credential helper.
   + 2ca1ab2c2c73d78021794f3099ee892cc73f515e:
     Make bazel_cc_code_coverage_test more robust against GCC version
     differences (#16254)
   + 1e25152906b668bbe56aa4c1773186af85335315:
     Fix local execution of external dynamically linked cc_* targets
     (#16253)
   + f6cccae5b6f9c0ad0e7d0bf7bd31ea1263449316:
     * add change to allow blaze info to skip Starlark build settings
     that start with --no prefix * add unit tests for both info and
     clean commands
   + 59b8b8f4dc098c31a372ad45adc2a48c5f1c4a9f:
     Release 5.3.1 (2022-09-19)
   + 77f0233420d141e36fbf86a62dff20285c7d8fdc:
     Update GrpcRemoteDownloader to only include relevant headers.
     (#16450)
   + 42ff95a1202cd18cc3348ed6a442de5eb95845bd:
     Avoid unnecessary iteration on action inputs.
   + d29034e43150f32bb02c2cff3774747e25e97de3:
     Update flag `--experimental_remote_download_regex` to accept
     multiple regular expressions. (#16478)
   + bc087f49584a6a60a5acb3612f6d714e315ab8b5:
     Release 5.3.2 (2022-10-19)
   + 0b914c6f2a5114f1b81f44bab348fb415177e53e:
     Send remote actions to specific worker pools instead of machine
     types.
   + ece17d5d4e74d67dd869cbd1951ca1001423b472:
     Add `$(rlocationpath(s) ...)` expansion (#16668)
   + f02bcf8d8b0d00ecdd06ea0a45ba4f52e436597c:
     Fix identical gcov json file name problem
   + 0696b8a728bd205c1a12cc5a3e0891c87113c95a:
     Upgrade google-http-client and google-http-client-gson.
   + 42a3dbb2d47a321d746ee0f1f89603da329f5852:
     Move analysis_test into testing.analysis_test (#16702)
   + b55f3222a5e9d1e4267ccf5cbf71643e8c492b32:
     Fix hanging issue when Bazel failed to upload action inputs
     (#16819)
   + 2f0f3e1253e1086496d4adf1a136b5473db5a693:
     [5.4.0] Add integration tests for
     --experimental_credential_helper. (#16880)
   + 6d2d68d95abedac6a646eafcca04e6856c87ab3c:
     [5.4.0] Keep credentials cached across build commands. (#16884)
   + 676a0c8dea0e7782e47a386396e386a51566087f:
     Update Bazel to depend on bazelbuild/platforms 0.0.5.
   + 0ea070be02e21c2418e967e3398251c3abba73e8:
     Backport recent package metadata and license check capabilities
     from Bazel 6.x. (#16892)
   + b51396a52efd8ff90063ac79e5a69b950cefd914:
     Add 'toolchain' parameter to actions.{run,run_shell} (#16964)
```

Incompatible changes:

  - GrpcRemoteDownloader only includes relevant headers instead of
    sending all credentials.
    
    Closes #16439.
  - analysis_test moved into testing.analysis_test

Important changes:

  - alias() can now select() directly on constraint_value()
    
    Fixes https://github.com/bazelbuild/bazel/issues/13047.
    
    Closes #14310.
  - Fixed an issue where Bazel could erroneously report a test passes
    in coverage mode without actually running the test.
  - Make protocOpts() publicly accessible.
  - Add coverage configuration fragment, used to expose
    output_generator label.
  - Bazel now no longer includes system headers on macOS in coverage
    reports (#14969).
    
    Closes #14971.
  - Starlark test rules can use the new inherited_environment
    parameter of testing.TestEnvironment to specify environment
    variables
    whose values should be inherited from the shell environment.
    
    Closes #14849.
  - none
    RELNOTES:none
  - Enable merging permissions during Android manifest merging with
    the --merge_android_manifest_permissions flag.
  - Added new register_{execution_platforms,toolchains} directives to
    the MODULE.bazel file, to replace the
    {execution_platforms,toolchains}_to_register attributes on the
    module() directive.
  - Add support for fetching RPC credentials from credential helper.
    
    Progress on https://github.com/bazelbuild/bazel/issues/15856
    
    Closes #15947.
  - `cquery`'s new output mode
    [`--output=files`](https://bazel.build/docs/cquery#files-output)
    lists the output files of the targets matching the query. It
    takes the current value of `--output_groups` into account.
    
    Closes #15552.
  - Fix for desugaring failure on Bazel+Android+Windows build
    scenario.
  - The new path variable `$(rlocationpath ...)` and its plural form
    `$(rlocationpaths ...)` can be used to expand labels to the paths
    accepted by the `Rlocation` function of runfiles libraries. This
    is the preferred way to access data dependencies at runtime and
    works on all platforms, even when runfiles are not enabled (e.g.,
    on Windows by default).
    
    Work towards #16124
    Fixes #10923
    
    Closes #16667.

This release contains contributions from many people at Google, as well as amberdixon, Andreas Fuchs, Benjamin Peterson, Brentley Jones, Chenchu Kolli, Dan Fleming, Danny Wolf, Emil Kattainen, Fabian Meumertzheim, Gowroji Sunil, hvadehra, Juh-Roch, Keith Smiley, Krzysztof Naglik, kshyanashree, Niyas Sait, Noa Resare, Oliver Eikemeier, oquenchil, Peter Mounce, Philipp Schrader, Ryan Beasley, Thi Doãn, Xùdōng Yáng, Yannic, Zhongpeng Lin.

## Release 7.0.0-pre.20221207.2 (2022-12-14)

```
Baseline: 2a88c8da7783490ef6192336b091910cd662cc67

Cherry picks:

   + 70691f2b76be0b9530e49c3df18356925843b465:
     Make the Linux sandbox work with ActionInputs with absolute
     "exec paths".
   + 40b340722a97bd3ce1692047f173547203bb7452:
     Fix NPE in signal ignoring logic.
```

This release contains contributions from many people at Google, as well as aryeh, Fabian Meumertzheim, Gaspare Vitta, John Hinnegan, Roger Hu, Yi Cheng.

## Release 7.0.0-pre.20221204.2 (2022-12-09)

```
Baseline: de7b26acfdfcd9c36ec957305a889ac29f0da30e

Cherry picks:

   + 40846718e4f54c28fddc063b80b5ea30a82988c1:
     Add support for crosstool feature to prefer PIC compiles even
     for optimized binaries. This can have performance penalty, but
     in configurations where dynamic linking is used for tests can
     lead to a substantially better sharing of artifacts between
     tests and binaries. In contrast to the existing --force_pic,
     this can be enabled per crosstool and respects whether PIC is
     available for the used crosstool.
```

Incompatible changes:

  - --experimental_replay_action_out_err is not a no-op.
  - `cquery --output=files` also outputs source files.
  - `--incompatible_strict_conflict_checks` is flipped to true. See
    https://github.com/bazelbuild/bazel/issues/16729 for details.
  - `--incompatible_strict_conflict_checks` is flipped to true. See
    https://github.com/bazelbuild/bazel/issues/16729 for details.
  - `--incompatible_always_include_files_in_data` is flipped to true.
    See https://github.com/bazelbuild/bazel/issues/16654 for details.

Important changes:

  - Fixes a bug where some compilation flags would not be applied to
    a cc_test

This release contains contributions from many people at Google, as well as Alex Eagle, aryeh, Christopher Sauer, Fabian Meumertzheim, hvadehra, Keith Smiley, Roger Hu, Ulrik Falklof, Xavier Bonaventura.

## Release 7.0.0-pre.20221123.2 (2022-12-08)

```
Baseline: 14e32e7f5d1492f7ca4ffc17c40b913ec5799603
```

Incompatible changes:

  - the --experimental_async_execution flag is now a no-op.

New features:

  - The `aquery` and `cquery` commands now respect the
    `--query_file` flag just like the `query` command.

Important changes:

  - Starlark `print()` statements are now emitted iff the line of
    code is executed. They are no longer replayed on subsequent
    invocations unless the Starlark code is re-executed.
    Additionally, multiple identical `print()` statements (same
    string from the same line of code, e.g. from a loop) are all
    emitted and no longer deduplicated.

This release contains contributions from many people at Google, as well as Benjamin Peterson, Christopher Sauer, Daniel KT, Fabian Meumertzheim, Matt Mackay.

## Release 7.0.0-pre.20221111.3 (2022-12-01)

```
Baseline: 455454a56e961affb041a1d4a9214f7f313a05aa

Cherry picks:

   + 4caae75b49e815ad2cf1d805f316bc374f03f2ae:
     Automated rollback of commit
     8f956511bb115c39ac683a1e78971fcf9dce5deb.
```

Important changes:

  - The new path variable `$(rlocationpath ...)` and its plural form
    `$(rlocationpaths ...)` can be used to expand labels to the paths
    accepted by the `Rlocation` function of runfiles libraries. This
    is the preferred way to access data dependencies at runtime and
    works on all platforms, even when runfiles are not enabled (e.g.,
    on Windows by default).

This release contains contributions from many people at Google, as well as Ankush Goyal, Artem Zinnatullin, Christopher Peterson Sauer, Ed Schouten, Fabian Meumertzheim, Greg Magolan, keertk, Keith Smiley, nathyong, Robin Tweedie, Yannic Bonenberger, Yannic.

## Release 7.0.0-pre.20221102.3 (2022-11-11)

```
Baseline: 19b8d24531fb728701a85ec050361d434600b5d2
```

Incompatible changes:

  - This has the side effect of changing the message on unsuccessful
    builds from
    ```
    FAILED: Build did NOT complete successfully (0 packages loaded)
    ```
    to
    ```
    ERROR: Build did NOT complete successfully
    ```
  - Bazel no longer increases the delay between progress updates when
    there is no cursor control.
  - This has the side effect of changing the message on unsuccessful
    builds from
    ```
    FAILED: Build did NOT complete successfully (0 packages loaded)
    ```
    to
    ```
    ERROR: Build did NOT complete successfully
    ```

This release contains contributions from many people at Google, as well as Ed Schouten, Fabian Meumertzheim, Keith Smiley, Krzysztof Naglik, Patrick Balestra, Tom Cnops, Xdng Yng, Xiangquan Xiao.

## Release 7.0.0-pre.20221026.2 (2022-11-02)

```
Baseline: b422719f35b1ae5ed5f7f83d05cd778e9c58d793
```

Important changes:

  - Deletes the --extra_proguard_specs Blaze flag

This release contains contributions from many people at Google, as well as Benjamin Peterson, Fabian Meumertzheim, Olek Wojnar, Sara Adams, Xavier Bonaventura.

## Release 6.0.0-pre.20221020.1 (2022-10-27)

```
Baseline: e7218d556a2a265183a10a19fcaa21c0277820ad
```

Incompatible changes:

  - In package_group's `packages` attribute, the syntax "//..." now
    refers to all packages in the same repository as the package
    group, rather than all packages everywhere. The new item "public"
    can be used instead to obtain the old behavior. In `bazel query
    --output=proto` (and `--output=xml`), the `packages` attribute
    now serializes with the leading double slash included (for
    instance, `//foo/bar/...` instead of `foo/bar/...`). See also
    #16355, #16323, and #16391.

New features:

  - Support local_repository in Bazel Registry's source.json file

Important changes:

  - Record hermetic packaged JDK modules file size in deploy JAR
    manifest 'JDK-Lib-Modules-Size' attribute.
  - .bzl files may now set a visibility to guard what other .bzl and
    BUILD files may load them. See [...] for more information.

This release contains contributions from many people at Google, as well as Adam Singer, Albert Lloveras, Alex Eagle, Benjamin Lee, Benjamin Peterson, Christopher Rydell, Ed Schouten, Eric Wendelin, Fabian Meumertzheim, Jordan, Keith Smiley, Kirill Zabelin, Son Luong Ngoc, Tetsuo Kiso, Waleed Khan, Xavier Bonaventura, Yannic Bonenberger.

## Release 6.0.0-pre.20221012.2 (2022-10-24)

```
Baseline: 849f706ac227b1a18f26070cb772c9825583a1b3

Cherry picks:

   + 1ab8498a536cab2ff77cc221e4052ef7a6c7b778:
     Automated rollback of commit
     849f706ac227b1a18f26070cb772c9825583a1b3.
   + c5ccb06cb40dff72c69ea774e63cb8a1eea8ea1e:
     Automated rollback of commit
     bc1e9d85c97e8a62b49c6e26ede14eccd4951bd4.
   + 977d7fb3837ceeabd17ecd639037f95a99ca4cb1:
     Use single argument form for framework linkopts
```

Incompatible changes:

  - GrpcRemoteDownloader only includes relevant headers instead of
    sending all credentials.

This release contains contributions from many people at Google, as well as Fabian Meumertzheim, Keith Smiley, Xiangquan Xiao.

## Release 6.0.0-pre.20221007.4 (2022-10-20)

```
Baseline: 5d0e5a7ba415b981390bf9579da644e1065b2a36

Cherry picks:

   + 512d9b5cf784cc4450baf50362ab3d88cd815184:
     Automated rollback of commit
     21904a92b800139499f2f62c7c4c11351fa8bc0c.
   + ff927f72644b4d1c3036ea8b3b821c58c34c92fa:
     Automated rollback of commit
     dadc49e437018f482640ed76fae5307daf9911a8.
   + c5ccb06cb40dff72c69ea774e63cb8a1eea8ea1e:
     Automated rollback of commit
     bc1e9d85c97e8a62b49c6e26ede14eccd4951bd4.
```

Incompatible changes:

  - this incompatible change breaks old instances of http_archive
    that specified netrc as an absolute path. It is unlikely there
    are many instances in the wild since the path would refer to a
    netrc file inside the external repository by absolute path.
    Migration should be straightforward.
  - genrule switched to use exec transition instead of host. This can
    break targets with hardcoded output paths. To avoid using
    hardcoded paths use make variables, see
    https://docs.bazel.build/versions/4.2.2/be/make-variables.html#pre
    defined_label_variables
  - this incompatible change breaks old instances of http_archive
    that specified netrc as an absolute path. It is unlikely there
    are many instances in the wild since...
  - Error Prone now checks for unused return values of additional
    methods on `java.lang.Object`, which can be disabled using
    `--javacopts=-Xep:ReturnValueIgnored:OFF`
  - Error Prone now checks for unused return values of additional
    methods on `java.lang.Object`, which can be disabled using
    `--javacopts=-Xep:ReturnValueIgnored:OFF`
  - The --incompatible_existing_rules_immutable_view flag has been
    flipped to true. See
    https://github.com/bazelbuild/bazel/issues/13907 for
    migration notes.
  - Split up the C++ archive from the C++ link action and set
    `CppArchive` as mnemonic.
  - workspace(managed_directories=) is not available anymore.
  - --legacy_important_outputs now has a default of false.
  - --legacy_important_outputs default reverted to true.
  - objc_library now requires CcInfo in its deps.  If this breaks
    you, add empty CcInfo() to your rule.
  - Flag --experimental_local_memory_estimate removed.
  - Added a new flag
    --incompatible_unambiguous_label_stringification, which causes
    labels in the main repo to stringify into unambiguous forms
    starting with an @. See
    https://github.com/bazelbuild/bazel/issues/15916 for more
    information.
  - analysis_test moved into testing.analysis_test
  - Flip incompatible_enable_cc_toolchain_resolution
    (https://github.com/bazelbuild/bazel/issues/7260)
  - (Rollback) Flip incompatible_enable_cc_toolchain_resolution
    (https://github.com/bazelbuild/bazel/issues/7260)
  - name parameter is removed from rule call
    (https://github.com/bazelbuild/bazel/issues/16301)
  - name parameter is removed from rule call
    (https://github.com/bazelbuild/bazel/issues/16301)
  - name parameter is removed from rule call
    (https://github.com/bazelbuild/bazel/issues/16301)
  - --incompatible_remote_downloader_send_all_headers is flipped to
    true. See #16356 for details.

Important changes:

  - Deprecate --incompatible_applicable_licenses flag, in preparation
    for removal in Bazel 6.x.
  - Treat py_*.srcs_version="PY2" the same as "PY2ONLY".
  - The Build Event Protocol now contains file digests and sizes
    along with the file name and URI.
  - Refactor system suspend event handling.
  - alias() can now select() directly on constraint_value()
  - Allow \a \b \f \v escape sequences in Starlark.
  - Match remote and local xcode version by most granular version.
  - Adds `--experimental_worker_multiplex_sandboxing` flag that
    controls whether to sandbox multiplex workers that support it.
  - provider() has a new parameter: init, a callback for performing
    pre-processing and validation of field values. Iff this parameter
    is set,
    provider() returns a tuple of 2 elements: the usual provider
    symbol (which,
    when called, invokes init) and a raw constructor (which bypasses
    init).
  - Tests that fail to create or complete their
    `TestAttemptContinuation` by
    throwing an `ExecException` will report an `INCOMPLETE` status.
    Previously, Bazel
    would fail to report any status for the test attempt.
  - Fixed an issue where Bazel could erroneously report a test passes
    in coverage mode without actually running the test.
  - Include more information about configurations in cquery proto
    formatted output. This deprecates the configuration field of
    AnalysisProtosV2.ConfiguredTarget, and adds a new field,
    configuration_id, to
    be used instead.
  - experimental cc_library.implementation_deps inverted to
    interface_deps
  - In aquery and cquery proto output, indicate if a configuration is
    a
    tool or non-tool configuration.
  - Include complete configurations in cquery proto output.
  - experimental cc_library.implementation_deps inverted to
    interface_deps
  - Make protocOpts() publicly accessible.
  - Add some documentation about how configuration information is
    conveyed in cquery proto output.
  - Introduces experimental static library linking API under
    apple_common.link_multi_arch_static_library
  - Further deprecation and removal of pkg_tar. Stop supporting
    legacy use of 'files' attribute, where it could be a list of
    labels instead of a map of paths to labels.
  - Removed --incompatible_no_build_defs_pkg flag. It never fulfilled
    its purpose because --all_incompatible_changes would never set
    it. The last rule it gated (pkg_tar) is scheduled to be removed
    in Bazel 6.x.
  - Add coverage configuration fragment, used to expose
    output_generator label.
  - Bazel now no longer includes system headers on macOS in coverage
    reports (#14969).
  - android_sdk_repository read $ANDROID_SDK_ROOT in addition to
    $ANDROID_HOME.
  - The default dexer is now d8. dx can be optionally enabled using:
      --define=android_dexmerger_tool=dx_dexmerger \
      --define=android_incremental_dexing_tool=dx_dexbuilder \
      --define=android_standalone_dexing_tool=dx_compat_dx \
      --use_workers_with_dexbuilder
  - Packaging support for deploy JAR embedded JDK files (hermetic
    Java).
  - Don't stamp cc_common.link actions for tool dependencies.
  - Starlark test rules can use the new inherited_environment
    parameter of testing.TestEnvironment to specify environment
    variables
    whose values should be inherited from the shell environment.
  - Enable merging permissions during Android manifest merging with
    the --merge_android_manifest_permissions flag.
  - Allow specialization to work with constraint_values.
  - Bazel uses the D8 jar from Maven instead of the SDK.
  - Make ijar / java_import preserve classes with `@kotlin.Metadata`
    annotations
  - Switch cc_test implementation to Starlark. Note: cc_test will now
    link statically when _targeting_ Windows regardless of host
    platform (rather than always linking statically when Windows is
    the _host_).
  - Switch cc_test implementation to Starlark. Note: cc_test will now
    link statically when _targeting_ Windows regardless of host
    platform (rather than always linking statically when Windows is
    the _host_).
  - Add devtools/build/lib/worker:work_request_handlers to the remote
    android tools release package. This will be transitively packaged
    into all_android_tools.
  - Bazel uses the D8 jar from Maven instead of the SDK.
  - android_sdk_repository read $ANDROID_SDK_ROOT in addition to
    $ANDROID_HOME.
  - Advance android_tools_pkg version to 0.24.0.
  - Switch cc_test implementation to Starlark. Note: cc_test will now
    link statically when _targeting_ Windows regardless of host
    platform (rather
    than always linking statically when Windows is the _host_).
  - Bazel uses the D8 jar from Maven instead of the SDK.
  - "blaze config" now only reports info from the last build. To
    compare configurations across multiple builds, redirect "blaze
    config" output to a file and run your favorite diff tool.
  - The --incompatible_override_toolchain_transition flag is now
    always set, and will be removed in the future. Thus,
    --noincompatible_override_toolchain_transition has no effect, and
    the value of the incompatible_use_toolchain_transition parameter
    in aspect() and rule() builtins is ignored.
  - Switch cc_test implementation to Starlark. Note: cc_test will now
    link statically when _targeting_ Windows regardless of host
    platform (rather
    than always linking statically when Windows is the _host_).
  - Toolchain types may now be optional, in addition to mandatory.
    See https://bazel.build/docs/toolchains#optional-toolchains for
    further details.
  - Add six to deps of has_services=1 py_proto_librarys.
  - pkg_tar(symlinks) has been removed. Users needing that feature
    should
    migrate to @rules_pkg.
  - Aspects can now define and use exec groups using the same API as
    rules.
  - Removed the obsolete --incompatible_applicable_licenses flag. The
    feature is permanently enabled.
  - embedded_tools packages R8 desugarer again
  - Bazel now selects sh path based on execution platform instead of
    host platform, making it possible to execute sh actions in
    multiplatform builds. --shell_executable now only applies to
    actions configured for host.
  - labels in genquery.scope are no longer configured.
  - When Bzlmod is enabled, all Bzlmod-generated repos will have an
    extra '@' prepended to their names. This effectively enables the
    canonical label literal syntax for Bzlmod-generated repos
    (`@@canonicalRepoName//pkg:target`; see
    https://docs.google.com/document/d/1N81qfCa8oskCk5LqTW-LNthy6EBrDo
    t7bdUsjz6JFC4/edit?usp=sharing).
  - Exposed `CcSharedLibraryInfo` to Starlark builtins.
  - Enable --use_top_level_targets_for_symlinks by default.
  - Singlejar accepts runtime Created-By field
  - --noincompatible_disable_managed_directories, and with that,
    workspace(managed_directories=) is not supported anymore.
  - Bazel supports D8 desugaring, albeit without persistent workers
  - Remove mtime options from pkg_tar. Users should migrate to
    @rules_pkg.
  - Test for experimental multiplexed persistent resource processor.
  - Added new register_{execution_platforms,toolchains} directives to
    the MODULE.bazel file, to replace the
    {execution_platforms,toolchains}_to_register attributes on the
    module() directive.
  - The legacy pkg_tar no longer supports the ability to untar and
    repackage an input tar file (`deps` attribute). Users needed that
    capability must switch to github.com/bazelbuild/rules_pkg.
  - `cquery`'s new output mode
    [`--output=files`](https://bazel.build/docs/cquery#files-output)
    lists the output files of the targets matching the query. It
    takes the current value of `--output_groups` into account.
  - Change singlejar metadata to report Created-By Bazel
  - Add support for fetching RPC credentials from credential helper.
  - Revert interface_deps back to implementation_deps after problem
    reported in. Use `buildozer 'rename deps implementation_deps'
    //...:%cc_library; buildozer 'rename interface_deps deps'
    //...:%cc_library`
  - Fix for desugaring failure on Bazel+Android+Windows build
    scenario.
  - D8 is the default desugarer
  - Migrate main_dex_list_creator to D8 (DX deprecation)
  - --experimental_enable_bzlmod has been renamed --enable_bzlmod,
    and still defaults to false.
  - selects() no longer produce irrelevant duplicate label checks
  - Adds a dexer output cache to CompatDexBuilder to improve build
    speed.
  - Improved error messages when analyzing inline bzl code
  - Improved error messages when analyzing inline bzl code
  - The `@bazel_tools//tools/cpp:compiler` flag now has the value
    `gcc` if the configured compiler is detected to be gcc rather
    than the generic value `compiler`. A branch for `gcc` may have to
    be added to `select` statements that do not have a default case
    that handles gcc appropriately.
  - The `get_child` method of `path` now accepts an arbitrary
    number of relative path strings as positional arguments.
  - SourceManifestAction supports `Action.content`
  - Add --incompatible_build_transitive_python_runfiles alias. See
    #16303
  - The @bazel_tools//tools/cpp:compiler flag now has the value
    `clang` for the auto-configured Xcode toolchain rather than the
    generic value compiler. A branch for `clang` may have to be added
    to select statements that do not have a default case that handles
    this toolchain appropriately.
  - added additional debug message to warn of skipped toolchains
    during resolution
  - The deprecated --remote_allow_symlink_upload flag has been
    removed. Symlinks in local action outputs are always permitted,
    even with remote caching. Whether they're uploaded as symlinks or
    as the files/directories they point to is still determined by the
    --incompatible_remote_symlinks flag.
  - Added `struct`, `json`, `proto`, and `depset` to the starlark
    environment of Bazel's cquery (--output=starlark) command
  - Added three `package_group`-related flags:
    `--incompatible_package_group_includes_double_slash` (#16391),
    `--incompatible_package_group_has_public_syntax` (#16355), and
    `--incompatible_fix_package_group_reporoot_syntax` (#16323). With
    these flags, `package_group` can now easily specify "all
    packages", "no packages", and "all packages in the current repo".

This release contains contributions from many people at Google, as well as Adam Azarchs, Adam Wolf, Albert Lloveras, Alessandro Patti, Alex Eagle, Alex Scott, Alex Torok, Andreas Fuchs, Andreas Herrmann, Andrew Katson, Andrew Klotz, Ara Nguyen, arunkumar9t2, arun.sampathkumar, Ast-x64, Benedek Thaler, Benjamin Lee, Benjamin Peterson, Ben Lee, Bohdan Vanieiev, Bo Zhang, Bo Zhang, Bradley Burns, Brandon Duffany, Brandon Jacklyn, Brentley Jones, Brentley Jones, Chad Miller, Charles-Francois Natali, Chris Clearwater, Chris Fredrickson, Christopher Peterson Sauer, Christopher Sauer, ckiffel, Cristian Hancila, crydell-ericsson, Dan Fleming, Daniel Wagner-Hall, Danny Wolf, David Ostrovsky, David Sanderson, Denys Kurylenko, dhmemi, Dimi Shahbaz, divanorama, dmaclach, Ed Schouten, Emil Kattainen, Eric Song, Fabian Brandstetter, Fabian Meumertzheim, floriographygoth, Fredrik Medley, George Prekas, gkgoat1, gkorlam, Greg Estren, Greg, Gregory Fong, Greg Roodt, Grzegorz Lukasik, Halil Sener, Hannes Kufler, homuler, hvadehra, hvd, Igor Nazarenko, James Broadhead, Jan, Jason Tan, Jay Bazuzi, Jeremy Volkman, jheaff1, Jiawen Chen, Joel Williamson, John Laxson, John Millikin, Jonathan Gerrish, Jon Shea, juanchoviedo, Kaiqin Chen, Keith Smiley, Ken Micklas, Kevin Lin, Kiron, Krishna Ersson, kshyanashree, lihu, Luc Bertrand, Luis Fernando Pino Duque, Marek uppa, Matt Clarkson, Matt Mackay, Michael P. Nitowski, Mikhail Balabin, Mostyn Bramley-Moore, Nick Korostelev, Nitesh Anandan, Niyas Sait, Noa Resare, Oscar Bonilla, Patrick Balestra, Paul Tarjan, Peter Mounce, Philipp Schrader, Pras Velagapudi, Rahul Butani, Rajeshwar Reddy T, Rifqi Mulya Fahmi, Roman Salvador, rustberry, Ryan Beasley, Ryan Schmidt, Sahin Yort, Saleem Abdulrasool, Shuai Zhang, Simon Bjorklen, Son Luong Ngoc, Stephan Wolski, Steve Vermeulen, Stiopa Koltsov, Sven Tiffe, Takeo Sawada, Tao Wang, Ted Kaplan, Tetsuo Kiso, Thi Doan, Thomas Chen, ThomasCJY, Thomas, Thomas Zayouna, Timothe Peignier, Tomas Volf, Tom de Goede, Ulf Adams, Ulrik Falklof, vardaro, Vasilios Pantazopoulos, Vladimir Tagakov, William Muir, Xavier Bonaventura, Xdng Yng, Yannic Bonenberger, Yannic Bonenberger, Yannic, Yannic, Yesudeep Mangalapilly, Yuval K, Zhongpeng Lin.

## Release 5.3.2 (2022-10-19)

```
Baseline: 8d66a4171baddcbe1569972f019e54130111202c

Cherry picks:

   + becd1494481b96d2bc08055d3d9d4d7968d9702e:
     Remote: Cache merkle trees
   + d7628e1b566be353fe7172241ac8f15d5f8e7ff5:
     Update DEFAULT_IOS_CPU for M1 arm64 simulator support
   + 80c56ff7b603fcfff02a5f97829a2a5935f360a0:
     Compile Apple tools as fat binaries if possible
   + 3c09f3438a966b49a7c1726022c898b390b3a6e5:
     Add protobuf as a well known module
   + 3a5b3606a6f5433467a5b49f0188c41411684bf5:
     Remote: Merge target-level exec_properties with
     --remote_default_exec_properties
   + 917e15ea408e1d3d25574edbb466b39cfbcb61fe:
     Add -no_uuid for hermetic macOS toolchain setup
   + f5cf8b076bc913dbe021104d5f6837fb4a6cd8b3:
     Remote: Fixes an issue when --experimental_remote_cache_async
     encounter flaky tests.
   + 77a002cce050e861fcc87c89acf7768aa5c97124:
     Remove DigestUtils.getDigestInExclusiveMode() now that SsdModule
     has …
   + 557a7e71eeb5396f2c87c909ddc025fde2678780:
     Fixes for the Starlark transition hash computation (#14251)
   + 34c71465f84fa780217926db2e8e5ca3d6d4568c:
     Do location expansion in copts of objc_library
   + 50274a9f714616d4735a560db7f617e53fb8d01b:
     [5.x] Remote: Add support for compression on gRPC cache (#14277)
   + 61bf2e5b5181cbe34a2f0d584053570943881804:
     Automated rollback of commit
     34c71465f84fa780217926db2e8e5ca3d6d4568c.
   + 79888fe7369479c398bafe064daa19a7ae30f710:
     Silence a zstd-jni GCC warning.
   + 063b5c9c2c09b4794010b9a169b44890ffc79ec4:
     Remote: Limit max number of gRPC connections by
     --remote_max_connections.
   + fd727ec96d861573dcbad3249d727a94eff84789:
     Do location expansion in copts of objc_library
   + 23d096931be9b7247eafa750999dd7feadde14c1:
     Fix _is_shared_library_extension_valid
   + 5cf1d6e1f78bc860fcd0e2e86eff6fe43ab4a5a2:
     Remove merging of java_outputs in JavaPluginInfo.
   + cea5f4f499aa832cf90c68898671869ce79d63f2:
     Cherrypick Bzlmod documentation (#14301)
   + 227e49e28e5122cddd6c4cb70686ff7bde3617ea:
     Format work requests according to ndjson spec
   + ae0a6c98d4f94abedbedb2d51c27de5febd7df67:
     Enable user_link_flags_feature for macosx cc_toolchain_config
   + 8c2c78cdc66cc9d5eb2cd59823c659892c1643a7:
     Remote: Use Action's salt field to differentiate cache across
     workspaces.
   + f94898915268be5670fb1e93a16c03e9b14d2a58:
     [5.x] Remote: Fix "file not found" error when remote cache is
     changed from enabled to disabled.  (#14321)
   + 3069ac4e33dcca6f3d1abf55940cdd764d03bdbf:
     Delete marker file before fetching an external repository
   + c05c6261cdb2cacb7c9881c255c0ada435ab5182:
     Remote: Fix file counting in merkletree.DirectoryTreeBuilder
   + d84f7998ef8f15e27376a0c8f25b320145c4ba9e:
     Fix remote spawn tests for remote_merkle_tree_cache=true
   + 59e16e944200555da377799aa0d9e8d0674d2e27:
     Show skipped tests as a warning
   + 76b3c242831f8e88835e3002a831a185a41fcc52:
     Build xcode-locator as a universal binary
   + aa52f2ddf9bab1ebd18e5431124061e813bfcd80:
     Exit collect_coverage.sh early if LCOV_MERGER is not set.
   + 4256d46327bad8638df91be1a5d4ef83b12b74c7:
     Automated rollback of commit
     d84f7998ef8f15e27376a0c8f25b320145c4ba9e.
   + dce24350befd08216b3910ae343670015444ff81:
     [apple] fix issues compiling C in objc_library for watchos/armv7k
   + bfc24139d93f8643686d91596ba347df2e01966a:
     5.x: Remote: Ignore blobs referenced in BEP if the generating
     action cannot be cached remotely. (#14389)
   + 5aef53a8884038f3c9f06e6dddb9372196253378:
     Remote: Don't blocking-get when acquiring gRPC connections.
     (#14420)
   + 005361c895da334beb873901e93aff06d180256e:
     Disable IncludeValidation for ObjC in bazel
   + d703b7b4f09fb3c389f99e52bac1f23930280b56:
     Update java_tools v11.6
   + 90965b072eb4a6dec8ff5b8abde3726732d37bdc:
     Stop remote blob upload if upload is complete. (#14467)
   + dc59d9e8f7937f2e317c042e8da8f97ba6b1237e:
     [5.x] Make remote BES uploader better (#14472)
   + 2edab739e1f61fe8813230b03396ca46f0790089:
     Avoid too verbose warnings in terminal when cache issues
   + 1160485192b5e6d95bcd426b55cc9a35fc6b8614:
     Rename --project_id to --bes_instance_name
   + c63d9ecbe5fcb5716a0be21d8fc781d7aa5bbc30:
     Automated rollback of commit
     bfdfa6ebfd21b388f1c91f512291c848e1a92a96.
   + b341802700484d11c775bf02d80f43ba3f33b218:
     [apple] support watchos_arm64 in toolchain
   + 43bcf80a3dfdc5ac89c1e4d615d6f29a495855fb:
     Disable implicitly collecting baseline coverage for toolchain
     targets.
   + 302971e1b3d803069ac949c0085c0d2a3916c8ab:
     Automated rollback of commit
     7d09b4a15985052670244c277e4357557b4d0039.
   + 62002024ca7012ffe0f4fc74ac20b5471513c8c8:
     Bzlmod: Starlarkify default attr values for TypeCheckedTags
   + 38117d491cbc4a5686e0bdb1e58f8946d96aed58:
     Fix build after rc4 cherrypicks (#14581)
   + 41feb616ae18e21fdba3868e4c298b0b83012f10:
     Release 5.0.0 (2022-01-19)
   + 486d153d1981c3f47129f675de20189667667fa7:
     Find runfiles in directories that are themselves runfiles
   + 0de7bb95022057e8b89334f44759cf6f950e131f:
     Don't resolve symlinks for --sandbox_base
   + 8b60c90f3641591b65c4e153113aea562f1fab94:
     Remove uses of -lstdc++ on darwin
   + 60f757c0831f9fbb2415fb0105f964201faa9fa0:
     Allow Label instances as keys in select (#14755)
   + 3836ad029f202ca13c64c9f07e4568ea8ab2d9a6:
     Remote: Only waits for background tasks from remote execution.
   + 8734ccf9847eafb7193388cd9c6fa78faa78283f:
     Add the default solib dir to the rpath for cc_imports with
     transitions
   + 9e16a6484e94c358aa77a6ed7b1ded3243b65e8f:
     Flip --experimental_worker_allow_json_protocol
   + fce7ea8d5e0facfc125ae7c37bfb4b9a7c586e40:
     Fix `ctx.fragments.apple.single_arch_cpu` returning incorrect
     cpu for tools when host cpu and exec cpu are different
   + 0c1d09e4dce4c3251c2be2c70d4575ec65b1d9d3:
     Propagate --experimental_cc_implementation_deps to host config
   + 1c3a2456c95fd19974a5b2bd33c5ebdb2b2277e4:
     Support select() on constraint_value for aliases.
   + 67a133b431ccece22b7dd9a72f0837cff77d4360:
     Improve documentation for select()
   + 5356fedd4b6079851b51db27077bf84c7bab16a4:
     Cherrypicks for experimental cc_shared_library (#14773)
   + ffdd633d7b9f21267f4f9759dd9833096dd4e3a2:
     [apple] support tvos_sim_arm64 in toolchain (#14779)
   + a58ddea50b2fd476d183e2e0c077ad6173039b89:
     Cherry pick win arm64 (#14794)
   + dc41a20bb045d221a43223a5db6b8b44cd8f1676:
     [5.1.0] cherrypick subpackages support (#14780)
   + 86e2db7d67ec52bfe11c1f517f650653cee3ea26:
     Add a helper method for rules to depend on the cpp toolchain
     type.
   + 6990c02644a71d5e7c95c9c234ecf39bb55c6ac4:
     UrlRewriter should be able to load credentials from .netrc
     (#14834)
   + 32d1606dac2fea730abe174c41870b7ee70ae041:
     Add "arch" struct field to repository_os
   + 2cfdceae971d09f50ceddc3d7ef723fb5f879957:
     [5.x] bzlmod: Add support for WORKSPACE.bzlmod (#14813)
   + c2ddbd1954af5baab63b93f2b055a410a27832c8:
     Ignore missing include directory in JDK distribution.
   + 16de03595e21f7bf31818e717505b23c953b3b7d:
     Fix bazel coverage false negative
   + 0c74741742301abcf67452a7f591daec1c3a7635:
     Remote: Postpone the block waiting in `afterCommand` to
     `BlockWaitingModule` (#14833)
   + 3297d9234e15515aa91cc887b3b12db7e1040b02:
     Switch to `ProcessHandle` for getting the PID (#14842)
   + a987b98ea0d6da2656c4115568ef9cbe8a164550:
     Fix uses of std++ on bsd
   + d184e4883bb7fc21de2f7aeea4304994de27e9ea:
     Remote: handle early return of compressed blobs uploads
   + 0b09e9e018c557da04c9f978d25a66d963cd6cb6:
     Add removeprefix/removesuffix to Starlark strings
   + d42ab0cfcce56b5e55c8bd94d0923d08758fdb5b:
     Fix default CPU for macOS and iOS (#14923)
   + cd24f39750d7b08f6f31c82d3a23cc329c7fc78e:
     Add paramfile support for def_parser, since in rare cases on
     Windows command line character limit was reached.
   + 0b1beefd1e7611dc9b9f559d00d8ff76aabb0f32:
     Normalize rpath entries to guard against missing default solib
     dir
   + 24e82426e689853b0d9a04e7b9b6f13e145cf2d6:
     Fix aggressive params file assumption
   + c45838bd3e51bcd0c8c3e1a9b4a0e55cdf4b4f59:
     Fix precompiled libs not in runfiles of cc_shared_library
     (#14943)
   + 764614e0f0287125269e7a92e909a44624bcb360:
     Bzlmod: Allow multiple `use_extension`s on the same extension
     (#14945)
   + fa761f84994f18db383fbe9aaea524e4385da13a:
     Fix typo in `apple_common.platform` docs
   + f7d8288bd7b16c7f2e010aa8ddc241cf2ba8e0d5:
     Yield a Proxy for addresses without protocol
   + 8cefb8bed4ac82df8640682517372a9249732352:
     Avoid merging URLs in HttpUtils
   + b4804807fc2c184cc36df9e69e472942c01941b8:
     Make protocOpts() public. (#14952)
   + 113eaca5862c48797654ae2a3acbb6e15d761485:
     Do not hide BulkTransferException messages when there were more
     than one exception
   + b1bf9d6c5f85fc4fda0dc48bc3d3e2fe26880867:
     merkle_tree_cache: change default size to 1000
   + f15e0c7224ecc5473d4972afc436e28df35c4e5a:
     Add --experimental_repository_cache_urls_as_default_canonical_id
     to help detect broken repository URLs (#14989)
   + f4214746fcd15f0ef8c4e747ef8e3edca9f112a5:
     Expose the logic to read user netrc file
   + b858ec39aebd7e586af5438aa2035db2adebf9a4:
     Correct cpu and os values of `local_config_cc_toolchains` targets
   + 5e79972c05d89280f0cf1fa620f807366847bac6:
     Expose CoverageOutputGenerator on a Fragment (#14997)
   + 78f03110e0dab42f37e427fd524e72706e036d74:
     Correct error runfiles cc_shared_library (#14998)
   + 7937dd14c3c632ffcfaea9073d5dec6dcac93845:
     [5.1] Adding Starlark dependencies to the package //external
     (#14991)
   + a73aa12be65454ac8cfb5a8f3e056c420402f997:
     Remote: Fix crashes with InterruptedException when using http
     cache.
   + f8707c07f153ac4ac2ec4b210321f1a16343006d:
     Account for interface libraries in cc_shared_library
   + a570f5fdb1618a6c272d18bebaa712d3b2af3975:
     Fix coverage runfiles directory issue
   + 95de355e4524a6339c0e807b60d333c36c40bdc7:
     Do not validate input-only settings in transitions (#15048)
   + 71747ccc9d0032a865854613329362563c0574df:
     Filter out system headers on macOS.
   + cb6500a9ce648a02154dca8d05a978ce9b10c4b4:
     Update Bazel bootstrap documentation and remove obsolete flags.
     (#15065)
   + 4c031d1030afb1cb48c7e6d71f83cc99fea607c1:
     [5.1] Undocument --bes_best_effort (#15066)
   + 267142f3dc6b8d32b07beb21e3b4ba6f471a69d8:
     Fix conflicting actions error when specifying
     --host_macos_minimum_os (#15068)
   + f1923627e85b1c1d60bcd928f90f116c3ade7a3a:
     [5.1] Remote: Action should not be successful and cached if
     outputs were not created (#15071)
   + 00d74ff737cccd60305ee58d85313556a077152a:
     Support decompressing zstd tar archives for repository rules.
   + f5857830bb68bd05ffc257506575ed37a8128933:
     Remote: Don't check TreeArtifact output
   + efb2b80953983dce499d453a9f55a74ffaf8c42d:
     osx_cc_wrapper: Only expand existing response files
   + c771c43b870fb8618db7bdab6725ab40cac4976d:
     Remote: Fix crashes by InterruptedException when dynamic
     execution is enabled. (#15091)
   + 3785677cc84fc4024fda85575c05efbde5d512fc:
     Use python3 on macOS
   + 815d9e499a32fd4d87525ac0c698c293cf26433d:
     Release 5.1.0 (2022-03-24)
   + 1fbb69e366034484887e00c6006c7b79508765ed:
     Prepare 5.1.1 release
   + df153df9656e0e197f67622bb11f7d77e19238a0:
     Fix CODEOWNERS syntax
   + 2b92a3111e83a4d14934059afd0f51161a41276f:
     Remote: Don't check declared outputs for failed action
   + b47aa71b21d93c9499103e9a37a6c2ffa79865b9:
     Upgrade abseil version to the latest
   + c49c45d8dac87d21cf2b6a176ddd07f2c9f63414:
     Revert default export all symbols on Windows
   + 7d3fb993f55b35081786c3fe00cf3bebb89574f3:
     Support ZIP files with total number of disks = 0
   + 0f5dc111be06b2ee8694640f400b58e12bfa5fea:
     Release 5.1.1 (2022-04-08)
   + 2422cfb3e5d92d46f9065b2b1e442823a965faf7:
     Update CODEOWNERS
   + bbcff1802423fca7ee5bd6a3e527c12d6d7d80ba:
     [5.2.0] Update java_tools 11.7.1 (#15231)
   + 9c98120f33579b72561e02826d9fccf222eccb3c:
     Add support for .ar archives (and .deb files)
   + d3435b09d89f25bf5008ef3b9c870c835d51a8da:
     Seperate GetSelfPath implementation for Blaze and Bazel
   + c94572bea5ce6bdc0ccda9789e5be6fb3f4c173b:
     Include jdk.crypto.mscapi in minimized Windows embedded JDK
   + 299022ca2dc49b6cb27b2674f933755306ae8b9b:
     remote: Proactively close the ZstdInputStream in
     ZstdDecompressingOutputStream.
   + 27707995cc6576ed1f51fbdb199ff8512e8418c9:
     Collect coverage from cc_binary data deps of java_test
   + 3442179d240e01ef13b0fa7814db7366bad5ffac:
     Configure Apple crosstool to return a complete target triple
     that includes minimum OS version and target environment
   + bb6f1a7ce79168055ccd62629da07d46a52b930d:
     Collect C++ lcov coverage if runtime object not in runfiles
   + dbb6e9954b6e4423f727feb2719ffc75a93b514b:
     Fixing dependencies of //external package
   + f0213bbf730c4a5d1a31e65bc9c01fbb55a6edb3:
     [5.2] Upgrade Google Auth Version (#15383)
   + a1a74c9919e03e09ef7c6ae13f38f48eea80ead1:
     Fix chocolatey package - docsUrl must not 404 (#15395)
   + fe644bee95c14d461e0d1e3cccaa8bbcd57bcd8d:
     Fix cache leak when applying transitions when only a rule's
     attributes change.
   + ad74d5243917bb27a37e38d151a4a3c8a49947eb:
     Fix checking remote cache for omitted files in buildevent file
     (#15405)
   + ac219103d8798965b775db548d7b9214ecd78f73:
     fix(bzlmod): throw on json parse exception
   + 3d85b88609a362857d8ee3c0432a37d30268a8a2:
     Add a flag to expose undeclared test outputs in unzipped form.
     (#15431)
   + abd7a9f70c3dfe96724a692dc7dc04ff33bdece1:
     Remove -U_FORTIFY_SOURCE when thin_lto is enabled (#15433)
   + 53b9cb8637c0faddc6b122a1daab72bcc274bdec:
     Catch NumberFormatException while trying to parse thread id.
   + 19740b55ebc283b7ec42b359bcd4c9096facfdd5:
     Improve the --sandbox_debug error message
   + 0a2a43f9aab1e3875f03f643f6414eb67834c883:
     Set keywords on appropriate lifecycle events.
   + 394ddb82b311ea7edbe2522736b0b0202903ddb6:
     Record additional profiling information for remotely executed
     actions.
   + 652b48e567fcb30768dfc2eddee5f04bf6b5d65b:
     Fix downloading remote execution output files inside output
     dirs. (#15444)
   + 73f1ecbc1cb00e16ceda4b582f4d57268f8701cd:
     Fix android emulator darwin_arm64 select
   + 2649c7c4adef0ebf9bca8fe46aa97304b22de522:
     Fix --use_top_level_targets_for_symlinks with aliases (#15446)
   + fa1081c1f3dce7324a1da59c40d1a1a3533c7047:
     Filter libtool warning about table of contents
   + 26f878325e915e0905626a0e4c8bbacffd72f875:
     Unify sandbox/remote handling of empty TreeArtifact inputs
     (#15449)
   + 6b21b7773157a1eebd3dfe79ff4c4ee750059daf:
     Revert "Fixes incorrect install names on darwin platforms"
   + e133e66f715bac17bf5848e4440c089a8c8d3fd9:
     config doesn't error on duplicate `--define` values (#15473)
   + 84d59176622b76223828e61709179dbd5f0c9f8d:
     Collect coverage from cc_binary data deps of py_test (#15298)
   + 519d2daacfff3de6ffabfc5827621fa835e1c815:
     SolibSymlinkAction does not need exec platform or properties
   + 6e54699884cfad49d4e8f6dd59a4050bc95c4edf:
     Let Starlark tests inherit env variables (#15217)
   + 9610ae889e6fd45280c5beb7fe8f5bef2d736878:
     Update PythonZipper action to use CommandLineItem.CapturingMapFn
   + 2f1ff6fa17c3c30b2533bffe81f40eab06b453b9:
     Make `coverage --combined_report=lcov` skip incompatible tests
   + 9fad5a3dc93cd436a5712c46e6c98d3995428ddb:
     Disable ReturnValueIgnored checks to unblock java_tools release
   + 0120118893261968bdf116ef215655c428428fa8:
     Bump the limit of Bazel install base size (#15585)
   + 668805aace9bf96f78595fc2a122027a3000ceac:
     Upgrade zlib to 1.2.12
   + 4d900ceea12919ad62012830a95e51f9ec1a48bb:
     [5.2] Remote: Fix a bug that outputs of actions tagged with
     no-remote are u... (#15453)
   + b703cb9b999e243d776b7620468e48f450c0ce3a:
     Add feature to produce serialized diagnostics files (#15600)
   + 2e8458b7810eab7829fc7d28af5c45b9af91ed7c:
     Release 5.2.0 (2022-06-07)
   + 536f8d97991d891fc7db333af1a5262497d85173:
     Fix fail message construction in cc_shared_library
   + 2d42925ae80c0fb007aa39f4e210122611897255:
     Define cc-compiler-darwin in Xcode toolchain
   + a1d7d1f69f82da1bdfa1cebd32356249127aea3b:
     Fix alwayslink in objc_import
   + d273cb62f43ef8169415cf60fc96e503ea2ad823:
     Unify URL/URLs parameter code across http_archive, http_file,
     http_jar
   + fea32be42928c84463aa1f335b5722a1f6b8c93a:
     Preserve --experimental_allow_unresolved_symlinks in exec cfg
   + e4bc370b226eb0cc536b55641640266345a214ec:
     Ck/cherry pick cc shared library (#15754)
   + dbdfa07e92f99497be9c14265611ad2920161483:
     Let Starlark executable rules specify their environment (#15766)
   + e2a6a2b130552db7521d3d4d854b9a651b1f4a3b:
     Fix string formatting when java_home path is missing.
   + d54a288e6c79c740b9c93dfc31ee345d6a5332af:
     Optionally enable LLVM profile continuous mode
   + ad17b44cdc192277fafb0d0e204962b2b924dba8:
     Print remote execution message when the action times out (#15772)
   + 240e3d1e1dbc74c7753dead6421d7c1b5fc28d09:
     Add missing line to cherrypick
     e4bc370b226eb0cc536b55641640266345a214ec (#15784)
   + 804b4747152a59bc2965be2db85839b8b2764fc7:
     Replace strdupa with strdup
   + 62be9ea29295fab5289bd5d1a0f13dc7d55a8bc0:
     Bzlmod: Better canonical repo names for modules with overrides
     (#15793)
   + d4663a1c950d618c5b15a3e00fb733987cbf45cc:
     Add repo env test (#15768)
   + 594962cb283dcd71b736e0450453903911a8c85a:
     Add is_root struct field to bazel_module (#15815)
   + 3dd2b932d42fe86112899550d21452409cb3c4b0:
     Fix null pointer crash with `bazel coverage` on only
     incompatible tests
   + 4175018b47800db28c390d39fefbd266b5d674bd:
     Add util for finding credential helper to use
   + 3ea9eb2e363860c9305a987fa22a059afd35598d:
     Merge ManifestMergerAction-related commits into release-5.3.0
     (#15824)
   + 64571a428ffe2bf09f1a5eea13e770a7d0381620:
     Ck/cherrypick 15669 (#15788)
   + 1404651cafe5c26c5dae469e9126de53c2f4f024:
     Create output directories for remote execution (#15818)
   + ae523f82d39daf01cf31e40733de0c6345f0935c:
     Use tree artifacts in bootclasspath rule
   + 37f181cb6ed0237f43d81159eb81b19d3b5f8e36:
     [credentialhelper] Add types to communicate with the subprocess
   + 06ca634e10f17023022ab591a55aabdd9fb57b12:
     Add a flag to force Bazel to download certain artifacts when
     using --remote_download_minimal (#15870)
   + d35f923b098e4dc9c90b1ab66b413c216bdee638:
     RemoteExecutionService: fix outputs not being uploaded
   + 78af34f9f25b0c8fbf597a794a5162f0014629c5:
     Cherry-pick proto_lang_toolchain Starlarkfication and
     proto_common module (#15854)
   + afb434da9da79b53da1ea4c7bcc00571dbea6d3f:
     Fix behavior of `print()` in module extensions
   + 6714c30507edc70ec84f8c97d47cffc497356c0b:
     [credentialhelper] Implement invoking credential helper as
     subprocess
   + 0f05904171d187e6abacb431b3d7494423b027ab:
     Add register_{execution_platforms,toolchains} directives to
     MODULE.bazel files (#15852)
   + 33516e27dc6ee6ab5c3b9dee739a267b08d26b6c:
     [remote] Improve .netrc test in RemoteModuleTest
   + aa2a1f3afe2f10baab5befcafb39df14cbffc743:
     Fix ZipDecompressor windows 0x80 (file attribute normal)
   + 30f16e53cb36a5d506665be7553e785d52772e2d:
     Replace uses of `cfg = "host"` with `cfg = "exec"` (#15922)
   + 2a8d0ad7103511a94382aef41821a315bf8144b7:
     target pattern file: allow comments
   + 6f732052654ec37192450c795bb28dd0aad559cd:
     Add factory for creating paths relative to well-known roots
     (#15931)
   + 32cc8e638b91816f427b74266f6a8da6fb605419:
     Update CODEOWNERS (#15910)
   + 63bc14b095f1ea4043024e7fe1f9c476968897c5:
     Implement native analysis_test call. (#15940)
   + 4df77f771e5cfdf4b614afd8934d00c2b2ff31d1:
     Increase osx_cc_configure timeouts
   + cdf01a39ab9def4d46f41595ac1ac9206a96d6f8:
     Allow string_list flags to be set via repeated flag uses
   + 05e758d4bc18fc9d9e189526381a06e4399056a2:
     [credentialhelper] Add parser for flag syntax (#15929)
   + e4ee34416ef18094496ab54446e70cb62cd509e6:
     Docs should mention the new no-remote-cache-upload tag (#15965)
   + 96d23d30cc80912b82a8fbab31c902e9db74b6ab:
     Add netrc support to --bes_backend (#15970)
   + c5bc34e5f1dd92703dd8f15f9f0409c49b778837:
     Add CommandLinePathFactory to CommandEnvironment (#15971)
   + 508f18576ab5327bd623db6b476511ac2089d0fa:
     Move newCredentialHelperProvider into GoogleAuthUtils (#15973)
   + 14c944a5386eccbcfbe8389afb6c518582b11270:
     Wire up credential helper to command-line flag(s) (#15976)
   + 04c373b708390341be4ceb8eb5b2f8561385cb11:
     Add `--output=files` mode to cquery (#15979)
   + edfe2a17e3434cce660757f59b14f2e9d6ab944e:
     Make cpp assembly file extensions case sensitive again
   + 4ae85387e69db73e507b4f18b36d3e2f799e5d34:
     Prevent aspects from executing on incompatible targets (#15984)
   + f440f8ec3f63e5d663e1f9d9614f05a39422102a:
     Remote: Fix performance regression in "upload missing inputs".
     (#15998)
   + 0109031a2818b217b78026055b972da5901656f5:
     Updated Codeowners file (#16032)
   + 6102d33bf0b72dc0fe9ada4c71113cbee3eb8187:
     Propagate the error message when a credential helper fails.
     (#16030)
   + a8dacc7832b04fe1756cd7adce72f2572f357eee:
     Migrate legacy desugar wrapper to new rlocation() (#16025)
   + 11368be4ac24108f18b1965162ad27f207c074f9:
     Correctly report errors thrown by CommandLinePathFactory#create.
   + 82452c7c372fb28485b0b5e0a98b471648f0dfd0:
     Fix an issue that
     `incompatible_remote_build_event_upload_respect_no_… (#16045)
   + e745468461f93839491a4f80d0c1883d9007f9c0:
     Fix rpath for binaries in external repositories (#16079)
   + 83041b145d3966eb353aacb22b7e33ad01d9a239:
     Refactor combined cache. (#16110)
   + c62496f7b76da473cb1102798373f552ba2f434d:
     C++: Add compound error linked statically but not exported
     (#16113)
   + 0f18786b09e9729d79c0f14f7843b4d8402b6115:
     Do not crash on URIs without a host component.
   + 9c0940df3c5962b2291e812600dd71731775d45b:
     Add profiler task for calling a credential helper.
   + 2ca1ab2c2c73d78021794f3099ee892cc73f515e:
     Make bazel_cc_code_coverage_test more robust against GCC version
     differences (#16254)
   + 1e25152906b668bbe56aa4c1773186af85335315:
     Fix local execution of external dynamically linked cc_* targets
     (#16253)
   + f6cccae5b6f9c0ad0e7d0bf7bd31ea1263449316:
     * add change to allow blaze info to skip Starlark build settings
     that start with --no prefix * add unit tests for both info and
     clean commands
   + 59b8b8f4dc098c31a372ad45adc2a48c5f1c4a9f:
     Release 5.3.1 (2022-09-19)
   + 77f0233420d141e36fbf86a62dff20285c7d8fdc:
     Update GrpcRemoteDownloader to only include relevant headers.
     (#16450)
   + 42ff95a1202cd18cc3348ed6a442de5eb95845bd:
     Avoid unnecessary iteration on action inputs.
   + d29034e43150f32bb02c2cff3774747e25e97de3:
     Update flag `--experimental_remote_download_regex` to accept
     multiple regular expressions. (#16478)
```

Incompatible changes:

  - Removing java_common.javac_jar Starlark call.
  - native.existing_rule now returns select values in a form that is
    accepted by rule instantiation. This is a breaking API change
    because there is some code that relies on the precise type
    returned, including brittle workarounds for this bug specifically
    and insufficiently flexible workarounds for other issues with the
    intersection of select and native.existing_rule.
  - flipped incompatible_use_toolchain_resolution_for_java_rules, see
    #7849
  - Query output=xml/proto/location for source files will now show
    the location of line 1 of the source file (as the new default)
    instead of its location in the BUILD file.
  - Specifying a target pattern underneath a directory specified by
    .bazelignore will now emit a warning, not an error.
  - Query `--order_output=auto` will now sort lexicographically.
    However, when `somepath` is used as a top level function (e.g.
    `query 'somepath(a, b)'`), it will continue to output in
    dependency order. If you do not want the lexicographical output
    ordering, specify another `--order_output` value (`no`, `deps` or
    `full`) based on what ordering you require.
  - In the build event stream,
    BuildMetrics.TargetMetrics.targets_loaded is no longer populated.
    Its value was always mostly meaningless.
    BuildMetrics.TargetMetrics.targets_configured and
    BuildMetrics.ActionSummary.actions_created now include configured
    aspect data.
  - //visibility:legacy_public has been removed.
  - Flip and remove incompatible_dont_collect_so_artifacts
    (https://github.com/bazelbuild/bazel/issues/13043).
  - Remove flag --experimental_no_product_name_out_symlink: it is
    always true.
  - The Starlark method generate_dsym in objc fragment has
    been deleted.  Please use the equivalent apple_generate_dsym in
    cpp
    fragment instead.
  - Native libraries in data attribute are not collected. See
    https://github.com/bazelbuild/bazel/issues/13550 for details
  - Enforce the `--profile` path to be absolute.
  - Enforce the --memory_profile path to be absolute.
  - JavaToolchainInfo.jvm_opt returns Depset instead of a list.
  - --apple_sdk has been deleted.  It is a no-op.
  - --bep_publish_used_heap_size_post_build is now a no-op and will
    be deleted in a future release. Use --memory_profile=/dev/null
    instead.
  - Flipped --incompatible_disallow_resource_jars (see
    https://github.com/bazelbuild/bazel/issues/13221).
  - Remove --bep_publish_used_heap_size_post_build
  - JSON trace profile: rename counter names.
  - Removed --action_graph from the dump command.
  - Remove `--{experimental_,}json_trace_compression` option.
  - Remove `--experimental_profile_cpu_usage`.
  - flipped --incompatible_java_common_parameters (see #12373)
  - GrpcRemoteDownloader only includes relevant headers instead of
    sending all credentials.
    
    Closes #16439.

New features:

  - Args.add_all and Args.add_joined can now accept closures in
    map_each if explicitly enabled via allow_closure.
  - Add `--bes_header` flag to pass extra headers to the BES server.

Important changes:

  - Flag --incompatible_objc_compile_info_migration is removed.  See
    #10854.
  - Flag --incompatible_objc_compile_info_migration is removed.  See
    #10854.
  - Flag --incompatible_objc_compile_info_migration is removed.  See
    #10854.
  - none
    PAIR=cmita
  - The --incompatible_load_python_rules_from_bzl flag is now a no-op.
  - Filter all (instead of just C++) source files for coverage output
    according to --instrumentation_filter and
    --instrument_test_targets.
  - The `--incompatible_disable_native_apple_binary_rule` flag has
    been added which disables the native `apple_binary` rule. Users
    who need to use `apple_binary` directly (if they cannot use one
    of the more specific Apple rules) should load it from
    https://github.com/bazelbuild/rules_apple.
  - The Android rules' --use_singlejar_apkbuilder is now a no-op.
    SingleJar will always be used to build APKs.
  - dict.setdefault(key, ...) now fails if dict is frozen, even if it
    already contains key. This is an incompatible API change.
  - Flag --incompatible_objc_provider_remove_compile_info is removed.
     See #11359.
  - Starlark now permits def statements to be nested (closures).
  - native.existing_rule now returns select values in a form that is
    accepted by rule instantiation. This is a breaking API change,
    though the fallout is expected to be small.
  - Starlark now supports lambda (anonymous function) expressions.
  - The "test" and "coverage" commands no longer return 3 when a
    test action fails because of a system error. Instead, the exit
    code
    reflects the type of system error.
  - The undocumented ctx.expand feature no longer exists.
  - Make --legacy_dynamic_scheduler a no-op flag.
  - Multiplex persistent workers can now use the JSON protocol.
  - native.existing_rule now returns a mutable list, not a tuple, for
    a list-valued attributes. This is an incompatible API change.
  - Roll back change to have native.existing_rules use list instead
    of tuple.
  - BEP includes test suite expansions.
  - config_setting now honors `visibility` attribute (and defaults to
    `//visibility:public`)
  - Change the MultiArchSplitTransitionProvider to be based on
    platform type + CPU instead of fixed "ios_" + cpu.
  - enforce config_setting visibility. See
    https://github.com/bazelbuild/bazel/issues/12932 for details.
  - add a flag to build v4 signature file
  - Added _direct_source_jars output group to Java related targets.
    END_PUBLIC
  - pkg_deb is no longer part of @bazel_tools//build_defs/pkg:pkg.bzl.
    Use https://github.com/bazelbuild/rules_pkg/tree/main/pkg instead
  - Allowing the lipo operations to be conditional in the
    linkMultiArchBinary API for Apple binaries. Single architecture
    slices are now returned through AppleBinaryOutput and the
    Starlark API.
  - Release restriction for "-" in the package name for Python
    sources. Now `py_binary` and `py_test` targets can have main
    source file with "-" in the path.
  - Users consuming BEP may assume that a `named_set_of_files` event
    will
    appear before any event referencing that `named_set` by ID. This
    allows consumers
    to process the files for such events (eg. `TargetCompleted`)
    immediately.
  - BEP includes all files from successful actions in requested
    output groups.
    Previously, an output group's files were excluded if any file in
    the output group
    was not produced due to a failing action. Users can expect BEP
    output to be larger
    for failed builds.
  - In BEP, TargetComplete.output_group has a new field `incomplete`
    indicating that the file_sets field is missing one or more
    declared artifacts
    whose generating actions failed.
  - The flag `--toolchain_resolution_debug` now takes a regex
    argument, which is used to check which toolchain types should
    have debug info printed. You may use `.*` as an argument to keep
    the current behavior of debugging every toolchain type.
  - Add runfiles.merge_all() for merging a sequence of runfiles
    objects.
  - runfiles.merge() and merge_all() now respect
    --nested_set_depth_limit.
    If you hit the depth limit because you were calling merge() in a
    loop, use
    merge_all() on a sequence of runfiles objects instead.
  - Bazel will no longer create a bazel-out symlink if
    --symlink_prefix is specified: the directory pointed to via the
    bazel-out symlink is accessible via ${symlink_prefix}-out. If
    this causes problems for you, set
    --experimental_no_product_name_out_symlink=false in your builds
    and file an issue.
  - Updates worker protocol with cancellation fields, and adds
    experimental_worker_cancellation flag to control cancellation.
  - Simplify build failure output by always using `NNN arguments`.
  - trim_test_configuration now defaults to on
  - Mark genrule.srcs as a source attribute for coverage.
  - When using --allow_analysis_failures (for example, via
    bazel-skylib's
    analysistest with `expect_failure = True`), analysis-time
    failures in aspect
    implementation functions will now be propagated and saved in
    AnalysisFailureInfo, just like analysis-time failures in rules.
  - cquery --noimplicit_deps now correctly filters out resolved
    cc_toolchains
  - Sign apks deterministically.
  - Make gcov optional in cc_toolchain tools.
  - If --experimental_prefer_mutual_xcode is passed, Bazel will
    choose the local default (instead of the newest mutually
    available version) if it's available both locally and remotely.
  - Remove java_lite_proto_library.strict_deps attribute.
  - Generate proguard configurations deterministically.
  - Adds a new flag, `--incompatible_enable_cc_test_feature` which
    switches from the use of build variables to the feature of the
    same name.
  - Dropped fragile xz support from built in pkg_tar. Users requiring
    xz
    compression should switch to bazlebuild/rules_pkg.
  - If all strategies of one branch (the local or remote execution
    branch) of the `dynamic` strategy fail to even accept (via the
    response they give from `canExec`) the action, `dynamic` will now
    try to see if the other branch can accept it. (Trying to run it
    and it failing will still cause a failure if it was the first
    result, this is about strategies claiming they can't even try the
    action)
  - Add `disable_annotation_processing` option to
    `java_common.compile`, which disables any annotation processors
    passed to `plugins` or in `exported_plugins` of `deps`
  - Remove obsolete --incompatible_prohibit_aapt1
  - The minimum Android build tools version for the Android rules is
    now 30.0.0
  - Adds --experimental_reuse_sandbox_directories flag to reuse
    already-created non-worker sandboxes with cleanup.
  - --experimental_force_gc_after_build is deprecated and will be
    removed soon. Use --bep_publish_used_heap_size_post_build instead
  - Forward coverage-instrumented files from non-tool dependencies by
    default.
  - The used_heap_size_post_build field in BEP is populated when the
    --memory_profile flag is set
  - --run_validations defaults to true.
  - Consider label_keyed_string_dict attributes when gathering
    instrumented files for coverage.
  - Remove flag
    --experimental_forward_instrumented_files_info_by_default, now
    that this behavior is the default.
  - When using MemoryProfiler with multiple GCs via the
    --memory_profile_stable_heap_parameters flag, we do a more
    precise calculation of heap used at the end of the build. This
    will generally result in lower values.
  - --bep_publish_used_heap_size_post_build is deprecated. Use
    --memory_profile=/dev/null instead.
  - Disable --all_incompatible_changes flag.
  - The --all_incompatible_changes flag is now a no-op
  - The `--toolchain_resolution_debug` flag now accepts regexes
    matching targets, as well as toolchain types, when choosing what
    debug messages to print.
  - Adds --experimental_existing_rules_immutable_view flag to make the
    native.existing_rule and native.existing_rules functions more
    efficient by
    returning immutable, lightweight dict-like view objects instead
    of mutable
    dicts.
  - Add support to length-delimited protos as undeclared output
    annotations []
  - The deprecated "relative_to_caller_repository" parameter has been
    removed from the Label constructor.
  - The toolchain transition is now enabled for all toolchains.
  - incompatible_disable_depset_items is flipped
  - The --experimental_existing_rules_immutable_view flag has been
    renamed to  --incompatible_existing_rules_immutable_view
  - Bazel no longer supports Java 8. From this version on, the
    minimum required JDK is OpenJDK 11.
  - alias() can now select() directly on constraint_value()
    
    Fixes https://github.com/bazelbuild/bazel/issues/13047.
    
    Closes #14310.
  - Fixed an issue where Bazel could erroneously report a test passes
    in coverage mode without actually running the test.
  - Make protocOpts() publicly accessible.
  - Add coverage configuration fragment, used to expose
    output_generator label.
  - Bazel now no longer includes system headers on macOS in coverage
    reports (#14969).
    
    Closes #14971.
  - Starlark test rules can use the new inherited_environment
    parameter of testing.TestEnvironment to specify environment
    variables
    whose values should be inherited from the shell environment.
    
    Closes #14849.
  - none
    RELNOTES:none
  - Enable merging permissions during Android manifest merging with
    the --merge_android_manifest_permissions flag.
  - Added new register_{execution_platforms,toolchains} directives to
    the MODULE.bazel file, to replace the
    {execution_platforms,toolchains}_to_register attributes on the
    module() directive.
  - Add support for fetching RPC credentials from credential helper.
    
    Progress on https://github.com/bazelbuild/bazel/issues/15856
    
    Closes #15947.
  - `cquery`'s new output mode
    [`--output=files`](https://bazel.build/docs/cquery#files-output)
    lists the output files of the targets matching the query. It
    takes the current value of `--output_groups` into account.
    
    Closes #15552.
  - Fix for desugaring failure on Bazel+Android+Windows build
    scenario.

This release contains contributions from many people at Google, as well as Adam Liddell, Alex Eagle, Alex Eagle, amberdixon, Andreas Fuchs, Andrew Katson, Anthony Pratti, Artem V. Navrotskiy, Austin Schuh, Benedek Thaler, Benjamin Lee, Benjamin Peterson, Benjamin Peterson, Ben Lee, Brandon Jacklyn, Brentley Jones, bromano, Cameron Mulhern, Chenchu Kolli, Christopher Peterson Sauer, Christopher Sauer, Cristian Hancila, Dan Bamikiya, Dan Fleming, Daniel McCarney, Daniel Wagner-Hall, Danny Wolf, Dave MacLachlan, Dave Nicponski, David Cummings, David, David Ostrovsky, Delwin9999, Denys Kurylenko, Dmitry Ivankov, dorranh, ecngtng, Ed Schouten, Eitan Adler, Elliotte Rusty Harold, Emil Kattainen, erenon, Eric Cousineau, Ethan Steinberg, Fabian Meumertzheim, Fabian Meumertzheim, FaBrand, Felix Ehrenpfort, Finn Ball, frazze-jobb, Fredrik Medley, Garrett Holmstrom, Gautam Korlam, George Gensure, goodspark, Gowroji Sunil, Greg Estren, Grzegorz Lukasik, Grzegorz Lukasik, hvadehra, Ikko Ashimine, Jesse Chan, Joe Lencioni, Johannes Abt, John Laxson, Jonathan Schear, Juh-Roch, Justus Tumacder, Keith Smiley, kekxv, Kevin Hogeland, kshyanashree, Lauri Peltonen, Liu Liu, Lszl Csomor, m, Marc Zych, Mark Karpov, Masoud Koleini, Mathieu Olivari, Matt Mackay, Mauricio Galindo, Max Liu, Menny Even Danan, menny, Michael Chinen, Nathaniel Brough, Nick Korostelev, Niek Peeters, Nikolay Shelukhin, Niyas Sait, Noa Resare, odisseus, Oleh Stolyar, Olek Wojnar, Oliver Eikemeier, Olle Lundberg, Omar Zuniga, oquenchil, Paul Gschwendtner, Peter Kasting, Peter Mounce, Philipp Schrader, Pras Velagapudi, Qais Patankar, Rabi Shanker Guha, Rai, ron-stripe, Ryan Beasley, Ryan Beasley, samhowes, Samuel Giddins, Sebastian Olsson, Sergey Tyurin, Steve Siano, steve-the-bayesian, Stiopa Koltsov, susinmotion, tatiana, Tetsuo Kiso, Thaler Benedek, Thi Doan, Thi Doãn, Thi Don, Thomas Carmet, ThomasCJY, Timothe Peignier, Timothy Klim, Tobi, Torgil Svensson, Trustin Lee, Ulf Adams, Ulrik Falklof, Uri Baghin, Vaidas Pilkauskas, Vertexwahn, wisechengyi, Wren Turkal, Xavier Bonaventura, Xùdōng Yáng, Yannic Bonenberger, Yannic Bonenberger, Yannic, Yannic, Yury Evtikhov, Yuval Kaplan, Yuval K, Yuval, Zhongpeng Lin, [zqzzq].

## Release 4.2.3 (2022-10-18)

```
Baseline: 37a429ad12b4c9e6a62dbae4881a1ff03b81ab40

Cherry picks:

   + a689d673abadf80f1efaf8ddaeee92d56fc2847b:
     Use getRunfilesPath for run_under executable path generation.
     getRootRelativePath doesn't return a valid runfiles path for
     external source files anymore after the recent external source
     root change. Also, it won't work for external labels either once
     the --nolegacy_external_runfiles becomes default. This fixes
     issue #12545.
   + d90ec67fdab9710f649a3c1d374fb6b938b9271a:
     Fix NPE when coveragerunner is not set on the toolchain.
   + 8555789dd239a5ac229c1d9cee80b2a9f30b3bf7:
     Fix the classic query package-loading cutoff optimization with
     external workspaces.
   + 3f2e8c8220a1cf07fda0a08fb21734df79364248:
     Update turbine
   + 0577fa5623732e9d182d273597b9be6c66574d05:
     Update turbine
   + 268bedd5b8f4fc0aa4158248a8cf2d0d8ad79e52:
     Update turbine
   + 613c9fe7d6ad265d80be569485e599394fff310e:
     Update turbine
   + f28f6978b118868a7faec5ad3818ea0582ffb8f5:
     Update turbine
   + 69b43621a16d7ede62a3b876772e8b297d4ea09e:
     Update turbine
   + 4d4ab50501d5f493cea35885bd89b2a56b0027f7:
     Revert "Update turbine"
   + 89b9a048eec8f108795bebdada5b6c9d33dacff2:
     Update turbine
   + d31f6dfc85b73750139d287acdcd29a596e1884a:
     Update turbine version
   + 57672aca01b3be895382c952b550c9f8edf6c9f2:
     Update turbine
   + bef4bbbb47d47befe3711d06f358782ee12554f9:
     Update turbine
   + d113d7454127bba78aa618dac81e5d164920b662:
     Update turbine
   + 1489f0f4cae3e9247a70e4003ab76bef45c5b986:
     Support Scala3 .tasty files
   + 0d2d95cd7e34b4061c8e5fdfd21ba0ab8818c685:
     Update to java_tools javac11 release 10.5 (#12647)
   + a9419f38d5f29af31a6c8ebda09a6e0303a6ba54:
     Fix common prefix for instrumentation filter
   + 84fadcf81f81b2d7343ca4151a5639be7f2263ee:
     Fix builds for filegroup targets with incompatible dependencies
   + e43825d0bef359f645e1cabf2164fd2db6ee4a35:
     Revert "Remove
     --incompatible_blacklisted_protos_requires_proto_info"
   + 082d58de852ebaa640bcf13cf419cbb94eec2b26:
     Transform roots along with paths during output deletion.
   + e8835c1c221d76a2d5532d18083eaa04401619b3:
     AttributeContainer.Large now handles more than 127 attributes.
   + e1e87349335ac59f9b3df47cee8b999faeaa6d11:
     Add an env attribute to all test and binary rule classes
   + a87d7ed2411d5382bac58a20b79e09c464ad13b9:
     Take no action to prefetch empty artifacts.
   + 3e969ff24a6a0e03139b9f288c88451a7dfa97cd:
     Fix a couple of bugs with Incompatible Target Skipping
   + e6670825b1e183f81f5c864aafd425d512fa9ff5:
     Pass --host_action_env to host options hostActionEnvironment
     attribute
   + 07400c0392e7be163f8a3396fa5cf89ce6705412:
     Add --{no,}autodetect_server_javabase.
   + c83366064621d5a265eba14d93a03deff58fe6d8:
     Only treat "env" and "env_inherit" attrs specially for native
     rules
   + 6a60b30cd0f22d0ab84b2ddd658d5ccb899a8a76:
     Fix coverage support when using default_java_toolchain. (#12801)
   + 4158a6f512e52516437e00f8d9609a91be7fc195:
     Revert JacocoCoverage target to remote_java_tools_java_import
     and add a new target for remore_java_tools_filegroup. (#12813)
   + f6d30cf5ef9a8a39fea7072317f89a872387b790:
     Add windows_msvc back to conditions in bazel_tools.
   + 6b33bdb1e22514304c0e35ce8e067f2175685245:
     Release 4.0.0 (2021-01-21)
   + 8811e27353c2c10980faf7e4c5e44b431d2d4f1c:
     Fix error message from getPrerequisites to not print internal
     details.
   + 27e15ad11410eb1014f5247fd0eeb31a46733c07:
     Clean up ConfiguredTargetValueAccessor and
     ConfiguredTargetAccessor
   + e87feb8ac9573cef993824f82370d0389570521d:
     Move getConfigConditions into ConfiguredTarget.
   + 34d98234324da83e93ba0d5ef5702880d5ac7c5c:
     Change ConfiguredTargetQuery to use KeyedConfiguredTarget as a
     value.
   + 079bb7d69931705bb2b092c9017090e224ef3043:
     Clean up old dependencies that are unused since
     https://github.com/bazelbuild/bazel/commit/34d98234324da83e93ba0d
     5ef5702880d5ac7c5c.
   + e03cb63e059420847d6578d7cbfe93f05615c95e:
     Update bazelbuild/platforms to a current release. - Roll forward
     https://github.com/bazelbuild/bazel/commit/0a4533420a3de467fd211d
     7f925cf88e0cd5b76a  with kythe fix.
   + 2eb1bf53d5fef13b89ee440af4f83003d1d0b50a:
     Update docs and tests to use the @platforms//:incompatible
     constraint
   + c71697cf33b0fbbb42fc2910bac83960edc7e855:
     Clarify test_suite behaviour in the Platforms docs
   + dfb70ea4cae2ffffb76e9741d86c96505a6d05ad:
     Enable toolchain resolution for filegroup targets.
   + 24d086446f74606819dc53c3a436caa056ff05b7:
     PlatformProviderUtils should ignore targets that don't have the
     needed
   + ba60c0b3f9bbd00975c984244839b155e84b4c5d:
     ijar: fix manifest sections handling
   + 58bb42ad7ca263a75c6eeef51482f805726663a5:
     Revert "Switch to -fdebug-compilation-dir"
   + 3f2e8c8220a1cf07fda0a08fb21734df79364248:
     Update turbine
   + 0577fa5623732e9d182d273597b9be6c66574d05:
     Update turbine
   + 268bedd5b8f4fc0aa4158248a8cf2d0d8ad79e52:
     Update turbine
   + 613c9fe7d6ad265d80be569485e599394fff310e:
     Update turbine
   + f28f6978b118868a7faec5ad3818ea0582ffb8f5:
     Update turbine
   + 69b43621a16d7ede62a3b876772e8b297d4ea09e:
     Update turbine
   + 4d4ab50501d5f493cea35885bd89b2a56b0027f7:
     Revert "Update turbine"
   + 89b9a048eec8f108795bebdada5b6c9d33dacff2:
     Update turbine
   + d31f6dfc85b73750139d287acdcd29a596e1884a:
     Update turbine version
   + 57672aca01b3be895382c952b550c9f8edf6c9f2:
     Update turbine
   + bef4bbbb47d47befe3711d06f358782ee12554f9:
     Update turbine
   + d113d7454127bba78aa618dac81e5d164920b662:
     Update turbine
   + ad241fbebd90a9f0ad65ccd0658838f57030db68:
     Allow cquery to filter out incompatible targets
   + 1782f0ae751569607ef88930c822ac460a1f8bb3:
     Patch grpc to fix cares selecting the wrong source when building
     for darwin_arm64 cpu.
   + 8f7bc2f67fafcaa8d25cfc77eaaedbf8eed2984a:
     [1/3] Bump grpc to 1.33.1 to fix corruption when downloading CAS
     blobs
   + 848a51747a460ab4c5185e4c61ab522a9981cbea:
     [2/3] Bump grpc to 1.33.1 to fix corruption when downloading CAS
     blobs
   + 9b30172547f2093acb56aedf159a77d5dceffda2:
     [3/3] Bump grpc to 1.33.1 to fix corruption when downloading CAS
     blobs
   + 1e258d2a7a5221613047e5cee0aaec5b56045d2b:
     Allow exec groups to inherit from the rule or other exec groups.
   + d0676693310215407224c1b8e8aea9e3eddc183d:
     Support execution constraints per exec group
   + f1e0d346c8235c855e61afc2adb870e4b895e002:
     Clean up RuleContext to use a Table instead of a Map of Maps.
   + 8186fbb47ab964a9affa9a0fc6315fcdbde2b5aa:
     Documentation for #13110
   + 321fe3b6b4e892821ee7dbf2d17dd8ae6a541913:
     Prevent --repo_env from triggering unnecessary fetches
   + 3ebf658cba43bbab1efc36518f0795a7d65e2d46:
     Prevent a crash when using --repo_env=VAR without a value
   + 913a985a5c2fc3842b12c6e5f29af0fa1bccfd6a:
     Report digest of failed uploads
   + 5122617b8a22fee7acd86c9c48f2c2737709ca3f:
     Status error presentation with details
   + 9a70805db543e2fb910e1c55ef3b3567362adf30:
     Fix double shutdown of BuildEventArtifactUploader when BES+File
     output enabled.
   + 325eb956c92530bdfda54a36a186cae4245a4f7b:
     Add rxjava3 to third_party
   + ceaac966a7b977461b69ce9501df6a467f4a93b2:
     remote: set executable bit of an input file based on its real
     value
   + 5b786da75837c5e29714e1d708c3cdf9a67ed32d:
     Remote: correctly implement equals and hashCode.
   + 48648503729d53fdee1322fde2c8e6c05e99cff9:
     Fixed an error that bazel binary is not executable when testing
     with remote execution.
   + bc54c648aa1f99509c7c36d5e6b570d066689209:
     Remote: Use parameters instead of thread-local storage to
     provide tracing metadata.
   + 92955e617b5c41713a5163dc0437c2a024b31815:
     Remote: Use parameters instead of thread-local storage to
     provide tracing metadata. (Part 2)
   + 75bd1ff8ab56d241916bde36291301fa026b2bab:
     Remote: Use parameters instead of thread-local storage to
     provide tracing metadata. (Part 3)
   + 37ee252f3744abc4511f55b5089cc52abd3ba09d:
     Remote: Use parameters instead of thread-local storage to
     provide tracing metadata. (Part 4)
   + 71e35b165f924e2649a078fcf6007645d58039af:
     Remote: Use parameters instead of thread-local storage to
     provide tracing metadata. (Part 5)
   + 32fc451600b6e94a015263eb1c8a63e974f6f4cc:
     Write/QueryWriteStatus logging refinement/addition
   + 97963c5bb24ac79eb3646dd61bfcf2f8a648af54:
     Remote: gRPC load balancing. (Part 1)
   + e2b9a42a61596b0d24f0cadd6b7157b7f1efb221:
     Remote: gRPC load balancing. (Part 2)
   + 6667ad7dd77f8d97952133052c17e7779c1430ec:
     Remote: gRPC load balancing. (Part 3)
   + 7c081eb020186bfb16d4ef1c3832a8e946e99da1:
     Remote: gRPC load balancing. (Part 4)
   + 17afbe4e224b359fee6415a5bd71bbedaa7843eb:
     Implement getMessage for BulkTransferException
   + a6293b3df521aea9075b2ebbcdb675a7d02d3c32:
     Remote: gRPC load balancing. (Part 5)
   + 7a62c2d4e27e398f440910c81eacc384f38ca8be:
     Remote: Add interoperability between Rx and ListenableFuture.
   + 1fcb18a0b455bfcb8e9940778f37d8c82c5ed5a0:
     Update to latest remote-execution proto
   + dad96301d12aa77eb67399e08265a5f30f5ffd6a:
     Set Platform on Action not just Command
   + 6c5a3ee0dcbb4b804f4aa85c038a378fb70eb1f9:
     Remote: Add AsyncTaskCache which is used to deduplicate task
     executions and cache the results.
   + 9d0c7325ac810febe565a62fdd875ae0c240b274:
     Remote: Use AsyncTaskCache inside RemoteActionInputFetcher.
   + f54fe07209acc25340df8d2e02993b1add2deafa:
     Add --experimental_repository_disable_download to allow users
     disable download for external repos
   + b243584a479eb4481a9bf4f69acc899610a3b630:
     Report errors parsing rewriter config file
   + 63bc1c7d0853dc187e4b96a490d733fb29f79664:
     Downloader rewriter config has all_blocked_message
   + 495ac923f398443be45c20ab29d183fe47e08911:
     Allow UrlRewriter to change protocol, i.e. https->http, and
     http->https
   + 8dbbde0037264c1db4b229a09f98a61ab4ca06b0:
     Allow overriding the hostname and instance name in bytestream://
     URIs
   + 0881c80d29acecdfbb58c49156f805e8c50db117:
     Don't set requestId on non-multiplex requests.
   + e3b7e17b05f13ff183a4d7efec8ec797f3f5eaa3:
     When generating a symlink in _virtual_includes, add the original
     header to the 'allowed to use' set too
   + f8f66f36ad299a0ea019c94100d5a8e2018f5ab5:
     Make SimpleLogHandler not swallow interrupts.
   + f8606e5e76579442a1c6563e718ea54c673f1a04:
     linux-sandbox: don't assume -lrt, -D__STDC_FORMAT_MACROS
   + dac0d40d0eb903f5cb70341398d1a333c19adf3a:
     Improve "Common Attributes" section
   + a607d9dc70ac67f1aa2c32ca954177f9c77860be:
     Never create more than one process per WorkerMultiplexer.
   + 80c03ef14a1842d1e3475b1adf98adeb05df33f9:
     Move sending requests and reading responses for multiplex
     workers into separate subthreads.
   + 003cfcde3fd3901c1279ba1db3db3a14536248b4:
     Allow use of JSON protocol in multiplex workers.
   + 308bce36cba46095fe41866e703710035ddddada:
     Actively kill off still-active workers when stopping work on
     interrupt.
   + 8959dff512fe4505af786bcf2ef981ec7082a913:
     Add sanitizer support to Apple platforms
   + 32f16e9360f3e1856db1775eb5014b930da2a303:
     Fix a Google-internal broken link.
   + c9e2be52a067dd9abf5efa4f5f55bb5b98cf5d3b:
     Add SHA-1 to subresource integrity format for download()
     checksums
   + 3b3e6424c6fbd51d4c4ebb6aa25f1d1f4720221c:
     Remove fallback strategy support for workers, add flag for it in
     sandbox.
   + 3457f2ae11e4543de0a5e6e8e37c3aff067891fd:
     Update to java_tools javac11 10.6 (#13245)
   + 4928295b236ec8f590a7e9d863502bc2f50a77d9:
     Allow .S files in C++ Starlark cc_common.compile.
   + 1b18d65227c127fe946d3fcde4586158bc7e5fcb:
     Automatic code cleanup.
   + b5d6c38535c7f6f1eab3fd4c8d3d2da91d0b0f8a:
     Change short output of worker type to have the same logic as the
     worker creation for sandboxing vs. multiplex.
   + e7a0a71f50b69df5d38a8a85fefd36d211e12e8d:
     More properly destroy workers on interrupt.
   + 7056711eb11b672133274eb29fc93b01dcf088d5:
     Make WorkRequestHandler do a GC after some amount of CPU time
     has been used on requests. For Bazel and Blaze, defaults to 10s
     based on benchmarking.
   + 596653d3cf76e7b208da343e1fde5fe20273a5ff:
     Allow tree artifacts to be source or header inputs to
     cc_common.compile()
   + 055c93d11ab20cc4479539b24bbdfa5cab78a342:
     Switch to path autocompletion after -- for bazel run commands.
   + 807f2a1929e23b60b237c63fadb25af81de2e3c3:
     Fix Incompatible Target Skipping for test args
   + 9a5cd854e0613f91d52075973e2454b1e009e1ef:
     Fix order of build request id and command id
   + 706f5acd02363e48076dc97e37613fd968932d03:
     Fix bazel crash when passing config_setting to
     target_compatible_with
   + 61da1d2bf10eabba4c75de959b0374f302d89d70:
     Support multiple --bazelrc on command line
   + 5593358a58b66f06c4e421bb48856de94c3fd625:
     Update ConfiguredTargetFunction.computeUnloadedToolchainContexts
     to
   + 662cf54de7a103db30e04ebae2d2b919437c4846:
     Remote: Fix an issue that a failed action could lead to
     RuntimeException caused by InterruptedException thrown when
     acquiring gRPC connections.
     https://github.com/bazelbuild/bazel/issues/13239
   + a3a1763212f29932618b9b9b2f929976ae0e3b6e:
     Pass more `--add-exports=` flags
   + d2b942879471786e82f1c96eea8722bbe7919fc1:
     Remote: Fixed a bug that remote cache is missed due to
     executable bit is changed
   + 616dc264f02907d7b7887285d22307dfe6d097b6:
     Fix Bazel Coverage with C++ to work with Remote Execution
   + 5f40d12e741aa30d506eaa15673fb2ae76d29468:
     Fix external_path_test with newer Xcode versions.
   + b416193075642017e13c774422b49cb07fb65c23:
     Allow using embedded tools in sandboxed spawn runners.
   + eb762d4e7431637e607146b1c191485795047ef9:
     Fix racy write of temporary files while staging virtual inputs
     for the sandbox.
   + f31e86768579ad7ec57ba13f4c3c1348f5c2702e:
     Update platforms_test to not rely on filegroup not using
     toolchain
   + 13031e5b3bd7c8f29b96b2fee1b380160e0e27fc:
     Update SkyframeTests to not rely on filegroup not using toolchain
   + 11651824a9d0ffb9adb9611dcd39f4c95a59d750:
     Update ConfigurableAttributesTest to not rely on filegroup not
     using …
   + 4b68532e7ea5eb80c926b7b8e2ec2be300004628:
     Make WorkerExecRoot not be a subclass of SandboxedSpawn.
   + 31db460a45767de0bcd664a6efbe9d163b85b802:
     Make WorkerExecRoot not be re-created on each createFileSystem()
     call. Preparation for holding a map of existing links, but also
     just nicer.
   + a2cc0460dc84ad2dc88019af2fe2a65ce80c61e5:
     Start the file existence check traversal from the execroot base
     instead of execroot so that external repo files at
     "<execroot>/../<path>" are correctly handled when the sibling
     repository layout is enabled.
   + b048282c7893231d3a7191b251804973917b07a4:
     Use readdir for cleanExisting in WorkerExecRoot.
   + 270f00dd01fa06cf3e813da5a406be3446de7377:
     Add native support for Apple Silicon
   + 8e56b9423e8ad2f7323fb90b19b73858def81e39:
     Explicitly state that embedding macOS OpenJDK is for x86_64
   + 09c621e4cf5b968f4c6cdf905ab142d5961f9ddc:
     Remote: Fix a race that AsyncTaskCache#Execution could be reused
     after disposed which results in
     CancellationException("disposed") propagated to downstream.
   + 0299cd7e17203a4ce0ea947b62a7c55f1afb8225:
     Remove wrapped_clang params files after use
   + 47edc57806056f3c8764241ed41b8acc72bd2ebf:
     Silence swiftmodule timestamp warnings
   + f6e1074b09ebefba185c0531e9cea26b9596c8a9:
     Remote: Use shutdownNow() instead of shutdown() in
     ChannelConnection#close() as a workaround to a gRPC bug.
   + 71be4ea9e3d20bf90129e34a6a2899fe8401be36:
     And mnemonic and label to remote metadata
   + 615e1b16a81b0defc15699ec8027d6ddd70366d1:
     Change `set -x` in coverage to be set by var
   + fe4daea99c8cd163793eca84bfb12c8fc437616b:
     Bump minimal JDK install base maximum size from 290 to 295 MB.
   + 4840a68cd273a429e46d4114a3973fd11d0e3583:
     Remote: Check the return value of ActionOwner.getLabel() since
     it could be `null`.
   + 14abe4fd7c3967686a3536939fdc3882e691bca2:
     Allow `DiffAwareness` to share precomputed information about the
     workspace and propagate it to the `WorkspaceStatusAction`.
   + 082d98772690946ed29c157e60640c97a6e1195b:
     Implement available() method for Windows subprocesses.
   + c2bdd034014f66ce14529cc353cda18a32320f6c:
     Move --repo_env to common options
   + e09f2743738044095b9d784ea62df16b7f5750e6:
     Revert "Documentation for #13110"
   + a165baa250652fdc865ae0df39160be1f7f74c47:
     Revert "Clean up RuleContext to use a Table instead of a Map of
     Maps."
   + 51fb9e13a864f4f704ae378ea632433bae7ddc31:
     Revert "Support execution constraints per exec group"
   + cb6e5c24b82e0e20a243145fb6ea32b09e3d1de3:
     Revert "Allow exec groups to inherit from the rule or other exec
     groups."
   + 2ac6581aeaab33ba506fce96dfa6a75eaa819233:
     Release 4.1.0 (2021-05-21)
   + 7a0f36e3f0a21fed8857efbaa51ded2dbdeefab6:
     Change gceMachineType of highcpu platform from n1-highcpu-32 to
     e2-highcpu-32
   + 19491a91143f0c6132aca62c5ae40ab72e9dc0e2:
     Fix #10127: Remove Python 2 dependency from tools/android.
   + 80c59dea59d4dce39d4b5d21665c3d7313197358:
     fix main repo starlark options parsing - now flags passed on the
     command line as --@main_workspace//flag and --//flag will both
     parse to --//flag. Before this CL, the former maintained its
     workspace prefix and we would get different entries for these
     two formats.
   + 451b296c3aceb127ebb4a313b6e9608854fa68fa:
     Update threshold for long path shortening to be MAX_PATH - 4
   + 671e0489a5bd6d5abb4dcd9bcfc85134cee38385:
     Force source files to be readable before copying them from
     sandbox.
   + 6080c1e07f4229ea72eacd04faa9302e44955a84:
     Let workers finish lost races without delaying dynamic execution.
   + ee738dacb5d0089d3f57b15305057cb9ba675e74:
     Fix label_flag and label_setting to not have a dependency on the
     default
   + 74de0ba4e79341c77b8b85ff4485f92287b6854c:
     Java coverage: fix handling of external files
   + 48eee8b4b447a2ad11df28dd81a2ccb65562b5f5:
     [Bazel] Fix mobile-install for python2
   + 763dd0ce6e1644bf895231432f616427a11d385a:
     Add `stub_shebang` to `py_runtime`
   + b2231c56d78c6d37bcb6f11e1e50fe68ee336b4a:
     Move use of legacy sandbox -> local fallback to only be used
     after all strategies have been tried, and improve messages
     around it.
   + 6dc941e58dfc1d4a9714a76b921fbe11fce658ed:
     Remove restriction on generate_pdb_file to be only used in dbg
     and fastbuild mode
   + 5b95d9162b56b51c8e8f66258981ddf3c5d96765:
     Check the result of Future.cancel() when cancelling the other
     branch of dynamic execution.
   + aaae8ce2881c8c1a5d4ad64f20d6e71aa372cf2e:
     Update DEFAULT_MACOS_CPU to match host
   + 2f0927a4fd9342f4dcfd43475d3f1c90c523584f:
     Fix symlink creation on older Windows versions
   + fd9cffdcaf05551126e66f1cd62815eaa1af6bd9:
     Suppress interrupted status during pool closure
   + 33903d28bcea0005adf9b2a8cc4659c5e2999bbe:
     Fix Windows developer mode symlinks
   + 0cd1666721bdbe988dc361c085bb43cbd41a27f3:
     Respect Starlark options with values in `removeStarlarkOptions()`
   + 7920ffef472b25db3f4e564e5a3a28a4664c666e:
     cquery inherits from `test` not `build`
   + 1e258d2a7a5221613047e5cee0aaec5b56045d2b:
     Allow exec groups to inherit from the rule or other exec groups.
   + d0676693310215407224c1b8e8aea9e3eddc183d:
     Support execution constraints per exec group
   + f1e0d346c8235c855e61afc2adb870e4b895e002:
     Clean up RuleContext to use a Table instead of a Map of Maps.
   + 8186fbb47ab964a9affa9a0fc6315fcdbde2b5aa:
     Documentation for #13110
   + e376580ae4e9ad5bddc196bfb6ad3127e3ff561b:
     Split ExecGroup into a new target.
   + 0cbb8a863522d2f77ab6b67a01e39b19a9a81807:
     Create a new interface to allow Starlark objects to get a thread
     when getIndex is called.
   + d2e21cec31f09b27ef3589f47b0779f34077ca7e:
     Renamed ExecGroupCollection to clarify that it is only for
     Starlark usage.
   + b9519f92f8ce096107164ca5075feced0e989de7:
     Make StarlarkExecGroupContext use AutoValue.
   + 52b1b748b2368820bac2ca94323fb82c39c00e51:
     Use a dummy toolchain context for rules that don't have one.
   + 41877d0fefe3f021f3ff6d4ce398d0deb27157e6:
     Extract a separate StarlarkToolchainContext for starlark-only
     operations.
   + b120d4febc571f17e12501ad87fbff32ef94e9bb:
     Fix toolchains to support type lookup.
   + dc140d0b6119950dd4a7d71b125b15a78bacc8ce:
     Move DEFAULT_EXEC_GROUP_NAME from ToolchainCollection to
     ExecGroup.
   + 9b18d951a52819f1998ddfdc1739fa1b5bf0353d:
     Rename ToolchainCollection.getExecGroups to getExecGroupNames.
   + 10d4473bf476a587e3d9f9b2214581ec420c1919:
     BuildViewForTesting should directly call into
     ConfiguredTargetFunction.
   + 58a6fb1f8739e39125cc8c647f28cff2e79fe9aa:
     Move exec group tests out of platforms_test and into integration.
   + 7d5493d922761c3ce0037f0025912cc532c55ad7:
     Update creating exec groups that explicitly copy from defaults.
   + 8c6382a81237e72dbec24b3850df9481461e0015:
     Create a new ExecGroupCollection container to manage exec group
     inheritance and exec property parsing.
   + b4b0c321910bc968736ef48e8140528ea7d323cd:
     Fix unix toolchain for macos arm64 platform
   + f64f071f44394a33a1be40cb7642e2c881d1e9bb:
     Add `required_providers` attribute to Starlark defined aspects.
   + f2cbdcf67ac1990f05a8241ba8dae65795edac82:
     Don't ever claim /dev/null is an execpath.
   + ceec93c35ead1bd487e96a5fee46e8d080f88858:
     Don't ever claim /dev/null is an execpath.
   + 1f3f9f4c4b2eded90518aacd1b0b80c1b0dfd1c5:
     Use the parent directory of the exec root as the input root on
     RBE.
   + 4efeac9cb5f85325ed73f64e133a078c483cac01:
     Make the Merkle tree computation work in the wake of
     https://github.com/bazelbuild/bazel/commit/7149f578006a4ad0d51df6
     9830a6986749b34df5 .
   + b56a2aa709dcb681cfc3faa148a702015ec631d5:
     Remote: Use execRoot as input root and do NOT set working
     directory by default.
   + ae53991f2e207edacd1352ba94261e2473b79f14:
     Remote: Add RemoteExecutionService as a layer between spawn
     execution and remote execution.
   + 0c07c2e6571dd4806552213b2237ecb7a908afa4:
     Remote: Add remoteCacheable key to execution log
   + 5e617d83f3aab1fd36b07be4b58aba58604cc46e:
     Remote: Register "remote" strategy even if remote execution is
     not available.
   + 4ca8946a8e1c4c2fd48d8fb8ce38adb8b282fef0:
     Remote: Add --experimental_capture_corrupted_outputs flag.
   + 97d7b4c277814d73b50450b03f4bb160ce7e99b4:
     Remote: Report checking cache status before the action is
     scheduled to run remotely.
   + ba5b2a7c9448a3681a0d86d80670447e338a06dc:
     when writing to local disk cache, open files later in order to
     avoid "too many open files"
   + 3551898849a93306ad9b4dfdd7d4667913098efe:
     Propagate test envs to xml generation action
   + 9f8c678d7054548865f56f3464f778c751657074:
     Remote: Fix a bug that the XML generation is executed even if
     test.xml is generated when build with --remote_download_minimal.
   + af42653e6f6bd229142f4678bb256a8c397b4d8d:
     Automatic code cleanup.
   + 07a84ce31d9b09853c63c7e373418696dd285dc5:
     Remote: Another attempt to fix the CancellationException error
     in AsyncTaskCache caused by a race condition.
   + 0f812eb5e561cc5415d0c9931675e58dc37a5850:
     Remote: Display download progress when actions are downloading
     outputs from remote cache.
   + 18c82168433719b400a705a4a0222969a7a026ba:
     Remote: Do not upload empty output to remote cache.
   + 6a138a60e562beeef36003c4814a6b8ce9f253f6:
     Fix compiling errors
   + bcce6dd026e90336e80616a8c1004a79a2f8640c:
     Add the TEMP_FAILURE_RETRY macro to linux-sandbox-pid1.cc.
   + c8c0d94a49e1b865d95c6d245c2d152c7c7c9722:
     Export proguard specs from aar_import
   + 1a0285c3b64b121268ced3eb9ad9d5ba396b4905:
     Fix stripping of macOS loadable bundles
   + 0d3c231f5a08861d28e987703e9196890e6164bf:
     Roll forward config_setting visibility enforcement behind a flag.
   + bb7a01027242390da1c18fbf87c274cc34c11b79:
     Fix merge conflicts.
   + 8b8e77ea226aaa12e79580422bc5984e80ce048b:
     Remove redundant declaration.
   + 7c92cfcf9a88933c29334f6271ad3f086f7f36f4:
     Ignore empty virtual artifacts when spawn-logging inputs.
   + 4158b61211e099db780565d064a1c1a80c91bd2a:
     Use correct exit code on invalid aquery --output
   + b51b31dbe75a5bc73227fccb4484f3454df81b42:
     Remote: Fix a race when reporting action progresses.
   + 0e652737988e3c115e98e1552f6fada52bc2b9a2:
     Change MIN_BUILD_TOOLS_REVISION to 30.0.0
   + 6f9909c04b1e00faa510b38ccabac78821046cf9:
     Update Android remote tools to ensure Bazel uses the latest
     Android tooling that has been updated to support AndroidX
     databinding generation.
   + 31d88c629dff2c5f8e8a4baf8c89fd3349c9783e:
     Automated rollback of commit
     9a1d428e33bfae1ec5b68250d4732b72346b8b39.
   + 951a3023fbcdbe025e350590e6fa86097da3fe05:
     Increase allowed size of the install_base.
   + a7845f65befbeb65a28ec53e62458211a7bc3f8e:
     Increase allowed size for install base again.
   + affc27f9d18f9781437e91a3f36c73962a56f261:
     Bump version of java allocation instrumenter.
   + 7efabba19cf6400bf9e707f53b40a6dd7110fafb:
     Reference the correct version of the java allocation
     instrumenter.
   + 9055c67b17abf5fed487ae44d0e22f1c6ea1e50c:
     Support extracting aar files.
   + 861c3caa85e47da35a8a4f1512e57d43b9263c37:
     Revert "Remote: Fix a race when reporting action progresses."
   + 92ec798ddc1f38fb4868af08c1d818639283f501:
     Revert "Remote: Display download progress when actions are
     downloading outputs from remote cache."
   + ce091abb290d1d753f480cdee0e69748eb20db52:
     Revert "Fix compiling errors"
   + 1b19cd310418b850e8e0ca2086ffe50755c9ed7e:
     Revert "Remote: Fix a bug that the XML generation is executed
     even if test.xml is generated when build with
     --remote_download_minimal."
   + 988b56f5916e024d10695797a7f963b30fc998c7:
     Revert "Remote: Report checking cache status before the action
     is scheduled to run remotely."
   + 35c98d07b21785efae57a7c4230cc1e452f74fd2:
     Revert "Let workers finish lost races without delaying dynamic
     execution."
   + c4e22b9ace07f5d360c5327a38f9ae4ab24b7109:
     Migrate ExampleWorker to use WorkRequestHandler.
   + 230be161176bd6f1251077af7674f80d38ff1e25:
     Do not interleave readdir() calls with deletion of directory
     entries.
   + 3cc8ce6ba0934b1a4d9db184daf055c1207ef105:
     Propagate OOME if NewByteArray allocation failed
   + 19fc15ebbf6c63fcce90a038e91c5ec726852848:
     Create helper method for sandbox tests, transform existing tests
     into using it.
   + deb1006c0778692f7eaef4cbcf7eeb8112b55e91:
     Cleanup: Replace NULL with nullptr
   + f4b5e0233341977aaa76593ca032d9ac4eba7444:
     Let workers finish lost races without delaying dynamic execution.
   + 186decab01ee247c7453baf19dac778545ec4937:
     Interface and flag specification for worker cancellation.
   + 5894a8544d51c99f1356130b8b487bc93299fedd:
     Create BUILD file in worker tests directory instead of running
     tests from the parent directory.
   + e9e6978809b0214e336fee05047d5befe4f4e0c3:
     Server-side implementation of worker cancellation.
   + 5103662238f2df2038c7dff079e9c655e08ba654:
     Add builder for WorkRequestHandler.
   + 1a519bb66c3fa3e4ef3b9a9a556597920751fbcd:
     Makes singleplex requests be handled in separate threads in
     WorkRequestHandler.
   + 779d66019210f54e10a1343ee004df72a8dec812:
     Only allow worker async finishing when sandboxed.
   + a698bef6146a807fd82ee4402d89c23c83802e33:
     Support for cancellation in WorkRequestHandler.
   + 9dc95af4c7ef10979f21173260f5433006116096:
     Make workers restart on flags that affect their
     creation/behaviour.
   + 7e5cd529e9f8c9cb67900af36182f00ef7316654:
     Remote: Report checking cache status before the action is
     scheduled to run remotely.
   + 6e134a1b68418fba9992692901efa77a80c346f7:
     Remote: Fix a bug that the XML generation is executed even if
     test.xml is generated when build with --remote_download_minimal.
   + d4d071401acadb0d8977850a9439474e60fd7bb9:
     Fix compiling errors
   + 2579c9a18360955699d028426b45d381ff53783c:
     Eagerly initialize JNI copies of Java classes: doing lazy
     initialization on a per-method basis doesn't save anything and
     adds a tiny bit of overhead to every one of these calls.
   + 0f812eb5e561cc5415d0c9931675e58dc37a5850:
     Remote: Display download progress when actions are downloading
     outputs from remote cache.
   + 3835d9b21ad524d06873dfbf465ffd2dfb635ba8:
     Update the WorkRequestHandler to use callbacks of type:
     BiFunction<WorkRequest, PrintWriter, Integer>:  - Mark
     constructors that use BiFunction<List<String>, PrintWriter,
     Integer> callback as deprecated.  - Use a wrapper class for the
     BiFunction<WorkRequest, PrintWriter, Integer>. Suggesting this
     to avoid having two constructors that takes a BiFunction, as it
     creates a confusion between the deprecated and new constructor
     when given a lambda expressions.
   + 5e352afe2b35487ea2ced85ca79bd9f79858e648:
     Fix bug in WorkRequestHandler's handling of singleplex requests
     that would cause occasional hangs.
   + b51b31dbe75a5bc73227fccb4484f3454df81b42:
     Remote: Fix a race when reporting action progresses.
   + c9d823e42796962eed039b8122528c2a1541190f:
     Disable flaky test.
   + e6809c90ecc0ef5783faa39e63188fc33a79b80e:
     Revert "Check the result of Future.cancel() when cancelling the
     other branch of dynamic execution."
   + be4cbc7a67196414e3d3f323be8ab55fb5e530f7:
     Revert "Move use of legacy sandbox -> local fallback to only be
     used after all strategies have been tried, and improve messages
     around it."
   + b32349f50ff3d958613aef9275751ad9d50d344c:
     Set a fallback dynamic local strategy even when the
     dynamic_local_strategy flag is passed.
   + f395157c95692565bc220c7ccf788974fe0885fd:
     Allow running an extra spawn for local branch of dynamic
     execution.
   + 039461c76113ab3f165132dd26d0c58eb3e45cae:
     Adding debugging information for case when two branches
     apparently cancel each other.
   + b2231c56d78c6d37bcb6f11e1e50fe68ee336b4a:
     Move use of legacy sandbox -> local fallback to only be used
     after all strategies have been tried, and improve messages
     around it.
   + 5b95d9162b56b51c8e8f66258981ddf3c5d96765:
     Check the result of Future.cancel() when cancelling the other
     branch of dynamic execution.
   + 1962a59a5478f5ad374700b0abf0a718b1b3a7d3:
     Fix the case where if all strategies for one branch of `dynamic`
     execution fail to accept (that is, refuse to even take) the
     action given, the whole action fails. Instead of seeing whether
     the other branch can run and the action that that it succeeded.
   + b7c1ad2aff91105659299723a712b72eea943040:
     Fix rare crash in dynamic execution where both branches got
     cancelled.
   + 2c3cff5422b115d7bb86ed28a056f3d368ebceeb:
     Check if `treeDeleter` is actually async before casting it.
     Fixes #13240.
   + 1a89ce1757e75f8ba9bda76d7373a7e8527bcfc5:
     Make worker JSON protocol properly ignore unknown fields.
   + 4b12fc80abf4152815f09e473a972e52a1fe8b51:
     Fix test_source_file_does_not_override_standard_library to work
     with Python 3.9.
   + f4e10367df2d881f05e3ddd5bd0531b390a845fe:
     Removing line ending matches in tests to be compatible on Windows
   + ba74df07ced96226d78851e11d1df03147f1cc1f:
     Refactors CompilationSupport for objc to use existing API
   + a04cb1bfad4734f801c48bae3070a799067bda4e:
     Release 4.2.0 (2021-08-18)
   + ba8678077024e1b4e5d7419c758a97e8dc9fceea:
     Revert "fix main repo starlark options parsing.
   + 9f67cdf3d51c05bc2209786aa24b72658b61362c:
     cquery: disable `--build_tests_only`.
   + 02ad3e3bc6970db11fe80f966da5707a6c389fdd:
     Release 4.2.1 (2021-08-30)
   + ae0a6c98d4f94abedbedb2d51c27de5febd7df67:
     Enable user_link_flags_feature for macosx cc_toolchain_config
   + af74287f125b93119415ba35429b8638d7a986ea:
     Remote: Limit max number of gRPC connections by
     --remote_max_connections. (#14318)
   + 639f89d7682cadff723ac210fa37101f37762a9d:
     Fix [Prepa] actions stuck in active state
   + 3069ac4e33dcca6f3d1abf55940cdd764d03bdbf:
     Delete marker file before fetching an external repository
   + e6c8e8d1ba89df5cf624e7147cee6b8246a9a490:
     CI configs: switch centos to centos7_java11_devtoolset10
   + 15371720ae0c40ffc97b74c871d1b38851ef6410:
     Release 4.2.2 (2021-12-02)
   + f64b7553607e1d3572611cc5011c498e3cd4505c:
     [4.2.3] Update GrpcRemoteDownloader to only include relevant
     headers. (#16450) (#16459)
```

Incompatible changes:

  - GrpcRemoteDownloader only includes relevant headers instead of
    sending all credentials.
    
    Closes #16439.

Important changes:

  - Multiplex persistent workers can now use the JSON protocol.
  - enforce config_setting visibility. See
    https://github.com/bazelbuild/bazel/issues/12932 for details.
  - The minimum Android build tools version for the Android rules is
    now 30.0.0
  - Updates worker protocol with cancellation fields, and adds
    experimental_worker_cancellation flag to control cancellation.
  - If all strategies of one branch (the local or remote execution
    branch) of the `dynamic` strategy fail to even accept (via the
    response they give from `canExec`) the action, `dynamic` will now
    try to see if the other branch can accept it. (Trying to run it
    and it failing will still cause a failure if it was the first
    result, this is about strategies claiming they can't even try the
    action)

This release contains contributions from many people at Google, as well as Alex Eagle, Austin Schuh, Benjamin Peterson, bjacklyn, bromano, Christopher Peterson Sauer, Christopher Sauer, Cristian Hancila, Daniel Wagner-Hall, Denys Kurylenko, Ed Schouten, Fabian Meumertzheim, Finn Ball, George Gensure, Greg Estren, Johannes Abt, Keith Smiley, Kevin Hogeland, Lauri Peltonen, Noa Resare, Philipp Schrader, Ryan Beasley, Thi Doan, ThomasCJY, Timothy Klim, Trustin Lee, Ulf Adams, Vaidas Pilkauskas, Vertexwahn, wisechengyi, Xavier Bonaventura, Yannic Bonenberger, Yuval Kaplan, Yuval.

## Release 6.0.0-pre.20220922.1 (2022-09-30)

```
Baseline: 4e7d2a24715130ea5aec098e44f43fa603fad6b7
```

Incompatible changes:

  - this incompatible change breaks old instances of http_archive
    that specified netrc as an absolute path. It is unlikely there
    are many instances in the wild since the path would refer to a
    netrc file inside the external repository by absolute path.
    Migration should be straightforward.
  - genrule switched to use exec transition instead of host. This can
    break targets with hardcoded output paths. To avoid using
    hardcoded paths use make variables, see
    https://docs.bazel.build/versions/4.2.2/be/make-variables.html#pre
    defined_label_variables
  - this incompatible change breaks old instances of http_archive
    that specified netrc as an absolute path. It is unlikely there
    are many instances in the wild since...
  - Error Prone now checks for unused return values of additional
    methods on `java.lang.Object`, which can be disabled using
    `--javacopts=-Xep:ReturnValueIgnored:OFF`
  - Error Prone now checks for unused return values of additional
    methods on `java.lang.Object`, which can be disabled using
    `--javacopts=-Xep:ReturnValueIgnored:OFF`
  - The --incompatible_existing_rules_immutable_view flag has been
    flipped to true. See
    https://github.com/bazelbuild/bazel/issues/13907 for
    migration notes.
  - Split up the C++ archive from the C++ link action and set
    `CppArchive` as mnemonic.
  - workspace(managed_directories=) is not available anymore.
  - --legacy_important_outputs now has a default of false.
  - --legacy_important_outputs default reverted to true.
  - objc_library now requires CcInfo in its deps.  If this breaks
    you, add empty CcInfo() to your rule.
  - Flag --experimental_local_memory_estimate removed.
  - Added a new flag
    --incompatible_unambiguous_label_stringification, which causes
    labels in the main repo to stringify into unambiguous forms
    starting with an @. See
    https://github.com/bazelbuild/bazel/issues/15916 for more
    information.
  - analysis_test moved into testing.analysis_test

Important changes:

  - Deprecate --incompatible_applicable_licenses flag, in preparation
    for removal in Bazel 6.x.
  - Treat py_*.srcs_version="PY2" the same as "PY2ONLY".
  - The Build Event Protocol now contains file digests and sizes
    along with the file name and URI.
  - Refactor system suspend event handling.
  - alias() can now select() directly on constraint_value()
  - Allow \a \b \f \v escape sequences in Starlark.
  - Match remote and local xcode version by most granular version.
  - Adds `--experimental_worker_multiplex_sandboxing` flag that
    controls whether to sandbox multiplex workers that support it.
  - provider() has a new parameter: init, a callback for performing
    pre-processing and validation of field values. Iff this parameter
    is set,
    provider() returns a tuple of 2 elements: the usual provider
    symbol (which,
    when called, invokes init) and a raw constructor (which bypasses
    init).
  - Tests that fail to create or complete their
    `TestAttemptContinuation` by
    throwing an `ExecException` will report an `INCOMPLETE` status.
    Previously, Bazel
    would fail to report any status for the test attempt.
  - Fixed an issue where Bazel could erroneously report a test passes
    in coverage mode without actually running the test.
  - Include more information about configurations in cquery proto
    formatted output. This deprecates the configuration field of
    AnalysisProtosV2.ConfiguredTarget, and adds a new field,
    configuration_id, to
    be used instead.
  - experimental cc_library.implementation_deps inverted to
    interface_deps
  - In aquery and cquery proto output, indicate if a configuration is
    a
    tool or non-tool configuration.
  - Include complete configurations in cquery proto output.
  - experimental cc_library.implementation_deps inverted to
    interface_deps
  - Make protocOpts() publicly accessible.
  - Add some documentation about how configuration information is
    conveyed in cquery proto output.
  - Introduces experimental static library linking API under
    apple_common.link_multi_arch_static_library
  - Further deprecation and removal of pkg_tar. Stop supporting
    legacy use of 'files' attribute, where it could be a list of
    labels instead of a map of paths to labels.
  - Removed --incompatible_no_build_defs_pkg flag. It never fulfilled
    its purpose because --all_incompatible_changes would never set
    it. The last rule it gated (pkg_tar) is scheduled to be removed
    in Bazel 6.x.
  - Add coverage configuration fragment, used to expose
    output_generator label.
  - Bazel now no longer includes system headers on macOS in coverage
    reports (#14969).
  - android_sdk_repository read $ANDROID_SDK_ROOT in addition to
    $ANDROID_HOME.
  - The default dexer is now d8. dx can be optionally enabled using:
      --define=android_dexmerger_tool=dx_dexmerger \
      --define=android_incremental_dexing_tool=dx_dexbuilder \
      --define=android_standalone_dexing_tool=dx_compat_dx \
      --use_workers_with_dexbuilder
  - Packaging support for deploy JAR embedded JDK files (hermetic
    Java).
  - Don't stamp cc_common.link actions for tool dependencies.
  - Starlark test rules can use the new inherited_environment
    parameter of testing.TestEnvironment to specify environment
    variables
    whose values should be inherited from the shell environment.
  - Enable merging permissions during Android manifest merging with
    the --merge_android_manifest_permissions flag.
  - Allow specialization to work with constraint_values.
  - Bazel uses the D8 jar from Maven instead of the SDK.
  - Make ijar / java_import preserve classes with `@kotlin.Metadata`
    annotations
  - Switch cc_test implementation to Starlark. Note: cc_test will now
    link statically when _targeting_ Windows regardless of host
    platform (rather than always linking statically when Windows is
    the _host_).
  - Switch cc_test implementation to Starlark. Note: cc_test will now
    link statically when _targeting_ Windows regardless of host
    platform (rather than always linking statically when Windows is
    the _host_).
  - Add devtools/build/lib/worker:work_request_handlers to the remote
    android tools release package. This will be transitively packaged
    into all_android_tools.
  - Bazel uses the D8 jar from Maven instead of the SDK.
  - android_sdk_repository read $ANDROID_SDK_ROOT in addition to
    $ANDROID_HOME.
  - Advance android_tools_pkg version to 0.24.0.
  - Switch cc_test implementation to Starlark. Note: cc_test will now
    link statically when _targeting_ Windows regardless of host
    platform (rather
    than always linking statically when Windows is the _host_).
  - Bazel uses the D8 jar from Maven instead of the SDK.
  - "blaze config" now only reports info from the last build. To
    compare configurations across multiple builds, redirect "blaze
    config" output to a file and run your favorite diff tool.
  - The --incompatible_override_toolchain_transition flag is now
    always set, and will be removed in the future. Thus,
    --noincompatible_override_toolchain_transition has no effect, and
    the value of the incompatible_use_toolchain_transition parameter
    in aspect() and rule() builtins is ignored.
  - Switch cc_test implementation to Starlark. Note: cc_test will now
    link statically when _targeting_ Windows regardless of host
    platform (rather
    than always linking statically when Windows is the _host_).
  - Toolchain types may now be optional, in addition to mandatory.
    See https://bazel.build/docs/toolchains#optional-toolchains for
    further details.
  - Add six to deps of has_services=1 py_proto_librarys.
  - pkg_tar(symlinks) has been removed. Users needing that feature
    should
    migrate to @rules_pkg.
  - Aspects can now define and use exec groups using the same API as
    rules.
  - Removed the obsolete --incompatible_applicable_licenses flag. The
    feature is permanently enabled.
  - embedded_tools packages R8 desugarer again
  - Bazel now selects sh path based on execution platform instead of
    host platform, making it possible to execute sh actions in
    multiplatform builds. --shell_executable now only applies to
    actions configured for host.
  - labels in genquery.scope are no longer configured.
  - When Bzlmod is enabled, all Bzlmod-generated repos will have an
    extra '@' prepended to their names. This effectively enables the
    canonical label literal syntax for Bzlmod-generated repos
    (`@@canonicalRepoName//pkg:target`; see
    https://docs.google.com/document/d/1N81qfCa8oskCk5LqTW-LNthy6EBrDo
    t7bdUsjz6JFC4/edit?usp=sharing).
  - Exposed `CcSharedLibraryInfo` to Starlark builtins.
  - Enable --use_top_level_targets_for_symlinks by default.
  - Singlejar accepts runtime Created-By field
  - --noincompatible_disable_managed_directories, and with that,
    workspace(managed_directories=) is not supported anymore.
  - Bazel supports D8 desugaring, albeit without persistent workers
  - Remove mtime options from pkg_tar. Users should migrate to
    @rules_pkg.
  - Test for experimental multiplexed persistent resource processor.
  - Added new register_{execution_platforms,toolchains} directives to
    the MODULE.bazel file, to replace the
    {execution_platforms,toolchains}_to_register attributes on the
    module() directive.
  - The legacy pkg_tar no longer supports the ability to untar and
    repackage an input tar file (`deps` attribute). Users needed that
    capability must switch to github.com/bazelbuild/rules_pkg.
  - `cquery`'s new output mode
    [`--output=files`](https://bazel.build/docs/cquery#files-output)
    lists the output files of the targets matching the query. It
    takes the current value of `--output_groups` into account.
  - Change singlejar metadata to report Created-By Bazel
  - Add support for fetching RPC credentials from credential helper.
  - Revert interface_deps back to implementation_deps after problem
    reported in. Use `buildozer 'rename deps implementation_deps'
    //...:%cc_library; buildozer 'rename interface_deps deps'
    //...:%cc_library`
  - Fix for desugaring failure on Bazel+Android+Windows build
    scenario.
  - D8 is the default desugarer
  - Migrate main_dex_list_creator to D8 (DX deprecation)
  - --experimental_enable_bzlmod has been renamed --enable_bzlmod,
    and still defaults to false.
  - selects() no longer produce irrelevant duplicate label checks
  - Adds a dexer output cache to CompatDexBuilder to improve build
    speed.
  - Improved error messages when analyzing inline bzl code
  - Improved error messages when analyzing inline bzl code
  - The `@bazel_tools//tools/cpp:compiler` flag now has the value
    `gcc` if the configured compiler is detected to be gcc rather
    than the generic value `compiler`. A branch for `gcc` may have to
    be added to `select` statements that do not have a default case
    that handles gcc appropriately.
  - The `get_child` method of `path` now accepts an arbitrary
    number of relative path strings as positional arguments.
  - SourceManifestAction supports `Action.content`
  - Add --incompatible_build_transitive_python_runfiles alias. See
    #16303
  - The @bazel_tools//tools/cpp:compiler flag now has the value
    `clang` for the auto-configured Xcode toolchain rather than the
    generic value compiler. A branch for `clang` may have to be added
    to select statements that do not have a default case that handles
    this toolchain appropriately.
  - added additional debug message to warn of skipped toolchains
    during resolution

This release contains contributions from many people at Google, as well as Adam Azarchs, Adam Wolf, Albert Lloveras, Alessandro Patti, Alex Eagle, Alex Scott, Alex Torok, Andreas Fuchs, Andreas Herrmann, Andrew Katson, Andrew Klotz, Ara Nguyen, arunkumar9t2, arun.sampathkumar, Ast-x64, Benedek Thaler, Benjamin Lee, Benjamin Peterson, Ben Lee, Bohdan Vanieiev, Bradley Burns, Brandon Duffany, Brandon Jacklyn, Brentley Jones, Brentley Jones, Chad Miller, Charles-Francois Natali, Chris Clearwater, Chris Fredrickson, Christopher Peterson Sauer, Christopher Sauer, ckiffel, Cristian Hancila, crydell-ericsson, Dan Fleming, Daniel Wagner-Hall, Danny Wolf, David Ostrovsky, David Sanderson, Denys Kurylenko, dhmemi, Dimi Shahbaz, divanorama, dmaclach, Ed Schouten, Emil Kattainen, Eric Song, Fabian Brandstetter, Fabian Meumertzheim, floriographygoth, Fredrik Medley, George Prekas, gkgoat1, gkorlam, Greg Estren, Greg, Gregory Fong, Greg Roodt, Grzegorz Lukasik, Halil Sener, Hannes Kufler, homuler, hvadehra, hvd, Igor Nazarenko, James Broadhead, Jan, Jason Tan, Jay Bazuzi, Jeremy Volkman, jheaff1, Jiawen Chen, Joel Williamson, John Laxson, John Millikin, Jonathan Gerrish, Jon Shea, juanchoviedo, Kaiqin Chen, Keith Smiley, Ken Micklas, Kevin Lin, Kiron, Krishna Ersson, kshyanashree, lihu, Luc Bertrand, Luis Fernando Pino Duque, Marek uppa, Matt Clarkson, Matt Mackay, Michael P. Nitowski, Mikhail Balabin, Mostyn Bramley-Moore, Nick Korostelev, Nitesh Anandan, Niyas Sait, Noa Resare, Oscar Bonilla, Patrick Balestra, Paul Tarjan, Peter Mounce, Philipp Schrader, Pras Velagapudi, Rahul Butani, Rifqi Mulya Fahmi, Roman Salvador, rustberry, Ryan Beasley, Ryan Schmidt, Sahin Yort, Saleem Abdulrasool, Shuai Zhang, Simon Bjorklen, Son Luong Ngoc, Stephan Wolski, Steve Vermeulen, Stiopa Koltsov, Sven Tiffe, Takeo Sawada, Tao Wang, Ted Kaplan, Tetsuo Kiso, Thi Doan, Thomas Chen, ThomasCJY, Thomas, Thomas Zayouna, Timothe Peignier, Tomas Volf, Tom de Goede, Ulf Adams, Ulrik Falklof, Vasilios Pantazopoulos, Vladimir Tagakov, William Muir, Xavier Bonaventura, Xdng Yng, Yannic Bonenberger, Yannic Bonenberger, Yannic, Yesudeep Mangalapilly, Yuval K, Zhongpeng Lin.

## Release 5.3.1 (2022-09-19)

```
Baseline: 8d66a4171baddcbe1569972f019e54130111202c

Cherry picks:

   + becd1494481b96d2bc08055d3d9d4d7968d9702e:
     Remote: Cache merkle trees
   + d7628e1b566be353fe7172241ac8f15d5f8e7ff5:
     Update DEFAULT_IOS_CPU for M1 arm64 simulator support
   + 80c56ff7b603fcfff02a5f97829a2a5935f360a0:
     Compile Apple tools as fat binaries if possible
   + 3c09f3438a966b49a7c1726022c898b390b3a6e5:
     Add protobuf as a well known module
   + 3a5b3606a6f5433467a5b49f0188c41411684bf5:
     Remote: Merge target-level exec_properties with
     --remote_default_exec_properties
   + 917e15ea408e1d3d25574edbb466b39cfbcb61fe:
     Add -no_uuid for hermetic macOS toolchain setup
   + f5cf8b076bc913dbe021104d5f6837fb4a6cd8b3:
     Remote: Fixes an issue when --experimental_remote_cache_async
     encounter flaky tests.
   + 77a002cce050e861fcc87c89acf7768aa5c97124:
     Remove DigestUtils.getDigestInExclusiveMode() now that SsdModule
     has …
   + 557a7e71eeb5396f2c87c909ddc025fde2678780:
     Fixes for the Starlark transition hash computation (#14251)
   + 34c71465f84fa780217926db2e8e5ca3d6d4568c:
     Do location expansion in copts of objc_library
   + 50274a9f714616d4735a560db7f617e53fb8d01b:
     [5.x] Remote: Add support for compression on gRPC cache (#14277)
   + 61bf2e5b5181cbe34a2f0d584053570943881804:
     Automated rollback of commit
     34c71465f84fa780217926db2e8e5ca3d6d4568c.
   + 79888fe7369479c398bafe064daa19a7ae30f710:
     Silence a zstd-jni GCC warning.
   + 063b5c9c2c09b4794010b9a169b44890ffc79ec4:
     Remote: Limit max number of gRPC connections by
     --remote_max_connections.
   + fd727ec96d861573dcbad3249d727a94eff84789:
     Do location expansion in copts of objc_library
   + 23d096931be9b7247eafa750999dd7feadde14c1:
     Fix _is_shared_library_extension_valid
   + 5cf1d6e1f78bc860fcd0e2e86eff6fe43ab4a5a2:
     Remove merging of java_outputs in JavaPluginInfo.
   + cea5f4f499aa832cf90c68898671869ce79d63f2:
     Cherrypick Bzlmod documentation (#14301)
   + 227e49e28e5122cddd6c4cb70686ff7bde3617ea:
     Format work requests according to ndjson spec
   + ae0a6c98d4f94abedbedb2d51c27de5febd7df67:
     Enable user_link_flags_feature for macosx cc_toolchain_config
   + 8c2c78cdc66cc9d5eb2cd59823c659892c1643a7:
     Remote: Use Action's salt field to differentiate cache across
     workspaces.
   + f94898915268be5670fb1e93a16c03e9b14d2a58:
     [5.x] Remote: Fix "file not found" error when remote cache is
     changed from enabled to disabled.  (#14321)
   + 3069ac4e33dcca6f3d1abf55940cdd764d03bdbf:
     Delete marker file before fetching an external repository
   + c05c6261cdb2cacb7c9881c255c0ada435ab5182:
     Remote: Fix file counting in merkletree.DirectoryTreeBuilder
   + d84f7998ef8f15e27376a0c8f25b320145c4ba9e:
     Fix remote spawn tests for remote_merkle_tree_cache=true
   + 59e16e944200555da377799aa0d9e8d0674d2e27:
     Show skipped tests as a warning
   + 76b3c242831f8e88835e3002a831a185a41fcc52:
     Build xcode-locator as a universal binary
   + aa52f2ddf9bab1ebd18e5431124061e813bfcd80:
     Exit collect_coverage.sh early if LCOV_MERGER is not set.
   + 4256d46327bad8638df91be1a5d4ef83b12b74c7:
     Automated rollback of commit
     d84f7998ef8f15e27376a0c8f25b320145c4ba9e.
   + dce24350befd08216b3910ae343670015444ff81:
     [apple] fix issues compiling C in objc_library for watchos/armv7k
   + bfc24139d93f8643686d91596ba347df2e01966a:
     5.x: Remote: Ignore blobs referenced in BEP if the generating
     action cannot be cached remotely. (#14389)
   + 5aef53a8884038f3c9f06e6dddb9372196253378:
     Remote: Don't blocking-get when acquiring gRPC connections.
     (#14420)
   + 005361c895da334beb873901e93aff06d180256e:
     Disable IncludeValidation for ObjC in bazel
   + d703b7b4f09fb3c389f99e52bac1f23930280b56:
     Update java_tools v11.6
   + 90965b072eb4a6dec8ff5b8abde3726732d37bdc:
     Stop remote blob upload if upload is complete. (#14467)
   + dc59d9e8f7937f2e317c042e8da8f97ba6b1237e:
     [5.x] Make remote BES uploader better (#14472)
   + 2edab739e1f61fe8813230b03396ca46f0790089:
     Avoid too verbose warnings in terminal when cache issues
   + 1160485192b5e6d95bcd426b55cc9a35fc6b8614:
     Rename --project_id to --bes_instance_name
   + c63d9ecbe5fcb5716a0be21d8fc781d7aa5bbc30:
     Automated rollback of commit
     bfdfa6ebfd21b388f1c91f512291c848e1a92a96.
   + b341802700484d11c775bf02d80f43ba3f33b218:
     [apple] support watchos_arm64 in toolchain
   + 43bcf80a3dfdc5ac89c1e4d615d6f29a495855fb:
     Disable implicitly collecting baseline coverage for toolchain
     targets.
   + 302971e1b3d803069ac949c0085c0d2a3916c8ab:
     Automated rollback of commit
     7d09b4a15985052670244c277e4357557b4d0039.
   + 62002024ca7012ffe0f4fc74ac20b5471513c8c8:
     Bzlmod: Starlarkify default attr values for TypeCheckedTags
   + 38117d491cbc4a5686e0bdb1e58f8946d96aed58:
     Fix build after rc4 cherrypicks (#14581)
   + 41feb616ae18e21fdba3868e4c298b0b83012f10:
     Release 5.0.0 (2022-01-19)
   + 486d153d1981c3f47129f675de20189667667fa7:
     Find runfiles in directories that are themselves runfiles
   + 0de7bb95022057e8b89334f44759cf6f950e131f:
     Don't resolve symlinks for --sandbox_base
   + 8b60c90f3641591b65c4e153113aea562f1fab94:
     Remove uses of -lstdc++ on darwin
   + 60f757c0831f9fbb2415fb0105f964201faa9fa0:
     Allow Label instances as keys in select (#14755)
   + 3836ad029f202ca13c64c9f07e4568ea8ab2d9a6:
     Remote: Only waits for background tasks from remote execution.
   + 8734ccf9847eafb7193388cd9c6fa78faa78283f:
     Add the default solib dir to the rpath for cc_imports with
     transitions
   + 9e16a6484e94c358aa77a6ed7b1ded3243b65e8f:
     Flip --experimental_worker_allow_json_protocol
   + fce7ea8d5e0facfc125ae7c37bfb4b9a7c586e40:
     Fix `ctx.fragments.apple.single_arch_cpu` returning incorrect
     cpu for tools when host cpu and exec cpu are different
   + 0c1d09e4dce4c3251c2be2c70d4575ec65b1d9d3:
     Propagate --experimental_cc_implementation_deps to host config
   + 1c3a2456c95fd19974a5b2bd33c5ebdb2b2277e4:
     Support select() on constraint_value for aliases.
   + 67a133b431ccece22b7dd9a72f0837cff77d4360:
     Improve documentation for select()
   + 5356fedd4b6079851b51db27077bf84c7bab16a4:
     Cherrypicks for experimental cc_shared_library (#14773)
   + ffdd633d7b9f21267f4f9759dd9833096dd4e3a2:
     [apple] support tvos_sim_arm64 in toolchain (#14779)
   + a58ddea50b2fd476d183e2e0c077ad6173039b89:
     Cherry pick win arm64 (#14794)
   + dc41a20bb045d221a43223a5db6b8b44cd8f1676:
     [5.1.0] cherrypick subpackages support (#14780)
   + 86e2db7d67ec52bfe11c1f517f650653cee3ea26:
     Add a helper method for rules to depend on the cpp toolchain
     type.
   + 6990c02644a71d5e7c95c9c234ecf39bb55c6ac4:
     UrlRewriter should be able to load credentials from .netrc
     (#14834)
   + 32d1606dac2fea730abe174c41870b7ee70ae041:
     Add "arch" struct field to repository_os
   + 2cfdceae971d09f50ceddc3d7ef723fb5f879957:
     [5.x] bzlmod: Add support for WORKSPACE.bzlmod (#14813)
   + c2ddbd1954af5baab63b93f2b055a410a27832c8:
     Ignore missing include directory in JDK distribution.
   + 16de03595e21f7bf31818e717505b23c953b3b7d:
     Fix bazel coverage false negative
   + 0c74741742301abcf67452a7f591daec1c3a7635:
     Remote: Postpone the block waiting in `afterCommand` to
     `BlockWaitingModule` (#14833)
   + 3297d9234e15515aa91cc887b3b12db7e1040b02:
     Switch to `ProcessHandle` for getting the PID (#14842)
   + a987b98ea0d6da2656c4115568ef9cbe8a164550:
     Fix uses of std++ on bsd
   + d184e4883bb7fc21de2f7aeea4304994de27e9ea:
     Remote: handle early return of compressed blobs uploads
   + 0b09e9e018c557da04c9f978d25a66d963cd6cb6:
     Add removeprefix/removesuffix to Starlark strings
   + d42ab0cfcce56b5e55c8bd94d0923d08758fdb5b:
     Fix default CPU for macOS and iOS (#14923)
   + cd24f39750d7b08f6f31c82d3a23cc329c7fc78e:
     Add paramfile support for def_parser, since in rare cases on
     Windows command line character limit was reached.
   + 0b1beefd1e7611dc9b9f559d00d8ff76aabb0f32:
     Normalize rpath entries to guard against missing default solib
     dir
   + 24e82426e689853b0d9a04e7b9b6f13e145cf2d6:
     Fix aggressive params file assumption
   + c45838bd3e51bcd0c8c3e1a9b4a0e55cdf4b4f59:
     Fix precompiled libs not in runfiles of cc_shared_library
     (#14943)
   + 764614e0f0287125269e7a92e909a44624bcb360:
     Bzlmod: Allow multiple `use_extension`s on the same extension
     (#14945)
   + fa761f84994f18db383fbe9aaea524e4385da13a:
     Fix typo in `apple_common.platform` docs
   + f7d8288bd7b16c7f2e010aa8ddc241cf2ba8e0d5:
     Yield a Proxy for addresses without protocol
   + 8cefb8bed4ac82df8640682517372a9249732352:
     Avoid merging URLs in HttpUtils
   + b4804807fc2c184cc36df9e69e472942c01941b8:
     Make protocOpts() public. (#14952)
   + 113eaca5862c48797654ae2a3acbb6e15d761485:
     Do not hide BulkTransferException messages when there were more
     than one exception
   + b1bf9d6c5f85fc4fda0dc48bc3d3e2fe26880867:
     merkle_tree_cache: change default size to 1000
   + f15e0c7224ecc5473d4972afc436e28df35c4e5a:
     Add --experimental_repository_cache_urls_as_default_canonical_id
     to help detect broken repository URLs (#14989)
   + f4214746fcd15f0ef8c4e747ef8e3edca9f112a5:
     Expose the logic to read user netrc file
   + b858ec39aebd7e586af5438aa2035db2adebf9a4:
     Correct cpu and os values of `local_config_cc_toolchains` targets
   + 5e79972c05d89280f0cf1fa620f807366847bac6:
     Expose CoverageOutputGenerator on a Fragment (#14997)
   + 78f03110e0dab42f37e427fd524e72706e036d74:
     Correct error runfiles cc_shared_library (#14998)
   + 7937dd14c3c632ffcfaea9073d5dec6dcac93845:
     [5.1] Adding Starlark dependencies to the package //external
     (#14991)
   + a73aa12be65454ac8cfb5a8f3e056c420402f997:
     Remote: Fix crashes with InterruptedException when using http
     cache.
   + f8707c07f153ac4ac2ec4b210321f1a16343006d:
     Account for interface libraries in cc_shared_library
   + a570f5fdb1618a6c272d18bebaa712d3b2af3975:
     Fix coverage runfiles directory issue
   + 95de355e4524a6339c0e807b60d333c36c40bdc7:
     Do not validate input-only settings in transitions (#15048)
   + 71747ccc9d0032a865854613329362563c0574df:
     Filter out system headers on macOS.
   + cb6500a9ce648a02154dca8d05a978ce9b10c4b4:
     Update Bazel bootstrap documentation and remove obsolete flags.
     (#15065)
   + 4c031d1030afb1cb48c7e6d71f83cc99fea607c1:
     [5.1] Undocument --bes_best_effort (#15066)
   + 267142f3dc6b8d32b07beb21e3b4ba6f471a69d8:
     Fix conflicting actions error when specifying
     --host_macos_minimum_os (#15068)
   + f1923627e85b1c1d60bcd928f90f116c3ade7a3a:
     [5.1] Remote: Action should not be successful and cached if
     outputs were not created (#15071)
   + 00d74ff737cccd60305ee58d85313556a077152a:
     Support decompressing zstd tar archives for repository rules.
   + f5857830bb68bd05ffc257506575ed37a8128933:
     Remote: Don't check TreeArtifact output
   + efb2b80953983dce499d453a9f55a74ffaf8c42d:
     osx_cc_wrapper: Only expand existing response files
   + c771c43b870fb8618db7bdab6725ab40cac4976d:
     Remote: Fix crashes by InterruptedException when dynamic
     execution is enabled. (#15091)
   + 3785677cc84fc4024fda85575c05efbde5d512fc:
     Use python3 on macOS
   + 815d9e499a32fd4d87525ac0c698c293cf26433d:
     Release 5.1.0 (2022-03-24)
   + 1fbb69e366034484887e00c6006c7b79508765ed:
     Prepare 5.1.1 release
   + df153df9656e0e197f67622bb11f7d77e19238a0:
     Fix CODEOWNERS syntax
   + 2b92a3111e83a4d14934059afd0f51161a41276f:
     Remote: Don't check declared outputs for failed action
   + b47aa71b21d93c9499103e9a37a6c2ffa79865b9:
     Upgrade abseil version to the latest
   + c49c45d8dac87d21cf2b6a176ddd07f2c9f63414:
     Revert default export all symbols on Windows
   + 7d3fb993f55b35081786c3fe00cf3bebb89574f3:
     Support ZIP files with total number of disks = 0
   + 0f5dc111be06b2ee8694640f400b58e12bfa5fea:
     Release 5.1.1 (2022-04-08)
   + 2422cfb3e5d92d46f9065b2b1e442823a965faf7:
     Update CODEOWNERS
   + bbcff1802423fca7ee5bd6a3e527c12d6d7d80ba:
     [5.2.0] Update java_tools 11.7.1 (#15231)
   + 9c98120f33579b72561e02826d9fccf222eccb3c:
     Add support for .ar archives (and .deb files)
   + d3435b09d89f25bf5008ef3b9c870c835d51a8da:
     Seperate GetSelfPath implementation for Blaze and Bazel
   + c94572bea5ce6bdc0ccda9789e5be6fb3f4c173b:
     Include jdk.crypto.mscapi in minimized Windows embedded JDK
   + 299022ca2dc49b6cb27b2674f933755306ae8b9b:
     remote: Proactively close the ZstdInputStream in
     ZstdDecompressingOutputStream.
   + 27707995cc6576ed1f51fbdb199ff8512e8418c9:
     Collect coverage from cc_binary data deps of java_test
   + 3442179d240e01ef13b0fa7814db7366bad5ffac:
     Configure Apple crosstool to return a complete target triple
     that includes minimum OS version and target environment
   + bb6f1a7ce79168055ccd62629da07d46a52b930d:
     Collect C++ lcov coverage if runtime object not in runfiles
   + dbb6e9954b6e4423f727feb2719ffc75a93b514b:
     Fixing dependencies of //external package
   + f0213bbf730c4a5d1a31e65bc9c01fbb55a6edb3:
     [5.2] Upgrade Google Auth Version (#15383)
   + a1a74c9919e03e09ef7c6ae13f38f48eea80ead1:
     Fix chocolatey package - docsUrl must not 404 (#15395)
   + fe644bee95c14d461e0d1e3cccaa8bbcd57bcd8d:
     Fix cache leak when applying transitions when only a rule's
     attributes change.
   + ad74d5243917bb27a37e38d151a4a3c8a49947eb:
     Fix checking remote cache for omitted files in buildevent file
     (#15405)
   + ac219103d8798965b775db548d7b9214ecd78f73:
     fix(bzlmod): throw on json parse exception
   + 3d85b88609a362857d8ee3c0432a37d30268a8a2:
     Add a flag to expose undeclared test outputs in unzipped form.
     (#15431)
   + abd7a9f70c3dfe96724a692dc7dc04ff33bdece1:
     Remove -U_FORTIFY_SOURCE when thin_lto is enabled (#15433)
   + 53b9cb8637c0faddc6b122a1daab72bcc274bdec:
     Catch NumberFormatException while trying to parse thread id.
   + 19740b55ebc283b7ec42b359bcd4c9096facfdd5:
     Improve the --sandbox_debug error message
   + 0a2a43f9aab1e3875f03f643f6414eb67834c883:
     Set keywords on appropriate lifecycle events.
   + 394ddb82b311ea7edbe2522736b0b0202903ddb6:
     Record additional profiling information for remotely executed
     actions.
   + 652b48e567fcb30768dfc2eddee5f04bf6b5d65b:
     Fix downloading remote execution output files inside output
     dirs. (#15444)
   + 73f1ecbc1cb00e16ceda4b582f4d57268f8701cd:
     Fix android emulator darwin_arm64 select
   + 2649c7c4adef0ebf9bca8fe46aa97304b22de522:
     Fix --use_top_level_targets_for_symlinks with aliases (#15446)
   + fa1081c1f3dce7324a1da59c40d1a1a3533c7047:
     Filter libtool warning about table of contents
   + 26f878325e915e0905626a0e4c8bbacffd72f875:
     Unify sandbox/remote handling of empty TreeArtifact inputs
     (#15449)
   + 6b21b7773157a1eebd3dfe79ff4c4ee750059daf:
     Revert "Fixes incorrect install names on darwin platforms"
   + e133e66f715bac17bf5848e4440c089a8c8d3fd9:
     config doesn't error on duplicate `--define` values (#15473)
   + 84d59176622b76223828e61709179dbd5f0c9f8d:
     Collect coverage from cc_binary data deps of py_test (#15298)
   + 519d2daacfff3de6ffabfc5827621fa835e1c815:
     SolibSymlinkAction does not need exec platform or properties
   + 6e54699884cfad49d4e8f6dd59a4050bc95c4edf:
     Let Starlark tests inherit env variables (#15217)
   + 9610ae889e6fd45280c5beb7fe8f5bef2d736878:
     Update PythonZipper action to use CommandLineItem.CapturingMapFn
   + 2f1ff6fa17c3c30b2533bffe81f40eab06b453b9:
     Make `coverage --combined_report=lcov` skip incompatible tests
   + 9fad5a3dc93cd436a5712c46e6c98d3995428ddb:
     Disable ReturnValueIgnored checks to unblock java_tools release
   + 0120118893261968bdf116ef215655c428428fa8:
     Bump the limit of Bazel install base size (#15585)
   + 668805aace9bf96f78595fc2a122027a3000ceac:
     Upgrade zlib to 1.2.12
   + 4d900ceea12919ad62012830a95e51f9ec1a48bb:
     [5.2] Remote: Fix a bug that outputs of actions tagged with
     no-remote are u... (#15453)
   + b703cb9b999e243d776b7620468e48f450c0ce3a:
     Add feature to produce serialized diagnostics files (#15600)
   + 2e8458b7810eab7829fc7d28af5c45b9af91ed7c:
     Release 5.2.0 (2022-06-07)
   + 536f8d97991d891fc7db333af1a5262497d85173:
     Fix fail message construction in cc_shared_library
   + 2d42925ae80c0fb007aa39f4e210122611897255:
     Define cc-compiler-darwin in Xcode toolchain
   + a1d7d1f69f82da1bdfa1cebd32356249127aea3b:
     Fix alwayslink in objc_import
   + d273cb62f43ef8169415cf60fc96e503ea2ad823:
     Unify URL/URLs parameter code across http_archive, http_file,
     http_jar
   + fea32be42928c84463aa1f335b5722a1f6b8c93a:
     Preserve --experimental_allow_unresolved_symlinks in exec cfg
   + e4bc370b226eb0cc536b55641640266345a214ec:
     Ck/cherry pick cc shared library (#15754)
   + dbdfa07e92f99497be9c14265611ad2920161483:
     Let Starlark executable rules specify their environment (#15766)
   + e2a6a2b130552db7521d3d4d854b9a651b1f4a3b:
     Fix string formatting when java_home path is missing.
   + d54a288e6c79c740b9c93dfc31ee345d6a5332af:
     Optionally enable LLVM profile continuous mode
   + ad17b44cdc192277fafb0d0e204962b2b924dba8:
     Print remote execution message when the action times out (#15772)
   + 240e3d1e1dbc74c7753dead6421d7c1b5fc28d09:
     Add missing line to cherrypick
     e4bc370b226eb0cc536b55641640266345a214ec (#15784)
   + 804b4747152a59bc2965be2db85839b8b2764fc7:
     Replace strdupa with strdup
   + 62be9ea29295fab5289bd5d1a0f13dc7d55a8bc0:
     Bzlmod: Better canonical repo names for modules with overrides
     (#15793)
   + d4663a1c950d618c5b15a3e00fb733987cbf45cc:
     Add repo env test (#15768)
   + 594962cb283dcd71b736e0450453903911a8c85a:
     Add is_root struct field to bazel_module (#15815)
   + 3dd2b932d42fe86112899550d21452409cb3c4b0:
     Fix null pointer crash with `bazel coverage` on only
     incompatible tests
   + 4175018b47800db28c390d39fefbd266b5d674bd:
     Add util for finding credential helper to use
   + 3ea9eb2e363860c9305a987fa22a059afd35598d:
     Merge ManifestMergerAction-related commits into release-5.3.0
     (#15824)
   + 64571a428ffe2bf09f1a5eea13e770a7d0381620:
     Ck/cherrypick 15669 (#15788)
   + 1404651cafe5c26c5dae469e9126de53c2f4f024:
     Create output directories for remote execution (#15818)
   + ae523f82d39daf01cf31e40733de0c6345f0935c:
     Use tree artifacts in bootclasspath rule
   + 37f181cb6ed0237f43d81159eb81b19d3b5f8e36:
     [credentialhelper] Add types to communicate with the subprocess
   + 06ca634e10f17023022ab591a55aabdd9fb57b12:
     Add a flag to force Bazel to download certain artifacts when
     using --remote_download_minimal (#15870)
   + d35f923b098e4dc9c90b1ab66b413c216bdee638:
     RemoteExecutionService: fix outputs not being uploaded
   + 78af34f9f25b0c8fbf597a794a5162f0014629c5:
     Cherry-pick proto_lang_toolchain Starlarkfication and
     proto_common module (#15854)
   + afb434da9da79b53da1ea4c7bcc00571dbea6d3f:
     Fix behavior of `print()` in module extensions
   + 6714c30507edc70ec84f8c97d47cffc497356c0b:
     [credentialhelper] Implement invoking credential helper as
     subprocess
   + 0f05904171d187e6abacb431b3d7494423b027ab:
     Add register_{execution_platforms,toolchains} directives to
     MODULE.bazel files (#15852)
   + 33516e27dc6ee6ab5c3b9dee739a267b08d26b6c:
     [remote] Improve .netrc test in RemoteModuleTest
   + aa2a1f3afe2f10baab5befcafb39df14cbffc743:
     Fix ZipDecompressor windows 0x80 (file attribute normal)
   + 30f16e53cb36a5d506665be7553e785d52772e2d:
     Replace uses of `cfg = "host"` with `cfg = "exec"` (#15922)
   + 2a8d0ad7103511a94382aef41821a315bf8144b7:
     target pattern file: allow comments
   + 6f732052654ec37192450c795bb28dd0aad559cd:
     Add factory for creating paths relative to well-known roots
     (#15931)
   + 32cc8e638b91816f427b74266f6a8da6fb605419:
     Update CODEOWNERS (#15910)
   + 63bc14b095f1ea4043024e7fe1f9c476968897c5:
     Implement native analysis_test call. (#15940)
   + 4df77f771e5cfdf4b614afd8934d00c2b2ff31d1:
     Increase osx_cc_configure timeouts
   + cdf01a39ab9def4d46f41595ac1ac9206a96d6f8:
     Allow string_list flags to be set via repeated flag uses
   + 05e758d4bc18fc9d9e189526381a06e4399056a2:
     [credentialhelper] Add parser for flag syntax (#15929)
   + e4ee34416ef18094496ab54446e70cb62cd509e6:
     Docs should mention the new no-remote-cache-upload tag (#15965)
   + 96d23d30cc80912b82a8fbab31c902e9db74b6ab:
     Add netrc support to --bes_backend (#15970)
   + c5bc34e5f1dd92703dd8f15f9f0409c49b778837:
     Add CommandLinePathFactory to CommandEnvironment (#15971)
   + 508f18576ab5327bd623db6b476511ac2089d0fa:
     Move newCredentialHelperProvider into GoogleAuthUtils (#15973)
   + 14c944a5386eccbcfbe8389afb6c518582b11270:
     Wire up credential helper to command-line flag(s) (#15976)
   + 04c373b708390341be4ceb8eb5b2f8561385cb11:
     Add `--output=files` mode to cquery (#15979)
   + edfe2a17e3434cce660757f59b14f2e9d6ab944e:
     Make cpp assembly file extensions case sensitive again
   + 4ae85387e69db73e507b4f18b36d3e2f799e5d34:
     Prevent aspects from executing on incompatible targets (#15984)
   + f440f8ec3f63e5d663e1f9d9614f05a39422102a:
     Remote: Fix performance regression in "upload missing inputs".
     (#15998)
   + 0109031a2818b217b78026055b972da5901656f5:
     Updated Codeowners file (#16032)
   + 6102d33bf0b72dc0fe9ada4c71113cbee3eb8187:
     Propagate the error message when a credential helper fails.
     (#16030)
   + a8dacc7832b04fe1756cd7adce72f2572f357eee:
     Migrate legacy desugar wrapper to new rlocation() (#16025)
   + 11368be4ac24108f18b1965162ad27f207c074f9:
     Correctly report errors thrown by CommandLinePathFactory#create.
   + 82452c7c372fb28485b0b5e0a98b471648f0dfd0:
     Fix an issue that
     `incompatible_remote_build_event_upload_respect_no_… (#16045)
   + e745468461f93839491a4f80d0c1883d9007f9c0:
     Fix rpath for binaries in external repositories (#16079)
   + 83041b145d3966eb353aacb22b7e33ad01d9a239:
     Refactor combined cache. (#16110)
   + c62496f7b76da473cb1102798373f552ba2f434d:
     C++: Add compound error linked statically but not exported
     (#16113)
   + 0f18786b09e9729d79c0f14f7843b4d8402b6115:
     Do not crash on URIs without a host component.
   + 9c0940df3c5962b2291e812600dd71731775d45b:
     Add profiler task for calling a credential helper.
   + 2ca1ab2c2c73d78021794f3099ee892cc73f515e:
     Make bazel_cc_code_coverage_test more robust against GCC version
     differences (#16254)
   + 1e25152906b668bbe56aa4c1773186af85335315:
     Fix local execution of external dynamically linked cc_* targets
     (#16253)
   + f6cccae5b6f9c0ad0e7d0bf7bd31ea1263449316:
     * add change to allow blaze info to skip Starlark build settings
     that start with --no prefix * add unit tests for both info and
     clean commands
```

Important changes:

  - alias() can now select() directly on constraint_value()
    
    Fixes https://github.com/bazelbuild/bazel/issues/13047.
    
    Closes #14310.
  - Fixed an issue where Bazel could erroneously report a test passes
    in coverage mode without actually running the test.
  - Make protocOpts() publicly accessible.
  - Add coverage configuration fragment, used to expose
    output_generator label.
  - Bazel now no longer includes system headers on macOS in coverage
    reports (#14969).
    
    Closes #14971.
  - Starlark test rules can use the new inherited_environment
    parameter of testing.TestEnvironment to specify environment
    variables
    whose values should be inherited from the shell environment.
    
    Closes #14849.
  - none
    RELNOTES:none
  - Enable merging permissions during Android manifest merging with
    the --merge_android_manifest_permissions flag.
  - Added new register_{execution_platforms,toolchains} directives to
    the MODULE.bazel file, to replace the
    {execution_platforms,toolchains}_to_register attributes on the
    module() directive.
  - Add support for fetching RPC credentials from credential helper.
    
    Progress on https://github.com/bazelbuild/bazel/issues/15856
    
    Closes #15947.
  - `cquery`'s new output mode
    [`--output=files`](https://bazel.build/docs/cquery#files-output)
    lists the output files of the targets matching the query. It
    takes the current value of `--output_groups` into account.
    
    Closes #15552.
  - Fix for desugaring failure on Bazel+Android+Windows build
    scenario.

This release contains contributions from many people at Google, as well as amberdixon, Andreas Fuchs, Benjamin Peterson, Brentley Jones, Chenchu Kolli, Dan Fleming, Danny Wolf, Emil Kattainen, Fabian Meumertzheim, Gowroji Sunil, hvadehra, Juh-Roch, Keith Smiley, kshyanashree, Niyas Sait, Noa Resare, Oliver Eikemeier, oquenchil, Peter Mounce, Philipp Schrader, Ryan Beasley, Thi Doãn, Xùdōng Yáng, Yannic, Zhongpeng Lin.

## Release 5.3.1 (2022-09-19)

```
Baseline: 8d66a4171baddcbe1569972f019e54130111202c

Cherry picks:

   + becd1494481b96d2bc08055d3d9d4d7968d9702e:
     Remote: Cache merkle trees
   + d7628e1b566be353fe7172241ac8f15d5f8e7ff5:
     Update DEFAULT_IOS_CPU for M1 arm64 simulator support
   + 80c56ff7b603fcfff02a5f97829a2a5935f360a0:
     Compile Apple tools as fat binaries if possible
   + 3c09f3438a966b49a7c1726022c898b390b3a6e5:
     Add protobuf as a well known module
   + 3a5b3606a6f5433467a5b49f0188c41411684bf5:
     Remote: Merge target-level exec_properties with
     --remote_default_exec_properties
   + 917e15ea408e1d3d25574edbb466b39cfbcb61fe:
     Add -no_uuid for hermetic macOS toolchain setup
   + f5cf8b076bc913dbe021104d5f6837fb4a6cd8b3:
     Remote: Fixes an issue when --experimental_remote_cache_async
     encounter flaky tests.
   + 77a002cce050e861fcc87c89acf7768aa5c97124:
     Remove DigestUtils.getDigestInExclusiveMode() now that SsdModule
     has …
   + 557a7e71eeb5396f2c87c909ddc025fde2678780:
     Fixes for the Starlark transition hash computation (#14251)
   + 34c71465f84fa780217926db2e8e5ca3d6d4568c:
     Do location expansion in copts of objc_library
   + 50274a9f714616d4735a560db7f617e53fb8d01b:
     [5.x] Remote: Add support for compression on gRPC cache (#14277)
   + 61bf2e5b5181cbe34a2f0d584053570943881804:
     Automated rollback of commit
     34c71465f84fa780217926db2e8e5ca3d6d4568c.
   + 79888fe7369479c398bafe064daa19a7ae30f710:
     Silence a zstd-jni GCC warning.
   + 063b5c9c2c09b4794010b9a169b44890ffc79ec4:
     Remote: Limit max number of gRPC connections by
     --remote_max_connections.
   + fd727ec96d861573dcbad3249d727a94eff84789:
     Do location expansion in copts of objc_library
   + 23d096931be9b7247eafa750999dd7feadde14c1:
     Fix _is_shared_library_extension_valid
   + 5cf1d6e1f78bc860fcd0e2e86eff6fe43ab4a5a2:
     Remove merging of java_outputs in JavaPluginInfo.
   + cea5f4f499aa832cf90c68898671869ce79d63f2:
     Cherrypick Bzlmod documentation (#14301)
   + 227e49e28e5122cddd6c4cb70686ff7bde3617ea:
     Format work requests according to ndjson spec
   + ae0a6c98d4f94abedbedb2d51c27de5febd7df67:
     Enable user_link_flags_feature for macosx cc_toolchain_config
   + 8c2c78cdc66cc9d5eb2cd59823c659892c1643a7:
     Remote: Use Action's salt field to differentiate cache across
     workspaces.
   + f94898915268be5670fb1e93a16c03e9b14d2a58:
     [5.x] Remote: Fix "file not found" error when remote cache is
     changed from enabled to disabled.  (#14321)
   + 3069ac4e33dcca6f3d1abf55940cdd764d03bdbf:
     Delete marker file before fetching an external repository
   + c05c6261cdb2cacb7c9881c255c0ada435ab5182:
     Remote: Fix file counting in merkletree.DirectoryTreeBuilder
   + d84f7998ef8f15e27376a0c8f25b320145c4ba9e:
     Fix remote spawn tests for remote_merkle_tree_cache=true
   + 59e16e944200555da377799aa0d9e8d0674d2e27:
     Show skipped tests as a warning
   + 76b3c242831f8e88835e3002a831a185a41fcc52:
     Build xcode-locator as a universal binary
   + aa52f2ddf9bab1ebd18e5431124061e813bfcd80:
     Exit collect_coverage.sh early if LCOV_MERGER is not set.
   + 4256d46327bad8638df91be1a5d4ef83b12b74c7:
     Automated rollback of commit
     d84f7998ef8f15e27376a0c8f25b320145c4ba9e.
   + dce24350befd08216b3910ae343670015444ff81:
     [apple] fix issues compiling C in objc_library for watchos/armv7k
   + bfc24139d93f8643686d91596ba347df2e01966a:
     5.x: Remote: Ignore blobs referenced in BEP if the generating
     action cannot be cached remotely. (#14389)
   + 5aef53a8884038f3c9f06e6dddb9372196253378:
     Remote: Don't blocking-get when acquiring gRPC connections.
     (#14420)
   + 005361c895da334beb873901e93aff06d180256e:
     Disable IncludeValidation for ObjC in bazel
   + d703b7b4f09fb3c389f99e52bac1f23930280b56:
     Update java_tools v11.6
   + 90965b072eb4a6dec8ff5b8abde3726732d37bdc:
     Stop remote blob upload if upload is complete. (#14467)
   + dc59d9e8f7937f2e317c042e8da8f97ba6b1237e:
     [5.x] Make remote BES uploader better (#14472)
   + 2edab739e1f61fe8813230b03396ca46f0790089:
     Avoid too verbose warnings in terminal when cache issues
   + 1160485192b5e6d95bcd426b55cc9a35fc6b8614:
     Rename --project_id to --bes_instance_name
   + c63d9ecbe5fcb5716a0be21d8fc781d7aa5bbc30:
     Automated rollback of commit
     bfdfa6ebfd21b388f1c91f512291c848e1a92a96.
   + b341802700484d11c775bf02d80f43ba3f33b218:
     [apple] support watchos_arm64 in toolchain
   + 43bcf80a3dfdc5ac89c1e4d615d6f29a495855fb:
     Disable implicitly collecting baseline coverage for toolchain
     targets.
   + 302971e1b3d803069ac949c0085c0d2a3916c8ab:
     Automated rollback of commit
     7d09b4a15985052670244c277e4357557b4d0039.
   + 62002024ca7012ffe0f4fc74ac20b5471513c8c8:
     Bzlmod: Starlarkify default attr values for TypeCheckedTags
   + 38117d491cbc4a5686e0bdb1e58f8946d96aed58:
     Fix build after rc4 cherrypicks (#14581)
   + 41feb616ae18e21fdba3868e4c298b0b83012f10:
     Release 5.0.0 (2022-01-19)
   + 486d153d1981c3f47129f675de20189667667fa7:
     Find runfiles in directories that are themselves runfiles
   + 0de7bb95022057e8b89334f44759cf6f950e131f:
     Don't resolve symlinks for --sandbox_base
   + 8b60c90f3641591b65c4e153113aea562f1fab94:
     Remove uses of -lstdc++ on darwin
   + 60f757c0831f9fbb2415fb0105f964201faa9fa0:
     Allow Label instances as keys in select (#14755)
   + 3836ad029f202ca13c64c9f07e4568ea8ab2d9a6:
     Remote: Only waits for background tasks from remote execution.
   + 8734ccf9847eafb7193388cd9c6fa78faa78283f:
     Add the default solib dir to the rpath for cc_imports with
     transitions
   + 9e16a6484e94c358aa77a6ed7b1ded3243b65e8f:
     Flip --experimental_worker_allow_json_protocol
   + fce7ea8d5e0facfc125ae7c37bfb4b9a7c586e40:
     Fix `ctx.fragments.apple.single_arch_cpu` returning incorrect
     cpu for tools when host cpu and exec cpu are different
   + 0c1d09e4dce4c3251c2be2c70d4575ec65b1d9d3:
     Propagate --experimental_cc_implementation_deps to host config
   + 1c3a2456c95fd19974a5b2bd33c5ebdb2b2277e4:
     Support select() on constraint_value for aliases.
   + 67a133b431ccece22b7dd9a72f0837cff77d4360:
     Improve documentation for select()
   + 5356fedd4b6079851b51db27077bf84c7bab16a4:
     Cherrypicks for experimental cc_shared_library (#14773)
   + ffdd633d7b9f21267f4f9759dd9833096dd4e3a2:
     [apple] support tvos_sim_arm64 in toolchain (#14779)
   + a58ddea50b2fd476d183e2e0c077ad6173039b89:
     Cherry pick win arm64 (#14794)
   + dc41a20bb045d221a43223a5db6b8b44cd8f1676:
     [5.1.0] cherrypick subpackages support (#14780)
   + 86e2db7d67ec52bfe11c1f517f650653cee3ea26:
     Add a helper method for rules to depend on the cpp toolchain
     type.
   + 6990c02644a71d5e7c95c9c234ecf39bb55c6ac4:
     UrlRewriter should be able to load credentials from .netrc
     (#14834)
   + 32d1606dac2fea730abe174c41870b7ee70ae041:
     Add "arch" struct field to repository_os
   + 2cfdceae971d09f50ceddc3d7ef723fb5f879957:
     [5.x] bzlmod: Add support for WORKSPACE.bzlmod (#14813)
   + c2ddbd1954af5baab63b93f2b055a410a27832c8:
     Ignore missing include directory in JDK distribution.
   + 16de03595e21f7bf31818e717505b23c953b3b7d:
     Fix bazel coverage false negative
   + 0c74741742301abcf67452a7f591daec1c3a7635:
     Remote: Postpone the block waiting in `afterCommand` to
     `BlockWaitingModule` (#14833)
   + 3297d9234e15515aa91cc887b3b12db7e1040b02:
     Switch to `ProcessHandle` for getting the PID (#14842)
   + a987b98ea0d6da2656c4115568ef9cbe8a164550:
     Fix uses of std++ on bsd
   + d184e4883bb7fc21de2f7aeea4304994de27e9ea:
     Remote: handle early return of compressed blobs uploads
   + 0b09e9e018c557da04c9f978d25a66d963cd6cb6:
     Add removeprefix/removesuffix to Starlark strings
   + d42ab0cfcce56b5e55c8bd94d0923d08758fdb5b:
     Fix default CPU for macOS and iOS (#14923)
   + cd24f39750d7b08f6f31c82d3a23cc329c7fc78e:
     Add paramfile support for def_parser, since in rare cases on
     Windows command line character limit was reached.
   + 0b1beefd1e7611dc9b9f559d00d8ff76aabb0f32:
     Normalize rpath entries to guard against missing default solib
     dir
   + 24e82426e689853b0d9a04e7b9b6f13e145cf2d6:
     Fix aggressive params file assumption
   + c45838bd3e51bcd0c8c3e1a9b4a0e55cdf4b4f59:
     Fix precompiled libs not in runfiles of cc_shared_library
     (#14943)
   + 764614e0f0287125269e7a92e909a44624bcb360:
     Bzlmod: Allow multiple `use_extension`s on the same extension
     (#14945)
   + fa761f84994f18db383fbe9aaea524e4385da13a:
     Fix typo in `apple_common.platform` docs
   + f7d8288bd7b16c7f2e010aa8ddc241cf2ba8e0d5:
     Yield a Proxy for addresses without protocol
   + 8cefb8bed4ac82df8640682517372a9249732352:
     Avoid merging URLs in HttpUtils
   + b4804807fc2c184cc36df9e69e472942c01941b8:
     Make protocOpts() public. (#14952)
   + 113eaca5862c48797654ae2a3acbb6e15d761485:
     Do not hide BulkTransferException messages when there were more
     than one exception
   + b1bf9d6c5f85fc4fda0dc48bc3d3e2fe26880867:
     merkle_tree_cache: change default size to 1000
   + f15e0c7224ecc5473d4972afc436e28df35c4e5a:
     Add --experimental_repository_cache_urls_as_default_canonical_id
     to help detect broken repository URLs (#14989)
   + f4214746fcd15f0ef8c4e747ef8e3edca9f112a5:
     Expose the logic to read user netrc file
   + b858ec39aebd7e586af5438aa2035db2adebf9a4:
     Correct cpu and os values of `local_config_cc_toolchains` targets
   + 5e79972c05d89280f0cf1fa620f807366847bac6:
     Expose CoverageOutputGenerator on a Fragment (#14997)
   + 78f03110e0dab42f37e427fd524e72706e036d74:
     Correct error runfiles cc_shared_library (#14998)
   + 7937dd14c3c632ffcfaea9073d5dec6dcac93845:
     [5.1] Adding Starlark dependencies to the package //external
     (#14991)
   + a73aa12be65454ac8cfb5a8f3e056c420402f997:
     Remote: Fix crashes with InterruptedException when using http
     cache.
   + f8707c07f153ac4ac2ec4b210321f1a16343006d:
     Account for interface libraries in cc_shared_library
   + a570f5fdb1618a6c272d18bebaa712d3b2af3975:
     Fix coverage runfiles directory issue
   + 95de355e4524a6339c0e807b60d333c36c40bdc7:
     Do not validate input-only settings in transitions (#15048)
   + 71747ccc9d0032a865854613329362563c0574df:
     Filter out system headers on macOS.
   + cb6500a9ce648a02154dca8d05a978ce9b10c4b4:
     Update Bazel bootstrap documentation and remove obsolete flags.
     (#15065)
   + 4c031d1030afb1cb48c7e6d71f83cc99fea607c1:
     [5.1] Undocument --bes_best_effort (#15066)
   + 267142f3dc6b8d32b07beb21e3b4ba6f471a69d8:
     Fix conflicting actions error when specifying
     --host_macos_minimum_os (#15068)
   + f1923627e85b1c1d60bcd928f90f116c3ade7a3a:
     [5.1] Remote: Action should not be successful and cached if
     outputs were not created (#15071)
   + 00d74ff737cccd60305ee58d85313556a077152a:
     Support decompressing zstd tar archives for repository rules.
   + f5857830bb68bd05ffc257506575ed37a8128933:
     Remote: Don't check TreeArtifact output
   + efb2b80953983dce499d453a9f55a74ffaf8c42d:
     osx_cc_wrapper: Only expand existing response files
   + c771c43b870fb8618db7bdab6725ab40cac4976d:
     Remote: Fix crashes by InterruptedException when dynamic
     execution is enabled. (#15091)
   + 3785677cc84fc4024fda85575c05efbde5d512fc:
     Use python3 on macOS
   + 815d9e499a32fd4d87525ac0c698c293cf26433d:
     Release 5.1.0 (2022-03-24)
   + 1fbb69e366034484887e00c6006c7b79508765ed:
     Prepare 5.1.1 release
   + df153df9656e0e197f67622bb11f7d77e19238a0:
     Fix CODEOWNERS syntax
   + 2b92a3111e83a4d14934059afd0f51161a41276f:
     Remote: Don't check declared outputs for failed action
   + b47aa71b21d93c9499103e9a37a6c2ffa79865b9:
     Upgrade abseil version to the latest
   + c49c45d8dac87d21cf2b6a176ddd07f2c9f63414:
     Revert default export all symbols on Windows
   + 7d3fb993f55b35081786c3fe00cf3bebb89574f3:
     Support ZIP files with total number of disks = 0
   + 0f5dc111be06b2ee8694640f400b58e12bfa5fea:
     Release 5.1.1 (2022-04-08)
   + 2422cfb3e5d92d46f9065b2b1e442823a965faf7:
     Update CODEOWNERS
   + bbcff1802423fca7ee5bd6a3e527c12d6d7d80ba:
     [5.2.0] Update java_tools 11.7.1 (#15231)
   + 9c98120f33579b72561e02826d9fccf222eccb3c:
     Add support for .ar archives (and .deb files)
   + d3435b09d89f25bf5008ef3b9c870c835d51a8da:
     Seperate GetSelfPath implementation for Blaze and Bazel
   + c94572bea5ce6bdc0ccda9789e5be6fb3f4c173b:
     Include jdk.crypto.mscapi in minimized Windows embedded JDK
   + 299022ca2dc49b6cb27b2674f933755306ae8b9b:
     remote: Proactively close the ZstdInputStream in
     ZstdDecompressingOutputStream.
   + 27707995cc6576ed1f51fbdb199ff8512e8418c9:
     Collect coverage from cc_binary data deps of java_test
   + 3442179d240e01ef13b0fa7814db7366bad5ffac:
     Configure Apple crosstool to return a complete target triple
     that includes minimum OS version and target environment
   + bb6f1a7ce79168055ccd62629da07d46a52b930d:
     Collect C++ lcov coverage if runtime object not in runfiles
   + dbb6e9954b6e4423f727feb2719ffc75a93b514b:
     Fixing dependencies of //external package
   + f0213bbf730c4a5d1a31e65bc9c01fbb55a6edb3:
     [5.2] Upgrade Google Auth Version (#15383)
   + a1a74c9919e03e09ef7c6ae13f38f48eea80ead1:
     Fix chocolatey package - docsUrl must not 404 (#15395)
   + fe644bee95c14d461e0d1e3cccaa8bbcd57bcd8d:
     Fix cache leak when applying transitions when only a rule's
     attributes change.
   + ad74d5243917bb27a37e38d151a4a3c8a49947eb:
     Fix checking remote cache for omitted files in buildevent file
     (#15405)
   + ac219103d8798965b775db548d7b9214ecd78f73:
     fix(bzlmod): throw on json parse exception
   + 3d85b88609a362857d8ee3c0432a37d30268a8a2:
     Add a flag to expose undeclared test outputs in unzipped form.
     (#15431)
   + abd7a9f70c3dfe96724a692dc7dc04ff33bdece1:
     Remove -U_FORTIFY_SOURCE when thin_lto is enabled (#15433)
   + 53b9cb8637c0faddc6b122a1daab72bcc274bdec:
     Catch NumberFormatException while trying to parse thread id.
   + 19740b55ebc283b7ec42b359bcd4c9096facfdd5:
     Improve the --sandbox_debug error message
   + 0a2a43f9aab1e3875f03f643f6414eb67834c883:
     Set keywords on appropriate lifecycle events.
   + 394ddb82b311ea7edbe2522736b0b0202903ddb6:
     Record additional profiling information for remotely executed
     actions.
   + 652b48e567fcb30768dfc2eddee5f04bf6b5d65b:
     Fix downloading remote execution output files inside output
     dirs. (#15444)
   + 73f1ecbc1cb00e16ceda4b582f4d57268f8701cd:
     Fix android emulator darwin_arm64 select
   + 2649c7c4adef0ebf9bca8fe46aa97304b22de522:
     Fix --use_top_level_targets_for_symlinks with aliases (#15446)
   + fa1081c1f3dce7324a1da59c40d1a1a3533c7047:
     Filter libtool warning about table of contents
   + 26f878325e915e0905626a0e4c8bbacffd72f875:
     Unify sandbox/remote handling of empty TreeArtifact inputs
     (#15449)
   + 6b21b7773157a1eebd3dfe79ff4c4ee750059daf:
     Revert "Fixes incorrect install names on darwin platforms"
   + e133e66f715bac17bf5848e4440c089a8c8d3fd9:
     config doesn't error on duplicate `--define` values (#15473)
   + 84d59176622b76223828e61709179dbd5f0c9f8d:
     Collect coverage from cc_binary data deps of py_test (#15298)
   + 519d2daacfff3de6ffabfc5827621fa835e1c815:
     SolibSymlinkAction does not need exec platform or properties
   + 6e54699884cfad49d4e8f6dd59a4050bc95c4edf:
     Let Starlark tests inherit env variables (#15217)
   + 9610ae889e6fd45280c5beb7fe8f5bef2d736878:
     Update PythonZipper action to use CommandLineItem.CapturingMapFn
   + 2f1ff6fa17c3c30b2533bffe81f40eab06b453b9:
     Make `coverage --combined_report=lcov` skip incompatible tests
   + 9fad5a3dc93cd436a5712c46e6c98d3995428ddb:
     Disable ReturnValueIgnored checks to unblock java_tools release
   + 0120118893261968bdf116ef215655c428428fa8:
     Bump the limit of Bazel install base size (#15585)
   + 668805aace9bf96f78595fc2a122027a3000ceac:
     Upgrade zlib to 1.2.12
   + 4d900ceea12919ad62012830a95e51f9ec1a48bb:
     [5.2] Remote: Fix a bug that outputs of actions tagged with
     no-remote are u... (#15453)
   + b703cb9b999e243d776b7620468e48f450c0ce3a:
     Add feature to produce serialized diagnostics files (#15600)
   + 2e8458b7810eab7829fc7d28af5c45b9af91ed7c:
     Release 5.2.0 (2022-06-07)
   + 536f8d97991d891fc7db333af1a5262497d85173:
     Fix fail message construction in cc_shared_library
   + 2d42925ae80c0fb007aa39f4e210122611897255:
     Define cc-compiler-darwin in Xcode toolchain
   + a1d7d1f69f82da1bdfa1cebd32356249127aea3b:
     Fix alwayslink in objc_import
   + d273cb62f43ef8169415cf60fc96e503ea2ad823:
     Unify URL/URLs parameter code across http_archive, http_file,
     http_jar
   + fea32be42928c84463aa1f335b5722a1f6b8c93a:
     Preserve --experimental_allow_unresolved_symlinks in exec cfg
   + e4bc370b226eb0cc536b55641640266345a214ec:
     Ck/cherry pick cc shared library (#15754)
   + dbdfa07e92f99497be9c14265611ad2920161483:
     Let Starlark executable rules specify their environment (#15766)
   + e2a6a2b130552db7521d3d4d854b9a651b1f4a3b:
     Fix string formatting when java_home path is missing.
   + d54a288e6c79c740b9c93dfc31ee345d6a5332af:
     Optionally enable LLVM profile continuous mode
   + ad17b44cdc192277fafb0d0e204962b2b924dba8:
     Print remote execution message when the action times out (#15772)
   + 240e3d1e1dbc74c7753dead6421d7c1b5fc28d09:
     Add missing line to cherrypick
     e4bc370b226eb0cc536b55641640266345a214ec (#15784)
   + 804b4747152a59bc2965be2db85839b8b2764fc7:
     Replace strdupa with strdup
   + 62be9ea29295fab5289bd5d1a0f13dc7d55a8bc0:
     Bzlmod: Better canonical repo names for modules with overrides
     (#15793)
   + d4663a1c950d618c5b15a3e00fb733987cbf45cc:
     Add repo env test (#15768)
   + 594962cb283dcd71b736e0450453903911a8c85a:
     Add is_root struct field to bazel_module (#15815)
   + 3dd2b932d42fe86112899550d21452409cb3c4b0:
     Fix null pointer crash with `bazel coverage` on only
     incompatible tests
   + 4175018b47800db28c390d39fefbd266b5d674bd:
     Add util for finding credential helper to use
   + 3ea9eb2e363860c9305a987fa22a059afd35598d:
     Merge ManifestMergerAction-related commits into release-5.3.0
     (#15824)
   + 64571a428ffe2bf09f1a5eea13e770a7d0381620:
     Ck/cherrypick 15669 (#15788)
   + 1404651cafe5c26c5dae469e9126de53c2f4f024:
     Create output directories for remote execution (#15818)
   + ae523f82d39daf01cf31e40733de0c6345f0935c:
     Use tree artifacts in bootclasspath rule
   + 37f181cb6ed0237f43d81159eb81b19d3b5f8e36:
     [credentialhelper] Add types to communicate with the subprocess
   + 06ca634e10f17023022ab591a55aabdd9fb57b12:
     Add a flag to force Bazel to download certain artifacts when
     using --remote_download_minimal (#15870)
   + d35f923b098e4dc9c90b1ab66b413c216bdee638:
     RemoteExecutionService: fix outputs not being uploaded
   + 78af34f9f25b0c8fbf597a794a5162f0014629c5:
     Cherry-pick proto_lang_toolchain Starlarkfication and
     proto_common module (#15854)
   + afb434da9da79b53da1ea4c7bcc00571dbea6d3f:
     Fix behavior of `print()` in module extensions
   + 6714c30507edc70ec84f8c97d47cffc497356c0b:
     [credentialhelper] Implement invoking credential helper as
     subprocess
   + 0f05904171d187e6abacb431b3d7494423b027ab:
     Add register_{execution_platforms,toolchains} directives to
     MODULE.bazel files (#15852)
   + 33516e27dc6ee6ab5c3b9dee739a267b08d26b6c:
     [remote] Improve .netrc test in RemoteModuleTest
   + aa2a1f3afe2f10baab5befcafb39df14cbffc743:
     Fix ZipDecompressor windows 0x80 (file attribute normal)
   + 30f16e53cb36a5d506665be7553e785d52772e2d:
     Replace uses of `cfg = "host"` with `cfg = "exec"` (#15922)
   + 2a8d0ad7103511a94382aef41821a315bf8144b7:
     target pattern file: allow comments
   + 6f732052654ec37192450c795bb28dd0aad559cd:
     Add factory for creating paths relative to well-known roots
     (#15931)
   + 32cc8e638b91816f427b74266f6a8da6fb605419:
     Update CODEOWNERS (#15910)
   + 63bc14b095f1ea4043024e7fe1f9c476968897c5:
     Implement native analysis_test call. (#15940)
   + 4df77f771e5cfdf4b614afd8934d00c2b2ff31d1:
     Increase osx_cc_configure timeouts
   + cdf01a39ab9def4d46f41595ac1ac9206a96d6f8:
     Allow string_list flags to be set via repeated flag uses
   + 05e758d4bc18fc9d9e189526381a06e4399056a2:
     [credentialhelper] Add parser for flag syntax (#15929)
   + e4ee34416ef18094496ab54446e70cb62cd509e6:
     Docs should mention the new no-remote-cache-upload tag (#15965)
   + 96d23d30cc80912b82a8fbab31c902e9db74b6ab:
     Add netrc support to --bes_backend (#15970)
   + c5bc34e5f1dd92703dd8f15f9f0409c49b778837:
     Add CommandLinePathFactory to CommandEnvironment (#15971)
   + 508f18576ab5327bd623db6b476511ac2089d0fa:
     Move newCredentialHelperProvider into GoogleAuthUtils (#15973)
   + 14c944a5386eccbcfbe8389afb6c518582b11270:
     Wire up credential helper to command-line flag(s) (#15976)
   + 04c373b708390341be4ceb8eb5b2f8561385cb11:
     Add `--output=files` mode to cquery (#15979)
   + edfe2a17e3434cce660757f59b14f2e9d6ab944e:
     Make cpp assembly file extensions case sensitive again
   + 4ae85387e69db73e507b4f18b36d3e2f799e5d34:
     Prevent aspects from executing on incompatible targets (#15984)
   + f440f8ec3f63e5d663e1f9d9614f05a39422102a:
     Remote: Fix performance regression in "upload missing inputs".
     (#15998)
   + 0109031a2818b217b78026055b972da5901656f5:
     Updated Codeowners file (#16032)
   + 6102d33bf0b72dc0fe9ada4c71113cbee3eb8187:
     Propagate the error message when a credential helper fails.
     (#16030)
   + a8dacc7832b04fe1756cd7adce72f2572f357eee:
     Migrate legacy desugar wrapper to new rlocation() (#16025)
   + 11368be4ac24108f18b1965162ad27f207c074f9:
     Correctly report errors thrown by CommandLinePathFactory#create.
   + 82452c7c372fb28485b0b5e0a98b471648f0dfd0:
     Fix an issue that
     `incompatible_remote_build_event_upload_respect_no_… (#16045)
   + e745468461f93839491a4f80d0c1883d9007f9c0:
     Fix rpath for binaries in external repositories (#16079)
   + 83041b145d3966eb353aacb22b7e33ad01d9a239:
     Refactor combined cache. (#16110)
   + c62496f7b76da473cb1102798373f552ba2f434d:
     C++: Add compound error linked statically but not exported
     (#16113)
   + 0f18786b09e9729d79c0f14f7843b4d8402b6115:
     Do not crash on URIs without a host component.
   + 9c0940df3c5962b2291e812600dd71731775d45b:
     Add profiler task for calling a credential helper.
   + 2ca1ab2c2c73d78021794f3099ee892cc73f515e:
     Make bazel_cc_code_coverage_test more robust against GCC version
     differences (#16254)
   + 1e25152906b668bbe56aa4c1773186af85335315:
     Fix local execution of external dynamically linked cc_* targets
     (#16253)
   + f6cccae5b6f9c0ad0e7d0bf7bd31ea1263449316:
     * add change to allow blaze info to skip Starlark build settings
     that start with --no prefix * add unit tests for both info and
     clean commands
```

Important changes:

  - alias() can now select() directly on constraint_value()
    
    Fixes https://github.com/bazelbuild/bazel/issues/13047.
    
    Closes #14310.
  - Fixed an issue where Bazel could erroneously report a test passes
    in coverage mode without actually running the test.
  - Make protocOpts() publicly accessible.
  - Add coverage configuration fragment, used to expose
    output_generator label.
  - Bazel now no longer includes system headers on macOS in coverage
    reports (#14969).
    
    Closes #14971.
  - Starlark test rules can use the new inherited_environment
    parameter of testing.TestEnvironment to specify environment
    variables
    whose values should be inherited from the shell environment.
    
    Closes #14849.
  - none
    RELNOTES:none
  - Enable merging permissions during Android manifest merging with
    the --merge_android_manifest_permissions flag.
  - Added new register_{execution_platforms,toolchains} directives to
    the MODULE.bazel file, to replace the
    {execution_platforms,toolchains}_to_register attributes on the
    module() directive.
  - Add support for fetching RPC credentials from credential helper.
    
    Progress on https://github.com/bazelbuild/bazel/issues/15856
    
    Closes #15947.
  - `cquery`'s new output mode
    [`--output=files`](https://bazel.build/docs/cquery#files-output)
    lists the output files of the targets matching the query. It
    takes the current value of `--output_groups` into account.
    
    Closes #15552.
  - Fix for desugaring failure on Bazel+Android+Windows build
    scenario.

This release contains contributions from many people at Google, as well as amberdixon, Andreas Fuchs, Benjamin Peterson, Brentley Jones, Chenchu Kolli, Dan Fleming, Danny Wolf, Emil Kattainen, Fabian Meumertzheim, Gowroji Sunil, hvadehra, Juh-Roch, Keith Smiley, kshyanashree, Niyas Sait, Noa Resare, Oliver Eikemeier, oquenchil, Peter Mounce, Philipp Schrader, Ryan Beasley, Thi Doãn, Xùdōng Yáng, Yannic, Zhongpeng Lin.

## Release 6.0.0-pre.20220909.2 (2022-09-15)

```
Baseline: d3bef49f9182f6bcb6f609530970a7945ce51cbf
```

Incompatible changes:

  - analysis_test moved into testing.analysis_test

Important changes:

  - selects() no longer produce irrelevant duplicate label checks
  - Adds a dexer output cache to CompatDexBuilder to improve build
    speed.
  - Improved error messages when analyzing inline bzl code
  - Improved error messages when analyzing inline bzl code

This release contains contributions from many people at Google, as well as Alessandro Patti, Benjamin Peterson, Charles-Francois Natali, Emil Kattainen, Fabian Meumertzheim, James Broadhead, jheaff1, kshyanashree, Noa Resare, Philipp Schrader, Shuai Zhang, Xavier Bonaventura.

## Release 6.0.0-pre.20220825.4 (2022-09-15)

```
Baseline: c92d0e1c0bfbc2573104ff09d8dec282e85cafa1

Cherry picks:

   + e898060863fa0579d45f67c2c998b6ef5289199b:
     Automated rollback of commit
     14a0d830b95ca1a3f15baa3f76d8aa55afa2fe20.
```

Important changes:

  - --experimental_enable_bzlmod has been renamed --enable_bzlmod,
    and still defaults to false.

This release contains contributions from many people at Google, as well as Benjamin Peterson, Ed Schouten, Igor Nazarenko, John Millikin, Ken Micklas, Yannic.

## Release 6.0.0-pre.20220823.1 (2022-09-01)

```
Baseline: ca95fecde07a28736ea815ec64bcd639a234d79c
```

This release contains contributions from many people at Google, as well as Benjamin Peterson, Fabian Meumertzheim, Thomas.

## Release 6.0.0-pre.20220818.1 (2022-08-24)

```
Baseline: 62d1b0b2b6c9646855698b5d7f9515521bc37a45
```

Incompatible changes:

  - this incompatible change breaks old instances of http_archive
    that specified netrc as an absolute path. It is unlikely there
    are many instances in the wild since the path would refer to a
    netrc file inside the external repository by absolute path.
    Migration should be straightforward.
  - genrule switched to use exec transition instead of host. This can
    break targets with hardcoded output paths. To avoid using
    hardcoded paths use make variables, see
    https://docs.bazel.build/versions/4.2.2/be/make-variables.html#pre
    defined_label_variables
  - this incompatible change breaks old instances of http_archive
    that specified netrc as an absolute path. It is unlikely there
    are many instances in the wild since...
  - Error Prone now checks for unused return values of additional
    methods on `java.lang.Object`, which can be disabled using
    `--javacopts=-Xep:ReturnValueIgnored:OFF`
  - Error Prone now checks for unused return values of additional
    methods on `java.lang.Object`, which can be disabled using
    `--javacopts=-Xep:ReturnValueIgnored:OFF`
  - The --incompatible_existing_rules_immutable_view flag has been
    flipped to true. See
    https://github.com/bazelbuild/bazel/issues/13907 for
    migration notes.
  - Split up the C++ archive from the C++ link action and set
    `CppArchive` as mnemonic.
  - workspace(managed_directories=) is not available anymore.
  - --legacy_important_outputs now has a default of false.
  - --legacy_important_outputs default reverted to true.
  - objc_library now requires CcInfo in its deps.  If this breaks
    you, add empty CcInfo() to your rule.
  - Flag --experimental_local_memory_estimate removed.
  - Added a new flag
    --incompatible_unambiguous_label_stringification, which causes
    labels in the main repo to stringify into unambiguous forms
    starting with an @. See
    https://github.com/bazelbuild/bazel/issues/15916 for more
    information.

Important changes:

  - Deprecate --incompatible_applicable_licenses flag, in preparation
    for removal in Bazel 6.x.
  - Treat py_*.srcs_version="PY2" the same as "PY2ONLY".
  - The Build Event Protocol now contains file digests and sizes
    along with the file name and URI.
  - Refactor system suspend event handling.
  - alias() can now select() directly on constraint_value()
  - Allow \a \b \f \v escape sequences in Starlark.
  - Match remote and local xcode version by most granular version.
  - Adds `--experimental_worker_multiplex_sandboxing` flag that
    controls whether to sandbox multiplex workers that support it.
  - provider() has a new parameter: init, a callback for performing
    pre-processing and validation of field values. Iff this parameter
    is set,
    provider() returns a tuple of 2 elements: the usual provider
    symbol (which,
    when called, invokes init) and a raw constructor (which bypasses
    init).
  - Tests that fail to create or complete their
    `TestAttemptContinuation` by
    throwing an `ExecException` will report an `INCOMPLETE` status.
    Previously, Bazel
    would fail to report any status for the test attempt.
  - Fixed an issue where Bazel could erroneously report a test passes
    in coverage mode without actually running the test.
  - Include more information about configurations in cquery proto
    formatted output. This deprecates the configuration field of
    AnalysisProtosV2.ConfiguredTarget, and adds a new field,
    configuration_id, to
    be used instead.
  - experimental cc_library.implementation_deps inverted to
    interface_deps
  - In aquery and cquery proto output, indicate if a configuration is
    a
    tool or non-tool configuration.
  - Include complete configurations in cquery proto output.
  - experimental cc_library.implementation_deps inverted to
    interface_deps
  - Make protocOpts() publicly accessible.
  - Add some documentation about how configuration information is
    conveyed in cquery proto output.
  - Introduces experimental static library linking API under
    apple_common.link_multi_arch_static_library
  - Further deprecation and removal of pkg_tar. Stop supporting
    legacy use of 'files' attribute, where it could be a list of
    labels instead of a map of paths to labels.
  - Removed --incompatible_no_build_defs_pkg flag. It never fulfilled
    its purpose because --all_incompatible_changes would never set
    it. The last rule it gated (pkg_tar) is scheduled to be removed
    in Bazel 6.x.
  - Add coverage configuration fragment, used to expose
    output_generator label.
  - Bazel now no longer includes system headers on macOS in coverage
    reports (#14969).
  - android_sdk_repository read $ANDROID_SDK_ROOT in addition to
    $ANDROID_HOME.
  - The default dexer is now d8. dx can be optionally enabled using:
      --define=android_dexmerger_tool=dx_dexmerger \
      --define=android_incremental_dexing_tool=dx_dexbuilder \
      --define=android_standalone_dexing_tool=dx_compat_dx \
      --use_workers_with_dexbuilder
  - Packaging support for deploy JAR embedded JDK files (hermetic
    Java).
  - Don't stamp cc_common.link actions for tool dependencies.
  - Starlark test rules can use the new inherited_environment
    parameter of testing.TestEnvironment to specify environment
    variables
    whose values should be inherited from the shell environment.
  - Enable merging permissions during Android manifest merging with
    the --merge_android_manifest_permissions flag.
  - Allow specialization to work with constraint_values.
  - Bazel uses the D8 jar from Maven instead of the SDK.
  - Make ijar / java_import preserve classes with `@kotlin.Metadata`
    annotations
  - Switch cc_test implementation to Starlark. Note: cc_test will now
    link statically when _targeting_ Windows regardless of host
    platform (rather than always linking statically when Windows is
    the _host_).
  - Switch cc_test implementation to Starlark. Note: cc_test will now
    link statically when _targeting_ Windows regardless of host
    platform (rather than always linking statically when Windows is
    the _host_).
  - Add devtools/build/lib/worker:work_request_handlers to the remote
    android tools release package. This will be transitively packaged
    into all_android_tools.
  - Bazel uses the D8 jar from Maven instead of the SDK.
  - android_sdk_repository read $ANDROID_SDK_ROOT in addition to
    $ANDROID_HOME.
  - Advance android_tools_pkg version to 0.24.0.
  - Switch cc_test implementation to Starlark. Note: cc_test will now
    link statically when _targeting_ Windows regardless of host
    platform (rather
    than always linking statically when Windows is the _host_).
  - Bazel uses the D8 jar from Maven instead of the SDK.
  - "blaze config" now only reports info from the last build. To
    compare configurations across multiple builds, redirect "blaze
    config" output to a file and run your favorite diff tool.
  - The --incompatible_override_toolchain_transition flag is now
    always set, and will be removed in the future. Thus,
    --noincompatible_override_toolchain_transition has no effect, and
    the value of the incompatible_use_toolchain_transition parameter
    in aspect() and rule() builtins is ignored.
  - Switch cc_test implementation to Starlark. Note: cc_test will now
    link statically when _targeting_ Windows regardless of host
    platform (rather
    than always linking statically when Windows is the _host_).
  - Toolchain types may now be optional, in addition to mandatory.
    See https://bazel.build/docs/toolchains#optional-toolchains for
    further details.
  - Add six to deps of has_services=1 py_proto_librarys.
  - pkg_tar(symlinks) has been removed. Users needing that feature
    should
    migrate to @rules_pkg.
  - Aspects can now define and use exec groups using the same API as
    rules.
  - Removed the obsolete --incompatible_applicable_licenses flag. The
    feature is permanently enabled.
  - embedded_tools packages R8 desugarer again
  - Bazel now selects sh path based on execution platform instead of
    host platform, making it possible to execute sh actions in
    multiplatform builds. --shell_executable now only applies to
    actions configured for host.
  - labels in genquery.scope are no longer configured.
  - When Bzlmod is enabled, all Bzlmod-generated repos will have an
    extra '@' prepended to their names. This effectively enables the
    canonical label literal syntax for Bzlmod-generated repos
    (`@@canonicalRepoName//pkg:target`; see
    https://docs.google.com/document/d/1N81qfCa8oskCk5LqTW-LNthy6EBrDo
    t7bdUsjz6JFC4/edit?usp=sharing).
  - Exposed `CcSharedLibraryInfo` to Starlark builtins.
  - Enable --use_top_level_targets_for_symlinks by default.
  - Singlejar accepts runtime Created-By field
  - --noincompatible_disable_managed_directories, and with that,
    workspace(managed_directories=) is not supported anymore.
  - Bazel supports D8 desugaring, albeit without persistent workers
  - Remove mtime options from pkg_tar. Users should migrate to
    @rules_pkg.
  - Test for experimental multiplexed persistent resource processor.
  - Added new register_{execution_platforms,toolchains} directives to
    the MODULE.bazel file, to replace the
    {execution_platforms,toolchains}_to_register attributes on the
    module() directive.
  - The legacy pkg_tar no longer supports the ability to untar and
    repackage an input tar file (`deps` attribute). Users needed that
    capability must switch to github.com/bazelbuild/rules_pkg.
  - `cquery`'s new output mode
    [`--output=files`](https://bazel.build/docs/cquery#files-output)
    lists the output files of the targets matching the query. It
    takes the current value of `--output_groups` into account.
  - Change singlejar metadata to report Created-By Bazel
  - Add support for fetching RPC credentials from credential helper.
  - Revert interface_deps back to implementation_deps after problem
    reported in. Use `buildozer 'rename deps implementation_deps'
    //...:%cc_library; buildozer 'rename interface_deps deps'
    //...:%cc_library`
  - Fix for desugaring failure on Bazel+Android+Windows build
    scenario.
  - D8 is the default desugarer
  - Migrate main_dex_list_creator to D8 (DX deprecation)

This release contains contributions from many people at Google, as well as Adam Azarchs, Adam Wolf, Albert Lloveras, Alessandro Patti, Alex Eagle, Alex Scott, Alex Torok, Andreas Fuchs, Andreas Herrmann, Andrew Katson, Andrew Klotz, Ara Nguyen, arunkumar9t2, arun.sampathkumar, Ast-x64, Benedek Thaler, Benjamin Lee, Benjamin Peterson, Ben Lee, Bohdan Vanieiev, Bradley Burns, Brandon Duffany, Brandon Jacklyn, Brentley Jones, Brentley Jones, Chad Miller, Chris Clearwater, Chris Fredrickson, Christopher Peterson Sauer, Christopher Sauer, ckiffel, Cristian Hancila, crydell-ericsson, Dan Fleming, Daniel Wagner-Hall, Danny Wolf, David Ostrovsky, David Sanderson, Denys Kurylenko, dhmemi, Dimi Shahbaz, divanorama, dmaclach, Ed Schouten, Emil Kattainen, Eric Song, Fabian Brandstetter, Fabian Meumertzheim, floriographygoth, Fredrik Medley, George Prekas, gkgoat1, gkorlam, Greg Estren, Greg, Greg Roodt, Grzegorz Lukasik, Halil Sener, Hannes Kufler, homuler, hvadehra, hvd, Jan, Jason Tan, Jay Bazuzi, Jeremy Volkman, jheaff1, Jiawen Chen, Joel Williamson, John Laxson, John Millikin, Jonathan Gerrish, Jon Shea, juanchoviedo, Kaiqin Chen, Keith Smiley, Ken Micklas, Kevin Lin, Krishna Ersson, lihu, Luc Bertrand, Luis Fernando Pino Duque, Marek uppa, Matt Clarkson, Matt Mackay, Michael P. Nitowski, Mikhail Balabin, Mostyn Bramley-Moore, Nick Korostelev, Nitesh Anandan, Niyas Sait, Noa Resare, Oscar Bonilla, Patrick Balestra, Paul Tarjan, Peter Mounce, Philipp Schrader, Pras Velagapudi, Rahul Butani, Rifqi Mulya Fahmi, Roman Salvador, rustberry, Ryan Beasley, Ryan Schmidt, Sahin Yort, Saleem Abdulrasool, Simon Bjorklen, Son Luong Ngoc, Stephan Wolski, Steve Vermeulen, Stiopa Koltsov, Sven Tiffe, Takeo Sawada, Tao Wang, Ted Kaplan, Tetsuo Kiso, Thi Doan, Thomas Chen, ThomasCJY, Thomas Zayouna, Timothe Peignier, Tomas Volf, Tom de Goede, Ulf Adams, Ulrik Falklof, Vasilios Pantazopoulos, Vladimir Tagakov, William Muir, Xavier Bonaventura, Xdng Yng, Yannic Bonenberger, Yannic, Yesudeep Mangalapilly, Yuval K, Zhongpeng Lin.

## Release 5.3.0 (2022-08-22)

```
Baseline: 8d66a4171baddcbe1569972f019e54130111202c

Cherry picks:

   + becd1494481b96d2bc08055d3d9d4d7968d9702e:
     Remote: Cache merkle trees
   + d7628e1b566be353fe7172241ac8f15d5f8e7ff5:
     Update DEFAULT_IOS_CPU for M1 arm64 simulator support
   + 80c56ff7b603fcfff02a5f97829a2a5935f360a0:
     Compile Apple tools as fat binaries if possible
   + 3c09f3438a966b49a7c1726022c898b390b3a6e5:
     Add protobuf as a well known module
   + 3a5b3606a6f5433467a5b49f0188c41411684bf5:
     Remote: Merge target-level exec_properties with
     --remote_default_exec_properties
   + 917e15ea408e1d3d25574edbb466b39cfbcb61fe:
     Add -no_uuid for hermetic macOS toolchain setup
   + f5cf8b076bc913dbe021104d5f6837fb4a6cd8b3:
     Remote: Fixes an issue when --experimental_remote_cache_async
     encounter flaky tests.
   + 77a002cce050e861fcc87c89acf7768aa5c97124:
     Remove DigestUtils.getDigestInExclusiveMode() now that SsdModule
     has …
   + 557a7e71eeb5396f2c87c909ddc025fde2678780:
     Fixes for the Starlark transition hash computation (#14251)
   + 34c71465f84fa780217926db2e8e5ca3d6d4568c:
     Do location expansion in copts of objc_library
   + 50274a9f714616d4735a560db7f617e53fb8d01b:
     [5.x] Remote: Add support for compression on gRPC cache (#14277)
   + 61bf2e5b5181cbe34a2f0d584053570943881804:
     Automated rollback of commit
     34c71465f84fa780217926db2e8e5ca3d6d4568c.
   + 79888fe7369479c398bafe064daa19a7ae30f710:
     Silence a zstd-jni GCC warning.
   + 063b5c9c2c09b4794010b9a169b44890ffc79ec4:
     Remote: Limit max number of gRPC connections by
     --remote_max_connections.
   + fd727ec96d861573dcbad3249d727a94eff84789:
     Do location expansion in copts of objc_library
   + 23d096931be9b7247eafa750999dd7feadde14c1:
     Fix _is_shared_library_extension_valid
   + 5cf1d6e1f78bc860fcd0e2e86eff6fe43ab4a5a2:
     Remove merging of java_outputs in JavaPluginInfo.
   + cea5f4f499aa832cf90c68898671869ce79d63f2:
     Cherrypick Bzlmod documentation (#14301)
   + 227e49e28e5122cddd6c4cb70686ff7bde3617ea:
     Format work requests according to ndjson spec
   + ae0a6c98d4f94abedbedb2d51c27de5febd7df67:
     Enable user_link_flags_feature for macosx cc_toolchain_config
   + 8c2c78cdc66cc9d5eb2cd59823c659892c1643a7:
     Remote: Use Action's salt field to differentiate cache across
     workspaces.
   + f94898915268be5670fb1e93a16c03e9b14d2a58:
     [5.x] Remote: Fix "file not found" error when remote cache is
     changed from enabled to disabled.  (#14321)
   + 3069ac4e33dcca6f3d1abf55940cdd764d03bdbf:
     Delete marker file before fetching an external repository
   + c05c6261cdb2cacb7c9881c255c0ada435ab5182:
     Remote: Fix file counting in merkletree.DirectoryTreeBuilder
   + d84f7998ef8f15e27376a0c8f25b320145c4ba9e:
     Fix remote spawn tests for remote_merkle_tree_cache=true
   + 59e16e944200555da377799aa0d9e8d0674d2e27:
     Show skipped tests as a warning
   + 76b3c242831f8e88835e3002a831a185a41fcc52:
     Build xcode-locator as a universal binary
   + aa52f2ddf9bab1ebd18e5431124061e813bfcd80:
     Exit collect_coverage.sh early if LCOV_MERGER is not set.
   + 4256d46327bad8638df91be1a5d4ef83b12b74c7:
     Automated rollback of commit
     d84f7998ef8f15e27376a0c8f25b320145c4ba9e.
   + dce24350befd08216b3910ae343670015444ff81:
     [apple] fix issues compiling C in objc_library for watchos/armv7k
   + bfc24139d93f8643686d91596ba347df2e01966a:
     5.x: Remote: Ignore blobs referenced in BEP if the generating
     action cannot be cached remotely. (#14389)
   + 5aef53a8884038f3c9f06e6dddb9372196253378:
     Remote: Don't blocking-get when acquiring gRPC connections.
     (#14420)
   + 005361c895da334beb873901e93aff06d180256e:
     Disable IncludeValidation for ObjC in bazel
   + d703b7b4f09fb3c389f99e52bac1f23930280b56:
     Update java_tools v11.6
   + 90965b072eb4a6dec8ff5b8abde3726732d37bdc:
     Stop remote blob upload if upload is complete. (#14467)
   + dc59d9e8f7937f2e317c042e8da8f97ba6b1237e:
     [5.x] Make remote BES uploader better (#14472)
   + 2edab739e1f61fe8813230b03396ca46f0790089:
     Avoid too verbose warnings in terminal when cache issues
   + 1160485192b5e6d95bcd426b55cc9a35fc6b8614:
     Rename --project_id to --bes_instance_name
   + c63d9ecbe5fcb5716a0be21d8fc781d7aa5bbc30:
     Automated rollback of commit
     bfdfa6ebfd21b388f1c91f512291c848e1a92a96.
   + b341802700484d11c775bf02d80f43ba3f33b218:
     [apple] support watchos_arm64 in toolchain
   + 43bcf80a3dfdc5ac89c1e4d615d6f29a495855fb:
     Disable implicitly collecting baseline coverage for toolchain
     targets.
   + 302971e1b3d803069ac949c0085c0d2a3916c8ab:
     Automated rollback of commit
     7d09b4a15985052670244c277e4357557b4d0039.
   + 62002024ca7012ffe0f4fc74ac20b5471513c8c8:
     Bzlmod: Starlarkify default attr values for TypeCheckedTags
   + 38117d491cbc4a5686e0bdb1e58f8946d96aed58:
     Fix build after rc4 cherrypicks (#14581)
   + 41feb616ae18e21fdba3868e4c298b0b83012f10:
     Release 5.0.0 (2022-01-19)
   + 486d153d1981c3f47129f675de20189667667fa7:
     Find runfiles in directories that are themselves runfiles
   + 0de7bb95022057e8b89334f44759cf6f950e131f:
     Don't resolve symlinks for --sandbox_base
   + 8b60c90f3641591b65c4e153113aea562f1fab94:
     Remove uses of -lstdc++ on darwin
   + 60f757c0831f9fbb2415fb0105f964201faa9fa0:
     Allow Label instances as keys in select (#14755)
   + 3836ad029f202ca13c64c9f07e4568ea8ab2d9a6:
     Remote: Only waits for background tasks from remote execution.
   + 8734ccf9847eafb7193388cd9c6fa78faa78283f:
     Add the default solib dir to the rpath for cc_imports with
     transitions
   + 9e16a6484e94c358aa77a6ed7b1ded3243b65e8f:
     Flip --experimental_worker_allow_json_protocol
   + fce7ea8d5e0facfc125ae7c37bfb4b9a7c586e40:
     Fix `ctx.fragments.apple.single_arch_cpu` returning incorrect
     cpu for tools when host cpu and exec cpu are different
   + 0c1d09e4dce4c3251c2be2c70d4575ec65b1d9d3:
     Propagate --experimental_cc_implementation_deps to host config
   + 1c3a2456c95fd19974a5b2bd33c5ebdb2b2277e4:
     Support select() on constraint_value for aliases.
   + 67a133b431ccece22b7dd9a72f0837cff77d4360:
     Improve documentation for select()
   + 5356fedd4b6079851b51db27077bf84c7bab16a4:
     Cherrypicks for experimental cc_shared_library (#14773)
   + ffdd633d7b9f21267f4f9759dd9833096dd4e3a2:
     [apple] support tvos_sim_arm64 in toolchain (#14779)
   + a58ddea50b2fd476d183e2e0c077ad6173039b89:
     Cherry pick win arm64 (#14794)
   + dc41a20bb045d221a43223a5db6b8b44cd8f1676:
     [5.1.0] cherrypick subpackages support (#14780)
   + 86e2db7d67ec52bfe11c1f517f650653cee3ea26:
     Add a helper method for rules to depend on the cpp toolchain
     type.
   + 6990c02644a71d5e7c95c9c234ecf39bb55c6ac4:
     UrlRewriter should be able to load credentials from .netrc
     (#14834)
   + 32d1606dac2fea730abe174c41870b7ee70ae041:
     Add "arch" struct field to repository_os
   + 2cfdceae971d09f50ceddc3d7ef723fb5f879957:
     [5.x] bzlmod: Add support for WORKSPACE.bzlmod (#14813)
   + c2ddbd1954af5baab63b93f2b055a410a27832c8:
     Ignore missing include directory in JDK distribution.
   + 16de03595e21f7bf31818e717505b23c953b3b7d:
     Fix bazel coverage false negative
   + 0c74741742301abcf67452a7f591daec1c3a7635:
     Remote: Postpone the block waiting in `afterCommand` to
     `BlockWaitingModule` (#14833)
   + 3297d9234e15515aa91cc887b3b12db7e1040b02:
     Switch to `ProcessHandle` for getting the PID (#14842)
   + a987b98ea0d6da2656c4115568ef9cbe8a164550:
     Fix uses of std++ on bsd
   + d184e4883bb7fc21de2f7aeea4304994de27e9ea:
     Remote: handle early return of compressed blobs uploads
   + 0b09e9e018c557da04c9f978d25a66d963cd6cb6:
     Add removeprefix/removesuffix to Starlark strings
   + d42ab0cfcce56b5e55c8bd94d0923d08758fdb5b:
     Fix default CPU for macOS and iOS (#14923)
   + cd24f39750d7b08f6f31c82d3a23cc329c7fc78e:
     Add paramfile support for def_parser, since in rare cases on
     Windows command line character limit was reached.
   + 0b1beefd1e7611dc9b9f559d00d8ff76aabb0f32:
     Normalize rpath entries to guard against missing default solib
     dir
   + 24e82426e689853b0d9a04e7b9b6f13e145cf2d6:
     Fix aggressive params file assumption
   + c45838bd3e51bcd0c8c3e1a9b4a0e55cdf4b4f59:
     Fix precompiled libs not in runfiles of cc_shared_library
     (#14943)
   + 764614e0f0287125269e7a92e909a44624bcb360:
     Bzlmod: Allow multiple `use_extension`s on the same extension
     (#14945)
   + fa761f84994f18db383fbe9aaea524e4385da13a:
     Fix typo in `apple_common.platform` docs
   + f7d8288bd7b16c7f2e010aa8ddc241cf2ba8e0d5:
     Yield a Proxy for addresses without protocol
   + 8cefb8bed4ac82df8640682517372a9249732352:
     Avoid merging URLs in HttpUtils
   + b4804807fc2c184cc36df9e69e472942c01941b8:
     Make protocOpts() public. (#14952)
   + 113eaca5862c48797654ae2a3acbb6e15d761485:
     Do not hide BulkTransferException messages when there were more
     than one exception
   + b1bf9d6c5f85fc4fda0dc48bc3d3e2fe26880867:
     merkle_tree_cache: change default size to 1000
   + f15e0c7224ecc5473d4972afc436e28df35c4e5a:
     Add --experimental_repository_cache_urls_as_default_canonical_id
     to help detect broken repository URLs (#14989)
   + f4214746fcd15f0ef8c4e747ef8e3edca9f112a5:
     Expose the logic to read user netrc file
   + b858ec39aebd7e586af5438aa2035db2adebf9a4:
     Correct cpu and os values of `local_config_cc_toolchains` targets
   + 5e79972c05d89280f0cf1fa620f807366847bac6:
     Expose CoverageOutputGenerator on a Fragment (#14997)
   + 78f03110e0dab42f37e427fd524e72706e036d74:
     Correct error runfiles cc_shared_library (#14998)
   + 7937dd14c3c632ffcfaea9073d5dec6dcac93845:
     [5.1] Adding Starlark dependencies to the package //external
     (#14991)
   + a73aa12be65454ac8cfb5a8f3e056c420402f997:
     Remote: Fix crashes with InterruptedException when using http
     cache.
   + f8707c07f153ac4ac2ec4b210321f1a16343006d:
     Account for interface libraries in cc_shared_library
   + a570f5fdb1618a6c272d18bebaa712d3b2af3975:
     Fix coverage runfiles directory issue
   + 95de355e4524a6339c0e807b60d333c36c40bdc7:
     Do not validate input-only settings in transitions (#15048)
   + 71747ccc9d0032a865854613329362563c0574df:
     Filter out system headers on macOS.
   + cb6500a9ce648a02154dca8d05a978ce9b10c4b4:
     Update Bazel bootstrap documentation and remove obsolete flags.
     (#15065)
   + 4c031d1030afb1cb48c7e6d71f83cc99fea607c1:
     [5.1] Undocument --bes_best_effort (#15066)
   + 267142f3dc6b8d32b07beb21e3b4ba6f471a69d8:
     Fix conflicting actions error when specifying
     --host_macos_minimum_os (#15068)
   + f1923627e85b1c1d60bcd928f90f116c3ade7a3a:
     [5.1] Remote: Action should not be successful and cached if
     outputs were not created (#15071)
   + 00d74ff737cccd60305ee58d85313556a077152a:
     Support decompressing zstd tar archives for repository rules.
   + f5857830bb68bd05ffc257506575ed37a8128933:
     Remote: Don't check TreeArtifact output
   + efb2b80953983dce499d453a9f55a74ffaf8c42d:
     osx_cc_wrapper: Only expand existing response files
   + c771c43b870fb8618db7bdab6725ab40cac4976d:
     Remote: Fix crashes by InterruptedException when dynamic
     execution is enabled. (#15091)
   + 3785677cc84fc4024fda85575c05efbde5d512fc:
     Use python3 on macOS
   + 815d9e499a32fd4d87525ac0c698c293cf26433d:
     Release 5.1.0 (2022-03-24)
   + 1fbb69e366034484887e00c6006c7b79508765ed:
     Prepare 5.1.1 release
   + df153df9656e0e197f67622bb11f7d77e19238a0:
     Fix CODEOWNERS syntax
   + 2b92a3111e83a4d14934059afd0f51161a41276f:
     Remote: Don't check declared outputs for failed action
   + b47aa71b21d93c9499103e9a37a6c2ffa79865b9:
     Upgrade abseil version to the latest
   + c49c45d8dac87d21cf2b6a176ddd07f2c9f63414:
     Revert default export all symbols on Windows
   + 7d3fb993f55b35081786c3fe00cf3bebb89574f3:
     Support ZIP files with total number of disks = 0
   + 0f5dc111be06b2ee8694640f400b58e12bfa5fea:
     Release 5.1.1 (2022-04-08)
   + 2422cfb3e5d92d46f9065b2b1e442823a965faf7:
     Update CODEOWNERS
   + bbcff1802423fca7ee5bd6a3e527c12d6d7d80ba:
     [5.2.0] Update java_tools 11.7.1 (#15231)
   + 9c98120f33579b72561e02826d9fccf222eccb3c:
     Add support for .ar archives (and .deb files)
   + d3435b09d89f25bf5008ef3b9c870c835d51a8da:
     Seperate GetSelfPath implementation for Blaze and Bazel
   + c94572bea5ce6bdc0ccda9789e5be6fb3f4c173b:
     Include jdk.crypto.mscapi in minimized Windows embedded JDK
   + 299022ca2dc49b6cb27b2674f933755306ae8b9b:
     remote: Proactively close the ZstdInputStream in
     ZstdDecompressingOutputStream.
   + 27707995cc6576ed1f51fbdb199ff8512e8418c9:
     Collect coverage from cc_binary data deps of java_test
   + 3442179d240e01ef13b0fa7814db7366bad5ffac:
     Configure Apple crosstool to return a complete target triple
     that includes minimum OS version and target environment
   + bb6f1a7ce79168055ccd62629da07d46a52b930d:
     Collect C++ lcov coverage if runtime object not in runfiles
   + dbb6e9954b6e4423f727feb2719ffc75a93b514b:
     Fixing dependencies of //external package
   + f0213bbf730c4a5d1a31e65bc9c01fbb55a6edb3:
     [5.2] Upgrade Google Auth Version (#15383)
   + a1a74c9919e03e09ef7c6ae13f38f48eea80ead1:
     Fix chocolatey package - docsUrl must not 404 (#15395)
   + fe644bee95c14d461e0d1e3cccaa8bbcd57bcd8d:
     Fix cache leak when applying transitions when only a rule's
     attributes change.
   + ad74d5243917bb27a37e38d151a4a3c8a49947eb:
     Fix checking remote cache for omitted files in buildevent file
     (#15405)
   + ac219103d8798965b775db548d7b9214ecd78f73:
     fix(bzlmod): throw on json parse exception
   + 3d85b88609a362857d8ee3c0432a37d30268a8a2:
     Add a flag to expose undeclared test outputs in unzipped form.
     (#15431)
   + abd7a9f70c3dfe96724a692dc7dc04ff33bdece1:
     Remove -U_FORTIFY_SOURCE when thin_lto is enabled (#15433)
   + 53b9cb8637c0faddc6b122a1daab72bcc274bdec:
     Catch NumberFormatException while trying to parse thread id.
   + 19740b55ebc283b7ec42b359bcd4c9096facfdd5:
     Improve the --sandbox_debug error message
   + 0a2a43f9aab1e3875f03f643f6414eb67834c883:
     Set keywords on appropriate lifecycle events.
   + 394ddb82b311ea7edbe2522736b0b0202903ddb6:
     Record additional profiling information for remotely executed
     actions.
   + 652b48e567fcb30768dfc2eddee5f04bf6b5d65b:
     Fix downloading remote execution output files inside output
     dirs. (#15444)
   + 73f1ecbc1cb00e16ceda4b582f4d57268f8701cd:
     Fix android emulator darwin_arm64 select
   + 2649c7c4adef0ebf9bca8fe46aa97304b22de522:
     Fix --use_top_level_targets_for_symlinks with aliases (#15446)
   + fa1081c1f3dce7324a1da59c40d1a1a3533c7047:
     Filter libtool warning about table of contents
   + 26f878325e915e0905626a0e4c8bbacffd72f875:
     Unify sandbox/remote handling of empty TreeArtifact inputs
     (#15449)
   + 6b21b7773157a1eebd3dfe79ff4c4ee750059daf:
     Revert "Fixes incorrect install names on darwin platforms"
   + e133e66f715bac17bf5848e4440c089a8c8d3fd9:
     config doesn't error on duplicate `--define` values (#15473)
   + 84d59176622b76223828e61709179dbd5f0c9f8d:
     Collect coverage from cc_binary data deps of py_test (#15298)
   + 519d2daacfff3de6ffabfc5827621fa835e1c815:
     SolibSymlinkAction does not need exec platform or properties
   + 6e54699884cfad49d4e8f6dd59a4050bc95c4edf:
     Let Starlark tests inherit env variables (#15217)
   + 9610ae889e6fd45280c5beb7fe8f5bef2d736878:
     Update PythonZipper action to use CommandLineItem.CapturingMapFn
   + 2f1ff6fa17c3c30b2533bffe81f40eab06b453b9:
     Make `coverage --combined_report=lcov` skip incompatible tests
   + 9fad5a3dc93cd436a5712c46e6c98d3995428ddb:
     Disable ReturnValueIgnored checks to unblock java_tools release
   + 0120118893261968bdf116ef215655c428428fa8:
     Bump the limit of Bazel install base size (#15585)
   + 668805aace9bf96f78595fc2a122027a3000ceac:
     Upgrade zlib to 1.2.12
   + 4d900ceea12919ad62012830a95e51f9ec1a48bb:
     [5.2] Remote: Fix a bug that outputs of actions tagged with
     no-remote are u... (#15453)
   + b703cb9b999e243d776b7620468e48f450c0ce3a:
     Add feature to produce serialized diagnostics files (#15600)
   + 2e8458b7810eab7829fc7d28af5c45b9af91ed7c:
     Release 5.2.0 (2022-06-07)
   + 536f8d97991d891fc7db333af1a5262497d85173:
     Fix fail message construction in cc_shared_library
   + 2d42925ae80c0fb007aa39f4e210122611897255:
     Define cc-compiler-darwin in Xcode toolchain
   + a1d7d1f69f82da1bdfa1cebd32356249127aea3b:
     Fix alwayslink in objc_import
   + d273cb62f43ef8169415cf60fc96e503ea2ad823:
     Unify URL/URLs parameter code across http_archive, http_file,
     http_jar
   + fea32be42928c84463aa1f335b5722a1f6b8c93a:
     Preserve --experimental_allow_unresolved_symlinks in exec cfg
   + e4bc370b226eb0cc536b55641640266345a214ec:
     Ck/cherry pick cc shared library (#15754)
   + dbdfa07e92f99497be9c14265611ad2920161483:
     Let Starlark executable rules specify their environment (#15766)
   + e2a6a2b130552db7521d3d4d854b9a651b1f4a3b:
     Fix string formatting when java_home path is missing.
   + d54a288e6c79c740b9c93dfc31ee345d6a5332af:
     Optionally enable LLVM profile continuous mode
   + ad17b44cdc192277fafb0d0e204962b2b924dba8:
     Print remote execution message when the action times out (#15772)
   + 240e3d1e1dbc74c7753dead6421d7c1b5fc28d09:
     Add missing line to cherrypick
     e4bc370b226eb0cc536b55641640266345a214ec (#15784)
   + 804b4747152a59bc2965be2db85839b8b2764fc7:
     Replace strdupa with strdup
   + 62be9ea29295fab5289bd5d1a0f13dc7d55a8bc0:
     Bzlmod: Better canonical repo names for modules with overrides
     (#15793)
   + d4663a1c950d618c5b15a3e00fb733987cbf45cc:
     Add repo env test (#15768)
   + 594962cb283dcd71b736e0450453903911a8c85a:
     Add is_root struct field to bazel_module (#15815)
   + 3dd2b932d42fe86112899550d21452409cb3c4b0:
     Fix null pointer crash with `bazel coverage` on only
     incompatible tests
   + 4175018b47800db28c390d39fefbd266b5d674bd:
     Add util for finding credential helper to use
   + 3ea9eb2e363860c9305a987fa22a059afd35598d:
     Merge ManifestMergerAction-related commits into release-5.3.0
     (#15824)
   + 64571a428ffe2bf09f1a5eea13e770a7d0381620:
     Ck/cherrypick 15669 (#15788)
   + 1404651cafe5c26c5dae469e9126de53c2f4f024:
     Create output directories for remote execution (#15818)
   + ae523f82d39daf01cf31e40733de0c6345f0935c:
     Use tree artifacts in bootclasspath rule
   + 37f181cb6ed0237f43d81159eb81b19d3b5f8e36:
     [credentialhelper] Add types to communicate with the subprocess
   + 06ca634e10f17023022ab591a55aabdd9fb57b12:
     Add a flag to force Bazel to download certain artifacts when
     using --remote_download_minimal (#15870)
   + d35f923b098e4dc9c90b1ab66b413c216bdee638:
     RemoteExecutionService: fix outputs not being uploaded
   + 78af34f9f25b0c8fbf597a794a5162f0014629c5:
     Cherry-pick proto_lang_toolchain Starlarkfication and
     proto_common module (#15854)
   + afb434da9da79b53da1ea4c7bcc00571dbea6d3f:
     Fix behavior of `print()` in module extensions
   + 6714c30507edc70ec84f8c97d47cffc497356c0b:
     [credentialhelper] Implement invoking credential helper as
     subprocess
   + 0f05904171d187e6abacb431b3d7494423b027ab:
     Add register_{execution_platforms,toolchains} directives to
     MODULE.bazel files (#15852)
   + 33516e27dc6ee6ab5c3b9dee739a267b08d26b6c:
     [remote] Improve .netrc test in RemoteModuleTest
   + aa2a1f3afe2f10baab5befcafb39df14cbffc743:
     Fix ZipDecompressor windows 0x80 (file attribute normal)
   + 30f16e53cb36a5d506665be7553e785d52772e2d:
     Replace uses of `cfg = "host"` with `cfg = "exec"` (#15922)
   + 2a8d0ad7103511a94382aef41821a315bf8144b7:
     target pattern file: allow comments
   + 6f732052654ec37192450c795bb28dd0aad559cd:
     Add factory for creating paths relative to well-known roots
     (#15931)
   + 32cc8e638b91816f427b74266f6a8da6fb605419:
     Update CODEOWNERS (#15910)
   + 63bc14b095f1ea4043024e7fe1f9c476968897c5:
     Implement native analysis_test call. (#15940)
   + 4df77f771e5cfdf4b614afd8934d00c2b2ff31d1:
     Increase osx_cc_configure timeouts
   + cdf01a39ab9def4d46f41595ac1ac9206a96d6f8:
     Allow string_list flags to be set via repeated flag uses
   + 05e758d4bc18fc9d9e189526381a06e4399056a2:
     [credentialhelper] Add parser for flag syntax (#15929)
   + e4ee34416ef18094496ab54446e70cb62cd509e6:
     Docs should mention the new no-remote-cache-upload tag (#15965)
   + 96d23d30cc80912b82a8fbab31c902e9db74b6ab:
     Add netrc support to --bes_backend (#15970)
   + c5bc34e5f1dd92703dd8f15f9f0409c49b778837:
     Add CommandLinePathFactory to CommandEnvironment (#15971)
   + 508f18576ab5327bd623db6b476511ac2089d0fa:
     Move newCredentialHelperProvider into GoogleAuthUtils (#15973)
   + 14c944a5386eccbcfbe8389afb6c518582b11270:
     Wire up credential helper to command-line flag(s) (#15976)
   + 04c373b708390341be4ceb8eb5b2f8561385cb11:
     Add `--output=files` mode to cquery (#15979)
   + edfe2a17e3434cce660757f59b14f2e9d6ab944e:
     Make cpp assembly file extensions case sensitive again
   + 4ae85387e69db73e507b4f18b36d3e2f799e5d34:
     Prevent aspects from executing on incompatible targets (#15984)
   + f440f8ec3f63e5d663e1f9d9614f05a39422102a:
     Remote: Fix performance regression in "upload missing inputs".
     (#15998)
   + 0109031a2818b217b78026055b972da5901656f5:
     Updated Codeowners file (#16032)
   + 6102d33bf0b72dc0fe9ada4c71113cbee3eb8187:
     Propagate the error message when a credential helper fails.
     (#16030)
   + a8dacc7832b04fe1756cd7adce72f2572f357eee:
     Migrate legacy desugar wrapper to new rlocation() (#16025)
   + 11368be4ac24108f18b1965162ad27f207c074f9:
     Correctly report errors thrown by CommandLinePathFactory#create.
   + 82452c7c372fb28485b0b5e0a98b471648f0dfd0:
     Fix an issue that
     `incompatible_remote_build_event_upload_respect_no_… (#16045)
   + e745468461f93839491a4f80d0c1883d9007f9c0:
     Fix rpath for binaries in external repositories (#16079)
   + 83041b145d3966eb353aacb22b7e33ad01d9a239:
     Refactor combined cache. (#16110)
   + c62496f7b76da473cb1102798373f552ba2f434d:
     C++: Add compound error linked statically but not exported
     (#16113)
```

Important changes:

  - alias() can now select() directly on constraint_value()
    
    Fixes https://github.com/bazelbuild/bazel/issues/13047.
    
    Closes #14310.
  - Fixed an issue where Bazel could erroneously report a test passes
    in coverage mode without actually running the test.
  - Make protocOpts() publicly accessible.
  - Add coverage configuration fragment, used to expose
    output_generator label.
  - Bazel now no longer includes system headers on macOS in coverage
    reports (#14969).
    
    Closes #14971.
  - Starlark test rules can use the new inherited_environment
    parameter of testing.TestEnvironment to specify environment
    variables
    whose values should be inherited from the shell environment.
    
    Closes #14849.
  - none
    RELNOTES:none
  - Enable merging permissions during Android manifest merging with
    the --merge_android_manifest_permissions flag.
  - Added new register_{execution_platforms,toolchains} directives to
    the MODULE.bazel file, to replace the
    {execution_platforms,toolchains}_to_register attributes on the
    module() directive.
  - Add support for fetching RPC credentials from credential helper.
    
    Progress on https://github.com/bazelbuild/bazel/issues/15856
    
    Closes #15947.
  - `cquery`'s new output mode
    [`--output=files`](https://bazel.build/docs/cquery#files-output)
    lists the output files of the targets matching the query. It
    takes the current value of `--output_groups` into account.
    
    Closes #15552.
  - Fix for desugaring failure on Bazel+Android+Windows build
    scenario.

This release contains contributions from many people at Google, as well as amberdixon, Andreas Fuchs, Benjamin Peterson, Brentley Jones, Chenchu Kolli, Dan Fleming, Danny Wolf, Emil Kattainen, Fabian Meumertzheim, Gowroji Sunil, hvadehra, Juh-Roch, Keith Smiley, kshyanashree, Niyas Sait, Noa Resare, Oliver Eikemeier, oquenchil, Peter Mounce, Philipp Schrader, Thi Doãn, Xùdōng Yáng, Yannic, Zhongpeng Lin.

## Release 6.0.0-pre.20220816.1 (2022-08-19)

```
Baseline: 70ccf591f21e0c0148554244b34f02869abb7d7b
```

Important changes:

  - Migrate main_dex_list_creator to D8 (DX deprecation)

This release contains contributions from many people at Google, as well as Fabian Meumertzheim.

## Release 6.0.0-pre.20220810.1 (2022-08-18)

```
Baseline: 5767cba4044c2bfd8a4c9596c44d2363630b489d
```

Incompatible changes:

  - Added a new flag
    --incompatible_unambiguous_label_stringification, which causes
    labels in the main repo to stringify into unambiguous forms
    starting with an @. See
    https://github.com/bazelbuild/bazel/issues/15916 for more
    information.

This release contains contributions from many people at Google, as well as Philipp Schrader.

## Release 6.0.0-pre.20220804.3 (2022-08-11)

```
Baseline: 8152657c82b542a3da2ed39333941beefdeeeece
```

Important changes:

  - `cquery`'s new output mode
    [`--output=files`](https://bazel.build/docs/cquery#files-output)
    lists the output files of the targets matching the query. It
    takes the current value of `--output_groups` into account.
  - Change singlejar metadata to report Created-By Bazel
  - Add support for fetching RPC credentials from credential helper.
  - Revert interface_deps back to implementation_deps after problem
    reported in. Use `buildozer 'rename deps implementation_deps'
    //...:%cc_library; buildozer 'rename interface_deps deps'
    //...:%cc_library`
  - Fix for desugaring failure on Bazel+Android+Windows build
    scenario.
  - D8 is the default desugarer

This release contains contributions from many people at Google, as well as Adam Azarchs, Ara Nguyen, Benjamin Peterson, David Sanderson, dhmemi, Eric Song, Fabian Meumertzheim, Greg Roodt, Jeremy Volkman, jheaff1, Jonathan Gerrish, Jon Shea, Keith Smiley, Patrick Balestra, Philipp Schrader, Pras Velagapudi, Roman Salvador, Yannic Bonenberger.

## Release 6.0.0-pre.20220720.3 (2022-08-02)

```
Baseline: 4cd266aa1dfa53d8c8de44f7895edcfd46f74725

Cherry picks:

   + f706da832996ab30ddd8784f2af697a3bb62852b:
     Requires delayed release
```

Important changes:

  - Added new register_{execution_platforms,toolchains} directives to
    the MODULE.bazel file, to replace the
    {execution_platforms,toolchains}_to_register attributes on the
    module() directive.
  - The legacy pkg_tar no longer supports the ability to untar and
    repackage an input tar file (`deps` attribute). Users needed that
    capability must switch to github.com/bazelbuild/rules_pkg.

This release contains contributions from many people at Google, as well as Emil Kattainen, Jason Tan, Keith Smiley, Luis Fernando Pino Duque, rustberry, Son Luong Ngoc, Yannic Bonenberger, Yannic.

## Release 6.0.0-pre.20220706.4 (2022-07-21)

```
Baseline: ea8b99cf2a5914c67e4bd7651d83df98912bb1ed

Cherry picks:

   + 107a54edcf75dc026cf643df82c13fe32a1eb043:
     Fix flag file regexp broken by
     https://github.com/bazelbuild/bazel/commit/cb2cd9fd2b65311da92777
     7c35939701add5b879.
   + 1e7127dec96b69b8cd5d332551f8798433d6057e:
     Reinstate legacy worker flag file behaviour when not using
     --experimental_worker_strict_flagfiles.
```

Incompatible changes:

  - Flag --experimental_local_memory_estimate removed.

This release contains contributions from many people at Google, as well as Fabian Meumertzheim, Tomas Volf, Yannic Bonenberger.

## Release 6.0.0-pre.20220630.1 (2022-07-11)

```
Baseline: fbf9277975ceb7be5255fd5cf449e22706d25d3f
```

Important changes:

  - Removed the obsolete --incompatible_applicable_licenses flag. The
    feature is permanently enabled.
  - embedded_tools packages R8 desugarer again
  - Bazel now selects sh path based on execution platform instead of
    host platform, making it possible to execute sh actions in
    multiplatform builds. --shell_executable now only applies to
    actions configured for host.
  - labels in genquery.scope are no longer configured.
  - When Bzlmod is enabled, all Bzlmod-generated repos will have an
    extra '@' prepended to their names. This effectively enables the
    canonical label literal syntax for Bzlmod-generated repos
    (`@@canonicalRepoName//pkg:target`; see
    https://docs.google.com/document/d/1N81qfCa8oskCk5LqTW-LNthy6EBrDo
    t7bdUsjz6JFC4/edit?usp=sharing).
  - Exposed `CcSharedLibraryInfo` to Starlark builtins.
  - Enable --use_top_level_targets_for_symlinks by default.
  - Singlejar accepts runtime Created-By field
  - --noincompatible_disable_managed_directories, and with that,
    workspace(managed_directories=) is not supported anymore.
  - Bazel supports D8 desugaring, albeit without persistent workers
  - Remove mtime options from pkg_tar. Users should migrate to
    @rules_pkg.
  - Test for experimental multiplexed persistent resource processor.

This release contains contributions from many people at Google, as well as arun.sampathkumar, Benjamin Lee, Benjamin Peterson, Ed Schouten, Emil Kattainen, Fabian Brandstetter, Fabian Meumertzheim, hvadehra, Krishna Ersson, Philipp Schrader, Stephan Wolski, Steve Vermeulen, Xdng Yng.

## Release 6.0.0-pre.20220608.2 (2022-06-15)

```
Baseline: 4f5e325e337957ebea139dc52a00027acbbb572f

Cherry picks:

   + 442155f19f2c2764839327c8be3d3ab70edf1910:
     Automated rollback of commit
     a0a0d09debd090fbe74bba59b5d6d3107aaf97e9.
```

Important changes:

  - Aspects can now define and use exec groups using the same API as
    rules.

This release contains contributions from many people at Google, as well as Kaiqin Chen.

## Release 6.0.0-pre.20220601.1 (2022-06-10)

```
Baseline: 93f6e51a8756021f6e6a027d4520415385fe9293
```

Incompatible changes:

  - this incompatible change breaks old instances of http_archive
    that specified netrc as an absolute path. It is unlikely there
    are many instances in the wild since the path would refer to a
    netrc file inside the external repository by absolute path.
    Migration should be straightforward.
  - genrule switched to use exec transition instead of host. This can
    break targets with hardcoded output paths. To avoid using
    hardcoded paths use make variables, see
    https://docs.bazel.build/versions/4.2.2/be/make-variables.html#pre
    defined_label_variables
  - this incompatible change breaks old instances of http_archive
    that specified netrc as an absolute path. It is unlikely there
    are many instances in the wild since...
  - Error Prone now checks for unused return values of additional
    methods on `java.lang.Object`, which can be disabled using
    `--javacopts=-Xep:ReturnValueIgnored:OFF`
  - Error Prone now checks for unused return values of additional
    methods on `java.lang.Object`, which can be disabled using
    `--javacopts=-Xep:ReturnValueIgnored:OFF`
  - The --incompatible_existing_rules_immutable_view flag has been
    flipped to true. See
    https://github.com/bazelbuild/bazel/issues/13907 for
    migration notes.
  - Split up the C++ archive from the C++ link action and set
    `CppArchive` as mnemonic.
  - workspace(managed_directories=) is not available anymore.
  - --legacy_important_outputs now has a default of false.
  - --legacy_important_outputs default reverted to true.
  - objc_library now requires CcInfo in its deps.  If this breaks
    you, add empty CcInfo() to your rule.

Important changes:

  - Deprecate --incompatible_applicable_licenses flag, in preparation
    for removal in Bazel 6.x.
  - Treat py_*.srcs_version="PY2" the same as "PY2ONLY".
  - The Build Event Protocol now contains file digests and sizes
    along with the file name and URI.
  - Refactor system suspend event handling.
  - alias() can now select() directly on constraint_value()
  - Allow \a \b \f \v escape sequences in Starlark.
  - Match remote and local xcode version by most granular version.
  - Adds `--experimental_worker_multiplex_sandboxing` flag that
    controls whether to sandbox multiplex workers that support it.
  - provider() has a new parameter: init, a callback for performing
    pre-processing and validation of field values. Iff this parameter
    is set,
    provider() returns a tuple of 2 elements: the usual provider
    symbol (which,
    when called, invokes init) and a raw constructor (which bypasses
    init).
  - Tests that fail to create or complete their
    `TestAttemptContinuation` by
    throwing an `ExecException` will report an `INCOMPLETE` status.
    Previously, Bazel
    would fail to report any status for the test attempt.
  - Fixed an issue where Bazel could erroneously report a test passes
    in coverage mode without actually running the test.
  - Include more information about configurations in cquery proto
    formatted output. This deprecates the configuration field of
    AnalysisProtosV2.ConfiguredTarget, and adds a new field,
    configuration_id, to
    be used instead.
  - experimental cc_library.implementation_deps inverted to
    interface_deps
  - In aquery and cquery proto output, indicate if a configuration is
    a
    tool or non-tool configuration.
  - Include complete configurations in cquery proto output.
  - experimental cc_library.implementation_deps inverted to
    interface_deps
  - Make protocOpts() publicly accessible.
  - Add some documentation about how configuration information is
    conveyed in cquery proto output.
  - Introduces experimental static library linking API under
    apple_common.link_multi_arch_static_library
  - Further deprecation and removal of pkg_tar. Stop supporting
    legacy use of 'files' attribute, where it could be a list of
    labels instead of a map of paths to labels.
  - Removed --incompatible_no_build_defs_pkg flag. It never fulfilled
    its purpose because --all_incompatible_changes would never set
    it. The last rule it gated (pkg_tar) is scheduled to be removed
    in Bazel 6.x.
  - Add coverage configuration fragment, used to expose
    output_generator label.
  - Bazel now no longer includes system headers on macOS in coverage
    reports (#14969).
  - android_sdk_repository read $ANDROID_SDK_ROOT in addition to
    $ANDROID_HOME.
  - The default dexer is now d8. dx can be optionally enabled using:
      --define=android_dexmerger_tool=dx_dexmerger \
      --define=android_incremental_dexing_tool=dx_dexbuilder \
      --define=android_standalone_dexing_tool=dx_compat_dx \
      --use_workers_with_dexbuilder
  - Packaging support for deploy JAR embedded JDK files (hermetic
    Java).
  - Don't stamp cc_common.link actions for tool dependencies.
  - Starlark test rules can use the new inherited_environment
    parameter of testing.TestEnvironment to specify environment
    variables
    whose values should be inherited from the shell environment.
  - Enable merging permissions during Android manifest merging with
    the --merge_android_manifest_permissions flag.
  - Allow specialization to work with constraint_values.
  - Bazel uses the D8 jar from Maven instead of the SDK.
  - Make ijar / java_import preserve classes with `@kotlin.Metadata`
    annotations
  - Switch cc_test implementation to Starlark. Note: cc_test will now
    link statically when _targeting_ Windows regardless of host
    platform (rather than always linking statically when Windows is
    the _host_).
  - Switch cc_test implementation to Starlark. Note: cc_test will now
    link statically when _targeting_ Windows regardless of host
    platform (rather than always linking statically when Windows is
    the _host_).
  - Add devtools/build/lib/worker:work_request_handlers to the remote
    android tools release package. This will be transitively packaged
    into all_android_tools.
  - Bazel uses the D8 jar from Maven instead of the SDK.
  - android_sdk_repository read $ANDROID_SDK_ROOT in addition to
    $ANDROID_HOME.
  - Advance android_tools_pkg version to 0.24.0.
  - Switch cc_test implementation to Starlark. Note: cc_test will now
    link statically when _targeting_ Windows regardless of host
    platform (rather
    than always linking statically when Windows is the _host_).
  - Bazel uses the D8 jar from Maven instead of the SDK.
  - "blaze config" now only reports info from the last build. To
    compare configurations across multiple builds, redirect "blaze
    config" output to a file and run your favorite diff tool.
  - The --incompatible_override_toolchain_transition flag is now
    always set, and will be removed in the future. Thus,
    --noincompatible_override_toolchain_transition has no effect, and
    the value of the incompatible_use_toolchain_transition parameter
    in aspect() and rule() builtins is ignored.
  - Switch cc_test implementation to Starlark. Note: cc_test will now
    link statically when _targeting_ Windows regardless of host
    platform (rather
    than always linking statically when Windows is the _host_).
  - Toolchain types may now be optional, in addition to mandatory.
    See https://bazel.build/docs/toolchains#optional-toolchains for
    further details.
  - Add six to deps of has_services=1 py_proto_librarys.
  - pkg_tar(symlinks) has been removed. Users needing that feature
    should
    migrate to @rules_pkg.

This release contains contributions from many people at Google, as well as Adam Wolf, Albert Lloveras, Alessandro Patti, Alex Eagle, Alex Scott, Alex Torok, Andreas Fuchs, Andreas Herrmann, Andrew Katson, Andrew Klotz, arunkumar9t2, Ast-x64, Benedek Thaler, Benjamin Lee, Benjamin Peterson, Ben Lee, Bohdan Vanieiev, Bradley Burns, Brandon Duffany, Brandon Jacklyn, Brentley Jones, Brentley Jones, Chad Miller, Chris Clearwater, Chris Fredrickson, Christopher Peterson Sauer, Christopher Sauer, ckiffel, Cristian Hancila, crydell-ericsson, Dan Fleming, Daniel Wagner-Hall, Danny Wolf, David Ostrovsky, Denys Kurylenko, Dimi Shahbaz, divanorama, dmaclach, Ed Schouten, Emil Kattainen, Fabian Meumertzheim, floriographygoth, Fredrik Medley, George Prekas, gkgoat1, gkorlam, Greg Estren, Greg, Grzegorz Lukasik, Halil Sener, Hannes Kufler, homuler, hvadehra, hvd, Jan, Jay Bazuzi, jheaff1, Jiawen Chen, Joel Williamson, John Laxson, John Millikin, juanchoviedo, Keith Smiley, Ken Micklas, Kevin Lin, lihu, Luc Bertrand, Marek uppa, Matt Clarkson, Matt Mackay, Michael P. Nitowski, Mikhail Balabin, Mostyn Bramley-Moore, Nick Korostelev, Nitesh Anandan, Niyas Sait, Noa Resare, Oscar Bonilla, Patrick Balestra, Paul Tarjan, Peter Mounce, Philipp Schrader, Pras Velagapudi, Rahul Butani, Rifqi Mulya Fahmi, Ryan Beasley, Ryan Schmidt, Sahin Yort, Saleem Abdulrasool, Simon Bjorklen, Son Luong Ngoc, Stiopa Koltsov, Sven Tiffe, Takeo Sawada, Tao Wang, Ted Kaplan, Tetsuo Kiso, Thi Doan, Thomas Chen, ThomasCJY, Thomas Zayouna, Timothe Peignier, Tom de Goede, Ulf Adams, Ulrik Falklof, Vasilios Pantazopoulos, Vladimir Tagakov, William Muir, Xavier Bonaventura, Xdng Yng, Yannic Bonenberger, Yannic, Yesudeep Mangalapilly, Yuval K, Zhongpeng Lin.

## Release 5.2.0 (2022-06-07)

```
Baseline: 8d66a4171baddcbe1569972f019e54130111202c

Cherry picks:

   + becd1494481b96d2bc08055d3d9d4d7968d9702e:
     Remote: Cache merkle trees
   + d7628e1b566be353fe7172241ac8f15d5f8e7ff5:
     Update DEFAULT_IOS_CPU for M1 arm64 simulator support
   + 80c56ff7b603fcfff02a5f97829a2a5935f360a0:
     Compile Apple tools as fat binaries if possible
   + 3c09f3438a966b49a7c1726022c898b390b3a6e5:
     Add protobuf as a well known module
   + 3a5b3606a6f5433467a5b49f0188c41411684bf5:
     Remote: Merge target-level exec_properties with
     --remote_default_exec_properties
   + 917e15ea408e1d3d25574edbb466b39cfbcb61fe:
     Add -no_uuid for hermetic macOS toolchain setup
   + f5cf8b076bc913dbe021104d5f6837fb4a6cd8b3:
     Remote: Fixes an issue when --experimental_remote_cache_async
     encounter flaky tests.
   + 77a002cce050e861fcc87c89acf7768aa5c97124:
     Remove DigestUtils.getDigestInExclusiveMode() now that SsdModule
     has …
   + 557a7e71eeb5396f2c87c909ddc025fde2678780:
     Fixes for the Starlark transition hash computation (#14251)
   + 34c71465f84fa780217926db2e8e5ca3d6d4568c:
     Do location expansion in copts of objc_library
   + 50274a9f714616d4735a560db7f617e53fb8d01b:
     [5.x] Remote: Add support for compression on gRPC cache (#14277)
   + 61bf2e5b5181cbe34a2f0d584053570943881804:
     Automated rollback of commit
     34c71465f84fa780217926db2e8e5ca3d6d4568c.
   + 79888fe7369479c398bafe064daa19a7ae30f710:
     Silence a zstd-jni GCC warning.
   + 063b5c9c2c09b4794010b9a169b44890ffc79ec4:
     Remote: Limit max number of gRPC connections by
     --remote_max_connections.
   + fd727ec96d861573dcbad3249d727a94eff84789:
     Do location expansion in copts of objc_library
   + 23d096931be9b7247eafa750999dd7feadde14c1:
     Fix _is_shared_library_extension_valid
   + 5cf1d6e1f78bc860fcd0e2e86eff6fe43ab4a5a2:
     Remove merging of java_outputs in JavaPluginInfo.
   + cea5f4f499aa832cf90c68898671869ce79d63f2:
     Cherrypick Bzlmod documentation (#14301)
   + 227e49e28e5122cddd6c4cb70686ff7bde3617ea:
     Format work requests according to ndjson spec
   + ae0a6c98d4f94abedbedb2d51c27de5febd7df67:
     Enable user_link_flags_feature for macosx cc_toolchain_config
   + 8c2c78cdc66cc9d5eb2cd59823c659892c1643a7:
     Remote: Use Action's salt field to differentiate cache across
     workspaces.
   + f94898915268be5670fb1e93a16c03e9b14d2a58:
     [5.x] Remote: Fix "file not found" error when remote cache is
     changed from enabled to disabled.  (#14321)
   + 3069ac4e33dcca6f3d1abf55940cdd764d03bdbf:
     Delete marker file before fetching an external repository
   + c05c6261cdb2cacb7c9881c255c0ada435ab5182:
     Remote: Fix file counting in merkletree.DirectoryTreeBuilder
   + d84f7998ef8f15e27376a0c8f25b320145c4ba9e:
     Fix remote spawn tests for remote_merkle_tree_cache=true
   + 59e16e944200555da377799aa0d9e8d0674d2e27:
     Show skipped tests as a warning
   + 76b3c242831f8e88835e3002a831a185a41fcc52:
     Build xcode-locator as a universal binary
   + aa52f2ddf9bab1ebd18e5431124061e813bfcd80:
     Exit collect_coverage.sh early if LCOV_MERGER is not set.
   + 4256d46327bad8638df91be1a5d4ef83b12b74c7:
     Automated rollback of commit
     d84f7998ef8f15e27376a0c8f25b320145c4ba9e.
   + dce24350befd08216b3910ae343670015444ff81:
     [apple] fix issues compiling C in objc_library for watchos/armv7k
   + bfc24139d93f8643686d91596ba347df2e01966a:
     5.x: Remote: Ignore blobs referenced in BEP if the generating
     action cannot be cached remotely. (#14389)
   + 5aef53a8884038f3c9f06e6dddb9372196253378:
     Remote: Don't blocking-get when acquiring gRPC connections.
     (#14420)
   + 005361c895da334beb873901e93aff06d180256e:
     Disable IncludeValidation for ObjC in bazel
   + d703b7b4f09fb3c389f99e52bac1f23930280b56:
     Update java_tools v11.6
   + 90965b072eb4a6dec8ff5b8abde3726732d37bdc:
     Stop remote blob upload if upload is complete. (#14467)
   + dc59d9e8f7937f2e317c042e8da8f97ba6b1237e:
     [5.x] Make remote BES uploader better (#14472)
   + 2edab739e1f61fe8813230b03396ca46f0790089:
     Avoid too verbose warnings in terminal when cache issues
   + 1160485192b5e6d95bcd426b55cc9a35fc6b8614:
     Rename --project_id to --bes_instance_name
   + c63d9ecbe5fcb5716a0be21d8fc781d7aa5bbc30:
     Automated rollback of commit
     bfdfa6ebfd21b388f1c91f512291c848e1a92a96.
   + b341802700484d11c775bf02d80f43ba3f33b218:
     [apple] support watchos_arm64 in toolchain
   + 43bcf80a3dfdc5ac89c1e4d615d6f29a495855fb:
     Disable implicitly collecting baseline coverage for toolchain
     targets.
   + 302971e1b3d803069ac949c0085c0d2a3916c8ab:
     Automated rollback of commit
     7d09b4a15985052670244c277e4357557b4d0039.
   + 62002024ca7012ffe0f4fc74ac20b5471513c8c8:
     Bzlmod: Starlarkify default attr values for TypeCheckedTags
   + 38117d491cbc4a5686e0bdb1e58f8946d96aed58:
     Fix build after rc4 cherrypicks (#14581)
   + 41feb616ae18e21fdba3868e4c298b0b83012f10:
     Release 5.0.0 (2022-01-19)
   + 486d153d1981c3f47129f675de20189667667fa7:
     Find runfiles in directories that are themselves runfiles
   + 0de7bb95022057e8b89334f44759cf6f950e131f:
     Don't resolve symlinks for --sandbox_base
   + 8b60c90f3641591b65c4e153113aea562f1fab94:
     Remove uses of -lstdc++ on darwin
   + 60f757c0831f9fbb2415fb0105f964201faa9fa0:
     Allow Label instances as keys in select (#14755)
   + 3836ad029f202ca13c64c9f07e4568ea8ab2d9a6:
     Remote: Only waits for background tasks from remote execution.
   + 8734ccf9847eafb7193388cd9c6fa78faa78283f:
     Add the default solib dir to the rpath for cc_imports with
     transitions
   + 9e16a6484e94c358aa77a6ed7b1ded3243b65e8f:
     Flip --experimental_worker_allow_json_protocol
   + fce7ea8d5e0facfc125ae7c37bfb4b9a7c586e40:
     Fix `ctx.fragments.apple.single_arch_cpu` returning incorrect
     cpu for tools when host cpu and exec cpu are different
   + 0c1d09e4dce4c3251c2be2c70d4575ec65b1d9d3:
     Propagate --experimental_cc_implementation_deps to host config
   + 1c3a2456c95fd19974a5b2bd33c5ebdb2b2277e4:
     Support select() on constraint_value for aliases.
   + 67a133b431ccece22b7dd9a72f0837cff77d4360:
     Improve documentation for select()
   + 5356fedd4b6079851b51db27077bf84c7bab16a4:
     Cherrypicks for experimental cc_shared_library (#14773)
   + ffdd633d7b9f21267f4f9759dd9833096dd4e3a2:
     [apple] support tvos_sim_arm64 in toolchain (#14779)
   + a58ddea50b2fd476d183e2e0c077ad6173039b89:
     Cherry pick win arm64 (#14794)
   + dc41a20bb045d221a43223a5db6b8b44cd8f1676:
     [5.1.0] cherrypick subpackages support (#14780)
   + 86e2db7d67ec52bfe11c1f517f650653cee3ea26:
     Add a helper method for rules to depend on the cpp toolchain
     type.
   + 6990c02644a71d5e7c95c9c234ecf39bb55c6ac4:
     UrlRewriter should be able to load credentials from .netrc
     (#14834)
   + 32d1606dac2fea730abe174c41870b7ee70ae041:
     Add "arch" struct field to repository_os
   + 2cfdceae971d09f50ceddc3d7ef723fb5f879957:
     [5.x] bzlmod: Add support for WORKSPACE.bzlmod (#14813)
   + c2ddbd1954af5baab63b93f2b055a410a27832c8:
     Ignore missing include directory in JDK distribution.
   + 16de03595e21f7bf31818e717505b23c953b3b7d:
     Fix bazel coverage false negative
   + 0c74741742301abcf67452a7f591daec1c3a7635:
     Remote: Postpone the block waiting in `afterCommand` to
     `BlockWaitingModule` (#14833)
   + 3297d9234e15515aa91cc887b3b12db7e1040b02:
     Switch to `ProcessHandle` for getting the PID (#14842)
   + a987b98ea0d6da2656c4115568ef9cbe8a164550:
     Fix uses of std++ on bsd
   + d184e4883bb7fc21de2f7aeea4304994de27e9ea:
     Remote: handle early return of compressed blobs uploads
   + 0b09e9e018c557da04c9f978d25a66d963cd6cb6:
     Add removeprefix/removesuffix to Starlark strings
   + d42ab0cfcce56b5e55c8bd94d0923d08758fdb5b:
     Fix default CPU for macOS and iOS (#14923)
   + cd24f39750d7b08f6f31c82d3a23cc329c7fc78e:
     Add paramfile support for def_parser, since in rare cases on
     Windows command line character limit was reached.
   + 0b1beefd1e7611dc9b9f559d00d8ff76aabb0f32:
     Normalize rpath entries to guard against missing default solib
     dir
   + 24e82426e689853b0d9a04e7b9b6f13e145cf2d6:
     Fix aggressive params file assumption
   + c45838bd3e51bcd0c8c3e1a9b4a0e55cdf4b4f59:
     Fix precompiled libs not in runfiles of cc_shared_library
     (#14943)
   + 764614e0f0287125269e7a92e909a44624bcb360:
     Bzlmod: Allow multiple `use_extension`s on the same extension
     (#14945)
   + fa761f84994f18db383fbe9aaea524e4385da13a:
     Fix typo in `apple_common.platform` docs
   + f7d8288bd7b16c7f2e010aa8ddc241cf2ba8e0d5:
     Yield a Proxy for addresses without protocol
   + 8cefb8bed4ac82df8640682517372a9249732352:
     Avoid merging URLs in HttpUtils
   + b4804807fc2c184cc36df9e69e472942c01941b8:
     Make protocOpts() public. (#14952)
   + 113eaca5862c48797654ae2a3acbb6e15d761485:
     Do not hide BulkTransferException messages when there were more
     than one exception
   + b1bf9d6c5f85fc4fda0dc48bc3d3e2fe26880867:
     merkle_tree_cache: change default size to 1000
   + f15e0c7224ecc5473d4972afc436e28df35c4e5a:
     Add --experimental_repository_cache_urls_as_default_canonical_id
     to help detect broken repository URLs (#14989)
   + f4214746fcd15f0ef8c4e747ef8e3edca9f112a5:
     Expose the logic to read user netrc file
   + b858ec39aebd7e586af5438aa2035db2adebf9a4:
     Correct cpu and os values of `local_config_cc_toolchains` targets
   + 5e79972c05d89280f0cf1fa620f807366847bac6:
     Expose CoverageOutputGenerator on a Fragment (#14997)
   + 78f03110e0dab42f37e427fd524e72706e036d74:
     Correct error runfiles cc_shared_library (#14998)
   + 7937dd14c3c632ffcfaea9073d5dec6dcac93845:
     [5.1] Adding Starlark dependencies to the package //external
     (#14991)
   + a73aa12be65454ac8cfb5a8f3e056c420402f997:
     Remote: Fix crashes with InterruptedException when using http
     cache.
   + f8707c07f153ac4ac2ec4b210321f1a16343006d:
     Account for interface libraries in cc_shared_library
   + a570f5fdb1618a6c272d18bebaa712d3b2af3975:
     Fix coverage runfiles directory issue
   + 95de355e4524a6339c0e807b60d333c36c40bdc7:
     Do not validate input-only settings in transitions (#15048)
   + 71747ccc9d0032a865854613329362563c0574df:
     Filter out system headers on macOS.
   + cb6500a9ce648a02154dca8d05a978ce9b10c4b4:
     Update Bazel bootstrap documentation and remove obsolete flags.
     (#15065)
   + 4c031d1030afb1cb48c7e6d71f83cc99fea607c1:
     [5.1] Undocument --bes_best_effort (#15066)
   + 267142f3dc6b8d32b07beb21e3b4ba6f471a69d8:
     Fix conflicting actions error when specifying
     --host_macos_minimum_os (#15068)
   + f1923627e85b1c1d60bcd928f90f116c3ade7a3a:
     [5.1] Remote: Action should not be successful and cached if
     outputs were not created (#15071)
   + 00d74ff737cccd60305ee58d85313556a077152a:
     Support decompressing zstd tar archives for repository rules.
   + f5857830bb68bd05ffc257506575ed37a8128933:
     Remote: Don't check TreeArtifact output
   + efb2b80953983dce499d453a9f55a74ffaf8c42d:
     osx_cc_wrapper: Only expand existing response files
   + c771c43b870fb8618db7bdab6725ab40cac4976d:
     Remote: Fix crashes by InterruptedException when dynamic
     execution is enabled. (#15091)
   + 3785677cc84fc4024fda85575c05efbde5d512fc:
     Use python3 on macOS
   + 815d9e499a32fd4d87525ac0c698c293cf26433d:
     Release 5.1.0 (2022-03-24)
   + 1fbb69e366034484887e00c6006c7b79508765ed:
     Prepare 5.1.1 release
   + df153df9656e0e197f67622bb11f7d77e19238a0:
     Fix CODEOWNERS syntax
   + 2b92a3111e83a4d14934059afd0f51161a41276f:
     Remote: Don't check declared outputs for failed action
   + b47aa71b21d93c9499103e9a37a6c2ffa79865b9:
     Upgrade abseil version to the latest
   + c49c45d8dac87d21cf2b6a176ddd07f2c9f63414:
     Revert default export all symbols on Windows
   + 7d3fb993f55b35081786c3fe00cf3bebb89574f3:
     Support ZIP files with total number of disks = 0
   + 0f5dc111be06b2ee8694640f400b58e12bfa5fea:
     Release 5.1.1 (2022-04-08)
   + 2422cfb3e5d92d46f9065b2b1e442823a965faf7:
     Update CODEOWNERS
   + bbcff1802423fca7ee5bd6a3e527c12d6d7d80ba:
     [5.2.0] Update java_tools 11.7.1 (#15231)
   + 9c98120f33579b72561e02826d9fccf222eccb3c:
     Add support for .ar archives (and .deb files)
   + d3435b09d89f25bf5008ef3b9c870c835d51a8da:
     Seperate GetSelfPath implementation for Blaze and Bazel
   + c94572bea5ce6bdc0ccda9789e5be6fb3f4c173b:
     Include jdk.crypto.mscapi in minimized Windows embedded JDK
   + 299022ca2dc49b6cb27b2674f933755306ae8b9b:
     remote: Proactively close the ZstdInputStream in
     ZstdDecompressingOutputStream.
   + 27707995cc6576ed1f51fbdb199ff8512e8418c9:
     Collect coverage from cc_binary data deps of java_test
   + 3442179d240e01ef13b0fa7814db7366bad5ffac:
     Configure Apple crosstool to return a complete target triple
     that includes minimum OS version and target environment
   + bb6f1a7ce79168055ccd62629da07d46a52b930d:
     Collect C++ lcov coverage if runtime object not in runfiles
   + dbb6e9954b6e4423f727feb2719ffc75a93b514b:
     Fixing dependencies of //external package
   + f0213bbf730c4a5d1a31e65bc9c01fbb55a6edb3:
     [5.2] Upgrade Google Auth Version (#15383)
   + a1a74c9919e03e09ef7c6ae13f38f48eea80ead1:
     Fix chocolatey package - docsUrl must not 404 (#15395)
   + fe644bee95c14d461e0d1e3cccaa8bbcd57bcd8d:
     Fix cache leak when applying transitions when only a rule's
     attributes change.
   + ad74d5243917bb27a37e38d151a4a3c8a49947eb:
     Fix checking remote cache for omitted files in buildevent file
     (#15405)
   + ac219103d8798965b775db548d7b9214ecd78f73:
     fix(bzlmod): throw on json parse exception
   + 3d85b88609a362857d8ee3c0432a37d30268a8a2:
     Add a flag to expose undeclared test outputs in unzipped form.
     (#15431)
   + abd7a9f70c3dfe96724a692dc7dc04ff33bdece1:
     Remove -U_FORTIFY_SOURCE when thin_lto is enabled (#15433)
   + 53b9cb8637c0faddc6b122a1daab72bcc274bdec:
     Catch NumberFormatException while trying to parse thread id.
   + 19740b55ebc283b7ec42b359bcd4c9096facfdd5:
     Improve the --sandbox_debug error message
   + 0a2a43f9aab1e3875f03f643f6414eb67834c883:
     Set keywords on appropriate lifecycle events.
   + 394ddb82b311ea7edbe2522736b0b0202903ddb6:
     Record additional profiling information for remotely executed
     actions.
   + 652b48e567fcb30768dfc2eddee5f04bf6b5d65b:
     Fix downloading remote execution output files inside output
     dirs. (#15444)
   + 73f1ecbc1cb00e16ceda4b582f4d57268f8701cd:
     Fix android emulator darwin_arm64 select
   + 2649c7c4adef0ebf9bca8fe46aa97304b22de522:
     Fix --use_top_level_targets_for_symlinks with aliases (#15446)
   + fa1081c1f3dce7324a1da59c40d1a1a3533c7047:
     Filter libtool warning about table of contents
   + 26f878325e915e0905626a0e4c8bbacffd72f875:
     Unify sandbox/remote handling of empty TreeArtifact inputs
     (#15449)
   + 6b21b7773157a1eebd3dfe79ff4c4ee750059daf:
     Revert "Fixes incorrect install names on darwin platforms"
   + e133e66f715bac17bf5848e4440c089a8c8d3fd9:
     config doesn't error on duplicate `--define` values (#15473)
   + 84d59176622b76223828e61709179dbd5f0c9f8d:
     Collect coverage from cc_binary data deps of py_test (#15298)
   + 519d2daacfff3de6ffabfc5827621fa835e1c815:
     SolibSymlinkAction does not need exec platform or properties
   + 6e54699884cfad49d4e8f6dd59a4050bc95c4edf:
     Let Starlark tests inherit env variables (#15217)
   + 9610ae889e6fd45280c5beb7fe8f5bef2d736878:
     Update PythonZipper action to use CommandLineItem.CapturingMapFn
   + 2f1ff6fa17c3c30b2533bffe81f40eab06b453b9:
     Make `coverage --combined_report=lcov` skip incompatible tests
   + 9fad5a3dc93cd436a5712c46e6c98d3995428ddb:
     Disable ReturnValueIgnored checks to unblock java_tools release
   + 0120118893261968bdf116ef215655c428428fa8:
     Bump the limit of Bazel install base size (#15585)
   + 668805aace9bf96f78595fc2a122027a3000ceac:
     Upgrade zlib to 1.2.12
   + 4d900ceea12919ad62012830a95e51f9ec1a48bb:
     [5.2] Remote: Fix a bug that outputs of actions tagged with
     no-remote are u... (#15453)
   + b703cb9b999e243d776b7620468e48f450c0ce3a:
     Add feature to produce serialized diagnostics files (#15600)
```

Important changes:

  - alias() can now select() directly on constraint_value()
    
    Fixes https://github.com/bazelbuild/bazel/issues/13047.
    
    Closes #14310.
  - Fixed an issue where Bazel could erroneously report a test passes
    in coverage mode without actually running the test.
  - Make protocOpts() publicly accessible.
  - Add coverage configuration fragment, used to expose
    output_generator label.
  - Bazel now no longer includes system headers on macOS in coverage
    reports (#14969).
    
    Closes #14971.
  - Starlark test rules can use the new inherited_environment
    parameter of testing.TestEnvironment to specify environment
    variables
    whose values should be inherited from the shell environment.
    
    Closes #14849.

This release contains contributions from many people at Google, as well as amberdixon, Andreas Fuchs, Benjamin Peterson, Brentley Jones, Chenchu Kolli, Dan Fleming, Danny Wolf, Fabian Meumertzheim, hvadehra, Keith Smiley, Niyas Sait, Noa Resare, Oliver Eikemeier, oquenchil, Peter Mounce, Philipp Schrader, Thi Doãn, Xùdōng Yáng, Yannic, Zhongpeng Lin.

## Release 6.0.0-pre.20220526.1 (2022-06-02)

```
Baseline: e6bb6fcfcc9b571ef0bbdf039b5ae67954ade222
```

Incompatible changes:

  - --legacy_important_outputs now has a default of false.
  - --legacy_important_outputs default reverted to true.

Important changes:

  - pkg_tar(symlinks) has been removed. Users needing that feature
    should
    migrate to @rules_pkg.

This release contains contributions from many people at Google, as well as Alessandro Patti, Benjamin Lee, Benjamin Peterson.

## Release 6.0.0-pre.20220520.1 (2022-05-30)

```
Baseline: 4879106fabdf4af9395743941987d4297d232296
```

Incompatible changes:

  - workspace(managed_directories=) is not available anymore.

Important changes:

  - Add six to deps of has_services=1 py_proto_librarys.

This release contains contributions from many people at Google, as well as Benjamin Peterson, Christopher Peterson Sauer.

## Release 6.0.0-pre.20220517.1 (2022-05-23)

```
Baseline: 61fd06d92706d64fbcef64f0f54cded91c88afff
```

Incompatible changes:

  - Split up the C++ archive from the C++ link action and set
    `CppArchive` as mnemonic.

Important changes:

  - Switch cc_test implementation to Starlark. Note: cc_test will now
    link statically when _targeting_ Windows regardless of host
    platform (rather
    than always linking statically when Windows is the _host_).
  - Bazel uses the D8 jar from Maven instead of the SDK.
  - "blaze config" now only reports info from the last build. To
    compare configurations across multiple builds, redirect "blaze
    config" output to a file and run your favorite diff tool.
  - The --incompatible_override_toolchain_transition flag is now
    always set, and will be removed in the future. Thus,
    --noincompatible_override_toolchain_transition has no effect, and
    the value of the incompatible_use_toolchain_transition parameter
    in aspect() and rule() builtins is ignored.
  - Switch cc_test implementation to Starlark. Note: cc_test will now
    link statically when _targeting_ Windows regardless of host
    platform (rather
    than always linking statically when Windows is the _host_).
  - Toolchain types may now be optional, in addition to mandatory.
    See https://bazel.build/docs/toolchains#optional-toolchains for
    further details.

This release contains contributions from many people at Google, as well as Andreas Fuchs, Andrew Klotz, Benjamin Lee, Benjamin Peterson, Chris Clearwater, Christopher Peterson Sauer, Christopher Sauer, Daniel Wagner-Hall, Fabian Meumertzheim, Fredrik Medley, George Prekas, Grzegorz Lukasik, Halil Sener, homuler, John Laxson, John Millikin, Keith Smiley, Matt Clarkson, Peter Mounce, Philipp Schrader, Ryan Beasley, Saleem Abdulrasool, Takeo Sawada, ThomasCJY, Vladimir Tagakov, Xdng Yng.

## Release 6.0.0-pre.20220421.3 (2022-05-03)

```
Baseline: 092884b0118f1b8b14ba2277851baa6dcce5cac2

Cherry picks:

   + 82861c3a6e9761af883b1f6c99eef27da28b3d00:
     remove debug statement
   + a5a4198b4bae3e10e30bf48083d037acce39aac3:
     Automated rollback of commit
     92d760b37722feffd5b1121e4f9a1152d8120946.
```

Important changes:

  - Switch cc_test implementation to Starlark. Note: cc_test will now
    link statically when _targeting_ Windows regardless of host
    platform (rather than always linking statically when Windows is
    the _host_).
  - Switch cc_test implementation to Starlark. Note: cc_test will now
    link statically when _targeting_ Windows regardless of host
    platform (rather than always linking statically when Windows is
    the _host_).
  - Add devtools/build/lib/worker:work_request_handlers to the remote
    android tools release package. This will be transitively packaged
    into all_android_tools.
  - Bazel uses the D8 jar from Maven instead of the SDK.
  - android_sdk_repository read $ANDROID_SDK_ROOT in addition to
    $ANDROID_HOME.
  - Advance android_tools_pkg version to 0.24.0.

This release contains contributions from many people at Google, as well as Benjamin Peterson, Brandon Duffany, Daniel Wagner-Hall, Emil Kattainen, Fabian Meumertzheim, hvd, Keith Smiley, Tao Wang, Thomas Chen, ThomasCJY, Tom de Goede.

## Release 6.0.0-pre.20220414.2 (2022-04-26)

```
Baseline: 6872fd230b7fe4a15fa900d16f6f9ddd5726cdc3

Cherry picks:

   + a603c2382ffcc49f344eee73dfcd65aa2332f64f:
     Automated rollback of commit
     b93f828133e74cb3589ba7ffcfe74d2fe72430cd.
   + 6142eac9153b539661c43dada5e11b552a6f58f6:
     Automated rollback of commit
     314b0900cec69a9d017ab84e94ee1cc0b6782470.
```

Important changes:

  - Bazel uses the D8 jar from Maven instead of the SDK.
  - Make ijar / java_import preserve classes with `@kotlin.Metadata`
    annotations
  - Bazel uses the D8 jar from Maven instead of the SDK.
  - android_sdk_repository read $ANDROID_SDK_ROOT in addition to
    $ANDROID_HOME.

This release contains contributions from many people at Google, as well as Alex Torok, gkorlam, hvadehra, Vasilios Pantazopoulos, Yannic.

## Release 6.0.0-pre.20220411.2 (2022-04-19)

```
Baseline: 8f0034ce1e7854521e259a5eaf71859b1e6f95bc

Cherry picks:

   + a9465dfa4b124e331b8bb3e8d0219ea3dff7cdb1:
     Automated rollback of commit
     240af807c935225d98b630666000cc03934f2ce7.
```

Important changes:

  - Allow specialization to work with constraint_values.

This release contains contributions from many people at Google, as well as Brentley Jones, Fabian Meumertzheim, Keith Smiley, Noa Resare, Sahin Yort, Thomas Zayouna, Vasilios Pantazopoulos.

## Release 6.0.0-pre.20220407.1 (2022-04-14)

```
Baseline: 9db58e0656d7456e8180e90400c2c94a76bf5c8b
```

Incompatible changes:

  - this incompatible change breaks old instances of http_archive
    that specified netrc as an absolute path. It is unlikely there
    are many instances in the wild since the path would refer to a
    netrc file inside the external repository by absolute path.
    Migration should be straightforward.
  - genrule switched to use exec transition instead of host. This can
    break targets with hardcoded output paths. To avoid using
    hardcoded paths use make variables, see
    https://docs.bazel.build/versions/4.2.2/be/make-variables.html#pre
    defined_label_variables
  - this incompatible change breaks old instances of http_archive
    that specified netrc as an absolute path. It is unlikely there
    are many instances in the wild since...
  - Error Prone now checks for unused return values of additional
    methods on `java.lang.Object`, which can be disabled using
    `--javacopts=-Xep:ReturnValueIgnored:OFF`
  - Error Prone now checks for unused return values of additional
    methods on `java.lang.Object`, which can be disabled using
    `--javacopts=-Xep:ReturnValueIgnored:OFF`
  - The --incompatible_existing_rules_immutable_view flag has been
    flipped to true. See
    https://github.com/bazelbuild/bazel/issues/13907 for
    migration notes.

Important changes:

  - Deprecate --incompatible_applicable_licenses flag, in preparation
    for removal in Bazel 6.x.
  - Treat py_*.srcs_version="PY2" the same as "PY2ONLY".
  - The Build Event Protocol now contains file digests and sizes
    along with the file name and URI.
  - Refactor system suspend event handling.
  - alias() can now select() directly on constraint_value()
  - Allow \a \b \f \v escape sequences in Starlark.
  - Match remote and local xcode version by most granular version.
  - Adds `--experimental_worker_multiplex_sandboxing` flag that
    controls whether to sandbox multiplex workers that support it.
  - provider() has a new parameter: init, a callback for performing
    pre-processing and validation of field values. Iff this parameter
    is set,
    provider() returns a tuple of 2 elements: the usual provider
    symbol (which,
    when called, invokes init) and a raw constructor (which bypasses
    init).
  - Tests that fail to create or complete their
    `TestAttemptContinuation` by
    throwing an `ExecException` will report an `INCOMPLETE` status.
    Previously, Bazel
    would fail to report any status for the test attempt.
  - Fixed an issue where Bazel could erroneously report a test passes
    in coverage mode without actually running the test.
  - Include more information about configurations in cquery proto
    formatted output. This deprecates the configuration field of
    AnalysisProtosV2.ConfiguredTarget, and adds a new field,
    configuration_id, to
    be used instead.
  - experimental cc_library.implementation_deps inverted to
    interface_deps
  - In aquery and cquery proto output, indicate if a configuration is
    a
    tool or non-tool configuration.
  - Include complete configurations in cquery proto output.
  - experimental cc_library.implementation_deps inverted to
    interface_deps
  - Make protocOpts() publicly accessible.
  - Add some documentation about how configuration information is
    conveyed in cquery proto output.
  - Introduces experimental static library linking API under
    apple_common.link_multi_arch_static_library
  - Further deprecation and removal of pkg_tar. Stop supporting
    legacy use of 'files' attribute, where it could be a list of
    labels instead of a map of paths to labels.
  - Removed --incompatible_no_build_defs_pkg flag. It never fulfilled
    its purpose because --all_incompatible_changes would never set
    it. The last rule it gated (pkg_tar) is scheduled to be removed
    in Bazel 6.x.
  - Add coverage configuration fragment, used to expose
    output_generator label.
  - Bazel now no longer includes system headers on macOS in coverage
    reports (#14969).
  - android_sdk_repository read $ANDROID_SDK_ROOT in addition to
    $ANDROID_HOME.
  - The default dexer is now d8. dx can be optionally enabled using:
      --define=android_dexmerger_tool=dx_dexmerger \
      --define=android_incremental_dexing_tool=dx_dexbuilder \
      --define=android_standalone_dexing_tool=dx_compat_dx \
      --use_workers_with_dexbuilder
  - Packaging support for deploy JAR embedded JDK files (hermetic
    Java).
  - Don't stamp cc_common.link actions for tool dependencies.
  - Starlark test rules can use the new inherited_environment
    parameter of testing.TestEnvironment to specify environment
    variables
    whose values should be inherited from the shell environment.
  - Enable merging permissions during Android manifest merging with
    the --merge_android_manifest_permissions flag.

This release contains contributions from many people at Google, as well as Adam Wolf, Albert Lloveras, Alessandro Patti, Alex Eagle, Alex Scott, Andreas Herrmann, Andrew Katson, arunkumar9t2, Ast-x64, Benedek Thaler, Benjamin Lee, Benjamin Peterson, Ben Lee, Bohdan Vanieiev, Bradley Burns, Brandon Jacklyn, Brentley Jones, Brentley Jones, Chad Miller, Chris Fredrickson, Christopher Sauer, ckiffel, Cristian Hancila, crydell-ericsson, Dan Fleming, Daniel Wagner-Hall, Danny Wolf, David Ostrovsky, Denys Kurylenko, Dimi Shahbaz, divanorama, dmaclach, Ed Schouten, Fabian Meumertzheim, floriographygoth, Fredrik Medley, gkgoat1, Greg Estren, Greg, Hannes Kufler, hvadehra, Jan, Jay Bazuzi, jheaff1, Jiawen Chen, Joel Williamson, juanchoviedo, Keith Smiley, Ken Micklas, Kevin Lin, lihu, Luc Bertrand, Marek uppa, Matt Mackay, Michael P. Nitowski, Mikhail Balabin, Mostyn Bramley-Moore, Nick Korostelev, Nitesh Anandan, Niyas Sait, Noa Resare, Oscar Bonilla, Patrick Balestra, Paul Tarjan, Pras Velagapudi, Rahul Butani, Rifqi Mulya Fahmi, Ryan Schmidt, Simon Bjorklen, Son Luong Ngoc, Stiopa Koltsov, Sven Tiffe, Ted Kaplan, Tetsuo Kiso, Thi Doan, Thomas Zayouna, Timothe Peignier, Ulf Adams, Ulrik Falklof, Vasilios Pantazopoulos, William Muir, Xavier Bonaventura, Xdng Yng, Yannic Bonenberger, Yesudeep Mangalapilly, Yuval K, Zhongpeng Lin.

## Release 5.1.1 (2022-04-08)

```
Baseline: 8d66a4171baddcbe1569972f019e54130111202c

Cherry picks:

   + becd1494481b96d2bc08055d3d9d4d7968d9702e:
     Remote: Cache merkle trees
   + d7628e1b566be353fe7172241ac8f15d5f8e7ff5:
     Update DEFAULT_IOS_CPU for M1 arm64 simulator support
   + 80c56ff7b603fcfff02a5f97829a2a5935f360a0:
     Compile Apple tools as fat binaries if possible
   + 3c09f3438a966b49a7c1726022c898b390b3a6e5:
     Add protobuf as a well known module
   + 3a5b3606a6f5433467a5b49f0188c41411684bf5:
     Remote: Merge target-level exec_properties with
     --remote_default_exec_properties
   + 917e15ea408e1d3d25574edbb466b39cfbcb61fe:
     Add -no_uuid for hermetic macOS toolchain setup
   + f5cf8b076bc913dbe021104d5f6837fb4a6cd8b3:
     Remote: Fixes an issue when --experimental_remote_cache_async
     encounter flaky tests.
   + 77a002cce050e861fcc87c89acf7768aa5c97124:
     Remove DigestUtils.getDigestInExclusiveMode() now that SsdModule
     has …
   + 557a7e71eeb5396f2c87c909ddc025fde2678780:
     Fixes for the Starlark transition hash computation (#14251)
   + 34c71465f84fa780217926db2e8e5ca3d6d4568c:
     Do location expansion in copts of objc_library
   + 50274a9f714616d4735a560db7f617e53fb8d01b:
     [5.x] Remote: Add support for compression on gRPC cache (#14277)
   + 61bf2e5b5181cbe34a2f0d584053570943881804:
     Automated rollback of commit
     34c71465f84fa780217926db2e8e5ca3d6d4568c.
   + 79888fe7369479c398bafe064daa19a7ae30f710:
     Silence a zstd-jni GCC warning.
   + 063b5c9c2c09b4794010b9a169b44890ffc79ec4:
     Remote: Limit max number of gRPC connections by
     --remote_max_connections.
   + fd727ec96d861573dcbad3249d727a94eff84789:
     Do location expansion in copts of objc_library
   + 23d096931be9b7247eafa750999dd7feadde14c1:
     Fix _is_shared_library_extension_valid
   + 5cf1d6e1f78bc860fcd0e2e86eff6fe43ab4a5a2:
     Remove merging of java_outputs in JavaPluginInfo.
   + cea5f4f499aa832cf90c68898671869ce79d63f2:
     Cherrypick Bzlmod documentation (#14301)
   + 227e49e28e5122cddd6c4cb70686ff7bde3617ea:
     Format work requests according to ndjson spec
   + ae0a6c98d4f94abedbedb2d51c27de5febd7df67:
     Enable user_link_flags_feature for macosx cc_toolchain_config
   + 8c2c78cdc66cc9d5eb2cd59823c659892c1643a7:
     Remote: Use Action's salt field to differentiate cache across
     workspaces.
   + f94898915268be5670fb1e93a16c03e9b14d2a58:
     [5.x] Remote: Fix "file not found" error when remote cache is
     changed from enabled to disabled.  (#14321)
   + 3069ac4e33dcca6f3d1abf55940cdd764d03bdbf:
     Delete marker file before fetching an external repository
   + c05c6261cdb2cacb7c9881c255c0ada435ab5182:
     Remote: Fix file counting in merkletree.DirectoryTreeBuilder
   + d84f7998ef8f15e27376a0c8f25b320145c4ba9e:
     Fix remote spawn tests for remote_merkle_tree_cache=true
   + 59e16e944200555da377799aa0d9e8d0674d2e27:
     Show skipped tests as a warning
   + 76b3c242831f8e88835e3002a831a185a41fcc52:
     Build xcode-locator as a universal binary
   + aa52f2ddf9bab1ebd18e5431124061e813bfcd80:
     Exit collect_coverage.sh early if LCOV_MERGER is not set.
   + 4256d46327bad8638df91be1a5d4ef83b12b74c7:
     Automated rollback of commit
     d84f7998ef8f15e27376a0c8f25b320145c4ba9e.
   + dce24350befd08216b3910ae343670015444ff81:
     [apple] fix issues compiling C in objc_library for watchos/armv7k
   + bfc24139d93f8643686d91596ba347df2e01966a:
     5.x: Remote: Ignore blobs referenced in BEP if the generating
     action cannot be cached remotely. (#14389)
   + 5aef53a8884038f3c9f06e6dddb9372196253378:
     Remote: Don't blocking-get when acquiring gRPC connections.
     (#14420)
   + 005361c895da334beb873901e93aff06d180256e:
     Disable IncludeValidation for ObjC in bazel
   + d703b7b4f09fb3c389f99e52bac1f23930280b56:
     Update java_tools v11.6
   + 90965b072eb4a6dec8ff5b8abde3726732d37bdc:
     Stop remote blob upload if upload is complete. (#14467)
   + dc59d9e8f7937f2e317c042e8da8f97ba6b1237e:
     [5.x] Make remote BES uploader better (#14472)
   + 2edab739e1f61fe8813230b03396ca46f0790089:
     Avoid too verbose warnings in terminal when cache issues
   + 1160485192b5e6d95bcd426b55cc9a35fc6b8614:
     Rename --project_id to --bes_instance_name
   + c63d9ecbe5fcb5716a0be21d8fc781d7aa5bbc30:
     Automated rollback of commit
     bfdfa6ebfd21b388f1c91f512291c848e1a92a96.
   + b341802700484d11c775bf02d80f43ba3f33b218:
     [apple] support watchos_arm64 in toolchain
   + 43bcf80a3dfdc5ac89c1e4d615d6f29a495855fb:
     Disable implicitly collecting baseline coverage for toolchain
     targets.
   + 302971e1b3d803069ac949c0085c0d2a3916c8ab:
     Automated rollback of commit
     7d09b4a15985052670244c277e4357557b4d0039.
   + 62002024ca7012ffe0f4fc74ac20b5471513c8c8:
     Bzlmod: Starlarkify default attr values for TypeCheckedTags
   + 38117d491cbc4a5686e0bdb1e58f8946d96aed58:
     Fix build after rc4 cherrypicks (#14581)
   + 41feb616ae18e21fdba3868e4c298b0b83012f10:
     Release 5.0.0 (2022-01-19)
   + 486d153d1981c3f47129f675de20189667667fa7:
     Find runfiles in directories that are themselves runfiles
   + 0de7bb95022057e8b89334f44759cf6f950e131f:
     Don't resolve symlinks for --sandbox_base
   + 8b60c90f3641591b65c4e153113aea562f1fab94:
     Remove uses of -lstdc++ on darwin
   + 60f757c0831f9fbb2415fb0105f964201faa9fa0:
     Allow Label instances as keys in select (#14755)
   + 3836ad029f202ca13c64c9f07e4568ea8ab2d9a6:
     Remote: Only waits for background tasks from remote execution.
   + 8734ccf9847eafb7193388cd9c6fa78faa78283f:
     Add the default solib dir to the rpath for cc_imports with
     transitions
   + 9e16a6484e94c358aa77a6ed7b1ded3243b65e8f:
     Flip --experimental_worker_allow_json_protocol
   + fce7ea8d5e0facfc125ae7c37bfb4b9a7c586e40:
     Fix `ctx.fragments.apple.single_arch_cpu` returning incorrect
     cpu for tools when host cpu and exec cpu are different
   + 0c1d09e4dce4c3251c2be2c70d4575ec65b1d9d3:
     Propagate --experimental_cc_implementation_deps to host config
   + 1c3a2456c95fd19974a5b2bd33c5ebdb2b2277e4:
     Support select() on constraint_value for aliases.
   + 67a133b431ccece22b7dd9a72f0837cff77d4360:
     Improve documentation for select()
   + 5356fedd4b6079851b51db27077bf84c7bab16a4:
     Cherrypicks for experimental cc_shared_library (#14773)
   + ffdd633d7b9f21267f4f9759dd9833096dd4e3a2:
     [apple] support tvos_sim_arm64 in toolchain (#14779)
   + a58ddea50b2fd476d183e2e0c077ad6173039b89:
     Cherry pick win arm64 (#14794)
   + dc41a20bb045d221a43223a5db6b8b44cd8f1676:
     [5.1.0] cherrypick subpackages support (#14780)
   + 86e2db7d67ec52bfe11c1f517f650653cee3ea26:
     Add a helper method for rules to depend on the cpp toolchain
     type.
   + 6990c02644a71d5e7c95c9c234ecf39bb55c6ac4:
     UrlRewriter should be able to load credentials from .netrc
     (#14834)
   + 32d1606dac2fea730abe174c41870b7ee70ae041:
     Add "arch" struct field to repository_os
   + 2cfdceae971d09f50ceddc3d7ef723fb5f879957:
     [5.x] bzlmod: Add support for WORKSPACE.bzlmod (#14813)
   + c2ddbd1954af5baab63b93f2b055a410a27832c8:
     Ignore missing include directory in JDK distribution.
   + 16de03595e21f7bf31818e717505b23c953b3b7d:
     Fix bazel coverage false negative
   + 0c74741742301abcf67452a7f591daec1c3a7635:
     Remote: Postpone the block waiting in `afterCommand` to
     `BlockWaitingModule` (#14833)
   + 3297d9234e15515aa91cc887b3b12db7e1040b02:
     Switch to `ProcessHandle` for getting the PID (#14842)
   + a987b98ea0d6da2656c4115568ef9cbe8a164550:
     Fix uses of std++ on bsd
   + d184e4883bb7fc21de2f7aeea4304994de27e9ea:
     Remote: handle early return of compressed blobs uploads
   + 0b09e9e018c557da04c9f978d25a66d963cd6cb6:
     Add removeprefix/removesuffix to Starlark strings
   + d42ab0cfcce56b5e55c8bd94d0923d08758fdb5b:
     Fix default CPU for macOS and iOS (#14923)
   + cd24f39750d7b08f6f31c82d3a23cc329c7fc78e:
     Add paramfile support for def_parser, since in rare cases on
     Windows command line character limit was reached.
   + 0b1beefd1e7611dc9b9f559d00d8ff76aabb0f32:
     Normalize rpath entries to guard against missing default solib
     dir
   + 24e82426e689853b0d9a04e7b9b6f13e145cf2d6:
     Fix aggressive params file assumption
   + c45838bd3e51bcd0c8c3e1a9b4a0e55cdf4b4f59:
     Fix precompiled libs not in runfiles of cc_shared_library
     (#14943)
   + 764614e0f0287125269e7a92e909a44624bcb360:
     Bzlmod: Allow multiple `use_extension`s on the same extension
     (#14945)
   + fa761f84994f18db383fbe9aaea524e4385da13a:
     Fix typo in `apple_common.platform` docs
   + f7d8288bd7b16c7f2e010aa8ddc241cf2ba8e0d5:
     Yield a Proxy for addresses without protocol
   + 8cefb8bed4ac82df8640682517372a9249732352:
     Avoid merging URLs in HttpUtils
   + b4804807fc2c184cc36df9e69e472942c01941b8:
     Make protocOpts() public. (#14952)
   + 113eaca5862c48797654ae2a3acbb6e15d761485:
     Do not hide BulkTransferException messages when there were more
     than one exception
   + b1bf9d6c5f85fc4fda0dc48bc3d3e2fe26880867:
     merkle_tree_cache: change default size to 1000
   + f15e0c7224ecc5473d4972afc436e28df35c4e5a:
     Add --experimental_repository_cache_urls_as_default_canonical_id
     to help detect broken repository URLs (#14989)
   + f4214746fcd15f0ef8c4e747ef8e3edca9f112a5:
     Expose the logic to read user netrc file
   + b858ec39aebd7e586af5438aa2035db2adebf9a4:
     Correct cpu and os values of `local_config_cc_toolchains` targets
   + 5e79972c05d89280f0cf1fa620f807366847bac6:
     Expose CoverageOutputGenerator on a Fragment (#14997)
   + 78f03110e0dab42f37e427fd524e72706e036d74:
     Correct error runfiles cc_shared_library (#14998)
   + 7937dd14c3c632ffcfaea9073d5dec6dcac93845:
     [5.1] Adding Starlark dependencies to the package //external
     (#14991)
   + a73aa12be65454ac8cfb5a8f3e056c420402f997:
     Remote: Fix crashes with InterruptedException when using http
     cache.
   + f8707c07f153ac4ac2ec4b210321f1a16343006d:
     Account for interface libraries in cc_shared_library
   + a570f5fdb1618a6c272d18bebaa712d3b2af3975:
     Fix coverage runfiles directory issue
   + 95de355e4524a6339c0e807b60d333c36c40bdc7:
     Do not validate input-only settings in transitions (#15048)
   + 71747ccc9d0032a865854613329362563c0574df:
     Filter out system headers on macOS.
   + cb6500a9ce648a02154dca8d05a978ce9b10c4b4:
     Update Bazel bootstrap documentation and remove obsolete flags.
     (#15065)
   + 4c031d1030afb1cb48c7e6d71f83cc99fea607c1:
     [5.1] Undocument --bes_best_effort (#15066)
   + 267142f3dc6b8d32b07beb21e3b4ba6f471a69d8:
     Fix conflicting actions error when specifying
     --host_macos_minimum_os (#15068)
   + f1923627e85b1c1d60bcd928f90f116c3ade7a3a:
     [5.1] Remote: Action should not be successful and cached if
     outputs were not created (#15071)
   + 00d74ff737cccd60305ee58d85313556a077152a:
     Support decompressing zstd tar archives for repository rules.
   + f5857830bb68bd05ffc257506575ed37a8128933:
     Remote: Don't check TreeArtifact output
   + efb2b80953983dce499d453a9f55a74ffaf8c42d:
     osx_cc_wrapper: Only expand existing response files
   + c771c43b870fb8618db7bdab6725ab40cac4976d:
     Remote: Fix crashes by InterruptedException when dynamic
     execution is enabled. (#15091)
   + 3785677cc84fc4024fda85575c05efbde5d512fc:
     Use python3 on macOS
   + 815d9e499a32fd4d87525ac0c698c293cf26433d:
     Release 5.1.0 (2022-03-24)
   + 1fbb69e366034484887e00c6006c7b79508765ed:
     Prepare 5.1.1 release
   + df153df9656e0e197f67622bb11f7d77e19238a0:
     Fix CODEOWNERS syntax
   + d418245e8cdd6eef9c6ba326f96fd4aabd046fe2:
     Remote: Don't check declared outputs for failed action (#15181)
   + ffa2a0b197d1f4ffe2031fd0b1b40da9d126793b:
     Upgrade abseil version to the latest (#15183)
   + 8ae15207ecf0be3f45b8cd249077a2c1896e2b09:
     Fix windows_export_all_symbols in cc_shared_library (#15190)
   + 94cc0985ea07a2d69ef07ac9d3a9943e094794f2:
     Support ZIP files with total number of disks = 0 (#15200)
```

Important changes:

  - alias() can now select() directly on constraint_value()
    
    Fixes https://github.com/bazelbuild/bazel/issues/13047.
    
    Closes #14310.
  - Fixed an issue where Bazel could erroneously report a test passes
    in coverage mode without actually running the test.
  - Make protocOpts() publicly accessible.
  - Add coverage configuration fragment, used to expose
    output_generator label.
  - Bazel now no longer includes system headers on macOS in coverage
    reports (#14969).
    
    Closes #14971.

This release contains contributions from many people at Google, as well as amberdixon, Benjamin Peterson, Brentley Jones, Dan Fleming, Danny Wolf, Fabian Meumertzheim, Keith Smiley, Niyas Sait, Noa Resare, Oliver Eikemeier, oquenchil, Philipp Schrader, Xùdōng Yáng, Yannic.

## Release 5.1.0 (2022-03-24)

```
Baseline: 8d66a4171baddcbe1569972f019e54130111202c

Cherry picks:

   + becd1494481b96d2bc08055d3d9d4d7968d9702e:
     Remote: Cache merkle trees
   + d7628e1b566be353fe7172241ac8f15d5f8e7ff5:
     Update DEFAULT_IOS_CPU for M1 arm64 simulator support
   + 80c56ff7b603fcfff02a5f97829a2a5935f360a0:
     Compile Apple tools as fat binaries if possible
   + 3c09f3438a966b49a7c1726022c898b390b3a6e5:
     Add protobuf as a well known module
   + 3a5b3606a6f5433467a5b49f0188c41411684bf5:
     Remote: Merge target-level exec_properties with
     --remote_default_exec_properties
   + 917e15ea408e1d3d25574edbb466b39cfbcb61fe:
     Add -no_uuid for hermetic macOS toolchain setup
   + f5cf8b076bc913dbe021104d5f6837fb4a6cd8b3:
     Remote: Fixes an issue when --experimental_remote_cache_async
     encounter flaky tests.
   + 77a002cce050e861fcc87c89acf7768aa5c97124:
     Remove DigestUtils.getDigestInExclusiveMode() now that SsdModule
     has …
   + 557a7e71eeb5396f2c87c909ddc025fde2678780:
     Fixes for the Starlark transition hash computation (#14251)
   + 34c71465f84fa780217926db2e8e5ca3d6d4568c:
     Do location expansion in copts of objc_library
   + 50274a9f714616d4735a560db7f617e53fb8d01b:
     [5.x] Remote: Add support for compression on gRPC cache (#14277)
   + 61bf2e5b5181cbe34a2f0d584053570943881804:
     Automated rollback of commit
     34c71465f84fa780217926db2e8e5ca3d6d4568c.
   + 79888fe7369479c398bafe064daa19a7ae30f710:
     Silence a zstd-jni GCC warning.
   + 8d5973d29d60c0c615838c534ee27f93377cf5af:
     Remote: Limit max number of gRPC connections by
     --remote_max_connections.
   + fd727ec96d861573dcbad3249d727a94eff84789:
     Do location expansion in copts of objc_library
   + 23d096931be9b7247eafa750999dd7feadde14c1:
     Fix _is_shared_library_extension_valid
   + 7632928a116efc4e28a02ec9206870663bcaacf7:
     Remove merging of java_outputs in JavaPluginInfo.
   + cea5f4f499aa832cf90c68898671869ce79d63f2:
     Cherrypick Bzlmod documentation (#14301)
   + 299e50aae9d8c0b7f0d47aa2ce3d2658a3a80a94:
     Format work requests according to ndjson spec (#14314)
   + e53ae63c04a7158b78da19bc76ede57a8cc31673:
     Enable user_link_flags_feature for macosx cc_toolchain_config
     (#14313)
   + b587be37b3b817879d700d7ee55c44cd884b0905:
     Remote: Use Action's salt field to differentiate cache across
     workspaces. (#14320)
   + f94898915268be5670fb1e93a16c03e9b14d2a58:
     [5.x] Remote: Fix "file not found" error when remote cache is
     changed from enabled to disabled.  (#14321)
   + dc76f74d3a6f77de03c49234386bf0ca7d15bdcc:
     Delete marker file before fetching an external repository
     (#14323)
   + fabdff40070acf415282543b72cf114e2b5723f6:
     Remote: Fix file counting in merkletree.DirectoryTreeBuilder
     (#14331)
   + 541ed05702751a5b061b22f1ff98f0cef17af1a5:
     Fix remote spawn tests for remote_merkle_tree_cache=true (#14334)
   + aa884df6b09ed19fccd83aad67f39653fde5fbed:
     Show skipped tests as a warning (#14345)
   + 6916fc1c4c49134ee76b9a725deddd1e6bcab24a:
     Build xcode-locator as a universal binary (#14351)
   + ffa12adb44e86772ae48eeb5a387f172130407fa:
     Exit collect_coverage.sh early if LCOV_MERGER is not set.
     (#14359)
   + b46de754aba0f24d67cd9c882f8a82428915fae5:
     Automated rollback of commit
     d84f7998ef8f15e27376a0c8f25b320145c4ba9e. (#14358)
   + 24a340a50a11e255dff656d2ee9b3dcfb093b729:
     [apple] fix issues compiling C in objc_library for watchos/armv7k
   + bfc24139d93f8643686d91596ba347df2e01966a:
     5.x: Remote: Ignore blobs referenced in BEP if the generating
     action cannot be cached remotely. (#14389)
   + 5aef53a8884038f3c9f06e6dddb9372196253378:
     Remote: Don't blocking-get when acquiring gRPC connections.
     (#14420)
   + 2fb7dfe7b35b5997cc5fbcd1d98612b99419f097:
     Disable IncludeValidation for ObjC in bazel (#14440)
   + 7deb940f3840e6ac3233963a9b68227e7f0f4a9e:
     Update java_tools v11.6 (#14423)
   + 90965b072eb4a6dec8ff5b8abde3726732d37bdc:
     Stop remote blob upload if upload is complete. (#14467)
   + dc59d9e8f7937f2e317c042e8da8f97ba6b1237e:
     [5.x] Make remote BES uploader better (#14472)
   + d7f134110631641ea8c3f9b19b37165bb177ef2e:
     Avoid too verbose warnings in terminal when cache issues (#14504)
   + 2b48c6b9a447756fcb3295b8a75899b96efa7fd4:
     Rename --project_id to --bes_instance_name (#14507)
   + 7c7f102576c917acf6c9d6013a5c7c4783bf396d:
     Automated rollback of commit
     bfdfa6ebfd21b388f1c91f512291c848e1a92a96. (#14515)
   + 9c1c622fed219cb6b9c0656ebe4a4f3c117029b9:
     [apple] support watchos_arm64 in toolchain (#14527)
   + 43bcf80a3dfdc5ac89c1e4d615d6f29a495855fb:
     Disable implicitly collecting baseline coverage for toolchain
     targets.
   + 48a0fc51ccf6a3a263b9f8d96921d84d4243e0e6:
     Automated rollback of commit
     7d09b4a15985052670244c277e4357557b4d0039.
   + a233aaa649572b7173ea27aceed31cb705d7ba9b:
     Bzlmod: Starlarkify default attr values for TypeCheckedTags
   + 38117d491cbc4a5686e0bdb1e58f8946d96aed58:
     Fix build after rc4 cherrypicks (#14581)
   + 41feb616ae18e21fdba3868e4c298b0b83012f10:
     Release 5.0.0 (2022-01-19)
   + d53f53cf5cc05c738a9857ca95059ce8903107cd:
     Find runfiles in directories that are themselves runfiles
     (#14737)
   + 167e79f08a95ae14edfb44d85452c9c74e0f1a3c:
     Don't resolve symlinks for --sandbox_base (#14748)
   + 22bede95a5a74c61571d3b50c14488b0e922ff63:
     Remove uses of -lstdc++ on darwin (#14750)
   + 60f757c0831f9fbb2415fb0105f964201faa9fa0:
     Allow Label instances as keys in select (#14755)
   + a5f2813acf3e31aeb3037d80a6f9d7fddf76a1c8:
     Remote: Only waits for background tasks from remote execution.
     (#14752)
   + d17a769965f12363f339c7b93524f49dbcdd1b1e:
     Add the default solib dir to the rpath for cc_imports with
     transitions (#14757)
   + 53ee76e96365bdea88847f77706d55f2c39b9273:
     Flip --experimental_worker_allow_json_protocol (#14749)
   + 21ff46a639a83084975251ca7c21cfc8d74763eb:
     Fix `ctx.fragments.apple.single_arch_cpu` returning incorrect
     cpu for tools when host cpu and exec cpu are different (#14751)
   + 0c1d09e4dce4c3251c2be2c70d4575ec65b1d9d3:
     Propagate --experimental_cc_implementation_deps to host config
   + 0df1851f0759279d84c79ea6731552437c95ce65:
     Support select() on constraint_value for aliases. (#14754)
   + 58ecec37747636b3483bbcba29a7f3e0e2372697:
     Improve documentation for select() (#14769)
   + 5356fedd4b6079851b51db27077bf84c7bab16a4:
     Cherrypicks for experimental cc_shared_library (#14773)
   + ffdd633d7b9f21267f4f9759dd9833096dd4e3a2:
     [apple] support tvos_sim_arm64 in toolchain (#14779)
   + a58ddea50b2fd476d183e2e0c077ad6173039b89:
     Cherry pick win arm64 (#14794)
   + dc41a20bb045d221a43223a5db6b8b44cd8f1676:
     [5.1.0] cherrypick subpackages support (#14780)
   + af34c452c12dae8758340dc5c284cf30f3c80302:
     Add a helper method for rules to depend on the cpp toolchain
     type. (#14795)
   + 6990c02644a71d5e7c95c9c234ecf39bb55c6ac4:
     UrlRewriter should be able to load credentials from .netrc
     (#14834)
   + 65904046031325c418734dfda994bdeff4134160:
     Add "arch" struct field to repository_os (#14835)
   + 2cfdceae971d09f50ceddc3d7ef723fb5f879957:
     [5.x] bzlmod: Add support for WORKSPACE.bzlmod (#14813)
   + 59384ddee429ca363022c2a03b62a5a9a43c31c4:
     Ignore missing include directory in JDK distribution. (#14832)
   + 344e8f8e97db2e2aa9b2fce7d68083a7549e4bc6:
     Fix bazel coverage false negative (#14836)
   + 0c74741742301abcf67452a7f591daec1c3a7635:
     Remote: Postpone the block waiting in `afterCommand` to
     `BlockWaitingModule` (#14833)
   + 3297d9234e15515aa91cc887b3b12db7e1040b02:
     Switch to `ProcessHandle` for getting the PID (#14842)
   + 031a772acfd304fb5678e6a53e6c4ac3b99103ff:
     Fix uses of std++ on bsd (#14860)
   + 8ebd70b0c97c8bd584647f219be8dd52217cb5cf:
     Remote: handle early return of compressed blobs uploads (#14885)
   + 50bb742fc35c04ab422a7ce723160b27d6900e6c:
     Add removeprefix/removesuffix to Starlark strings (#14899)
   + d42ab0cfcce56b5e55c8bd94d0923d08758fdb5b:
     Fix default CPU for macOS and iOS (#14923)
   + ed7a10d6170049877a07cf27edaf8db65d17f77b:
     Add param file for def parser action (#14925)
   + e624aff6d63dd6264d7ff56ec9650b7a1aeb3a36:
     Normalize rpath entries to guard against missing default solib
     dir (#14929)
   + c1ecca22d2cb761bd094fcd40eb8b13e826e777e:
     Fix aggressive params file assumption (#14930)
   + c45838bd3e51bcd0c8c3e1a9b4a0e55cdf4b4f59:
     Fix precompiled libs not in runfiles of cc_shared_library
     (#14943)
   + 764614e0f0287125269e7a92e909a44624bcb360:
     Bzlmod: Allow multiple `use_extension`s on the same extension
     (#14945)
   + 85d7ed68fa7bd84a5a23baf0431cbb04d64d7fa6:
     Fix typo in `apple_common.platform` docs (#14958)
   + a6a430540879bd866dfbef5cd048b2a4ab6bd883:
     Yield a Proxy for addresses without protocol (#14956)
   + 698da7e563b76633c973ea3029b7e313b69545fd:
     Avoid merging URLs in HttpUtils (#14954)
   + b4804807fc2c184cc36df9e69e472942c01941b8:
     Make protocOpts() public. (#14952)
   + 61cfa1d01eefb0923e8e3029ab9e92fdfe77ff50:
     Do not hide BulkTransferException messages when there were more
     than one exception (#14986)
   + 0764821a8c1175fbcbca630d3681901244b33095:
     merkle_tree_cache: change default size to 1000 (#14984)
   + f15e0c7224ecc5473d4972afc436e28df35c4e5a:
     Add --experimental_repository_cache_urls_as_default_canonical_id
     to help detect broken repository URLs (#14989)
   + 87ef5ce4103be75e8d9935e071fa215a481536e1:
     Expose the logic to read user netrc file (#14990)
   + 785c7ecafa9b93e700e846397c3a13c320c1dbdd:
     Correct cpu and os values of `local_config_cc_toolchains`
     targets (#14995)
   + 5e79972c05d89280f0cf1fa620f807366847bac6:
     Expose CoverageOutputGenerator on a Fragment (#14997)
   + 78f03110e0dab42f37e427fd524e72706e036d74:
     Correct error runfiles cc_shared_library (#14998)
   + 7937dd14c3c632ffcfaea9073d5dec6dcac93845:
     [5.1] Adding Starlark dependencies to the package //external
     (#14991)
   + 6cd6a27d4480eff91258ef8258b5af1901acde65:
     Remote: Fix crashes with InterruptedException when using http
     cache. (#14999)
   + 91a580ad198a9d7f179c1822d55f75ba5318e2ce:
     Fix interface_library-only libraries_to_link for
     cc_shared_library (#15046)
   + 1345938867e5c0c381f46cccf889c7b2b20a867a:
     Fix coverage runfiles directory issue (#15047)
   + 95de355e4524a6339c0e807b60d333c36c40bdc7:
     Do not validate input-only settings in transitions (#15048)
   + f19d6107bca9aea7742bd66eb3080f29fcf3bd81:
     Filter out system headers on macOS. (#15020)
   + cb6500a9ce648a02154dca8d05a978ce9b10c4b4:
     Update Bazel bootstrap documentation and remove obsolete flags.
     (#15065)
   + 4c031d1030afb1cb48c7e6d71f83cc99fea607c1:
     [5.1] Undocument --bes_best_effort (#15066)
   + 267142f3dc6b8d32b07beb21e3b4ba6f471a69d8:
     Fix conflicting actions error when specifying
     --host_macos_minimum_os (#15068)
   + f1923627e85b1c1d60bcd928f90f116c3ade7a3a:
     [5.1] Remote: Action should not be successful and cached if
     outputs were not created (#15071)
   + 6d26dc74da2602817d56b0507ec79394c35a3781:
     Support decompressing zstd tar archives for repository rules.
     (#15087)
   + 376cd472bbf7d81c7feb79563e7894cc3d74151a:
     Remote: Don't check TreeArtifact output (#15085)
   + 48b60d22bca0158d194b78481ff86b0ac251243f:
     osx_cc_wrapper: Only expand existing response files (#15090)
   + c771c43b870fb8618db7bdab6725ab40cac4976d:
     Remote: Fix crashes by InterruptedException when dynamic
     execution is enabled. (#15091)
   + 3b2d686f2976e66ca4f93b568f2262a88621855a:
     Use python3 on macOS (#15102)
```

Important changes:

  - alias() can now select() directly on constraint_value()
    
    Fixes https://github.com/bazelbuild/bazel/issues/13047.
    
    Closes #14310.
  - Fixed an issue where Bazel could erroneously report a test passes
    in coverage mode without actually running the test.
  - Make protocOpts() publicly accessible.
  - Add coverage configuration fragment, used to expose
    output_generator label.
  - Bazel now no longer includes system headers on macOS in coverage
    reports (#14969).
    
    Closes #14971.

This release contains contributions from many people at Google, as well as amberdixon, Benjamin Peterson, Brentley Jones, Dan Fleming, Danny Wolf, Fabian Meumertzheim, Keith Smiley, Niyas Sait, Noa Resare, Oliver Eikemeier, oquenchil, Philipp Schrader, Xùdōng Yáng, Yannic.

## Release 6.0.0-pre.20211101.2 (2021-11-11)

```
Baseline: 9c65356cedcf4e68077219c10f5a7bb39d38054b

Cherry picks:

   + 2c9721f9ba11979eee1fd95fe793b52369df99ac:
     Automated rollback of commit
     9c65356cedcf4e68077219c10f5a7bb39d38054b.
```

Important changes:

  - Deprecate --incompatible_applicable_licenses flag, in preparation
    for removal in Bazel 6.x.

This release contains contributions from many people at Google, as well as Alex Eagle, Benjamin Peterson, Ben Lee, Fabian Meumertzheim, Fredrik Medley, Keith Smiley, Rahul Butani, Ulf Adams, William Muir.

## Release 6.0.0-pre.20211025.1 (2021-11-03)

```
Baseline: 5c04973b000b6e1819d6b51d238498a0b507c7af
```

Important changes:

  - Bazel no longer supports Java 8. From this version on, the
    minimum required JDK is OpenJDK 11.

This release contains contributions from many people at Google, as well as Benjamin Peterson, John Laxson, Keith Smiley, Thi Don.

## Release 6.0.0-pre.20211019.1 (2021-10-26)

```
Baseline: 406fc1ba5fae98843c99f89a43dcbdbca0d90274
```

Incompatible changes:

  - Remove `--experimental_profile_cpu_usage`.
  - flipped --incompatible_java_common_parameters (see #12373)

This release contains contributions from many people at Google, as well as ecngtng, Fabian Meumertzheim, Keith Smiley, Mauricio Galindo, Thaler Benedek.

## Release 5.0.0-pre.20211011.2 (2021-10-20)

```
Baseline: 3b3bad9e774891856c198738c46d547de954b84a

Cherry picks:

   + d8c23189c9118f99cfc3eaac98976b7c6fdacae0:
     Automated rollback of commit
     2571ce2d9e72ee60326ef524fee1702cb2dd07e7.
```

Incompatible changes:

  - Removed --action_graph from the dump command.
  - Remove `--{experimental_,}json_trace_compression` option.

Important changes:

  - The --experimental_existing_rules_immutable_view flag has been
    renamed to  --incompatible_existing_rules_immutable_view

This release contains contributions from many people at Google, as well as Alex Eagle, hvadehra, Keith Smiley, Torgil Svensson, Yuval.

## Release 5.0.0-pre.20211006.1 (2021-10-19)

```
Baseline: 681886de2901a2f7920288253674927cf13f1585
```

Important changes:

  - incompatible_disable_depset_items is flipped

This release contains contributions from many people at Google, as well as Fabian Meumertzheim, Keith Smiley, Thomas Carmet, Timothe Peignier.

## Release 5.0.0-pre.20210929.1 (2021-10-07)

```
Baseline: 61a5fae1b49ed067350d93578da268715031df06
```

Important changes:

  - The deprecated "relative_to_caller_repository" parameter has been
    removed from the Label constructor.
  - The toolchain transition is now enabled for all toolchains.

This release contains contributions from many people at Google, as well as Artem V. Navrotskiy, hvadehra, Ikko Ashimine, Paul Gschwendtner, ron-stripe, Yuval K.

## Release 5.0.0-pre.20210923.7 (2021-09-30)

```
Baseline: 9a765c8b498a72e20af6c391bef01e794913c317

Cherry picks:

   + f959a22bc59229b723cfca8c987da210b03b8a8d:
     Rollback.
```

Important changes:

  - Add support to length-delimited protos as undeclared output
    annotations []

This release contains contributions from many people at Google, as well as Benjamin Peterson, Brandon Jacklyn, Rabi Shanker Guha.

## Release 5.0.0-pre.20210921.1 (2021-09-27)

```
Baseline: 11f1a6d3ce529a63d4b7111c62ae504ceac2a019
```

Incompatible changes:

  - Remove --bep_publish_used_heap_size_post_build
  - JSON trace profile: rename counter names.

Important changes:

  - Adds --experimental_existing_rules_immutable_view flag to make the
    native.existing_rule and native.existing_rules functions more
    efficient by
    returning immutable, lightweight dict-like view objects instead
    of mutable
    dicts.

This release contains contributions from many people at Google, as well as Wren Turkal.

## Release 5.0.0-pre.20210916.1 (2021-09-23)

```
Baseline: e4a26b6391fd2d3112a29bf81b4397055c854184
```

This release contains contributions from many people at Google, as well as Peter Kasting, Ulrik Falklof.

## Release 5.0.0-pre.20210913.1 (2021-09-17)

```
Baseline: 0017fd23e1ff9aea7241c92a503024e3f2a3425b
```

This release contains contributions from many people at Google, as well as Keith Smiley, Mathieu Olivari, Yannic Bonenberger.

## Release 5.0.0-pre.20210907.1 (2021-09-14)

```
Baseline: 9cb59369a84d9328c2929eefcb58c1b972ab15f2
```

Important changes:

  - The `--toolchain_resolution_debug` flag now accepts regexes
    matching targets, as well as toolchain types, when choosing what
    debug messages to print.

This release contains contributions from many people at Google, as well as Benjamin Peterson, frazze-jobb, Tetsuo Kiso.

## Release 5.0.0-pre.20210831.2 (2021-09-10)

```
Baseline: 14fe5dff967cf91f130746f646d1bb1cfc1053f2

Cherry picks:

   + 6f5c4bb4d17abd6b9654f255c12775eb35638000:
     Automated rollback of commit
     8181f0abe6591bc14957e6a941a6556fb040ca9f.
```

Important changes:

  - The --all_incompatible_changes flag is now a no-op

This release contains contributions from many people at Google, as well as Keith Smiley, kekxv, ron-stripe, Sergey Tyurin.

## Release 5.0.0-pre.20210826.1 (2021-09-03)

```
Baseline: f53c389dbd4b0ae66307e9bd4a72b36b3d284ec3
```

Incompatible changes:

  - Removing java_common.javac_jar Starlark call.
  - native.existing_rule now returns select values in a form that is
    accepted by rule instantiation. This is a breaking API change
    because there is some code that relies on the precise type
    returned, including brittle workarounds for this bug specifically
    and insufficiently flexible workarounds for other issues with the
    intersection of select and native.existing_rule.
  - flipped incompatible_use_toolchain_resolution_for_java_rules, see
    #7849
  - Query output=xml/proto/location for source files will now show
    the location of line 1 of the source file (as the new default)
    instead of its location in the BUILD file.
  - Specifying a target pattern underneath a directory specified by
    .bazelignore will now emit a warning, not an error.
  - Query `--order_output=auto` will now sort lexicographically.
    However, when `somepath` is used as a top level function (e.g.
    `query 'somepath(a, b)'`), it will continue to output in
    dependency order. If you do not want the lexicographical output
    ordering, specify another `--order_output` value (`no`, `deps` or
    `full`) based on what ordering you require.
  - In the build event stream,
    BuildMetrics.TargetMetrics.targets_loaded is no longer populated.
    Its value was always mostly meaningless.
    BuildMetrics.TargetMetrics.targets_configured and
    BuildMetrics.ActionSummary.actions_created now include configured
    aspect data.
  - //visibility:legacy_public has been removed.
  - Flip and remove incompatible_dont_collect_so_artifacts
    (https://github.com/bazelbuild/bazel/issues/13043).
  - Remove flag --experimental_no_product_name_out_symlink: it is
    always true.
  - The Starlark method generate_dsym in objc fragment has
    been deleted.  Please use the equivalent apple_generate_dsym in
    cpp
    fragment instead.
  - Native libraries in data attribute are not collected. See
    https://github.com/bazelbuild/bazel/issues/13550 for details
  - Enforce the `--profile` path to be absolute.
  - Enforce the --memory_profile path to be absolute.
  - JavaToolchainInfo.jvm_opt returns Depset instead of a list.
  - --apple_sdk has been deleted.  It is a no-op.
  - --bep_publish_used_heap_size_post_build is now a no-op and will
    be deleted in a future release. Use --memory_profile=/dev/null
    instead.
  - Flipped --incompatible_disallow_resource_jars (see
    https://github.com/bazelbuild/bazel/issues/13221).

New features:

  - Args.add_all and Args.add_joined can now accept closures in
    map_each if explicitly enabled via allow_closure.
  - Add `--bes_header` flag to pass extra headers to the BES server.

Important changes:

  - Flag --incompatible_objc_compile_info_migration is removed.  See
    #10854.
  - Flag --incompatible_objc_compile_info_migration is removed.  See
    #10854.
  - Flag --incompatible_objc_compile_info_migration is removed.  See
    #10854.
  - none
    PAIR=cmita
  - The --incompatible_load_python_rules_from_bzl flag is now a no-op.
  - Filter all (instead of just C++) source files for coverage output
    according to --instrumentation_filter and
    --instrument_test_targets.
  - The `--incompatible_disable_native_apple_binary_rule` flag has
    been added which disables the native `apple_binary` rule. Users
    who need to use `apple_binary` directly (if they cannot use one
    of the more specific Apple rules) should load it from
    https://github.com/bazelbuild/rules_apple.
  - The Android rules' --use_singlejar_apkbuilder is now a no-op.
    SingleJar will always be used to build APKs.
  - dict.setdefault(key, ...) now fails if dict is frozen, even if it
    already contains key. This is an incompatible API change.
  - Flag --incompatible_objc_provider_remove_compile_info is removed.
     See #11359.
  - Starlark now permits def statements to be nested (closures).
  - native.existing_rule now returns select values in a form that is
    accepted by rule instantiation. This is a breaking API change,
    though the fallout is expected to be small.
  - Starlark now supports lambda (anonymous function) expressions.
  - The "test" and "coverage" commands no longer return 3 when a
    test action fails because of a system error. Instead, the exit
    code
    reflects the type of system error.
  - The undocumented ctx.expand feature no longer exists.
  - Make --legacy_dynamic_scheduler a no-op flag.
  - Multiplex persistent workers can now use the JSON protocol.
  - native.existing_rule now returns a mutable list, not a tuple, for
    a list-valued attributes. This is an incompatible API change.
  - Roll back change to have native.existing_rules use list instead
    of tuple.
  - BEP includes test suite expansions.
  - config_setting now honors `visibility` attribute (and defaults to
    `//visibility:public`)
  - Change the MultiArchSplitTransitionProvider to be based on
    platform type + CPU instead of fixed "ios_" + cpu.
  - enforce config_setting visibility. See
    https://github.com/bazelbuild/bazel/issues/12932 for details.
  - add a flag to build v4 signature file
  - Added _direct_source_jars output group to Java related targets.
    END_PUBLIC
  - pkg_deb is no longer part of @bazel_tools//build_defs/pkg:pkg.bzl.
    Use https://github.com/bazelbuild/rules_pkg/tree/main/pkg instead
  - Allowing the lipo operations to be conditional in the
    linkMultiArchBinary API for Apple binaries. Single architecture
    slices are now returned through AppleBinaryOutput and the
    Starlark API.
  - Release restriction for "-" in the package name for Python
    sources. Now `py_binary` and `py_test` targets can have main
    source file with "-" in the path.
  - Users consuming BEP may assume that a `named_set_of_files` event
    will
    appear before any event referencing that `named_set` by ID. This
    allows consumers
    to process the files for such events (eg. `TargetCompleted`)
    immediately.
  - BEP includes all files from successful actions in requested
    output groups.
    Previously, an output group's files were excluded if any file in
    the output group
    was not produced due to a failing action. Users can expect BEP
    output to be larger
    for failed builds.
  - In BEP, TargetComplete.output_group has a new field `incomplete`
    indicating that the file_sets field is missing one or more
    declared artifacts
    whose generating actions failed.
  - The flag `--toolchain_resolution_debug` now takes a regex
    argument, which is used to check which toolchain types should
    have debug info printed. You may use `.*` as an argument to keep
    the current behavior of debugging every toolchain type.
  - Add runfiles.merge_all() for merging a sequence of runfiles
    objects.
  - runfiles.merge() and merge_all() now respect
    --nested_set_depth_limit.
    If you hit the depth limit because you were calling merge() in a
    loop, use
    merge_all() on a sequence of runfiles objects instead.
  - Bazel will no longer create a bazel-out symlink if
    --symlink_prefix is specified: the directory pointed to via the
    bazel-out symlink is accessible via ${symlink_prefix}-out. If
    this causes problems for you, set
    --experimental_no_product_name_out_symlink=false in your builds
    and file an issue.
  - Updates worker protocol with cancellation fields, and adds
    experimental_worker_cancellation flag to control cancellation.
  - Simplify build failure output by always using `NNN arguments`.
  - trim_test_configuration now defaults to on
  - Mark genrule.srcs as a source attribute for coverage.
  - When using --allow_analysis_failures (for example, via
    bazel-skylib's
    analysistest with `expect_failure = True`), analysis-time
    failures in aspect
    implementation functions will now be propagated and saved in
    AnalysisFailureInfo, just like analysis-time failures in rules.
  - cquery --noimplicit_deps now correctly filters out resolved
    cc_toolchains
  - Sign apks deterministically.
  - Make gcov optional in cc_toolchain tools.
  - If --experimental_prefer_mutual_xcode is passed, Bazel will
    choose the local default (instead of the newest mutually
    available version) if it's available both locally and remotely.
  - Remove java_lite_proto_library.strict_deps attribute.
  - Generate proguard configurations deterministically.
  - Adds a new flag, `--incompatible_enable_cc_test_feature` which
    switches from the use of build variables to the feature of the
    same name.
  - Dropped fragile xz support from built in pkg_tar. Users requiring
    xz
    compression should switch to bazlebuild/rules_pkg.
  - If all strategies of one branch (the local or remote execution
    branch) of the `dynamic` strategy fail to even accept (via the
    response they give from `canExec`) the action, `dynamic` will now
    try to see if the other branch can accept it. (Trying to run it
    and it failing will still cause a failure if it was the first
    result, this is about strategies claiming they can't even try the
    action)
  - Add `disable_annotation_processing` option to
    `java_common.compile`, which disables any annotation processors
    passed to `plugins` or in `exported_plugins` of `deps`
  - Remove obsolete --incompatible_prohibit_aapt1
  - The minimum Android build tools version for the Android rules is
    now 30.0.0
  - Adds --experimental_reuse_sandbox_directories flag to reuse
    already-created non-worker sandboxes with cleanup.
  - --experimental_force_gc_after_build is deprecated and will be
    removed soon. Use --bep_publish_used_heap_size_post_build instead
  - Forward coverage-instrumented files from non-tool dependencies by
    default.
  - The used_heap_size_post_build field in BEP is populated when the
    --memory_profile flag is set
  - --run_validations defaults to true.
  - Consider label_keyed_string_dict attributes when gathering
    instrumented files for coverage.
  - Remove flag
    --experimental_forward_instrumented_files_info_by_default, now
    that this behavior is the default.
  - When using MemoryProfiler with multiple GCs via the
    --memory_profile_stable_heap_parameters flag, we do a more
    precise calculation of heap used at the end of the build. This
    will generally result in lower values.
  - --bep_publish_used_heap_size_post_build is deprecated. Use
    --memory_profile=/dev/null instead.
  - Disable --all_incompatible_changes flag.

This release contains contributions from many people at Google, as well as Adam Liddell, Alex Eagle, Andrew Katson, Anthony Pratti, Austin Schuh, Benedek Thaler, Benjamin Lee, Benjamin Peterson, Benjamin Peterson, Ben Lee, Brentley Jones, bromano, Cameron Mulhern, Christopher Peterson Sauer, Christopher Sauer, Cristian Hancila, Dan Bamikiya, Daniel McCarney, Daniel Wagner-Hall, Danny Wolf, Dave MacLachlan, Dave Nicponski, David Cummings, David, David Ostrovsky, Delwin9999, Denys Kurylenko, Dmitry Ivankov, dorranh, Ed Schouten, Eitan Adler, Elliotte Rusty Harold, erenon, Eric Cousineau, Ethan Steinberg, Fabian Meumertzheim, FaBrand, Felix Ehrenpfort, Finn Ball, Fredrik Medley, Garrett Holmstrom, Gautam Korlam, George Gensure, goodspark, Greg Estren, Grzegorz Lukasik, Grzegorz Lukasik, Ikko Ashimine, Jesse Chan, Joe Lencioni, Johannes Abt, John Laxson, Jonathan Schear, Justus Tumacder, Keith Smiley, Kevin Hogeland, Lauri Peltonen, Liu Liu, Lszl Csomor, m, Marc Zych, Mark Karpov, Masoud Koleini, Matt Mackay, Max Liu, Menny Even Danan, menny, Michael Chinen, Nathaniel Brough, Nick Korostelev, Niek Peeters, Nikolay Shelukhin, odisseus, Oleh Stolyar, Olek Wojnar, Olle Lundberg, Omar Zuniga, Philipp Schrader, Pras Velagapudi, Qais Patankar, Rai, Ryan Beasley, samhowes, Samuel Giddins, Sebastian Olsson, Steve Siano, steve-the-bayesian, Stiopa Koltsov, susinmotion, tatiana, Thi Doan, ThomasCJY, Timothy Klim, Tobi, Torgil Svensson, Trustin Lee, Ulf Adams, Uri Baghin, Vaidas Pilkauskas, Vertexwahn, wisechengyi, Xavier Bonaventura, Yannic Bonenberger, Yannic Bonenberger, Yannic, Yury Evtikhov, Yuval Kaplan, Yuval, [zqzzq].

## Release 4.2.1 (2021-08-30)

```
Baseline: 37a429ad12b4c9e6a62dbae4881a1ff03b81ab40

Cherry picks:

   + a689d673abadf80f1efaf8ddaeee92d56fc2847b:
     Use getRunfilesPath for run_under executable path generation.
     getRootRelativePath doesn't return a valid runfiles path for
     external source files anymore after the recent external source
     root change. Also, it won't work for external labels either once
     the --nolegacy_external_runfiles becomes default. This fixes
     issue #12545.
   + d90ec67fdab9710f649a3c1d374fb6b938b9271a:
     Fix NPE when coveragerunner is not set on the toolchain.
   + 8555789dd239a5ac229c1d9cee80b2a9f30b3bf7:
     Fix the classic query package-loading cutoff optimization with
     external workspaces.
   + 57672aca01b3be895382c952b550c9f8edf6c9f2:
     Update turbine
   + bef4bbbb47d47befe3711d06f358782ee12554f9:
     Update turbine
   + d113d7454127bba78aa618dac81e5d164920b662:
     Update turbine
   + 1489f0f4cae3e9247a70e4003ab76bef45c5b986:
     Support Scala3 .tasty files
   + 0d2d95cd7e34b4061c8e5fdfd21ba0ab8818c685:
     Update to java_tools javac11 release 10.5 (#12647)
   + a9419f38d5f29af31a6c8ebda09a6e0303a6ba54:
     Fix common prefix for instrumentation filter
   + 84fadcf81f81b2d7343ca4151a5639be7f2263ee:
     Fix builds for filegroup targets with incompatible dependencies
   + e43825d0bef359f645e1cabf2164fd2db6ee4a35:
     Revert "Remove
     --incompatible_blacklisted_protos_requires_proto_info"
   + 082d58de852ebaa640bcf13cf419cbb94eec2b26:
     Transform roots along with paths during output deletion.
   + e8835c1c221d76a2d5532d18083eaa04401619b3:
     AttributeContainer.Large now handles more than 127 attributes.
   + e1e87349335ac59f9b3df47cee8b999faeaa6d11:
     Add an env attribute to all test and binary rule classes
   + a87d7ed2411d5382bac58a20b79e09c464ad13b9:
     Take no action to prefetch empty artifacts.
   + 3e969ff24a6a0e03139b9f288c88451a7dfa97cd:
     Fix a couple of bugs with Incompatible Target Skipping
   + e6670825b1e183f81f5c864aafd425d512fa9ff5:
     Pass --host_action_env to host options hostActionEnvironment
     attribute
   + 07400c0392e7be163f8a3396fa5cf89ce6705412:
     Add --{no,}autodetect_server_javabase.
   + c83366064621d5a265eba14d93a03deff58fe6d8:
     Only treat "env" and "env_inherit" attrs specially for native
     rules
   + 6a60b30cd0f22d0ab84b2ddd658d5ccb899a8a76:
     Fix coverage support when using default_java_toolchain. (#12801)
   + 4158a6f512e52516437e00f8d9609a91be7fc195:
     Revert JacocoCoverage target to remote_java_tools_java_import
     and add a new target for remore_java_tools_filegroup. (#12813)
   + f6d30cf5ef9a8a39fea7072317f89a872387b790:
     Add windows_msvc back to conditions in bazel_tools.
   + 6b33bdb1e22514304c0e35ce8e067f2175685245:
     Release 4.0.0 (2021-01-21)
   + 8811e27353c2c10980faf7e4c5e44b431d2d4f1c:
     Fix error message from getPrerequisites to not print internal
     details.
   + 27e15ad11410eb1014f5247fd0eeb31a46733c07:
     Clean up ConfiguredTargetValueAccessor and
     ConfiguredTargetAccessor
   + e87feb8ac9573cef993824f82370d0389570521d:
     Move getConfigConditions into ConfiguredTarget.
   + 34d98234324da83e93ba0d5ef5702880d5ac7c5c:
     Change ConfiguredTargetQuery to use KeyedConfiguredTarget as a
     value.
   + 079bb7d69931705bb2b092c9017090e224ef3043:
     Clean up old dependencies that are unused since
     https://github.com/bazelbuild/bazel/commit/34d98234324da83e93ba0d
     5ef5702880d5ac7c5c.
   + e03cb63e059420847d6578d7cbfe93f05615c95e:
     Update bazelbuild/platforms to a current release. - Roll forward
     https://github.com/bazelbuild/bazel/commit/0a4533420a3de467fd211d
     7f925cf88e0cd5b76a  with kythe fix.
   + 2eb1bf53d5fef13b89ee440af4f83003d1d0b50a:
     Update docs and tests to use the @platforms//:incompatible
     constraint
   + c71697cf33b0fbbb42fc2910bac83960edc7e855:
     Clarify test_suite behaviour in the Platforms docs
   + dfb70ea4cae2ffffb76e9741d86c96505a6d05ad:
     Enable toolchain resolution for filegroup targets.
   + 24d086446f74606819dc53c3a436caa056ff05b7:
     PlatformProviderUtils should ignore targets that don't have the
     needed
   + ba60c0b3f9bbd00975c984244839b155e84b4c5d:
     ijar: fix manifest sections handling
   + 58bb42ad7ca263a75c6eeef51482f805726663a5:
     Revert "Switch to -fdebug-compilation-dir"
   + 57672aca01b3be895382c952b550c9f8edf6c9f2:
     Update turbine
   + bef4bbbb47d47befe3711d06f358782ee12554f9:
     Update turbine
   + d113d7454127bba78aa618dac81e5d164920b662:
     Update turbine
   + ad241fbebd90a9f0ad65ccd0658838f57030db68:
     Allow cquery to filter out incompatible targets
   + 1782f0ae751569607ef88930c822ac460a1f8bb3:
     Patch grpc to fix cares selecting the wrong source when building
     for darwin_arm64 cpu.
   + 8f7bc2f67fafcaa8d25cfc77eaaedbf8eed2984a:
     [1/3] Bump grpc to 1.33.1 to fix corruption when downloading CAS
     blobs
   + 848a51747a460ab4c5185e4c61ab522a9981cbea:
     [2/3] Bump grpc to 1.33.1 to fix corruption when downloading CAS
     blobs
   + 9b30172547f2093acb56aedf159a77d5dceffda2:
     [3/3] Bump grpc to 1.33.1 to fix corruption when downloading CAS
     blobs
   + 1e258d2a7a5221613047e5cee0aaec5b56045d2b:
     Allow exec groups to inherit from the rule or other exec groups.
   + d0676693310215407224c1b8e8aea9e3eddc183d:
     Support execution constraints per exec group
   + f1e0d346c8235c855e61afc2adb870e4b895e002:
     Clean up RuleContext to use a Table instead of a Map of Maps.
   + 8186fbb47ab964a9affa9a0fc6315fcdbde2b5aa:
     Documentation for #13110
   + 321fe3b6b4e892821ee7dbf2d17dd8ae6a541913:
     Prevent --repo_env from triggering unnecessary fetches
   + 3ebf658cba43bbab1efc36518f0795a7d65e2d46:
     Prevent a crash when using --repo_env=VAR without a value
   + 913a985a5c2fc3842b12c6e5f29af0fa1bccfd6a:
     Report digest of failed uploads
   + 5122617b8a22fee7acd86c9c48f2c2737709ca3f:
     Status error presentation with details
   + 9a70805db543e2fb910e1c55ef3b3567362adf30:
     Fix double shutdown of BuildEventArtifactUploader when BES+File
     output enabled.
   + 325eb956c92530bdfda54a36a186cae4245a4f7b:
     Add rxjava3 to third_party
   + ceaac966a7b977461b69ce9501df6a467f4a93b2:
     remote: set executable bit of an input file based on its real
     value
   + 5b786da75837c5e29714e1d708c3cdf9a67ed32d:
     Remote: correctly implement equals and hashCode.
   + 48648503729d53fdee1322fde2c8e6c05e99cff9:
     Fixed an error that bazel binary is not executable when testing
     with remote execution.
   + bc54c648aa1f99509c7c36d5e6b570d066689209:
     Remote: Use parameters instead of thread-local storage to
     provide tracing metadata.
   + 92955e617b5c41713a5163dc0437c2a024b31815:
     Remote: Use parameters instead of thread-local storage to
     provide tracing metadata. (Part 2)
   + 75bd1ff8ab56d241916bde36291301fa026b2bab:
     Remote: Use parameters instead of thread-local storage to
     provide tracing metadata. (Part 3)
   + 37ee252f3744abc4511f55b5089cc52abd3ba09d:
     Remote: Use parameters instead of thread-local storage to
     provide tracing metadata. (Part 4)
   + 71e35b165f924e2649a078fcf6007645d58039af:
     Remote: Use parameters instead of thread-local storage to
     provide tracing metadata. (Part 5)
   + 32fc451600b6e94a015263eb1c8a63e974f6f4cc:
     Write/QueryWriteStatus logging refinement/addition
   + 97963c5bb24ac79eb3646dd61bfcf2f8a648af54:
     Remote: gRPC load balancing. (Part 1)
   + e2b9a42a61596b0d24f0cadd6b7157b7f1efb221:
     Remote: gRPC load balancing. (Part 2)
   + 6667ad7dd77f8d97952133052c17e7779c1430ec:
     Remote: gRPC load balancing. (Part 3)
   + 7c081eb020186bfb16d4ef1c3832a8e946e99da1:
     Remote: gRPC load balancing. (Part 4)
   + 17afbe4e224b359fee6415a5bd71bbedaa7843eb:
     Implement getMessage for BulkTransferException
   + a6293b3df521aea9075b2ebbcdb675a7d02d3c32:
     Remote: gRPC load balancing. (Part 5)
   + 7a62c2d4e27e398f440910c81eacc384f38ca8be:
     Remote: Add interoperability between Rx and ListenableFuture.
   + 1fcb18a0b455bfcb8e9940778f37d8c82c5ed5a0:
     Update to latest remote-execution proto
   + dad96301d12aa77eb67399e08265a5f30f5ffd6a:
     Set Platform on Action not just Command
   + 6c5a3ee0dcbb4b804f4aa85c038a378fb70eb1f9:
     Remote: Add AsyncTaskCache which is used to deduplicate task
     executions and cache the results.
   + 9d0c7325ac810febe565a62fdd875ae0c240b274:
     Remote: Use AsyncTaskCache inside RemoteActionInputFetcher.
   + f54fe07209acc25340df8d2e02993b1add2deafa:
     Add --experimental_repository_disable_download to allow users
     disable download for external repos
   + b243584a479eb4481a9bf4f69acc899610a3b630:
     Report errors parsing rewriter config file
   + 63bc1c7d0853dc187e4b96a490d733fb29f79664:
     Downloader rewriter config has all_blocked_message
   + 495ac923f398443be45c20ab29d183fe47e08911:
     Allow UrlRewriter to change protocol, i.e. https->http, and
     http->https
   + 8dbbde0037264c1db4b229a09f98a61ab4ca06b0:
     Allow overriding the hostname and instance name in bytestream://
     URIs
   + 0881c80d29acecdfbb58c49156f805e8c50db117:
     Don't set requestId on non-multiplex requests.
   + e3b7e17b05f13ff183a4d7efec8ec797f3f5eaa3:
     When generating a symlink in _virtual_includes, add the original
     header to the 'allowed to use' set too
   + f8f66f36ad299a0ea019c94100d5a8e2018f5ab5:
     Make SimpleLogHandler not swallow interrupts.
   + f8606e5e76579442a1c6563e718ea54c673f1a04:
     linux-sandbox: don't assume -lrt, -D__STDC_FORMAT_MACROS
   + dac0d40d0eb903f5cb70341398d1a333c19adf3a:
     Improve "Common Attributes" section
   + a607d9dc70ac67f1aa2c32ca954177f9c77860be:
     Never create more than one process per WorkerMultiplexer.
   + 80c03ef14a1842d1e3475b1adf98adeb05df33f9:
     Move sending requests and reading responses for multiplex
     workers into separate subthreads.
   + 003cfcde3fd3901c1279ba1db3db3a14536248b4:
     Allow use of JSON protocol in multiplex workers.
   + 308bce36cba46095fe41866e703710035ddddada:
     Actively kill off still-active workers when stopping work on
     interrupt.
   + 8959dff512fe4505af786bcf2ef981ec7082a913:
     Add sanitizer support to Apple platforms
   + 32f16e9360f3e1856db1775eb5014b930da2a303:
     Fix a Google-internal broken link.
   + c9e2be52a067dd9abf5efa4f5f55bb5b98cf5d3b:
     Add SHA-1 to subresource integrity format for download()
     checksums
   + 3b3e6424c6fbd51d4c4ebb6aa25f1d1f4720221c:
     Remove fallback strategy support for workers, add flag for it in
     sandbox.
   + 3457f2ae11e4543de0a5e6e8e37c3aff067891fd:
     Update to java_tools javac11 10.6 (#13245)
   + 4928295b236ec8f590a7e9d863502bc2f50a77d9:
     Allow .S files in C++ Starlark cc_common.compile.
   + 1b18d65227c127fe946d3fcde4586158bc7e5fcb:
     Automatic code cleanup.
   + b5d6c38535c7f6f1eab3fd4c8d3d2da91d0b0f8a:
     Change short output of worker type to have the same logic as the
     worker creation for sandboxing vs. multiplex.
   + e7a0a71f50b69df5d38a8a85fefd36d211e12e8d:
     More properly destroy workers on interrupt.
   + 7056711eb11b672133274eb29fc93b01dcf088d5:
     Make WorkRequestHandler do a GC after some amount of CPU time
     has been used on requests. For Bazel and Blaze, defaults to 10s
     based on benchmarking.
   + 596653d3cf76e7b208da343e1fde5fe20273a5ff:
     Allow tree artifacts to be source or header inputs to
     cc_common.compile()
   + 055c93d11ab20cc4479539b24bbdfa5cab78a342:
     Switch to path autocompletion after -- for bazel run commands.
   + 807f2a1929e23b60b237c63fadb25af81de2e3c3:
     Fix Incompatible Target Skipping for test args
   + 9a5cd854e0613f91d52075973e2454b1e009e1ef:
     Fix order of build request id and command id
   + 706f5acd02363e48076dc97e37613fd968932d03:
     Fix bazel crash when passing config_setting to
     target_compatible_with
   + 61da1d2bf10eabba4c75de959b0374f302d89d70:
     Support multiple --bazelrc on command line
   + 5593358a58b66f06c4e421bb48856de94c3fd625:
     Update ConfiguredTargetFunction.computeUnloadedToolchainContexts
     to
   + 662cf54de7a103db30e04ebae2d2b919437c4846:
     Remote: Fix an issue that a failed action could lead to
     RuntimeException caused by InterruptedException thrown when
     acquiring gRPC connections.
     https://github.com/bazelbuild/bazel/issues/13239
   + a3a1763212f29932618b9b9b2f929976ae0e3b6e:
     Pass more `--add-exports=` flags
   + d2b942879471786e82f1c96eea8722bbe7919fc1:
     Remote: Fixed a bug that remote cache is missed due to
     executable bit is changed
   + 616dc264f02907d7b7887285d22307dfe6d097b6:
     Fix Bazel Coverage with C++ to work with Remote Execution
   + 5f40d12e741aa30d506eaa15673fb2ae76d29468:
     Fix external_path_test with newer Xcode versions.
   + b416193075642017e13c774422b49cb07fb65c23:
     Allow using embedded tools in sandboxed spawn runners.
   + eb762d4e7431637e607146b1c191485795047ef9:
     Fix racy write of temporary files while staging virtual inputs
     for the sandbox.
   + f31e86768579ad7ec57ba13f4c3c1348f5c2702e:
     Update platforms_test to not rely on filegroup not using
     toolchain
   + 13031e5b3bd7c8f29b96b2fee1b380160e0e27fc:
     Update SkyframeTests to not rely on filegroup not using toolchain
   + 11651824a9d0ffb9adb9611dcd39f4c95a59d750:
     Update ConfigurableAttributesTest to not rely on filegroup not
     using …
   + 4b68532e7ea5eb80c926b7b8e2ec2be300004628:
     Make WorkerExecRoot not be a subclass of SandboxedSpawn.
   + 31db460a45767de0bcd664a6efbe9d163b85b802:
     Make WorkerExecRoot not be re-created on each createFileSystem()
     call. Preparation for holding a map of existing links, but also
     just nicer.
   + a2cc0460dc84ad2dc88019af2fe2a65ce80c61e5:
     Start the file existence check traversal from the execroot base
     instead of execroot so that external repo files at
     "<execroot>/../<path>" are correctly handled when the sibling
     repository layout is enabled.
   + b048282c7893231d3a7191b251804973917b07a4:
     Use readdir for cleanExisting in WorkerExecRoot.
   + 270f00dd01fa06cf3e813da5a406be3446de7377:
     Add native support for Apple Silicon
   + 8e56b9423e8ad2f7323fb90b19b73858def81e39:
     Explicitly state that embedding macOS OpenJDK is for x86_64
   + 09c621e4cf5b968f4c6cdf905ab142d5961f9ddc:
     Remote: Fix a race that AsyncTaskCache#Execution could be reused
     after disposed which results in
     CancellationException("disposed") propagated to downstream.
   + 0299cd7e17203a4ce0ea947b62a7c55f1afb8225:
     Remove wrapped_clang params files after use
   + 47edc57806056f3c8764241ed41b8acc72bd2ebf:
     Silence swiftmodule timestamp warnings
   + f6e1074b09ebefba185c0531e9cea26b9596c8a9:
     Remote: Use shutdownNow() instead of shutdown() in
     ChannelConnection#close() as a workaround to a gRPC bug.
   + 71be4ea9e3d20bf90129e34a6a2899fe8401be36:
     And mnemonic and label to remote metadata
   + 615e1b16a81b0defc15699ec8027d6ddd70366d1:
     Change `set -x` in coverage to be set by var
   + fe4daea99c8cd163793eca84bfb12c8fc437616b:
     Bump minimal JDK install base maximum size from 290 to 295 MB.
   + 4840a68cd273a429e46d4114a3973fd11d0e3583:
     Remote: Check the return value of ActionOwner.getLabel() since
     it could be `null`.
   + 14abe4fd7c3967686a3536939fdc3882e691bca2:
     Allow `DiffAwareness` to share precomputed information about the
     workspace and propagate it to the `WorkspaceStatusAction`.
   + 082d98772690946ed29c157e60640c97a6e1195b:
     Implement available() method for Windows subprocesses.
   + c2bdd034014f66ce14529cc353cda18a32320f6c:
     Move --repo_env to common options
   + e09f2743738044095b9d784ea62df16b7f5750e6:
     Revert "Documentation for #13110"
   + a165baa250652fdc865ae0df39160be1f7f74c47:
     Revert "Clean up RuleContext to use a Table instead of a Map of
     Maps."
   + 51fb9e13a864f4f704ae378ea632433bae7ddc31:
     Revert "Support execution constraints per exec group"
   + cb6e5c24b82e0e20a243145fb6ea32b09e3d1de3:
     Revert "Allow exec groups to inherit from the rule or other exec
     groups."
   + 2ac6581aeaab33ba506fce96dfa6a75eaa819233:
     Release 4.1.0 (2021-05-21)
   + 7a0f36e3f0a21fed8857efbaa51ded2dbdeefab6:
     Change gceMachineType of highcpu platform from n1-highcpu-32 to
     e2-highcpu-32
   + 19491a91143f0c6132aca62c5ae40ab72e9dc0e2:
     Fix #10127: Remove Python 2 dependency from tools/android.
   + 80c59dea59d4dce39d4b5d21665c3d7313197358:
     fix main repo starlark options parsing - now flags passed on the
     command line as --@main_workspace//flag and --//flag will both
     parse to --//flag. Before this CL, the former maintained its
     workspace prefix and we would get different entries for these
     two formats.
   + 451b296c3aceb127ebb4a313b6e9608854fa68fa:
     Update threshold for long path shortening to be MAX_PATH - 4
   + 671e0489a5bd6d5abb4dcd9bcfc85134cee38385:
     Force source files to be readable before copying them from
     sandbox.
   + 6080c1e07f4229ea72eacd04faa9302e44955a84:
     Let workers finish lost races without delaying dynamic execution.
   + ee738dacb5d0089d3f57b15305057cb9ba675e74:
     Fix label_flag and label_setting to not have a dependency on the
     default
   + 74de0ba4e79341c77b8b85ff4485f92287b6854c:
     Java coverage: fix handling of external files
   + 48eee8b4b447a2ad11df28dd81a2ccb65562b5f5:
     [Bazel] Fix mobile-install for python2
   + 763dd0ce6e1644bf895231432f616427a11d385a:
     Add `stub_shebang` to `py_runtime`
   + b2231c56d78c6d37bcb6f11e1e50fe68ee336b4a:
     Move use of legacy sandbox -> local fallback to only be used
     after all strategies have been tried, and improve messages
     around it.
   + 6dc941e58dfc1d4a9714a76b921fbe11fce658ed:
     Remove restriction on generate_pdb_file to be only used in dbg
     and fastbuild mode
   + 5b95d9162b56b51c8e8f66258981ddf3c5d96765:
     Check the result of Future.cancel() when cancelling the other
     branch of dynamic execution.
   + aaae8ce2881c8c1a5d4ad64f20d6e71aa372cf2e:
     Update DEFAULT_MACOS_CPU to match host
   + 2f0927a4fd9342f4dcfd43475d3f1c90c523584f:
     Fix symlink creation on older Windows versions
   + fd9cffdcaf05551126e66f1cd62815eaa1af6bd9:
     Suppress interrupted status during pool closure
   + 33903d28bcea0005adf9b2a8cc4659c5e2999bbe:
     Fix Windows developer mode symlinks
   + 0cd1666721bdbe988dc361c085bb43cbd41a27f3:
     Respect Starlark options with values in `removeStarlarkOptions()`
   + 7920ffef472b25db3f4e564e5a3a28a4664c666e:
     cquery inherits from `test` not `build`
   + 1e258d2a7a5221613047e5cee0aaec5b56045d2b:
     Allow exec groups to inherit from the rule or other exec groups.
   + d0676693310215407224c1b8e8aea9e3eddc183d:
     Support execution constraints per exec group
   + f1e0d346c8235c855e61afc2adb870e4b895e002:
     Clean up RuleContext to use a Table instead of a Map of Maps.
   + 8186fbb47ab964a9affa9a0fc6315fcdbde2b5aa:
     Documentation for #13110
   + e376580ae4e9ad5bddc196bfb6ad3127e3ff561b:
     Split ExecGroup into a new target.
   + 0cbb8a863522d2f77ab6b67a01e39b19a9a81807:
     Create a new interface to allow Starlark objects to get a thread
     when getIndex is called.
   + d2e21cec31f09b27ef3589f47b0779f34077ca7e:
     Renamed ExecGroupCollection to clarify that it is only for
     Starlark usage.
   + b9519f92f8ce096107164ca5075feced0e989de7:
     Make StarlarkExecGroupContext use AutoValue.
   + 52b1b748b2368820bac2ca94323fb82c39c00e51:
     Use a dummy toolchain context for rules that don't have one.
   + 41877d0fefe3f021f3ff6d4ce398d0deb27157e6:
     Extract a separate StarlarkToolchainContext for starlark-only
     operations.
   + b120d4febc571f17e12501ad87fbff32ef94e9bb:
     Fix toolchains to support type lookup.
   + dc140d0b6119950dd4a7d71b125b15a78bacc8ce:
     Move DEFAULT_EXEC_GROUP_NAME from ToolchainCollection to
     ExecGroup.
   + 9b18d951a52819f1998ddfdc1739fa1b5bf0353d:
     Rename ToolchainCollection.getExecGroups to getExecGroupNames.
   + 10d4473bf476a587e3d9f9b2214581ec420c1919:
     BuildViewForTesting should directly call into
     ConfiguredTargetFunction.
   + 58a6fb1f8739e39125cc8c647f28cff2e79fe9aa:
     Move exec group tests out of platforms_test and into integration.
   + 7d5493d922761c3ce0037f0025912cc532c55ad7:
     Update creating exec groups that explicitly copy from defaults.
   + 8c6382a81237e72dbec24b3850df9481461e0015:
     Create a new ExecGroupCollection container to manage exec group
     inheritance and exec property parsing.
   + b4b0c321910bc968736ef48e8140528ea7d323cd:
     Fix unix toolchain for macos arm64 platform
   + f64f071f44394a33a1be40cb7642e2c881d1e9bb:
     Add `required_providers` attribute to Starlark defined aspects.
   + f2cbdcf67ac1990f05a8241ba8dae65795edac82:
     Don't ever claim /dev/null is an execpath.
   + ceec93c35ead1bd487e96a5fee46e8d080f88858:
     Don't ever claim /dev/null is an execpath.
   + 1f3f9f4c4b2eded90518aacd1b0b80c1b0dfd1c5:
     Use the parent directory of the exec root as the input root on
     RBE.
   + 4efeac9cb5f85325ed73f64e133a078c483cac01:
     Make the Merkle tree computation work in the wake of
     https://github.com/bazelbuild/bazel/commit/7149f578006a4ad0d51df6
     9830a6986749b34df5 .
   + b56a2aa709dcb681cfc3faa148a702015ec631d5:
     Remote: Use execRoot as input root and do NOT set working
     directory by default.
   + ae53991f2e207edacd1352ba94261e2473b79f14:
     Remote: Add RemoteExecutionService as a layer between spawn
     execution and remote execution.
   + 0c07c2e6571dd4806552213b2237ecb7a908afa4:
     Remote: Add remoteCacheable key to execution log
   + 5e617d83f3aab1fd36b07be4b58aba58604cc46e:
     Remote: Register "remote" strategy even if remote execution is
     not available.
   + 4ca8946a8e1c4c2fd48d8fb8ce38adb8b282fef0:
     Remote: Add --experimental_capture_corrupted_outputs flag.
   + 97d7b4c277814d73b50450b03f4bb160ce7e99b4:
     Remote: Report checking cache status before the action is
     scheduled to run remotely.
   + ba5b2a7c9448a3681a0d86d80670447e338a06dc:
     when writing to local disk cache, open files later in order to
     avoid "too many open files"
   + 3551898849a93306ad9b4dfdd7d4667913098efe:
     Propagate test envs to xml generation action
   + 9f8c678d7054548865f56f3464f778c751657074:
     Remote: Fix a bug that the XML generation is executed even if
     test.xml is generated when build with --remote_download_minimal.
   + af42653e6f6bd229142f4678bb256a8c397b4d8d:
     Automatic code cleanup.
   + 07a84ce31d9b09853c63c7e373418696dd285dc5:
     Remote: Another attempt to fix the CancellationException error
     in AsyncTaskCache caused by a race condition.
   + 0f812eb5e561cc5415d0c9931675e58dc37a5850:
     Remote: Display download progress when actions are downloading
     outputs from remote cache.
   + 18c82168433719b400a705a4a0222969a7a026ba:
     Remote: Do not upload empty output to remote cache.
   + 6a138a60e562beeef36003c4814a6b8ce9f253f6:
     Fix compiling errors
   + bcce6dd026e90336e80616a8c1004a79a2f8640c:
     Add the TEMP_FAILURE_RETRY macro to linux-sandbox-pid1.cc.
   + c8c0d94a49e1b865d95c6d245c2d152c7c7c9722:
     Export proguard specs from aar_import
   + 1a0285c3b64b121268ced3eb9ad9d5ba396b4905:
     Fix stripping of macOS loadable bundles
   + 0d3c231f5a08861d28e987703e9196890e6164bf:
     Roll forward config_setting visibility enforcement behind a flag.
   + bb7a01027242390da1c18fbf87c274cc34c11b79:
     Fix merge conflicts.
   + 8b8e77ea226aaa12e79580422bc5984e80ce048b:
     Remove redundant declaration.
   + 7c92cfcf9a88933c29334f6271ad3f086f7f36f4:
     Ignore empty virtual artifacts when spawn-logging inputs.
   + 4158b61211e099db780565d064a1c1a80c91bd2a:
     Use correct exit code on invalid aquery --output
   + b51b31dbe75a5bc73227fccb4484f3454df81b42:
     Remote: Fix a race when reporting action progresses.
   + 0e652737988e3c115e98e1552f6fada52bc2b9a2:
     Change MIN_BUILD_TOOLS_REVISION to 30.0.0
   + 6f9909c04b1e00faa510b38ccabac78821046cf9:
     Update Android remote tools to ensure Bazel uses the latest
     Android tooling that has been updated to support AndroidX
     databinding generation.
   + 31d88c629dff2c5f8e8a4baf8c89fd3349c9783e:
     Automated rollback of commit
     9a1d428e33bfae1ec5b68250d4732b72346b8b39.
   + 951a3023fbcdbe025e350590e6fa86097da3fe05:
     Increase allowed size of the install_base.
   + a7845f65befbeb65a28ec53e62458211a7bc3f8e:
     Increase allowed size for install base again.
   + affc27f9d18f9781437e91a3f36c73962a56f261:
     Bump version of java allocation instrumenter.
   + 7efabba19cf6400bf9e707f53b40a6dd7110fafb:
     Reference the correct version of the java allocation
     instrumenter.
   + 9055c67b17abf5fed487ae44d0e22f1c6ea1e50c:
     Support extracting aar files.
   + 861c3caa85e47da35a8a4f1512e57d43b9263c37:
     Revert "Remote: Fix a race when reporting action progresses."
   + 92ec798ddc1f38fb4868af08c1d818639283f501:
     Revert "Remote: Display download progress when actions are
     downloading outputs from remote cache."
   + ce091abb290d1d753f480cdee0e69748eb20db52:
     Revert "Fix compiling errors"
   + 1b19cd310418b850e8e0ca2086ffe50755c9ed7e:
     Revert "Remote: Fix a bug that the XML generation is executed
     even if test.xml is generated when build with
     --remote_download_minimal."
   + 988b56f5916e024d10695797a7f963b30fc998c7:
     Revert "Remote: Report checking cache status before the action
     is scheduled to run remotely."
   + 35c98d07b21785efae57a7c4230cc1e452f74fd2:
     Revert "Let workers finish lost races without delaying dynamic
     execution."
   + c4e22b9ace07f5d360c5327a38f9ae4ab24b7109:
     Migrate ExampleWorker to use WorkRequestHandler.
   + 230be161176bd6f1251077af7674f80d38ff1e25:
     Do not interleave readdir() calls with deletion of directory
     entries.
   + 3cc8ce6ba0934b1a4d9db184daf055c1207ef105:
     Propagate OOME if NewByteArray allocation failed
   + 19fc15ebbf6c63fcce90a038e91c5ec726852848:
     Create helper method for sandbox tests, transform existing tests
     into using it.
   + deb1006c0778692f7eaef4cbcf7eeb8112b55e91:
     Cleanup: Replace NULL with nullptr
   + f4b5e0233341977aaa76593ca032d9ac4eba7444:
     Let workers finish lost races without delaying dynamic execution.
   + 186decab01ee247c7453baf19dac778545ec4937:
     Interface and flag specification for worker cancellation.
   + 5894a8544d51c99f1356130b8b487bc93299fedd:
     Create BUILD file in worker tests directory instead of running
     tests from the parent directory.
   + e9e6978809b0214e336fee05047d5befe4f4e0c3:
     Server-side implementation of worker cancellation.
   + 5103662238f2df2038c7dff079e9c655e08ba654:
     Add builder for WorkRequestHandler.
   + 1a519bb66c3fa3e4ef3b9a9a556597920751fbcd:
     Makes singleplex requests be handled in separate threads in
     WorkRequestHandler.
   + 779d66019210f54e10a1343ee004df72a8dec812:
     Only allow worker async finishing when sandboxed.
   + a698bef6146a807fd82ee4402d89c23c83802e33:
     Support for cancellation in WorkRequestHandler.
   + 9dc95af4c7ef10979f21173260f5433006116096:
     Make workers restart on flags that affect their
     creation/behaviour.
   + 7e5cd529e9f8c9cb67900af36182f00ef7316654:
     Remote: Report checking cache status before the action is
     scheduled to run remotely.
   + 6e134a1b68418fba9992692901efa77a80c346f7:
     Remote: Fix a bug that the XML generation is executed even if
     test.xml is generated when build with --remote_download_minimal.
   + d4d071401acadb0d8977850a9439474e60fd7bb9:
     Fix compiling errors
   + 2579c9a18360955699d028426b45d381ff53783c:
     Eagerly initialize JNI copies of Java classes: doing lazy
     initialization on a per-method basis doesn't save anything and
     adds a tiny bit of overhead to every one of these calls.
   + 0f812eb5e561cc5415d0c9931675e58dc37a5850:
     Remote: Display download progress when actions are downloading
     outputs from remote cache.
   + 3835d9b21ad524d06873dfbf465ffd2dfb635ba8:
     Update the WorkRequestHandler to use callbacks of type:
     BiFunction<WorkRequest, PrintWriter, Integer>:  - Mark
     constructors that use BiFunction<List<String>, PrintWriter,
     Integer> callback as deprecated.  - Use a wrapper class for the
     BiFunction<WorkRequest, PrintWriter, Integer>. Suggesting this
     to avoid having two constructors that takes a BiFunction, as it
     creates a confusion between the deprecated and new constructor
     when given a lambda expressions.
   + 5e352afe2b35487ea2ced85ca79bd9f79858e648:
     Fix bug in WorkRequestHandler's handling of singleplex requests
     that would cause occasional hangs.
   + b51b31dbe75a5bc73227fccb4484f3454df81b42:
     Remote: Fix a race when reporting action progresses.
   + c9d823e42796962eed039b8122528c2a1541190f:
     Disable flaky test.
   + e6809c90ecc0ef5783faa39e63188fc33a79b80e:
     Revert "Check the result of Future.cancel() when cancelling the
     other branch of dynamic execution."
   + be4cbc7a67196414e3d3f323be8ab55fb5e530f7:
     Revert "Move use of legacy sandbox -> local fallback to only be
     used after all strategies have been tried, and improve messages
     around it."
   + b32349f50ff3d958613aef9275751ad9d50d344c:
     Set a fallback dynamic local strategy even when the
     dynamic_local_strategy flag is passed.
   + f395157c95692565bc220c7ccf788974fe0885fd:
     Allow running an extra spawn for local branch of dynamic
     execution.
   + 039461c76113ab3f165132dd26d0c58eb3e45cae:
     Adding debugging information for case when two branches
     apparently cancel each other.
   + b2231c56d78c6d37bcb6f11e1e50fe68ee336b4a:
     Move use of legacy sandbox -> local fallback to only be used
     after all strategies have been tried, and improve messages
     around it.
   + 5b95d9162b56b51c8e8f66258981ddf3c5d96765:
     Check the result of Future.cancel() when cancelling the other
     branch of dynamic execution.
   + 1962a59a5478f5ad374700b0abf0a718b1b3a7d3:
     Fix the case where if all strategies for one branch of `dynamic`
     execution fail to accept (that is, refuse to even take) the
     action given, the whole action fails. Instead of seeing whether
     the other branch can run and the action that that it succeeded.
   + b7c1ad2aff91105659299723a712b72eea943040:
     Fix rare crash in dynamic execution where both branches got
     cancelled.
   + 2c3cff5422b115d7bb86ed28a056f3d368ebceeb:
     Check if `treeDeleter` is actually async before casting it.
     Fixes #13240.
   + 1a89ce1757e75f8ba9bda76d7373a7e8527bcfc5:
     Make worker JSON protocol properly ignore unknown fields.
   + 4b12fc80abf4152815f09e473a972e52a1fe8b51:
     Fix test_source_file_does_not_override_standard_library to work
     with Python 3.9.
   + f4e10367df2d881f05e3ddd5bd0531b390a845fe:
     Removing line ending matches in tests to be compatible on Windows
   + ba74df07ced96226d78851e11d1df03147f1cc1f:
     Refactors CompilationSupport for objc to use existing API
   + a04cb1bfad4734f801c48bae3070a799067bda4e:
     Release 4.2.0 (2021-08-18)
   + ba8678077024e1b4e5d7419c758a97e8dc9fceea:
     Revert "fix main repo starlark options parsing.
   + 9f67cdf3d51c05bc2209786aa24b72658b61362c:
     cquery: disable `--build_tests_only`.
```

Important changes:

  - Multiplex persistent workers can now use the JSON protocol.
  - enforce config_setting visibility. See
    https://github.com/bazelbuild/bazel/issues/12932 for details.
  - The minimum Android build tools version for the Android rules is
    now 30.0.0
  - Updates worker protocol with cancellation fields, and adds
    experimental_worker_cancellation flag to control cancellation.
  - If all strategies of one branch (the local or remote execution
    branch) of the `dynamic` strategy fail to even accept (via the
    response they give from `canExec`) the action, `dynamic` will now
    try to see if the other branch can accept it. (Trying to run it
    and it failing will still cause a failure if it was the first
    result, this is about strategies claiming they can't even try the
    action)

This release contains contributions from many people at Google, as well as Alex Eagle, Austin Schuh, Benjamin Peterson, bromano, Christopher Peterson Sauer, Christopher Sauer, Cristian Hancila, Daniel Wagner-Hall, Denys Kurylenko, Ed Schouten, Finn Ball, George Gensure, Greg Estren, Johannes Abt, Keith Smiley, Kevin Hogeland, Lauri Peltonen, Philipp Schrader, Ryan Beasley, Thi Doan, ThomasCJY, Timothy Klim, Trustin Lee, Ulf Adams, Vaidas Pilkauskas, Vertexwahn, wisechengyi, Xavier Bonaventura, Yannic Bonenberger, Yuval Kaplan, Yuval.

## Release 5.0.0-pre.20210810.4 (2021-08-19)

```
Baseline: ead44955c5cf02d94152f2cf3462c40ee6659594

Cherry picks:

   + 99a85e79a11cef98d0e08db21ab94833398381af:
     Automated rollback of commit
     92f7b58672baffe5a230f675d7197c2a10892284.
   + 16523615ba04c2697f436ca02d957809e6fe8dbf:
     Fix a race condition in scheduling code in
     `FileSystemValueCheckerInferringAncestors`.
   + ed251187b078c4262bbbc1da72015ce12f9964f4:
     Add incompatible flag to guard top-level aspects dependencies
```

Incompatible changes:

  - Removing java_common.javac_jar Starlark call.
  - native.existing_rule now returns select values in a form that is
    accepted by rule instantiation. This is a breaking API change
    because there is some code that relies on the precise type
    returned, including brittle workarounds for this bug specifically
    and insufficiently flexible workarounds for other issues with the
    intersection of select and native.existing_rule.
  - flipped incompatible_use_toolchain_resolution_for_java_rules, see
    #7849
  - Query output=xml/proto/location for source files will now show
    the location of line 1 of the source file (as the new default)
    instead of its location in the BUILD file.
  - Specifying a target pattern underneath a directory specified by
    .bazelignore will now emit a warning, not an error.
  - Query `--order_output=auto` will now sort lexicographically.
    However, when `somepath` is used as a top level function (e.g.
    `query 'somepath(a, b)'`), it will continue to output in
    dependency order. If you do not want the lexicographical output
    ordering, specify another `--order_output` value (`no`, `deps` or
    `full`) based on what ordering you require.
  - In the build event stream,
    BuildMetrics.TargetMetrics.targets_loaded is no longer populated.
    Its value was always mostly meaningless.
    BuildMetrics.TargetMetrics.targets_configured and
    BuildMetrics.ActionSummary.actions_created now include configured
    aspect data.
  - //visibility:legacy_public has been removed.
  - Flip and remove incompatible_dont_collect_so_artifacts
    (https://github.com/bazelbuild/bazel/issues/13043).
  - Remove flag --experimental_no_product_name_out_symlink: it is
    always true.
  - The Starlark method generate_dsym in objc fragment has
    been deleted.  Please use the equivalent apple_generate_dsym in
    cpp
    fragment instead.
  - Native libraries in data attribute are not collected. See
    https://github.com/bazelbuild/bazel/issues/13550 for details
  - Enforce the `--profile` path to be absolute.
  - Enforce the --memory_profile path to be absolute.
  - JavaToolchainInfo.jvm_opt returns Depset instead of a list.
  - --apple_sdk has been deleted.  It is a no-op.

Important changes:

  - Flag --incompatible_objc_compile_info_migration is removed.  See
    #10854.
  - Flag --incompatible_objc_compile_info_migration is removed.  See
    #10854.
  - Flag --incompatible_objc_compile_info_migration is removed.  See
    #10854.
  - none
    PAIR=cmita
  - The --incompatible_load_python_rules_from_bzl flag is now a no-op.
  - Filter all (instead of just C++) source files for coverage output
    according to --instrumentation_filter and
    --instrument_test_targets.
  - The `--incompatible_disable_native_apple_binary_rule` flag has
    been added which disables the native `apple_binary` rule. Users
    who need to use `apple_binary` directly (if they cannot use one
    of the more specific Apple rules) should load it from
    https://github.com/bazelbuild/rules_apple.
  - The Android rules' --use_singlejar_apkbuilder is now a no-op.
    SingleJar will always be used to build APKs.
  - dict.setdefault(key, ...) now fails if dict is frozen, even if it
    already contains key. This is an incompatible API change.
  - Flag --incompatible_objc_provider_remove_compile_info is removed.
     See #11359.
  - Starlark now permits def statements to be nested (closures).
  - native.existing_rule now returns select values in a form that is
    accepted by rule instantiation. This is a breaking API change,
    though the fallout is expected to be small.
  - Starlark now supports lambda (anonymous function) expressions.
  - The "test" and "coverage" commands no longer return 3 when a
    test action fails because of a system error. Instead, the exit
    code
    reflects the type of system error.
  - The undocumented ctx.expand feature no longer exists.
  - Make --legacy_dynamic_scheduler a no-op flag.
  - Multiplex persistent workers can now use the JSON protocol.
  - native.existing_rule now returns a mutable list, not a tuple, for
    a list-valued attributes. This is an incompatible API change.
  - Roll back change to have native.existing_rules use list instead
    of tuple.
  - BEP includes test suite expansions.
  - config_setting now honors `visibility` attribute (and defaults to
    `//visibility:public`)
  - Change the MultiArchSplitTransitionProvider to be based on
    platform type + CPU instead of fixed "ios_" + cpu.
  - enforce config_setting visibility. See
    https://github.com/bazelbuild/bazel/issues/12932 for details.
  - add a flag to build v4 signature file
  - Added _direct_source_jars output group to Java related targets.
    END_PUBLIC
  - pkg_deb is no longer part of @bazel_tools//build_defs/pkg:pkg.bzl.
    Use https://github.com/bazelbuild/rules_pkg/tree/main/pkg instead
  - Allowing the lipo operations to be conditional in the
    linkMultiArchBinary API for Apple binaries. Single architecture
    slices are now returned through AppleBinaryOutput and the
    Starlark API.
  - Release restriction for "-" in the package name for Python
    sources. Now `py_binary` and `py_test` targets can have main
    source file with "-" in the path.
  - Users consuming BEP may assume that a `named_set_of_files` event
    will
    appear before any event referencing that `named_set` by ID. This
    allows consumers
    to process the files for such events (eg. `TargetCompleted`)
    immediately.
  - BEP includes all files from successful actions in requested
    output groups.
    Previously, an output group's files were excluded if any file in
    the output group
    was not produced due to a failing action. Users can expect BEP
    output to be larger
    for failed builds.
  - In BEP, TargetComplete.output_group has a new field `incomplete`
    indicating that the file_sets field is missing one or more
    declared artifacts
    whose generating actions failed.
  - The flag `--toolchain_resolution_debug` now takes a regex
    argument, which is used to check which toolchain types should
    have debug info printed. You may use `.*` as an argument to keep
    the current behavior of debugging every toolchain type.
  - Add runfiles.merge_all() for merging a sequence of runfiles
    objects.
  - runfiles.merge() and merge_all() now respect
    --nested_set_depth_limit.
    If you hit the depth limit because you were calling merge() in a
    loop, use
    merge_all() on a sequence of runfiles objects instead.
  - Bazel will no longer create a bazel-out symlink if
    --symlink_prefix is specified: the directory pointed to via the
    bazel-out symlink is accessible via ${symlink_prefix}-out. If
    this causes problems for you, set
    --experimental_no_product_name_out_symlink=false in your builds
    and file an issue.
  - Updates worker protocol with cancellation fields, and adds
    experimental_worker_cancellation flag to control cancellation.
  - Simplify build failure output by always using `NNN arguments`.
  - trim_test_configuration now defaults to on
  - Mark genrule.srcs as a source attribute for coverage.
  - When using --allow_analysis_failures (for example, via
    bazel-skylib's
    analysistest with `expect_failure = True`), analysis-time
    failures in aspect
    implementation functions will now be propagated and saved in
    AnalysisFailureInfo, just like analysis-time failures in rules.
  - cquery --noimplicit_deps now correctly filters out resolved
    cc_toolchains
  - Sign apks deterministically.
  - Make gcov optional in cc_toolchain tools.
  - If --experimental_prefer_mutual_xcode is passed, Bazel will
    choose the local default (instead of the newest mutually
    available version) if it's available both locally and remotely.
  - Remove java_lite_proto_library.strict_deps attribute.
  - Generate proguard configurations deterministically.
  - Adds a new flag, `--incompatible_enable_cc_test_feature` which
    switches from the use of build variables to the feature of the
    same name.
  - Dropped fragile xz support from built in pkg_tar. Users requiring
    xz
    compression should switch to bazlebuild/rules_pkg.
  - If all strategies of one branch (the local or remote execution
    branch) of the `dynamic` strategy fail to even accept (via the
    response they give from `canExec`) the action, `dynamic` will now
    try to see if the other branch can accept it. (Trying to run it
    and it failing will still cause a failure if it was the first
    result, this is about strategies claiming they can't even try the
    action)
  - Add `disable_annotation_processing` option to
    `java_common.compile`, which disables any annotation processors
    passed to `plugins` or in `exported_plugins` of `deps`
  - Remove obsolete --incompatible_prohibit_aapt1
  - The minimum Android build tools version for the Android rules is
    now 30.0.0
  - Adds --experimental_reuse_sandbox_directories flag to reuse
    already-created non-worker sandboxes with cleanup.
  - --experimental_force_gc_after_build is deprecated and will be
    removed soon. Use --bep_publish_used_heap_size_post_build instead
  - Forward coverage-instrumented files from non-tool dependencies by
    default.
  - The used_heap_size_post_build field in BEP is populated when the
    --memory_profile flag is set
  - --run_validations defaults to true.
  - Consider label_keyed_string_dict attributes when gathering
    instrumented files for coverage.
  - Remove flag
    --experimental_forward_instrumented_files_info_by_default, now
    that this behavior is the default.
  - When using MemoryProfiler with multiple GCs via the
    --memory_profile_stable_heap_parameters flag, we do a more
    precise calculation of heap used at the end of the build. This
    will generally result in lower values.
  - --bep_publish_used_heap_size_post_build is deprecated. Use
    --memory_profile=/dev/null instead.

This release contains contributions from many people at Google, as well as Adam Liddell, Alex Eagle, Andrew Katson, Anthony Pratti, Austin Schuh, Benedek Thaler, Benjamin Lee, Benjamin Peterson, Benjamin Peterson, bromano, Cameron Mulhern, Christopher Peterson Sauer, Christopher Sauer, Cristian Hancila, Dan Bamikiya, Daniel McCarney, Daniel Wagner-Hall, Danny Wolf, Dave MacLachlan, Dave Nicponski, David Cummings, David, David Ostrovsky, Delwin9999, Denys Kurylenko, Dmitry Ivankov, dorranh, Ed Schouten, Eitan Adler, Elliotte Rusty Harold, erenon, Eric Cousineau, Ethan Steinberg, FaBrand, Felix Ehrenpfort, Finn Ball, Fredrik Medley, Garrett Holmstrom, Gautam Korlam, George Gensure, goodspark, Greg Estren, Grzegorz Lukasik, Jesse Chan, Joe Lencioni, Johannes Abt, John Laxson, Jonathan Schear, Justus Tumacder, Keith Smiley, Kevin Hogeland, Lauri Peltonen, Liu Liu, Lszl Csomor, m, Marc Zych, Mark Karpov, Masoud Koleini, Matt Mackay, Max Liu, Menny Even Danan, menny, Michael Chinen, Nathaniel Brough, Nick Korostelev, Niek Peeters, Nikolay Shelukhin, odisseus, Oleh Stolyar, Olek Wojnar, Olle Lundberg, Philipp Schrader, Pras Velagapudi, Qais Patankar, Rai, Ryan Beasley, samhowes, Samuel Giddins, Sebastian Olsson, Steve Siano, steve-the-bayesian, Stiopa Koltsov, susinmotion, tatiana, Thi Doan, ThomasCJY, Timothy Klim, Tobi, Torgil Svensson, Trustin Lee, Ulf Adams, Uri Baghin, Vaidas Pilkauskas, Vertexwahn, wisechengyi, Xavier Bonaventura, Yannic Bonenberger, Yannic Bonenberger, Yannic, Yury Evtikhov, Yuval Kaplan, Yuval, [zqzzq].

## Release 4.2.0 (2021-08-18)

```
Baseline: 37a429ad12b4c9e6a62dbae4881a1ff03b81ab40

Cherry picks:

   + a689d673abadf80f1efaf8ddaeee92d56fc2847b:
     Use getRunfilesPath for run_under executable path generation.
     getRootRelativePath doesn't return a valid runfiles path for
     external source files anymore after the recent external source
     root change. Also, it won't work for external labels either once
     the --nolegacy_external_runfiles becomes default. This fixes
     issue #12545.
   + d90ec67fdab9710f649a3c1d374fb6b938b9271a:
     Fix NPE when coveragerunner is not set on the toolchain.
   + 8555789dd239a5ac229c1d9cee80b2a9f30b3bf7:
     Fix the classic query package-loading cutoff optimization with
     external workspaces.
   + 57672aca01b3be895382c952b550c9f8edf6c9f2:
     Update turbine
   + bef4bbbb47d47befe3711d06f358782ee12554f9:
     Update turbine
   + d113d7454127bba78aa618dac81e5d164920b662:
     Update turbine
   + 1489f0f4cae3e9247a70e4003ab76bef45c5b986:
     Support Scala3 .tasty files
   + 0d2d95cd7e34b4061c8e5fdfd21ba0ab8818c685:
     Update to java_tools javac11 release 10.5 (#12647)
   + a9419f38d5f29af31a6c8ebda09a6e0303a6ba54:
     Fix common prefix for instrumentation filter
   + 84fadcf81f81b2d7343ca4151a5639be7f2263ee:
     Fix builds for filegroup targets with incompatible dependencies
   + e43825d0bef359f645e1cabf2164fd2db6ee4a35:
     Revert "Remove
     --incompatible_blacklisted_protos_requires_proto_info"
   + 082d58de852ebaa640bcf13cf419cbb94eec2b26:
     Transform roots along with paths during output deletion.
   + e8835c1c221d76a2d5532d18083eaa04401619b3:
     AttributeContainer.Large now handles more than 127 attributes.
   + e1e87349335ac59f9b3df47cee8b999faeaa6d11:
     Add an env attribute to all test and binary rule classes
   + a87d7ed2411d5382bac58a20b79e09c464ad13b9:
     Take no action to prefetch empty artifacts.
   + 3e969ff24a6a0e03139b9f288c88451a7dfa97cd:
     Fix a couple of bugs with Incompatible Target Skipping
   + e6670825b1e183f81f5c864aafd425d512fa9ff5:
     Pass --host_action_env to host options hostActionEnvironment
     attribute
   + 07400c0392e7be163f8a3396fa5cf89ce6705412:
     Add --{no,}autodetect_server_javabase.
   + c83366064621d5a265eba14d93a03deff58fe6d8:
     Only treat "env" and "env_inherit" attrs specially for native
     rules
   + 6a60b30cd0f22d0ab84b2ddd658d5ccb899a8a76:
     Fix coverage support when using default_java_toolchain. (#12801)
   + 4158a6f512e52516437e00f8d9609a91be7fc195:
     Revert JacocoCoverage target to remote_java_tools_java_import
     and add a new target for remore_java_tools_filegroup. (#12813)
   + f6d30cf5ef9a8a39fea7072317f89a872387b790:
     Add windows_msvc back to conditions in bazel_tools.
   + 6b33bdb1e22514304c0e35ce8e067f2175685245:
     Release 4.0.0 (2021-01-21)
   + 8811e27353c2c10980faf7e4c5e44b431d2d4f1c:
     Fix error message from getPrerequisites to not print internal
     details.
   + 27e15ad11410eb1014f5247fd0eeb31a46733c07:
     Clean up ConfiguredTargetValueAccessor and
     ConfiguredTargetAccessor
   + e87feb8ac9573cef993824f82370d0389570521d:
     Move getConfigConditions into ConfiguredTarget.
   + 34d98234324da83e93ba0d5ef5702880d5ac7c5c:
     Change ConfiguredTargetQuery to use KeyedConfiguredTarget as a
     value.
   + 079bb7d69931705bb2b092c9017090e224ef3043:
     Clean up old dependencies that are unused since
     https://github.com/bazelbuild/bazel/commit/34d98234324da83e93ba0d
     5ef5702880d5ac7c5c.
   + e03cb63e059420847d6578d7cbfe93f05615c95e:
     Update bazelbuild/platforms to a current release. - Roll forward
     https://github.com/bazelbuild/bazel/commit/0a4533420a3de467fd211d
     7f925cf88e0cd5b76a  with kythe fix.
   + 2eb1bf53d5fef13b89ee440af4f83003d1d0b50a:
     Update docs and tests to use the @platforms//:incompatible
     constraint
   + c71697cf33b0fbbb42fc2910bac83960edc7e855:
     Clarify test_suite behaviour in the Platforms docs
   + dfb70ea4cae2ffffb76e9741d86c96505a6d05ad:
     Enable toolchain resolution for filegroup targets.
   + 24d086446f74606819dc53c3a436caa056ff05b7:
     PlatformProviderUtils should ignore targets that don't have the
     needed
   + ba60c0b3f9bbd00975c984244839b155e84b4c5d:
     ijar: fix manifest sections handling
   + 58bb42ad7ca263a75c6eeef51482f805726663a5:
     Revert "Switch to -fdebug-compilation-dir"
   + 57672aca01b3be895382c952b550c9f8edf6c9f2:
     Update turbine
   + bef4bbbb47d47befe3711d06f358782ee12554f9:
     Update turbine
   + d113d7454127bba78aa618dac81e5d164920b662:
     Update turbine
   + ad241fbebd90a9f0ad65ccd0658838f57030db68:
     Allow cquery to filter out incompatible targets
   + 1782f0ae751569607ef88930c822ac460a1f8bb3:
     Patch grpc to fix cares selecting the wrong source when building
     for darwin_arm64 cpu.
   + 8f7bc2f67fafcaa8d25cfc77eaaedbf8eed2984a:
     [1/3] Bump grpc to 1.33.1 to fix corruption when downloading CAS
     blobs
   + 848a51747a460ab4c5185e4c61ab522a9981cbea:
     [2/3] Bump grpc to 1.33.1 to fix corruption when downloading CAS
     blobs
   + 9b30172547f2093acb56aedf159a77d5dceffda2:
     [3/3] Bump grpc to 1.33.1 to fix corruption when downloading CAS
     blobs
   + 1e258d2a7a5221613047e5cee0aaec5b56045d2b:
     Allow exec groups to inherit from the rule or other exec groups.
   + d0676693310215407224c1b8e8aea9e3eddc183d:
     Support execution constraints per exec group
   + f1e0d346c8235c855e61afc2adb870e4b895e002:
     Clean up RuleContext to use a Table instead of a Map of Maps.
   + 8186fbb47ab964a9affa9a0fc6315fcdbde2b5aa:
     Documentation for #13110
   + 321fe3b6b4e892821ee7dbf2d17dd8ae6a541913:
     Prevent --repo_env from triggering unnecessary fetches
   + 3ebf658cba43bbab1efc36518f0795a7d65e2d46:
     Prevent a crash when using --repo_env=VAR without a value
   + 913a985a5c2fc3842b12c6e5f29af0fa1bccfd6a:
     Report digest of failed uploads
   + 5122617b8a22fee7acd86c9c48f2c2737709ca3f:
     Status error presentation with details
   + 9a70805db543e2fb910e1c55ef3b3567362adf30:
     Fix double shutdown of BuildEventArtifactUploader when BES+File
     output enabled.
   + 325eb956c92530bdfda54a36a186cae4245a4f7b:
     Add rxjava3 to third_party
   + ceaac966a7b977461b69ce9501df6a467f4a93b2:
     remote: set executable bit of an input file based on its real
     value
   + 5b786da75837c5e29714e1d708c3cdf9a67ed32d:
     Remote: correctly implement equals and hashCode.
   + 48648503729d53fdee1322fde2c8e6c05e99cff9:
     Fixed an error that bazel binary is not executable when testing
     with remote execution.
   + bc54c648aa1f99509c7c36d5e6b570d066689209:
     Remote: Use parameters instead of thread-local storage to
     provide tracing metadata.
   + 92955e617b5c41713a5163dc0437c2a024b31815:
     Remote: Use parameters instead of thread-local storage to
     provide tracing metadata. (Part 2)
   + 75bd1ff8ab56d241916bde36291301fa026b2bab:
     Remote: Use parameters instead of thread-local storage to
     provide tracing metadata. (Part 3)
   + 37ee252f3744abc4511f55b5089cc52abd3ba09d:
     Remote: Use parameters instead of thread-local storage to
     provide tracing metadata. (Part 4)
   + 71e35b165f924e2649a078fcf6007645d58039af:
     Remote: Use parameters instead of thread-local storage to
     provide tracing metadata. (Part 5)
   + 32fc451600b6e94a015263eb1c8a63e974f6f4cc:
     Write/QueryWriteStatus logging refinement/addition
   + 97963c5bb24ac79eb3646dd61bfcf2f8a648af54:
     Remote: gRPC load balancing. (Part 1)
   + e2b9a42a61596b0d24f0cadd6b7157b7f1efb221:
     Remote: gRPC load balancing. (Part 2)
   + 6667ad7dd77f8d97952133052c17e7779c1430ec:
     Remote: gRPC load balancing. (Part 3)
   + 7c081eb020186bfb16d4ef1c3832a8e946e99da1:
     Remote: gRPC load balancing. (Part 4)
   + 17afbe4e224b359fee6415a5bd71bbedaa7843eb:
     Implement getMessage for BulkTransferException
   + a6293b3df521aea9075b2ebbcdb675a7d02d3c32:
     Remote: gRPC load balancing. (Part 5)
   + 7a62c2d4e27e398f440910c81eacc384f38ca8be:
     Remote: Add interoperability between Rx and ListenableFuture.
   + 1fcb18a0b455bfcb8e9940778f37d8c82c5ed5a0:
     Update to latest remote-execution proto
   + dad96301d12aa77eb67399e08265a5f30f5ffd6a:
     Set Platform on Action not just Command
   + 6c5a3ee0dcbb4b804f4aa85c038a378fb70eb1f9:
     Remote: Add AsyncTaskCache which is used to deduplicate task
     executions and cache the results.
   + 9d0c7325ac810febe565a62fdd875ae0c240b274:
     Remote: Use AsyncTaskCache inside RemoteActionInputFetcher.
   + f54fe07209acc25340df8d2e02993b1add2deafa:
     Add --experimental_repository_disable_download to allow users
     disable download for external repos
   + b243584a479eb4481a9bf4f69acc899610a3b630:
     Report errors parsing rewriter config file
   + 63bc1c7d0853dc187e4b96a490d733fb29f79664:
     Downloader rewriter config has all_blocked_message
   + 495ac923f398443be45c20ab29d183fe47e08911:
     Allow UrlRewriter to change protocol, i.e. https->http, and
     http->https
   + 8dbbde0037264c1db4b229a09f98a61ab4ca06b0:
     Allow overriding the hostname and instance name in bytestream://
     URIs
   + 0881c80d29acecdfbb58c49156f805e8c50db117:
     Don't set requestId on non-multiplex requests.
   + e3b7e17b05f13ff183a4d7efec8ec797f3f5eaa3:
     When generating a symlink in _virtual_includes, add the original
     header to the 'allowed to use' set too
   + f8f66f36ad299a0ea019c94100d5a8e2018f5ab5:
     Make SimpleLogHandler not swallow interrupts.
   + f8606e5e76579442a1c6563e718ea54c673f1a04:
     linux-sandbox: don't assume -lrt, -D__STDC_FORMAT_MACROS
   + dac0d40d0eb903f5cb70341398d1a333c19adf3a:
     Improve "Common Attributes" section
   + a607d9dc70ac67f1aa2c32ca954177f9c77860be:
     Never create more than one process per WorkerMultiplexer.
   + 80c03ef14a1842d1e3475b1adf98adeb05df33f9:
     Move sending requests and reading responses for multiplex
     workers into separate subthreads.
   + 003cfcde3fd3901c1279ba1db3db3a14536248b4:
     Allow use of JSON protocol in multiplex workers.
   + 308bce36cba46095fe41866e703710035ddddada:
     Actively kill off still-active workers when stopping work on
     interrupt.
   + 8959dff512fe4505af786bcf2ef981ec7082a913:
     Add sanitizer support to Apple platforms
   + 32f16e9360f3e1856db1775eb5014b930da2a303:
     Fix a Google-internal broken link.
   + c9e2be52a067dd9abf5efa4f5f55bb5b98cf5d3b:
     Add SHA-1 to subresource integrity format for download()
     checksums
   + 3b3e6424c6fbd51d4c4ebb6aa25f1d1f4720221c:
     Remove fallback strategy support for workers, add flag for it in
     sandbox.
   + 3457f2ae11e4543de0a5e6e8e37c3aff067891fd:
     Update to java_tools javac11 10.6 (#13245)
   + 4928295b236ec8f590a7e9d863502bc2f50a77d9:
     Allow .S files in C++ Starlark cc_common.compile.
   + 1b18d65227c127fe946d3fcde4586158bc7e5fcb:
     Automatic code cleanup.
   + b5d6c38535c7f6f1eab3fd4c8d3d2da91d0b0f8a:
     Change short output of worker type to have the same logic as the
     worker creation for sandboxing vs. multiplex.
   + e7a0a71f50b69df5d38a8a85fefd36d211e12e8d:
     More properly destroy workers on interrupt.
   + 7056711eb11b672133274eb29fc93b01dcf088d5:
     Make WorkRequestHandler do a GC after some amount of CPU time
     has been used on requests. For Bazel and Blaze, defaults to 10s
     based on benchmarking.
   + 596653d3cf76e7b208da343e1fde5fe20273a5ff:
     Allow tree artifacts to be source or header inputs to
     cc_common.compile()
   + 055c93d11ab20cc4479539b24bbdfa5cab78a342:
     Switch to path autocompletion after -- for bazel run commands.
   + 807f2a1929e23b60b237c63fadb25af81de2e3c3:
     Fix Incompatible Target Skipping for test args
   + 9a5cd854e0613f91d52075973e2454b1e009e1ef:
     Fix order of build request id and command id
   + 706f5acd02363e48076dc97e37613fd968932d03:
     Fix bazel crash when passing config_setting to
     target_compatible_with
   + 61da1d2bf10eabba4c75de959b0374f302d89d70:
     Support multiple --bazelrc on command line
   + 5593358a58b66f06c4e421bb48856de94c3fd625:
     Update ConfiguredTargetFunction.computeUnloadedToolchainContexts
     to
   + 662cf54de7a103db30e04ebae2d2b919437c4846:
     Remote: Fix an issue that a failed action could lead to
     RuntimeException caused by InterruptedException thrown when
     acquiring gRPC connections.
     https://github.com/bazelbuild/bazel/issues/13239
   + a3a1763212f29932618b9b9b2f929976ae0e3b6e:
     Pass more `--add-exports=` flags
   + d2b942879471786e82f1c96eea8722bbe7919fc1:
     Remote: Fixed a bug that remote cache is missed due to
     executable bit is changed
   + 616dc264f02907d7b7887285d22307dfe6d097b6:
     Fix Bazel Coverage with C++ to work with Remote Execution
   + 5f40d12e741aa30d506eaa15673fb2ae76d29468:
     Fix external_path_test with newer Xcode versions.
   + b416193075642017e13c774422b49cb07fb65c23:
     Allow using embedded tools in sandboxed spawn runners.
   + eb762d4e7431637e607146b1c191485795047ef9:
     Fix racy write of temporary files while staging virtual inputs
     for the sandbox.
   + f31e86768579ad7ec57ba13f4c3c1348f5c2702e:
     Update platforms_test to not rely on filegroup not using
     toolchain
   + 13031e5b3bd7c8f29b96b2fee1b380160e0e27fc:
     Update SkyframeTests to not rely on filegroup not using toolchain
   + 11651824a9d0ffb9adb9611dcd39f4c95a59d750:
     Update ConfigurableAttributesTest to not rely on filegroup not
     using …
   + 4b68532e7ea5eb80c926b7b8e2ec2be300004628:
     Make WorkerExecRoot not be a subclass of SandboxedSpawn.
   + 31db460a45767de0bcd664a6efbe9d163b85b802:
     Make WorkerExecRoot not be re-created on each createFileSystem()
     call. Preparation for holding a map of existing links, but also
     just nicer.
   + a2cc0460dc84ad2dc88019af2fe2a65ce80c61e5:
     Start the file existence check traversal from the execroot base
     instead of execroot so that external repo files at
     "<execroot>/../<path>" are correctly handled when the sibling
     repository layout is enabled.
   + b048282c7893231d3a7191b251804973917b07a4:
     Use readdir for cleanExisting in WorkerExecRoot.
   + 270f00dd01fa06cf3e813da5a406be3446de7377:
     Add native support for Apple Silicon
   + 8e56b9423e8ad2f7323fb90b19b73858def81e39:
     Explicitly state that embedding macOS OpenJDK is for x86_64
   + 09c621e4cf5b968f4c6cdf905ab142d5961f9ddc:
     Remote: Fix a race that AsyncTaskCache#Execution could be reused
     after disposed which results in
     CancellationException("disposed") propagated to downstream.
   + 0299cd7e17203a4ce0ea947b62a7c55f1afb8225:
     Remove wrapped_clang params files after use
   + 47edc57806056f3c8764241ed41b8acc72bd2ebf:
     Silence swiftmodule timestamp warnings
   + f6e1074b09ebefba185c0531e9cea26b9596c8a9:
     Remote: Use shutdownNow() instead of shutdown() in
     ChannelConnection#close() as a workaround to a gRPC bug.
   + 71be4ea9e3d20bf90129e34a6a2899fe8401be36:
     And mnemonic and label to remote metadata
   + 615e1b16a81b0defc15699ec8027d6ddd70366d1:
     Change `set -x` in coverage to be set by var
   + fe4daea99c8cd163793eca84bfb12c8fc437616b:
     Bump minimal JDK install base maximum size from 290 to 295 MB.
   + 4840a68cd273a429e46d4114a3973fd11d0e3583:
     Remote: Check the return value of ActionOwner.getLabel() since
     it could be `null`.
   + 14abe4fd7c3967686a3536939fdc3882e691bca2:
     Allow `DiffAwareness` to share precomputed information about the
     workspace and propagate it to the `WorkspaceStatusAction`.
   + 082d98772690946ed29c157e60640c97a6e1195b:
     Implement available() method for Windows subprocesses.
   + c2bdd034014f66ce14529cc353cda18a32320f6c:
     Move --repo_env to common options
   + e09f2743738044095b9d784ea62df16b7f5750e6:
     Revert "Documentation for #13110"
   + a165baa250652fdc865ae0df39160be1f7f74c47:
     Revert "Clean up RuleContext to use a Table instead of a Map of
     Maps."
   + 51fb9e13a864f4f704ae378ea632433bae7ddc31:
     Revert "Support execution constraints per exec group"
   + cb6e5c24b82e0e20a243145fb6ea32b09e3d1de3:
     Revert "Allow exec groups to inherit from the rule or other exec
     groups."
   + 2ac6581aeaab33ba506fce96dfa6a75eaa819233:
     Release 4.1.0 (2021-05-21)
   + 7a0f36e3f0a21fed8857efbaa51ded2dbdeefab6:
     Change gceMachineType of highcpu platform from n1-highcpu-32 to
     e2-highcpu-32
   + 19491a91143f0c6132aca62c5ae40ab72e9dc0e2:
     Fix #10127: Remove Python 2 dependency from tools/android.
   + 80c59dea59d4dce39d4b5d21665c3d7313197358:
     fix main repo starlark options parsing - now flags passed on the
     command line as --@main_workspace//flag and --//flag will both
     parse to --//flag. Before this CL, the former maintained its
     workspace prefix and we would get different entries for these
     two formats.
   + 451b296c3aceb127ebb4a313b6e9608854fa68fa:
     Update threshold for long path shortening to be MAX_PATH - 4
   + 671e0489a5bd6d5abb4dcd9bcfc85134cee38385:
     Force source files to be readable before copying them from
     sandbox.
   + 6080c1e07f4229ea72eacd04faa9302e44955a84:
     Let workers finish lost races without delaying dynamic execution.
   + ee738dacb5d0089d3f57b15305057cb9ba675e74:
     Fix label_flag and label_setting to not have a dependency on the
     default
   + 74de0ba4e79341c77b8b85ff4485f92287b6854c:
     Java coverage: fix handling of external files
   + 48eee8b4b447a2ad11df28dd81a2ccb65562b5f5:
     [Bazel] Fix mobile-install for python2
   + 763dd0ce6e1644bf895231432f616427a11d385a:
     Add `stub_shebang` to `py_runtime`
   + b2231c56d78c6d37bcb6f11e1e50fe68ee336b4a:
     Move use of legacy sandbox -> local fallback to only be used
     after all strategies have been tried, and improve messages
     around it.
   + 6dc941e58dfc1d4a9714a76b921fbe11fce658ed:
     Remove restriction on generate_pdb_file to be only used in dbg
     and fastbuild mode
   + 5b95d9162b56b51c8e8f66258981ddf3c5d96765:
     Check the result of Future.cancel() when cancelling the other
     branch of dynamic execution.
   + aaae8ce2881c8c1a5d4ad64f20d6e71aa372cf2e:
     Update DEFAULT_MACOS_CPU to match host
   + 2f0927a4fd9342f4dcfd43475d3f1c90c523584f:
     Fix symlink creation on older Windows versions
   + fd9cffdcaf05551126e66f1cd62815eaa1af6bd9:
     Suppress interrupted status during pool closure
   + 33903d28bcea0005adf9b2a8cc4659c5e2999bbe:
     Fix Windows developer mode symlinks
   + 0cd1666721bdbe988dc361c085bb43cbd41a27f3:
     Respect Starlark options with values in `removeStarlarkOptions()`
   + 7920ffef472b25db3f4e564e5a3a28a4664c666e:
     cquery inherits from `test` not `build`
   + 1e258d2a7a5221613047e5cee0aaec5b56045d2b:
     Allow exec groups to inherit from the rule or other exec groups.
   + d0676693310215407224c1b8e8aea9e3eddc183d:
     Support execution constraints per exec group
   + f1e0d346c8235c855e61afc2adb870e4b895e002:
     Clean up RuleContext to use a Table instead of a Map of Maps.
   + 8186fbb47ab964a9affa9a0fc6315fcdbde2b5aa:
     Documentation for #13110
   + e376580ae4e9ad5bddc196bfb6ad3127e3ff561b:
     Split ExecGroup into a new target.
   + 0cbb8a863522d2f77ab6b67a01e39b19a9a81807:
     Create a new interface to allow Starlark objects to get a thread
     when getIndex is called.
   + d2e21cec31f09b27ef3589f47b0779f34077ca7e:
     Renamed ExecGroupCollection to clarify that it is only for
     Starlark usage.
   + b9519f92f8ce096107164ca5075feced0e989de7:
     Make StarlarkExecGroupContext use AutoValue.
   + 52b1b748b2368820bac2ca94323fb82c39c00e51:
     Use a dummy toolchain context for rules that don't have one.
   + 41877d0fefe3f021f3ff6d4ce398d0deb27157e6:
     Extract a separate StarlarkToolchainContext for starlark-only
     operations.
   + b120d4febc571f17e12501ad87fbff32ef94e9bb:
     Fix toolchains to support type lookup.
   + dc140d0b6119950dd4a7d71b125b15a78bacc8ce:
     Move DEFAULT_EXEC_GROUP_NAME from ToolchainCollection to
     ExecGroup.
   + 9b18d951a52819f1998ddfdc1739fa1b5bf0353d:
     Rename ToolchainCollection.getExecGroups to getExecGroupNames.
   + 10d4473bf476a587e3d9f9b2214581ec420c1919:
     BuildViewForTesting should directly call into
     ConfiguredTargetFunction.
   + 58a6fb1f8739e39125cc8c647f28cff2e79fe9aa:
     Move exec group tests out of platforms_test and into integration.
   + 7d5493d922761c3ce0037f0025912cc532c55ad7:
     Update creating exec groups that explicitly copy from defaults.
   + 8c6382a81237e72dbec24b3850df9481461e0015:
     Create a new ExecGroupCollection container to manage exec group
     inheritance and exec property parsing.
   + b4b0c321910bc968736ef48e8140528ea7d323cd:
     Fix unix toolchain for macos arm64 platform
   + f64f071f44394a33a1be40cb7642e2c881d1e9bb:
     Add `required_providers` attribute to Starlark defined aspects.
   + f2cbdcf67ac1990f05a8241ba8dae65795edac82:
     Don't ever claim /dev/null is an execpath.
   + ceec93c35ead1bd487e96a5fee46e8d080f88858:
     Don't ever claim /dev/null is an execpath.
   + 1f3f9f4c4b2eded90518aacd1b0b80c1b0dfd1c5:
     Use the parent directory of the exec root as the input root on
     RBE.
   + 4efeac9cb5f85325ed73f64e133a078c483cac01:
     Make the Merkle tree computation work in the wake of
     https://github.com/bazelbuild/bazel/commit/7149f578006a4ad0d51df6
     9830a6986749b34df5 .
   + b56a2aa709dcb681cfc3faa148a702015ec631d5:
     Remote: Use execRoot as input root and do NOT set working
     directory by default.
   + ae53991f2e207edacd1352ba94261e2473b79f14:
     Remote: Add RemoteExecutionService as a layer between spawn
     execution and remote execution.
   + 0c07c2e6571dd4806552213b2237ecb7a908afa4:
     Remote: Add remoteCacheable key to execution log
   + 5e617d83f3aab1fd36b07be4b58aba58604cc46e:
     Remote: Register "remote" strategy even if remote execution is
     not available.
   + 4ca8946a8e1c4c2fd48d8fb8ce38adb8b282fef0:
     Remote: Add --experimental_capture_corrupted_outputs flag.
   + 97d7b4c277814d73b50450b03f4bb160ce7e99b4:
     Remote: Report checking cache status before the action is
     scheduled to run remotely.
   + ba5b2a7c9448a3681a0d86d80670447e338a06dc:
     when writing to local disk cache, open files later in order to
     avoid "too many open files"
   + 3551898849a93306ad9b4dfdd7d4667913098efe:
     Propagate test envs to xml generation action
   + 9f8c678d7054548865f56f3464f778c751657074:
     Remote: Fix a bug that the XML generation is executed even if
     test.xml is generated when build with --remote_download_minimal.
   + af42653e6f6bd229142f4678bb256a8c397b4d8d:
     Automatic code cleanup.
   + 07a84ce31d9b09853c63c7e373418696dd285dc5:
     Remote: Another attempt to fix the CancellationException error
     in AsyncTaskCache caused by a race condition.
   + 0f812eb5e561cc5415d0c9931675e58dc37a5850:
     Remote: Display download progress when actions are downloading
     outputs from remote cache.
   + 18c82168433719b400a705a4a0222969a7a026ba:
     Remote: Do not upload empty output to remote cache.
   + 6a138a60e562beeef36003c4814a6b8ce9f253f6:
     Fix compiling errors
   + bcce6dd026e90336e80616a8c1004a79a2f8640c:
     Add the TEMP_FAILURE_RETRY macro to linux-sandbox-pid1.cc.
   + c8c0d94a49e1b865d95c6d245c2d152c7c7c9722:
     Export proguard specs from aar_import
   + 1a0285c3b64b121268ced3eb9ad9d5ba396b4905:
     Fix stripping of macOS loadable bundles
   + 0d3c231f5a08861d28e987703e9196890e6164bf:
     Roll forward config_setting visibility enforcement behind a flag.
   + bb7a01027242390da1c18fbf87c274cc34c11b79:
     Fix merge conflicts.
   + 8b8e77ea226aaa12e79580422bc5984e80ce048b:
     Remove redundant declaration.
   + 7c92cfcf9a88933c29334f6271ad3f086f7f36f4:
     Ignore empty virtual artifacts when spawn-logging inputs.
   + 4158b61211e099db780565d064a1c1a80c91bd2a:
     Use correct exit code on invalid aquery --output
   + b51b31dbe75a5bc73227fccb4484f3454df81b42:
     Remote: Fix a race when reporting action progresses.
   + 0e652737988e3c115e98e1552f6fada52bc2b9a2:
     Change MIN_BUILD_TOOLS_REVISION to 30.0.0
   + 6f9909c04b1e00faa510b38ccabac78821046cf9:
     Update Android remote tools to ensure Bazel uses the latest
     Android tooling that has been updated to support AndroidX
     databinding generation.
   + 31d88c629dff2c5f8e8a4baf8c89fd3349c9783e:
     Automated rollback of commit
     9a1d428e33bfae1ec5b68250d4732b72346b8b39.
   + 951a3023fbcdbe025e350590e6fa86097da3fe05:
     Increase allowed size of the install_base.
   + a7845f65befbeb65a28ec53e62458211a7bc3f8e:
     Increase allowed size for install base again.
   + affc27f9d18f9781437e91a3f36c73962a56f261:
     Bump version of java allocation instrumenter.
   + 7efabba19cf6400bf9e707f53b40a6dd7110fafb:
     Reference the correct version of the java allocation
     instrumenter.
   + afb819697a6c3daca71a0105d723f54d42fe129f:
     Support extracting aar files.
   + 861c3caa85e47da35a8a4f1512e57d43b9263c37:
     Revert "Remote: Fix a race when reporting action progresses."
   + 92ec798ddc1f38fb4868af08c1d818639283f501:
     Revert "Remote: Display download progress when actions are
     downloading outputs from remote cache."
   + ce091abb290d1d753f480cdee0e69748eb20db52:
     Revert "Fix compiling errors"
   + 1b19cd310418b850e8e0ca2086ffe50755c9ed7e:
     Revert "Remote: Fix a bug that the XML generation is executed
     even if test.xml is generated when build with
     --remote_download_minimal."
   + 988b56f5916e024d10695797a7f963b30fc998c7:
     Revert "Remote: Report checking cache status before the action
     is scheduled to run remotely."
   + 35c98d07b21785efae57a7c4230cc1e452f74fd2:
     Revert "Let workers finish lost races without delaying dynamic
     execution."
   + c4e22b9ace07f5d360c5327a38f9ae4ab24b7109:
     Migrate ExampleWorker to use WorkRequestHandler.
   + 230be161176bd6f1251077af7674f80d38ff1e25:
     Do not interleave readdir() calls with deletion of directory
     entries.
   + 3cc8ce6ba0934b1a4d9db184daf055c1207ef105:
     Propagate OOME if NewByteArray allocation failed
   + 19fc15ebbf6c63fcce90a038e91c5ec726852848:
     Create helper method for sandbox tests, transform existing tests
     into using it.
   + deb1006c0778692f7eaef4cbcf7eeb8112b55e91:
     Cleanup: Replace NULL with nullptr
   + f4b5e0233341977aaa76593ca032d9ac4eba7444:
     Let workers finish lost races without delaying dynamic execution.
   + 186decab01ee247c7453baf19dac778545ec4937:
     Interface and flag specification for worker cancellation.
   + 5894a8544d51c99f1356130b8b487bc93299fedd:
     Create BUILD file in worker tests directory instead of running
     tests from the parent directory.
   + e9e6978809b0214e336fee05047d5befe4f4e0c3:
     Server-side implementation of worker cancellation.
   + 5103662238f2df2038c7dff079e9c655e08ba654:
     Add builder for WorkRequestHandler.
   + 1a519bb66c3fa3e4ef3b9a9a556597920751fbcd:
     Makes singleplex requests be handled in separate threads in
     WorkRequestHandler.
   + 779d66019210f54e10a1343ee004df72a8dec812:
     Only allow worker async finishing when sandboxed.
   + a698bef6146a807fd82ee4402d89c23c83802e33:
     Support for cancellation in WorkRequestHandler.
   + 9dc95af4c7ef10979f21173260f5433006116096:
     Make workers restart on flags that affect their
     creation/behaviour.
   + 7e5cd529e9f8c9cb67900af36182f00ef7316654:
     Remote: Report checking cache status before the action is
     scheduled to run remotely.
   + 6e134a1b68418fba9992692901efa77a80c346f7:
     Remote: Fix a bug that the XML generation is executed even if
     test.xml is generated when build with --remote_download_minimal.
   + d4d071401acadb0d8977850a9439474e60fd7bb9:
     Fix compiling errors
   + 2579c9a18360955699d028426b45d381ff53783c:
     Eagerly initialize JNI copies of Java classes: doing lazy
     initialization on a per-method basis doesn't save anything and
     adds a tiny bit of overhead to every one of these calls.
   + 0f812eb5e561cc5415d0c9931675e58dc37a5850:
     Remote: Display download progress when actions are downloading
     outputs from remote cache.
   + 3835d9b21ad524d06873dfbf465ffd2dfb635ba8:
     Update the WorkRequestHandler to use callbacks of type:
     BiFunction<WorkRequest, PrintWriter, Integer>:  - Mark
     constructors that use BiFunction<List<String>, PrintWriter,
     Integer> callback as deprecated.  - Use a wrapper class for the
     BiFunction<WorkRequest, PrintWriter, Integer>. Suggesting this
     to avoid having two constructors that takes a BiFunction, as it
     creates a confusion between the deprecated and new constructor
     when given a lambda expressions.
   + 5e352afe2b35487ea2ced85ca79bd9f79858e648:
     Fix bug in WorkRequestHandler's handling of singleplex requests
     that would cause occasional hangs.
   + b51b31dbe75a5bc73227fccb4484f3454df81b42:
     Remote: Fix a race when reporting action progresses.
   + c9d823e42796962eed039b8122528c2a1541190f:
     Disable flaky test.
   + e6809c90ecc0ef5783faa39e63188fc33a79b80e:
     Revert "Check the result of Future.cancel() when cancelling the
     other branch of dynamic execution."
   + be4cbc7a67196414e3d3f323be8ab55fb5e530f7:
     Revert "Move use of legacy sandbox -> local fallback to only be
     used after all strategies have been tried, and improve messages
     around it."
   + b32349f50ff3d958613aef9275751ad9d50d344c:
     Set a fallback dynamic local strategy even when the
     dynamic_local_strategy flag is passed.
   + f395157c95692565bc220c7ccf788974fe0885fd:
     Allow running an extra spawn for local branch of dynamic
     execution.
   + 039461c76113ab3f165132dd26d0c58eb3e45cae:
     Adding debugging information for case when two branches
     apparently cancel each other.
   + b2231c56d78c6d37bcb6f11e1e50fe68ee336b4a:
     Move use of legacy sandbox -> local fallback to only be used
     after all strategies have been tried, and improve messages
     around it.
   + 5b95d9162b56b51c8e8f66258981ddf3c5d96765:
     Check the result of Future.cancel() when cancelling the other
     branch of dynamic execution.
   + 1962a59a5478f5ad374700b0abf0a718b1b3a7d3:
     Fix the case where if all strategies for one branch of `dynamic`
     execution fail to accept (that is, refuse to even take) the
     action given, the whole action fails. Instead of seeing whether
     the other branch can run and the action that that it succeeded.
   + b7c1ad2aff91105659299723a712b72eea943040:
     Fix rare crash in dynamic execution where both branches got
     cancelled.
   + 2c3cff5422b115d7bb86ed28a056f3d368ebceeb:
     Check if `treeDeleter` is actually async before casting it.
     Fixes #13240.
   + 1a89ce1757e75f8ba9bda76d7373a7e8527bcfc5:
     Make worker JSON protocol properly ignore unknown fields.
   + 7bbff61d9486eeb6b7cd0b6cfb619a9b6e08967b:
     Fix test_source_file_does_not_override_standard_library to work
     with Python 3.9.
   + f4e10367df2d881f05e3ddd5bd0531b390a845fe:
     Removing line ending matches in tests to be compatible on Windows
   + ba74df07ced96226d78851e11d1df03147f1cc1f:
     Refactors CompilationSupport for objc to use existing API
```

Important changes:

  - Multiplex persistent workers can now use the JSON protocol.
  - enforce config_setting visibility. See
    https://github.com/bazelbuild/bazel/issues/12932 for details.
  - The minimum Android build tools version for the Android rules is
    now 30.0.0
  - Updates worker protocol with cancellation fields, and adds
    experimental_worker_cancellation flag to control cancellation.
  - If all strategies of one branch (the local or remote execution
    branch) of the `dynamic` strategy fail to even accept (via the
    response they give from `canExec`) the action, `dynamic` will now
    try to see if the other branch can accept it. (Trying to run it
    and it failing will still cause a failure if it was the first
    result, this is about strategies claiming they can't even try the
    action)

This release contains contributions from many people at Google, as well as Alex Eagle, Austin Schuh, Benjamin Peterson, bromano, Christopher Peterson Sauer, Christopher Sauer, Cristian Hancila, Daniel Wagner-Hall, Denys Kurylenko, Ed Schouten, Finn Ball, George Gensure, Greg Estren, Johannes Abt, Keith Smiley, Kevin Hogeland, Lauri Peltonen, Philipp Schrader, Ryan Beasley, Thi Doan, ThomasCJY, Timothy Klim, Trustin Lee, Ulf Adams, Vaidas Pilkauskas, Vertexwahn, wisechengyi, Xavier Bonaventura, Yannic Bonenberger, Yuval Kaplan, Yuval.

## Release 5.0.0-pre.20210708.4 (2021-07-16)

```
Baseline: ca1d20fdfa95dad533c64aba08ba9d7d98be41b7

Cherry picks:

   + 802901e697015ee6a56ac36cd0000c1079207d12:
     Add flags parameter to attr.label for use in builtins only.
   + aa768ada9ef6bcd8de878a5ca2dbd9932f0868fc:
     Automated rollback of commit
     ca1d20fdfa95dad533c64aba08ba9d7d98be41b7.
   + 4bcf2e83c5cb4f459aae815b38f1edd823286a29:
     Automated rollback of commit
     ff38dbfc65b8ffe92833e67f12ce616739a3d213.
   + 706483fd6398f00fd4faba73812de9bf15728086:
     Resolve merge conflict
   + 3821db8725b9ea3267cddfd0bbad55f50e96527e:
     Fix merge conflict properly
```

Important changes:

  - The used_heap_size_post_build field in BEP is populated when the
    --memory_profile flag is set

This release contains contributions from many people at Google, as well as Daniel Wagner-Hall, Grzegorz Lukasik, Keith Smiley, Kevin Hogeland, Yannic Bonenberger.

## Release 5.0.0-pre.20210623.2 (2021-07-02)

```
Baseline: 8b453331163378071f1cfe0ae7c74d551c21b834

Cherry picks:

   + 223113c9202e8f338b183d1736d97327d28241ea:
     Automated rollback of commit
     ae2a6a2dc909e468a284913c410fde995cf51095.
```

Important changes:

  - Adds --experimental_reuse_sandbox_directories flag to reuse
    already-created non-worker sandboxes with cleanup.
  - --experimental_force_gc_after_build is deprecated and will be
    removed soon. Use --bep_publish_used_heap_size_post_build instead
  - Forward coverage-instrumented files from non-tool dependencies by
    default.

This release contains contributions from many people at Google, as well as David Ostrovsky, Johannes Abt, Masoud Koleini, Pras Velagapudi.

## Release 5.0.0-pre.20210615.3 (2021-06-25)

```
Baseline: e7bd0947ab552a26ec032d0f1a50ee15c8810f6c

Cherry picks:

   + 04bed291c9f56163ae4da3a358d71cf8399b47a4:
     Disable shadowed_action part of action_aspect_test
   + 367b19eb8821b4de738c6c994ba275c695f4726b:
     Fix starlark action with shadowed_action inputs cache test
   + 4acb9ae67a7135b2365b92e91601d4797adc2ad5:
     Automated rollback of commit
     03f6af623ae3de4a9b756b5235ebd31cc2faf762.
```

Incompatible changes:

  - Native libraries in data attribute are not collected. See
    https://github.com/bazelbuild/bazel/issues/13550 for details

Important changes:

  - Remove obsolete --incompatible_prohibit_aapt1
  - The minimum Android build tools version for the Android rules is
    now 30.0.0

This release contains contributions from many people at Google, as well as Cameron Mulhern, Delwin9999, Keith Smiley.

## Release 5.0.0-pre.20210604.6 (2021-06-11)

```
Baseline: d571c8976f279e4d485498d0875c85ae73aecc42

Cherry picks:

   + c367a7e027f351e8ffefabf919563abbb8c7d0e1:
     Fix places where nodes were still being enqueued at
     `Integer.MAX_VALUE` and add checks for overflow conditions.
   + 260015df1524543d56b0dbff00958320cd58d166:
     Automated rollback of commit
     f1b37b5d610728634d92ef4ebd4d1435c0c8605d.
```

Important changes:

  - Add `disable_annotation_processing` option to
    `java_common.compile`, which disables any annotation processors
    passed to `plugins` or in `exported_plugins` of `deps`

This release contains contributions from many people at Google, as well as Dave MacLachlan, FaBrand, George Gensure, Jesse Chan, Keith Smiley, Kevin Hogeland, Uri Baghin, Xavier Bonaventura.

## Release 5.0.0-pre.20210520.7 (2021-06-09)

```
Baseline: e2ae73fe16cbedf095b9e6d5687b06ecf765d794

Cherry picks:

   + 0fdb485421f9d134f11103a36c48182769fb40d3:
     Automated rollback of commit
     f2230d8494e70f02b1e4fb082fcf8550aa684a40.
   + 1f52e9a58dd814f203797c5fbab44d9f4d53a43c:
     Support rolling releases in Bazel release scripts.
   + 2f72244183c8c3de722ff1d9e8b0b745d12cd528:
     Fix syntax error in Bazel release scripts
   + 4ef9c566c861848fef7907cf07a6e7d9d15cee7a:
     Fix location of -prerelease option
   + a6dfd927c58c63275159858ac661a9b669594a0c:
     Add --experimental_shadowed_action to graveyard options for all
     commands.
```

Important changes:

  - If all strategies of one branch (the local or remote execution
    branch) of the `dynamic` strategy fail to even accept (via the
    response they give from `canExec`) the action, `dynamic` will now
    try to see if the other branch can accept it. (Trying to run it
    and it failing will still cause a failure if it was the first
    result, this is about strategies claiming they can't even try the
    action)

This release contains contributions from many people at Google, as well as Benedek Thaler.

## Release 5.0.0-pre.20210516.1 (2021-06-09)

```
Baseline: 275c54c982468b97611dc764c68daed8d7c45004

Cherry picks:

   + 1f52e9a58dd814f203797c5fbab44d9f4d53a43c:
     Support rolling releases in Bazel release scripts.
   + 2f72244183c8c3de722ff1d9e8b0b745d12cd528:
     Fix syntax error in Bazel release scripts
   + 4ef9c566c861848fef7907cf07a6e7d9d15cee7a:
     Fix location of -prerelease option
```

This release contains contributions from many people at Google, as well as Keith Smiley, Niek Peeters.

## Release 5.0.0-pre.20210510.2.2 (2021-06-01)

```
Baseline: 8a42645ec500874b0440475763ab680d5efc1e6a

Cherry picks:

   + e3c78c4eeaf4e8db3c22aa71c6c1578cb48c8dcc:
     Ensure that test status artifacts are reported as top-level
     artifacts.
   + 1f52e9a58dd814f203797c5fbab44d9f4d53a43c:
     Support rolling releases in Bazel release scripts.
   + 2f72244183c8c3de722ff1d9e8b0b745d12cd528:
     Fix syntax error in Bazel release scripts
   + 4ef9c566c861848fef7907cf07a6e7d9d15cee7a:
     Fix location of -prerelease option
```

This release contains contributions from many people at Google, as well as .

## Release 5.0.0-pre.20210510.2.1 (2021-05-31)

```
Baseline: 8a42645ec500874b0440475763ab680d5efc1e6a

Cherry picks:

   + e3c78c4eeaf4e8db3c22aa71c6c1578cb48c8dcc:
     Ensure that test status artifacts are reported as top-level
     artifacts.
   + 1f52e9a58dd814f203797c5fbab44d9f4d53a43c:
     Support rolling releases in Bazel release scripts.
   + 2f72244183c8c3de722ff1d9e8b0b745d12cd528:
     Fix syntax error in Bazel release scripts
```

This release contains contributions from many people at Google, as well as .

## Release 5.0.0-pre.20210510.2 (2021-05-31)

```
Baseline: 8a42645ec500874b0440475763ab680d5efc1e6a

Cherry picks:

   + e3c78c4eeaf4e8db3c22aa71c6c1578cb48c8dcc:
     Ensure that test status artifacts are reported as top-level
     artifacts.
   + 1f52e9a58dd814f203797c5fbab44d9f4d53a43c:
     Support rolling releases in Bazel release scripts.
```

Incompatible changes:

  - Removing java_common.javac_jar Starlark call.
  - native.existing_rule now returns select values in a form that is
    accepted by rule instantiation. This is a breaking API change
    because there is some code that relies on the precise type
    returned, including brittle workarounds for this bug specifically
    and insufficiently flexible workarounds for other issues with the
    intersection of select and native.existing_rule.
  - flipped incompatible_use_toolchain_resolution_for_java_rules, see
    #7849
  - Query output=xml/proto/location for source files will now show
    the location of line 1 of the source file (as the new default)
    instead of its location in the BUILD file.
  - Specifying a target pattern underneath a directory specified by
    .bazelignore will now emit a warning, not an error.
  - Query `--order_output=auto` will now sort lexicographically.
    However, when `somepath` is used as a top level function (e.g.
    `query 'somepath(a, b)'`), it will continue to output in
    dependency order. If you do not want the lexicographical output
    ordering, specify another `--order_output` value (`no`, `deps` or
    `full`) based on what ordering you require.
  - In the build event stream,
    BuildMetrics.TargetMetrics.targets_loaded is no longer populated.
    Its value was always mostly meaningless.
    BuildMetrics.TargetMetrics.targets_configured and
    BuildMetrics.ActionSummary.actions_created now include configured
    aspect data.
  - //visibility:legacy_public has been removed.
  - Flip and remove incompatible_dont_collect_so_artifacts
    (https://github.com/bazelbuild/bazel/issues/13043).
  - Remove flag --experimental_no_product_name_out_symlink: it is
    always true.
  - The Starlark method generate_dsym in objc fragment has
    been deleted.  Please use the equivalent apple_generate_dsym in
    cpp
    fragment instead.

Important changes:

  - Flag --incompatible_objc_compile_info_migration is removed.  See
    #10854.
  - Flag --incompatible_objc_compile_info_migration is removed.  See
    #10854.
  - Flag --incompatible_objc_compile_info_migration is removed.  See
    #10854.
  - none
    PAIR=cmita
  - The --incompatible_load_python_rules_from_bzl flag is now a no-op.
  - Filter all (instead of just C++) source files for coverage output
    according to --instrumentation_filter and
    --instrument_test_targets.
  - The `--incompatible_disable_native_apple_binary_rule` flag has
    been added which disables the native `apple_binary` rule. Users
    who need to use `apple_binary` directly (if they cannot use one
    of the more specific Apple rules) should load it from
    https://github.com/bazelbuild/rules_apple.
  - The Android rules' --use_singlejar_apkbuilder is now a no-op.
    SingleJar will always be used to build APKs.
  - dict.setdefault(key, ...) now fails if dict is frozen, even if it
    already contains key. This is an incompatible API change.
  - Flag --incompatible_objc_provider_remove_compile_info is removed.
     See #11359.
  - Starlark now permits def statements to be nested (closures).
  - native.existing_rule now returns select values in a form that is
    accepted by rule instantiation. This is a breaking API change,
    though the fallout is expected to be small.
  - Starlark now supports lambda (anonymous function) expressions.
  - The "test" and "coverage" commands no longer return 3 when a
    test action fails because of a system error. Instead, the exit
    code
    reflects the type of system error.
  - The undocumented ctx.expand feature no longer exists.
  - Make --legacy_dynamic_scheduler a no-op flag.
  - Multiplex persistent workers can now use the JSON protocol.
  - native.existing_rule now returns a mutable list, not a tuple, for
    a list-valued attributes. This is an incompatible API change.
  - Roll back change to have native.existing_rules use list instead
    of tuple.
  - BEP includes test suite expansions.
  - config_setting now honors `visibility` attribute (and defaults to
    `//visibility:public`)
  - Change the MultiArchSplitTransitionProvider to be based on
    platform type + CPU instead of fixed "ios_" + cpu.
  - enforce config_setting visibility. See
    https://github.com/bazelbuild/bazel/issues/12932 for details.
  - add a flag to build v4 signature file
  - Added _direct_source_jars output group to Java related targets.
    END_PUBLIC
  - pkg_deb is no longer part of @bazel_tools//build_defs/pkg:pkg.bzl.
    Use https://github.com/bazelbuild/rules_pkg/tree/main/pkg instead
  - Allowing the lipo operations to be conditional in the
    linkMultiArchBinary API for Apple binaries. Single architecture
    slices are now returned through AppleBinaryOutput and the
    Starlark API.
  - Release restriction for "-" in the package name for Python
    sources. Now `py_binary` and `py_test` targets can have main
    source file with "-" in the path.
  - Users consuming BEP may assume that a `named_set_of_files` event
    will
    appear before any event referencing that `named_set` by ID. This
    allows consumers
    to process the files for such events (eg. `TargetCompleted`)
    immediately.
  - BEP includes all files from successful actions in requested
    output groups.
    Previously, an output group's files were excluded if any file in
    the output group
    was not produced due to a failing action. Users can expect BEP
    output to be larger
    for failed builds.
  - In BEP, TargetComplete.output_group has a new field `incomplete`
    indicating that the file_sets field is missing one or more
    declared artifacts
    whose generating actions failed.
  - The flag `--toolchain_resolution_debug` now takes a regex
    argument, which is used to check which toolchain types should
    have debug info printed. You may use `.*` as an argument to keep
    the current behavior of debugging every toolchain type.
  - Add runfiles.merge_all() for merging a sequence of runfiles
    objects.
  - runfiles.merge() and merge_all() now respect
    --nested_set_depth_limit.
    If you hit the depth limit because you were calling merge() in a
    loop, use
    merge_all() on a sequence of runfiles objects instead.
  - Bazel will no longer create a bazel-out symlink if
    --symlink_prefix is specified: the directory pointed to via the
    bazel-out symlink is accessible via ${symlink_prefix}-out. If
    this causes problems for you, set
    --experimental_no_product_name_out_symlink=false in your builds
    and file an issue.
  - Updates worker protocol with cancellation fields, and adds
    experimental_worker_cancellation flag to control cancellation.
  - Simplify build failure output by always using `NNN arguments`.
  - trim_test_configuration now defaults to on
  - Mark genrule.srcs as a source attribute for coverage.
  - When using --allow_analysis_failures (for example, via
    bazel-skylib's
    analysistest with `expect_failure = True`), analysis-time
    failures in aspect
    implementation functions will now be propagated and saved in
    AnalysisFailureInfo, just like analysis-time failures in rules.
  - cquery --noimplicit_deps now correctly filters out resolved
    cc_toolchains
  - Sign apks deterministically.
  - Make gcov optional in cc_toolchain tools.
  - If --experimental_prefer_mutual_xcode is passed, Bazel will
    choose the local default (instead of the newest mutually
    available version) if it's available both locally and remotely.
  - Remove java_lite_proto_library.strict_deps attribute.
  - Generate proguard configurations deterministically.
  - Adds a new flag, `--incompatible_enable_cc_test_feature` which
    switches from the use of build variables to the feature of the
    same name.
  - Dropped fragile xz support from built in pkg_tar. Users requiring
    xz
    compression should switch to bazlebuild/rules_pkg.

This release contains contributions from many people at Google, as well as Adam Liddell, Alex Eagle, Anthony Pratti, Austin Schuh, Benedek Thaler, Benjamin Lee, Benjamin Peterson, bromano, Christopher Sauer, Cristian Hancila, Daniel McCarney, Daniel Wagner-Hall, Danny Wolf, Dave Nicponski, David Cummings, David, David Ostrovsky, Denys Kurylenko, Dmitry Ivankov, dorranh, Ed Schouten, Elliotte Rusty Harold, erenon, Eric Cousineau, Ethan Steinberg, Felix Ehrenpfort, Finn Ball, Fredrik Medley, Garrett Holmstrom, Gautam Korlam, George Gensure, goodspark, Greg Estren, Grzegorz Lukasik, John Laxson, Jonathan Schear, Justus Tumacder, Keith Smiley, Lauri Peltonen, Liu Liu, Lszl Csomor, m, Marc Zych, Mark Karpov, Matt Mackay, Max Liu, Menny Even Danan, menny, Michael Chinen, Nathaniel Brough, Nick Korostelev, Nikolay Shelukhin, odisseus, Oleh Stolyar, Olek Wojnar, Olle Lundberg, Philipp Schrader, Qais Patankar, Ryan Beasley, samhowes, Samuel Giddins, Sebastian Olsson, Steve Siano, steve-the-bayesian, Stiopa Koltsov, susinmotion, tatiana, Thi Doan, ThomasCJY, Timothy Klim, Tobi, Torgil Svensson, Trustin Lee, Ulf Adams, Vaidas Pilkauskas, Vertexwahn, wisechengyi, Xavier Bonaventura, Yannic Bonenberger, Yannic, Yury Evtikhov, Yuval Kaplan, Yuval, [zqzzq].

## Release 4.1.0 (2021-05-21)

```
Baseline: 37a429ad12b4c9e6a62dbae4881a1ff03b81ab40

Cherry picks:

   + a689d673abadf80f1efaf8ddaeee92d56fc2847b:
     Use getRunfilesPath for run_under executable path generation.
     getRootRelativePath doesn't return a valid runfiles path for
     external source files anymore after the recent external source
     root change. Also, it won't work for external labels either once
     the --nolegacy_external_runfiles becomes default. This fixes
     issue #12545.
   + d90ec67fdab9710f649a3c1d374fb6b938b9271a:
     Fix NPE when coveragerunner is not set on the toolchain.
   + 8555789dd239a5ac229c1d9cee80b2a9f30b3bf7:
     Fix the classic query package-loading cutoff optimization with
     external workspaces.
   + 57672aca01b3be895382c952b550c9f8edf6c9f2:
     Update turbine
   + bef4bbbb47d47befe3711d06f358782ee12554f9:
     Update turbine
   + d113d7454127bba78aa618dac81e5d164920b662:
     Update turbine
   + 1489f0f4cae3e9247a70e4003ab76bef45c5b986:
     Support Scala3 .tasty files
   + 0d2d95cd7e34b4061c8e5fdfd21ba0ab8818c685:
     Update to java_tools javac11 release 10.5 (#12647)
   + a9419f38d5f29af31a6c8ebda09a6e0303a6ba54:
     Fix common prefix for instrumentation filter
   + 84fadcf81f81b2d7343ca4151a5639be7f2263ee:
     Fix builds for filegroup targets with incompatible dependencies
   + e43825d0bef359f645e1cabf2164fd2db6ee4a35:
     Revert "Remove
     --incompatible_blacklisted_protos_requires_proto_info"
   + 082d58de852ebaa640bcf13cf419cbb94eec2b26:
     Transform roots along with paths during output deletion.
   + e8835c1c221d76a2d5532d18083eaa04401619b3:
     AttributeContainer.Large now handles more than 127 attributes.
   + e1e87349335ac59f9b3df47cee8b999faeaa6d11:
     Add an env attribute to all test and binary rule classes
   + a87d7ed2411d5382bac58a20b79e09c464ad13b9:
     Take no action to prefetch empty artifacts.
   + 3e969ff24a6a0e03139b9f288c88451a7dfa97cd:
     Fix a couple of bugs with Incompatible Target Skipping
   + e6670825b1e183f81f5c864aafd425d512fa9ff5:
     Pass --host_action_env to host options hostActionEnvironment
     attribute
   + 07400c0392e7be163f8a3396fa5cf89ce6705412:
     Add --{no,}autodetect_server_javabase.
   + c83366064621d5a265eba14d93a03deff58fe6d8:
     Only treat "env" and "env_inherit" attrs specially for native
     rules
   + 6a60b30cd0f22d0ab84b2ddd658d5ccb899a8a76:
     Fix coverage support when using default_java_toolchain. (#12801)
   + 4158a6f512e52516437e00f8d9609a91be7fc195:
     Revert JacocoCoverage target to remote_java_tools_java_import
     and add a new target for remore_java_tools_filegroup. (#12813)
   + f6d30cf5ef9a8a39fea7072317f89a872387b790:
     Add windows_msvc back to conditions in bazel_tools.
   + 6b33bdb1e22514304c0e35ce8e067f2175685245:
     Release 4.0.0 (2021-01-21)
   + 8811e27353c2c10980faf7e4c5e44b431d2d4f1c:
     Fix error message from getPrerequisites to not print internal
     details.
   + 27e15ad11410eb1014f5247fd0eeb31a46733c07:
     Clean up ConfiguredTargetValueAccessor and
     ConfiguredTargetAccessor
   + e87feb8ac9573cef993824f82370d0389570521d:
     Move getConfigConditions into ConfiguredTarget.
   + 34d98234324da83e93ba0d5ef5702880d5ac7c5c:
     Change ConfiguredTargetQuery to use KeyedConfiguredTarget as a
     value.
   + 079bb7d69931705bb2b092c9017090e224ef3043:
     Clean up old dependencies that are unused since
     https://github.com/bazelbuild/bazel/commit/34d98234324da83e93ba0d
     5ef5702880d5ac7c5c.
   + e03cb63e059420847d6578d7cbfe93f05615c95e:
     Update bazelbuild/platforms to a current release. - Roll forward
     https://github.com/bazelbuild/bazel/commit/0a4533420a3de467fd211d
     7f925cf88e0cd5b76a  with kythe fix.
   + 2eb1bf53d5fef13b89ee440af4f83003d1d0b50a:
     Update docs and tests to use the @platforms//:incompatible
     constraint
   + c71697cf33b0fbbb42fc2910bac83960edc7e855:
     Clarify test_suite behaviour in the Platforms docs
   + dfb70ea4cae2ffffb76e9741d86c96505a6d05ad:
     Enable toolchain resolution for filegroup targets.
   + 24d086446f74606819dc53c3a436caa056ff05b7:
     PlatformProviderUtils should ignore targets that don't have the
     needed
   + ba60c0b3f9bbd00975c984244839b155e84b4c5d:
     ijar: fix manifest sections handling
   + 58bb42ad7ca263a75c6eeef51482f805726663a5:
     Revert "Switch to -fdebug-compilation-dir"
   + 57672aca01b3be895382c952b550c9f8edf6c9f2:
     Update turbine
   + bef4bbbb47d47befe3711d06f358782ee12554f9:
     Update turbine
   + d113d7454127bba78aa618dac81e5d164920b662:
     Update turbine
   + ad241fbebd90a9f0ad65ccd0658838f57030db68:
     Allow cquery to filter out incompatible targets
   + 1782f0ae751569607ef88930c822ac460a1f8bb3:
     Patch grpc to fix cares selecting the wrong source when building
     for darwin_arm64 cpu.
   + 8f7bc2f67fafcaa8d25cfc77eaaedbf8eed2984a:
     [1/3] Bump grpc to 1.33.1 to fix corruption when downloading CAS
     blobs
   + 848a51747a460ab4c5185e4c61ab522a9981cbea:
     [2/3] Bump grpc to 1.33.1 to fix corruption when downloading CAS
     blobs
   + 9b30172547f2093acb56aedf159a77d5dceffda2:
     [3/3] Bump grpc to 1.33.1 to fix corruption when downloading CAS
     blobs
   + 1e258d2a7a5221613047e5cee0aaec5b56045d2b:
     Allow exec groups to inherit from the rule or other exec groups.
   + d0676693310215407224c1b8e8aea9e3eddc183d:
     Support execution constraints per exec group
   + f1e0d346c8235c855e61afc2adb870e4b895e002:
     Clean up RuleContext to use a Table instead of a Map of Maps.
   + 8186fbb47ab964a9affa9a0fc6315fcdbde2b5aa:
     Documentation for #13110
   + 321fe3b6b4e892821ee7dbf2d17dd8ae6a541913:
     Prevent --repo_env from triggering unnecessary fetches
   + 3ebf658cba43bbab1efc36518f0795a7d65e2d46:
     Prevent a crash when using --repo_env=VAR without a value
   + 913a985a5c2fc3842b12c6e5f29af0fa1bccfd6a:
     Report digest of failed uploads
   + 5122617b8a22fee7acd86c9c48f2c2737709ca3f:
     Status error presentation with details
   + 9a70805db543e2fb910e1c55ef3b3567362adf30:
     Fix double shutdown of BuildEventArtifactUploader when BES+File
     output enabled.
   + 325eb956c92530bdfda54a36a186cae4245a4f7b:
     Add rxjava3 to third_party
   + ceaac966a7b977461b69ce9501df6a467f4a93b2:
     remote: set executable bit of an input file based on its real
     value
   + 5b786da75837c5e29714e1d708c3cdf9a67ed32d:
     Remote: correctly implement equals and hashCode.
   + 48648503729d53fdee1322fde2c8e6c05e99cff9:
     Fixed an error that bazel binary is not executable when testing
     with remote execution.
   + bc54c648aa1f99509c7c36d5e6b570d066689209:
     Remote: Use parameters instead of thread-local storage to
     provide tracing metadata.
   + 92955e617b5c41713a5163dc0437c2a024b31815:
     Remote: Use parameters instead of thread-local storage to
     provide tracing metadata. (Part 2)
   + 75bd1ff8ab56d241916bde36291301fa026b2bab:
     Remote: Use parameters instead of thread-local storage to
     provide tracing metadata. (Part 3)
   + 37ee252f3744abc4511f55b5089cc52abd3ba09d:
     Remote: Use parameters instead of thread-local storage to
     provide tracing metadata. (Part 4)
   + 71e35b165f924e2649a078fcf6007645d58039af:
     Remote: Use parameters instead of thread-local storage to
     provide tracing metadata. (Part 5)
   + 32fc451600b6e94a015263eb1c8a63e974f6f4cc:
     Write/QueryWriteStatus logging refinement/addition
   + 97963c5bb24ac79eb3646dd61bfcf2f8a648af54:
     Remote: gRPC load balancing. (Part 1)
   + e2b9a42a61596b0d24f0cadd6b7157b7f1efb221:
     Remote: gRPC load balancing. (Part 2)
   + 6667ad7dd77f8d97952133052c17e7779c1430ec:
     Remote: gRPC load balancing. (Part 3)
   + 7c081eb020186bfb16d4ef1c3832a8e946e99da1:
     Remote: gRPC load balancing. (Part 4)
   + 17afbe4e224b359fee6415a5bd71bbedaa7843eb:
     Implement getMessage for BulkTransferException
   + a6293b3df521aea9075b2ebbcdb675a7d02d3c32:
     Remote: gRPC load balancing. (Part 5)
   + 7a62c2d4e27e398f440910c81eacc384f38ca8be:
     Remote: Add interoperability between Rx and ListenableFuture.
   + 1fcb18a0b455bfcb8e9940778f37d8c82c5ed5a0:
     Update to latest remote-execution proto
   + dad96301d12aa77eb67399e08265a5f30f5ffd6a:
     Set Platform on Action not just Command
   + 6c5a3ee0dcbb4b804f4aa85c038a378fb70eb1f9:
     Remote: Add AsyncTaskCache which is used to deduplicate task
     executions and cache the results.
   + 9d0c7325ac810febe565a62fdd875ae0c240b274:
     Remote: Use AsyncTaskCache inside RemoteActionInputFetcher.
   + f54fe07209acc25340df8d2e02993b1add2deafa:
     Add --experimental_repository_disable_download to allow users
     disable download for external repos
   + b243584a479eb4481a9bf4f69acc899610a3b630:
     Report errors parsing rewriter config file
   + 63bc1c7d0853dc187e4b96a490d733fb29f79664:
     Downloader rewriter config has all_blocked_message
   + 495ac923f398443be45c20ab29d183fe47e08911:
     Allow UrlRewriter to change protocol, i.e. https->http, and
     http->https
   + 8dbbde0037264c1db4b229a09f98a61ab4ca06b0:
     Allow overriding the hostname and instance name in bytestream://
     URIs
   + 0881c80d29acecdfbb58c49156f805e8c50db117:
     Don't set requestId on non-multiplex requests.
   + e3b7e17b05f13ff183a4d7efec8ec797f3f5eaa3:
     When generating a symlink in _virtual_includes, add the original
     header to the 'allowed to use' set too
   + f8f66f36ad299a0ea019c94100d5a8e2018f5ab5:
     Make SimpleLogHandler not swallow interrupts.
   + f8606e5e76579442a1c6563e718ea54c673f1a04:
     linux-sandbox: don't assume -lrt, -D__STDC_FORMAT_MACROS
   + dac0d40d0eb903f5cb70341398d1a333c19adf3a:
     Improve "Common Attributes" section
   + a607d9dc70ac67f1aa2c32ca954177f9c77860be:
     Never create more than one process per WorkerMultiplexer.
   + 80c03ef14a1842d1e3475b1adf98adeb05df33f9:
     Move sending requests and reading responses for multiplex
     workers into separate subthreads.
   + 003cfcde3fd3901c1279ba1db3db3a14536248b4:
     Allow use of JSON protocol in multiplex workers.
   + 308bce36cba46095fe41866e703710035ddddada:
     Actively kill off still-active workers when stopping work on
     interrupt.
   + 8959dff512fe4505af786bcf2ef981ec7082a913:
     Add sanitizer support to Apple platforms
   + 32f16e9360f3e1856db1775eb5014b930da2a303:
     Fix a Google-internal broken link.
   + c9e2be52a067dd9abf5efa4f5f55bb5b98cf5d3b:
     Add SHA-1 to subresource integrity format for download()
     checksums
   + 3b3e6424c6fbd51d4c4ebb6aa25f1d1f4720221c:
     Remove fallback strategy support for workers, add flag for it in
     sandbox.
   + 3457f2ae11e4543de0a5e6e8e37c3aff067891fd:
     Update to java_tools javac11 10.6 (#13245)
   + 4928295b236ec8f590a7e9d863502bc2f50a77d9:
     Allow .S files in C++ Starlark cc_common.compile.
   + 1b18d65227c127fe946d3fcde4586158bc7e5fcb:
     Automatic code cleanup.
   + b5d6c38535c7f6f1eab3fd4c8d3d2da91d0b0f8a:
     Change short output of worker type to have the same logic as the
     worker creation for sandboxing vs. multiplex.
   + e7a0a71f50b69df5d38a8a85fefd36d211e12e8d:
     More properly destroy workers on interrupt.
   + 7056711eb11b672133274eb29fc93b01dcf088d5:
     Make WorkRequestHandler do a GC after some amount of CPU time
     has been used on requests. For Bazel and Blaze, defaults to 10s
     based on benchmarking.
   + 596653d3cf76e7b208da343e1fde5fe20273a5ff:
     Allow tree artifacts to be source or header inputs to
     cc_common.compile()
   + 055c93d11ab20cc4479539b24bbdfa5cab78a342:
     Switch to path autocompletion after -- for bazel run commands.
   + 807f2a1929e23b60b237c63fadb25af81de2e3c3:
     Fix Incompatible Target Skipping for test args
   + 9a5cd854e0613f91d52075973e2454b1e009e1ef:
     Fix order of build request id and command id
   + 706f5acd02363e48076dc97e37613fd968932d03:
     Fix bazel crash when passing config_setting to
     target_compatible_with
   + 61da1d2bf10eabba4c75de959b0374f302d89d70:
     Support multiple --bazelrc on command line
   + 5593358a58b66f06c4e421bb48856de94c3fd625:
     Update ConfiguredTargetFunction.computeUnloadedToolchainContexts
     to
   + 662cf54de7a103db30e04ebae2d2b919437c4846:
     Remote: Fix an issue that a failed action could lead to
     RuntimeException caused by InterruptedException thrown when
     acquiring gRPC connections.
     https://github.com/bazelbuild/bazel/issues/13239
   + a3a1763212f29932618b9b9b2f929976ae0e3b6e:
     Pass more `--add-exports=` flags
   + d2b942879471786e82f1c96eea8722bbe7919fc1:
     Remote: Fixed a bug that remote cache is missed due to
     executable bit is changed
   + 616dc264f02907d7b7887285d22307dfe6d097b6:
     Fix Bazel Coverage with C++ to work with Remote Execution
   + 5f40d12e741aa30d506eaa15673fb2ae76d29468:
     Fix external_path_test with newer Xcode versions.
   + b416193075642017e13c774422b49cb07fb65c23:
     Allow using embedded tools in sandboxed spawn runners.
   + eb762d4e7431637e607146b1c191485795047ef9:
     Fix racy write of temporary files while staging virtual inputs
     for the sandbox.
   + f31e86768579ad7ec57ba13f4c3c1348f5c2702e:
     Update platforms_test to not rely on filegroup not using
     toolchain
   + 13031e5b3bd7c8f29b96b2fee1b380160e0e27fc:
     Update SkyframeTests to not rely on filegroup not using toolchain
   + 11651824a9d0ffb9adb9611dcd39f4c95a59d750:
     Update ConfigurableAttributesTest to not rely on filegroup not
     using …
   + 4b68532e7ea5eb80c926b7b8e2ec2be300004628:
     Make WorkerExecRoot not be a subclass of SandboxedSpawn.
   + 31db460a45767de0bcd664a6efbe9d163b85b802:
     Make WorkerExecRoot not be re-created on each createFileSystem()
     call. Preparation for holding a map of existing links, but also
     just nicer.
   + a2cc0460dc84ad2dc88019af2fe2a65ce80c61e5:
     Start the file existence check traversal from the execroot base
     instead of execroot so that external repo files at
     "<execroot>/../<path>" are correctly handled when the sibling
     repository layout is enabled.
   + b048282c7893231d3a7191b251804973917b07a4:
     Use readdir for cleanExisting in WorkerExecRoot.
   + 270f00dd01fa06cf3e813da5a406be3446de7377:
     Add native support for Apple Silicon
   + 8e56b9423e8ad2f7323fb90b19b73858def81e39:
     Explicitly state that embedding macOS OpenJDK is for x86_64
   + 09c621e4cf5b968f4c6cdf905ab142d5961f9ddc:
     Remote: Fix a race that AsyncTaskCache#Execution could be reused
     after disposed which results in
     CancellationException("disposed") propagated to downstream.
   + 0299cd7e17203a4ce0ea947b62a7c55f1afb8225:
     Remove wrapped_clang params files after use
   + 47edc57806056f3c8764241ed41b8acc72bd2ebf:
     Silence swiftmodule timestamp warnings
   + f6e1074b09ebefba185c0531e9cea26b9596c8a9:
     Remote: Use shutdownNow() instead of shutdown() in
     ChannelConnection#close() as a workaround to a gRPC bug.
   + 71be4ea9e3d20bf90129e34a6a2899fe8401be36:
     And mnemonic and label to remote metadata
   + 6d28486e8eca70f76d13922944cb567b8aa09380:
     Change `set -x` in coverage to be set by var
   + 9b9de653355864e9700889ee36a3a49a450a2607:
     Bump minimal JDK install base maximum size from 290 to 295 MB.
   + 9e7e592ca51eba1a3f120320c41c845312894d74:
     Remote: Check the return value of ActionOwner.getLabel() since
     it could be `null`.
   + 14abe4fd7c3967686a3536939fdc3882e691bca2:
     Allow `DiffAwareness` to share precomputed information about the
     workspace and propagate it to the `WorkspaceStatusAction`.
   + 082d98772690946ed29c157e60640c97a6e1195b:
     Implement available() method for Windows subprocesses.
   + c2bdd034014f66ce14529cc353cda18a32320f6c:
     Move --repo_env to common options
   + e09f2743738044095b9d784ea62df16b7f5750e6:
     Revert "Documentation for #13110"
   + a165baa250652fdc865ae0df39160be1f7f74c47:
     Revert "Clean up RuleContext to use a Table instead of a Map of
     Maps."
   + 51fb9e13a864f4f704ae378ea632433bae7ddc31:
     Revert "Support execution constraints per exec group"
   + cb6e5c24b82e0e20a243145fb6ea32b09e3d1de3:
     Revert "Allow exec groups to inherit from the rule or other exec
     groups."
```

Important changes:

  - Multiplex persistent workers can now use the JSON protocol.

This release contains contributions from many people at Google, as well as Alex Eagle, Austin Schuh, Benjamin Peterson, Cristian Hancila, Daniel Wagner-Hall, Denys Kurylenko, Ed Schouten, Finn Ball, George Gensure, Keith Smiley, Lauri Peltonen, Philipp Schrader, Ryan Beasley, Thi Doan, Timothy Klim, Ulf Adams, Vaidas Pilkauskas, wisechengyi, Xavier Bonaventura, Yannic Bonenberger, Yuval Kaplan, Yuval.

## Release 4.0.0 (2021-01-21)

```
Baseline: 37a429ad12b4c9e6a62dbae4881a1ff03b81ab40

Cherry picks:

   + a689d673abadf80f1efaf8ddaeee92d56fc2847b:
     Use getRunfilesPath for run_under executable path generation.
     getRootRelativePath doesn't return a valid runfiles path for
     external source files anymore after the recent external source
     root change. Also, it won't work for external labels either once
     the --nolegacy_external_runfiles becomes default. This fixes
     issue #12545.
   + d90ec67fdab9710f649a3c1d374fb6b938b9271a:
     Fix NPE when coveragerunner is not set on the toolchain.
   + 8555789dd239a5ac229c1d9cee80b2a9f30b3bf7:
     Fix the classic query package-loading cutoff optimization with
     external workspaces.
   + d113d7454127bba78aa618dac81e5d164920b662:
     Update turbine
   + 1489f0f4cae3e9247a70e4003ab76bef45c5b986:
     Support Scala3 .tasty files
   + 0d2d95cd7e34b4061c8e5fdfd21ba0ab8818c685:
     Update to java_tools javac11 release 10.5 (#12647)
   + a9419f38d5f29af31a6c8ebda09a6e0303a6ba54:
     Fix common prefix for instrumentation filter
   + 84fadcf81f81b2d7343ca4151a5639be7f2263ee:
     Fix builds for filegroup targets with incompatible dependencies
   + e43825d0bef359f645e1cabf2164fd2db6ee4a35:
     Revert "Remove
     --incompatible_blacklisted_protos_requires_proto_info"
   + 082d58de852ebaa640bcf13cf419cbb94eec2b26:
     Transform roots along with paths during output deletion.
   + e8835c1c221d76a2d5532d18083eaa04401619b3:
     AttributeContainer.Large now handles more than 127 attributes.
   + e1e87349335ac59f9b3df47cee8b999faeaa6d11:
     Add an env attribute to all test and binary rule classes
   + a87d7ed2411d5382bac58a20b79e09c464ad13b9:
     Take no action to prefetch empty artifacts.
   + 3e969ff24a6a0e03139b9f288c88451a7dfa97cd:
     Fix a couple of bugs with Incompatible Target Skipping
   + e6670825b1e183f81f5c864aafd425d512fa9ff5:
     Pass --host_action_env to host options hostActionEnvironment
     attribute
   + 07400c0392e7be163f8a3396fa5cf89ce6705412:
     Add --{no,}autodetect_server_javabase.
   + c83366064621d5a265eba14d93a03deff58fe6d8:
     Only treat "env" and "env_inherit" attrs specially for native
     rules
   + 6a60b30cd0f22d0ab84b2ddd658d5ccb899a8a76:
     Fix coverage support when using default_java_toolchain. (#12801)
   + 4158a6f512e52516437e00f8d9609a91be7fc195:
     Revert JacocoCoverage target to remote_java_tools_java_import
     and add a new target for remore_java_tools_filegroup. (#12813)
   + f6d30cf5ef9a8a39fea7072317f89a872387b790:
     Add windows_msvc back to conditions in bazel_tools.
```

New features:

  - Starlark-defined flags can now be shorthanded using --flag_alias.

Important changes:

  - Add --starlark:file option. This adds a capability to the
    (cquery)[https://docs.bazel.build/versions/master/cquery.html]
    feature in `--output=starlark` mode so that the expression to
    format output may
    be specified in a file.
  - Error messages emitted when an action fails are reworked to be
    more informative about the failing action. Some tooling may have
    to be updated as a result.
  - Querying with output=location now allows the relative_locations
    flag to properly display relative locations instead of the full
    path. Fixes https://github.com/bazelbuild/bazel/issues/3497.
  - --flag_alias can now be used without
    --experimental_enable_flag_alias
  - Remove no-op `--deep_execroot` flag
  - The BEP uses `AbortReason.OUT_OF_MEMORY` for abort events when
    the build tool is crashing due to OOM.
  - Added flag `incompatible_display_source_file_location` for `blaze
    query location=output` to print the location of line 1 of the
    actual source files instead of the source file targets. Provides
    a solution to https://github.com/bazelbuild/bazel/issues/8900.
  - The Starlark json module is now available.
    Use json.encode(x) to encode a Starlark value as JSON.
    struct.to_json(x) is deprecated and will be disabled by
    the --incompatible_struct_has_no_methods flag.
  - The flag `--incompatible_objc_compile_info_migration` is enabled
    by default.  See #10854.
  - The flag `--incompatible_objc_provider_remove_compile_info` is
    enabled by default.  See #11359.
  - Add `relative_ast_path` feature for darwin builds to relativize
    swiftmodule paths for debugging
  - Use proto.encode_text(x) to encode a Starlark value as textproto.
    struct.to_proto() is deprecated and will be disabled by
    the --incompatible_struct_has_no_methods flag.
    Both functions now reject list/dict fields that contain list/dict
    elements.
  - Add --starlark:file option. This adds a capability to the
    (cquery)[https://docs.bazel.build/versions/master/cquery.html]
    feature in `--output=starlark` mode so that the expression to
    format output may be specified in a file.
    See [Configured Query Starlark
    Output](//docs.google.com/document/d/1kL6Tdmp6uLBa9lq_DbUSjIC87glO
    zKIyPoBeF95Rs4c/edit)
  - Flipped --incompatble_proto_output_v2 for aquery.
  - The --incompatible_load_java_rules_from_bzl flag is now a no-op.
  - The --incompatible_load_proto_rules_from_bzl flag is now a no-op.
  - Flipped --incompatible_force_strict_header_check_from_starlark
  - --incompatible_string_replace_count is flipped and removed
    (#11244)
  - Bazel skips incompatible targets based on target platform
    and `target_compatible_with` contents. See
    https://docs.bazel.build/versions/master/platforms.html for more
    details.
  - Bazel returns exit code 36 (rather than 1) if it fails to start a
    subprocess in a local sandbox due to environmental issues, for
    example, if the argument list is too long.
  - //tools/build_defs/pkg:pkg_rpm is no longer built in to Bazel.
    See https://github.com/bazelbuild/bazel/issues/11218 for
    instructions
    on how to migrate to the replacement.
  - Javac now supports multiplex workers.
  - The `--default_ios_provisioning_profile` flag has been removed
    (it was a no-op).
  - Add support for using AndroidX dependencies in
    data-binding-enabled targets.
  - Fix data-binding generation for android_local_test.
  - Enable debug_prefix_map_pwd_is_dot feature by default on macOS,
    this passes `-fdebug-prefix-map=$PWD=.` for every compile to
    remove absolute paths from debug info.
  - --incompatible_run_shell_command_string is enabled by default
    (#5903)
  - py_binary now tolerates package paths that contain hyphens ('-').
    Note that such paths might not be importable from within Python
    code.
  - C++ Starlark API requires linker_inputs wrapping library_to_link.
    #10860
  - Toolchain rule is extended with target_settings attribute.
  - --incompatible_restrict_string_escapes=true is now the default.
    Unnecessary backslashes such as "\." in string literals are now
    an error, instead of being silently treated as "\\.".
    To fix the error while preserving behavior, double the backlash.
    However, the error is often a sign that the original code was
    wrong.
  - Propagate instrumented files for transitive sources of
    `android_library` and `android_binary`
  - --local_resources and --incompatible_remove_local_resources have
    been removed. If you've been setting --local resources or
    --incompatible_remove_local_resources=false, you must migrate to
    using --local_ram_resources and --local_cpu_resources instead.
  - Update rules_cc to commit b1c40e1de81913a3c40e5948f78719c28152486d
  - --incompatible_avoid_conflict_dlls=true is now the default.
  - Dynamic execution now uses the new scheduler by default.
  - Dynamic execution now uses the new scheduler by default.
  - The new dynamic scheduler is now the default.

This release contains contributions from many people at Google, as well as Adam Liddell, Akira Baruah, Alexander Grund, Alex Eagle, Andrew Z Allen, Austin Schuh, Benjamin Peterson, Benson Muite, Brentley Jones, Cristian Hancila, Dan Halperin, Daniel Wagner-Hall, Dmitry Ivankov, Dmitry Ivankov, erenon, Eric Cousineau, Greg Estren, Gregor Jasny, Grzegorz Lukasik, Grzegorz Lukasik, hollste, Joe Lencioni, johnjbarton, Jonathan Perry, Jonathon Belotti, Keith Smiley, Kevin Gessner, Matt Davis, Matt Mackay, Menny Even Danan, Neeraj Gupta, Philipp Schrader, Ricardo Delfin, Ryan Beasley, Samuel Giddins, Simon Bjorklen, Simon Stewart, Stiopa Koltsov, Thi Doan, ThomasCJY, Timothy Klim, Tom de Goede, vectoralpha, V Vn Ngha, William A Rowe Jr, Xavier Bonaventura, Yannic Bonenberger, Yannic.

## Release 3.7.2 (2020-12-17)

```
Baseline: a991db7c2f66a354666388d888dcef9b0d0f70c0

Cherry picks:

   + 0d14ec84a06c4da628a7f6d9d1c5f9314392ab15:
     Release 3.7.0 (2020-10-20)
   + d563446a77b906807cea86f5c2abafa5900d901a:
     Add `-XDcompilePolicy=simple` to default javacopts
   + 6336264e4b0d8cc422ec73e1b923bf8014ace778:
     Update rules_cc reference to head of rules_cc as of 2020-11-11.
   + b3f934680554515aa312b5dd4453df5cd38f0aea:
     Bump rules_cc to support llvm 11.0.0 clang-cl compiler on Windows
   + e055b433efdccb28b9c21082e72d8e79d9b34e0f:
     Remove accidentally re-added
     tools/jdk/java_toolchain_default.bzl.
   + 02838a1b2aa2f6d03980536ab2ac6840c3c98e84:
     Avoid the spawn cache if executing dynamically.
   + d0efd7b9e5109ff5ac6d13c91f58c3fc4dc3afd8:
     Release 3.7.1 (2020-11-24)
   + a689d673abadf80f1efaf8ddaeee92d56fc2847b:
     Use getRunfilesPath for run_under executable path generation.
     getRootRelativePath doesn't return a valid runfiles path for
     external source files anymore after the recent external source
     root change. Also, it won't work for external labels either once
     the --nolegacy_external_runfiles becomes default. This fixes
     issue #12545.
```

Important changes:

  - Update rules_cc to commit b1c40e1de81913a3c40e5948f78719c28152486d

This release contains contributions from many people at Google, as well as William A Rowe Jr.

## Release 3.7.1 (2020-11-24)

```
Baseline: a991db7c2f66a354666388d888dcef9b0d0f70c0

Cherry picks:

   + 0d14ec84a06c4da628a7f6d9d1c5f9314392ab15:
     Release 3.7.0 (2020-10-20)
   + d563446a77b906807cea86f5c2abafa5900d901a:
     Add `-XDcompilePolicy=simple` to default javacopts
   + 6336264e4b0d8cc422ec73e1b923bf8014ace778:
     Update rules_cc reference to head of rules_cc as of 2020-11-11.
   + b3f934680554515aa312b5dd4453df5cd38f0aea:
     Bump rules_cc to support llvm 11.0.0 clang-cl compiler on Windows
   + e055b433efdccb28b9c21082e72d8e79d9b34e0f:
     Remove accidentally re-added
     tools/jdk/java_toolchain_default.bzl.
   + 02838a1b2aa2f6d03980536ab2ac6840c3c98e84:
     Avoid the spawn cache if executing dynamically.
```

Important changes:

  - Update rules_cc to commit b1c40e1de81913a3c40e5948f78719c28152486d

This release contains contributions from many people at Google, as well as William A Rowe Jr.

## Release 3.7.0 (2020-10-20)

```
Baseline: a991db7c2f66a354666388d888dcef9b0d0f70c0
```

Incompatible changes:

  - The syntax //foo/BUILD can no longer be used on the command line
    to refer to the //foo:BUILD target. Use //foo:BUILD (preferred)
    or foo/BUILD instead. This does not affect BUILD/bzl files, where
    that syntax already didn't work.
  - This removes `--objc_header_scanner_tool`. The flag was primarily
    used internally, and to our knowledge, a compatible tool was
    never released. Therefore this flag is believed to be unused.

New features:

  - select() directly supports constraint_value (no need for an
    intermediate config_setting).

Important changes:

  - Non-android targets can again be built when
    android_sdk_repository is present but invalid.
  - Add a build variable for -install_name / -soname.
  - Add a build variable for -install_name / -soname.
  - Include "resources" attr in dependency attributes for java_*
    coverage configuration.
  - --trim_test_configuration should work for almost all cases when a
    non-test target depends on a test.
  - Javac now supports multiplex workers.
  - Javac now supports multiplex workers.
  - Blaze now allows symbolic links that point to their own ancestor
    unless they are traversed recursively by e.g. a //... recursive
    target pattern or a recursive glob.
  - Blaze now allows symbolic links that point to their own ancestor
    unless they are traversed recursively by e.g. a //... recursive
    target pattern or a recursive glob.
  - Blaze now allows symbolic links that point to their own ancestor
    unless they are traversed recursively by e.g. a //... recursive
    target pattern or a recursive glob.
  - Generated Go protobufs no longer depend on //net/proto2/go:proto

This release contains contributions from many people at Google, as well as Benjamin Peterson, Cristian Hancila, Ed Schouten, Fredrik Medley, Greg Estren, jgehw, Jin, Kalle Johansson, Keith Smiley, Kseniia Vasilchuk, Michael Eisel, Michael Hackner, Michael Krasnyk, Mostyn Bramley-Moore, Ruixin Bao, Samuel Giddins, Simon Stewart, Torgil Svensson, Ulf Adams, Vasilios Pantazopoulos, Wenyu Zhang, Yannic Bonenberger, yoav-steinberg.

## Release 3.6.0 (2020-10-06)

```
Baseline: aa0d97c0bfc4c09ec6f45303aa80052ba28afbd9

Cherry picks:

   + 32c88da98f301333dc447b75564459165368d418:
     Patch RuleContext for android_binary.deps to restore legacy
     behavior.
   + db9fc88fed387f09067a9250a731f8bf9ad74b05:
     android_test also needs the legacy behavior in
     RuleContext.getPrerequisites.
   + 144d5149a0c50e464dd1be0769fed2ce33ab26a4:
     Update android_sdk_repository to create a valid, but useless,
     repository
   + bb11f9235da52eb3b3e462ce0286f1a89188cb89:
     Patch upb to fix build error with gcc 10
   + 9f06be482aea3fcadeaf8fca6e48b32f224eba2e:
     Patch upb to fix build error with gcc 10 (third_party)
   + b67b75e3a62f5433d812993f3702f431b6967e86:
     Fix issue where libtool_check_unique isn't found for sandbox
     builds
```

Incompatible changes:

  - `--experimental_ui_limit_console_output` is removed. Users of
    `--experimental_ui_limit_console_output=1` for silencing terminal
    output should use `--ui_event_filters=` instead.
  - --proto:instantiation_stack must be enabled in addition to
    --record_rule_instantiation_callstack to see call stack in proto
    output from blaze query.

New features:

  - cc_common.compile support for include_prefix/strip_include_prefix
  - Multiplexed persistent workers: Use
    --experimental_worker_max_multiplex_instances to configure the
    number of WorkRequests that are sent concurrently to one worker
    process. The --worker_max_instances flag will no longer be used
    to determine max instances for multiplex workers, since the two
    have different resource requirements. Multiplex workers will by
    default have a max instances of 8.

Important changes:

  - The prelude file (//tools/build_rules:prelude_bazel) is now
    processed as a Starlark module, rather than being sourced into
    the BUILD file textually. This may cause slight breakages
    depending on the content of the prelude file. (Use of the prelude
    file is discouraged as it will be removed in the long term.)
  - Removed --experimental_ignore_deprecated_instrumentation_spec and
    cleaned up the old deprecated behavior.
  - Added CODEBASE.md, a description of the Bazel codebase.
  - Removed the flag --experimental_transparent_compression.
  - Removed the flag --experimental_action_args.
  - Stop needlessly parsing WORKSPACE files from external
    repositories.
  - Dot ('.') is now allowed in workspace names. See
    https://github.com/bazelbuild/bazel/issues/11837.
  - This change can cause memory and performance regressions for some
    builds with C++ dependencies, due to extra actions being executed.
    RELNOTES: None
  - Building Android apps for legacy multi-dex (pre-L) now require a
    main-dex list if the application does not fit into a single DEX
    file.
  - Puts the experimental_worker_multiplex flag to use.
  - In Starlark, the Args object supports a new parameter file format
    'flag_per_line', compatible with the Abseil flags library.
  - The flag --incompatible_no_support_tools_in_action_inputs is
    removed.
  - Support for NDK 21 added
  - Bazel will now skip printing action stdout/stderr contents if
    they exceed --experimental_ui_max_stdouterr_memory_bytes.
  - The Starlark interpreter now correctly emits an error
     if the operand of the first loop in a list comprehension
     refers to a variable bound by a later loop, such as y in
     this example:
       [e1 for x in f(y) in e2 for y in e3] # error: undefined y
                      ^
     This may cause latent dynamic errors to become static errors.
  - Added support for a 'supports-graceful-termination' execution
    requirement and tag, which causes Bazel to send a SIGTERM to any
    tagged
    actions before sending a delayed SIGKILL. This is to give
    actions, and more
    specifically tests, a chance to clean up after themselves.
  - Non-android targets can again be built when
    android_sdk_repository is present but invalid.

This release contains contributions from many people at Google, as well as Benjamin Peterson, Daniel Wagner-Hall, Dave MacLachlan, David Ostrovsky, Emil Kattainen, George Gensure, Greg Estren, Keith Smiley, mai12, Mai Hussien, Michael Eisel, Per Halvor Tryggeseth, Ruixin Bao, Samuel Giddins, Steeve Morin, Thi Doan, Tom de Goede, Ulf Adams, Zhongpeng Lin.

## Release 3.5.0 (2020-09-02)

```
Baseline: 889bc0b523b47eeb38a72bf9bb6858ee525a7c7e

Cherry picks:

   + a7a0d48fbeb059ee60e77580e5d05baeefdd5699:
     Make no-op starlark transition not affect the output directory.
   + b37c51c7085f0aefe04034dd451acb847605ddb5:
     Add include_prefix and strip_include_prefix to cc_common.compile
   + f6ad35fcde93f92c591778ed7db38d167f5bbc03:
     Delete --experimental_transparent_compression
   + 39bc97eab295bddb35b38bfc4a2ff3d2b15d034e:
     Remove --experimental_action_args
   + b9706675a7abf6ceebb250f0b3dfa4087a0c35f6:
     Stop needlessly parsing WORKSPACE files from external
     repositories.
   + e574d558da17cfd0f818e7a937a07926aa270069:
     Allow hyphen char in workspace name
   + 9993785fa0c4fa4172aa31d306f3abea76833abf:
     Allow dot ('.') in workspace names.
```

New features:

  - cc_common.compile support for include_prefix/strip_include_prefix

Important changes:

  - Removed the flag --experimental_transparent_compression.
  - Removed the flag --experimental_action_args.
  - Stop needlessly parsing WORKSPACE files from external
    repositories.
  - Dot ('.') is now allowed in workspace names. See
    https://github.com/bazelbuild/bazel/issues/11837.

This release contains contributions from many people at Google, as well as David Ostrovsky.

## Release 3.5.0 (2020-09-02)

```
Baseline: 889bc0b523b47eeb38a72bf9bb6858ee525a7c7e

Cherry picks:

   + d6b9469efebd200a39d7fd43876a18822fcdbe7b:
     Make no-op starlark transition not affect the output directory.
   + b37c51c7085f0aefe04034dd451acb847605ddb5:
     Add include_prefix and strip_include_prefix to cc_common.compile
   + 0ebb1d5a5388109e3f026a355c77fdf0121f3a43:
     Delete --experimental_transparent_compression
   + 312e121c70aebfaa91b0a3106fa964e0bc12d1df:
     Remove --experimental_action_args
   + 7e6e855bb82734f582e03c2c7fad3148c139d0e0:
     Stop needlessly parsing WORKSPACE files from external
     repositories.
   + d4049f6f85efb8f48d1f6b72764115af5b184831:
     Allow hyphen char in workspace name
   + 0a35be1843a2e4d49d5e5c3893cd6673705b7fb1:
     Allow dot ('.') in workspace names.
```

Incompatible changes:

  - The --experimental_process_wrapper_wait_fix flag (used
    purely to roll out a risky bug fix) has been removed.
  - Removed the --experimental_ui_deduplicate flag.
  - Bazel now correctly prefers Xcode versions in `/Applications`
    over any other paths, which resolves an issue with accidentally
    picking up an Xcode version from a Time Machine backup or network
    disk. In the improbable case that you relied on the old behavior
    and Bazel now picks up Xcode from the wrong location, you can fix
    it by moving that Xcode version to /Applications.

New features:

  - cquery now follows aspects with --include_aspects.
  - cc_common.compile support for include_prefix/strip_include_prefix

Important changes:

  - Add support to bazel/crosstool for building arm64 on macos aka
    darwin
  - Add opt in 'oso_prefix_is_pwd' feature for Apple builds
  - Add InstrumentedFilesInfo provider to Starlark globals.
  - Fixed resource shrinking when <overlayable/> tags are used.
  - Remove old incompatible flag
    --incompatible_symlinked_sandbox_expands_tree_artifacts_in_runfile
    s_tree.
  - Update coverage configuration for Python, filegroup, and shell
    script rules to distinguish between source and dependency
    attributes.
  - Add support to bazel/crosstool for building arm64e on macos aka
    darwin
  - Make filegroup always forward InstrumentedFilesProvider and not
    collect any sources directly.
  - Support signing key rotation in android_binary
  - Remove legacy handling of --extra_checks
  - Support signing key rotation in android_binary
    GO...
  - `--apple_bitcode` now takes an optional platform and only applies
    the Bitcode mode to that platform if present. The option may be
    provided multiple times.
  - Support signing key rotation in android_binary
  - NS_BLOCK_ASSERTIONS is now passed for all Apple architectures.
  - Major changes to reporting of Starlark errors and the call stack.
    (Please be alert to possible regressions, such as errors that
    lack relevant location information.)
  - Removed the flag --experimental_transparent_compression.
  - Removed the flag --experimental_action_args.
  - Stop needlessly parsing WORKSPACE files from external
    repositories.
  - Dot ('.') is now allowed in workspace names. See
    https://github.com/bazelbuild/bazel/issues/11837.

This release contains contributions from many people at Google, as well as Adam Gross, Andrew Suffield, Benjamin Peterson, bnczk, David Ostrovsky, Ed Schouten, Greg Estren, Grzegorz Lukasik, Holger Freyther, Kalle Johansson, Keith Smiley, Kerrick Staley, Kyle Teske, Mostyn Bramley-Moore, Ryan Beasley, Ryan Pavlik, Siggi Simonarson, Stiopa Koltsov, Ulf Adams, Xiaoyi Shi, Yannic Bonenberger, Yesudeep Mangalapilly.

## Release 3.4.1 (2020-07-14)

```
Baseline: 7404d17ac76da876ae0b432d1fccf222a9e991fe

Cherry picks:

   + f31f2d787116120b2b16e9aa9a64fab171c0d954:
     fixup! Gracefully handle the lack of subreaper support in Linux.
   + 3a4f221e3c57495c1ed0d1ec8128f92323b13079:
     Revert "Replace the remaining dependencies for Bazel Debian
     build (third_party)"
   + c55ec0f2cb3f5b44e5025bf9d3c5dc91d94db287:
     Revert "Upgrade gRPC to 1.26.0"
```

This release contains contributions from many people at Google, as well as Ryan Beasley.

## Release 3.4.0 (2020-07-13)

```
Baseline: 7404d17ac76da876ae0b432d1fccf222a9e991fe

Cherry picks:

   + a4334be50a206bf8d676a0196af11056c48ac35b:
     fixup! Gracefully handle the lack of subreaper support in Linux.
```

Incompatible changes:

  - This removes the short-lived --process_wrapper_extra_flags
    flag, which was introduced primarily to roll out a bug fix.
    Unfortunately,
    this made us inadvertently expose all of the process-wrapper's
    command line
    interface to the public, which should not have happened.  Given
    the corner
    case of the utility of this flag, the lack of documentation for
    it, and the
    fact that it only appeared in a single release, we are treating
    this as a
    bug instead of a backwards compatibility breakage.

New features:

  - bazel info: Allow to specify multiple keys.
  - Support code coverage with GCC 9.

Important changes:

  - Allow InstrumentedFilesInfo fields to be read from Starlark.
  - The --starlark_cpu_profile=<file> flag writes a profile in
    pprof format containing a statistical summary of CPU usage
    by all Starlark execution during the bazel command. Use it
    to identify slow Starlark functions in loading and analysis.
  - The --debug_depset_flag has been removed as it is in effect
    always on at no cost.
  - Rule authors should use the
    incompatible_use_toolchain_transition rule attribute to migrate
    to using
    the toolchain transition. jcater to udpate notes further.
  - `apple_binary` rules now accept the `stamp` attribute with the
    same
    semantics that it has in `cc_binary` rules.
  - --incompatible_objc_provider_remove_compile_info turns off
    the compile info/mege_zip Starlark APIs in ObjcProvider.  See
    #11359.
  - The --debug_depset_flag has been removed as it is in effect
    always on at no cost.
  - Fix behavior of ctx.actions.write so content is written without
    an incorrect encoding to UTF-8.
    See https://github.com/bazelbuild/bazel/issues/10174 for details.
  - Collect more performance metrics for worker execution.
  - Add flag --incompatible_force_strict_header_check_from_starlark
  - Configure coverage and runfiles for sh_library.
  - Adds --incompatible_blacklisted_protos_requires_proto_info to
    indicate whether proto_lang_toolchain.blacklisted_protos requires
    ProtoInfo.

This release contains contributions from many people at Google, as well as Andrzej Guszak, Benjamin Peterson, Benjamin Romano, Carlos Eduardo Seo, Claudio Bley, dannysullivan, David Ostrovsky, George Gensure, Graham Jenson, Grzegorz Lukasik, Gunnar Wagenknecht, Henk van der Laan, Jin, John Millikin, Marin Baron, Nikhil Marathe, Robin Nabel, Ryan Beasley, Samuel Giddins, Sergey Balabanov, utsav-dbx, Vo Van Nghia, Yannic Bonenberger.

## Release 3.3.1 (2020-06-30)

```
Baseline: c063b5caf776dee665497b64c5c17d4ed7e6750a

Cherry picks:

   + cb798a475eb54087e1e83f8aa1dc1c54550877b5:
     Restore missing Building with Platforms docs.
   + 9be97678b02bbd45d164c8458c8fd4f7791cb7aa:
     Release 3.3.0 (2020-06-17)
   + 3b0439e37247a480e08337a6314d06231bdbafd3:
     Fix incorrect assumption of desugar persistent worker conditional
```

This release contains contributions from many people at Google, as well as .

## Release 3.3.0 (2020-06-17)

```
Baseline: c063b5caf776dee665497b64c5c17d4ed7e6750a

Cherry picks:

   + 23bd69d7499de097b15e6025cc0796bdbc9886b8:
     Restore missing Building with Platforms docs.
```

Incompatible changes:

  - The startup option --fatal_event_bus_exceptions is now a no-op
    and will be removed soon.

New features:

  - Bazel offers basic completion for the fish shell.

Important changes:

  - Add configuration_field for --custom_malloc to cpp config fragment
  - Flip --incompatible_objc_compile_info_migration to true.  See
    #10854.
  - It is now possible to use different action mnemonics while still
    sharing the same pool of persistent workers. It requires setting
    a new property
    on the execution requirements (`worker-key-mnemonic`). The value
    overrides
    the action's mnemonic when it comes to reusing worker processes.
  - linkshared=1 in cc_binary no longer requires '.so' or '.dll' in
    the target name
  - Revert --incompatible_objc_compile_info_migration to false.  See
    #10854.
  - Invoke clang with the correct -target flag when building for
    watchOS.
  - NA
  - Add experiment flag to forward InstrumentedFilesInfo from
    non-tool deps by default.

This release contains contributions from many people at Google, as well as Abhishek Kumar, Adam Azarchs, Akira Baruah, Daniel Wagner-Hall, Derek Argueta, glukasiknuro, Greg Estren, Greg, Jason Furmanek, Jiri Dank, Keith Smiley, Kseniia Vasilchuk, Laurent Le Brun, Matt Mackay, Michael Klemm, Nikolay Shelukhin, Patrick Balestra, Rui Chen, Siggi Simonarson, sventiffe, Tobias Werth, Tom de Goede, Vladimir Chebotarev, Yannic Bonenberger.

## Release 3.2.0 (2020-05-27)

```
Baseline: 1d93d26d9900328dcba0026bf21cb45cc37a4596
```

Important changes:

  - Renamed --experimental_slim_json_profile to --slim_profile.
  - Expose ctx.attr.write Args content for analysistest when possible
  - Added aquery_differ_v2 that works with the new aquery proto
    output format.
  - Add new flag, 'experimental_no_product_name_out_symlink', to omit
    creating '<product>-out' symlink if user specifies
    '--symlink_prefix' option.
  - --ram_utilization_factor is removed (as is
    --incompatible_remove_ram_utilization_factor). Please use
    --local_ram_resources.
  - Improve include scanner support for cl.exe and clang-cl command
    lines
  - ctx.split_attr now includes attributes with Starlark split
    transitions.
  - Added --incompatible_string_replace_count, to make
    string.replace() behave as in Python.
  - Bazel can now recursively delete non-executable but readable
    directories.
  - Restore case-sensitivity to -I and /I include scanning detection
    to avoid conflicts.

This release contains contributions from many people at Google, as well as Alessandro Patti, Antoine Eiche, Beebs, Brian Silverman, George Gensure, Gerhard Pretorius, Gibson Fahnestock, Greg, Gregor Jasny, Gustav Westling, hannometer, Jin, Jonathan Gerrish, Josh Smith, Justin Y Wei, Laurent Le Brun, Links, liubang, Lszl Csomor, Matt Mackay, Moritz Krger, Ryan Beasley, Siddhartha Bagaria, Yannic Bonenberger, Yannic, Zhongpeng Lin.

## Release 3.1.0 (2020-04-21)

```
Baseline: 17ebbf15bea3733c0c21e0376fb5906e391edb49

Cherry picks:

   + 71fb56b4bb669a419f473598c8722e125dbb5c9e:
     Suppress last-ditch download exceptions w/cleanup
   + fd60614c38da0db22431d91a793423904dff801f:
     In repo rules, don't warn about generator_* attributes being
     non-canonical
   + 2a372792f5cc09bd0e8389d5fc4bbfdd2f5d6e37:
     Refactor configureFeatures and prevent NPE
   + 777a6ee6ed95cae4ddb949d52b63ee8a66024f03:
     Automated rollback of commit
     0bbe38176e15d891a4e4cab2d8425e292de6cc5f.
   + 2ee53c9267eb6de8eae109950ca8f3953bf1ae66:
     Guard parseActionResultMetadata with bulk wrapper
```

Incompatible changes:

  - The deprecated startup options
    --experimental_oom_more_eagerly(_threshold) are removed.

Important changes:

  - Remove flag
    --incompatible_load_proto_toolchain_for_javalite_from_com_google_p
    rotobuf which has been flipped in Bazel 3.0.
  - Allow assembly file sources in cc_common.compile.
  - Set default .netrc file on Windows to %USERPROFILE%
  - A maximum 150 attributes per RuleClass is enforced
  - Increase max targets per rule class limit to 200
  - ctx.split_attr now includes attributes with Starlark split
    transitions.
  - The --max_computation_steps flag bounds the computation done by a
    BUILD file.
  - Native patch can handle file permission properly
  - Aspects may now propagate through dependencies on rule outputs by
    being defined with `apply_to_generating_rules = True`.
  - 'query --output=build' now shows where rule classes (not just
    rules) are created.
  - The flag `incompatible_bzl_disallow_load_after_statement` is
    removed.
  - ctx.split_attr now includes attributes with Starlark split
    transitions.
  - The flag `incompatible_no_output_attr_default` is removed.
  - Fix wall-time of the SpawnResult in WorkerSpawnRunner
  - Add stamp parameter for cc_common.link to enable including build
    info
  - The flag `--incompatible_restrict_named_params` is removed.
  - The flag `--incompatible_depset_union` is removed.
  - Bazel uses fewer compiler flags by default when building
    Objective-C. In
    particular, Bazel no longer sets `-O0`, `-DDEBUG=1`,
    `-fstack-protector`, `-fstack-protector-all`, or `-g` in dbg
    mode, and
    Bazel no longer sets `-Os`, `-DNDEBUG=1`, `-Wno-unused-variable`,
    `-Winit-self`, or `-Wno-extra` in opt mode. If you want to apply
    these
    flags to your project, you can reenable them in your CROSSTOOL.
  - A maximum attribute name length is 128 is enforced

This release contains contributions from many people at Google, as well as Alessandro Patti, Benjamin Peterson, Benjamin Romano, Bor Kae Hwang, Chris Heisterkamp, Cristian Hancila, Dmitri G, Douglas Parker, George Gensure, Gregor Jasny, John Millikin, Keith Smiley, Leo, Mike Fourie, Patrick Balestra, Robbert Van Ginkel, Ryota, Samuel Giddins, Ulf Adams, Ulf Adams, Vertexwahn, Xavier Bonaventura, Yannic Bonenberger.

## Release 3.0.0 (2020-04-06)

```
Baseline: 3c7cc747ac653dca8b88a9e43726a794e2c27a9c

Cherry picks:

   + 19e214b44df9c82a8a3bd3381344f7145813c572:
     Use prefix encoding for paths.
   + 63b01f7b1cd6603a08bf2a8ae813388c201e3448:
     Avoid file operations in the sandbox creation critical path.
   + 80a2d7cc5f8a22816934dcd2ca9bdf87050f3d9f:
     Implementation (but not plumbing) of the gRPC remote downloader
   + 586eabf419972c74fdd5fef328cfe9a259e035ed:
     Implement RemoteDownloader w/ `--experimental_remote_downloader`
```

Incompatible changes:

  - Flip --incompatible_remove_enabled_toolchain_types, so that rules
    can no longer access enabled toolchain types from the platform
    fragment.
  - The --incompatible_use_jdk11_as_host_javabase flag has been
    removed (it was flipped in Bazel 0.25.0).
  - Using JDK 9 or 10 as a `--host_javabase` is no longer officially
    supported. As always, you can use the
    `@bazel_tools//tools/jdk:toolchain_vanilla` Java toolchain to use
    older or newer JDKs than what Bazel currently supports.
  - --fatal_event_bus_exceptions is deprecated and should not be
    used. Any crashes should be reported so that they can be fixed.
  - The old-style binary profile format is no longer suppported, use
    the new JSON trace profile instead.

Important changes:

  - Improve the performance of creating a sandboxed execution root
    for workers when the number of inputs is large (>1000).
  - Treat .cu and .cl files as C++ source. CUDA or OpenCL are not
    natively supported and will require custom flags to compile with
    e.g. clang.
  - Add actions' primary output details in JSON profile and
    analysis_v2.proto.
  - Add --cds_archive option for embedding CDS archive into deploy
    JAR.
  - Add new global attribute: applicable_licenses
    - Package level default with default_applicable_licenses
    - guarded by --incompatible_applicable_licenses (default true for
    Blaze, false for Bazel)
    - In support of
    https://docs.google.com/document/d/1uwBuhAoBNrw8tmFs-NxlssI6VRolid
    GYdYqagLqHWt8/edit#
  - Non-test Java rules no longer require the TestConfiguration and
    thus --trim_test_configuration is again usable for Java builds
  - The flag `--incompatible_always_check_depset_elements` is enabled
    by default.
  - --incompatible_objc_compile_info_migration determines
    whether native rules can assume compile info has been migrated to
    CcInfo. See https://github.com/bazelbuild/bazel/issues/10854.
  - --incompatible_remove_local_resources is true by default. Please
    use --local_ram_resources and --local_cpu_resources instead of
    --local_resources.

This release contains contributions from many people at Google, as well as Alessandro Patti, Benjamin Peterson, Christy Norman, Dave hughes, David Haxton, David Neil, garyschulte, George Chiramel, George Gensure, Gibson Fahnestock, Greg Estren, Greg, Jason Hoch, Jin, John Millikin, Jonathan Springer, Keith Smiley, Laurent Le Brun, Ulf Adams, Yannic Bonenberger, Yannic, Yihong Wang, Yuchen Dai.

## Release 2.2.0 (2020-03-03)

```
Baseline: 78055efad0917b848078bf8d97b3adfddf91128d
```

Incompatible changes:

  - The --[no]incompatible_windows_bashless_run_command flag is no
    longer supported. It was flipped in Bazel 1.0
  - The --[no]incompatible_windows_native_test_wrapper flag is no
    longer supported. It was flipped in Bazel 1.0

Important changes:

  - Consistent target naming style in example target names.
  - cquery's config() now supports arbitrary configurations.
  - The flag --incompatible_disallow_dict_lookup_unhashable_keys is
    removed.
  - Include target label in Python version error message.
  - The flag --incompatible_remap_main_repo is removed.
  - Windows: we now discourage running Bazel from MSYS2 because of a
    newly found bug (#10573)
  - Reduced the packaging time (`package-bazel.sh`) for the
    `//src:bazel-dev` Bazel development build target from 14s to 6s.
    Use `//src:bazel-dev` if you're iterating rapidly on a local
    Bazel changes, and use `//src:bazel --compilation_mode=opt` for
    release builds.
  - cquery: "//foo:bar" now means "all configured targets with label
    //foo:bar" instead of "choose an arbitrary configured target with
    label //foo:bar". See cquery docs for details.
  - WORKSPACE and BUILD.bazel files of http_archive repositories can
    now be patched using the "patch_cmds" and "patches" attributes.
  - Actions with "parse" on the critical path should no longer finish
    in the future.
  - Flags that affect external repositories like
    "--override_repository" can now be addressed in bazelrc files
    using the "common" command, without causing commands like "bazel
    shutdown" to fail.
  - The flag --incompatible_disallow_unverified_http_downloads is
    removed.
  - Create the incompatibleApplicableLicenses flag.
    We plan to flip this from false to true in Bazel 4.x.
    Implementation to follow.
  - Treat .cu and .cl files as C++ source. CUDA or OpenCL are not
    natively supported and will require custom flags to compile with
    e.g. clang.
  - Treat .cu and .cl files as C++ source. CUDA or OpenCL are not
    natively supported and will require custom flags to compile with
    e.g. clang.
  - The --starlark_cpu_profile=<file> flag writes a profile in
    pprof format containing a statistical summary of CPU usage
    by all Starlark execution during the bazel command. Use it
    to identify slow Starlark functions in loading and analysis.
  - --ram_utilization_factor will be deprecated. Please use
    --local_ram_resources=HOST_RAM*<float>
  - Docs: glob() documentation is rewritten, and now it points out a
    pitfall of rules shadowing glob-matched files.

This release contains contributions from many people at Google, as well as Alessandro Patti, Alex Kirchhoff, aman, Artur Dryomov, Benjamin Peterson, Benjamin Peterson, David Ostrovsky, Elliotte Rusty Harold, Eric Klein, George Chiramel, George Gensure, Guillaume Bouchard, Hui-Zhi, John Millikin, Jonathan Springer, Laurent Le Brun, Michael McLoughlin, nikola-sh, Nikolaus Wittenstein, Nikolay Shelukhin, Yannic Bonenberger, Yannic.

## Release 2.1.0 (2020-02-07)

```
Baseline: 41ec5a28fb30a8d6c5c60194c4bb29528352cf78

Cherry picks:

   + 733ac0ff7ad1e13ab68ceb2fde694d7ab71b2366:
     Adds an alias for d8_jar_import in android.WORKSPACE.
   + c94b1474b368dedf9f68f34fad90cc8664f2b0e0:
     Automatic code cleanup.
   + 2a8cc7075f741721563efd9dc050ca3458cde30b:
     Do not fail or print errors when Shellzelisk cannot find a
     requested ?
   + bdf34d7fd9539411e93348ba25307f34362d9a42:
     Fix race when extracting the install base when Bazel runs in a
     PID namespace.
   + d381c25bb7dd205c283f7ad91cac13190d2dfede:
     Fix wrong mode of install base directory.
   + eab39cc7b5a612f891fd1e5af5b45bdc1b66e6e1:
     Disable broken test_max_open_file_descriptors.
```

Incompatible changes:

  - The following attributes of CcToolchainProvider, which formerly
    were
    accessible both as fields (x.f) and as methods (x.f()), are now
    only fields:

New features:

  - Similar to the
    [.bazelignore](https://docs.bazel.build/versions/master/guide.html
    #.bazelignore) in the main repository, a `.bazelignore` file in
    external repository will cause the specified directories to be
    ignored by Bazel. Bazel won't try to identify any packages under
    the directories, but the files can still be referenced in other
    BUILD files.
  - bazelignore files now support line comments, e.g. "# this is a
    comment"

Important changes:

  - Experimental support for d8 merger is now available for use using
    --define=android_dexmerger_tool=d8_dexmerger.
  - Critical path run time should not have a longer run time than
    total execution run time.
  - Remove "please do not import" warning for cc rules.
  - x.f() is now equivalent to y=x.f; y(). That is, x.f should return
    the same
    attribute value regardless of whether it is accessed as a field
    or called
    like a method. Any arguments to the call are evaluated after the
    x.f operation.
  - Add desugaring support for RoleManager#addRoleHolderAsUser
  - Adds ctx.target_platform_has_constraint to allow rules to check
    the target platform's constraints.
  - Critical path run time should not have a longer run time than
    total execution run time.
  - Post new ConvenienceSymlinksIdentifiedEvent to the
    BuildEventProtocol when
    --experimental_convenience_symlinks_bep_event is enabled.
  - Keyword-only arguments are now allowed:
        def foo(a, *, k): pass
        def foo(a, *b, k): pass
      where k can be specified only by keyword:
        foo(5, k=6)
  - Generated Go protobufs now depend on //net/proto2/go:protodeps in
    addition to //net/proto2/go:proto
  - cquery 'somepath' returns more reliable results when the
    dep has a different configuration than the parent. To get a
    result for
    `somepath(//foo, //bar`) where //bar isn't in the top-level
    configuration,
    run your query with `--universe_scope=//foo`. See cquery docs for
    details.

This release contains contributions from many people at Google, as well as Adam Liddell, Alessandro Patti, Andreas Herrmann, Bor Kae Hwang, Brian Silverman, Emran BatmanGhelich, George Gensure, Greg Estren, Jeff Palm, Jonathan Beverly, Mark Nevill, Patrick Niklaus, Peter, Philipp Wollermann, Ryan Beasley, Shin Yamamoto, Yen-Chi Chen.

## Release 2.0.0 (2019-12-19)

```
Baseline: 807ed23e4f53a5e008ec823e9c23e2c9baa36d0d

Cherry picks:

   + db0e32ca6296e56e5314993fe9939bc7331768ec:
     build.sh: Fix bug in build script for RC release
   + 85e84f7812f04bc0dbc36376f31b6dd2d229b905:
     Set --incompatible_prohibit_aapt1 default to true.
   + 84eae2ff550c433a3d0409cf2b5525059939439d:
     Let shellzelisk fallback to bazel-real if it's the requested
     version.
   + d5ae460f1581ddf27514b4be18255481b47b4075:
     Fix a typo in bazel.sh
```

Incompatible changes:

  - --incompatible_remap_main_repo is enabled by default. Therefore,
    both ways of addressing the main repository, by its name and by
    '@' are now considered referring to the same repository.
    see https://github.com/bazelbuild/bazel/issues/7130
  - --incompatible_disallow_dict_lookup_unhashable_keys is enabled by
    default https://github.com/bazelbuild/bazel/issues/9184
  - --incompatible_remove_native_maven_jar is now enabled by default
    and the flag removed. See https://github.com/bazelbuild/bazel/issues/6799
  - --incompatible_prohibit_aapt1 is enabled by default.
    See https://github.com/bazelbuild/bazel/issues/10000

Important changes:

  - --incompatible_proto_output_v2: proto v2 for aquery proto output
    formats, which reduces the output size compared to v1. Note that
    the messages' ids in v2 are in uint64 instead of string like in
    v1.
  - Adds --incompatible_remove_enabled_toolchain_types.
  - Package loading now consistently fails if package loading had a
    glob evaluation that encountered a symlink cycle or symlink
    infinite expansion. Previously, such package loading with such
    glob evaluations would fail only in some cases.
  - The --disk_cache flag can now also be used together
    with the gRPC remote cache.
  - An action's discover inputs runtime metrics is now categorized as
    parse time on the CriticalPathComponent.
  - Make the formatting example more like to the written text by
    adding an initial description.
  - An action's discover inputs runtime metrics is now categorized as
    parse time on the CriticalPathComponent.
  - Bazel's Debian package and the binary installer now include an
    improved wrapper that understands `<WORKSPACE>/.bazelversion`
    files and the `$USE_BAZEL_VERSION` environment variable. This is
    similar to what Bazelisk offers
    (https://github.com/bazelbuild/bazelisk#how-does-bazelisk-know-whi
    ch-bazel-version-to-run-and-where-to-get-it-from), except that it
    works offline and integrates with apt-get.
  - We are planning to deprecate the runfiles manifest files, which
    aren't safe in the presence of whitespace, and also unnecessarily
    require local CPU when remote execution is used. This release
    adds --experimental_skip_runfiles_manifests to disable the
    generation of the input manifests (rule.manifest files) in most
    cases. Note that this flag has no effect on Windows by default or
    if --experimental_enable_runfiles is explicitly set to false.

This release contains contributions from many people at Google, as well as aldersondrive, Benjamin Peterson, Bor Kae Hwang, David Ostrovsky, Jakob Buchgraber, Jin, John Millikin, Keith Smiley, Lauri Peltonen, nikola-sh, Peter Mounce, Tony Hsu.

## Release 1.2.1 (2019-11-26)

```
Baseline: 11deef7582dfeec7a04ee3f7236393d9b8027367

Cherry picks:

   + c76c3e539c73ecf6e96e3e098be7be59e17bf276:
     Replace macOS CC path with relative path
   + 63332eb556fadfe9edd0806add79942482adddef:
     Hardcode path to dirname on macOS
   + ceadf0a063cb97c32aced143d2447781d1dafc38:
     Add tool executables (from FilesToRunProvider) to action inputs.
   + dbe63b00954a25fa4405f7cbf273df78c16498dd:
     Fix some of the bazel Windows tools code to work with GCC.
```

This release fixes a single regression:
- #10297: Bazel 1.2.0 does no longer run on macOS High Sierra.

It is the same code as Bazel 1.2.0, except that we rebuild the macOS release
binaries with Xcode 10.2.1 to make them backwards compatible with older macOS
versions again.

## Release 1.2.0 (2019-11-20)

```
Baseline: 11deef7582dfeec7a04ee3f7236393d9b8027367

Cherry picks:

   + c76c3e539c73ecf6e96e3e098be7be59e17bf276:
     Replace macOS CC path with relative path
   + 63332eb556fadfe9edd0806add79942482adddef:
     Hardcode path to dirname on macOS
   + ceadf0a063cb97c32aced143d2447781d1dafc38:
     Add tool executables (from FilesToRunProvider) to action inputs.
   + dbe63b00954a25fa4405f7cbf273df78c16498dd:
     Fix some of the bazel Windows tools code to work with GCC.
```

Incompatible changes:

  - Tree artifacts and regular artifact paths can no longer overlap.

New features:

  - Added a special "_validation" output group to enable moving
    "validation actions" off the critical path of builds.

Important changes:

  - The query flag "--host_deps" (commonly used as "--nohost_deps")
    has been renamed to "--tool_deps", and now also removes
    dependencies in any execution configuration from being reported
    in the query output. The previous flag name is deprecated and
    will be removed in a future release.
  - The `cc_common.{compile,link}` APIs can now be used without
    passing the `--experimental_cc_skylark_api_enabled_packages` flag.
  - A list of log paths will be provided in build output.
  - Improve runfiles documentation.
  - Improve documentation on rule outputs.
  - BUILD/.bzl execution errors cause execution to stop, even at
    top-level
  - Multiple Starlark validation errors are reported in a single pass.
  - Introduce --experimental_nested_set_as_skykey_threshold
  - Blaze will prevent idle sleep during test and build actions. Note
    that this does not affect screen savers and will not keep a
    laptop awake if the user forces sleep or closes the lid. This is
    purely to avoid idle sleeping when the user is not interacting
    with the device.
  - Improve testing docs.
  - Incompatible flag
    `--incompatible_validate_top_level_header_inclusions` has been
    added. See https://github.com/bazelbuild/bazel/issues/10047 for
    details.
  - Fix an aquery bug with handling malformed queries that crashes
    bazel.
  - List fields on CcLinkingOutputs.
  - [Python] Added flag --incomaptible_default_to_explicit_init_py to
    switch the default value of legacy_create_init to True. With this
    flag enabled, your py_binary and py_test targets will no longer
    behave as if empty __init__.py files were implicitly littered in
    your runfiles tree. See
    [#10076](https://github.com/bazelbuild/bazel/issues/10076).
  - Fix documentation on allowed target names.
  - --target_platform_fallback now also applies to exec/host
    configurations
  - android_binary and android_libary can now depend on targets
    providing
    CcInfos.
  - Add support for tracking suspensions (sleeps or SIGSTOP) on macOS.
  - d8 dexers (both standalone and incremental) are now available for
    use.
  - Add Desugar support for FreezePeriod#<init>

This release contains contributions from many people at Google, as well as Alex Kirchhoff, Andrew Suffield, Asaf Flescher, Austin Schuh, Benjamin Peterson, Bor Kae Hwang, Brian Richardson, Christy Norman, Clint Harrison, Dan Halperin, Daniel Martn, Dave Lee, David Neil, David Ostrovsky, George Gensure, Greg Estren, Greg, Ira Shikhman, Jacob Parker, Jakub Bujny, John Millikin, John Millikin, Keith Smiley, Laurent Le Brun, marcohu, Marwan Tammam, Mostyn Bramley-Moore, Peter Mounce, Ruben Das, Stepan Koltsov, Thi Don, Thi, Tomasz Strejczek, Walt Panfil, Yannic Bonenberger, Zackary Lowery.

## Release 1.0.1 (2019-10-21)

```
Baseline: 97a82646dadd93bf52d47828bda42e3383b657c6

Cherry picks:

   + a0e3bb207fe2044120a2555a37162ee1f2b17500:
     Remove support for authentication and .netrc
   + ada2c55dcc106cd55bafbbe5d9a966e21e4770e0:
     Add explicit --sdk argument to xcrun calls
   + 847df729528f6e5919ec8374247eadf792cba544:
     toolchain_vanilla: Unset source and target language level
     versions
   + 5cfa0303d6ac3b5bd031ff60272ce80a704af8c2:
     Update java_tools version to javac11-v5.1.
   + 9c257df5b9b1de5459fc066e77c435ae085957a7:
     Release 1.0.0 (2019-10-10)
   + f7a31b30f5319639c36a6c6b1c14f358597d98d2:
     Prevent action-cache duplicate suppression
   + 618e5a28f7f735c37724377b15775a4975349c74:
     Use FileSystemUtils.moveFile instead of renameTo function of Path
```

This release contains contributions from many people at Google, as well as David Ostrovsky, George Gensure, Keith Smiley.

## Release 1.0.0 (2019-10-10)

```
Baseline: 97a82646dadd93bf52d47828bda42e3383b657c6

Cherry picks:

   + a0e3bb207fe2044120a2555a37162ee1f2b17500:
     Remove support for authentication and .netrc
   + ada2c55dcc106cd55bafbbe5d9a966e21e4770e0:
     Add explicit --sdk argument to xcrun calls
   + 847df729528f6e5919ec8374247eadf792cba544:
     toolchain_vanilla: Unset source and target language level
     versions
   + 5cfa0303d6ac3b5bd031ff60272ce80a704af8c2:
     Update java_tools version to javac11-v5.1.
```

Incompatible changes:

  - Python, Windows: the
    --[no]incompatible_windows_escape_python_args is no longer
    supported. (It was flipped to true in Bazel 0.27.0)
  - --incompatible_use_native_patch is enabled by default
  - Windows: --incompatible_windows_bashless_run_command is now true
    by default, meaning "bazel run //foo:bin" will run the binary as
    a subprocess of the Bazel client. (When the flag is false, the
    binary is executed as a subprocess of Bash.)
  - Windows: --incompatible_windows_native_test_wrapper is enabled by
    default

New features:

  - Genrule now supports `cmd_bash`, `cmd_ps`, `cmd_bat` attributes.
    More details at
    https://docs.bazel.build/versions/master/be/general.html#genrule.c
    md
  - config_setting can now check multiple values on "--foo=firstVal
    --foo=secondVal ..."-style flags
  - tags: use `--experimental_allow_tags_propagation` flag to
    propagate tags to the action's execution requirements from
    targets. Such tags should start with: `no-`, `requires-`,
    `supports-`, `block-`, `disable-`, `cpu:`. See #8830 for details.
  - Users can now get generated def file from cc_library via
    "def_file" output group on Windows.
  - Platform-specific bazelrc: with --enable_platform_specific_config
    you can
    enable flags in bazelrc according to your host platform.
  - tags: use `--experimental_allow_tags_propagation` flag to
    propagate tags to the action's execution requirements from
    cc_library or cc_binary targets. Such tags should start with:
    `no-`, `requires-`, `supports-`, `block-`, `disable-`, `cpu:`.
    See #8830 for details.
  - tags: use --experimental_allow_tags_propagation flag to propagate
    tags to the action's execution requirements from java targets.
    Such tags should start with: no-, requires-, supports-, block-,
    disable-, cpu:. See #8830 for details.

Important changes:

  - Bazel Android builds now use aapt2 by default. To revert to aapt,
    set `--android_aapt=aapt`.
  - Make either --subcommands or --verbose_failures imply
    --materialize_param_files
  - Bazel Android builds now use aapt2 by default. To revert to aapt,
    set `--an...
    RELNOTES: None
  - by default all remote connections considered to be via `gRPC`
    with TLS enabled, unless other specified. To disable TLS use
    `grpc://` prefix for you endpoints. All remote connections via
    `gRPC` affected - `--remote_cache`, `--remote_executor` or
    `--bes_backend`. http cache/executor is not affected. See #8061
    for details.
  - cc_* rules support non-transitive defines through a
    'local_defines' attribute.
  - Enable
    incompatible_disallow_rule_execution_platform_constraints_allowed
    by default (https://github.com/bazelbuild/bazel/issues/8136).
  - incompatible_disallow_split_empty_separator is enabled by default
  - Fixed Android build issues with aapt2 on Windows. See the [GitHub
    issue](https://github.com/bazelbuild/bazel/issues/9102) for more
    information.
  - --incompatible_disable_static_cc_toolchains has been flipped. See
    https://github.com/bazelbuild/bazel/issues/8546.
  - --remote_default_platform_properties has been deprecated in favor
    of --remote_default_exec_properties.
  - The --incompatible_make_thinlto_command_lines_standalone flag has
    been flipped, see https://github.com/bazelbuild/bazel/issues/6791
    for more information.
  - The --incompatible_use_specific_tool_files flag has been flipped.
    See https://github.com/bazelbuild/bazel/pull/9126 for more
    information.
  - Clarify default visibility.
  - Enables incompatible_auto_configure_host_platform
  - New incompatible flag --incompatible_disable_depset_items
    disables the "items" parameter in the Starlark depset
    constructor. Use "direct" and "transitive" parameters instead.
  - --incompatible_assignment_identifiers_have_local_scope is enabled
  - incompatible_disable_partition_default_parameter is enabled by
    default ()
  - incompatible_restrict_attribute_names is enabled
    (https://github.com/bazelbuild/bazel/issues/6437)
  - The --incompatible_disable_nocopts flag has been flipped. See
    https://github.com/bazelbuild/bazel/issues/8546 for more
    information.
  - Deprecated Java-Starlark API java_common.create_provider is
    removed. JavaInfo() legacy args (actions, sources, source_jars,
    use_ijar, java_toolchain, host_javabase) are removed.
  - The flag incompatible_disallow_hashing_frozen_mutables is enabled
    (https://github.com/bazelbuild/bazel/issues/7800)
  - `maven_jar` and `maven_server` now disallow using plain HTTP URLs
    without a specified checksum. If you are still using `maven_jar`,
    consider migrating to
    [`rules_jvm_external`](https://github.com/bazelbuild/rules_jvm_ext
    ernal) for transitive dependency management. See
    [#8607](https://github.com/bazelbuild/bazel/issues/8607) for more
    information.
  - Added `sha256` and `sha256_src` attributes to `maven_jar`. Please
    consider migrating to SHA-256 as SHA-1 has been deemed
    cryptographically insecure ([https://shattered.io]()). Or, use
    [`rules_jvm_external`](https://github.com/bazelbuild/rules_jvm_ext
    ernal) to manage your transitive Maven dependencies with artifact
    pinning and SHA-256 verification support.
  - introducing per-target exec_properties
  - Bazel now supports ThinLTO builds on Linux for Clang versions >=
    6.0. ThinLTO can be enabled through --features=thin_lto
  - The Target.output_group field in Starlark is removed. Use
    OutputGroupInfo instead. See
    https://github.com/bazelbuild/bazel/issues/7949 for details.
  - Make a number of parameters of Starlark builtin functions
    positional-only (as opposed to specifiable by keyword). See
    https://github.com/bazelbuild/bazel/issues/8147 for details.
  - incompatible_skip_genfiles_symlink is enabled by default (#8651)
  - Change Pruned events will fire immediately after being checked.
  - --incompatible_remove_legacy_whole_archive has been flipped. See
    https://github.com/bazelbuild/bazel/issues/7362 for more
    information

This release contains contributions from many people at Google, as well as Adam Liddell, Alessandro Patti, Arshabh Kumar Agarwal, Artem Pelenitsyn, Artem Zinnatullin, Benjamin Peterson, David Ostrovsky, Emmanuel Goh, Farhim Ferdous, George Gensure, iirina, Keith Smiley, Kiril Videlov, Laurent Le Brun, Mantas Sakalauskas, Marwan Tammam, Matt Mukerjee, panzhongxian, Shachar Anchelovich, Stepan Koltsov, Stephan Wolski, Travis Clarke, Yannic Bonenberger, Yuta Saito.

## Release 0.29.0 (2019-08-28)

```
Baseline: 6c5ef5369a3ffceb8a65cc159a2fff1401242810

Cherry picks:

   + 338829f2633e91ae0492ee4169446465e10b5994:
     Fix retrying of SocketTimeoutExceptions in HttpConnector
   + 14651cd86b6fc1d48f56a208a9b5278b3e2dcf75:
     Fallback to next urls if download fails in HttpDownloader
   + b7d300c6be3e130dec0e62a4f19493105f595d57:
     Fix incorrect stdout/stderr in remote action cache. Fixes #9072
   + 960217631abdcab0a7ed95e2ab10acd55f636639:
     Automated rollback of commit
     0f0a0d58725603cf2f1c175963360b525718a195.
   + da557f96c697102ad787e57bbf7db2460f6a60a8:
     Windows: fix "bazel run" argument quoting
   + ef8b6f68cc8ffd2e6523a894034ae383e87ec74c:
     Return JavaInfo from java proto aspects.
   + 209175ff8ffeb05628ed8a187dd414a3d2935c55:
     Revert back to the old behavior of not creating a proto source
     root for generated .proto files.
   + 644060b7a4bc98384b66e3d2343b950b875b5e35:
     Fix PatchUtil for parsing special patch format
   + 067040d7bcb3b24a88432e210a96adacee3f37b4:
     Put the removal of the legacy repository-relative proto path
     behind the --incompatible_generated_protos_in_virtual_imports
     flag.
   + 76ed014e77d7b862f6eb2894600ae525ea570f11:
     repository mapping lookup: convert to canonical name first
```

Important changes:

  - rule_test: fix Bazel 0.27 regression ("tags" attribute was
    ingored, https://github.com/bazelbuild/bazel/issues/8723
  - Adds --incompatible_enable_execution_transition, which enables
    incremental migration of host attributes to exec attributes.
  - objc_proto_library rule has been deleted from Bazel.
  - repository_ctx.read is no longer restricted to files
        in the repository contructed.
  - tags 'no-remote', 'no-cache', 'no-remote-cache',
    'no-remote-exec', 'no-sandbox' are propagated now to the actions
    from targets when '--ncompatible_allow_tags_propagation' flag set
    to true. See #8830.
  - Adds flag
    --//tools/build_defs/pkg:incompatible_no_build_defs_pkg. This
    flag turns off the rules //tools/build_defs/pkg:{pkg_deb,
    pkg_rpm, pkg_tar}.
  - The Android NDK is now integrated with toolchains. To use them,
    pass the `--extra_toolchains=@androidndk//:all` flag or register
    them in your WORKSPACE with
    `register_toolchains("@androidndk//:all")`.
  - Stdout and stderr are checked to determine if output is going to a
    terminal. `--is_stderr_atty` is deprecated and `--isatty` is
    undeprecated.
  - --incompatible_load_proto_rules_from_bzl was added to forbid
    loading the native proto rules directly. See more on tracking
    issue #8922
  - Docker Sandbox now respects remote_default_platform_properties
  - pkg_deb, pkg_rpm & pkg_tar deprecation plan announced in the
    documentation.
  - The new java_tools release:
    * fixes https://github.com/bazelbuild/bazel/issues/8614
    * exposes a new toolchain `@java_tools//:prebuilt_toolchain`
    which is using all the pre-built tools, including singlejar and
    ijar, even on remote execution. This toolchain should be used
    only when host and execution platform are the same, otherwise the
    binaries will not work on the execution platform.
  - java_common.compile supports specifying
    annotation_processor_additional_inputs and
    annotation_processor_additional_outputs for the Java compilation
    action for supporting annotation processors that consume or
    produce artifacts. Fixes #6415
  - There is now documentation on optimizing Android app build
    performance. Read it at
    https://docs.bazel.build/versions/0.29.0/android-build-performance
    .html
  - Execution log now respects --remote_default_platform_properties
  - Include a link to the relevant documenation on transitive Python
    version errors.
  - New incompatible flag
    --incompatible_disable_target_provider_fields removes the ability
    (in Starlark) to access a target's providers via the field syntax
    (for example, `ctx.attr.dep.my_provider`). The provider-key
    syntax should be used instead (for example,
    `ctx.attr.dep[MyProvider]`). See
    https://github.com/bazelbuild/bazel/issues/9014 for details.
  - A new platform exec_properties is added to replace
    remote_execution_properties.
  - Added --incompatible_load_python_rules_from_bzl, which will be
    flipped in Bazel 1.0. See
    https://github.com/bazelbuild/bazel/issues/9006.
  - add --break_build_on_parallel_dex2oat_failure to shortcut tests
    on dex2oat errors

This release contains contributions from many people at Google, as well as Alexander Ilyin, Arek Sredzki, Artem Zinnatullin, Benjamin Peterson, Fan Wu, John Millikin, Loo Rong Jie, Marwan Tammam, Oscar Bonilla, Peter Mounce, Sergio Rodriguez Orellana, Takeo Sawada, and Yannic Bonenberger.

## Release 0.28.1 (2019-07-19)

```
Baseline: 2e374a9c6e3d4ed71f0145de287c4b2fe43c76d6

Cherry picks:

   + 6d0b14b95a71175362030b4811ca74512b00a890:
     rule_test: apply "tags" to all rules in the macro
   + 18cd9048526f067a4950c6ddbf4b1b3604760af0:
     Release 0.28.0 (2019-07-10)
   + 2260b970cb2a10c21a2fde116aa82c79be52991f:
     When copying dynamic libraries to binary, copy them into the
     runfiles as well.
   + a0af170f87c8230fcd8860599b983df097b646bd:
     Undo breaking change of hiding android_common behind
     --experimental_google_legacy_api
   + c6ca6c2ccd9e11a87f837341ae05d2ba037975b1:
     Ignore external/ directory in users' source tree when creating
     execroot symlink tree.
```

Important changes:

  - rule_test: fix Bazel 0.27 regression ("tags" attribute was
    ingored, https://github.com/bazelbuild/bazel/issues/8723

This release contains contributions from many people at Google, as well as .

## Release 0.28.0 (2019-07-10)

```
Baseline: 2e374a9c6e3d4ed71f0145de287c4b2fe43c76d6

Cherry picks:

   + 6d0b14b95a71175362030b4811ca74512b00a890:
     rule_test: apply "tags" to all rules in the macro
```

Incompatible changes:

  - Add --incompatible_enable_profile_by_default to enable the JSON
    profile by default.
  - The --incompatible_windows_style_arg_escaping flag is flipped to
    "true", and the "false" case unsupported. Bazel no longer accepts
    this flag.

Important changes:

  - Bazel now supports hiding compiler warnings for targets that
    you're not explicitly building (see
    https://docs.bazel.build/versions/master/user-manual.html#flag--au
    to_output_filter).
  - Flag `--incompatible_restrict_escape_sequences` is added. See
    https://github.com/bazelbuild/bazel/issues/8380
  - The "info" command now supports the "starlark-semantics"
    argument, which outputs a representation of the effective Starlark
    semantics option values.
  - The `outputs` parameter of the `rule()` function is deprecated
    and attached to flag `--incompatible_no_rule_outputs_param`.
    Migrate rules to use `OutputGroupInfo` or `attr.output` instead.
    See https://github.com/bazelbuild/bazel/issues/7977 for more info.
  - When `--incompatible_strict_action_env` is enabled, the default
    `PATH` now includes `/usr/local/bin`.
  - Turn on --experimental_build_setting_api by default for starlark
    build settings (see
    https://docs.bazel.build/versions/master/skylark/config.html#user-
    defined-build-settings for more info)
  - `@bazel_tools//tools/jdk:toolchain_java10` and
    `@bazel_tools//tools/jdk:toolchain_java11` are now available to
    enable java 10, respectively java 11 language level support.
  - The `command` parameter of the `actions.run_shell()` function
    will be restricted to only accept strings (and not string
    sequences). This check is attached to flag
    `--incompatible_run_shell_command_string`. One may migrate by
    using the `arguments` parameter of `actions.run()` instead. See
    https://github.com/bazelbuild/bazel/issues/5903 for more info.
  - Incompatible change
    `--incompatible_use_platforms_repo_for_constraints` has been
    added. See https://github.com/bazelbuild/bazel/issues/8622 for
    details.
  - Incompatible change
    `--incompatible_use_platforms_repo_for_constraints` has been
    added. See https://github.com/bazelbuild/bazel/issues/8622 f...
  - Bazel's C++ autoconfiguration now understands `BAZEL_LINKLIBS`
    environment variable to specify system libraries that should be
    appended to the link command line.
  - paths under the execution root starting with "." or "_" will be
    re-linked across builds
  - execution_log_json_file now allows actions without outputs.
  - Labels aapt as deprecated for aapt_version, and heavily endorses
    aapt2.
  - Update doc links still pointing to cc_binary.features to point to
    common features
  - Incompatible change
    `--incompatible_use_platforms_repo_for_constraints` has been
    added. See https://github.com/bazelbuild/bazel/issues/8622 for
    details.
    RELNOTES:
  - --incompatible_disable_nocopts flag has been added. See
    https://github.com/bazelbuild/bazel/issues/8706 for details.
  - Fixed treatment of <dist:module /> tags in AndroidManifest.xml
  - Fixed asset precedence for android_binary rules with aapt2.
  - Bazel now officially supports running on CentOS 7.
  - The runtime dynamic libraries are no longer in default output
    group of cc_binary.
  - set the FDOBuildType as CSFDO for binaries built with
    --cs_fdo_absolute_path.
  - Bazel can now be bootstrapped and built on arm64 platforms
    without requiring any flags or patches.
  - Fixed treatment of AndroidManifest.xml attributes which contained
    XML escaping
  - Retire experimental blaze flag
    experimental_link_compile_output_separately. The same behavior is
    available through the feature dynamic_link_test_srcs.
  - --incompatible_load_java_rules_from_bzl was added to forbid
    loading the native java rules directly. See more on tracking
    issue #8746
  - Turn on --experimental_build_setting_api by default for starlark
    build settings (see
    https://docs.bazel.build/versions/master/skylark/config.html#user-
    defined-build-settings for more info)
  - Attribute names are going to be restricted and must be
    syntactically valid identifiers.
    https://github.com/bazelbuild/bazel/issues/6437
  - rule_test: fix Bazel 0.27 regression ("tags" attribute was
    ingored, https://github.com/bazelbuild/bazel/issues/8723

This release contains contributions from many people at Google, as well as Ben Diuguid, Benjamin Peterson, Dave Lee, Loo Rong Jie, Mark Butcher, Marwan Tammam, Pedro Alvarez.

## Release 0.27.1 (2019-07-02)

```
Baseline: 8c3b3fba3f68833bd97d3df2db9c48f0539efc3b

Cherry picks:

   + 123c68daed17b19927372e4df7f7a2256db6b80e:
     Warn in more cases of possible Python version mismatch in host
     config
   + 052167e907373ac7ea43238c3049739f6e94a9d1:
     Add a non-strict autodetecting Python toolchain
   + 6ef6d879ab69225d54ecab3db847fb4eff33bbeb:
     Default java toolchain target
   + 50fa3ec27efdd95771c70faa38a4543d4fed44f2:
     Fix problems with the non-strict Python toolchain
   + e2a626c4f61fe4ceb79a5675d09a6f25ca7b5b22:
     Automated rollback of commit
     bc6f7cb330bb531f062bb301f3703876051191f5.
   + 6efc5b787ad3164cc2fb779c73377695032b4524:
     Treat existence of managed directories as a part of repository
     dirtiness.
   + 3a4be3c93813987a27a97dade3f9ebbc5770e349:
     Add /usr/local/bin to default PATH under strict action env
   + 5c1005c0947b010ee36ca851b8ba07c9479cf682:
     Automated rollback of commit
     536a166270590a8dbc701718550383f3a07cc763.
   + c82eb4878c7dc829455caeb915affe36c89df06f:
     Release 0.27.0 (2019-06-17)
   + d4589630428c1c1bc08a9baf36257e636fe9d746:
     Check for both :lcov_merger and $lcov_merger  attributes in
     TestActionBuilder.
```

Important changes:

  - Add new options --cs_fdo_absolute_path= to support the absolute
    path
    profile for LLVM's context-sensitive FDO.
  - When `--incompatible_strict_action_env` is enabled, the default
    `PATH` now includes `/usr/local/bin`.
  - Turn on --experimental_build_setting_api by default for starlark
    build settings (see
    https://docs.bazel.build/versions/master/skylark/config.html#user-
    defined-build-settings for more info)

This release contains contributions from many people at Google, as well as Ricky Pai.

## Release 0.27.0 (2019-06-17)

```
Baseline: 5935259724bebd1c4bdebc90e159d0f655c8c219

Cherry picks:

   + fe81b49e727efdcc90a270520af193af75f4e31d:
     Support of using the absolute path profile for LLVM's Context
     Sensitive FDO
   + ce5e7180d98e1244fdfba0349952727826cbd173:
     Demote OptionProcessor from globals
   + 3ed9d3681c3e130aafcf3c405ff1795c601bdf95:
     Properly wire up BES half-close. The lack thereof was a simple
     oversight.
   + 4ca768e9f87701fb92598d0a8325a5fc8881a852:
     standardize graph output indentation with 2 spaces
   + aff189a7c514a0171a53a2dcdd37c93ecaa672ad:
     Make sure default Linux artifacts have an associated action,
     even when artifact names are altered.
   + 8c3b3fba3f68833bd97d3df2db9c48f0539efc3b:
     Failures early in package loading will now fail all --keep_going
     builds.
   + 123c68daed17b19927372e4df7f7a2256db6b80e:
     Warn in more cases of possible Python version mismatch in host
     config
   + 052167e907373ac7ea43238c3049739f6e94a9d1:
     Add a non-strict autodetecting Python toolchain
   + 6ef6d879ab69225d54ecab3db847fb4eff33bbeb:
     Default java toolchain target
   + 50fa3ec27efdd95771c70faa38a4543d4fed44f2:
     Fix problems with the non-strict Python toolchain
   + e2a626c4f61fe4ceb79a5675d09a6f25ca7b5b22:
     Automated rollback of commit
     bc6f7cb330bb531f062bb301f3703876051191f5.
   + 6efc5b787ad3164cc2fb779c73377695032b4524:
     Treat existence of managed directories as a part of repository
     dirtiness.
   + 3a4be3c93813987a27a97dade3f9ebbc5770e349:
     Add /usr/local/bin to default PATH under strict action env
   + 5c1005c0947b010ee36ca851b8ba07c9479cf682:
     Automated rollback of commit
     536a166270590a8dbc701718550383f3a07cc763.
```

Incompatible changes:

  - --incompatible_disable_objc_provider_resources no longer has
    effect. Use of deprecated resource fields on the Objc provider is
    now disallowed regardless of this flag.
  - deleted deprecated --experimental-remote-retry* flags, please use
    --remote_retries instead
  - flipped --incompatible_list_based_execution_strategy_selection
    flag to be true by default. See
    https://github.com/bazelbuild/bazel/issues/7480 for details.
  - Octal integer literals in Starlark are required to start with
    "Oo".
  - The "native" module is no longer available in BUILD files, all
    its members can be accessed directly as global symbols. This can
    be temporarily reverted by providing
    --incompatible_disallow_native_in_build_file=false as a flag to
    Blaze.
  - The "native" module is no longer available in BUILD files, all
    its members can be accessed directly as global symbols. This can
    be temporarily reverted by providing
    --incompatible_disallow_native_in_build_file=false as a flag to
    Blaze.
  - Turn off binary style profile format.
  - The "native" module is no longer available in BUILD files, all
    its members can be accessed directly as global symbols. This can
    be temporarily reverted by providing
    --incompatible_disallow_native_in_build_f...
  - cleanup that affects user provided apple frameworks is
    now enabled by default.  See
    https://github.com/bazelbuild/bazel/issues/7944 for more info.
  - Python rules now determine the Python runtime using toolchains
    rather than `--python_top` and `--python_path`, which are
    deprecated. See
    [#7899](https://github.com/bazelbuild/bazel/issues/7899) for
    information on declaring Python toolchains and migrating your
    code. As a side-benefit, this addresses
    [#4815](https://github.com/bazelbuild/bazel/issues/4815)
    (incorrect interpreter version used) on non-Windows platforms.
    Note however that some builds break due to getting the version
    they asked for -- consider setting `python_version = "PY2"` on
    Python 2 targets and `--host_force_python=PY2` if any Python 2
    targets are used in the host configuration. You can temporarily
    opt out of this change with
    `--incompatible_use_python_toolchains=false`.
  - Depsets can't be iterated over unless they're converted to lists
    using the .to_list() method. Use
    --incompatible_depset_is_not_iterable=false to
    temporarily restore the previous behaviour.

New features:

  - Bash, runfiles: the copy-pasted init code of the Bash runfiles
    library is now shorter, see `tools/bash/runfiles/runfiles.bash`.
    The rlocation() implementation is the same.
  - Bash, runfiles: the copy-pasted init code of the Bash runfiles
    library is now shorter, see `tools/bash/runfiles/runfiles.bash`.
    The rlocation() implementation is the same.
  - Bash, runfiles: the copy-pasted init code of the Bash runfiles
    library is now shorter, see `tools/bash/runfiles/runfiles.bash`.
    To use the new init code, you need Bazel 0.27 or newer. The old
    (longer) init code still works.

Important changes:

  - The `outputs` parameter of the `rule()` function is deprecated
    and attached to flag `--incompatible_no_rule_outputs_param`.
    Migrate rules to use `OutputGroupInfo` or `attr.output` instead.
    See https://github.com/bazelbuild/bazel/issues/7977 for more info.
  - The --incompatible_disable_objc_library_resources flag is being
    removed. Please remove it from your configs as it otherwise will
    fail the build.
  - Add a generic additional_linker_inputs attribute on cc_binary
    rules.
  - Windows, C++ autoconfigure: BAZEL_VC and BAZEL_VS may now have
    quotes, so if you set these envvars' values in cmd.exe via
    TAB-completion then you no longer need to remove the surrounding
    quotes.
  - pkg_deb has new attributes: `config` and `templates` that can be
    used for integration with debconf
  - Allow cc_import() of a DLL with no interface library on Windows,
    used to document runtime dependencies.
  - All host-configured Python tools that are built for the wrong
    Python version will now emit a warning message when they exit
    with non-zero status. See #7899.
  - deprecated --remote_local_fallback_strategy. Use
    `--strategy=remote,local` instead. See
    https://github.com/bazelbuild/bazel/issues/7480.
  - Introduce --incompatible_disable_native_android_rules flag
  - The Android desugaring actions now support a persistent worker
    mode for faster local build performance. Enable it with
    `--strategy=Desugar=worker`.
  - --incompatible_static_name_resolution_in_build_files is now
    enabled by default
  - --incompatible_disable_deprecated_attr_params is now enabled by
    default (#5818)
  - Repository containing autoconfigured C++ toolchain
    `@local_config_cc` has been split in 2 - see
    `local_config_cc_toolchains`.
  - --incompatible_string_join_requires_strings is now enabled by
    default
  - Flag --incompatible_new_actions_api is enabled by dewfault (#5825)
  - New flag `--incompatible_disallow_empty_glob`. See
    https://github.com/bazelbuild/bazel/issues/8195
  - --incompatible_no_kwargs_in_build_files is enabled by default
  - Incompatible flag
    `--incompatible_require_ctx_in_configure_features` has been
    flipped. See https://github.com/bazelbuild/bazel/issues/7793 for
    more information.
  - `BAZEL_USE_XCODE_TOOLCHAIN=1` tells Bazel not to look for Xcode to
    decide whether to enable toolchains for Apple rules, but to
    assume Xcode is
    available. Can be also used when building on Darwin and no C++ or
    ObjC is being
    built, so there is no need to detect Xcode.
  - Android desugaring actions now use persistent workers by default.
    This has been measured to provide up to 20% reduction in build
    times. To disable it, use the `--strategy=Desugar=sandboxed`
    flag. See https://github.com/bazelbuild/bazel/issues/8342 and
    https://github.com/bazelbuild/bazel/issues/8427 for more details
    on local build speed optimization for Android apps.
  - Fixed an issue with Android builds where `--fat_apk_cpu` doesn't
    pack all selected shared libraries from `aar_import` targets into
    the APK. See
    [#8283](https://github.com/bazelbuild/bazel/issues/8283).
  - Turn on --experimental_starlark_config_transitions by default for
    starlark transitions (see
    https://docs.bazel.build/versions/master/skylark/config.html#user-
    defined-transitions for more info)
  - Turn on --experimental_build_setting_api by default for starlark
    build settings (see
    https://docs.bazel.build/versions/master/skylark/config.html#user-
    defined-build-settings for more info)
  - Incompatible flag
    `--incompatible_dont_enable_host_nonhost_crosstool_features` has
    been flipped. See https://github.com/bazelbuild/bazel/issues/7407
    for more information.
  - Added support for Android NDK 19 and 20.
  - Flip --incompatible_no_support_tools_in_action_inputs
  - --remote_executor, --remote_cache or --bes_backend=someurl.com
    would be treated as grpcs://someurl.com, if the
    --incompatible_tls_enabled_removed flag enabled. See
    https://github.com/bazelbuild/bazel/issues/8061 for details.
  - Add new options --cs_fdo_absolute_path= to support the absolute
    path
    profile for LLVM's context-sensitive FDO.
  - When `--incompatible_strict_action_env` is enabled, the default
    `PATH` now includes `/usr/local/bin`.
  - Turn on --experimental_build_setting_api by default for starlark
    build settings (see
    https://docs.bazel.build/versions/master/skylark/config.html#user-
    defined-build-settings for more info)

This release contains contributions from many people at Google, as well as Alex Thompson, Andy Scott, Benjamin Peterson, David McNett, Drew Gassaway, Ira Shikhman, James deBoer, Jay Vercellone, Jingwen Chen, Josh Rosen, Keith Smiley, Laurent Le Brun, Lee Mracek, Marwan Tammam, Matt Passell, Michael Hackner, Michal Majcherski, Patrick Niklaus, Peter Mounce, Ricky Pai, Steeve Morin, szakmary, Takuto Ikuta, Vladimir Chebotarev, Yen-Chi Chen.

## Release 0.26.1 (2019-06-06)

```
Baseline: cb82ed84d44db0169a8fbf15f9cee434b77002bb

Cherry picks:

   + d1c0d205945f5a765efb0a48593b1cd82699ce32:
     Allow WORKSPACE file to be a symlink if no managed directories
     is used.
   + c3d2aa74ccd23dfb8a8173c2b3e2955f0c5892cb:
     Fix ios, tvos and watchos arm64 constraints
   + 55e42052a22a60b68d88a89932b2a068311b1a95:
     Bump java_tools_javac10 from 3.1 to 3.2
```

Patch release on top of 0.26.0, fixing
- https://github.com/bazelbuild/bazel/issues/8475
- https://github.com/bazelbuild/bazel/issues/8520
- https://github.com/bazelbuild/intellij/issues/845

## Release 0.26.0 (2019-05-28)

```
Baseline: daa8ae565ab2023e49134f0aad233b0a8bd7a5d0

Cherry picks:

   + 61c7ffa60ae9c1937dd6d8ee30a8c0471094ee71:
     Automated rollback of commit
     87388e24814b177f54ca7697b4233489f90c587e.
   + 898d7b6138af73f03daf35b767d252560087de70:
     Add test for repository overrides, conflicting with managed
     directories being added when Bazel server is already started.
   + c2001a4569483596d9dc74ba9cabcbe4b6f1887f:
     Automated rollback of commit
     bbe47a1564a832e1a175206f2dfbc92af94c120b.
   + e67c961905792cd63950c6f6efc33275ad243c49:
     Fix a non-determinism in create_embedded_tools.py.
   + 81aefe7ee01cc73646a53f9c72ed40ead09f9f5a:
     Remove unsupported cpu attribute from cc_toolchains.
   + 597e289b097d3bfed8eea1cb0924bbeb04877e42:
     remote: made CombinedCache a composition of Disk and Http Cache
   + 942f7cf6a0da0a4ecc804615424f039e50963933:
     C++: Fixes bug in C++ API with external repo aspects
   + 85a5a2bd569a5274950fc7327a044c395248c024:
     Configure @androidsdk//:emulator_x86 and :emulator_arm to point
     to the unified emulator binary
   + 9835cb4135503768cdf1161746b95d7969ccb938:
     Automated rollback of commit
     844e4e297b404d6ff28b818d8150d4b9c47de887.
   + c963ba21073b514961946b8b4b45b091f08fdaa1:
     Windows, Python: fix arg. esc. also in host config
   + a1ea487e0a9e180a36fa4aab57f7c746ddcf367a:
     Do not pre-cache changed files under managed directories
   + 7dc78cdd04eedf2f4373b170053ba5fc2a990929:
     Add explicit execution and target constraints for autodiscovered
     cc t?
   + dd9ac13f7e3b71bdf2eca717bc7681bdd12389a2:
     Fix a bug when a relative path is used for the execution log
   + 0ff19c6d0adf3c0df94fff59ca3bd13cbcf99897:
     Fix StandaloneTestStrategy.appendStderr
   + 7f495315749478e75a3424726cc273a535b7c3b8:
     Fix the autodetecting Python toolchain on Mac
   + ddce7235ef29a0aba727c265eae865d15af4ed09:
     Avoid exporting PATH unnecessarily
   + 35dd05a059fa7fddfdd888cfc69102994e3c04dc:
     Allow Starlark rules to be able to use the `exec_compatible_with`
```

### Incompatible changes

- [`--incompatible_windows_escape_jvm_flags`](https://github.com/bazelbuild/bazel/issues/7486)
  is enabled by default, and removed.

- [`--incompatible_windows_style_arg_escaping`](https://github.com/bazelbuild/bazel/issues/7454)
  is enabled by default.

- [`--incompatible_no_output_attr_default`](https://github.com/bazelbuild/bazel/issues/7950)
  is enabled by default.

- [`--incompatible_depset_union`](https://github.com/bazelbuild/bazel/issues/5817)
  is enabled by default.

- [`--incompatible_disable_genrule_cc_toolchain_dependency`](https://github.com/bazelbuild/bazel/issues/6867) removed

- [`--Incompatible_disallow_rule_execution_platform_constraints_allowed`](https://github.com/bazelbuild/bazel/issues/8136):
  When enabled, disallows the use of the `execution_platform_constraints_allowed`
  attribute when defining new rules.

- [`--incompatible_disable_objc_provider_resources`](https://github.com/bazelbuild/bazel/issues/5710)
  is now enabled by default.

### Apple

- The `--ios_multi_cpus`, `--watchos_cpus`, `--macos_cpus` and `--tvos_cpus` are
  now additive. This means that you can now split the `--ios_multi_cpus=arm64,armv7`
  into `--ios_multi_cpus=arm64` and `--ios_multi_cpus=armv7`.

- Add `--incompatible_objc_framework_cleanup` to control whether to enable some
  objc framework cleanup that changes the API. Specifically, the cleanup changes
  the objc provider API pertaining to frameworks. This change is expected to be
  transparent to most users unless they write their own Starlark rules to handle
  frameworks. See https://github.com/bazelbuild/bazel/issues/7594 for details.

- `objc_library` does not support resource attributes any more. Please read
  [#7594](https://github.com/bazelbuild/bazel/issues/7594) for more info.

### Android

- Android resource conflicts will no longer be reported between a strong attr
  resource and a weak attr resource, if the weak attr does not have format
  specified.

### C++

- [Allow debugging C++ features logic](https://github.com/bazelbuild/bazel/commit/53156db1e30fe7197889c3cbc8d1321ff9b85143

- Add new options [`--cs_fdo_instrument`](https://docs.bazel.build/versions/master/command-line-reference.html#flag--cs_fdo_instrument)
  and [`--cs_fdo_profile`](https://docs.bazel.build/versions/master/command-line-reference.html#flag--cs_fdo_profile)
  to support LLVM's context-sensitive FDO (CSFDO).

- [Bazel C++ compile/link Starlark API](https://github.com/bazelbuild/bazel/issues/4570).
  Can be used with experimental flag `--experimental_cc_skylark_api_enabled_packages`.

- `cc_toolchain.static_runtime_lib` and `cc_toolchain.dynamic_runtime_lib` are
  now exposed to Starlark.

- C++ Starlark API for compilation and linking is no longer whitelisted

- Incompatible flag `--incompatible_make_thinlto_command_lines_standalone` has
  been added. See https://github.com/bazelbuild/bazel/issues/6791 for details.

- Feature `disable_whole_archive_for_static_lib` has been added to allow turning
  off legacy_whole_archive for individual targets.
  https://github.com/bazelbuild/bazel/issues/7362

### Python

- Fixed an issue where some `py_runtimes` were incompatible with using
  `--build_python_zip` ([#5104](https://github.com/bazelbuild/bazel/issues/5104)).

### Starlark

- The flag [`--incompatible_restrict_named_params`](https://github.com/bazelbuild/bazel/issues/8147)
  is added. [Buildifier](https://github.com/bazelbuild/buildtools) will soon be
  updated to automatically fix this in your code.

- The flag [`--incompatible_no_kwargs_in_build_files`](https://github.com/bazelbuild/bazel/issues/8021)
  is added. It fixes a bug where the `**kwarg` notation was allowed in `BUILD`
  files.

- The flag [`--incompatible_static_name_resolution_in_build_files`](https://github.com/bazelbuild/bazel/issues/8022)
  is added. This fixes a bug where invalid code was silently accepted.

- The flag [`--incompatible_disallow_old_octal_notation`](https://github.com/bazelbuild/bazel/issues/8059)
  is added. It removes a deprecated notation for octal numbers.
  [Buildifier](https://github.com/bazelbuild/buildtools) can update your code
  automatically.

- [`struct.to_proto()`](https://docs.bazel.build/versions/master/skylark/lib/struct.html#to_proto)
  can now convert dictionaries into proto3 text message.

- The [`glob`](https://docs.bazel.build/versions/master/be/functions.html#glob)
  function has a new argument `allow_empty`. When set to `False` (this will be
  the default in the future), the glob fails when it doesn't match anything.
  Please explicitly set `allow_empty = True` to the globs that need it.

### Windows

- Windows, Python: the new `--incompatible_windows_escape_python_args` flag
  (`false` by default) builds `py_binary` and `py_test` targets with correct
  command line argument escaping. Similar to
  https://github.com/bazelbuild/bazel/issues/7486 but for `py_*` rules.

### Other changes

- cquery supports `--output=build`

- Generated Go protobufs now depend on `//net/proto2/go:proto_gendeps` instead
  of `//net/proto2/go:proto`

- Added `--incompatible_remove_binary_profile` to disable the old binary
  profiles. Instead use the JSON profile format:
  https://docs.bazel.build/versions/master/skylark/performance.html#json-profile

- Introducing `--execution_log_binary_file` and `--execution_log_json_file`
  that output a stable sorted execution log. They will offer a stable
  replacement to `--experimental_execution_log_file`.

- New platform_mappings ability to allow gradual flag to platforms/toolchains
  migration. See also https://github.com/bazelbuild/bazel/issues/6426

- Added support for compiling against fully qualified `R` classes from
  `aar_import` dependencies.

- `--tls_enabled` flag is deprecated. Please provide `grpcs` as a scheme in
  the URLs if TLS should be used for a remote connection.

### Community

- Alex Eagle gave a talk at ng-conf:
  [The Bazel Opt-in Preview is Here!](https://www.youtube.com/watch?v=J1lnp-nU4wM)

- The latest release of
  [rules_haskell](https://github.com/tweag/rules_haskell/releases/tag/v0.9)
  includes many new improvements, including an initial Windows support.

- The latest
  [Buildifier release](https://github.com/bazelbuild/buildtools/releases/tag/0.25.1)
  includes Windows binaries, as well as a JSON output for diagnostics.

- Natan Silnitsky gave the talk
  [How to successfully migrate to Bazel from Maven or Gradle](https://www.youtube.com/watch?v=2UOFm-Cc_cU)
  at the Java Eastern Europe Conference.

This release contains contributions from many people at Google, as well as
Benjamin Peterson, Brian Topping, clyang82, Dave Lee, George Gensure,, Greg,
Guro Bokum, Keith Smiley, Max Vorobev, Michael Hackner, Robert Brown, Robert
Sayre, Ryan Beasley, and Yannic.


## Release 0.25.3 (2019-05-23)

```
Baseline: 03662462941953dad23af88693804b8b1d4430b9

Cherry picks:

   + 3f7f255f9a8345b8898e3953e7e53d68106cc63d:
     Windows: fix native test wrapper's arg. escaping
   + afeb8d0b7fef619159fc8fbaaeb8bd41dd2619bd:
     Flip --incompatible_windows_escape_jvm_flags
   + 4299b6549cbc1b3e4494c91ed2f51d49b14c7980:
     Sort DirectoryNode children to ensure validity.
   + 231270c67d5aa771462245531fa9b2ee7d3d0ae8:
     Conditionally use deprecated signature for initWithContentsOfURL
   + 75a3a531b08e727ade4fa3cb0a574bd142727cce:
     Add http_archive entries for testing with various JDK versions.
   + 4a6354a3a5ca23583f8b62e3e439a04ce75b863f:
     Now that ubuntu1804 uses JDK 11, remove explicit
     ubuntu1804_java11 tests.
   + ae102fbde3c1ff87e4f67007a275fb30792a4e8d:
     Fix wrong name of ubuntu1804_javabase9 task.
   + 0020a97fdc20ca099ec6386771b20d3236f9890d:
     Remove @executable_path/Frameworks from rpaths
   + 130f86ded1ce84f959f0b78c065211902faed546:
     Download stderr/stdout to a temporary FileOutErr
   + 2ab38663592a9ccbcc1f6f75ed135ae315f4d9d9:
     Release 0.25.0 (2019-05-01)
   + ed48a4a5fddbd93b057c3aa726e15720d79dcf8f:
     Add implementation to removed methods to address
     https://github.com/bazelbuild/bazel/issues/8226
   + 81aefe7ee01cc73646a53f9c72ed40ead09f9f5a:
     Remove unsupported cpu attribute from cc_toolchains.
   + cccced1e7fc7eaf4ba8f2c9d73dbac72b2686df9:
     Release 0.25.1 (2019-05-07)
   + 0900660d67b53a56a13d1fa16a788e4cecbb1c0e:
     Use package identifier instead of package name
   + 85a5a2bd569a5274950fc7327a044c395248c024:
     Configure @androidsdk//:emulator_x86 and :emulator_arm to point
     to the unified emulator binary
   + 6549ac5bba3eef2b1813b5a75757437383bf38f0:
     Release 0.25.2 (2019-05-10)
   + 0ff19c6d0adf3c0df94fff59ca3bd13cbcf99897:
     Fix StandaloneTestStrategy.appendStderr
```

Incompatible changes:

  - Flip --incompatible_windows_escape_jvm_flags to true. See
    https://github.com/bazelbuild/bazel/issues/7486

This release contains contributions from many people at Google, as well as George Gensure, Keith Smiley, Robert Sayre.

## Release 0.25.2 (2019-05-10)

```
Baseline: 03662462941953dad23af88693804b8b1d4430b9

Cherry picks:

   + 3f7f255f9a8345b8898e3953e7e53d68106cc63d:
     Windows: fix native test wrapper's arg. escaping
   + afeb8d0b7fef619159fc8fbaaeb8bd41dd2619bd:
     Flip --incompatible_windows_escape_jvm_flags
   + 4299b6549cbc1b3e4494c91ed2f51d49b14c7980:
     Sort DirectoryNode children to ensure validity.
   + 231270c67d5aa771462245531fa9b2ee7d3d0ae8:
     Conditionally use deprecated signature for initWithContentsOfURL
   + 75a3a531b08e727ade4fa3cb0a574bd142727cce:
     Add http_archive entries for testing with various JDK versions.
   + 4a6354a3a5ca23583f8b62e3e439a04ce75b863f:
     Now that ubuntu1804 uses JDK 11, remove explicit
     ubuntu1804_java11 tests.
   + ae102fbde3c1ff87e4f67007a275fb30792a4e8d:
     Fix wrong name of ubuntu1804_javabase9 task.
   + 0020a97fdc20ca099ec6386771b20d3236f9890d:
     Remove @executable_path/Frameworks from rpaths
   + 130f86ded1ce84f959f0b78c065211902faed546:
     Download stderr/stdout to a temporary FileOutErr
   + 2ab38663592a9ccbcc1f6f75ed135ae315f4d9d9:
     Release 0.25.0 (2019-05-01)
   + ed48a4a5fddbd93b057c3aa726e15720d79dcf8f:
     Add implementation to removed methods to address
     https://github.com/bazelbuild/bazel/issues/8226
   + 81aefe7ee01cc73646a53f9c72ed40ead09f9f5a:
     Remove unsupported cpu attribute from cc_toolchains.
   + cccced1e7fc7eaf4ba8f2c9d73dbac72b2686df9:
     Release 0.25.1 (2019-05-07)
   + 0900660d67b53a56a13d1fa16a788e4cecbb1c0e:
     Use package identifier instead of package name
   + 85a5a2bd569a5274950fc7327a044c395248c024:
     Configure @androidsdk//:emulator_x86 and :emulator_arm to point
     to the unified emulator binary
```

* Add fix for https://github.com/bazelbuild/bazel/issues/8254
* Add fix for https://github.com/bazelbuild/bazel/issues/8280

## Release 0.25.1 (2019-05-07)

```
Baseline: 03662462941953dad23af88693804b8b1d4430b9

Cherry picks:

   + 3f7f255f9a8345b8898e3953e7e53d68106cc63d:
     Windows: fix native test wrapper's arg. escaping
   + afeb8d0b7fef619159fc8fbaaeb8bd41dd2619bd:
     Flip --incompatible_windows_escape_jvm_flags
   + 4299b6549cbc1b3e4494c91ed2f51d49b14c7980:
     Sort DirectoryNode children to ensure validity.
   + 231270c67d5aa771462245531fa9b2ee7d3d0ae8:
     Conditionally use deprecated signature for initWithContentsOfURL
   + 75a3a531b08e727ade4fa3cb0a574bd142727cce:
     Add http_archive entries for testing with various JDK versions.
   + 4a6354a3a5ca23583f8b62e3e439a04ce75b863f:
     Now that ubuntu1804 uses JDK 11, remove explicit
     ubuntu1804_java11 tests.
   + ae102fbde3c1ff87e4f67007a275fb30792a4e8d:
     Fix wrong name of ubuntu1804_javabase9 task.
   + 0020a97fdc20ca099ec6386771b20d3236f9890d:
     Remove @executable_path/Frameworks from rpaths
   + 130f86ded1ce84f959f0b78c065211902faed546:
     Download stderr/stdout to a temporary FileOutErr
   + 2ab38663592a9ccbcc1f6f75ed135ae315f4d9d9:
     Release 0.25.0 (2019-05-01)
   + ed48a4a5fddbd93b057c3aa726e15720d79dcf8f:
     Add implementation to removed methods to address
     https://github.com/bazelbuild/bazel/issues/8226
   + 81aefe7ee01cc73646a53f9c72ed40ead09f9f5a:
     Remove unsupported cpu attribute from cc_toolchains.
```

Adding a commit which reintroduces the implementation for cc_common.compile and cc_common.link https://github.com/bazelbuild/bazel/issues/8226

## Release 0.25.0 (2019-05-01)

```
Baseline: 03662462941953dad23af88693804b8b1d4430b9

Cherry picks:

   + 3f7f255f9a8345b8898e3953e7e53d68106cc63d:
     Windows: fix native test wrapper's arg. escaping
   + afeb8d0b7fef619159fc8fbaaeb8bd41dd2619bd:
     Flip --incompatible_windows_escape_jvm_flags
   + 4299b6549cbc1b3e4494c91ed2f51d49b14c7980:
     Sort DirectoryNode children to ensure validity.
   + 231270c67d5aa771462245531fa9b2ee7d3d0ae8:
     Conditionally use deprecated signature for initWithContentsOfURL
   + 75a3a531b08e727ade4fa3cb0a574bd142727cce:
     Add http_archive entries for testing with various JDK versions.
   + 4a6354a3a5ca23583f8b62e3e439a04ce75b863f:
     Now that ubuntu1804 uses JDK 11, remove explicit
     ubuntu1804_java11 tests.
   + ae102fbde3c1ff87e4f67007a275fb30792a4e8d:
     Fix wrong name of ubuntu1804_javabase9 task.
   + 0020a97fdc20ca099ec6386771b20d3236f9890d:
     Remove @executable_path/Frameworks from rpaths
   + 130f86ded1ce84f959f0b78c065211902faed546:
     Download stderr/stdout to a temporary FileOutErr
```

Incompatible changes:

  - (Starlark rules) The legacy "py" provider can no longer be passed
    to or produced by native Python rules; use
    [PyInfo](https://docs.bazel.build/versions/master/skylark/lib/PyIn
    fo.html) instead. See
    [#7298](https://github.com/bazelbuild/bazel/issues/7298) for more
    information.
  - (Python rules) The `default_python_version` attribute of the
    `py_binary` and `py_test` rules has been renamed to
    `python_version`. Also, the `--force_python` flag has been
    renamed to `--python_version`. See
    [#7308](https://github.com/bazelbuild/bazel/issues/7308) for more
    information.
  - (Python rules) The python version now changes to whatever version
    is specified in a `py_binary` or `py_test`'s `python_version`
    attribute, instead of being forced to the value set by a command
    line flag. You can temporarily revert this change with
    `--incompatible_allow_python_version_transitions=false`. See
    [#7307](https://github.com/bazelbuild/bazel/issues/7307) for more
    information.
  - --incompatible_disable_third_party_license_checking` is enabled
    by default
  - Introduced --incompatible_use_python_toolchains, which supersedes
    --python_top/--python_path. See #7899 and #7375 for more
    information.
  - Python 3 is now the default Python version (for `py_binary` and
    `py_test` targets that don't specify the `python_version`
    attribute). Targets that are built for Python 3 will no longer
    have their output put in a separate `-py3` directory; instead
    there is now a separate `-py2` directory for Python 2 targets.
    See #7359 and #7593 for more information.
  - objc_library resource attributes are now disabled by default.
    Please migrate them to data instead. See
    https://github.com/bazelbuild/bazel/issues/7594 for more info.
  - Flip --incompatible_windows_escape_jvm_flags to true. See
    https://github.com/bazelbuild/bazel/issues/7486

New features:

  - genrules now support a $(RULEDIR) variable that resolves to the
    directory where the outputs of the rule are put.
  - Added --incompatible_windows_native_test_wrapper flag: enables
    using the Bash-less test wrapper on Windows. (No-op on other
    platforms.)

Important changes:

  - incompatible_use_jdk11_as_host_javabase: makes JDK 11 the default
    --host_javabase for remote jdk
    (https://github.com/bazelbuild/bazel/issues/7219)
  - Makes genquery somepath output deterministic.
  - Tristate attributes of native rules now reject True/False (use
    1/0)
  - Rollback of "Tristate attributes of native rules now reject
    True/False (use 1/0)"
  - Tristate attributes of native rules now reject True/False (use
    1/0)
  - Added -incompatible_do_not_split_linking_cmdline flag. See #7670
  - Tristate attributes of native rules now temporarily accept
    True/False again
  - `--incompatible_disable_legacy_crosstool_fields` has been flipped
    (https://github.com/bazelbuild/bazel/issues/6861)
    `--incompatible_disable_expand_if_all_available_in_flag_set` has
    been flipped (https://github.com/bazelbuild/bazel/issues/7008)
  - `--incompatible_disable_legacy_crosstool_fields` has been flipped
    (https://github.com/bazelbuild/bazel/issues/6861)
    `--incompatible_disable_expand_if_all_available_in_flag_set...
    RELNOTES: None.
  - --incompatible_no_transitive_loads is enabled by default.
  - Makes TreeArtifact deterministic.
  - --incompatible_no_transitive_loads is enabled by default.
  - Android NDK C++ toolchain is now configured in Starlark. This
    should be a backwards compatible change, but in case of bugs
    blame unknown commit.
  - `--incompatible_disable_legacy_crosstool_fields` has been flipped
    (https://github.com/bazelbuild/bazel/issues/6861)
    `--incompatible_disable_expand_if_all_available_in_flag_set` has
    been flipped (https://github.com/bazelbuild/bazel/issues/7008)
  - --incompatible_no_transitive_loads is enabled by default.
  - --incompatible_bzl_disallow_load_after_statement is enabled
  - Added `--incompatible_require_ctx_in_configure_features`, see
    https://github.com/bazelbuild/bazel/issues/7793 for details.
  - Flag --incompatible_merge_genfiles_directory is flipped. This
    removes the directory `bazel-genfiles` in favor of `bazel-bin`.
  - previously deprecated flag --experimental_remote_spawn_cache was
    removed
  - `--incompatible_disallow_load_labels_to_cross_package_boundaries`
    is enabled by default
  - Fix an issue where the Android resource processor did not surface
    errors from aapt2 compile and link actions.
  - --incompatible_no_attr_license is enabled by default
  - `--incompatible_disable_crosstool_file` has been flipped
    (https://github.com/bazelbuild/bazel/issues/7320)
  - A new flag `--incompatible_string_join_requires_strings` is
    introduced. The sequence argument of `string.join` must contain
    only string elements.
  - --incompatible_symlinked_sandbox_expands_tree_artifacts_in_runfile
    s_tree has been flipped
  - Incompatible flag `--incompatible_disable_legacy_cc_provider` has
    been flipped (see https://github.com/bazelbuild/bazel/issues/7036
    for details).
  - Don't drop the analysis cache when the same --define flag is set
    multiple times and the last value is the same (e.g. if the
    current invocation was run with "--define foo=bar" and the
    previous one was run with "--define foo=baz --define foo=bar").
  - The --incompatible_disable_genrule_cc_toolchain_dependency flag
    has been flipped (see
    https://github.com/bazelbuild/bazel/issues/6867 for details).
  - Incompatible change
    `--incompatible_remove_cpu_and_compiler_attributes_from_cc_toolcha
    in` has been flipped (see
    https://github.com/bazelbuild/bazel/issues/7075 for details).
  - --noexperimental_java_coverage is a no-op flag.
  - --experimental_java_coverage/--incompatible_java_coverage flag was
    removed. See #7425.
  - incompatible_use_toolchain_providers_in_java_common: pass
    JavaToolchainInfo and JavaRuntimeInfo providers to java_common
    APIs instead of configured targets
    (https://github.com/bazelbuild/bazel/issues/7186.)
  - --incompatible_remote_symlinks has been flipped. The remote
    caching and execution protocol will now represent symlinks in
    outputs as such. See
    https://github.com/bazelbuild/bazel/issues/7917 for more details.
  - Bazel is now ~20MiB smaller, from unbundling the Android rules'
    runtime dependencies.

This release contains contributions from many people at Google, as well as Andreas Herrmann, Andrew Suffield, Andy Scott, Benjamin Peterson, Ed Baunton, George Gensure, Ian McGinnis, Ity Kaul, Jingwen Chen, John Millikin, Keith Smiley, Marwan Tammam, Mike Fourie, Oscar Bonilla, perwestling, petros, Robert Sayre, Ryan Beasley, silvergasp, Stanimir Mladenov, Travis Cline, Vladimir Chebotarev, ??.

## Release 0.24.1 (2019-04-02)

```
Baseline: 235e76b0e756d05599a6cbe1663ff8e13df84a86

Cherry picks:

   + badd82e4c5cda7b3232481e1c63a5550ac898cd8:
     Automated rollback of commit
     1b4c37c38804559b5c1ade6f9c93501875e231b0.
   + 33e571939085dd158422e1b3503cfc738e0a3165:
     Fix the Python version select() mechanism to handle
     PY3-as-default
   + 56366ee3a73e2c92b2fa36a9840478202b9618ca:
     Set non-empty values for msvc_env_* when VC not installed
   + 22b3fbf4800113df51d603d943bd9eb9517ef904:
     Windows, test wrapper: fix broken integration test
   + f14d447cb56aee563f6e686b8f5b086a3bb55d47:
     Add whitelist file for starlark transitions
   + d99bc478db1f3414b4f6cd3dc14ca70aacf6b375:
     Update BUILD
   + 3529ad7ccf0c26dfb20a9d67b9d96de15f309f8b:
     Rename tools/function_transition_whitelist/BUILD to
     tools/whitelists/function_transition_whitelist/BUILD
   + de0612ad3ef7cc8c44069261befdeb0d15b97c10:
     Update bazel_toolchains to latest release and add toolchain
     config target for BuildKite CI (rbe_ubuntu1604)
   + 3e660ad178926648e8e10e2ee7a1a30b12f9b3d1:
     Automated rollback of commit
     087734009801242b83655efb863b2d5a761ae3dc.
   + 314cf1f9e4b332955c4800b2451db4e926c3e092:
     Pass -undefined dynamic_lookup to dynamic library linking
     actions on Mac
   + fc586a86b614667a21e5a01aea3544ac0338de78:
     Move cc_flags target into @bazel_tools//tools/cpp.
   + ea1703b30f9ac43a0c3262f5729c34658ed8d473:
     C++: Fix crash reported in #7721
   + 803801d1494f06f0ce977a1f2241ef6a4d85df09:
     Pass execution info to xml generating spawn. Fixes #7794
   + f092ec388a4b58788285b928c86f0f81561d4be4:
     Release 0.24.0 (2019-03-26)
   + c56c489119e6587975964c44ceb9e429ad950736:
     Wrap StatusRuntimeExceptions from GrpcRemoteCache
```

Baseline: f092ec388a4b58788285b928c86f0f81561d4be4

Cherrypicks:
+ c56c489119e6587975964c44ceb9e429ad950736: Wrap StatusRuntimeExceptions from GrpcRemoteCache

## Release 0.24.0 (2019-03-26)

```
Baseline: 235e76b0e756d05599a6cbe1663ff8e13df84a86

Cherry picks:

   + badd82e4c5cda7b3232481e1c63a5550ac898cd8:
     Automated rollback of commit
     1b4c37c38804559b5c1ade6f9c93501875e231b0.
   + 33e571939085dd158422e1b3503cfc738e0a3165:
     Fix the Python version select() mechanism to handle
     PY3-as-default
   + 56366ee3a73e2c92b2fa36a9840478202b9618ca:
     Set non-empty values for msvc_env_* when VC not installed
   + 22b3fbf4800113df51d603d943bd9eb9517ef904:
     Windows, test wrapper: fix broken integration test
   + f14d447cb56aee563f6e686b8f5b086a3bb55d47:
     Add whitelist file for starlark transitions
   + d99bc478db1f3414b4f6cd3dc14ca70aacf6b375:
     Update BUILD
   + 3529ad7ccf0c26dfb20a9d67b9d96de15f309f8b:
     Rename tools/function_transition_whitelist/BUILD to
     tools/whitelists/function_transition_whitelist/BUILD
   + de0612ad3ef7cc8c44069261befdeb0d15b97c10:
     Update bazel_toolchains to latest release and add toolchain
     config target for BuildKite CI (rbe_ubuntu1604)
   + 3e660ad178926648e8e10e2ee7a1a30b12f9b3d1:
     Automated rollback of commit
     087734009801242b83655efb863b2d5a761ae3dc.
   + 314cf1f9e4b332955c4800b2451db4e926c3e092:
     Pass -undefined dynamic_lookup to dynamic library linking
     actions on Mac
   + fc586a86b614667a21e5a01aea3544ac0338de78:
     Move cc_flags target into @bazel_tools//tools/cpp.
   + ea1703b30f9ac43a0c3262f5729c34658ed8d473:
     C++: Fix crash reported in #7721
   + 803801d1494f06f0ce977a1f2241ef6a4d85df09:
     Pass execution info to xml generating spawn. Fixes #7794
```

Incompatible changes:

  - Added --incompatible_py3_is_default to test switching the default
    Python version to PY3 for py_binary/py_test targets that do not
    specify a version. See #7359.
  - //tools/cmd_line_differ has been renamed to //tools/aquery_differ
    & can now compare (in addition to command lines) inputs of
    actions given 2 aquery results.
  - java_(mutable_|)proto_library: removed strict_deps attribute.
  - The flag --incompatible_list_based_execution_strategy_selection
    was added and is used to ease the migration to the new style of
    specifying
    execution strategy selection and fallback behavior. The
    documentation for
    this flag is here: https://github.com/bazelbuild/bazel/issues/7480
  - Added --incompatible_py2_outputs_are_suffixed, for switching the
    bazel-bin symlink to point to Python 3 outputs instead of Python
    2 outputs. See
    [#7593](https://github.com/bazelbuild/bazel/issues/7593).

New features:

  - Make actions.args() object chainable.
  - Added --incompatible_windows_style_arg_escaping flag: enables
    correct subprocess argument escaping on Windows. (No-op on other
    platforms.)
  - Added --incompatible_windows_escape_jvm_flags flag: enables
    correct java_binary.jvm_flags and java_test.jvm_flags
    tokenization and escaping on Windows. (No-op on other platforms.)

Important changes:

  - Allow running aquery against the current state of Skyframe
  - Added support for the "navigation" resource directory to Android
    resource processing in Bazel. This is used by the Navigation
    Architecture Component.
  - --incompatible_disable_runtimes_filegroups was flipped
    (https://github.com/bazelbuild/bazel/issues/6942)
  - Incompatible flag `--incompatible_linkopts_in_user_link_flags`
    has been flipped (https://github.com/bazelbuild/bazel/issues/6826)
  - Incompatible flag `--incompatible_dont_emit_static_libgcc` has
    been flipped (https://github.com/bazelbuild/bazel/issues/6825)
  - --incompatible_disallow_filetype is enabled by default.
  - Fixed issue where exceptions and stacktraces were silently
    swallowed in the Android resource processing pipeline.
  - `--incompatible_disable_expand_if_all_available_in_flag_set` has
    been flipped (https://github.com/bazelbuild/bazel/issues/7008)
  - --incompatible_disallow_dict_plus is enabled by default
  - Adds --incompatible_disable_objc_library_resources to disable
    resource attributes in objc_library. Please migrate these
    attributes to `data` instead.
  - --incompatible_disallow_old_style_args_add is enabled by default.
  - Using the `native` module in BUILD files is deprecated. It will
    be forbidden with --incompatible_disallow_native_in_build_file.
  - (Python rules) PyRuntimeInfo is exposed to Starlark, making it
    possible for Starlark rules to depend on or imitate `py_runtime`.
    The `files` attribute of `py_runtime` is no longer mandatory.
  - incompatible_use_toolchain_providers_in_java_common: pass
    JavaToolchainInfo and JavaRuntimeInfo providers to java_common
    APIs instead of configured
    targetshttps://github.com/bazelbuild/bazel/issues/7186.
  - is_using_fission crosstool variable is now exposed in all compile
    actions when fission is active (it used to be exposed only for
    linking actions).
  - incompatible_use_toolchain_providers_in_java_common: pass
    JavaToolchainInfo and JavaRuntimeInfo providers to java_common
    APIs instead of configured
    targetshttps://github.com/bazelbuild/bazel/issues/7186.
  - `py_runtime` gains a `python_version` attribute for specifying
    whether it represents a Python 2 or 3 interpreter.
  - `--incompatible_java_coverage` is enabled by default.
  - Starlark rules can safely declare attributes named "licenses"
  - When using
    --incompatible_list_based_execution_strategy_selection, Bazel
    will use remote execution by default (if you specify
    --remote_executor), otherwise persistent workers (if the action
    supports it), otherwise sandboxed local execution (if the action
    and platform supports it) and at last unsandboxed local
    execution. The flags --spawn_strategy and --strategy continue to
    work as before - this only sets new defaults for the case where
    you don't specify these flags.
  - Set default value of --incompatible_remap_main_repo to true.
  - Set default value of --incompatible_remap_main_repo to true.

This release contains contributions from many people at Google, as well as Andrew Suffield, Brandon Lico, Chris Eason, Clint Harrison, Ed Schouten, Garrett Hopper, George Gensure, Greg, John Millikin, Julie, Keith Smiley, Laurent Le Brun, Ryan Beasley, Shmuel H, Travis Cline, Vladimir Chebotarev.

## Release 0.23.0 (2019-02-26)

```
Baseline: 441fd75d0047f8a998d784c557736ab9075db893

Cherry picks:

   + 6ca7763669728253606578a56a205bca3ea883e9:
     Fix a typo
   + 2310b1c2c8b2f32db238f667747e7d5672480f4a:
     Ignore SIGCHLD in test setup script
   + f9eb1b56706f91063e9d080b850fa56964e77324:
     Complete channel initialization in the event loop
```

Incompatible changes:

  - //src:bazel uses the minimal embedded JDK, if you want to
    avoid the extra steps of minimizing the JDK, use //src:bazel-dev
    instead.
  - //src:bazel uses the minimal embedded JDK, if you want to
    avoid the extra steps of building bazel with the minimized JDK,
    use //src:bazel-dev
    instead.
  - The default value of --host_platform and --platforms will be
      changed to not be dependent on the configuration. This means
    that setting
      --cpu or --host_cpu will not affect the target or host platform.
  - Toolchain resolution for cc rules is now enabled via an
    incompatible flag, --incompatible_enable_cc_toolchain_resolution.
    The previous
    flag, --enabled_toolchain_types, is deprecated and will be
    removed.
  - java_(mutable_|)proto_library: removed strict_deps attribute.
  - Python rules will soon reject the legacy "py" struct provider
    (preview by enabling --incompatible_disallow_legacy_py_provider).
    Upgrade rules to use PyInfo instead. See
    [#7298](https://github.com/bazelbuild/bazel/issues/7298).
  - java_(mutable_|)proto_library: removed strict_deps attribute.
  - Two changes to native Python rules: 1) `default_python_version`
    and `--force_python` are deprecated; use `python_version` and
    `--python_version` respectively instead. You can preview the
    removal of the deprecated names with
    --incompatible_remove_old_python_version_api. See
    [#7308](https://github.com/bazelbuild/bazel/issues/7308). 2) The
    version flag will no longer override the declared version of a
    `py_binary` or `py_test` target. You can preview this new
    behavior with --incompatible_allow_python_version_transitions.
    See [#7307](https://github.com/bazelbuild/bazel/issues/7307).

Important changes:

  - There is a new flag available
    `--experimental_java_common_create_provider_enabled_packages`
    that acts as a whitelist for usages of
    `java_common.create_provider`. The constructor will be deprecated
    in Bazel 0.23.
  - [#7024] Allow chaining of the same function type in aquery.
  - Introduces --local_{ram,cpu}_resources, which will take the place
    of --local_resources.
  - [#6930] Add documentation for the aquery command.
  - Incompatible flag `--incompatible_dont_emit_static_libgcc` has
    been flipped (https://github.com/bazelbuild/bazel/issues/6825)
  - Incompatible flag `--incompatible_linkopts_in_user_link_flags`
    has been flipped (https://github.com/bazelbuild/bazel/issues/6826)
  - Flag --incompatible_range_type is removed.
  - Flag --incompatible_disallow_slash_operator is removed.
  - Flag --incompatible_disallow_conflicting_providers is removed.
  - `--incompatible_disallow_data_transition` is now enabled by
    default
  - Allow inclusion of param files in aquery output
  - [#6985] Add test to verify aquery's behavior for Cpp action
    templates.
  - --incompatible_require_feature_configuration_for_pic was flipped
    (https://github.com/bazelbuild/bazel/issues/7007).
  - Also ignore module-info.class in multi-version Jars
  - objc_framework has been deleted. Please refer to
    apple_dynamic_framework_import and apple_static_framework_import
    rules available in
    [rules_apple](https://github.com/bazelbuild/rules_apple/blob/maste
    r/doc/rules-general.md)
  - --test_sharding_strategy=experimental_heuristic is no more
  - objc_bundle_library has been removed. Please migrate to
    rules_apple's
    [apple_resource_bundle](https://github.com/bazelbuild/rules_apple/
    blob/master/doc/rules-resources.md#apple_resource_bundle).
  - You can now use the attribute `aapt_version` or the flag
    `--android_aapt` to pick the aapt version for android_local_test
    tests
  - In --keep_going mode, Bazel now correctly returns a non-zero exit
    code when encountering a package loading error during target
    pattern parsing of patterns like "//foo:all" and "//foo/...".
  - The default value for --incompatible_strict_action_env has been
    flipped to 'false' again, as we discovered breakages for local
    execution users. We'll need some more time to figure out the best
    way to make this work for local and remote execution. Follow
    https://github.com/bazelbuild/bazel/issues/7026 for more details.
  - Locally-executed spawns tagged "no-cache" no longer upload their
    outputs to the remote cache.
  - Introduces --host_compiler flag to allow setting a compiler for
    host compilation when --host_crosstool_top is specified.
  - --incompatible_expand_directories is enabled by default
  - [aquery] Handle the case of aspect-on-aspect.
  - Fixed a longstanding bug in the http remote cache where the value
    passed to
    --remote_timeout would be interpreted as milliseconds instead of
    seconds.
  - Enable --incompatible_use_jdk10_as_host_javabase by default, see
    https://github.com/bazelbuild/bazel/issues/6661
  - Add --incompatible_use_jdk11_as_host_javabase: makes JDK 11 the
    default --host_javabase for remote jdk
    (https://github.com/bazelbuild/bazel/issues/7219)
  - Highlight TreeArtifact in aquery text output.
  - Locally-executed spawns tagged "no-cache" no longer upload their
    outputs to the remote cache.
  - java_common APIs now accept JavaToolchainInfo and JavaRuntimeInfo
    instead of configured targets for java_toolchain and java_runtime
  - cc_common.create_cc_toolchain_config_info is stable and available
    for production use
  - incompatible_use_toolchain_providers_in_java_common: pass
    JavaToolchainInfo and JavaRuntimeInfo providers to java_common
    APIs instead of configured targets
    (https://github.com/bazelbuild/bazel/issues/7186)
  - --incompatible_strict_argument_ordering is enabled by default.
  - Bazel now supports reading cache hits from a repository cache,
    even if it doesn't have write access to the cache.
  - Adding arm64e to OSX CROSSTOOL.
  - Ignore package-level licenses on config_setting.
  - Add an optional output_source_jar parameter to java_common.compile
  - --incompatible_disable_objc_provider_resources is now enabled by
    default. This disables ObjcProvider's fields related to resource
    processing.
  - Explicitly set https.protocols and exclude TLSv1.3.
  - Bazel now validates that JAVA_HOME points to a valid JDK and
    falls back to auto-detection by looking up the path of `javac`.
  - Upgrade the embedded JDK version to 11.0.2.
  - Added --incompatible_disable_crosstool_file
    (https://github.com/bazelbuild/bazel/issues/7320)
  - --incompatible_disable_objc_provider_resources is now enabled by
    default. This disables ObjcProvider's fields related to resource
    processing.
  - --incompatible_disable_tools_defaults_package has been flipped.
  - For tests that do not generate a test.xml, Bazel now uses a
    separate action to generate one; this results in minor
    differences in the generated test.xml, and makes the generation
    more reliable overall.
  - incompatible_generate_javacommon_source_jar: java_common.compile
    now always generates a source jar, see
    https://github.com/bazelbuild/bazel/issues/5824.
  - New incompatible flag
    --incompatible_disallow_struct_provider_syntax removes the
    ability for rule implementation functions to return struct. Such
    functions should return a list of providers instead. Migration
    tracking: https://github.com/bazelbuild/bazel/issues/7347

This release contains contributions from many people at Google, as well as Benjamin Peterson, Ed Schouten, erenon, George Gensure, Greg Estren, Igal Tabachnik, Ittai Zeidman, Jannis Andrija Schnitzer, John Millikin, Keith Smiley, Kelly Campbell, Max Vorobev, nicolov, Robin Nabel.

## Release 0.22.0 (2019-01-28)

```
Baseline: deb028e3fb30b4e2953df16f35ab1f55a08ea8fa

Cherry picks:

   + a3a5975dca3ad04c19dc7d063fcf490a8cd612fd:
     Fix a race condition in remote cache
   + b8d0e1b05c225a4b943ce498194d069d18093d9a:
     Use a new GitHub token and KMS key for the release process.
   + 3759e3895503aa2bbd6943c5b568b8c050b9448f:
     remote: fix unexpected IO error (not a directory)
   + 4473bb1a9ec4282aa8497b86580d68e82415df4a:
     Fix a race condition in Bazel's Windows process management.
   + 9137fb940886aa516f32ca8a36feccedb545c99b:
     undo flag flip of --incompatible_strict_action_env
   + 12ab12e80ad1c9a3510aa4bbfdf3fddafc0bca00:
     Revert "Enabling Bazel to generate input symlinks as defined by
     RE AP?
   + 6345c747d8cb1819e70c853becadbf8a989decf1:
     Automated rollback of commit
     30536baa4a410d8c0a7adab5cd58cd8a2ac7e46c.
```



The Bazel team is happy to announce a new release of Bazel,
[Bazel 0.22.0](https://github.com/bazelbuild/bazel/releases/tag/0.22.0).

Baseline: deb028e3fb30b4e2953df16f35ab1f55a08ea8fa

### Breaking changes

- [`--incompatible_string_is_not_iterable`](https://github.com/bazelbuild/bazel/issues/5830)

### Upcoming changes

This release is a [migration window for the following changes](https://github.com/bazelbuild/bazel/labels/migration-0.22).

- [`--incompatible_disallow_data_transition`](https://github.com/bazelbuild/bazel/issues/6153)
- [`--incompatible_dont_emit_static_libgcc`](https://github.com/bazelbuild/bazel/issues/6825)
- [`--incompatible_linkopts_in_user_link_flags`](https://github.com/bazelbuild/bazel/issues/6826)
- [`--incompatible_disable_legacy_crosstool_fields`](https://github.com/bazelbuild/bazel/issues/6861)
- [`--incompatible_use_aapt2_by_default`](https://github.com/bazelbuild/bazel/issues/6907)
- [`--incompatible_disable_runtimes_filegroups`](https://github.com/bazelbuild/bazel/issues/6942)
- [`--incompatible_disable_legacy_cc_provider`](https://github.com/bazelbuild/bazel/issues/7036)
- [`--incompatible_require_feature_configuration_for_pic`](https://github.com/bazelbuild/bazel/issues/7007)
- [`--incompatible_disable_expand_if_all_available_in_flag_set`](https://github.com/bazelbuild/bazel/issues/7008)
- [`--incompatible_disable_legacy_proto_provider`](https://github.com/bazelbuild/bazel/issues/7152)
- [`--incompatible_disable_proto_source_root`](https://github.com/bazelbuild/bazel/issues/7153)

### General Changes

- https://docs.bazel.build now supports versioned
  documentation. Use the selector at the top of the navigation bar
  to switch between documentation for different Bazel releases.

- set `projectId` in all `PublishBuildToolEventStreamRequest`

### Android

- mobile-install now works with aapt2. Try it out with `bazel
  mobile-install --android_aapt=aapt2 //my:target`

- Fixed issues with mobile-install v1 when deploying to Android 9 Pie
  devices. https://github.com/bazelbuild/bazel/issues/6814

- Fixed issue where error messages from Android manifest merging
  actions were not fully propagated.

- New incompatible change flag `--incompatible_use_aapt2_by_default`
  for defaulting to aapt2 in Android builds has been added. To build with
  aapt2 today, pass the flag
  `--incompatible_use_aapt2_by_default=true` or
  `--android_aapt=aapt2`, or set the `aapt_version`  to `aapt2` on
  your `android_binary` or `android_local_test` target.

- Fixed mobile-install v1 error when installing an app with native
  libraries onto an Android 9 (Pie) device. See
  https://github.com/bazelbuild/examples/issues/77

- Fixed a mobile-install bug where `arm64-v8a` libraries were not
  deployed correctly on `arm64` devices. This was done by enabling
  incremental native lib deployment by default. A previously
  undocumented `--android_incremental_native_libs` flag is removed,
  and is now the regular behavior. See
  https://github.com/bazelbuild/bazel/issues/2239

### Apple

- The `objc_bundle` rule has been removed. Please migrate to rules_apple's
  [apple_bundle_import](https://github.com/bazelbuild/rules_apple/bl
  ob/master/doc/rules-resources.md#apple_bundle_import).

- The `apple_stub_binary` rule has been deleted.

- The `--xbinary_fdo` option that passes xbinary profiles has been added.

### C++

- `cc_toolchain.(static|dynamic)_runtime_libs` attributes are now optional

### Packaging

- `build_tar.py` in `tools/build_defs/pkg` now supports a JSON manifest
  that can be used to add paths that have symbols that can't be
  specified via the command line

### Query

- Filtering of inputs, outputs, and mnemonic filtering have been added to
  aquery.

- The aquery and cquery query2 tests have been open-sourced.

- The Bazel query how-to recommends ":*" instead of ":all", because "all" might
  be the name of a target.

### Testing

- The `--runs_per_test` has been placed in the TESTING documentation category.

- A a clarifying message has been added to test case summary output when all
  test cases pass but the target fails.

### Contributors

This release contains contributions from many people at Google, as well as
Benjamin Peterson, Dave Lee, George Gensure, Gert van Dijk, Gustavo Storti
Salibi, Keith Smiley, Loo Rong Jie, Lukasz Tekieli, Mikhail Mazurskiy, Thi,
Travis Cline, Vladimir Chebotarev, and Yannic.

## Release 0.21.0 (2018-12-19)

```
Baseline: cb9b2afbba3f8d3a1db8bf68e65d06f1b36902f5

Cherry picks:

   + 12b96466ee0d6ab83f7d4cd24be110bb5021281d:
     Windows, test wrapper: rename the associated flag
   + 7fc967c4d6435de2bb4e34aac00ca2e499f55fca:
     Use a fixed thread pool in ByteStreamBuildEventArtifactUploader
   + 798b9a989aa793655d29504edb5fb85f3143db84:
     Add --build_event_upload_max_threads option
   + dbe05df23ccf4c919379e0294e0701fd3f66739c:
     Update the version of  skylib bundled in the distfile
```

Incompatible changes:

  - The --experimental_stl command line option is removed.
  - aquery defaults to human readable output format.

New features:

  - repository_ctx.download and repository_ctx.download_and_extract
    now return a struct.
  - Android Databinding v2 can be enabled with
    --experimental_android_databinding_v2.

Important changes:

  - The deprecated and unmaintained Docker rules in
    tools/build_defs/docker were removed. Please use
    https://github.com/bazelbuild/rules_docker instead.
  - The new --upload_query_output_using_bep query/cquery/aquery flag
    causes query outputs to be uploaded via BEP.
  - New incompatible flag --incompatible_strict_argument_ordering
  - --strict_android_deps and --strict_java_deps were renamed to
    --experimental_strict_java_deps
  - config_settings that select on "compiler" value instead of values
    = {"compiler" : "x"} should use flag_values =
    {"@bazel_tools//tools/cpp:compiler": "x"}.
  - The new --upload_query_output_using_bep query/cquery/aquery flag
    causes query outputs to be uploaded via BEP.
  - Turn on --incompatible_disable_sysroot_from_configuration
  - We revamped our Android with Bazel tutorial! Check it out
    [here](https://docs.bazel.build/versions/master/tutorial/android-a
    pp.html).
  - --incompatible_disallow_slash_operator is now on by default
  - Enable --experimental_check_desugar_deps by default.  This flag
    rules out several types of invalid Android builds at compile-time.
  - The --max_config_changes_to_show option lists the names of
    options which
    have changed and thus caused the analysis cache to be dropped.
  - The --experimental_strict_action_env option has been renamed to
    --incompatible_strict_action_env and is now on by default. This
    means Bazel will no longer use the client's PATH and
    LD_LIBRARY_PATH environmental variables in the default action
    environment. If the old behavior is desired, pass
    --action_env=PATH and --action_env=LD_LIBRARY_PATH.
    --noincompatible_strict_action_env will also temporarily restore
    the old behavior. However, as --action_env is a more general and
    explicit way to pass client environmental variables into actions,
    --noincompatible_strict_action_env will eventually be deprecated
    and removed. See #6648 for more details.
  - XCRUNWRAPPER_LABEL has been removed. If you used this value
    before, please use @bazel_tools//tools/objc:xcrunwrapper instead.
  - --incompatible_static_name_resolution is no unable by default
  - We will phase out --genrule_strategy in favor of
    --strategy=Genrule=<value> (for genrules) or
    --spawn_strategy=<value> (for all actions).
  - --incompatible_package_name_is_a_function is now enabled by
    default
  - Dynamic execution is now available with
    --experimental_spawn_strategy. Dynamic execution allows a build
    action to run locally and remotely simultaneously, and Bazel
    picks the fastest action. This provides the best of both worlds:
    faster clean builds than pure local builds, and faster
    incremental builds than pure remote builds.
  - --incompatible_package_name_is_a_function is now enabled by
    default
  - New incompatible flag --incompatible_merge_genfiles_directory
  - grpc log now logs updateActionResult
  - CppConfiguration doesn't do package loading anymore. That means:
    * it's no longer needed to have C++ toolchain available when
    building non-C++ projects
    * bazel will not analyze C++ toolchain when not needed -> speedup
    ~2s on bazel startup when C++ rules using hermetic toolchain are
    not loaded
  - --incompatible_package_name_is_a_fu...

This release contains contributions from many people at Google, as well as andy g scott ?, Attila Ol?h, Benjamin Peterson, Clint Harrison, Dave Lee, Ed Schouten, Greg Estren, Gregor Jasny, Jamie Snape, Jerry Marino, Loo Rong Jie, Or Shachar, Sevki Hasirci, William Chargin.

## Release 0.20.0 (2018-11-30)

```
Baseline: 7bf7f031c332dc483257248d1c1f98ad75bbc83b

Cherry picks:

   + fd52341505e725487c6bc6dfbe6b5e081aa037da:
     update bazel-toolchains pin to latest release Part of changes to
     allow bazelci to use 0.19.0 configs. RBE toolchain configs at or
     before 0.17.0 are not compatible with bazel 0.19.0 or above.
   + 241f28d05424db2d11ee245dc856b992258505e3:
     Revert "Toggle --incompatible_disable_late_bound_option_defaults
     flag."
   + f7e5aef145c33968f658eb2260e25630dc41cc67:
     Add cc_toolchain targets for the new entries in the default
     cc_toolchain_suite.
   + d2920e32ec7f3f8551a693d33c17b19f1b802145:
     Revert "WindowsFileSystem: open files with delete-sharing"
```

[Breaking changes in 0.20](https://github.com/bazelbuild/bazel/issues?q=is%3Aissue+label%3Abreaking-change-0.20)

  - [--incompatible_remove_native_http_archive](https://github.com/bazelbuild/bazel/issues/6570).
  - [--incompatible_remove_native_git_repository](https://github.com/bazelbuild/bazel/issues/6569).
  - [--incompatible_disable_cc_toolchain_label_from_crosstool_proto](https://github.com/bazelbuild/bazel/issues/6434).
  - [--incompatible_disable_depset_in_cc_user_flags](https://github.com/bazelbuild/bazel/issues/6384).
  - [--incompatible_disable_cc_configuration_make_variables](https://github.com/bazelbuild/bazel/issues/6381).
  - [--incompatible_disallow_conflicting_providers](https://github.com/bazelbuild/bazel/issues/5902).
  - [--incompatible_range_type](https://github.com/bazelbuild/bazel/issues/5264).

[0.20 is a migration window for the following changes](https://github.com/bazelbuild/bazel/issues?q=is%3Aissue+label%3Amigration-0.20)

  - [--incompatible_use_jdk10_as_host_javabase](https://github.com/bazelbuild/bazel/issues/6661)
  - [--incompatible_use_remotejdk_as_host_javabase](https://github.com/bazelbuild/bazel/issues/6656)
  - [--incompatible_disable_sysroot_from_configuration](https://github.com/bazelbuild/bazel/issues/6565)
  - [--incompatible_provide_cc_toolchain_info_from_cc_toolchain_suite](https://github.com/bazelbuild/bazel/issues/6537)
  - [--incompatible_disable_depset_in_cc_user_flags](https://github.com/bazelbuild/bazel/issues/6383)
  - [--incompatible_package_name_is_a_function](https://github.com/bazelbuild/bazel/issues/5827)

[Breaking changes in the next release (0.21)](https://github.com/bazelbuild/bazel/issues?q=is%3Aissue+label%3Abreaking-change-0.21)

  - [--incompatible_use_jdk10_as_host_javabase](https://github.com/bazelbuild/bazel/issues/6661)
  - [--incompatible_use_remotejdk_as_host_javabase](https://github.com/bazelbuild/bazel/issues/6656)
  - [--incompatible_disable_sysroot_from_configuration](https://github.com/bazelbuild/bazel/issues/6565)
  - [--incompatible_provide_cc_toolchain_info_from_cc_toolchain_suite](https://github.com/bazelbuild/bazel/issues/6537)
  - [--incompatible_disable_depset_in_cc_user_flags](https://github.com/bazelbuild/bazel/issues/6383)
  - [--incompatible_disallow_data_transition](https://github.com/bazelbuild/bazel/issues/6153)
  - [--incompatible_package_name_is_a_function](https://github.com/bazelbuild/bazel/issues/5827)
  - [--incompatible_disallow_slash_operator](https://github.com/bazelbuild/bazel/issues/5823)
  - [--incompatible_static_name_resolution](https://github.com/bazelbuild/bazel/issues/5637)

Incompatible changes:

  - the --experimental_no_dotd_scanning_with_modules command line
    argument is not supported anymore.
  - The --prune_cpp_modules command line option is not supported
    anymore.
  - the --experimental_prune_cpp_input_discovery command line option
    is not supported anymore.

New features:

  - Added support for Android NDK r18.

Important changes:

  - The 'default' parameter of attr.output and attr.output_list is
    removed. This is controlled by
    --incompatible_no_output_attr_default
  - A number of platform-related Starlark APIs which were previously
    marked "experimental" are now disabled by default, and may be
    enabled via --experimental_platforms_api
  - Make legacy-test-support ("legacy_test-<api-level>") from
    android_sdk_repository neverlink. The legacy test support
    libraries shouldn't be built into test binaries. To make them
    available at runtime, developers should declare them via
    uses-library:
    https://developer.android.com/training/testing/set-up-project#andr
    oid-test-base
  - query remote server Capabilities (per REAPI v2)
  - CppRules: All cc_toolchains depended on from
    cc_toolchain_suite.toolchains are now analyzed when not using
    platforms in order to select the right cc_toolchain.
  - removed obsolete --explicit_jre_deps flag.
  - Incompatible flag
    --incompatible_disable_legacy_cpp_toolchain_skylark_api was
    flipped.
  - Improve error messaging when unsupport proguard options are
    specified at the library level.
  - Incompatible flag
    --incompatible_disable_legacy_cpp_toolchain_skylark_api was
    flipped.
  - Incompatible flag
    --incompatible_disable_legacy_cpp_toolchain_skylark_api was
    flipped.
  - The --incompatible_disable_late_bound_option_defaults flag has
    been flipped (#6384)
  - Incompatible flag
    --incompatible_disable_legacy_flags_cc_toolchain_api was flipped
    (#6434)
  - Fixed issue where ctx.resolve_command created conflicting
    intermediate files when resolve_command was called multiple times
    within the same rule invocation with a long command attribute.
  - Incompatible flag
    --incompatible_disable_cc_configuration_make_variables was
    flipped (#6381)
  - If the --javabase flag is unset, it Bazel locates a JDK using
    the JAVA_HOME environment variable and searching the PATH. If no
    JDK is found --javabase will be empty, and builds targeting Java
    will not
    be supported. Previously Bazel would fall back to using the
    embedded
    JDK as a --javabase, but this is no longer default behaviour. A
    JDK should
    be explicitly installed instead to enable Java development
  - Bazel will now shut down when idle for 5 minutes and the system
    is low on RAM (linux only).
  - CROSSTOOL file is now read from the package of cc_toolchain, not
    from
    the package of cc_toolchain_suite. This is not expected to break
    anybody since
    cc_toolchain_suite and cc_toolchain are commonly in the same
    package.
  - All overrides of Starlark's ctx.new_file function are now
    deprecated.
      Try the `--incompatible_new_actions_api` flag to ensure your
    code is forward-compatible.
  - --incompatible_disable_cc_toolchain_label_from_crosstool_proto
    was flipped.
  - Introduce --(no)shutdown_on_low_sys_mem startup flag to toggle
    idle low-memory shutdown, disabled by default.
  - --incompatible_disable_cc_toolchain_label_from_crosstool_proto
    was flipped.
  - --incompatible_disable_cc_toolchain_label_from_crosstool_proto
    was flipped.
  - CppRules: All cc_toolchains depended on from
    cc_toolchain_suite.toolchains are now analyzed when not using
    platforms in order to select the right cc_toolchain.
  - The function `attr.license` is deprecated and will be removed.
      It can be disabled now with `--incompatible_no_attr_license`.
  - `range()` function now returns a lazy value
    (`--incompatible_range_type` is now set by default).
  - The code coverage report now includes the actual paths to header
    files instead of the ugly,
    Bazel generated, virtual includes path.
  - `--incompatible_disallow_conflicting_providers` has been switched
    to true
  - Add new flag `--incompatible_disable_systool_from_configration` to
    disable loading the systool from CppConfiguration.
  - Add new flag `--incompatible_disable_sysroot_from_configuration`
    to
    disable loading the systool from CppConfiguration.
  - Sorting remote Platform properties for remote execution. May
    affect cache keys!
  - Use different server log files per Bazel server process; java.log
    is
    now a symlink to the latest log.

This release contains contributions from many people at Google, as well as a7g4 <a7g4@a7g4.net>, Alan <alan.agius@betssongroup.com>, Asaf Flescher <asafflesch@gmail.com>, Benjamin Peterson <bp@benjamin.pe>, Ed Schouten <ed.schouten@prodrive-technologies.com>, George Gensure <ggensure@uber.com>, George Kalpakas <kalpakas.g@gmail.com>, Greg <gregestren@users.noreply.github.com>, Irina Iancu <iirina@users.noreply.github.com>, Keith Smiley <keithbsmiley@gmail.com>, Loo Rong Jie <loorongjie@gmail.com>, Mark Zeren <mzeren@vmware.com>, Petros Eskinder <petroseskinder@users.noreply.github.com>, rachcatch <rachelcatchpoole@hotmail.com>, Robert Brown <robert.brown@gmail.com>, Robert Gay <robert.gay@redfin.com>, Salty Egg <2281521+zhouhao@users.noreply.github.com>.

## Release 0.19.2 (2018-11-19)

```
Baseline: ac880418885061d1039ad6b3d8c28949782e02d6

Cherry picks:

   + 9bc3b20053a8b99bf2c4a31323a7f96fabb9f1ec:
     Fix the "nojava" platform and enable full presubmit checks for
     the various JDK platforms now that we have enough GCE resources.
   + 54c2572a8cabaf2b29e58abe9f04327314caa6a0:
     Add openjdk_linux_archive java_toolchain for nojava platform.
   + 20bfdc67dc1fc32ffebbda7088ba49ee17e3e182:
     Automated rollback of commit
     19a401c38e30ebc0879925a5caedcbe43de0028f.
   + 914b4ce14624171a97ff8b41f9202058f10d15b2:
     Windows: Fix Precondition check for addDynamicInputLinkOptions
   + 83d406b7da32d1b1f6dd02eae2fe98582a4556fd:
     Windows, test-setup.sh: Setting RUNFILES_MANIFEST_FILE only when
     it exists.
   + e025726006236520f7e91e196b9e7f139e0af5f4:
     Update turbine
   + 5f312dd1678878fb7563eae0cd184f2270346352:
     Fix event id for action_completed BEP events
   + f0c844c77a2406518c4e75c49188390d5e281d3d:
     Release 0.19.0 (2018-10-29)
   + c3fb1db9e4e817e8a911f5b347b30f2674a82f7c:
     Do not use CROSSTOOL to select cc_toolchain
   + 8e280838e8896a6b5eb5421fda435b96b6f8de60:
     Windows Add tests for msys gcc toolchain and mingw gcc toolchain
   + fd52341505e725487c6bc6dfbe6b5e081aa037da:
     update bazel-toolchains pin to latest release Part of changes to
     allow bazelci to use 0.19.0 configs. RBE toolchain configs at or
     before 0.17.0 are not compatible with bazel 0.19.0 or above.
   + eb2af0f699350ad187048bf814a95af23f562c77:
     Release 0.19.1 (2018-11-12)
   + 6bc452874ddff69cbf7f66186238032283f1195f:
     Also update cc_toolchain.toolchain_identifier when
     CC_TOOLCHAIN_NAME is set
   + f7e5aef145c33968f658eb2260e25630dc41cc67:
     Add cc_toolchain targets for the new entries in the default
     cc_toolchain_suite.
   + 683c302129b66a8999f986be5ae7e642707e978c:
     Read the CROSSTOOL from the package of the current cc_toolchain,
     not from --crosstool_top
```

- Fixes regression #6662, by fixing tools/cpp/BUILD
- Fixes regression #6665, by setting the toolchain identifier.
- CROSSTOOL file is now read from the package of cc_toolchain, not from the
  package of cc_toolchain_suite. This is not expected to break anybody since
  cc_toolchain_suite and cc_toolchain are commonly in the same package.

## Release 0.19.1 (2018-11-12)

```
Baseline: ac880418885061d1039ad6b3d8c28949782e02d6

Cherry picks:

   + 9bc3b20053a8b99bf2c4a31323a7f96fabb9f1ec:
     Fix the "nojava" platform and enable full presubmit checks for
     the various JDK platforms now that we have enough GCE resources.
   + 54c2572a8cabaf2b29e58abe9f04327314caa6a0:
     Add openjdk_linux_archive java_toolchain for nojava platform.
   + 20bfdc67dc1fc32ffebbda7088ba49ee17e3e182:
     Automated rollback of commit
     19a401c38e30ebc0879925a5caedcbe43de0028f.
   + 914b4ce14624171a97ff8b41f9202058f10d15b2:
     Windows: Fix Precondition check for addDynamicInputLinkOptions
   + 83d406b7da32d1b1f6dd02eae2fe98582a4556fd:
     Windows, test-setup.sh: Setting RUNFILES_MANIFEST_FILE only when
     it exists.
   + e025726006236520f7e91e196b9e7f139e0af5f4:
     Update turbine
   + 5f312dd1678878fb7563eae0cd184f2270346352:
     Fix event id for action_completed BEP events
   + f0c844c77a2406518c4e75c49188390d5e281d3d:
     Release 0.19.0 (2018-10-29)
   + c3fb1db9e4e817e8a911f5b347b30f2674a82f7c:
     Do not use CROSSTOOL to select cc_toolchain
   + 8e280838e8896a6b5eb5421fda435b96b6f8de60:
     Windows Add tests for msys gcc toolchain and mingw gcc toolchain
   + fd52341505e725487c6bc6dfbe6b5e081aa037da:
     update bazel-toolchains pin to latest release Part of changes to
     allow bazelci to use 0.19.0 configs. RBE toolchain configs at or
     before 0.17.0 are not compatible with bazel 0.19.0 or above.
```

Important changes:
- Fix regression #6610, which prevents using the MINGW compiler on Windows.

## Release 0.19.0 (2018-10-29)

```
Baseline: ac880418885061d1039ad6b3d8c28949782e02d6

Cherry picks:

   + 9bc3b20053a8b99bf2c4a31323a7f96fabb9f1ec:
     Fix the "nojava" platform and enable full presubmit checks for
     the various JDK platforms now that we have enough GCE resources.
   + 54c2572a8cabaf2b29e58abe9f04327314caa6a0:
     Add openjdk_linux_archive java_toolchain for nojava platform.
   + 20bfdc67dc1fc32ffebbda7088ba49ee17e3e182:
     Automated rollback of commit
     19a401c38e30ebc0879925a5caedcbe43de0028f.
   + 914b4ce14624171a97ff8b41f9202058f10d15b2:
     Windows: Fix Precondition check for addDynamicInputLinkOptions
   + 83d406b7da32d1b1f6dd02eae2fe98582a4556fd:
     Windows, test-setup.sh: Setting RUNFILES_MANIFEST_FILE only when
     it exists.
   + e025726006236520f7e91e196b9e7f139e0af5f4:
     Update turbine
   + 5f312dd1678878fb7563eae0cd184f2270346352:
     Fix event id for action_completed BEP events
```

The Bazel team is happy to announce a new version of Bazel, [Bazel 0.19](https://github.com/bazelbuild/bazel/releases/tag/0.19.0).

This document lists the major changes since Bazel 0.18.

General changes
---------------

* The `--incompatible_expand_directories` flag will automatically expand directories in command lines. Design doc: https://docs.google.com/document/d/11agWFiOUiz2htBLj6swPTob5z78TrCxm8DQE4uJLOwM

* The `--loading_phase_threads` flag now defaults to `auto` (not 200, as was previously the case), which at the moment corresponds to the number of CPUs. This is appropriate for most users. However, if your sources reside on a network file system, increasing this value may yield better analysis-time performance when disk caches are cold.

Android
-------

* Fixed missing debug symbols when building native code with `--compilation_mode=dbg` that target Android ARM architectures by adding the `-g` flag.

C++
---

* Added `--incompatible_disable_legacy_flags_cc_toolchain_api` to deprecate legacy `cc_toolchain` Starlark API for legacy CROSSTOOL fields. Tracking issue is #6434. Migration docs are on the bazel website.

* Runfiles in cc_test: the C++ runfiles library (`@bazel_tools//tools/cpp/runfiles`) can now create Runfiles objects for tests. See `//tools/cpp/runfiles/runfiles_src.h` (in the Bazel source tree) for documentation.

* :cc_binary link action no longer hardcodes `-static-libgcc` for toolchains that support embedded runtimes (guarded by `--experimental_dont_emit_static_libgcc` temporarily).

* The flag `--experimental_enable_cc_configuration_make_variables` is removed, use `--incompatible_disable_cc_configuration_make_variables` instead.

Java
----

* If the `--javabase` flag is unset, Bazel locates a JDK using the `JAVA_HOME` environment variable and searching the PATH. If no JDK is found `--javabase` will be empty, and builds targeting Java will not be supported.  Previously Bazel would fall back to using the embedded JDK as a `--javabase`, but this is no longer default behaviour. A JDK should be explicitly installed instead to enable Java development.

Code Coverage
-------------

* LcovMerger was renamed to CoverageOutputGenerator.

* Faster coverage collection for gcc compiled C++ code can now be tested by enabling it with `--experimental_cc_coverage`.

Other Changes
-------------

* Add `--apple_compiler` and `--apple_grte_top options`. These provide the equivalent of --compiler / --grte_top for the toolchain configured in --apple_crosstool_top.

* There is now a `same_pkg_direct_rdeps` query function. See the query documentation for more details.

* Propagating remote errors to the user even if `--verbose_failures=false` is set.

* Add number of configured targets to analysis phase status output.

* Bazel will now check stderr instead of stdout to decide if it is outputting to a terminal.  `--isatty` is deprecated, use `--is_stderr_atty` instead.

Future Changes
--------------

* None of the C++ related incompatible flags mentioned in the 0.18 release were flipped, they will be flipped in the next release (0.20). We have created tracking issues for all the relevant incompatible flags:
    * [`--incompatible_disable_late_bound_option_defaults`](https://docs.bazel.build/versions/master/skylark/backward-compatibility.html#disable-late-bound-option-defaults): #6384
    * [`--incompatible_disable_depset_in_cc_user_flags`](https://docs.bazel.build/versions/master/skylark/backward-compatibility.html#disable-depsets-in-c-toolchain-api-in-user-flags): #6383
    * [`--incompatible_disable_cc_toolchain_label_from_crosstool_proto`](https://docs.bazel.build/versions/master/skylark/backward-compatibility.html#disallow-using-crosstool-to-select-the-cc_toolchain-label): #6382
    * [`--incompatible_disable_cc_configuration_make_variables`](https://github.com/bazelbuild/bazel/issues/6381): #6381
    * [`--incompatible_disable_legacy_cpp_toolchain_skylark_api`](https://docs.bazel.build/versions/master/skylark/backward-compatibility.html#disable-legacy-c-configuration-api): #6380
    * [`incompatible_disable_legacy_flags_cc_toolchain_api`](https://docs.bazel.build/versions/master/skylark/backward-compatibility.html#disable-legacy-c-toolchain-api): #6434

* In the 0.20 release the flags [`--incompatible_remove_native_git_repository`](https://docs.bazel.build/versions/master/skylark/backward-compatibility.html#remove-native-git-repository) and [`--incompatible_remove_native_http_archive`](https://docs.bazel.build/versions/master/skylark/backward-compatibility.html#remove-native-http-archive) will be turned on.

Thank you to our contributors!
------------------------------

This release contains contributions from many people at Google, as well as Andreas Herrmann, Andreas Hippler, Benjamin Peterson, David Ostrovsky, Ed Baunton, George Gensure, Igal Tabachnik, Jason Gavris, Loo Rong Jie, rmalik, and Yannic Bonenberger

Thank you to everyone who contributed to this release!

## Release 0.18.1 (2018-10-31)

```
Baseline: c062b1f1730f3562d5c16a037b374fc07dc8d9a2

Cherry picks:

   + 2834613f93f74e988c51cf27eac0e59c79ff3b8f:
     Include also ext jars in the bootclasspath jar.
   + 2579b791c023a78a577e8cb827890139d6fb7534:
     Fix toolchain_java9 on --host_javabase=<jdk9> after
     7eb9ea150fb889a93908d96896db77d5658e5005
   + faaff7fa440939d4367f284ee268225a6f40b826:
     Release notes: fix markdown
   + b073a18e3fac05e647ddc6b45128a6158b34de2c:
     Fix NestHost length computation Fixes #5987
   + bf6a63d64a010f4c363d218e3ec54dc4dc9d8f34:
     Fixes #6219. Don't rethrow any remote cache failures on either
     download or upload, only warn. Added more tests.
   + c1a7b4c574f956c385de5c531383bcab2e01cadd:
     Fix broken IdlClassTest on Bazel's CI.
   + 71926bc25b3b91fcb44471e2739b89511807f96b:
     Fix the Xcode version detection which got broken by the upgrade
     to Xcode 10.0.
   + 86a8217d12263d598e3a1baf2c6aa91b2e0e2eb5:
     Temporarily restore processing of workspace-wide tools/bazel.rc
     file.
   + 914b4ce14624171a97ff8b41f9202058f10d15b2:
     Windows: Fix Precondition check for addDynamicInputLinkOptions
   + e025726006236520f7e91e196b9e7f139e0af5f4:
     Update turbine
```

Important changes:

  - Fix regression #6219, remote cache failures

## Release 0.18.0 (2018-10-15)

```
Baseline: c062b1f1730f3562d5c16a037b374fc07dc8d9a2

Cherry picks:

   + 2834613f93f74e988c51cf27eac0e59c79ff3b8f:
     Include also ext jars in the bootclasspath jar.
   + 2579b791c023a78a577e8cb827890139d6fb7534:
     Fix toolchain_java9 on --host_javabase=<jdk9> after
     7eb9ea150fb889a93908d96896db77d5658e5005
   + faaff7fa440939d4367f284ee268225a6f40b826:
     Release notes: fix markdown
   + b073a18e3fac05e647ddc6b45128a6158b34de2c:
     Fix NestHost length computation Fixes #5987
   + bf6a63d64a010f4c363d218e3ec54dc4dc9d8f34:
     Fixes #6219. Don't rethrow any remote cache failures on either
     download or upload, only warn. Added more tests.
   + c1a7b4c574f956c385de5c531383bcab2e01cadd:
     Fix broken IdlClassTest on Bazel's CI.
   + 71926bc25b3b91fcb44471e2739b89511807f96b:
     Fix the Xcode version detection which got broken by the upgrade
     to Xcode 10.0.
   + 86a8217d12263d598e3a1baf2c6aa91b2e0e2eb5:
     Temporarily restore processing of workspace-wide tools/bazel.rc
     file.
```

General changes

- New [bazelrc file list](https://docs.bazel.build/versions/master/user-manual.html#where-are-the-bazelrc-files).
  If you need to keep both the old and new lists of .rc files active
  concurrently to support multiple versions of Bazel, you can import the old
  file location into the new list using `try-import`. This imports a file if it
  exists and silently exits if it does not. You can use this method to account
  for a user file that may or may not exist

- [.bazelignore](https://docs.bazel.build/versions/master/user-manual.html#.bazelignore)
  is now fully functional.

- The startup flag `--host_javabase` has been renamed to
  `--server_javabase` to avoid confusion with the build flag
  `--host_javabase`.

Android

- The Android resource processing pipeline now supports persistence
  via worker processes. Enable it with
  `--persistent_android_resource_processor`. We have observed a 50% increase
  in build speed for clean local builds and up to 150% increase in build
  speed for incremental local builds.

C++

- In-memory package //tools/defaults has been removed (controlled by
  `--incompatible_disable_tools_defaults_package` flag). Please see
  [migration instructions](https://docs.bazel.build/versions/master/skylark/backward-compatibility.html#disable-inmemory-tools-defaults-package)
  and migrate soon, the flag will be flipped in Bazel 0.19, and the legacy
  behavior will be removed in Bazel 0.20.

- Late bound option defaults (typical example was the `--compiler` flag, when
  it was not specified, it’s value was computed using the CROSSTOOL) are removed
  (controlled by `--incompatible_disable_late_bound_option_defaults` flag).
  Please see [migration instructions](https://docs.bazel.build/versions/master/skylark/backward-compatibility.html#disable-late-bound-option-defaults)
  and migrate soon, the flag will be flipped in Bazel 0.19, and the legacy
  behavior will be removed in Bazel 0.20.

- Depsets are no longer accepted in `user_compile_flags` and `user_link_flags`
  in the C++ toolchain API (controlled by
  `--incompatible_disable_depset_in_cc_user_flags` flag) affects C++ users.
  Please see [migration instructions](https://docs.bazel.build/versions/master/skylark/backward-compatibility.html#disable-depsets-in-c-toolchain-api-in-user-flags)
  and migrate soon, the flag will be flipped in Bazel 0.19, and the legacy
  behavior will be removed in Bazel 0.20.

- CROSSTOOL is no longer consulted when selecting C++ toolchain (controlled by
  `--incompatible_disable_cc_toolchain_label_from_crosstool_proto` flag).
  Please see [migration instructions](https://docs.bazel.build/versions/master/skylark/backward-compatibility.html#disallow-using-crosstool-to-select-the-cc_toolchain-label)
  and migrate soon, the flag will be flipped in Bazel 0.19, and the legacy behavior will be removed in Bazel 0.20.

- You can now use [`toolchain_identifier` attribute](https://github.com/bazelbuild/bazel/commit/857d4664ce939f240b1d10d8d2baca6c6893cfcb)
  on `cc_toolchain` to pair it with CROSSTOOL toolchain.

- C++ specific Make variables
  are no longer passed from the `CppConfiguration`, but from the C++ toolchain
  (controlled by `--incompatible_disable_cc_configuration_make_variables` flag).
  Please see [migration instructions](https://docs.bazel.build/versions/master/skylark/backward-compatibility.html#disallow-using-c-specific-make-variables-from-the-configuration)
  and migrate soon, the flag will be flipped
  in Bazel 0.19, and the legacy behavior will be removed in Bazel 0.20.

- Skylark api accessing C++
  toolchain in `ctx.fragments.cpp` is removed (controlled by
  `--incompatible_disable_legacy_cpp_toolchain_skylark_api` flag).
  Please migrate soon, the flag will be flipped
  in Bazel 0.19, and the legacy behavior will be removed in Bazel 0.20.

- cc_binary link action no longer hardcodes
  `-static-libgcc` for toolchains that support embedded runtimes
  (guarded by [`--experimental_dont_emit_static_libgcc`](https://source.bazel.build/bazel/+/2f281960b829e964526a9d292d4c3003e4d19f1c)
  temporarily). Proper deprecation using `--incompatible` flags will follow.

Java

- Future versions of Bazel will require a locally installed JDK
  for Java development. Previously Bazel would fall back to using
  the embedded `--server_javabase` if no JDK as available. Pass
  `--incompatible_never_use_embedded_jdk_for_javabase` to disable the
  legacy behaviour.

- `--javacopt=` no longer affects compilations of tools that are
  executed during the build; use `--host_javacopt=` to change javac
  flags in the host configuration.

Objective C

- `objc_library` now supports the module_name attribute.

Skylark

- Adds `--incompatible_expand_directories` to automatically expand
  directories in skylark command lines. Design doc:
  https://docs.google.com/document/d/11agWFiOUiz2htBLj6swPTob5z78TrCxm8DQE4uJLOwM

- Support fileset expansion in ctx.actions.args(). Controlled by
  `--incompatible_expand_directories`.

Windows

- `--windows_exe_launcher` is deprecated, this flag will be removed
  soon. Please make sure you are not using it.

- Bazel now supports the symlink runfiles tree on Windows with
  `--experimental_enable_runfiles` flag. For more details, see
  [this doc](https://docs.google.com/document/d/1hnYmU1BmtCSJOUvvDAK745DSJQCapToJxb3THXYMrmQ).

Other Changes

- A new experimental option `--experimental_ui_deduplicate` has been added. It
  causes the UI to attempt to deduplicate messages from actions to keep the
  console output cleaner.

- Add `--modify_execution_info`, a flag to customize action execution
  info.

- Add ExecutionInfo to aquery output for ExecutionInfoSpecifier
  actions.

- When computing `--instrumentation_filter`, end filter patterns with
  "[/:]" to match non-top-level packages exactly and treat
  top-level targets consistently.

- Added the `bazel info server_log` command, which obtains the main Bazel
  server log file path. This can help debug Bazel issues.

- `aapt shrink` resources now properly respect filter configurations.

## Release 0.17.2 (2018-09-21)

```
Baseline: aa118ca818baf722aede0bc48d0a17584fa45b6e

Cherry picks:
   + 0e0462589528154cb5160411991075a2000b5452:
     Update checker framework dataflow and javacutil versions
   + 3987300d6651cf0e6e91b395696afac6913a7d66:
     Stop using --release in versioned java_toolchains
   + 438b2773b8c019afa46be470b90bcf70ede7f2ef:
     make_deb: Add new empty line in the end of conffiles file
   + 504401791e0a0e7e3263940e9e127f74956e7806:
     Properly mark configuration files in the Debian package.
   + 9ed9d8ac4347408d15c8fce7c9c07e5c8e658b30:
     Add flag
     --incompatible_symlinked_sandbox_expands_tree_artifacts_in_runfil
     es_tree.
   + 22d761ab42dfb1b131f1facbf490ccdb6c17b89c:
     Update protobuf to 3.6.1 -- add new files
   + 27303d79c38f2bfa3b64ee7cd7a6ef03a9a87842:
     Update protobuf to 3.6.1 -- update references
   + ddc97ed6b0367eb443e3e09a28d10e65179616ab:
     Update protobuf to 3.6.1 -- remove 3.6.0 sources
   + ead1002d3803fdfd4ac68b4b4872076b19d511a2:
     Fix protobuf in the WORKSPACE
   + 12dcd35ef7a26d690589b0fbefb1f20090cbfe15:
     Revert "Update to JDK 10 javac"
   + 7eb9ea150fb889a93908d96896db77d5658e5005:
     Automated rollback of
     https://github.com/bazelbuild/bazel/commit/808ec9ff9b5cec14f23a4b
     a106bc5249cacc8c54 and
     https://github.com/bazelbuild/bazel/commit/4c9149d558161e7d3e363f
     b697f5852bc5742a36 and some manual merging.
   + 4566a428c5317d87940aeacfd65f1018340e52b6:
     Fix tests on JDK 9 and 10
   + 1e9f0aa89dad38eeab0bd40e95e689be2ab6e5e5:
     Fix more tests on JDK 9 and 10
   + a572c1cbc8c26f625cab6716137e2d57d05cfdf3:
     Add ubuntu1804_nojava, ubuntu1804_java9, ubuntu1804_java10 to
     postsubmit.
   + 29f1de099e4f6f0f50986aaa4374fc5fb7744ee8:
     Disable Android shell tests on the "nojava" platform.
   + b495eafdc2ab380afe533514b3bcd7d5b30c9935:
     Update bazel_toolchains to latest release.
   + 9323c57607d37f9c949b60e293b573584906da46:
     Windows: fix writing java.log
   + 1aba9ac4b4f68b69f2d91e88cfa8e5dcc7cb98c2:
     Automated rollback of commit
     de22ab0582760dc95f33e217e82a7b822378f625.
   + 2579b791c023a78a577e8cb827890139d6fb7534:
     Fix toolchain_java9 on --host_javabase=<jdk9> after
     7eb9ea150fb889a93908d96896db77d5658e5005
   + 2834613f93f74e988c51cf27eac0e59c79ff3b8f:
     Include also ext jars in the bootclasspath jar.
   + fdb09a260dead1e1169f94584edc837349a4f4a5:
     Release 0.17.1 (2018-09-14)
   + 1d956c707e1c843896ac58a341c335c9c149073d:
     Do not fail the build when gcov is not installed
   + 2e677fb6b8f309b63558eb13294630a91ee0cd33:
     Ignore unrecognized VM options in desugar.sh, such as the JVM 9
     flags to silence warnings.
```

Important changes:

  - In the future, Bazel will expand tree artifacts in runfiles, too,
    which causes the sandbox to link each file individually into the
    sandbox directory, instead of symlinking the entire directory. In
    this release, the behavior is not enabled by default yet. Please
    try it out via
    --incompatible_symlinked_sandbox_expands_tree_artifacts_in_runfile
    s_tree and let us know if it causes issues. If everything looks
    good, this behavior will become the default in a following
    release.

## Release 0.17.1 (2018-09-14)

```
Baseline: aa118ca818baf722aede0bc48d0a17584fa45b6e

Cherry picks:
   + 0e0462589528154cb5160411991075a2000b5452:
     Update checker framework dataflow and javacutil versions
   + 3987300d6651cf0e6e91b395696afac6913a7d66:
     Stop using --release in versioned java_toolchains
   + 438b2773b8c019afa46be470b90bcf70ede7f2ef:
     make_deb: Add new empty line in the end of conffiles file
   + 504401791e0a0e7e3263940e9e127f74956e7806:
     Properly mark configuration files in the Debian package.
   + 9ed9d8ac4347408d15c8fce7c9c07e5c8e658b30:
     Add flag
     --incompatible_symlinked_sandbox_expands_tree_artifacts_in_runfil
     es_tree.
   + 22d761ab42dfb1b131f1facbf490ccdb6c17b89c:
     Update protobuf to 3.6.1 -- add new files
   + 27303d79c38f2bfa3b64ee7cd7a6ef03a9a87842:
     Update protobuf to 3.6.1 -- update references
   + ddc97ed6b0367eb443e3e09a28d10e65179616ab:
     Update protobuf to 3.6.1 -- remove 3.6.0 sources
   + ead1002d3803fdfd4ac68b4b4872076b19d511a2:
     Fix protobuf in the WORKSPACE
   + 12dcd35ef7a26d690589b0fbefb1f20090cbfe15:
     Revert "Update to JDK 10 javac"
   + 7eb9ea150fb889a93908d96896db77d5658e5005:
     Automated rollback of
     https://github.com/bazelbuild/bazel/commit/808ec9ff9b5cec14f23a4b
     a106bc5249cacc8c54 and
     https://github.com/bazelbuild/bazel/commit/4c9149d558161e7d3e363f
     b697f5852bc5742a36 and some manual merging.
   + 4566a428c5317d87940aeacfd65f1018340e52b6:
     Fix tests on JDK 9 and 10
   + 1e9f0aa89dad38eeab0bd40e95e689be2ab6e5e5:
     Fix more tests on JDK 9 and 10
   + a572c1cbc8c26f625cab6716137e2d57d05cfdf3:
     Add ubuntu1804_nojava, ubuntu1804_java9, ubuntu1804_java10 to
     postsubmit.
   + 29f1de099e4f6f0f50986aaa4374fc5fb7744ee8:
     Disable Android shell tests on the "nojava" platform.
   + b495eafdc2ab380afe533514b3bcd7d5b30c9935:
     Update bazel_toolchains to latest release.
   + 9323c57607d37f9c949b60e293b573584906da46:
     Windows: fix writing java.log
   + 1aba9ac4b4f68b69f2d91e88cfa8e5dcc7cb98c2:
     Automated rollback of commit
     de22ab0582760dc95f33e217e82a7b822378f625.
   + 2579b791c023a78a577e8cb827890139d6fb7534:
     Fix toolchain_java9 on --host_javabase=<jdk9> after
     7eb9ea150fb889a93908d96896db77d5658e5005
   + 2834613f93f74e988c51cf27eac0e59c79ff3b8f:
     Include also ext jars in the bootclasspath jar.
```

Incompatible changes:

  - Loading @bazel_tools//tools/build_defs/repo:git_repositories.bzl
    no longer works. Load @bazel_tools//tools/build_defs/repo:git.bzl
    instead.
  - If the same artifact is generated by two distinct but identical
    actions, and a downstream action has both those actions' outputs
    in its inputs, the artifact will now appear twice in the
    downstream action's inputs. If this causes problems in Skylark
    actions, you can use the uniquify=True argument in Args.add_args.
  - If the same artifact is generated by two distinct but identical
    actions, and a downstream action has both those actions' outputs
    in its inputs, the artifact will now appear twice in the
    downstream action's inputs. If this causes problems in Skylark
    actions, you can use the uniquify=True argument in Args.add_args.
  - Labels in C++ rules' linkopts attribute are not expanded anymore
    unless they are wrapped, e.g: $(location //foo:bar)
  - If the same artifact is generated by two distinct but identical
    actions, and a downstream action has both those actions' outputs
    in its inputs, the artifact will now appear twice in the
    downstream action's inputs. If this causes problems in Skylark
    actions, you can use the uniquify=True argument in Args.add_args.
  - New bazelrc file list.
  - Windows: when BAZEL_SH envvar is not defined and Bazel searches
    for a suitable bash.exe, Bazel will no longer look for Git Bash
    and no longer recommend installing it as a Bash implementation.
    See issue #5751.
  - New bazelrc file list.

New features:

  - The aquery command now supports --output=text.
  - Java, runfiles: the Java runfiles library is now in
    @bazel_tools//tools/java/runfiles. The old target
    (@bazel_tools//tools/runfiles:java-runfiles) is deprecated and
    will be removed in Bazel 0.18.0.
  - Java, runfiles: the Java runfiles library is now in
    @bazel_tools//tools/java/runfiles. The old target
    (@bazel_tools//tools/runfiles:java-runfiles) is deprecated and
    will be removed in Bazel 0.19.0 (not 0.18.0, as stated earlier).

Important changes:

  - Allow @ in package names.
  - Remove support for java_runtime_suite; use alias() together with
    select() instead.
  - Python wrapper scripts for MSVC are removed.
  - [JavaInfo] Outputs are merged in java_common.merge().
  - Faster analysis by improved parallelization.
  - --experimental_shortened_obj_file_path is removed.
  - Introduce the --remote_cache_proxy flag,
    which allows for remote http caching to connect
    via a unix domain socket.
  - No longer define G3_VERSION_INFO for c++ linkstamp compiles, as
    it was a duplicate of G3_TARGET_NAME.
  - Added support for Android NDK r17. The default STL is now
    `libc++`, and support for targeting `mips`, `mips64` and `ARMv5`
    (`armeabi`) has been removed.
  - Add aquery command to get analysis time information about the
    action graph.
  - Fixed compatibility with aar_import when using aapt2.  AAPT2 is
    now supported for Android app builds without resource shrinking.
    To use it, pass the `--android_aapt=aapt2` flag or define
    android_binary.aapt_version=aapt2.
  - Code coverage is collected for Java binaries invoked from sh_test.
  - java_common.compile creates the native headers jar accesible via
    JavaInfo.outputs.native_headers.
  - Deleting deprecated no-op flag --show_package_location
  - The JDK shipped with Bazel was updated to JDK10.
  - Rename the startup flag --host_javabase to --server_javabase to
    avoid confusion with the build flag --host_javabase
  - newly added options --experimental_repository_hash_file and
      --experimental_verify_repository_rules allow to verify for
    repositories
      the directory generated against pre-recorded hashes. See
    documentation
      for those options.
  - Removed the gen_jars output group
  - --subcommands can now take a "pretty_print" value
    ("--subcommands=pretty_print") to print the
    arguments of subcommands as a list for easier reading.
  - follow-up to
    https://github.com/bazelbuild/bazel/commit/1ac359743176e659e9c7472
    645e3142f3c44b9e8
  - A rule error is now thrown if a Skylark rule implementation
    function returns multiple providers of the same type.
  - When using Bazel's remote execution feature and Bazel has to
    fallback to local execution for an action, Bazel used
    non-sandboxed
    local execution until now. From this release on, you can use the
    new
    flag --remote_local_fallback_strategy=<strategy> to tell Bazel
    which
    strategy to use in that case.
  - Execution Log Parser can now, when printing it out, filter the
    log by runner type
  - A rule error is now thrown if a Skylark rule implementation
    function returns multiple providers of the same type.
  - Removed the gen_jars output group
  - Removed the gen_jars output group
  - Set --defer_param_files to default to true.
  - Sort attribute lists in proto-form query output to fix
    non-deterministic genquery output.
  - Replace 0/1 with False/True for testonly attribute
  - bazel now supports a .bazelignore file specifying
      directories to be ignored; however, these directories still
      have to be well founded and, in particular, may not contain
      symlink cycles.
  - Add more detailed reporting of the differences between startup
    options.
  - update data binding to 3.2.0
  - For Android incremental dexing actions, Bazel now persists its
    DexBuilder process across individual actions. From our
    benchmarks, this results in a 1.2x speedup for clean local builds.
  - The standard `xcode_VERSION` feature now always uses exactly two
    components in the version, even if you specify `--xcode_version`
    with
    more or fewer than two.
  - A rule error will be thrown if a Skylark rule implementation
    function returns multiple providers of the same type. Try the
    `--incompatible_disallow_conflicting_providers` flag to ensure
    your code is forward-compatible.
  - Removed notion of FULLY_STATIC linking mode from C++ rules.
  - In documentation, we've renamed Skylark into Starlark.
  - Execution Log Parser can now, when printing it out, reorder the
    actions for easier text diffs
  - Linkstamps are no longer recompiled after server restart.
  - Use VanillaJavaBuilder and disable header compilation in
    toolchain_hostjdk8. The default toolchain will soon drop
    compatibility with JDK 8. Using a JDK 8 host_javabase
    will only be supported when using 'VanillaJavaBuilder' (which
    does not support Error Prone,
    Strict Java Deps, or reduced classpaths) and with header
    compilation disabled.
  - In the future, Bazel will expand tree artifacts in runfiles, too,
    which causes the sandbox to link each file individually into the
    sandbox directory, instead of symlinking the entire directory. In
    this release, the behavior is not enabled by default yet. Please
    try it out via
    --incompatible_symlinked_sandbox_expands_tree_artifacts_in_runfile
    s_tree and let us know if it causes issues. If everything looks
    good, this behavior will become the default in a following
    release.

## Release 0.16.1 (2018-08-13)

```
Baseline: 4f64b77a3dd8e4ccdc8077051927985f9578a3a5

Cherry picks:
   + 4c9a0c82d308d5df5c524e2a26644022ff525f3e:
     reduce the size of bazel's embedded jdk
   + d3228b61f633cdc5b3f740b641a0836f1bd79abd:
     remote: limit number of open tcp connections by default. Fixes
     #5491
   + 8ff87c164f48dbabe3b20becd00dde90c50d46f5:
     Fix autodetection of linker flags
   + c4622ac9205d2f1b42dac8c598e83113d39e7f11:
     Fix autodetection of -z linker flags
   + 10219659f58622d99034288cf9f491865f818218:
     blaze_util_posix.cc: fix order of #define
   + ab1f269017171223932e0da9bb539e8a17dd99ed:
     blaze_util_freebsd.cc: include path.h explicitly
   + 68e92b45a37f2142c768a56eb7ecfa484b8b22df:
     openjdk: update macOS openjdk image. Fixes #5532
   + f45c22407e6b00fcba706eb62141cb9036bd38d7:
     Set the start time of binary and JSON profiles to zero correctly.
   + bca1912853086b8e9a28a85a1b144ec0dc9717cc:
     remote: fix race on download error. Fixes #5047
   + 3842bd39e10612c7eef36c6048407e81bcd0a8fb:
     jdk: use parallel old gc and disable compact strings
   + 6bd0bdf5140525cb33dc2db068b210261d9df271:
     Add objc-fully-link to the list of actions that require the
     apple_env feature. This fixes apple_static_library functionality.
   + f330439fb970cfa17c70fc59c1458bb1c31c9522:
     Add the action_names_test_files target to the OSS version of
     tools/buils_defs/cc/BUILD.
   + d215b64362c4ede61c8ba87b5f3f57bce4785d15:
     Fix StackOverflowError on Windows. Fixes #5730
   + 366da4cf27b7f957ef39f89206db77fa2ac289df:
     In java_rules_skylark depend on the javabase through
     //tools/jdk:current_java_runtime
   + 30c601dc13d9e1b40a57434c022c888c7578cc56:
     Don't use @local_jdk for jni headers
   + c56699db5f9173739ba3ac55aa9fa69b6457a99b:
     'DumpPlatformClasspath' now dumps the current JDK's default
     platform classpath
```

This release is a patch release that contains fixes for several serious
regressions that were found after the release of Bazel 0.16.0.

In particular this release resolves the following issues:

 - Bazel crashes with a StackOverflowError on Windows (See #5730)
 - Bazel requires a locally installed JDK and does not fall back
   to the embedded JDK (See #5744)
 - Bazel fails to build for Homebrew on macOS El Capitan (See #5777)
 - A regression in apple_static_library (See #5683)

Please watch our blog for a more detailed release announcement.

## Release 0.16.0 (2018-07-31)

```
Baseline: 4f64b77a3dd8e4ccdc8077051927985f9578a3a5

Cherry picks:
   + 4c9a0c82d308d5df5c524e2a26644022ff525f3e:
     reduce the size of bazel's embedded jdk
   + d3228b61f633cdc5b3f740b641a0836f1bd79abd:
     remote: limit number of open tcp connections by default. Fixes
     #5491
   + 8ff87c164f48dbabe3b20becd00dde90c50d46f5:
     Fix autodetection of linker flags
   + c4622ac9205d2f1b42dac8c598e83113d39e7f11:
     Fix autodetection of -z linker flags
   + 10219659f58622d99034288cf9f491865f818218:
     blaze_util_posix.cc: fix order of #define
   + ab1f269017171223932e0da9bb539e8a17dd99ed:
     blaze_util_freebsd.cc: include path.h explicitly
   + 68e92b45a37f2142c768a56eb7ecfa484b8b22df:
     openjdk: update macOS openjdk image. Fixes #5532
   + f45c22407e6b00fcba706eb62141cb9036bd38d7:
     Set the start time of binary and JSON profiles to zero correctly.
   + bca1912853086b8e9a28a85a1b144ec0dc9717cc:
     remote: fix race on download error. Fixes #5047
   + 3842bd39e10612c7eef36c6048407e81bcd0a8fb:
     jdk: use parallel old gc and disable compact strings
```

Incompatible changes:

  - The $(ANDROID_CPU) Make variable is not available anymore. Use
    $(TARGET_CPU) after an Android configuration transition instead.
  - The $(JAVA_TRANSLATIONS) Make variable is not supported anymore.
  - Skylark structs (using struct()) may no longer have to_json and
    to_proto overridden.
  - The mobile-install --skylark_incremental_res flag is no longer
    available, use the --skylark flag instead.

New features:

  - android_local_test now takes advantage of Robolectric's binary
    resource processing which allows for faster tests.
  - Allow @ in package names.

Important changes:

  - Option --glibc is removed, toolchain selection relies solely on
    --cpu and --compiler options.
  - Build support for enabling cross binary FDO optimization.
  - The --distdir option is no longer experimental. This
      option allows to specify additional directories to look for
      files before trying to fetch them from the network. Files from
      any of the distdirs are only used if a checksum for the file
      is specified and both, the filename and the checksum, match.
  - Java coverage works now with multiple jobs.
  - Flip default value of --experimental_shortened_obj_file_path to
    true, Bazel now generates short object file path by default.
  - New rules for importing Android dependencies:
    `aar_import_external` and `aar_maven_import_external`.
    `aar_import_external` enables specifying external AAR
    dependencies using a list of HTTP URLs for the artifact.
    `aar_maven_import_external` enables specifying external AAR
    dependencies using the artifact coordinate and a list of server
    URLs.
  - The BAZEL_JAVAC_OPTS environment variable allows arguments, e.g.,
    "-J-Xmx2g", may be passed to the javac compiler during bootstrap
    build. This is helpful if your system chooses too small of a max
    heap size for the Java compiler during the bootstrap build.
  - --noexpand_configs_in_place is deprecated.
  - A tool to parse the Bazel execution log.
  - Support for LIPO has been fully removed.
  - Remove support for --discard_actions_after_execution.
  - Add --materialize_param_files flag to write parameter files even
    when actions are executed remotely.
  - Windows default system bazelrc is read from the user's
    ProgramData if present.
  - --[no]allow_undefined_configs no longer exists, passing undefined
    configs is an error.
  - In remote caching we limit the number of open
    TCP connections to 100 by default. The number can be adjusted
    by specifying the --remote_max_connections flag.

## Release 0.15.0 (2018-06-26)

```
Baseline: b93ae42e8e693ccbcc387841a17f58259966fa38

Cherry picks:
   + 4b80f2455e7e49a95f3a4c9102a67a57dad52207:
     Add option to enable Docker sandboxing.
   + 6b1635279e8b33dc1ac505ac81825e38f8797a14:
     Allow disabling the simple blob caches via CLI flag overrides.
   + 4ec0a7524913ab2c4641368e3f8c09b347351a08:
     Use BUILD.bazel instead of BUILD for external projects
```

Incompatible changes:

  - Bazel now always runs binaries in with "bazel run" in
    interactive mode. The "--nodirect_run" command line option is now
    a no-op.
  - "bazel run --noas_test" is not supported anymore.
  - Indentation on the first line of a file was previously ignored.
    This is now fixed.

New features:

  - C++,runfiles: to access data-dependencies (runfiles) in C++
    programs, use the runfiles library built into Bazel. For usage
    info, see
    https://github.com/bazelbuild/bazel/blob/master/tools/cpp/runfiles
    /runfiles.h

Important changes:

  - Bazel now allows almost all 7-bit ASCII characters in labels.
  - Remove vestigial java_plugin.data attribute
  - Bazel supports including select Java 8 APIs into Android apps
    targeting pre-Nougat Android devices with
    --experimental_desugar_java8_libs
  - Flag `--incompatible_disable_glob_tracking` is removed.
  - SkyQuery's rbuildfiles now returns targets corresponding to
    broken packages.
  - Introduce build support for providing cache prefetch hints.
  - Update the skylark DefaultInfo documentation to spell out
    runfiles, data_runfiles and default_runfiles
  - An internal action for symlinking runfiles will use Command
    instead of a Spawns. This should have no functional chages; the
    only user visible consequence should be that the internal action
    is no longer be included in statistics when calculating processes
    count.
  - --batch is deprecated
  - execution strategies line no longer handles differently the case
    where all processes have the same strategy.
  - The --experimental_remote_spawn_cache flag is now enabled by
    default, and remote caching no longer needs --*_strategy=remote
    flags (it will fail if they are specified).
  - android_binary.aapt_version='aapt2' now supports en_XA and ar_XB
  - Added --apple_enable_auto_dsym_dbg flag.
  - non_propagated_deps has been removed from objc_library and
    apple_binary.
  - For Android projects, Bazel now supports building fonts as
    resources. See
    https://developer.android.com/guide/topics/ui/look-and-feel/fonts-in-xml
    for more information on the feature.
  - With --incompatible_no_support_tools_in_action_inputs enabled, Skylark
    action inputs are no longer scanned for tools. Move any such
    inputs to the newly introduced 'tools' attribute.

## Release 0.14.1 (2018-06-08)

```
Baseline: 5c3f5c9be7fa40d4fb3c35756891fab8483ca406

Cherry picks:
   + f96f037f8f77335dc444844abcc31a372a3e1849:
     Windows, Java launcher: Support jar files under different drives
   + ff8162d01409db34893de98bd840a51c5f13e257:
     sh_configure.bzl: FreeBSD is also a known platform
   + 7092ed324137f03fcd34856bdb0595a1bdec3069:
     Remove unneeded exec_compatible_with from local_sh_toolchain
   + 57bc201346e61c62a921c1cbf32ad24f185c10c9:
     Do not autodetect C++ toolchain when
     BAZEL_DO_NOT_DETECT_CPP_TOOLCHAIN=1 is present
   + 35a78c09cf2fbfc3de9c124d2142e3d72aac4348:
     remote: recursively delete incomplete downloaded output
     directory.
   + 3c9cd82b847f3ece8ec04b2029bd5e8ad0eb7502:
     distfile: pack the archives needed later in the build
   + 27487c77387e457df18be3b6833697096d074eab:
     Slightly refactor SpawnAction to improve env handling
   + 1b333a2c37add9d04fe5bc5258ee4f73c93115e2:
     Fix Cpp{Compile,Link}Action environment and cache key computation
   + 3da8929963e9c70dff5d8859d6e988e6e7f4f9d7:
     Make SymlinkTreeAction properly use the configuration's
     environment
   + eca7b81cf8cc51e1fe56e5ed7d4ad5cd1668a17a:
     Add a missing dependency from checker framework dataflow to
     javacutils
   + 10a4de954c2061258d8222961fc3bd39516db49d:
     Release 0.14.0 (2018-06-01)
   + 4b80f2455e7e49a95f3a4c9102a67a57dad52207:
     Add option to enable Docker sandboxing.
   + 6b1635279e8b33dc1ac505ac81825e38f8797a14:
     Allow disabling the simple blob caches via CLI flag overrides.
```

Bug fix for [#5336](https://github.com/bazelbuild/bazel/issues/5336)
Bug fix fot [#5308](https://github.com/bazelbuild/bazel/issues/5308)

## Release 0.14.0 (2018-06-01)

```
Baseline: 5c3f5c9be7fa40d4fb3c35756891fab8483ca406

Cherry picks:
   + f96f037f8f77335dc444844abcc31a372a3e1849:
     Windows, Java launcher: Support jar files under different drives
   + ff8162d01409db34893de98bd840a51c5f13e257:
     sh_configure.bzl: FreeBSD is also a known platform
   + 7092ed324137f03fcd34856bdb0595a1bdec3069:
     Remove unneeded exec_compatible_with from local_sh_toolchain
   + 57bc201346e61c62a921c1cbf32ad24f185c10c9:
     Do not autodetect C++ toolchain when
     BAZEL_DO_NOT_DETECT_CPP_TOOLCHAIN=1 is present
   + 35a78c09cf2fbfc3de9c124d2142e3d72aac4348:
     remote: recursively delete incomplete downloaded output
     directory.
   + 3c9cd82b847f3ece8ec04b2029bd5e8ad0eb7502:
     distfile: pack the archives needed later in the build
   + 27487c77387e457df18be3b6833697096d074eab:
     Slightly refactor SpawnAction to improve env handling
   + 1b333a2c37add9d04fe5bc5258ee4f73c93115e2:
     Fix Cpp{Compile,Link}Action environment and cache key computation
   + 3da8929963e9c70dff5d8859d6e988e6e7f4f9d7:
     Make SymlinkTreeAction properly use the configuration's
     environment
   + eca7b81cf8cc51e1fe56e5ed7d4ad5cd1668a17a:
     Add a missing dependency from checker framework dataflow to
     javacutils
```

Incompatible changes:

  - Add --incompatible_disallow_legacy_javainfo flag.
  - Added flag --incompatible_disallow_old_style_args_add to help
    migrate from args.add() to args.add_all() / args.add_joined()
    where appropriate.

New features:

  - Bash,runfiles: use the new platform-independent library in
    `@bazel_tools//tools/bash/runfiles` to access runfiles
    (data-dependencies). See
    https://github.com/bazelbuild/bazel/blob/master/tools/bash/runfile
    s/runfiles.bash for usage information.
  - TemplateVariableInfo can now be constructed from Skylark.
  - The java_host_runtime_alias rule is now implemented in Java.

Important changes:

  - Flip default value of --experimental_shortened_obj_file_path to
    true, Bazel now generates short object file path by default.
  - Introduce fdo_profile rule that allows architecture-sensitive
    specification of fdo profiles.
  - canonicalize-flags no longer reorders the flags
  - CppRules: optional_compiler_flag was removed from CROSSTOOL, use
    features instead.
  - Labels of the form ////foo are disallowed.
  - The `/` operator is deprecated in favor of `//` (floor integer
    division).
      Try the `--incompatible_disallow_slash_operator` flag to ensure
    your code
      is forward-compatible.
  - Flip default value of --experimental_shortened_obj_file_path to
    true, Bazel now generates short object file path by default.
  - Exposed "mnemonic" and "env" fields on skylark "Action" objects.
  - Removed flag `--incompatible_disallow_toplevel_if_statement`.
  - Remove vestigial 'deps' and 'data' attributes from
    proto_lang_toolchain
  - Args objects (ctx.actions.args()) have new methods add_all() and
    add_joined() for building command lines using depsets.
  - `FileType` is deprecated and will be removed soon.
      Try the `--incompatible_disallow_filetype` flag to ensure your
    code
      is forward-compatible.
  - Introduce absolute_path_profile attribute that allows fdo_profile
    to accept absolute paths.
  - Support two-arg overloads for ctx.actions.args (eg.
    args.add("--foo", val))
  - Introduce 'tools' attribute to ctx.actions.run.
  - Fixed error message for proguard_apply_dictionary.
  - "bazel run" now lets one run interactive binaries. The
    BUILD_WORKSPACE_DIRECTORY and BUILD_WORKING_DIRECTORY environment
    variables indicate the working directory and the workspace root
    of the Bazel invocation. Tests are provided with an approximation
    of the official test environment.
  - repository rules are no longer restricted to return None.
  - Add --high_priority_workers flag.
  - CppRules: Feature configuration can be created from Skylark
  - Adds new-style JavaInfo provider constructor.
  - Make java_common.compile now uses java_toolchain javacopts by
    default; explicitly retrieving them using
    java_common.default_javac_opts is unnecessary.
  - CppRules: C++ command lines and env variables for C++ actions can
    be retrieved from feature configuration.
  - Skylark rule definitions may advertise providers that targets of
    the rule must propagate.
  - Bazel now supports running actions inside Docker containers.
    To use this feature, run "bazel build --spawn_strategy=docker
    --experimental_docker_image=myimage:latest".
  - Remote execution works for Windows binaries with launchers.
  - Fixing start/end lib expansion for linking. There were many cases
    where archive files were still being used with toolchains that
    support start/end lib. This change consolidates the places that
    make that decision so they can be more consistent.
  - Add support for reporting an error if
    android_test.binary_under_test contains incompatible versions of
    deps
  - We replaced the --experimental_local_disk_cache and
    --experimental_local_disk_cache_path flags into a single
    --disk_cache flag. Additionally, Bazel now tries to create the disk cache
    directory if it doesn't exist.
  - Save Blaze memory by not storing LinkerInput objects in
    LinkCommandLine
  - In the JavaInfo created by java_common.create_provider now
    includes both direct and transitive arguments in
    transitive_compile_time_jars and transitive_runtime_jars
  - Allow --worker_max_instances to take MnemonicName=value to
    specify max for each worker.
  - Allow java_toolchain.header_compiler to be an arbitrary executable

## Release 0.13.1 (2018-05-23)

```
Baseline: fdee70e6e39b74bfd9144b1e350d2d8806386e05

Cherry picks:
   + f083e7623cd03e20ed216117c5ea8c8b4ec61948:
     windows: GetOutputRoot() returns GetHomeDir()
   + fa36d2f48965b127e8fd397348d16e991135bfb6:
     Automated rollback of commit
     4465dae23de989f1452e93d0a88ac2a289103dd9.
   + 4abd2babcc50900afd0271bf30dc64055f34e100:
     Add error message on empty public resources
   + 2c957575ff24c183d48ade4345a79ffa5bec3724:
     test-setup: remove leading "./" from test name
   + e6eaf251acb3b7054c8c5ced58a49c054b5f23b1:
     Sort entries by segment when building a parent node to prevent
     unordered directory structures.
```

Important changes:

  - Remote Execution: Fixes a regression that produces directories with unsorted file/directory lists

## Release 0.13.0 (2018-04-30)

```
Baseline: fdee70e6e39b74bfd9144b1e350d2d8806386e05

Cherry picks:
   + f083e7623cd03e20ed216117c5ea8c8b4ec61948:
     windows: GetOutputRoot() returns GetHomeDir()
   + fa36d2f48965b127e8fd397348d16e991135bfb6:
     Automated rollback of commit
     4465dae23de989f1452e93d0a88ac2a289103dd9.
   + 4abd2babcc50900afd0271bf30dc64055f34e100:
     Add error message on empty public resources
   + 2c957575ff24c183d48ade4345a79ffa5bec3724:
     test-setup: remove leading "./" from test name
```

Incompatible changes:

  - Remove //tools/defaults:android_jar. Use
    @bazel_tools//tools/android:android_jar instead.
  - The flag --incompatible_show_all_print_messages is removed.
    Messages generated by `print` statements from any package will be
    displayed as
    DEBUG messages.
  - The --incompatible_disallow_uncalled_set_constructor flag is no
    longer available, the `set` constructor` is completely removed
    from Skylark.
    Use `depset` instead.
  - Variables PACKAGE_NAME and REPOSITORY_NAME are deprecated in
    favor of
      functions `package_name()` and `repository_name()`.

    https://docs.bazel.build/versions/master/skylark/lib/native.html#p
    ackage_name
  - BUILD_TIMESTAMP now contains seconds (and not milliseconds) since
    the epoch.

New features:

  - Strings have a new .elems() method, that provides an iterator on
    the characters of the string.
  - Now you can access three functions in windows_cc_configure.bzl by:
      load("@bazel_tools/tools/cpp:windows_cc_configure.bzl",
    "<function_name>")

Important changes:

  - CppRules: Unified action_configs for static libraries
  - Remove support for blaze dump --vfs. It is no longer meaningful.
  - Enable dependency checking for aar_import targets.
  - internal_bootstrap_hack has been deprecated and removed.
  - Properly handle tree artifacts on the link command line coming
    from a cc_library dependency.
  - Allow C++ features to make proto_library emit smaller C++ code
  - The 'j2objc' configuration fragment is exposed to Skylark.
  - Remove the default content of the global bazelrc.
  - In int() function, do not auto-detect base if input starts with
    '0'.
  - Users can now pass --experimental_shortened_obj_file_path=true to
    have a shorter object file path, the object file paths (and all
    other related paths) will be constructed as following:
    If there's no two or more source files with the same base name:

    <bazel-bin>/<target_package_path>/_objs/<target_name>/<source_base
    _name>.<extension>
    otherwise:

    <bazel-bin>/<target_package_path>/_objs/<target_name>/N/<source_ba
    se_name>.<extension>
      N = the file?s order among the source files with the same
    basename, starts from 0.
  - Move (c/cxx)opts from legacy_compile_flags to user_compile_flags
  - CppRules: Remove optional_*_flag fields from CROSSTOOL, they are
    not
    used, and could be expressed using features.
  - Introduce --incompatible_disable_objc_provider_resources to turn
    off all resource-related fields of the Objc provider.
  - Removed the statement of "What does Bazel support?" as it's
    limiting/misleading. Added supported host OSes to
    "multi-platform" paragraph.
  - android_library AAR output now contains proguard.txt
  - Bazel now displays information about remote cache hits and
    execution strategies used in its UI after every build and test,
    and adds a corresponding line "process stats" to BuildToolLogs in
    BEP.
  - Print correct build result for builds with --aspects flag.
  - android_binary.manifest_merger is no longer supported.

## Release 0.12.0 (2018-04-11)

```
Baseline: b33e5afa313322a7048044c44d854cbb666b988e

Cherry picks:
   + 369409995bd75eeb0683fd24f7585d2a90320796:
     Automated rollback of commit
     c2b332b45e6ea41a14ecbd3c5f30782bcdeec301.
   + dbf779869751cc893ba240402d352c6e70be2978:
     Emit SJD errors even if we don't know the label of a dependency
   + 4c3098cfa6f00f90c7530b6f40d3e93062931c1d:
     Android tools: remove mtime-modifications
   + a1068c44a700ec2cff84cbd12592e9bfea25d754:
     NDK cc_toolchains: include bundled runtime libraries in
     cc_toolchain.all_files
   + b1be5816ec1bf8e1172c1bed4f29b4e6c6bb7202:
     runfiles,Python: remove library from @bazel_tools
   + 0a4622012ff796429220fe57d3217f262cc208a8:
     Fix visibility of def_parser for remote builds
   + 3c5373c50c7c492842f8a468906eda2c0bc90787:
     Remove visibility attribute from
     //third_party/def_parser:def_parser
   + f54d7e5293cc40ce3507a9adef530e46ab817585:
     Enable bulk writes in the HttpBlobStore
   + 04ce86e8ba96630f89a436167b7f3a195c5e50e7:
     remote/http: properly complete user promise
```

Incompatible changes:

  - The order of dict-valued attributes is now the order in the BUILD
    file (or in the Skylark dict they were created from) and not
    lexicographically sorted.

New features:

  - The new "--direct_run" flag on "blaze run" lets one run
    interactive binaries.
  - "blaze run --direct_run" with tests now gives the test an
    approximation of the official test environment.
  - "blaze run --direct_run" now exports the
    BUILD_{WORKSPACE,WORKING}_DIRECTORY variables to tell the binary
    about the cwd of the client and the workspace root.
  - New Android device test rule: android_instrumentation_test.
  - Add option to dump the action graph to a file: 'bazel dump
    --action_graph=/path/to/file'.
  - Pass `tags` from `java_import_external` rule to the generated
    `java_import` rule.
  - blaze query: use --proto:output_rule_attrs to filter for given
    attributes
  - Added Android NDK r15 support, including compatibility with
    Unified Headers.
  - Adds --ltobackendopt and --per_file_ltobackendopt for passing
    options to ThinLTO LTO backend compile actions only.

Important changes:

  - Fix how libraries to link is specified to archiver actions.
  - Fix how libraries_to_link are expanded in the archiver command
    line.
  - stop using --no-locals in android coverage builds
  - apple_binary can now generate dSYM outputs with the
    --apple_generate_dsym=true flag.
  - Fix FDO_STAMP_MACRO to only be set when fdoBuildStamp is not null.
  - Improved clarity of warning message for unsupported NDK revisions.
  - Add lint check for discouraging glob(["**/*.java"])
  - unifly lint glob(["**/*.java"]) message
  - Removed flags `--incompatible_checked_arithmetic`,
    `--incompatible_dict_literal_has_no_duplicates`,
    `--incompatible_disallow_keyword_only_args`, and `
    --incompatible_comprehension_variables_do_not_leak`.
  - Add "proto_source_root" flag to proto_library.
  - Updated default android_cpu value to armeabi-v7a
  - In skylark, print(target) now shows the provider keys of a
    target, as debug information.
  - The native http_archive rule is deprecated. Use the
      Skylark version available via
    load("@bazel_tools//tools/build_defs/repo:http.bzl",
    "http_archive")
      instead.
  - flaky_test_attempts supports the regex@attempts syntax, like
    runs_per_test.
  - Fixed include paths for NDK r13+ llvm-libc++ headers to
    `ndk/sources/cxx-stl/llvm-libc++/include` and
    `ndk/sources/cxx-stl/llvm-libc++abi/include`
  - --config flags now expand in place by default.
  - aar_import now sets java.transitive_exports.
  - repository_cache is no longer experimental and enabled by default.
  - BAZEL_LINKOPTS is now consulted when autoconfiguring c++ toolchain
  - The native git_repository rule is deprecated. Use the
      Skylark version available via
    load("@bazel_tools//tools/build_defs/repo:git.bzl",
    "git_repository")
      instead.
  - Removed flag `--incompatible_load_argument_is_label`.
  - CcToolchain: Introduced action_config for
    "c++-link-transitive-dynamic-library"
  - Use bazel dump --action_graph=/path/to/action.proto
    --action_graph:targets://foo:bar,//foo:foo to filter for certain
    targets in the action graph dump.
  - Added Android NDK r16 support. Use --cxxopt='-std=c++11` compile
    with the C++11 standard, and
    `--android_crosstool_top=@androidndk//:toolchain-libcpp` to use
    the `libc++` STL.
  - Add a --build_event_publish_all_actions flag to allow all actions
    to be published via the BEP.
  - C++: Introduced --experimental_drop_fully_static_linking_mode
  - Removed cc_inc_library, please use cc_library instead
  - CppRules: cc_binary/cc_test now enable 'static_linking_mode' or
    'dynamic_linking_mode'.

## Release 0.11.1 (2018-03-06)

```
Baseline: 00d781ae78a8bd51d3c61b621d79f0bb095aff9e

Cherry picks:
   + ea2d4c475febdbd59ca0e0ba46adc7be759f84e0:
     Update stub_finds_runfiles_test to be a real sh_test.
   + d855d8133f4efb73ebd5e82c54a9afb4c7565d46:
     java,runfiles: fix bugs in runfiles library
   + 56aeb04a064218b845ecc193d530c341c6ec854d:
     Fixing #4585: broken re-execution of orphaned actions.
   + cf3f81aef7c32019d70cbce218a64a03276268f0:
     remote: Add support for HTTP Basic Auth
   + 28bd997c1c8793973f63dcae4c22bbae49e7d8b7:
     Fixing test-setup.sh occasionally missing stdout/stderr, on
     systems where "tail --pid" is supported.
   + 109e4b4dc9e786e3a2d8d7cb245d18320dbe9216:
     Automated rollback of commit
     7e6837cc1d1aa4259f5c27ba3606b277b5f6c3e9.
   + b3d52b1b6d46a0f23cc91125c1d522e9d13433b4:
     Fix incorrect include directories when -no-canonical-prefixes is
     passed to clang
   + 1001141f0674ff4b611814edcb00a5183680ef4a:
     Roll forward of
     https://github.com/bazelbuild/bazel/commit/3904ac33a983fd8faebba1
     b52bcac5a3ff942029
     (https://github.com/bazelbuild/bazel/commit/3904ac33a983fd8faebba
     1b52bcac5a3ff942029). Fix #4625 by running the test process in a
     sub-shell.
   + fc98b44b6181fa4c3efd8613d887970629468d74:
     android,windows: bugfix in aar_resources_extractor
```

Important changes:

  - Fixes regression building Android rules on Windows.

## Release 0.11.0 (2018-02-23)

```
Baseline: 00d781ae78a8bd51d3c61b621d79f0bb095aff9e

Cherry picks:
   + ea2d4c475febdbd59ca0e0ba46adc7be759f84e0:
     Update stub_finds_runfiles_test to be a real sh_test.
   + d855d8133f4efb73ebd5e82c54a9afb4c7565d46:
     java,runfiles: fix bugs in runfiles library
   + 56aeb04a064218b845ecc193d530c341c6ec854d:
     Fixing #4585: broken re-execution of orphaned actions.
   + cf3f81aef7c32019d70cbce218a64a03276268f0:
     remote: Add support for HTTP Basic Auth
   + 28bd997c1c8793973f63dcae4c22bbae49e7d8b7:
     Fixing test-setup.sh occasionally missing stdout/stderr, on
     systems where "tail --pid" is supported.
   + 109e4b4dc9e786e3a2d8d7cb245d18320dbe9216:
     Automated rollback of commit
     7e6837cc1d1aa4259f5c27ba3606b277b5f6c3e9.
   + b3d52b1b6d46a0f23cc91125c1d522e9d13433b4:
     Fix incorrect include directories when -no-canonical-prefixes is
     passed to clang
   + 3904ac33a983fd8faebba1b52bcac5a3ff942029:
     Automated rollback of commit
     28bd997c1c8793973f63dcae4c22bbae49e7d8b7.
   + 1001141f0674ff4b611814edcb00a5183680ef4a:
     Roll forward of
     https://github.com/bazelbuild/bazel/commit/3904ac33a983fd8faebba1
     b52bcac5a3ff942029
     (https://github.com/bazelbuild/bazel/commit/3904ac33a983fd8faebba
     1b52bcac5a3ff942029). Fix #4625 by running the test process in a
     sub-shell.
```

Incompatible changes:

  - ctx.fragments.jvm is not available anymore.

New features:

  - java,runfiles: You can now depend on
    `@bazel_tools//tools/runfiles:java-runfiles` to get a
    platform-independent runfiles library for Java. See JavaDoc of
    https://github.com/bazelbuild/bazel/blob/master/src/tools/runfiles
    /java/com/google/devtools/build/runfiles/Runfiles.java for usage
    information.

Important changes:

  - The --[no]experimental_disable_jvm command line option is not
    supported anymore.
  - Allow expanding TreeArtifacts for libraries_to_link
  - Proguarded Android binaries can be built with incremental dexing.
  - aar_import now supports assets.
  - Crash in OutputJar::Close has been fixed
  - generator_* attributes are nonconfigurable.
  - Introduces --[no]keep_state_after_build
  - Add support for merged object files needed for -flto-unit.
  - Fix how libraries to link is specified to archiver actions.
  - Replace //tools/defaults:android_jar with
    @bazel_tools//tools/android:android_jar.
    //tools/defaults:android_jar will be removed in a future release.
  - java_common.compile supports neverlink
  - Resolved an issue where a failure in the remote cache would not
    trigger local re-execution of an action.

## Release 0.10.1 (2018-02-15)

```
Baseline: 22c2f9a7722e8c8b7fdf8f5d30a40f1c4118e993

Cherry picks:
   + f6ca78808722c8c119affdb33400838ee92d44b6:
     isable_presubmit
   + 65c13dd5a4c1b4b5a072f7680b8f1cf3c5079b52:
     Fix StreamResourceLeak error
   + e5436745e1732f5e43fc55f0deb5b19e23ce8524:
     windows: fix --symlink_prefix=/ throwing exception
   + 22ccdd1ebe1dc495e05d894a3325f6b05e681fb3:
     Fix turbine command lines with empty javacopts
   + 96c654d43eb2906177325cbc2fc2b1e90dbcc792:
     Remove EOL'd Linux flavours, bump CentOS to 6.9.
   + f0bec36864f10370cbbda4caa8beac2e0c5ee45b:
     Automated rollback of commit
     2aeaeba66857c561dd6d63c79a213f1cabc3650d.
   + 860af5be10b6bad68144d9d2d34173e86b40268c:
     Consolidate Error Prone resource handling
   + 2e631c99495f75270d2639542cefb531ec262d67:
     sandbox: properly add `tmpDir` to `writablePaths`
   + 5bfa5844d0d16d71e88002956e88402bfec88ef7:
     actions,temp: respect TMPDIR envvar
   + 6cc2ad8676d1ae0542b351a07a05ddbe5efac165:
     sandbox: add env[TMPDIR] instead of `tmpDir`
   + 40c757f4ab90214f95935672532a495c4551490a:
     Change git clone to pull all history, so all needed commits can
     be accessed.
   + 56aeb04a064218b845ecc193d530c341c6ec854d:
     Fixing #4585: broken re-execution of orphaned actions.
```

Important changes:

  - Resolved an issue where a failure in the remote cache would not
    trigger local re-execution of an action.

## Release 0.10.0 (2018-02-01)

```
Baseline: 22c2f9a7722e8c8b7fdf8f5d30a40f1c4118e993

Cherry picks:
   + f6ca78808722c8c119affdb33400838ee92d44b6:
     isable_presubmit
   + 65c13dd5a4c1b4b5a072f7680b8f1cf3c5079b52:
     Fix StreamResourceLeak error
   + e5436745e1732f5e43fc55f0deb5b19e23ce8524:
     windows: fix --symlink_prefix=/ throwing exception
   + 22ccdd1ebe1dc495e05d894a3325f6b05e681fb3:
     Fix turbine command lines with empty javacopts
   + 96c654d43eb2906177325cbc2fc2b1e90dbcc792:
     Remove EOL'd Linux flavours, bump CentOS to 6.9.
   + f0bec36864f10370cbbda4caa8beac2e0c5ee45b:
     Automated rollback of commit
     2aeaeba66857c561dd6d63c79a213f1cabc3650d.
   + 860af5be10b6bad68144d9d2d34173e86b40268c:
     Consolidate Error Prone resource handling
   + 2e631c99495f75270d2639542cefb531ec262d67:
     sandbox: properly add `tmpDir` to `writablePaths`
   + 5bfa5844d0d16d71e88002956e88402bfec88ef7:
     actions,temp: respect TMPDIR envvar
   + 6cc2ad8676d1ae0542b351a07a05ddbe5efac165:
     sandbox: add env[TMPDIR] instead of `tmpDir`
   + 40c757f4ab90214f95935672532a495c4551490a:
     Change git clone to pull all history, so all needed commits can
     be accessed.
```

Incompatible changes:

  - In order to access the template variables $(JAVA) and
    $(JAVABASE), @bazel_tools//tools/jdk:current_java_runtime needs
    to be added to the toolchains= attribute from now on.
  - The ctx.middle_man function is not supported anymore.
  - The flag --incompatible_list_plus_equals_inplace is removed, its
    default behavior is preserved. += on lists now always mutates the
    left hand
    side.
  - --android_sdk no longer supports filegroup targets.
  - android_* rules no longer support legacy_native_support attribute.

New features:

  - query: Add option --noproto:flatten_selects to turn off
    flattening of selector lists in proto output.
  - New android test rule, android_local_test.

Important changes:

  - The --remote_rest_cache flag now respects --remote_timeout.
  - --experimental_java_coverage is available for testing.
  - The deprecated builtin `set` is no longer allowed even from within
    unexecuted code in bzl files. It's temporarily possible to use
    --incompatible_disallow_uncalled_set_constructor=false if this
    change causes
    incompatibility issues.
  - Linkstamping is now a separate and full-blown CppCompileAction,
    it's
    no longer a part of linking command.
  - Using `+`, `|` or `.union` on depsets is now deprecated. Please
    use the new
      constructor instead (see
    https://docs.bazel.build/versions/master/skylark/depsets.html).
  - config_feature_flag's default_value is optional. It is
    only an error to have a config_feature_flag with no default_value
    if that config_feature_flag has not been set in the configuration
    it is being evaluated in.
  - --[no]keep_incrementality_data is gone, replaced by the
    enum-valued --incremental_state_retention_strategy
  - Linkstamping is now a separate and full-blown CppCompileAction,
    it's
    no longer a part of linking command.
  - Added --checkHashMismatch flag to ZipFilterAction. Valid values
    are IGNORE, WARN and ERROR. --errorOnHashMismatch is deprecated,
    please use this flag instead.
  - Set build jobs equivalent to number of logical processors by
    default. Should improve build times significantly.
  - Added --(no)expand_test_suites flag.
  - Rename --keep_incrementality_data to --track_incremental_state
  - --remote_rest_cache was renamed to --remote_http_cache. Both
    options keep working in this release, but --remote_rest_cache
    will be
    removed in the next release.
  - Aspects-on-aspect see and propagate over aspect attributes.
  - --auth_* flags were renamed to --google_* flags. The old names
    will continue to work for this release but will be removed in the
    next
    release.
  - Remote Caching and Execution support output directories.
  - Remove defunct flags
    --experimental_incremental_dexing_for_lite_proto and
    --experimental_incremental_dexing_error_on_missed_jars that have
    long been enabled by default
  - New version of aapt2 and Resources.proto.
  - Make PIC and non PIC outputs for C++ compilation with Tree
    Artifacts

## Release 0.9.0 (2017-12-19)

```
Baseline: ddd5ac16aeffa6c4693c348f73e7365240b1abc5

Cherry picks:
   + 2cf560f83922e6df9626ba3ee063c1caf6797548:
     Update version of re2
   + a2d2615362c65be98629b39ce39754a325ed1c42:
     Check for null build file returned from getBuildFileForPackage.
   + 68c577afc2fb33b5e66b820bcc9043fed1071456:
     Fix some broken targets and failing tests.
   + 766ba8adc4487f17ebfc081aeba6f34b18b53d6c:
     Automated rollback of commit
     337f19cc54e77c45daa1d5f61bf0a8d3daf8268f.
   + a22d0e9c14e58b29d81f5a83bdcc6e5fce52eafe:
     Fix: uploading artifacts of failed actions to remote cache
     stopped working.
   + 03964c8ccb20d673add76c7f37245e837c3899b6:
     [java_common.compile] Name output source jar relative to the
     output jar name
```

Incompatible changes:

  - The deprecated `set` constructor is removed, along with the
    migration flag --incompatible_disallow_set_constructor. It is
    still temporarily
    allowed to refer to `set` from within unexecuted code.
  - The flag --incompatible_disallow_set_constructor is no longer
    available, the deprecated `set` constructor is not available
    anymore.
  - The path to the JVM executable is not accessible anymore as
    ctx.{fragments,host_fragments}.jvm.java_executable. Use
    JavaRuntimeInfo.java_executable_exec_path instead.
  - --clean_style is no longer an option.

New features:

  - Users can use win_def_file attribute to specify a DEF file for
    exporting symbols when build a shared library on Windows.
  - Add --experimental_android_resource_cycle_shrinking option to
    allow for more aggressive code and resource shrinking.

Important changes:

  - Late-bound attributes are exposed to skylark. This is a new API
    (`configuration_field()`) to depend on certain
    configuration-defined targets from skylark rules.
  - Document interaction between test_suite and target exclusions
  - AAR manifest files will come from the processed resource APK if it
    exists.
    RELNOTES: None for Blaze users.
  - Document interaction between test_suite and target exclusions
  - --keep_incrementality_data flag allows Bazel servers to be run in
    memory-saving non-incremental mode independent of --batch and
    --discard_analysis_cache.
  - Add deps attribute to Skylark maven_aar and maven_jar workspace
    rules.
  - Use --expand_configs_in_place as a startup argument to change the
    order in which --config expansions are interpreted.
  - SOURCE_DATE_EPOCH
    (https://reproducible-builds.org/specs/source-date-epoch/) can
    be used to override the timestamp used for stamped target (when
    using --stamp).
  - Package specifications can now be prefixed with `-` to indicate
    negation
  - transitive_source_jars is now exposed on JavaInfo.
  - Add six to deps of has_services=1 py_proto_librarys.
  - java_tests no complain when use_testrunner is explicitly set to 1
    and main_class is set.
  - transitive_source_jars is now exposed on JavaInfo.
  - Debug messages generated by `print()` are not being filtered out
    by --output_filter anymore, it's recommended not to use them in
    production code.
  - in the Label() function, relative_to_caller_repository is now
    deprecated.
  - java_tests no complain when use_testrunner is explicitly set to 1
    and main_class is set.
  - Bazel's default hash function was changed from MD5 to SHA256.
    In particular, this affects users of remote caching and
    execution, as
    all hashes will be SHA256 by default.
  - Remove redirects for domains be.bazel.build and cr.bazel.build
    from the source for docs.bazel.build (because those subdomains
    don't resolve here; they resolve to bazel.build, which has the
    redirects for them)
  - First argument of 'load' must be a label. Path syntax is removed.
      (label should start with '//' or ':').
  - Document startup option --host_javabase
  - The --host_platform and --platform flags are no longer
    experimental.

## Release 0.8.0 (2017-11-27)

```
Baseline: cff0dc94f6a8e16492adf54c88d0b26abe903d4c

Cherry picks:
   + 8a49b156c4edf710e3e1e0acfde5a8d27cc3a086:
     Fix ImportError on tools.android for junction_lib
   + 275ae45b1228bdd0f912c4fbd634b29ba4180383:
     Automated rollback of commit
     4869c4e17d5b1410070a1570f3244148d8f97b5d.
   + d0bf589f2716b3d139c210930371a684c6e158eb:
     Add a random number to action temp dir
   + 9738f35abddb7ef7a7ef314b5d2a52a3be1b830a:
     CcProtoLibrary: Don't add dynamic librarys to filesToBuild on
     Windows
   + 0d6ff477099fdf6c8c1c7d4e2104f9184afe0a2b:
     Automated rollback of commit
     0ebb3e54fc890946ae6b3d059ecbd50e4b5ec840.
```

Incompatible changes:

  - ctx.fragments.apple.{xcode_version,ios_minimum_os} is not
    supported anymore. The same information is accessible through the
    target @bazel_tools//tools/osx:current_xcode_config: point an
    implicit attribute to it (i.e.
    attr.label(default=Label("@bazel_tools//tools/osx:current_xcode_co
    nfig")) then use
    ctx.attr._xcode_config[apple_common].XcodeVersionConfig].
  - ctx.fragments.apple.minimum_os_for_platform_type is not supported
    anymore. The same information is accessible through the target
    @bazel_tools//tools/osx:current_xcode_config: point an implicit
    attribute to it (i.e.
    attr.label(default=Label("@bazel_tools//tools/osx:current_xcode_co
    nfig")) then use
    ctx.attr._xcode_config[apple_common].XcodeVersionConfig].minimum_o
    s_for_platform_type .
  - ctx.fragments.apple.sdk_version_for_platform is not supported
    anymore. The same information is accessible through the target
    @bazel_tools//tools/osx:current_xcode_config: point an implicit
    attribute to it (i.e.
    attr.label(default=Label("@bazel_tools//tools/osx:current_xcode_co
    nfig")) then use
    ctx.attr._xcode_config[apple_common].XcodeVersionConfig].sdk_versi
    on_for_platform .
  - --javabase=<absolute path> and --host_javabase=<absolute path>
    are not supported anymore. If you need this functionality
    java_runtime_suite(name="suite", default=":runtime")
    java_runtime(name="runtime", java_home=<path to the JDK>) is an
    alternative.
  - The flag --incompatible_descriptive_string_representations is no
    longer available, old style string representations of objects are
    not supported
    anymore.
  - The flag --incompatible_disallow_set_constructor is no longer
    available, the deprecated `set` constructor is not available
    anymore.
  - += on lists now mutates them. `list1 += list2` is now equivalent
    to `list1.extend(list2)` and not equival