/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization.strings;

import com.google.common.annotations.VisibleForTesting;
import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.devtools.build.lib.unsafe.StringUnsafe;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.util.Arrays;

@VisibleForTesting
public final class UnsafeStringCodec
implements ObjectCodec<String> {
    private final StringUnsafe stringUnsafe = StringUnsafe.getInstance();

    @Override
    public Class<String> getEncodedClass() {
        return String.class;
    }

    @Override
    public ObjectCodec.MemoizationStrategy getStrategy() {
        return ObjectCodec.MemoizationStrategy.DO_NOT_MEMOIZE;
    }

    @Override
    public void serialize(SerializationContext context, String obj, CodedOutputStream codedOut) throws SerializationException, IOException {
        byte coder = this.stringUnsafe.getCoder(obj);
        byte[] value = this.stringUnsafe.getByteArray(obj);
        if (coder == 0) {
            codedOut.writeInt32NoTag(value.length);
        } else if (coder == 1) {
            codedOut.writeInt32NoTag(-value.length);
        } else {
            throw new SerializationException("Unexpected coder value: " + coder + " for " + obj);
        }
        codedOut.writeRawBytes(value);
    }

    @Override
    public String deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
        byte coder;
        int length = codedIn.readInt32();
        if (length >= 0) {
            coder = 0;
        } else {
            coder = 1;
            length = -length;
        }
        byte[] value = codedIn.readRawBytes(length);
        try {
            return this.stringUnsafe.newInstance(value, coder);
        }
        catch (ReflectiveOperationException e) {
            throw new SerializationException("Could not instantiate string: " + Arrays.toString(value) + ", " + coder, e);
        }
    }
}

