/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.devtools.build.lib.unsafe.UnsafeProvider;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;

class EnumMapCodec<E extends Enum<E>, V>
implements ObjectCodec<EnumMap<E, V>> {
    private final long classTypeOffset;

    EnumMapCodec() {
        try {
            this.classTypeOffset = UnsafeProvider.unsafe().objectFieldOffset(EnumMap.class.getDeclaredField("keyType"));
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("Couldn't get keyType field fron EnumMap", e);
        }
    }

    @Override
    public Class<EnumMap<E, V>> getEncodedClass() {
        return EnumMap.class;
    }

    @Override
    public void serialize(SerializationContext context, EnumMap<E, V> obj, CodedOutputStream codedOut) throws SerializationException, IOException {
        if (!obj.getClass().equals(EnumMap.class)) {
            throw new SerializationException("Cannot serialize subclasses of EnumMap: " + String.valueOf(obj.getClass()) + " (" + String.valueOf(obj) + ")");
        }
        codedOut.writeInt32NoTag(obj.size());
        if (obj.isEmpty()) {
            context.serialize(UnsafeProvider.unsafe().getObject(obj, this.classTypeOffset), codedOut);
            return;
        }
        context.serialize(((Enum)obj.keySet().iterator().next()).getDeclaringClass(), codedOut);
        for (Map.Entry<E, V> entry : obj.entrySet()) {
            codedOut.writeInt32NoTag(((Enum)entry.getKey()).ordinal());
            context.serialize(entry.getValue(), codedOut);
        }
    }

    @Override
    public EnumMap<E, V> deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
        int size = codedIn.readInt32();
        Class clazz = (Class)context.deserialize(codedIn);
        EnumMap result = new EnumMap(clazz);
        Enum[] enums = (Enum[])clazz.getEnumConstants();
        for (int i = 0; i < size; ++i) {
            int ordinal = codedIn.readInt32();
            Object val = context.deserialize(codedIn);
            result.put(enums[ordinal], val);
        }
        return result;
    }
}

