/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth.extensions.proto;

import com.google.auto.value.AutoValue;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.truth.Correspondence;
import com.google.common.truth.extensions.proto.AnyUtils;
import com.google.common.truth.extensions.proto.AutoValue_FluentEqualityConfig;
import com.google.common.truth.extensions.proto.FieldDescriptorValidator;
import com.google.common.truth.extensions.proto.FieldScope;
import com.google.common.truth.extensions.proto.FieldScopeLogic;
import com.google.common.truth.extensions.proto.FieldScopeLogicContainer;
import com.google.common.truth.extensions.proto.FieldScopeLogicMap;
import com.google.common.truth.extensions.proto.FieldScopeUtil;
import com.google.common.truth.extensions.proto.FieldScopes;
import com.google.common.truth.extensions.proto.ProtoTruth;
import com.google.common.truth.extensions.proto.ProtoTruthMessageDifferencer;
import com.google.common.truth.extensions.proto.SubScopeId;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import org.checkerframework.checker.nullness.qual.Nullable;

@AutoValue
abstract class FluentEqualityConfig
implements FieldScopeLogicContainer<FluentEqualityConfig> {
    private static final FluentEqualityConfig DEFAULT_INSTANCE = new AutoValue_FluentEqualityConfig.Builder().setIgnoreFieldAbsenceScope(FieldScopeLogic.none()).setIgnoreRepeatedFieldOrderScope(FieldScopeLogic.none()).setIgnoreExtraRepeatedFieldElementsScope(FieldScopeLogic.none()).setDoubleCorrespondenceMap(FieldScopeLogicMap.empty()).setFloatCorrespondenceMap(FieldScopeLogicMap.empty()).setCompareExpectedFieldsOnly(false).setHasExpectedMessages(false).setCompareFieldsScope(FieldScopeLogic.all()).setReportMismatchesOnly(false).setUnpackingAnyUsing(AnyUtils.defaultTypeRegistry(), AnyUtils.defaultExtensionRegistry()).setUsingCorrespondenceStringFunction((Function<? super Optional<Descriptors.Descriptor>, String>)Functions.constant((Object)"")).build();
    private final LoadingCache<Descriptors.Descriptor, ProtoTruthMessageDifferencer> messageDifferencers = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Descriptors.Descriptor, ProtoTruthMessageDifferencer>(){

        public ProtoTruthMessageDifferencer load(Descriptors.Descriptor descriptor) {
            return ProtoTruthMessageDifferencer.create(FluentEqualityConfig.this, descriptor);
        }
    });

    FluentEqualityConfig() {
    }

    static FluentEqualityConfig defaultInstance() {
        return DEFAULT_INSTANCE;
    }

    abstract FieldScopeLogic ignoreFieldAbsenceScope();

    abstract FieldScopeLogic ignoreRepeatedFieldOrderScope();

    abstract FieldScopeLogic ignoreExtraRepeatedFieldElementsScope();

    abstract FieldScopeLogicMap<Correspondence<Number, Number>> doubleCorrespondenceMap();

    abstract FieldScopeLogicMap<Correspondence<Number, Number>> floatCorrespondenceMap();

    abstract boolean compareExpectedFieldsOnly();

    abstract boolean hasExpectedMessages();

    abstract FieldScopeLogic compareFieldsScope();

    abstract boolean reportMismatchesOnly();

    abstract TypeRegistry useTypeRegistry();

    abstract ExtensionRegistry useExtensionRegistry();

    abstract Function<? super Optional<Descriptors.Descriptor>, String> usingCorrespondenceStringFunction();

    final String usingCorrespondenceString(Optional<Descriptors.Descriptor> descriptor) {
        return (String)this.usingCorrespondenceStringFunction().apply(descriptor);
    }

    final FluentEqualityConfig ignoringFieldAbsence() {
        return this.toBuilder().setIgnoreFieldAbsenceScope(FieldScopeLogic.all()).addUsingCorrespondenceString(".ignoringFieldAbsence()").build();
    }

    final FluentEqualityConfig ignoringFieldAbsenceOfFields(Iterable<Integer> fieldNumbers) {
        return this.toBuilder().setIgnoreFieldAbsenceScope(this.ignoreFieldAbsenceScope().allowingFieldsNonRecursive(fieldNumbers)).addUsingCorrespondenceFieldNumbersString(".ignoringFieldAbsenceOf(%s)", fieldNumbers).build();
    }

    final FluentEqualityConfig ignoringFieldAbsenceOfFieldDescriptors(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.toBuilder().setIgnoreFieldAbsenceScope(this.ignoreFieldAbsenceScope().allowingFieldDescriptorsNonRecursive(fieldDescriptors)).addUsingCorrespondenceFieldDescriptorsString(".ignoringFieldAbsenceOf(%s)", fieldDescriptors).build();
    }

    final FluentEqualityConfig ignoringRepeatedFieldOrder() {
        return this.toBuilder().setIgnoreRepeatedFieldOrderScope(FieldScopeLogic.all()).addUsingCorrespondenceString(".ignoringRepeatedFieldOrder()").build();
    }

    final FluentEqualityConfig ignoringRepeatedFieldOrderOfFields(Iterable<Integer> fieldNumbers) {
        return this.toBuilder().setIgnoreRepeatedFieldOrderScope(this.ignoreRepeatedFieldOrderScope().allowingFieldsNonRecursive(fieldNumbers)).addUsingCorrespondenceFieldNumbersString(".ignoringRepeatedFieldOrderOf(%s)", fieldNumbers).build();
    }

    final FluentEqualityConfig ignoringRepeatedFieldOrderOfFieldDescriptors(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.toBuilder().setIgnoreRepeatedFieldOrderScope(this.ignoreRepeatedFieldOrderScope().allowingFieldDescriptorsNonRecursive(fieldDescriptors)).addUsingCorrespondenceFieldDescriptorsString(".ignoringRepeatedFieldOrderOf(%s)", fieldDescriptors).build();
    }

    final FluentEqualityConfig ignoringExtraRepeatedFieldElements() {
        return this.toBuilder().setIgnoreExtraRepeatedFieldElementsScope(FieldScopeLogic.all()).addUsingCorrespondenceString(".ignoringExtraRepeatedFieldElements()").build();
    }

    final FluentEqualityConfig ignoringExtraRepeatedFieldElementsOfFields(Iterable<Integer> fieldNumbers) {
        return this.toBuilder().setIgnoreExtraRepeatedFieldElementsScope(this.ignoreExtraRepeatedFieldElementsScope().allowingFieldsNonRecursive(fieldNumbers)).addUsingCorrespondenceFieldNumbersString(".ignoringExtraRepeatedFieldElements(%s)", fieldNumbers).build();
    }

    final FluentEqualityConfig ignoringExtraRepeatedFieldElementsOfFieldDescriptors(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.toBuilder().setIgnoreExtraRepeatedFieldElementsScope(this.ignoreExtraRepeatedFieldElementsScope().allowingFieldDescriptorsNonRecursive(fieldDescriptors)).addUsingCorrespondenceFieldDescriptorsString(".ignoringExtraRepeatedFieldElements(%s)", fieldDescriptors).build();
    }

    final FluentEqualityConfig usingDoubleTolerance(double tolerance) {
        return this.toBuilder().setDoubleCorrespondenceMap(FieldScopeLogicMap.defaultValue(Correspondence.tolerance((double)tolerance))).addUsingCorrespondenceString(new StringBuilder(47).append(".usingDoubleTolerance(").append(tolerance).append(")").toString()).build();
    }

    final FluentEqualityConfig usingDoubleToleranceForFields(double tolerance, Iterable<Integer> fieldNumbers) {
        return this.toBuilder().setDoubleCorrespondenceMap(this.doubleCorrespondenceMap().with(FieldScopeLogic.none().allowingFieldsNonRecursive(fieldNumbers), (Correspondence<Number, Number>)Correspondence.tolerance((double)tolerance))).addUsingCorrespondenceFieldNumbersString(new StringBuilder(51).append(".usingDoubleTolerance(").append(tolerance).append(", %s)").toString(), fieldNumbers).build();
    }

    final FluentEqualityConfig usingDoubleToleranceForFieldDescriptors(double tolerance, Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.toBuilder().setDoubleCorrespondenceMap(this.doubleCorrespondenceMap().with(FieldScopeLogic.none().allowingFieldDescriptorsNonRecursive(fieldDescriptors), (Correspondence<Number, Number>)Correspondence.tolerance((double)tolerance))).addUsingCorrespondenceFieldDescriptorsString(new StringBuilder(51).append(".usingDoubleTolerance(").append(tolerance).append(", %s)").toString(), fieldDescriptors).build();
    }

    final FluentEqualityConfig usingFloatTolerance(float tolerance) {
        return this.toBuilder().setFloatCorrespondenceMap(FieldScopeLogicMap.defaultValue(Correspondence.tolerance((double)tolerance))).addUsingCorrespondenceString(new StringBuilder(37).append(".usingFloatTolerance(").append(tolerance).append(")").toString()).build();
    }

    final FluentEqualityConfig usingFloatToleranceForFields(float tolerance, Iterable<Integer> fieldNumbers) {
        return this.toBuilder().setFloatCorrespondenceMap(this.floatCorrespondenceMap().with(FieldScopeLogic.none().allowingFieldsNonRecursive(fieldNumbers), (Correspondence<Number, Number>)Correspondence.tolerance((double)tolerance))).addUsingCorrespondenceFieldNumbersString(new StringBuilder(41).append(".usingFloatTolerance(").append(tolerance).append(", %s)").toString(), fieldNumbers).build();
    }

    final FluentEqualityConfig usingFloatToleranceForFieldDescriptors(float tolerance, Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.toBuilder().setFloatCorrespondenceMap(this.floatCorrespondenceMap().with(FieldScopeLogic.none().allowingFieldDescriptorsNonRecursive(fieldDescriptors), (Correspondence<Number, Number>)Correspondence.tolerance((double)tolerance))).addUsingCorrespondenceFieldDescriptorsString(new StringBuilder(41).append(".usingFloatTolerance(").append(tolerance).append(", %s)").toString(), fieldDescriptors).build();
    }

    final FluentEqualityConfig comparingExpectedFieldsOnly() {
        return this.toBuilder().setCompareExpectedFieldsOnly(true).addUsingCorrespondenceString(".comparingExpectedFieldsOnly()").build();
    }

    final FluentEqualityConfig withExpectedMessages(Iterable<? extends Message> messages) {
        Builder builder = this.toBuilder().setHasExpectedMessages(true);
        if (this.compareExpectedFieldsOnly()) {
            builder.setCompareFieldsScope(FieldScopeLogic.and(this.compareFieldsScope(), FieldScopes.fromSetFields(messages).logic()));
        }
        return builder.build();
    }

    final FluentEqualityConfig withPartialScope(FieldScope partialScope) {
        return this.toBuilder().setCompareFieldsScope(FieldScopeLogic.and(this.compareFieldsScope(), partialScope.logic())).addUsingCorrespondenceFieldScopeString(".withPartialScope(%s)", partialScope).build();
    }

    final FluentEqualityConfig ignoringFields(Iterable<Integer> fieldNumbers) {
        return this.toBuilder().setCompareFieldsScope(this.compareFieldsScope().ignoringFields(fieldNumbers)).addUsingCorrespondenceFieldNumbersString(".ignoringFields(%s)", fieldNumbers).build();
    }

    final FluentEqualityConfig ignoringFieldDescriptors(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.toBuilder().setCompareFieldsScope(this.compareFieldsScope().ignoringFieldDescriptors(fieldDescriptors)).addUsingCorrespondenceFieldDescriptorsString(".ignoringFieldDescriptors(%s)", fieldDescriptors).build();
    }

    final FluentEqualityConfig ignoringFieldScope(FieldScope fieldScope) {
        return this.toBuilder().setCompareFieldsScope(FieldScopeLogic.and(this.compareFieldsScope(), FieldScopeLogic.not(fieldScope.logic()))).addUsingCorrespondenceFieldScopeString(".ignoringFieldScope(%s)", fieldScope).build();
    }

    final FluentEqualityConfig reportingMismatchesOnly() {
        return this.toBuilder().setReportMismatchesOnly(true).addUsingCorrespondenceString(".reportingMismatchesOnly()").build();
    }

    final FluentEqualityConfig unpackingAnyUsing(TypeRegistry typeRegistry, ExtensionRegistry extensionRegistry) {
        String string = String.valueOf(typeRegistry);
        String string2 = String.valueOf(extensionRegistry);
        return this.toBuilder().setUnpackingAnyUsing(typeRegistry, extensionRegistry).addUsingCorrespondenceString(new StringBuilder(22 + String.valueOf(string).length() + String.valueOf(string2).length()).append(".unpackingAnyUsing(").append(string).append(", ").append(string2).append(")").toString()).build();
    }

    @Override
    public final FluentEqualityConfig subScope(Descriptors.Descriptor rootDescriptor, SubScopeId subScopeId) {
        return this.toBuilder().setIgnoreFieldAbsenceScope(this.ignoreFieldAbsenceScope().subScope(rootDescriptor, subScopeId)).setIgnoreRepeatedFieldOrderScope(this.ignoreRepeatedFieldOrderScope().subScope(rootDescriptor, subScopeId)).setIgnoreExtraRepeatedFieldElementsScope(this.ignoreExtraRepeatedFieldElementsScope().subScope(rootDescriptor, subScopeId)).setDoubleCorrespondenceMap((FieldScopeLogicMap<Correspondence<Number, Number>>)this.doubleCorrespondenceMap().subScope(rootDescriptor, subScopeId)).setFloatCorrespondenceMap((FieldScopeLogicMap<Correspondence<Number, Number>>)this.floatCorrespondenceMap().subScope(rootDescriptor, subScopeId)).setCompareFieldsScope(this.compareFieldsScope().subScope(rootDescriptor, subScopeId)).build();
    }

    @Override
    public final void validate(Descriptors.Descriptor rootDescriptor, FieldDescriptorValidator fieldDescriptorValidator) {
        Verify.verify((fieldDescriptorValidator == FieldDescriptorValidator.ALLOW_ALL ? 1 : 0) != 0);
        this.ignoreFieldAbsenceScope().validate(rootDescriptor, FieldDescriptorValidator.IS_FIELD_WITH_ABSENCE);
        this.ignoreRepeatedFieldOrderScope().validate(rootDescriptor, FieldDescriptorValidator.IS_FIELD_WITH_ORDER);
        this.ignoreExtraRepeatedFieldElementsScope().validate(rootDescriptor, FieldDescriptorValidator.IS_FIELD_WITH_EXTRA_ELEMENTS);
        this.doubleCorrespondenceMap().validate(rootDescriptor, FieldDescriptorValidator.IS_DOUBLE_FIELD);
        this.floatCorrespondenceMap().validate(rootDescriptor, FieldDescriptorValidator.IS_FLOAT_FIELD);
        this.compareFieldsScope().validate(rootDescriptor, FieldDescriptorValidator.ALLOW_ALL);
    }

    final ProtoTruthMessageDifferencer toMessageDifferencer(Descriptors.Descriptor descriptor) {
        Preconditions.checkState((boolean)this.hasExpectedMessages(), (Object)"withExpectedMessages() not called");
        return (ProtoTruthMessageDifferencer)this.messageDifferencers.getUnchecked((Object)descriptor);
    }

    final <M extends Message> Correspondence<M, M> toCorrespondence(Optional<Descriptors.Descriptor> optDescriptor) {
        Preconditions.checkState((boolean)this.hasExpectedMessages(), (Object)"withExpectedMessages() not called");
        String string = this.usingCorrespondenceString(optDescriptor);
        return Correspondence.from((Correspondence.BinaryPredicate)new Correspondence.BinaryPredicate<M, M>(){

            public boolean apply(@Nullable M actual, @Nullable M expected) {
                return ProtoTruth.assertThat(actual).usingConfig(FluentEqualityConfig.this).testIsEqualTo((Message)expected);
            }
        }, (String)new StringBuilder(65 + String.valueOf(string).length()).append("is equivalent according to assertThat(proto)").append(string).append(".isEqualTo(target) to").toString()).formattingDiffsUsing(new Correspondence.DiffFormatter<M, M>(){

            public String formatDiff(@Nullable M actual, @Nullable M expected) {
                return FluentEqualityConfig.this.formatDiff(actual, expected);
            }
        });
    }

    private <M extends Message> String formatDiff(@Nullable M actual, @Nullable M expected) {
        if (actual == null || expected == null) {
            return "";
        }
        return this.toMessageDifferencer(actual.getDescriptorForType()).diffMessages(actual, expected).printToString(this.reportMismatchesOnly());
    }

    abstract Builder toBuilder();

    @CanIgnoreReturnValue
    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setIgnoreFieldAbsenceScope(FieldScopeLogic var1);

        abstract Builder setIgnoreRepeatedFieldOrderScope(FieldScopeLogic var1);

        abstract Builder setIgnoreExtraRepeatedFieldElementsScope(FieldScopeLogic var1);

        abstract Builder setDoubleCorrespondenceMap(FieldScopeLogicMap<Correspondence<Number, Number>> var1);

        abstract Builder setFloatCorrespondenceMap(FieldScopeLogicMap<Correspondence<Number, Number>> var1);

        abstract Builder setCompareExpectedFieldsOnly(boolean var1);

        abstract Builder setHasExpectedMessages(boolean var1);

        abstract Builder setCompareFieldsScope(FieldScopeLogic var1);

        abstract Builder setReportMismatchesOnly(boolean var1);

        final Builder setUnpackingAnyUsing(TypeRegistry typeRegistry, ExtensionRegistry extensionRegistry) {
            this.setUseTypeRegistry(typeRegistry);
            this.setUseExtensionRegistry(extensionRegistry);
            return this;
        }

        abstract Builder setUseTypeRegistry(TypeRegistry var1);

        abstract Builder setUseExtensionRegistry(ExtensionRegistry var1);

        @CheckReturnValue
        abstract Function<? super Optional<Descriptors.Descriptor>, String> usingCorrespondenceStringFunction();

        abstract Builder setUsingCorrespondenceStringFunction(Function<? super Optional<Descriptors.Descriptor>, String> var1);

        abstract FluentEqualityConfig build();

        final Builder addUsingCorrespondenceString(String string) {
            return this.setUsingCorrespondenceStringFunction(FieldScopeUtil.concat(this.usingCorrespondenceStringFunction(), (Function<? super Optional<Descriptors.Descriptor>, String>)Functions.constant((Object)string)));
        }

        final Builder addUsingCorrespondenceFieldNumbersString(String fmt, Iterable<Integer> fieldNumbers) {
            return this.setUsingCorrespondenceStringFunction(FieldScopeUtil.concat(this.usingCorrespondenceStringFunction(), FieldScopeUtil.fieldNumbersFunction(fmt, fieldNumbers)));
        }

        final Builder addUsingCorrespondenceFieldDescriptorsString(String fmt, Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
            return this.setUsingCorrespondenceStringFunction(FieldScopeUtil.concat(this.usingCorrespondenceStringFunction(), (Function<? super Optional<Descriptors.Descriptor>, String>)Functions.constant((Object)String.format(fmt, FieldScopeUtil.join(fieldDescriptors)))));
        }

        final Builder addUsingCorrespondenceFieldScopeString(String fmt, FieldScope fieldScope) {
            return this.setUsingCorrespondenceStringFunction(FieldScopeUtil.concat(this.usingCorrespondenceStringFunction(), FieldScopeUtil.fieldScopeFunction(fmt, fieldScope)));
        }
    }
}

