/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import javax.lang.model.element.ElementKind;

@BugPattern(summary="Type parameter used as type qualifier", severity=BugPattern.SeverityLevel.ERROR, suppressionAnnotations={})
public class TypeParameterQualifier
extends BugChecker
implements BugChecker.MemberSelectTreeMatcher {
    public Description matchMemberSelect(MemberSelectTree tree, VisitorState state) {
        Symbol baseSym = ASTHelpers.getSymbol((Tree)tree.getExpression());
        if (baseSym == null || baseSym.getKind() != ElementKind.TYPE_PARAMETER) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        fix.replace((Tree)tree, SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (Symbol)ASTHelpers.getSymbol((Tree)tree)));
        return this.describeMatch(tree, (Fix)fix.build());
    }
}

