/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.errorprone.org.plumelib.util;

import java.util.Collections;
import java.util.IdentityHashMap;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.errorprone.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.errorprone.checker.formatter.qual.FormatBottom;
import org.checkerframework.errorprone.checker.formatter.qual.UnknownFormat;
import org.checkerframework.errorprone.checker.index.qual.LessThanUnknown;
import org.checkerframework.errorprone.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.errorprone.checker.index.qual.SameLenUnknown;
import org.checkerframework.errorprone.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.errorprone.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.errorprone.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.errorprone.checker.initialization.qual.Initialized;
import org.checkerframework.errorprone.checker.interning.qual.FindDistinct;
import org.checkerframework.errorprone.checker.interning.qual.Interned;
import org.checkerframework.errorprone.checker.interning.qual.UnknownInterned;
import org.checkerframework.errorprone.checker.lock.qual.GuardSatisfied;
import org.checkerframework.errorprone.checker.lock.qual.GuardedBy;
import org.checkerframework.errorprone.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.errorprone.checker.mustcall.qual.MustCall;
import org.checkerframework.errorprone.checker.nullness.qual.NonNull;
import org.checkerframework.errorprone.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.errorprone.checker.regex.qual.UnknownRegex;
import org.checkerframework.errorprone.checker.signature.qual.SignatureUnknown;
import org.checkerframework.errorprone.checker.signedness.qual.Signed;
import org.checkerframework.errorprone.checker.signedness.qual.UnknownSignedness;
import org.checkerframework.errorprone.common.returnsreceiver.qual.UnknownThis;
import org.checkerframework.errorprone.common.value.qual.UnknownVal;
import org.checkerframework.errorprone.org.plumelib.util.AbstractMostlySingletonSet;

public final class IdentityMostlySingletonSet<@FormatBottom T>
extends AbstractMostlySingletonSet<T> {
    public IdentityMostlySingletonSet() {
        super(AbstractMostlySingletonSet.State.EMPTY);
    }

    public IdentityMostlySingletonSet(T value) {
        super(AbstractMostlySingletonSet.State.SINGLETON, value);
    }

    @Override
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed boolean add(@GuardSatisfied IdentityMostlySingletonSet<T> this, @FindDistinct T e) {
        switch (this.state) {
            case EMPTY: {
                this.state = AbstractMostlySingletonSet.State.SINGLETON;
                this.value = e;
                return true;
            }
            case SINGLETON: {
                if (this.value == e) {
                    return false;
                }
                this.makeNonSingleton();
            }
            case ANY: {
                assert (this.set != null) : "@AssumeAssertion(nullness): set initialized before";
                return this.set.add(e);
            }
        }
        throw new IllegalStateException("Unhandled state " + (Object)((Object)this.state));
    }

    private void makeNonSingleton(@GuardSatisfied IdentityMostlySingletonSet<T> this) {
        this.state = AbstractMostlySingletonSet.State.ANY;
        this.set = Collections.newSetFromMap(new IdentityHashMap(4));
        assert (this.value != null) : "@AssumeAssertion(nullness): previous add is non-null";
        this.set.add(this.value);
        this.value = null;
    }

    @Override
    @Pure
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed boolean contains(@GuardSatisfied IdentityMostlySingletonSet<T> this, @GuardSatisfied @UnknownSignedness @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown Object o) {
        switch (this.state) {
            case EMPTY: {
                return false;
            }
            case SINGLETON: {
                return o == this.value;
            }
            case ANY: {
                assert (this.set != null) : "@AssumeAssertion(nullness): set initialized before";
                return this.set.contains(o);
            }
        }
        throw new IllegalStateException("Unhandled state " + (Object)((Object)this.state));
    }
}

