/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.nullness;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.nullness.NullnessUtils;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Name;
import javax.lang.model.type.TypeKind;

@BugPattern(summary="Parameter has handling for null but is not annotated @Nullable", severity=BugPattern.SeverityLevel.SUGGESTION)
public final class ParameterMissingNullable
extends BugChecker
implements BugChecker.BinaryTreeMatcher,
BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewClassTreeMatcher {
    private final boolean beingConservative;

    @Inject
    ParameterMissingNullable(ErrorProneFlags flags) {
        this.beingConservative = NullnessUtils.nullnessChecksShouldBeConservative(flags);
    }

    public Description matchBinary(BinaryTree tree, VisitorState state) {
        if (this.beingConservative) {
            return Description.NO_MATCH;
        }
        NullnessUtils.NullCheck nullCheck = NullnessUtils.getNullCheck(tree);
        if (nullCheck == null) {
            return Description.NO_MATCH;
        }
        Symbol.VarSymbol symbol = nullCheck.varSymbolButUsuallyPreferBareIdentifier();
        if (!ParameterMissingNullable.isParameterWithoutNullable(symbol)) {
            return Description.NO_MATCH;
        }
        if (ParameterMissingNullable.isLoopCondition(state.getPath())) {
            return Description.NO_MATCH;
        }
        if (ParameterMissingNullable.nullCheckLikelyToProduceException(state)) {
            return Description.NO_MATCH;
        }
        VariableTree param = NullnessUtils.findDeclaration(state, symbol);
        if (param == null) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.hasNoExplicitType((VariableTree)param, (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        SuggestedFix fix = NullnessUtils.fixByAddingNullableAnnotationToType(state, param);
        if (fix.isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, (Fix)fix);
    }

    private static boolean isLoopCondition(TreePath path) {
        switch (path.getParentPath().getParentPath().getLeaf().getKind()) {
            case WHILE_LOOP: 
            case DO_WHILE_LOOP: {
                return true;
            }
        }
        switch (path.getParentPath().getLeaf().getKind()) {
            case FOR_LOOP: {
                return true;
            }
        }
        return false;
    }

    private static boolean isParameterWithoutNullable(Symbol sym) {
        return sym != null && sym.getKind() == ElementKind.PARAMETER && !NullnessUtils.isAlreadyAnnotatedNullable(sym);
    }

    private static boolean nullCheckLikelyToProduceException(final VisitorState state) {
        final boolean[] likelyToProduceException = new boolean[]{false};
        Tree childInPath = null;
        for (Tree tree : state.getPath()) {
            if (tree instanceof AssertTree || tree instanceof MethodInvocationTree) {
                return true;
            }
            if (tree instanceof IfTree && childInPath.equals(((IfTree)tree).getCondition())) {
                new TreeScanner<Void, Void>(){

                    @Override
                    public Void visitNewClass(NewClassTree tree, Void unused) {
                        likelyToProduceException[0] = likelyToProduceException[0] | state.getTypes().isSubtype(ASTHelpers.getType((Tree)tree), state.getSymtab().throwableType);
                        return (Void)super.visitNewClass(tree, unused);
                    }

                    @Override
                    public Void visitThrow(ThrowTree tree, Void unused) {
                        likelyToProduceException[0] = true;
                        return null;
                    }
                }.scan(tree, null);
            }
            childInPath = tree;
        }
        return likelyToProduceException[0];
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return this.matchCall(ASTHelpers.getSymbol((MethodInvocationTree)tree), tree.getArguments(), state);
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        return this.matchCall(ASTHelpers.getSymbol((NewClassTree)tree), tree.getArguments(), state);
    }

    private Description matchCall(Symbol.MethodSymbol methodSymbol, List<? extends ExpressionTree> arguments, VisitorState state) {
        if (NullnessUtils.hasExtraParameterForEnclosingInstance(methodSymbol)) {
            return Description.NO_MATCH;
        }
        if (methodSymbol.isVarArgs()) {
            return Description.NO_MATCH;
        }
        Streams.forEachPair(arguments.stream(), methodSymbol.getParameters().stream(), (argTree, paramSymbol) -> {
            if (!NullnessUtils.hasDefinitelyNullBranch(argTree, (Set<Symbol.VarSymbol>)ImmutableSet.of(), (ImmutableSet<Name>)ImmutableSet.of(), state)) {
                return;
            }
            if (NullnessUtils.isAlreadyAnnotatedNullable(paramSymbol)) {
                return;
            }
            if (((Type)paramSymbol.asType()).getKind() == TypeKind.TYPEVAR) {
                return;
            }
            VariableTree paramTree = NullnessUtils.findDeclaration(state, paramSymbol);
            if (paramTree == null) {
                return;
            }
            SuggestedFix fix = NullnessUtils.fixByAddingNullableAnnotationToType(state, paramTree);
            if (fix.isEmpty()) {
                return;
            }
            state.reportMatch(this.describeMatch((Tree)argTree, (Fix)fix));
        });
        return Description.NO_MATCH;
    }
}

