/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractReturnValueIgnored;
import com.google.errorprone.bugpatterns.threadsafety.ConstantExpressions;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.predicates.type.DescendantOf;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.SideEffectAnalysis;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import javax.inject.Inject;

@BugPattern(summary="Unnecessary call to proto's #build() method.  If you don't consume the return value of #build(), the result is discarded and the only effect is to verify that all required fields are set, which can be expressed more directly with #isInitialized().", severity=BugPattern.SeverityLevel.ERROR)
public final class ProtoBuilderReturnValueIgnored
extends AbstractReturnValueIgnored {
    private static final Matcher<ExpressionTree> BUILDER = MethodMatchers.instanceMethod().onDescendantOf("com.google.protobuf.MessageLite.Builder").namedAnyOf(new String[]{"build", "buildPartial"});
    public static final Matcher<ExpressionTree> MATCHER = Matchers.allOf((Matcher[])new Matcher[]{BUILDER, ProtoBuilderReturnValueIgnored::doesNotTerminateInNewBuilder});
    private static final Matcher<ExpressionTree> ROOT_INVOCATIONS_TO_IGNORE = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClass((TypePredicate)new DescendantOf(Suppliers.typeFromString((String)"com.google.protobuf.MessageLite"))).namedAnyOf(new String[]{"newBuilder"}), MethodMatchers.instanceMethod().onDescendantOf("com.google.protobuf.MessageLite").namedAnyOf(new String[]{"toBuilder"})});

    @Inject
    ProtoBuilderReturnValueIgnored(ConstantExpressions constantExpressions) {
        super(constantExpressions);
    }

    @Override
    public Matcher<? super ExpressionTree> specializedMatcher() {
        return MATCHER;
    }

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Description description = super.matchMethodInvocation(tree, state);
        if (description.equals(Description.NO_MATCH)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).addAllFixes(ProtoBuilderReturnValueIgnored.generateFixes(tree, state)).build();
    }

    private static ImmutableList<SuggestedFix> generateFixes(MethodInvocationTree tree, VisitorState state) {
        SuggestedFix.Builder simpleFixBuilder = SuggestedFix.builder().setShortDescription("Remove the call to #build. Note that this will not validate the presence of required fields.");
        ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)tree);
        if (receiver instanceof IdentifierTree || receiver instanceof MemberSelectTree) {
            simpleFixBuilder.replace(state.getPath().getParentPath().getLeaf(), "");
            if (SideEffectAnalysis.hasSideEffect((ExpressionTree)receiver)) {
                simpleFixBuilder.setShortDescription("Remove the call to #build. Note that this will not validate the presence of required fields, and removes any side effects of the receiver expression.");
            }
        } else {
            simpleFixBuilder.replace(state.getEndPosition((Tree)receiver), state.getEndPosition((Tree)tree), "");
        }
        SuggestedFix simpleFix = simpleFixBuilder.build();
        SuggestedFix withRequiredFieldCheck = SuggestedFix.builder().setShortDescription("Replace the call to #build with an explicit check that required fields are present.").addStaticImport("com.google.common.base.Preconditions.checkState").prefixWith((Tree)tree, "checkState(").replace(state.getEndPosition((Tree)receiver), state.getEndPosition((Tree)tree), ".isInitialized())").build();
        return ImmutableList.of((Object)simpleFix, (Object)withRequiredFieldCheck);
    }

    private static boolean doesNotTerminateInNewBuilder(ExpressionTree tree, VisitorState state) {
        return ASTHelpers.streamReceivers((ExpressionTree)tree).noneMatch(t -> ROOT_INVOCATIONS_TO_IGNORE.matches((Tree)t, state));
    }
}

