/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.ReplacementVariableFinder;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;
import java.util.List;
import java.util.function.Predicate;
import javax.lang.model.element.ElementKind;

@BugPattern(summary="Using a collection function with itself as the argument.", severity=BugPattern.SeverityLevel.ERROR)
public class ModifyingCollectionWithItself
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<MethodInvocationTree> IS_COLLECTION_MODIFIED_WITH_ITSELF = ModifyingCollectionWithItself.buildMatcher();

    private static Matcher<MethodInvocationTree> buildMatcher() {
        return Matchers.anyOf((Matcher[])new Matcher[]{Matchers.allOf((Matcher[])new Matcher[]{Matchers.anyOf((Matcher[])new Matcher[]{Matchers.instanceMethod().onDescendantOf("java.util.Collection").named("addAll"), Matchers.instanceMethod().onDescendantOf("java.util.Collection").named("removeAll"), Matchers.instanceMethod().onDescendantOf("java.util.Collection").named("containsAll"), Matchers.instanceMethod().onDescendantOf("java.util.Collection").named("retainAll")}), Matchers.receiverSameAsArgument((int)0)}), Matchers.allOf((Matcher[])new Matcher[]{Matchers.instanceMethod().onDescendantOf("java.util.Collection").named("addAll"), Matchers.receiverSameAsArgument((int)1)})});
    }

    public Description matchMethodInvocation(MethodInvocationTree t, VisitorState state) {
        if (IS_COLLECTION_MODIFIED_WITH_ITSELF.matches((Tree)t, state)) {
            return this.describe(t, state);
        }
        return Description.NO_MATCH;
    }

    private Description describe(MethodInvocationTree methodInvocationTree, VisitorState state) {
        ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)methodInvocationTree);
        List<? extends ExpressionTree> arguments = methodInvocationTree.getArguments();
        ExpressionTree argument = arguments.size() == 2 ? arguments.get(1) : arguments.get(0);
        Description.Builder builder = this.buildDescription(methodInvocationTree);
        for (Fix fix : ModifyingCollectionWithItself.buildFixes(methodInvocationTree, state, receiver, argument)) {
            builder.addFix(fix);
        }
        return builder.build();
    }

    private static List<Fix> buildFixes(MethodInvocationTree methodInvocationTree, VisitorState state, ExpressionTree receiver, ExpressionTree argument) {
        ImmutableList<Fix> fixes;
        if (receiver.getKind() == Tree.Kind.MEMBER_SELECT) {
            fixes = ReplacementVariableFinder.fixesByReplacingExpressionWithMethodParameter(argument, ModifyingCollectionWithItself.isCollectionVariable(state), state);
        } else {
            Preconditions.checkState((receiver.getKind() == Tree.Kind.IDENTIFIER ? 1 : 0) != 0, (Object)"receiver.getKind is identifier");
            boolean lhsIsField = ASTHelpers.getSymbol((Tree)receiver).getKind() == ElementKind.FIELD;
            ImmutableList<Fix> immutableList = fixes = lhsIsField ? ReplacementVariableFinder.fixesByReplacingExpressionWithMethodParameter(argument, ModifyingCollectionWithItself.isCollectionVariable(state), state) : ReplacementVariableFinder.fixesByReplacingExpressionWithLocallyDeclaredField(receiver, ModifyingCollectionWithItself.isCollectionVariable(state), state);
        }
        if (fixes.isEmpty()) {
            fixes = ModifyingCollectionWithItself.literalReplacement(methodInvocationTree, state, receiver);
        }
        return fixes;
    }

    private static Predicate<JCTree.JCVariableDecl> isCollectionVariable(VisitorState state) {
        return var -> Matchers.variableType((Matcher)Matchers.isSubtypeOf((String)"java.util.Collection")).matches((Tree)var, state);
    }

    private static ImmutableList<Fix> literalReplacement(MethodInvocationTree methodInvocationTree, VisitorState state, ExpressionTree lhs) {
        Tree parent = state.getPath().getParentPath().getLeaf();
        if (parent instanceof ExpressionStatementTree) {
            SuggestedFix fix = Matchers.instanceMethod().anyClass().named("removeAll").matches((Tree)methodInvocationTree, state) ? SuggestedFix.replace((Tree)methodInvocationTree, (String)(state.getSourceForNode((Tree)lhs) + ".clear()")) : SuggestedFix.delete((Tree)parent);
            return ImmutableList.of((Object)fix);
        }
        return ImmutableList.of();
    }
}

