/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dependency;

import com.android.builder.model.MavenCoordinates;
import com.google.common.base.Preconditions;
import java.io.File;

public class JarDependency {
    private final File mJarFile;
    private final boolean mCompiled;
    private final boolean mPackaged;
    private final boolean mProguarded;
    private final String mProjectPath;
    private final MavenCoordinates mResolvedCoordinates;

    public JarDependency(File jarFile, boolean compiled, boolean packaged, boolean proguarded, MavenCoordinates resolvedCoordinates, String projectPath) {
        Preconditions.checkNotNull((Object)jarFile);
        this.mJarFile = jarFile;
        this.mCompiled = compiled;
        this.mPackaged = packaged;
        this.mProguarded = proguarded;
        this.mResolvedCoordinates = resolvedCoordinates;
        this.mProjectPath = projectPath;
    }

    public JarDependency(File jarFile, boolean compiled, boolean packaged, MavenCoordinates resolvedCoordinates, String projectPath) {
        this(jarFile, compiled, packaged, true, resolvedCoordinates, projectPath);
    }

    public File getJarFile() {
        return this.mJarFile;
    }

    public boolean isCompiled() {
        return this.mCompiled;
    }

    public boolean isPackaged() {
        return this.mPackaged;
    }

    public boolean isProguarded() {
        return this.mProguarded;
    }

    public MavenCoordinates getResolvedCoordinates() {
        return this.mResolvedCoordinates;
    }

    public String getProjectPath() {
        return this.mProjectPath;
    }

    public String toString() {
        return "JarDependency{mJarFile=" + this.mJarFile + ", mCompiled=" + this.mCompiled + ", mPackaged=" + this.mPackaged + ", mProguarded=" + this.mProguarded + ", mResolvedCoordinates=" + this.mResolvedCoordinates + '}';
    }
}

