/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.common.collect.Sets;
import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashSet;

final class HashSetCodec<E>
implements ObjectCodec<HashSet<E>> {
    HashSetCodec() {
    }

    @Override
    public Class<HashSet<E>> getEncodedClass() {
        return HashSet.class;
    }

    @Override
    public void serialize(SerializationContext context, HashSet<E> obj, CodedOutputStream codedOut) throws SerializationException, IOException {
        codedOut.writeInt32NoTag(obj.size());
        for (E object : obj) {
            context.serialize(object, codedOut);
        }
    }

    @Override
    public LinkedHashSet<E> deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
        int size = codedIn.readInt32();
        LinkedHashSet set = Sets.newLinkedHashSetWithExpectedSize((int)size);
        for (int i = 0; i < size; ++i) {
            set.add(context.deserialize(codedIn));
        }
        return set;
    }
}

