/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.compile;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreePath;
import java.util.List;

final class Breadcrumbs {
    private static final BreadcrumbVisitor BREADCRUMB_VISITOR = new BreadcrumbVisitor();

    private Breadcrumbs() {
    }

    static String describeTreePath(TreePath path) {
        return Joiner.on((String)"->").join(Breadcrumbs.getBreadcrumbList(path));
    }

    static List<String> getBreadcrumbList(TreePath path) {
        return Lists.reverse((List)FluentIterable.from((Iterable)path).transform((Function)new Function<Tree, String>(){

            public String apply(Tree t) {
                return t.accept(BREADCRUMB_VISITOR, null);
            }
        }).toList());
    }

    static final class BreadcrumbVisitor
    extends SimpleTreeVisitor<String, Void> {
        BreadcrumbVisitor() {
        }

        private String kindString(Tree t) {
            return t.getKind().toString();
        }

        private String detailedKindString(Tree t, Object detail) {
            return String.format("%s(%s)", this.kindString(t), detail);
        }

        @Override
        public String defaultAction(Tree t, Void v) {
            return t != null ? this.kindString(t) : "";
        }

        @Override
        public String visitBlock(BlockTree reference, Void v) {
            return reference != null ? this.detailedKindString(reference, reference.isStatic() ? "static" : "non-static") : "";
        }

        @Override
        public String visitBreak(BreakTree reference, Void v) {
            return reference != null ? this.detailedKindString(reference, reference.getLabel()) : "";
        }

        @Override
        public String visitClass(ClassTree reference, Void v) {
            return reference != null ? this.detailedKindString(reference, reference.getSimpleName()) : "";
        }

        @Override
        public String visitContinue(ContinueTree reference, Void v) {
            return reference != null ? this.detailedKindString(reference, reference.getLabel()) : "";
        }

        @Override
        public String visitIdentifier(IdentifierTree reference, Void v) {
            return reference != null ? this.detailedKindString(reference, reference.getName()) : "";
        }

        @Override
        public String visitImport(ImportTree reference, Void v) {
            return reference != null ? this.detailedKindString(reference, reference.isStatic() ? "static" : "non-static") : "";
        }

        @Override
        public String visitLabeledStatement(LabeledStatementTree reference, Void v) {
            return reference != null ? this.detailedKindString(reference, reference.getLabel()) : "";
        }

        @Override
        public String visitLiteral(LiteralTree reference, Void v) {
            return reference != null ? this.detailedKindString(reference, reference.getValue()) : "";
        }

        @Override
        public String visitMethod(MethodTree reference, Void v) {
            return reference != null ? this.detailedKindString(reference, reference.getName()) : "";
        }

        @Override
        public String visitModifiers(ModifiersTree reference, Void v) {
            return reference != null ? this.detailedKindString(reference, reference.getFlags()) : "";
        }

        @Override
        public String visitMemberSelect(MemberSelectTree reference, Void v) {
            return reference != null ? this.detailedKindString(reference, reference.getIdentifier()) : "";
        }

        @Override
        public String visitPrimitiveType(PrimitiveTypeTree reference, Void v) {
            return reference != null ? this.detailedKindString(reference, (Object)reference.getPrimitiveTypeKind()) : "";
        }

        @Override
        public String visitTypeParameter(TypeParameterTree reference, Void v) {
            return reference != null ? this.detailedKindString(reference, reference.getName()) : "";
        }

        @Override
        public String visitVariable(VariableTree reference, Void v) {
            return reference != null ? this.detailedKindString(reference, reference.getName()) : "";
        }
    }
}

