/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.errorprone.javacutil;

import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.errorprone.checker.nullness.qual.Nullable;
import org.checkerframework.errorprone.javacutil.BugInCF;
import org.checkerframework.errorprone.javacutil.TypesUtils;

public final class TypeKindUtils {
    private TypeKindUtils() {
        throw new AssertionError((Object)"Class TypeKindUtils cannot be instantiated.");
    }

    public static boolean isIntegral(TypeKind typeKind) {
        switch (typeKind) {
            case INT: 
            case SHORT: 
            case BYTE: 
            case CHAR: 
            case LONG: {
                return true;
            }
        }
        return false;
    }

    public static boolean isFloatingPoint(TypeKind typeKind) {
        switch (typeKind) {
            case FLOAT: 
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }

    public static boolean isNumeric(TypeKind typeKind) {
        switch (typeKind) {
            case INT: 
            case SHORT: 
            case BYTE: 
            case CHAR: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }

    public static @Nullable TypeKind primitiveOrBoxedToTypeKind(TypeMirror type) {
        String typeString;
        TypeKind typeKind = type.getKind();
        if (typeKind.isPrimitive()) {
            return typeKind;
        }
        if (!(type instanceof DeclaredType)) {
            return null;
        }
        switch (typeString = TypesUtils.getQualifiedName((DeclaredType)type).toString()) {
            case "java.lang.Byte": {
                return TypeKind.BYTE;
            }
            case "java.lang.Boolean": {
                return TypeKind.BOOLEAN;
            }
            case "java.lang.Character": {
                return TypeKind.CHAR;
            }
            case "java.lang.Double": {
                return TypeKind.DOUBLE;
            }
            case "java.lang.Float": {
                return TypeKind.FLOAT;
            }
            case "java.lang.Integer": {
                return TypeKind.INT;
            }
            case "java.lang.Long": {
                return TypeKind.LONG;
            }
            case "java.lang.Short": {
                return TypeKind.SHORT;
            }
        }
        return null;
    }

    public static TypeKind widenedNumericType(TypeMirror left, TypeMirror right) {
        return TypeKindUtils.widenedNumericType(left.getKind(), right.getKind());
    }

    public static TypeKind widenedNumericType(TypeKind a, TypeKind b) {
        if (!TypeKindUtils.isNumeric(a) || !TypeKindUtils.isNumeric(b)) {
            return TypeKind.NONE;
        }
        if (a == TypeKind.DOUBLE || b == TypeKind.DOUBLE) {
            return TypeKind.DOUBLE;
        }
        if (a == TypeKind.FLOAT || b == TypeKind.FLOAT) {
            return TypeKind.FLOAT;
        }
        if (a == TypeKind.LONG || b == TypeKind.LONG) {
            return TypeKind.LONG;
        }
        return TypeKind.INT;
    }

    public static PrimitiveConversionKind getPrimitiveConversionKind(TypeKind from, TypeKind to) {
        if (from == TypeKind.BOOLEAN && to == TypeKind.BOOLEAN) {
            return PrimitiveConversionKind.SAME;
        }
        assert ((TypeKindUtils.isIntegral(from) || TypeKindUtils.isFloatingPoint(from)) && (TypeKindUtils.isIntegral(to) || TypeKindUtils.isFloatingPoint(to))) : "getPrimitiveConversionKind " + (Object)((Object)from) + " " + (Object)((Object)to);
        if (from == to) {
            return PrimitiveConversionKind.SAME;
        }
        boolean fromIntegral = TypeKindUtils.isIntegral(from);
        boolean toFloatingPoint = TypeKindUtils.isFloatingPoint(to);
        if (fromIntegral && toFloatingPoint) {
            return PrimitiveConversionKind.WIDENING;
        }
        boolean toIntegral = TypeKindUtils.isIntegral(to);
        boolean fromFloatingPoint = TypeKindUtils.isFloatingPoint(from);
        if (fromFloatingPoint && toIntegral) {
            return PrimitiveConversionKind.NARROWING;
        }
        if (TypeKindUtils.numBits(from) < TypeKindUtils.numBits(to)) {
            return PrimitiveConversionKind.WIDENING;
        }
        return PrimitiveConversionKind.NARROWING;
    }

    private static int numBits(TypeKind tk) {
        switch (tk) {
            case BYTE: {
                return 8;
            }
            case SHORT: {
                return 16;
            }
            case CHAR: {
                return 16;
            }
            case INT: {
                return 32;
            }
            case LONG: {
                return 64;
            }
            case FLOAT: {
                return 32;
            }
            case DOUBLE: {
                return 64;
            }
        }
        return -1;
    }

    public static long minValue(TypeKind tk) {
        switch (tk) {
            case BYTE: {
                return -128L;
            }
            case SHORT: {
                return -32768L;
            }
            case CHAR: {
                return 0L;
            }
            case INT: {
                return Integer.MIN_VALUE;
            }
            case LONG: {
                return Long.MIN_VALUE;
            }
        }
        throw new BugInCF((Object)((Object)tk) + " does not have a minimum value");
    }

    public static long maxValue(TypeKind tk) {
        switch (tk) {
            case BYTE: {
                return 127L;
            }
            case SHORT: {
                return 32767L;
            }
            case CHAR: {
                return 65535L;
            }
            case INT: {
                return Integer.MAX_VALUE;
            }
            case LONG: {
                return Long.MAX_VALUE;
            }
        }
        throw new BugInCF((Object)((Object)tk) + " does not have a maximum value");
    }

    public static enum PrimitiveConversionKind {
        SAME,
        WIDENING,
        NARROWING;

    }
}

