/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.errorprone.dataflow.util;

import java.util.LinkedHashSet;
import org.checkerframework.errorprone.dataflow.util.AbstractMostlySingleton;
import org.checkerframework.errorprone.javacutil.BugInCF;

public final class MostlySingleton<T>
extends AbstractMostlySingleton<T> {
    public MostlySingleton() {
        super(AbstractMostlySingleton.State.EMPTY);
    }

    public MostlySingleton(T value) {
        super(AbstractMostlySingleton.State.SINGLETON, value);
    }

    @Override
    public boolean add(T e) {
        switch (this.state) {
            case EMPTY: {
                this.state = AbstractMostlySingleton.State.SINGLETON;
                this.value = e;
                return true;
            }
            case SINGLETON: {
                assert (this.value != null) : "@AssumeAssertion(nullness): SINGLETON => value != null";
                if (this.value.equals(e)) {
                    return false;
                }
                this.makeNonSingleton();
            }
            case ANY: {
                assert (this.set != null) : "@AssumeAssertion(nullness): ANY => value != null";
                return this.set.add(e);
            }
        }
        throw new BugInCF("Unhandled state " + (Object)((Object)this.state));
    }

    private void makeNonSingleton() {
        this.state = AbstractMostlySingleton.State.ANY;
        this.set = new LinkedHashSet();
        assert (this.value != null) : "@AssumeAssertion(nullness): SINGLETON => value != null";
        this.set.add(this.value);
        this.value = null;
    }

    @Override
    public boolean contains(Object o) {
        switch (this.state) {
            case EMPTY: {
                return false;
            }
            case SINGLETON: {
                assert (this.value != null) : "@AssumeAssertion(nullness): SINGLETON => value != null";
                return this.value.equals(o);
            }
            case ANY: {
                assert (this.set != null) : "@AssumeAssertion(nullness): set initialized before";
                return this.set.contains(o);
            }
        }
        throw new BugInCF("Unhandled state " + (Object)((Object)this.state));
    }
}

