/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.errorprone.dataflow.cfg.node;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.checkerframework.errorprone.checker.nullness.qual.Nullable;
import org.checkerframework.errorprone.dataflow.cfg.node.ArrayAccessNode;
import org.checkerframework.errorprone.dataflow.cfg.node.AssignmentContext;
import org.checkerframework.errorprone.dataflow.cfg.node.FieldAccessNode;
import org.checkerframework.errorprone.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.errorprone.dataflow.cfg.node.Node;
import org.checkerframework.errorprone.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.errorprone.javacutil.TreeUtils;

public class AssignmentNode
extends Node {
    protected final Tree tree;
    protected final Node lhs;
    protected final Node rhs;

    public AssignmentNode(Tree tree, Node target, Node expression) {
        super(TreeUtils.typeOf(tree));
        assert (tree instanceof AssignmentTree || tree instanceof VariableTree || tree instanceof CompoundAssignmentTree || tree instanceof UnaryTree);
        assert (target instanceof FieldAccessNode || target instanceof LocalVariableNode || target instanceof ArrayAccessNode);
        this.tree = tree;
        this.lhs = target;
        this.rhs = expression;
        this.rhs.setAssignmentContext(new AssignmentContext.AssignmentLhsContext(this.lhs));
    }

    public Node getTarget() {
        return this.lhs;
    }

    public Node getExpression() {
        return this.rhs;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitAssignment(this, p);
    }

    public String toString() {
        return this.getTarget() + " = " + this.getExpression();
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof AssignmentNode)) {
            return false;
        }
        AssignmentNode other = (AssignmentNode)obj;
        return this.getTarget().equals(other.getTarget()) && this.getExpression().equals(other.getExpression());
    }

    public int hashCode() {
        return Objects.hash(this.getTarget(), this.getExpression());
    }

    @Override
    public Collection<Node> getOperands() {
        return Arrays.asList(this.getTarget(), this.getExpression());
    }
}

