/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(summary="Using dangerous ClassLoader APIs may deserialize untrusted user input into bytecode, leading to remote code execution vulnerabilities", severity=BugPattern.SeverityLevel.ERROR)
public final class BanClassLoader
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.anyMethod().onDescendantOf("java.lang.ClassLoader").namedAnyOf(new String[]{"defineClass", "findClass"}), Matchers.anyMethod().onDescendantOf("java.lang.invoke.MethodHandles.Lookup").named("defineClass"), Matchers.anyMethod().onDescendantOf("java.rmi.server.RMIClassLoader").namedAnyOf(new String[]{"loadClass", "loadProxyClass"}), Matchers.anyMethod().onDescendantOf("java.rmi.server.RMIClassLoaderSpi").namedAnyOf(new String[]{"loadClass", "loadProxyClass"})});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (state.errorProneOptions().isTestOnlyTarget() || !MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        Description.Builder description = this.buildDescription(tree);
        return description.build();
    }
}

