/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.dataflow.util;

import com.sun.source.tree.MethodTree;
import java.util.EnumSet;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import org.checkerframework.shaded.dataflow.qual.Deterministic;
import org.checkerframework.shaded.dataflow.qual.Pure;
import org.checkerframework.shaded.dataflow.qual.SideEffectFree;
import org.checkerframework.shaded.javacutil.AnnotationProvider;
import org.checkerframework.shaded.javacutil.BugInCF;
import org.checkerframework.shaded.javacutil.TreeUtils;

public class PurityUtils {
    public static boolean hasPurityAnnotation(AnnotationProvider provider, MethodTree methodTree) {
        return !PurityUtils.getPurityKinds(provider, methodTree).isEmpty();
    }

    public static boolean hasPurityAnnotation(AnnotationProvider provider, Element methodElement) {
        return !PurityUtils.getPurityKinds(provider, methodElement).isEmpty();
    }

    public static boolean isDeterministic(AnnotationProvider provider, MethodTree methodTree) {
        Element methodElement = TreeUtils.elementFromTree(methodTree);
        if (methodElement == null) {
            throw new BugInCF("Could not find element for tree: " + methodTree);
        }
        return PurityUtils.isDeterministic(provider, methodElement);
    }

    public static boolean isDeterministic(AnnotationProvider provider, Element methodElement) {
        EnumSet<Pure.Kind> kinds = PurityUtils.getPurityKinds(provider, methodElement);
        return kinds.contains((Object)Pure.Kind.DETERMINISTIC);
    }

    public static boolean isSideEffectFree(AnnotationProvider provider, MethodTree methodTree) {
        Element methodElement = TreeUtils.elementFromTree(methodTree);
        if (methodElement == null) {
            throw new BugInCF("Could not find element for tree: " + methodTree);
        }
        return PurityUtils.isSideEffectFree(provider, methodElement);
    }

    public static boolean isSideEffectFree(AnnotationProvider provider, Element methodElement) {
        EnumSet<Pure.Kind> kinds = PurityUtils.getPurityKinds(provider, methodElement);
        return kinds.contains((Object)Pure.Kind.SIDE_EFFECT_FREE);
    }

    public static EnumSet<Pure.Kind> getPurityKinds(AnnotationProvider provider, MethodTree methodTree) {
        Element methodElement = TreeUtils.elementFromTree(methodTree);
        if (methodElement == null) {
            throw new BugInCF("Could not find element for tree: " + methodTree);
        }
        return PurityUtils.getPurityKinds(provider, methodElement);
    }

    public static EnumSet<Pure.Kind> getPurityKinds(AnnotationProvider provider, Element methodElement) {
        AnnotationMirror pureAnnotation = provider.getDeclAnnotation(methodElement, Pure.class);
        AnnotationMirror sefAnnotation = provider.getDeclAnnotation(methodElement, SideEffectFree.class);
        AnnotationMirror detAnnotation = provider.getDeclAnnotation(methodElement, Deterministic.class);
        if (pureAnnotation != null) {
            return EnumSet.of(Pure.Kind.DETERMINISTIC, Pure.Kind.SIDE_EFFECT_FREE);
        }
        EnumSet<Pure.Kind> result = EnumSet.noneOf(Pure.Kind.class);
        if (sefAnnotation != null) {
            result.add(Pure.Kind.SIDE_EFFECT_FREE);
        }
        if (detAnnotation != null) {
            result.add(Pure.Kind.DETERMINISTIC);
        }
        return result;
    }
}

