/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.DescribedNode;
import lombok.ast.Identifier;
import lombok.ast.ListAccessor;
import lombok.ast.Node;
import lombok.ast.RawListAccessor;
import lombok.ast.StrictListAccessor;
import lombok.ast.TypeReference;
import lombok.ast.TypeVariableTemplate;

public class TypeVariable
extends AbstractNode
implements DescribedNode {
    private AbstractNode name = this.adopt(new Identifier());
    ListAccessor<TypeReference, TypeVariable> extending = ListAccessor.of(this, TypeReference.class, "TypeVariable.extending");

    public Identifier astName() {
        if (!(this.name instanceof Identifier)) {
            return null;
        }
        return (Identifier)this.name;
    }

    public TypeVariable astName(Identifier name) {
        return this.rawName(name);
    }

    private TypeVariable rawName(Node name) {
        if (name == this.name) {
            return this;
        }
        if (name != null) {
            this.adopt((AbstractNode)name);
        }
        if (this.name != null) {
            this.disown(this.name);
        }
        this.name = (AbstractNode)name;
        return this;
    }

    public RawListAccessor<TypeReference, TypeVariable> rawExtending() {
        return this.extending.asRaw();
    }

    public StrictListAccessor<TypeReference, TypeVariable> astExtending() {
        return this.extending.asStrict();
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        if (this.name != null) {
            result.add(this.name);
        }
        result.addAll(this.extending.backingList());
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        if (this.name == original) {
            if (replacement instanceof Identifier) {
                this.astName((Identifier)replacement);
                return true;
            }
            throw new AstException(this, String.format("Cannot replace node: replacement must be of type %s but is of type %s", "Identifier", replacement == null ? "null" : replacement.getClass().getName()));
        }
        return this.rawExtending().replace(original, replacement);
    }

    @Override
    public boolean detach(Node child) {
        if (this.name == child) {
            this.disown((AbstractNode)child);
            this.name = null;
            return true;
        }
        return this.rawExtending().remove(child);
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitTypeVariable(this)) {
            return;
        }
        if (this.name != null) {
            this.name.accept(visitor);
        }
        for (AbstractNode child : this.extending.asIterable()) {
            child.accept(visitor);
        }
        visitor.afterVisitTypeVariable(this);
        visitor.endVisit(this);
    }

    @Override
    public TypeVariable copy() {
        TypeVariable result = new TypeVariable();
        if (this.name != null) {
            result.rawName(this.name.copy());
        }
        for (AbstractNode n : this.extending.backingList()) {
            result.rawExtending().addToEnd(n == null ? null : n.copy());
        }
        return result;
    }

    @Override
    public String getDescription() {
        return TypeVariableTemplate.getDescription(this);
    }
}

