/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.agent.rt.internal_b864216.output;

import java.io.IOException;
import java.net.Socket;
import org.jacoco.agent.rt.internal_b864216.IExceptionLogger;
import org.jacoco.agent.rt.internal_b864216.core.runtime.AgentOptions;
import org.jacoco.agent.rt.internal_b864216.core.runtime.RuntimeData;
import org.jacoco.agent.rt.internal_b864216.output.IAgentOutput;
import org.jacoco.agent.rt.internal_b864216.output.TcpConnection;

public class TcpClientOutput
implements IAgentOutput {
    private final IExceptionLogger logger;
    private TcpConnection connection;
    private Thread worker;

    public TcpClientOutput(IExceptionLogger logger) {
        this.logger = logger;
    }

    @Override
    public void startup(AgentOptions options, RuntimeData data) throws IOException {
        Socket socket = this.createSocket(options);
        this.connection = new TcpConnection(socket, data);
        this.connection.init();
        this.worker = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TcpClientOutput.this.connection.run();
                }
                catch (IOException e) {
                    TcpClientOutput.this.logger.logExeption(e);
                }
            }
        });
        this.worker.setName(this.getClass().getName());
        this.worker.setDaemon(true);
        this.worker.start();
    }

    @Override
    public void shutdown() throws Exception {
        this.connection.close();
        this.worker.join();
    }

    @Override
    public void writeExecutionData(boolean reset) throws IOException {
        this.connection.writeExecutionData(reset);
    }

    protected Socket createSocket(AgentOptions options) throws IOException {
        return new Socket(options.getAddress(), options.getPort());
    }
}

