/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.agent.rt.internal_b864216.core.internal.instr;

import org.jacoco.agent.rt.internal_b864216.asm.AnnotationVisitor;
import org.jacoco.agent.rt.internal_b864216.asm.Label;
import org.jacoco.agent.rt.internal_b864216.asm.MethodVisitor;
import org.jacoco.agent.rt.internal_b864216.asm.Opcodes;
import org.jacoco.agent.rt.internal_b864216.asm.Type;
import org.jacoco.agent.rt.internal_b864216.asm.TypePath;
import org.jacoco.agent.rt.internal_b864216.core.internal.instr.IProbeArrayStrategy;
import org.jacoco.agent.rt.internal_b864216.core.internal.instr.IProbeInserter;
import org.jacoco.agent.rt.internal_b864216.core.internal.instr.InstrSupport;

class ProbeInserter
extends MethodVisitor
implements IProbeInserter {
    private final IProbeArrayStrategy arrayStrategy;
    private final boolean clinit;
    private final int variable;
    private int accessorStackSize;

    ProbeInserter(int access, String name, String desc, MethodVisitor mv, IProbeArrayStrategy arrayStrategy) {
        super(589824, mv);
        this.clinit = "<clinit>".equals(name);
        this.arrayStrategy = arrayStrategy;
        int pos = (8 & access) == 0 ? 1 : 0;
        for (Type t : Type.getArgumentTypes(desc)) {
            pos += t.getSize();
        }
        this.variable = pos;
    }

    @Override
    public void insertProbe(int id) {
        this.mv.visitVarInsn(25, this.variable);
        InstrSupport.push(this.mv, id);
        this.mv.visitInsn(4);
        this.mv.visitInsn(84);
    }

    @Override
    public void visitCode() {
        this.accessorStackSize = this.arrayStrategy.storeInstance(this.mv, this.clinit, this.variable);
        this.mv.visitCode();
    }

    @Override
    public final void visitVarInsn(int opcode, int var) {
        this.mv.visitVarInsn(opcode, this.map(var));
    }

    @Override
    public final void visitIincInsn(int var, int increment) {
        this.mv.visitIincInsn(this.map(var), increment);
    }

    @Override
    public final void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        this.mv.visitLocalVariable(name, desc, signature, start, end, this.map(index));
    }

    @Override
    public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String descriptor, boolean visible) {
        int[] newIndex = new int[index.length];
        for (int i = 0; i < newIndex.length; ++i) {
            newIndex[i] = this.map(index[i]);
        }
        return this.mv.visitLocalVariableAnnotation(typeRef, typePath, start, end, newIndex, descriptor, visible);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        int increasedStack = Math.max(maxStack + 3, this.accessorStackSize);
        this.mv.visitMaxs(increasedStack, maxLocals + 1);
    }

    private int map(int var) {
        if (var < this.variable) {
            return var;
        }
        return var + 1;
    }

    @Override
    public final void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        if (type != -1) {
            throw new IllegalArgumentException("ClassReader.accept() should be called with EXPAND_FRAMES flag");
        }
        Object[] newLocal = new Object[Math.max(nLocal, this.variable) + 1];
        int idx = 0;
        int newIdx = 0;
        int pos = 0;
        while (idx < nLocal || pos <= this.variable) {
            if (pos == this.variable) {
                newLocal[newIdx++] = "[Z";
                ++pos;
                continue;
            }
            if (idx < nLocal) {
                Object t = local[idx++];
                newLocal[newIdx++] = t;
                ++pos;
                if (t != Opcodes.LONG && t != Opcodes.DOUBLE) continue;
                ++pos;
                continue;
            }
            newLocal[newIdx++] = Opcodes.TOP;
            ++pos;
        }
        this.mv.visitFrame(type, newIdx, newLocal, nStack, stack);
    }
}

