// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: build/bazel/remote/execution/v2/remote_execution.proto

package build.bazel.remote.execution.v2;

/**
 * <pre>
 * A `Directory` represents a directory node in a file tree, containing zero or
 * more children [FileNodes][build.bazel.remote.execution.v2.FileNode],
 * [DirectoryNodes][build.bazel.remote.execution.v2.DirectoryNode] and
 * [SymlinkNodes][build.bazel.remote.execution.v2.SymlinkNode].
 * Each `Node` contains its name in the directory, either the digest of its
 * content (either a file blob or a `Directory` proto) or a symlink target, as
 * well as possibly some metadata about the file or directory.
 * In order to ensure that two equivalent directory trees hash to the same
 * value, the following restrictions MUST be obeyed when constructing a
 * a `Directory`:
 * * Every child in the directory must have a path of exactly one segment.
 *   Multiple levels of directory hierarchy may not be collapsed.
 * * Each child in the directory must have a unique path segment (file name).
 *   Note that while the API itself is case-sensitive, the environment where
 *   the Action is executed may or may not be case-sensitive. That is, it is
 *   legal to call the API with a Directory that has both "Foo" and "foo" as
 *   children, but the Action may be rejected by the remote system upon
 *   execution.
 * * The files, directories and symlinks in the directory must each be sorted
 *   in lexicographical order by path. The path strings must be sorted by code
 *   point, equivalently, by UTF-8 bytes.
 * * The [NodeProperties][build.bazel.remote.execution.v2.NodeProperty] of files,
 *   directories, and symlinks must be sorted in lexicographical order by
 *   property name.
 * A `Directory` that obeys the restrictions is said to be in canonical form.
 * As an example, the following could be used for a file named `bar` and a
 * directory named `foo` with an executable file named `baz` (hashes shortened
 * for readability):
 * ```json
 * // (Directory proto)
 * {
 *   files: [
 *     {
 *       name: "bar",
 *       digest: {
 *         hash: "4a73bc9d03...",
 *         size: 65534
 *       },
 *       node_properties: [
 *         {
 *           "name": "MTime",
 *           "value": "2017-01-15T01:30:15.01Z"
 *         }
 *       ]
 *     }
 *   ],
 *   directories: [
 *     {
 *       name: "foo",
 *       digest: {
 *         hash: "4cf2eda940...",
 *         size: 43
 *       }
 *     }
 *   ]
 * }
 * // (Directory proto with hash "4cf2eda940..." and size 43)
 * {
 *   files: [
 *     {
 *       name: "baz",
 *       digest: {
 *         hash: "b2c941073e...",
 *         size: 1294,
 *       },
 *       is_executable: true
 *     }
 *   ]
 * }
 * ```
 * </pre>
 *
 * Protobuf type {@code build.bazel.remote.execution.v2.Directory}
 */
public final class Directory extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:build.bazel.remote.execution.v2.Directory)
    DirectoryOrBuilder {
private static final long serialVersionUID = 0L;
  // Use Directory.newBuilder() to construct.
  private Directory(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private Directory() {
    files_ = java.util.Collections.emptyList();
    directories_ = java.util.Collections.emptyList();
    symlinks_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new Directory();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return build.bazel.remote.execution.v2.RemoteExecutionProto.internal_static_build_bazel_remote_execution_v2_Directory_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return build.bazel.remote.execution.v2.RemoteExecutionProto.internal_static_build_bazel_remote_execution_v2_Directory_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            build.bazel.remote.execution.v2.Directory.class, build.bazel.remote.execution.v2.Directory.Builder.class);
  }

  public static final int FILES_FIELD_NUMBER = 1;
  private java.util.List<build.bazel.remote.execution.v2.FileNode> files_;
  /**
   * <pre>
   * The files in the directory.
   * </pre>
   *
   * <code>repeated .build.bazel.remote.execution.v2.FileNode files = 1;</code>
   */
  @java.lang.Override
  public java.util.List<build.bazel.remote.execution.v2.FileNode> getFilesList() {
    return files_;
  }
  /**
   * <pre>
   * The files in the directory.
   * </pre>
   *
   * <code>repeated .build.bazel.remote.execution.v2.FileNode files = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends build.bazel.remote.execution.v2.FileNodeOrBuilder> 
      getFilesOrBuilderList() {
    return files_;
  }
  /**
   * <pre>
   * The files in the directory.
   * </pre>
   *
   * <code>repeated .build.bazel.remote.execution.v2.FileNode files = 1;</code>
   */
  @java.lang.Override
  public int getFilesCount() {
    return files_.size();
  }
  /**
   * <pre>
   * The files in the directory.
   * </pre>
   *
   * <code>repeated .build.bazel.remote.execution.v2.FileNode files = 1;</code>
   */
  @java.lang.Override
  public build.bazel.remote.execution.v2.FileNode getFiles(int index) {
    return files_.get(index);
  }
  /**
   * <pre>
   * The files in the directory.
   * </pre>
   *
   * <code>repeated .build.bazel.remote.execution.v2.FileNode files = 1;</code>
   */
  @java.lang.Override
  public build.bazel.remote.execution.v2.FileNodeOrBuilder getFilesOrBuilder(
      int index) {
    return files_.get(index);
  }

  public static final int DIRECTORIES_FIELD_NUMBER = 2;
  private java.util.List<build.bazel.remote.execution.v2.DirectoryNode> directories_;
  /**
   * <pre>
   * The subdirectories in the directory.
   * </pre>
   *
   * <code>repeated .build.bazel.remote.execution.v2.DirectoryNode directories = 2;</code>
   */
  @java.lang.Override
  public java.util.List<build.bazel.remote.execution.v2.DirectoryNode> getDirectoriesList() {
    return directories_;
  }
  /**
   * <pre>
   * The subdirectories in the directory.
   * </pre>
   *
   * <code>repeated .build.bazel.remote.execution.v2.DirectoryNode directories = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends build.bazel.remote.execution.v2.DirectoryNodeOrBuilder> 
      getDirectoriesOrBuilderList() {
    return directories_;
  }
  /**
   * <pre>
   * The subdirectories in the directory.
   * </pre>
   *
   * <code>repeated .build.bazel.remote.execution.v2.DirectoryNode directories = 2;</code>
   */
  @java.lang.Override
  public int getDirectoriesCount() {
    return directories_.size();
  }
  /**
   * <pre>
   * The subdirectories in the directory.
   * </pre>
   *
   * <code>repeated .build.bazel.remote.execution.v2.DirectoryNode directories = 2;</code>
   */
  @java.lang.Override
  public build.bazel.remote.execution.v2.DirectoryNode getDirectories(int index) {
    return directories_.get(index);
  }
  /**
   * <pre>
   * The subdirectories in the directory.
   * </pre>
   *
   * <code>repeated .build.bazel.remote.execution.v2.DirectoryNode directories = 2;</code>
   */
  @java.lang.Override
  public build.bazel.remote.execution.v2.DirectoryNodeOrBuilder getDirectoriesOrBuilder(
      int index) {
    return directories_.get(index);
  }

  public static final int SYMLINKS_FIELD_NUMBER = 3;
  private java.util.List<build.bazel.remote.execution.v2.SymlinkNode> symlinks_;
  /**
   * <pre>
   * The symlinks in the directory.
   * </pre>
   *
   * <code>repeated .build.bazel.remote.execution.v2.SymlinkNode symlinks = 3;</code>
   */
  @java.lang.Override
  public java.util.List<build.bazel.remote.execution.v2.SymlinkNode> getSymlinksList() {
    return symlinks_;
  }
  /**
   * <pre>
   * The symlinks in the directory.
   * </pre>
   *
   * <code>repeated .build.bazel.remote.execution.v2.SymlinkNode symlinks = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends build.bazel.remote.execution.v2.SymlinkNodeOrBuilder> 
      getSymlinksOrBuilderList() {
    return symlinks_;
  }
  /**
   * <pre>
   * The symlinks in the directory.
   * </pre>
   *
   * <code>repeated .build.bazel.remote.execution.v2.SymlinkNode symlinks = 3;</code>
   */
  @java.lang.Override
  public int getSymlinksCount() {
    return symlinks_.size();
  }
  /**
   * <pre>
   * The symlinks in the directory.
   * </pre>
   *
   * <code>repeated .build.bazel.remote.execution.v2.SymlinkNode symlinks = 3;</code>
   */
  @java.lang.Override
  public build.bazel.remote.execution.v2.SymlinkNode getSymlinks(int index) {
    return symlinks_.get(index);
  }
  /**
   * <pre>
   * The symlinks in the directory.
   * </pre>
   *
   * <code>repeated .build.bazel.remote.execution.v2.SymlinkNode symlinks = 3;</code>
   */
  @java.lang.Override
  public build.bazel.remote.execution.v2.SymlinkNodeOrBuilder getSymlinksOrBuilder(
      int index) {
    return symlinks_.get(index);
  }

  public static final int NODE_PROPERTIES_FIELD_NUMBER = 5;
  private build.bazel.remote.execution.v2.NodeProperties nodeProperties_;
  /**
   * <code>.build.bazel.remote.execution.v2.NodeProperties node_properties = 5;</code>
   * @return Whether the nodeProperties field is set.
   */
  @java.lang.Override
  public boolean hasNodeProperties() {
    return nodeProperties_ != null;
  }
  /**
   * <code>.build.bazel.remote.execution.v2.NodeProperties node_properties = 5;</code>
   * @return The nodeProperties.
   */
  @java.lang.Override
  public build.bazel.remote.execution.v2.NodeProperties getNodeProperties() {
    return nodeProperties_ == null ? build.bazel.remote.execution.v2.NodeProperties.getDefaultInstance() : nodeProperties_;
  }
  /**
   * <code>.build.bazel.remote.execution.v2.NodeProperties node_properties = 5;</code>
   */
  @java.lang.Override
  public build.bazel.remote.execution.v2.NodePropertiesOrBuilder getNodePropertiesOrBuilder() {
    return getNodeProperties();
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    for (int i = 0; i < files_.size(); i++) {
      output.writeMessage(1, files_.get(i));
    }
    for (int i = 0; i < directories_.size(); i++) {
      output.writeMessage(2, directories_.get(i));
    }
    for (int i = 0; i < symlinks_.size(); i++) {
      output.writeMessage(3, symlinks_.get(i));
    }
    if (nodeProperties_ != null) {
      output.writeMessage(5, getNodeProperties());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < files_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(1, files_.get(i));
    }
    for (int i = 0; i < directories_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(2, directories_.get(i));
    }
    for (int i = 0; i < symlinks_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(3, symlinks_.get(i));
    }
    if (nodeProperties_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(5, getNodeProperties());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof build.bazel.remote.execution.v2.Directory)) {
      return super.equals(obj);
    }
    build.bazel.remote.execution.v2.Directory other = (build.bazel.remote.execution.v2.Directory) obj;

    if (!getFilesList()
        .equals(other.getFilesList())) return false;
    if (!getDirectoriesList()
        .equals(other.getDirectoriesList())) return false;
    if (!getSymlinksList()
        .equals(other.getSymlinksList())) return false;
    if (hasNodeProperties() != other.hasNodeProperties()) return false;
    if (hasNodeProperties()) {
      if (!getNodeProperties()
          .equals(other.getNodeProperties())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getFilesCount() > 0) {
      hash = (37 * hash) + FILES_FIELD_NUMBER;
      hash = (53 * hash) + getFilesList().hashCode();
    }
    if (getDirectoriesCount() > 0) {
      hash = (37 * hash) + DIRECTORIES_FIELD_NUMBER;
      hash = (53 * hash) + getDirectoriesList().hashCode();
    }
    if (getSymlinksCount() > 0) {
      hash = (37 * hash) + SYMLINKS_FIELD_NUMBER;
      hash = (53 * hash) + getSymlinksList().hashCode();
    }
    if (hasNodeProperties()) {
      hash = (37 * hash) + NODE_PROPERTIES_FIELD_NUMBER;
      hash = (53 * hash) + getNodeProperties().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static build.bazel.remote.execution.v2.Directory parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static build.bazel.remote.execution.v2.Directory parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static build.bazel.remote.execution.v2.Directory parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static build.bazel.remote.execution.v2.Directory parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static build.bazel.remote.execution.v2.Directory parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static build.bazel.remote.execution.v2.Directory parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static build.bazel.remote.execution.v2.Directory parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static build.bazel.remote.execution.v2.Directory parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static build.bazel.remote.execution.v2.Directory parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static build.bazel.remote.execution.v2.Directory parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static build.bazel.remote.execution.v2.Directory parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static build.bazel.remote.execution.v2.Directory parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(build.bazel.remote.execution.v2.Directory prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * A `Directory` represents a directory node in a file tree, containing zero or
   * more children [FileNodes][build.bazel.remote.execution.v2.FileNode],
   * [DirectoryNodes][build.bazel.remote.execution.v2.DirectoryNode] and
   * [SymlinkNodes][build.bazel.remote.execution.v2.SymlinkNode].
   * Each `Node` contains its name in the directory, either the digest of its
   * content (either a file blob or a `Directory` proto) or a symlink target, as
   * well as possibly some metadata about the file or directory.
   * In order to ensure that two equivalent directory trees hash to the same
   * value, the following restrictions MUST be obeyed when constructing a
   * a `Directory`:
   * * Every child in the directory must have a path of exactly one segment.
   *   Multiple levels of directory hierarchy may not be collapsed.
   * * Each child in the directory must have a unique path segment (file name).
   *   Note that while the API itself is case-sensitive, the environment where
   *   the Action is executed may or may not be case-sensitive. That is, it is
   *   legal to call the API with a Directory that has both "Foo" and "foo" as
   *   children, but the Action may be rejected by the remote system upon
   *   execution.
   * * The files, directories and symlinks in the directory must each be sorted
   *   in lexicographical order by path. The path strings must be sorted by code
   *   point, equivalently, by UTF-8 bytes.
   * * The [NodeProperties][build.bazel.remote.execution.v2.NodeProperty] of files,
   *   directories, and symlinks must be sorted in lexicographical order by
   *   property name.
   * A `Directory` that obeys the restrictions is said to be in canonical form.
   * As an example, the following could be used for a file named `bar` and a
   * directory named `foo` with an executable file named `baz` (hashes shortened
   * for readability):
   * ```json
   * // (Directory proto)
   * {
   *   files: [
   *     {
   *       name: "bar",
   *       digest: {
   *         hash: "4a73bc9d03...",
   *         size: 65534
   *       },
   *       node_properties: [
   *         {
   *           "name": "MTime",
   *           "value": "2017-01-15T01:30:15.01Z"
   *         }
   *       ]
   *     }
   *   ],
   *   directories: [
   *     {
   *       name: "foo",
   *       digest: {
   *         hash: "4cf2eda940...",
   *         size: 43
   *       }
   *     }
   *   ]
   * }
   * // (Directory proto with hash "4cf2eda940..." and size 43)
   * {
   *   files: [
   *     {
   *       name: "baz",
   *       digest: {
   *         hash: "b2c941073e...",
   *         size: 1294,
   *       },
   *       is_executable: true
   *     }
   *   ]
   * }
   * ```
   * </pre>
   *
   * Protobuf type {@code build.bazel.remote.execution.v2.Directory}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:build.bazel.remote.execution.v2.Directory)
      build.bazel.remote.execution.v2.DirectoryOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return build.bazel.remote.execution.v2.RemoteExecutionProto.internal_static_build_bazel_remote_execution_v2_Directory_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return build.bazel.remote.execution.v2.RemoteExecutionProto.internal_static_build_bazel_remote_execution_v2_Directory_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              build.bazel.remote.execution.v2.Directory.class, build.bazel.remote.execution.v2.Directory.Builder.class);
    }

    // Construct using build.bazel.remote.execution.v2.Directory.newBuilder()
    private Builder() {

    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);

    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (filesBuilder_ == null) {
        files_ = java.util.Collections.emptyList();
      } else {
        files_ = null;
        filesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (directoriesBuilder_ == null) {
        directories_ = java.util.Collections.emptyList();
      } else {
        directories_ = null;
        directoriesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      if (symlinksBuilder_ == null) {
        symlinks_ = java.util.Collections.emptyList();
      } else {
        symlinks_ = null;
        symlinksBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      if (nodePropertiesBuilder_ == null) {
        nodeProperties_ = null;
      } else {
        nodeProperties_ = null;
        nodePropertiesBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return build.bazel.remote.execution.v2.RemoteExecutionProto.internal_static_build_bazel_remote_execution_v2_Directory_descriptor;
    }

    @java.lang.Override
    public build.bazel.remote.execution.v2.Directory getDefaultInstanceForType() {
      return build.bazel.remote.execution.v2.Directory.getDefaultInstance();
    }

    @java.lang.Override
    public build.bazel.remote.execution.v2.Directory build() {
      build.bazel.remote.execution.v2.Directory result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public build.bazel.remote.execution.v2.Directory buildPartial() {
      build.bazel.remote.execution.v2.Directory result = new build.bazel.remote.execution.v2.Directory(this);
      int from_bitField0_ = bitField0_;
      if (filesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          files_ = java.util.Collections.unmodifiableList(files_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.files_ = files_;
      } else {
        result.files_ = filesBuilder_.build();
      }
      if (directoriesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          directories_ = java.util.Collections.unmodifiableList(directories_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.directories_ = directories_;
      } else {
        result.directories_ = directoriesBuilder_.build();
      }
      if (symlinksBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          symlinks_ = java.util.Collections.unmodifiableList(symlinks_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.symlinks_ = symlinks_;
      } else {
        result.symlinks_ = symlinksBuilder_.build();
      }
      if (nodePropertiesBuilder_ == null) {
        result.nodeProperties_ = nodeProperties_;
      } else {
        result.nodeProperties_ = nodePropertiesBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof build.bazel.remote.execution.v2.Directory) {
        return mergeFrom((build.bazel.remote.execution.v2.Directory)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(build.bazel.remote.execution.v2.Directory other) {
      if (other == build.bazel.remote.execution.v2.Directory.getDefaultInstance()) return this;
      if (filesBuilder_ == null) {
        if (!other.files_.isEmpty()) {
          if (files_.isEmpty()) {
            files_ = other.files_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureFilesIsMutable();
            files_.addAll(other.files_);
          }
          onChanged();
        }
      } else {
        if (!other.files_.isEmpty()) {
          if (filesBuilder_.isEmpty()) {
            filesBuilder_.dispose();
            filesBuilder_ = null;
            files_ = other.files_;
            bitField0_ = (bitField0_ & ~0x00000001);
            filesBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getFilesFieldBuilder() : null;
          } else {
            filesBuilder_.addAllMessages(other.files_);
          }
        }
      }
      if (directoriesBuilder_ == null) {
        if (!other.directories_.isEmpty()) {
          if (directories_.isEmpty()) {
            directories_ = other.directories_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureDirectoriesIsMutable();
            directories_.addAll(other.directories_);
          }
          onChanged();
        }
      } else {
        if (!other.directories_.isEmpty()) {
          if (directoriesBuilder_.isEmpty()) {
            directoriesBuilder_.dispose();
            directoriesBuilder_ = null;
            directories_ = other.directories_;
            bitField0_ = (bitField0_ & ~0x00000002);
            directoriesBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getDirectoriesFieldBuilder() : null;
          } else {
            directoriesBuilder_.addAllMessages(other.directories_);
          }
        }
      }
      if (symlinksBuilder_ == null) {
        if (!other.symlinks_.isEmpty()) {
          if (symlinks_.isEmpty()) {
            symlinks_ = other.symlinks_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureSymlinksIsMutable();
            symlinks_.addAll(other.symlinks_);
          }
          onChanged();
        }
      } else {
        if (!other.symlinks_.isEmpty()) {
          if (symlinksBuilder_.isEmpty()) {
            symlinksBuilder_.dispose();
            symlinksBuilder_ = null;
            symlinks_ = other.symlinks_;
            bitField0_ = (bitField0_ & ~0x00000004);
            symlinksBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getSymlinksFieldBuilder() : null;
          } else {
            symlinksBuilder_.addAllMessages(other.symlinks_);
          }
        }
      }
      if (other.hasNodeProperties()) {
        mergeNodeProperties(other.getNodeProperties());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              build.bazel.remote.execution.v2.FileNode m =
                  input.readMessage(
                      build.bazel.remote.execution.v2.FileNode.parser(),
                      extensionRegistry);
              if (filesBuilder_ == null) {
                ensureFilesIsMutable();
                files_.add(m);
              } else {
                filesBuilder_.addMessage(m);
              }
              break;
            } // case 10
            case 18: {
              build.bazel.remote.execution.v2.DirectoryNode m =
                  input.readMessage(
                      build.bazel.remote.execution.v2.DirectoryNode.parser(),
                      extensionRegistry);
              if (directoriesBuilder_ == null) {
                ensureDirectoriesIsMutable();
                directories_.add(m);
              } else {
                directoriesBuilder_.addMessage(m);
              }
              break;
            } // case 18
            case 26: {
              build.bazel.remote.execution.v2.SymlinkNode m =
                  input.readMessage(
                      build.bazel.remote.execution.v2.SymlinkNode.parser(),
                      extensionRegistry);
              if (symlinksBuilder_ == null) {
                ensureSymlinksIsMutable();
                symlinks_.add(m);
              } else {
                symlinksBuilder_.addMessage(m);
              }
              break;
            } // case 26
            case 42: {
              input.readMessage(
                  getNodePropertiesFieldBuilder().getBuilder(),
                  extensionRegistry);

              break;
            } // case 42
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int bitField0_;

    private java.util.List<build.bazel.remote.execution.v2.FileNode> files_ =
      java.util.Collections.emptyList();
    private void ensureFilesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        files_ = new java.util.ArrayList<build.bazel.remote.execution.v2.FileNode>(files_);
        bitField0_ |= 0x00000001;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        build.bazel.remote.execution.v2.FileNode, build.bazel.remote.execution.v2.FileNode.Builder, build.bazel.remote.execution.v2.FileNodeOrBuilder> filesBuilder_;

    /**
     * <pre>
     * The files in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.FileNode files = 1;</code>
     */
    public java.util.List<build.bazel.remote.execution.v2.FileNode> getFilesList() {
      if (filesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(files_);
      } else {
        return filesBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * The files in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.FileNode files = 1;</code>
     */
    public int getFilesCount() {
      if (filesBuilder_ == null) {
        return files_.size();
      } else {
        return filesBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * The files in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.FileNode files = 1;</code>
     */
    public build.bazel.remote.execution.v2.FileNode getFiles(int index) {
      if (filesBuilder_ == null) {
        return files_.get(index);
      } else {
        return filesBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * The files in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.FileNode files = 1;</code>
     */
    public Builder setFiles(
        int index, build.bazel.remote.execution.v2.FileNode value) {
      if (filesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFilesIsMutable();
        files_.set(index, value);
        onChanged();
      } else {
        filesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * The files in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.FileNode files = 1;</code>
     */
    public Builder setFiles(
        int index, build.bazel.remote.execution.v2.FileNode.Builder builderForValue) {
      if (filesBuilder_ == null) {
        ensureFilesIsMutable();
        files_.set(index, builderForValue.build());
        onChanged();
      } else {
        filesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The files in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.FileNode files = 1;</code>
     */
    public Builder addFiles(build.bazel.remote.execution.v2.FileNode value) {
      if (filesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFilesIsMutable();
        files_.add(value);
        onChanged();
      } else {
        filesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * The files in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.FileNode files = 1;</code>
     */
    public Builder addFiles(
        int index, build.bazel.remote.execution.v2.FileNode value) {
      if (filesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFilesIsMutable();
        files_.add(index, value);
        onChanged();
      } else {
        filesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * The files in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.FileNode files = 1;</code>
     */
    public Builder addFiles(
        build.bazel.remote.execution.v2.FileNode.Builder builderForValue) {
      if (filesBuilder_ == null) {
        ensureFilesIsMutable();
        files_.add(builderForValue.build());
        onChanged();
      } else {
        filesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The files in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.FileNode files = 1;</code>
     */
    public Builder addFiles(
        int index, build.bazel.remote.execution.v2.FileNode.Builder builderForValue) {
      if (filesBuilder_ == null) {
        ensureFilesIsMutable();
        files_.add(index, builderForValue.build());
        onChanged();
      } else {
        filesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The files in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.FileNode files = 1;</code>
     */
    public Builder addAllFiles(
        java.lang.Iterable<? extends build.bazel.remote.execution.v2.FileNode> values) {
      if (filesBuilder_ == null) {
        ensureFilesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, files_);
        onChanged();
      } else {
        filesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * The files in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.FileNode files = 1;</code>
     */
    public Builder clearFiles() {
      if (filesBuilder_ == null) {
        files_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        filesBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * The files in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.FileNode files = 1;</code>
     */
    public Builder removeFiles(int index) {
      if (filesBuilder_ == null) {
        ensureFilesIsMutable();
        files_.remove(index);
        onChanged();
      } else {
        filesBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * The files in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.FileNode files = 1;</code>
     */
    public build.bazel.remote.execution.v2.FileNode.Builder getFilesBuilder(
        int index) {
      return getFilesFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * The files in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.FileNode files = 1;</code>
     */
    public build.bazel.remote.execution.v2.FileNodeOrBuilder getFilesOrBuilder(
        int index) {
      if (filesBuilder_ == null) {
        return files_.get(index);  } else {
        return filesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * The files in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.FileNode files = 1;</code>
     */
    public java.util.List<? extends build.bazel.remote.execution.v2.FileNodeOrBuilder> 
         getFilesOrBuilderList() {
      if (filesBuilder_ != null) {
        return filesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(files_);
      }
    }
    /**
     * <pre>
     * The files in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.FileNode files = 1;</code>
     */
    public build.bazel.remote.execution.v2.FileNode.Builder addFilesBuilder() {
      return getFilesFieldBuilder().addBuilder(
          build.bazel.remote.execution.v2.FileNode.getDefaultInstance());
    }
    /**
     * <pre>
     * The files in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.FileNode files = 1;</code>
     */
    public build.bazel.remote.execution.v2.FileNode.Builder addFilesBuilder(
        int index) {
      return getFilesFieldBuilder().addBuilder(
          index, build.bazel.remote.execution.v2.FileNode.getDefaultInstance());
    }
    /**
     * <pre>
     * The files in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.FileNode files = 1;</code>
     */
    public java.util.List<build.bazel.remote.execution.v2.FileNode.Builder> 
         getFilesBuilderList() {
      return getFilesFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        build.bazel.remote.execution.v2.FileNode, build.bazel.remote.execution.v2.FileNode.Builder, build.bazel.remote.execution.v2.FileNodeOrBuilder> 
        getFilesFieldBuilder() {
      if (filesBuilder_ == null) {
        filesBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            build.bazel.remote.execution.v2.FileNode, build.bazel.remote.execution.v2.FileNode.Builder, build.bazel.remote.execution.v2.FileNodeOrBuilder>(
                files_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        files_ = null;
      }
      return filesBuilder_;
    }

    private java.util.List<build.bazel.remote.execution.v2.DirectoryNode> directories_ =
      java.util.Collections.emptyList();
    private void ensureDirectoriesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        directories_ = new java.util.ArrayList<build.bazel.remote.execution.v2.DirectoryNode>(directories_);
        bitField0_ |= 0x00000002;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        build.bazel.remote.execution.v2.DirectoryNode, build.bazel.remote.execution.v2.DirectoryNode.Builder, build.bazel.remote.execution.v2.DirectoryNodeOrBuilder> directoriesBuilder_;

    /**
     * <pre>
     * The subdirectories in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.DirectoryNode directories = 2;</code>
     */
    public java.util.List<build.bazel.remote.execution.v2.DirectoryNode> getDirectoriesList() {
      if (directoriesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(directories_);
      } else {
        return directoriesBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * The subdirectories in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.DirectoryNode directories = 2;</code>
     */
    public int getDirectoriesCount() {
      if (directoriesBuilder_ == null) {
        return directories_.size();
      } else {
        return directoriesBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * The subdirectories in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.DirectoryNode directories = 2;</code>
     */
    public build.bazel.remote.execution.v2.DirectoryNode getDirectories(int index) {
      if (directoriesBuilder_ == null) {
        return directories_.get(index);
      } else {
        return directoriesBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * The subdirectories in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.DirectoryNode directories = 2;</code>
     */
    public Builder setDirectories(
        int index, build.bazel.remote.execution.v2.DirectoryNode value) {
      if (directoriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDirectoriesIsMutable();
        directories_.set(index, value);
        onChanged();
      } else {
        directoriesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * The subdirectories in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.DirectoryNode directories = 2;</code>
     */
    public Builder setDirectories(
        int index, build.bazel.remote.execution.v2.DirectoryNode.Builder builderForValue) {
      if (directoriesBuilder_ == null) {
        ensureDirectoriesIsMutable();
        directories_.set(index, builderForValue.build());
        onChanged();
      } else {
        directoriesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The subdirectories in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.DirectoryNode directories = 2;</code>
     */
    public Builder addDirectories(build.bazel.remote.execution.v2.DirectoryNode value) {
      if (directoriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDirectoriesIsMutable();
        directories_.add(value);
        onChanged();
      } else {
        directoriesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * The subdirectories in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.DirectoryNode directories = 2;</code>
     */
    public Builder addDirectories(
        int index, build.bazel.remote.execution.v2.DirectoryNode value) {
      if (directoriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDirectoriesIsMutable();
        directories_.add(index, value);
        onChanged();
      } else {
        directoriesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * The subdirectories in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.DirectoryNode directories = 2;</code>
     */
    public Builder addDirectories(
        build.bazel.remote.execution.v2.DirectoryNode.Builder builderForValue) {
      if (directoriesBuilder_ == null) {
        ensureDirectoriesIsMutable();
        directories_.add(builderForValue.build());
        onChanged();
      } else {
        directoriesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The subdirectories in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.DirectoryNode directories = 2;</code>
     */
    public Builder addDirectories(
        int index, build.bazel.remote.execution.v2.DirectoryNode.Builder builderForValue) {
      if (directoriesBuilder_ == null) {
        ensureDirectoriesIsMutable();
        directories_.add(index, builderForValue.build());
        onChanged();
      } else {
        directoriesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The subdirectories in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.DirectoryNode directories = 2;</code>
     */
    public Builder addAllDirectories(
        java.lang.Iterable<? extends build.bazel.remote.execution.v2.DirectoryNode> values) {
      if (directoriesBuilder_ == null) {
        ensureDirectoriesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, directories_);
        onChanged();
      } else {
        directoriesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * The subdirectories in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.DirectoryNode directories = 2;</code>
     */
    public Builder clearDirectories() {
      if (directoriesBuilder_ == null) {
        directories_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        directoriesBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * The subdirectories in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.DirectoryNode directories = 2;</code>
     */
    public Builder removeDirectories(int index) {
      if (directoriesBuilder_ == null) {
        ensureDirectoriesIsMutable();
        directories_.remove(index);
        onChanged();
      } else {
        directoriesBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * The subdirectories in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.DirectoryNode directories = 2;</code>
     */
    public build.bazel.remote.execution.v2.DirectoryNode.Builder getDirectoriesBuilder(
        int index) {
      return getDirectoriesFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * The subdirectories in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.DirectoryNode directories = 2;</code>
     */
    public build.bazel.remote.execution.v2.DirectoryNodeOrBuilder getDirectoriesOrBuilder(
        int index) {
      if (directoriesBuilder_ == null) {
        return directories_.get(index);  } else {
        return directoriesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * The subdirectories in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.DirectoryNode directories = 2;</code>
     */
    public java.util.List<? extends build.bazel.remote.execution.v2.DirectoryNodeOrBuilder> 
         getDirectoriesOrBuilderList() {
      if (directoriesBuilder_ != null) {
        return directoriesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(directories_);
      }
    }
    /**
     * <pre>
     * The subdirectories in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.DirectoryNode directories = 2;</code>
     */
    public build.bazel.remote.execution.v2.DirectoryNode.Builder addDirectoriesBuilder() {
      return getDirectoriesFieldBuilder().addBuilder(
          build.bazel.remote.execution.v2.DirectoryNode.getDefaultInstance());
    }
    /**
     * <pre>
     * The subdirectories in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.DirectoryNode directories = 2;</code>
     */
    public build.bazel.remote.execution.v2.DirectoryNode.Builder addDirectoriesBuilder(
        int index) {
      return getDirectoriesFieldBuilder().addBuilder(
          index, build.bazel.remote.execution.v2.DirectoryNode.getDefaultInstance());
    }
    /**
     * <pre>
     * The subdirectories in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.DirectoryNode directories = 2;</code>
     */
    public java.util.List<build.bazel.remote.execution.v2.DirectoryNode.Builder> 
         getDirectoriesBuilderList() {
      return getDirectoriesFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        build.bazel.remote.execution.v2.DirectoryNode, build.bazel.remote.execution.v2.DirectoryNode.Builder, build.bazel.remote.execution.v2.DirectoryNodeOrBuilder> 
        getDirectoriesFieldBuilder() {
      if (directoriesBuilder_ == null) {
        directoriesBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            build.bazel.remote.execution.v2.DirectoryNode, build.bazel.remote.execution.v2.DirectoryNode.Builder, build.bazel.remote.execution.v2.DirectoryNodeOrBuilder>(
                directories_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        directories_ = null;
      }
      return directoriesBuilder_;
    }

    private java.util.List<build.bazel.remote.execution.v2.SymlinkNode> symlinks_ =
      java.util.Collections.emptyList();
    private void ensureSymlinksIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        symlinks_ = new java.util.ArrayList<build.bazel.remote.execution.v2.SymlinkNode>(symlinks_);
        bitField0_ |= 0x00000004;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        build.bazel.remote.execution.v2.SymlinkNode, build.bazel.remote.execution.v2.SymlinkNode.Builder, build.bazel.remote.execution.v2.SymlinkNodeOrBuilder> symlinksBuilder_;

    /**
     * <pre>
     * The symlinks in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.SymlinkNode symlinks = 3;</code>
     */
    public java.util.List<build.bazel.remote.execution.v2.SymlinkNode> getSymlinksList() {
      if (symlinksBuilder_ == null) {
        return java.util.Collections.unmodifiableList(symlinks_);
      } else {
        return symlinksBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * The symlinks in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.SymlinkNode symlinks = 3;</code>
     */
    public int getSymlinksCount() {
      if (symlinksBuilder_ == null) {
        return symlinks_.size();
      } else {
        return symlinksBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * The symlinks in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.SymlinkNode symlinks = 3;</code>
     */
    public build.bazel.remote.execution.v2.SymlinkNode getSymlinks(int index) {
      if (symlinksBuilder_ == null) {
        return symlinks_.get(index);
      } else {
        return symlinksBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * The symlinks in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.SymlinkNode symlinks = 3;</code>
     */
    public Builder setSymlinks(
        int index, build.bazel.remote.execution.v2.SymlinkNode value) {
      if (symlinksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSymlinksIsMutable();
        symlinks_.set(index, value);
        onChanged();
      } else {
        symlinksBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * The symlinks in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.SymlinkNode symlinks = 3;</code>
     */
    public Builder setSymlinks(
        int index, build.bazel.remote.execution.v2.SymlinkNode.Builder builderForValue) {
      if (symlinksBuilder_ == null) {
        ensureSymlinksIsMutable();
        symlinks_.set(index, builderForValue.build());
        onChanged();
      } else {
        symlinksBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The symlinks in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.SymlinkNode symlinks = 3;</code>
     */
    public Builder addSymlinks(build.bazel.remote.execution.v2.SymlinkNode value) {
      if (symlinksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSymlinksIsMutable();
        symlinks_.add(value);
        onChanged();
      } else {
        symlinksBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * The symlinks in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.SymlinkNode symlinks = 3;</code>
     */
    public Builder addSymlinks(
        int index, build.bazel.remote.execution.v2.SymlinkNode value) {
      if (symlinksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSymlinksIsMutable();
        symlinks_.add(index, value);
        onChanged();
      } else {
        symlinksBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * The symlinks in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.SymlinkNode symlinks = 3;</code>
     */
    public Builder addSymlinks(
        build.bazel.remote.execution.v2.SymlinkNode.Builder builderForValue) {
      if (symlinksBuilder_ == null) {
        ensureSymlinksIsMutable();
        symlinks_.add(builderForValue.build());
        onChanged();
      } else {
        symlinksBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The symlinks in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.SymlinkNode symlinks = 3;</code>
     */
    public Builder addSymlinks(
        int index, build.bazel.remote.execution.v2.SymlinkNode.Builder builderForValue) {
      if (symlinksBuilder_ == null) {
        ensureSymlinksIsMutable();
        symlinks_.add(index, builderForValue.build());
        onChanged();
      } else {
        symlinksBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The symlinks in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.SymlinkNode symlinks = 3;</code>
     */
    public Builder addAllSymlinks(
        java.lang.Iterable<? extends build.bazel.remote.execution.v2.SymlinkNode> values) {
      if (symlinksBuilder_ == null) {
        ensureSymlinksIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, symlinks_);
        onChanged();
      } else {
        symlinksBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * The symlinks in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.SymlinkNode symlinks = 3;</code>
     */
    public Builder clearSymlinks() {
      if (symlinksBuilder_ == null) {
        symlinks_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        symlinksBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * The symlinks in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.SymlinkNode symlinks = 3;</code>
     */
    public Builder removeSymlinks(int index) {
      if (symlinksBuilder_ == null) {
        ensureSymlinksIsMutable();
        symlinks_.remove(index);
        onChanged();
      } else {
        symlinksBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * The symlinks in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.SymlinkNode symlinks = 3;</code>
     */
    public build.bazel.remote.execution.v2.SymlinkNode.Builder getSymlinksBuilder(
        int index) {
      return getSymlinksFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * The symlinks in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.SymlinkNode symlinks = 3;</code>
     */
    public build.bazel.remote.execution.v2.SymlinkNodeOrBuilder getSymlinksOrBuilder(
        int index) {
      if (symlinksBuilder_ == null) {
        return symlinks_.get(index);  } else {
        return symlinksBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * The symlinks in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.SymlinkNode symlinks = 3;</code>
     */
    public java.util.List<? extends build.bazel.remote.execution.v2.SymlinkNodeOrBuilder> 
         getSymlinksOrBuilderList() {
      if (symlinksBuilder_ != null) {
        return symlinksBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(symlinks_);
      }
    }
    /**
     * <pre>
     * The symlinks in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.SymlinkNode symlinks = 3;</code>
     */
    public build.bazel.remote.execution.v2.SymlinkNode.Builder addSymlinksBuilder() {
      return getSymlinksFieldBuilder().addBuilder(
          build.bazel.remote.execution.v2.SymlinkNode.getDefaultInstance());
    }
    /**
     * <pre>
     * The symlinks in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.SymlinkNode symlinks = 3;</code>
     */
    public build.bazel.remote.execution.v2.SymlinkNode.Builder addSymlinksBuilder(
        int index) {
      return getSymlinksFieldBuilder().addBuilder(
          index, build.bazel.remote.execution.v2.SymlinkNode.getDefaultInstance());
    }
    /**
     * <pre>
     * The symlinks in the directory.
     * </pre>
     *
     * <code>repeated .build.bazel.remote.execution.v2.SymlinkNode symlinks = 3;</code>
     */
    public java.util.List<build.bazel.remote.execution.v2.SymlinkNode.Builder> 
         getSymlinksBuilderList() {
      return getSymlinksFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        build.bazel.remote.execution.v2.SymlinkNode, build.bazel.remote.execution.v2.SymlinkNode.Builder, build.bazel.remote.execution.v2.SymlinkNodeOrBuilder> 
        getSymlinksFieldBuilder() {
      if (symlinksBuilder_ == null) {
        symlinksBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            build.bazel.remote.execution.v2.SymlinkNode, build.bazel.remote.execution.v2.SymlinkNode.Builder, build.bazel.remote.execution.v2.SymlinkNodeOrBuilder>(
                symlinks_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        symlinks_ = null;
      }
      return symlinksBuilder_;
    }

    private build.bazel.remote.execution.v2.NodeProperties nodeProperties_;
    private com.google.protobuf.SingleFieldBuilderV3<
        build.bazel.remote.execution.v2.NodeProperties, build.bazel.remote.execution.v2.NodeProperties.Builder, build.bazel.remote.execution.v2.NodePropertiesOrBuilder> nodePropertiesBuilder_;
    /**
     * <code>.build.bazel.remote.execution.v2.NodeProperties node_properties = 5;</code>
     * @return Whether the nodeProperties field is set.
     */
    public boolean hasNodeProperties() {
      return nodePropertiesBuilder_ != null || nodeProperties_ != null;
    }
    /**
     * <code>.build.bazel.remote.execution.v2.NodeProperties node_properties = 5;</code>
     * @return The nodeProperties.
     */
    public build.bazel.remote.execution.v2.NodeProperties getNodeProperties() {
      if (nodePropertiesBuilder_ == null) {
        return nodeProperties_ == null ? build.bazel.remote.execution.v2.NodeProperties.getDefaultInstance() : nodeProperties_;
      } else {
        return nodePropertiesBuilder_.getMessage();
      }
    }
    /**
     * <code>.build.bazel.remote.execution.v2.NodeProperties node_properties = 5;</code>
     */
    public Builder setNodeProperties(build.bazel.remote.execution.v2.NodeProperties value) {
      if (nodePropertiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        nodeProperties_ = value;
        onChanged();
      } else {
        nodePropertiesBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <code>.build.bazel.remote.execution.v2.NodeProperties node_properties = 5;</code>
     */
    public Builder setNodeProperties(
        build.bazel.remote.execution.v2.NodeProperties.Builder builderForValue) {
      if (nodePropertiesBuilder_ == null) {
        nodeProperties_ = builderForValue.build();
        onChanged();
      } else {
        nodePropertiesBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <code>.build.bazel.remote.execution.v2.NodeProperties node_properties = 5;</code>
     */
    public Builder mergeNodeProperties(build.bazel.remote.execution.v2.NodeProperties value) {
      if (nodePropertiesBuilder_ == null) {
        if (nodeProperties_ != null) {
          nodeProperties_ =
            build.bazel.remote.execution.v2.NodeProperties.newBuilder(nodeProperties_).mergeFrom(value).buildPartial();
        } else {
          nodeProperties_ = value;
        }
        onChanged();
      } else {
        nodePropertiesBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <code>.build.bazel.remote.execution.v2.NodeProperties node_properties = 5;</code>
     */
    public Builder clearNodeProperties() {
      if (nodePropertiesBuilder_ == null) {
        nodeProperties_ = null;
        onChanged();
      } else {
        nodeProperties_ = null;
        nodePropertiesBuilder_ = null;
      }

      return this;
    }
    /**
     * <code>.build.bazel.remote.execution.v2.NodeProperties node_properties = 5;</code>
     */
    public build.bazel.remote.execution.v2.NodeProperties.Builder getNodePropertiesBuilder() {
      
      onChanged();
      return getNodePropertiesFieldBuilder().getBuilder();
    }
    /**
     * <code>.build.bazel.remote.execution.v2.NodeProperties node_properties = 5;</code>
     */
    public build.bazel.remote.execution.v2.NodePropertiesOrBuilder getNodePropertiesOrBuilder() {
      if (nodePropertiesBuilder_ != null) {
        return nodePropertiesBuilder_.getMessageOrBuilder();
      } else {
        return nodeProperties_ == null ?
            build.bazel.remote.execution.v2.NodeProperties.getDefaultInstance() : nodeProperties_;
      }
    }
    /**
     * <code>.build.bazel.remote.execution.v2.NodeProperties node_properties = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        build.bazel.remote.execution.v2.NodeProperties, build.bazel.remote.execution.v2.NodeProperties.Builder, build.bazel.remote.execution.v2.NodePropertiesOrBuilder> 
        getNodePropertiesFieldBuilder() {
      if (nodePropertiesBuilder_ == null) {
        nodePropertiesBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            build.bazel.remote.execution.v2.NodeProperties, build.bazel.remote.execution.v2.NodeProperties.Builder, build.bazel.remote.execution.v2.NodePropertiesOrBuilder>(
                getNodeProperties(),
                getParentForChildren(),
                isClean());
        nodeProperties_ = null;
      }
      return nodePropertiesBuilder_;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:build.bazel.remote.execution.v2.Directory)
  }

  // @@protoc_insertion_point(class_scope:build.bazel.remote.execution.v2.Directory)
  private static final build.bazel.remote.execution.v2.Directory DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new build.bazel.remote.execution.v2.Directory();
  }

  public static build.bazel.remote.execution.v2.Directory getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Directory>
      PARSER = new com.google.protobuf.AbstractParser<Directory>() {
    @java.lang.Override
    public Directory parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<Directory> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Directory> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public build.bazel.remote.execution.v2.Directory getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

