/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.annotations.ThreadSafe;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.threadsafety.AnnotationInfo;
import com.google.errorprone.bugpatterns.threadsafety.ThreadSafeAnalysis;
import com.google.errorprone.bugpatterns.threadsafety.ThreadSafety;
import com.google.errorprone.bugpatterns.threadsafety.WellKnownThreadSafety;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.checkerframework.checker.nullness.qual.Nullable;

@BugPattern(name="ThreadSafe", summary="Type declaration annotated with @ThreadSafe is not thread safe", severity=BugPattern.SeverityLevel.ERROR)
public class ThreadSafeChecker
extends BugChecker
implements BugChecker.ClassTreeMatcher,
BugChecker.NewClassTreeMatcher,
BugChecker.TypeParameterTreeMatcher,
BugChecker.MethodInvocationTreeMatcher,
BugChecker.MemberReferenceTreeMatcher {
    private final WellKnownThreadSafety wellKnownThreadSafety;
    private final boolean checkElementUsage;

    @Inject
    ThreadSafeChecker(WellKnownThreadSafety wellKnownThreadSafety, ErrorProneFlags flags) {
        this.wellKnownThreadSafety = wellKnownThreadSafety;
        this.checkElementUsage = flags.getBoolean("ThreadSafeChecker:CheckElementUsage").orElse(true);
    }

    public Description matchMemberReference(MemberReferenceTree tree, VisitorState state) {
        return this.checkInvocation(tree, ((JCTree.JCMemberReference)tree).referentType, state, ASTHelpers.getSymbol((MemberReferenceTree)tree));
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return this.checkInvocation(tree, ASTHelpers.getType((Tree)tree.getMethodSelect()), state, ASTHelpers.getSymbol((MethodInvocationTree)tree));
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        this.checkInvocation(tree, ((JCTree.JCNewClass)tree).constructorType, state, ((JCTree.JCNewClass)tree).constructor);
        ThreadSafeAnalysis analysis = new ThreadSafeAnalysis(this, state, this.wellKnownThreadSafety);
        ThreadSafety.Violation info = analysis.checkInstantiation(ASTHelpers.getSymbol((Tree)tree.getIdentifier()).getTypeParameters(), ASTHelpers.getType((Tree)tree).getTypeArguments());
        if (info.isPresent()) {
            state.reportMatch(this.buildDescription(tree).setMessage(info.message()).build());
        }
        return Description.NO_MATCH;
    }

    private Description checkInvocation(Tree tree, Type methodType, VisitorState state, Symbol symbol) {
        ThreadSafeAnalysis analysis = new ThreadSafeAnalysis(this, state, this.wellKnownThreadSafety);
        ThreadSafety.Violation info = analysis.checkInvocation(methodType, symbol);
        if (info.isPresent()) {
            state.reportMatch(this.buildDescription(tree).setMessage(info.message()).build());
        }
        return Description.NO_MATCH;
    }

    public Description matchTypeParameter(TypeParameterTree tree, VisitorState state) {
        Symbol sym = ASTHelpers.getSymbol((Tree)tree);
        if (sym == null) {
            return Description.NO_MATCH;
        }
        switch (sym.owner.getKind()) {
            case METHOD: 
            case CONSTRUCTOR: {
                return Description.NO_MATCH;
            }
        }
        ThreadSafeAnalysis analysis = new ThreadSafeAnalysis(this, state, this.wellKnownThreadSafety);
        if (analysis.hasThreadSafeTypeParameterAnnotation((Symbol.TypeVariableSymbol)sym) && analysis.getThreadSafeAnnotation(sym.owner, state) == null) {
            return this.buildDescription(tree).setMessage("@ThreadSafe.TypeParameter is only supported on threadsafe classes").build();
        }
        if (this.checkElementUsage && analysis.hasThreadSafeElementAnnotation((Symbol.TypeVariableSymbol)sym) && analysis.getThreadSafeAnnotation(sym.owner, state) == null) {
            return this.buildDescription(tree).setMessage("@ThreadSafe.Element is only supported on threadsafe classes").build();
        }
        return Description.NO_MATCH;
    }

    public Description matchClass(ClassTree tree, VisitorState state) {
        ThreadSafeAnalysis analysis = new ThreadSafeAnalysis(this, state, this.wellKnownThreadSafety);
        if (tree.getSimpleName().length() == 0) {
            return this.handleAnonymousClass(tree, state, analysis);
        }
        AnnotationInfo annotation = analysis.getThreadSafeAnnotation(tree, state);
        if (annotation == null) {
            return this.checkSubtype(tree, state);
        }
        if (this.wellKnownThreadSafety.getKnownThreadSafeClasses().containsValue((Object)annotation)) {
            return Description.NO_MATCH;
        }
        HashMap<String, Symbol.TypeVariableSymbol> typarams = new HashMap<String, Symbol.TypeVariableSymbol>();
        for (TypeParameterTree typeParameterTree : tree.getTypeParameters()) {
            typarams.put(typeParameterTree.getName().toString(), (Symbol.TypeVariableSymbol)ASTHelpers.getSymbol((Tree)typeParameterTree));
        }
        Sets.SetView difference = Sets.difference(annotation.containerOf(), typarams.keySet());
        if (!difference.isEmpty()) {
            return this.buildDescription(tree).setMessage(String.format("could not find type(s) referenced by containerOf: %s", Joiner.on((String)"', '").join((Iterable)difference))).build();
        }
        ImmutableSet immutableSet = (ImmutableSet)typarams.entrySet().stream().filter(e -> annotation.containerOf().contains(e.getKey()) && analysis.hasThreadSafeTypeParameterAnnotation((Symbol.TypeVariableSymbol)e.getValue())).map(Map.Entry::getKey).collect(ImmutableSet.toImmutableSet());
        if (!immutableSet.isEmpty()) {
            return this.buildDescription(tree).setMessage(String.format("using both @ThreadSafe.TypeParameter and @ThreadSafe.Element is redundant: %s", Joiner.on((String)"', '").join((Iterable)immutableSet))).build();
        }
        ThreadSafety.Violation info = analysis.checkForThreadSafety(Optional.of(tree), analysis.threadSafeTypeParametersInScope(ASTHelpers.getSymbol((ClassTree)tree)), ASTHelpers.getType((ClassTree)tree));
        if (!info.isPresent()) {
            return Description.NO_MATCH;
        }
        String message = "type annotated with @ThreadSafe could not be proven threadsafe: " + info.message();
        return this.buildDescription(tree).setMessage(message).build();
    }

    private Description handleAnonymousClass(ClassTree tree, VisitorState state, ThreadSafeAnalysis analysis) {
        Symbol.ClassSymbol sym = ASTHelpers.getSymbol((ClassTree)tree);
        if (sym == null) {
            return Description.NO_MATCH;
        }
        Type superType = ThreadSafeChecker.threadSafeSupertype(sym, state);
        if (superType == null) {
            return Description.NO_MATCH;
        }
        ImmutableSet<String> typarams = analysis.threadSafeTypeParametersInScope(sym);
        ThreadSafety.Violation info = analysis.areFieldsThreadSafe(Optional.of(tree), typarams, ASTHelpers.getType((ClassTree)tree));
        if (!info.isPresent()) {
            return Description.NO_MATCH;
        }
        String reason = Joiner.on((String)", ").join(info.path());
        String message = String.format("Class extends @ThreadSafe type %s, but is not threadsafe: %s", superType, reason);
        return this.buildDescription(tree).setMessage(message).build();
    }

    private Description checkSubtype(ClassTree tree, VisitorState state) {
        Symbol.ClassSymbol sym = ASTHelpers.getSymbol((ClassTree)tree);
        if (sym == null) {
            return Description.NO_MATCH;
        }
        Type superType = ThreadSafeChecker.threadSafeSupertype(sym, state);
        if (superType == null) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.hasAnnotation((Symbol)sym, Immutable.class, (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        String message = String.format("Class extends @ThreadSafe type %s, but is not annotated as threadsafe", superType);
        SuggestedFix.Builder fix = SuggestedFix.builder();
        String typeName = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)ThreadSafe.class.getName());
        fix.prefixWith((Tree)tree, "@" + typeName + " ");
        return this.buildDescription(tree).setMessage(message).addFix((Fix)fix.build()).build();
    }

    private static @Nullable Type threadSafeSupertype(Symbol sym, VisitorState state) {
        for (Type superType : state.getTypes().closure(sym.type)) {
            if (superType.asElement().equals(sym) || !ASTHelpers.hasAnnotation((Symbol)superType.tsym, ThreadSafe.class, (VisitorState)state)) continue;
            return superType;
        }
        return null;
    }
}

