/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.errorprone.dataflow.analysis;

import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicLong;
import javax.lang.model.element.Element;
import org.checkerframework.errorprone.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.errorprone.checker.nullness.qual.Nullable;
import org.checkerframework.errorprone.dataflow.analysis.AbstractValue;
import org.checkerframework.errorprone.dataflow.analysis.Analysis;
import org.checkerframework.errorprone.dataflow.analysis.Store;
import org.checkerframework.errorprone.dataflow.analysis.TransferInput;
import org.checkerframework.errorprone.dataflow.analysis.TransferResult;
import org.checkerframework.errorprone.dataflow.cfg.block.Block;
import org.checkerframework.errorprone.dataflow.cfg.block.ExceptionBlock;
import org.checkerframework.errorprone.dataflow.cfg.node.AssignmentNode;
import org.checkerframework.errorprone.dataflow.cfg.node.Node;
import org.checkerframework.errorprone.javacutil.BugInCF;
import org.checkerframework.errorprone.javacutil.TreeUtils;
import org.checkerframework.errorprone.org.plumelib.util.UniqueId;

public class AnalysisResult<V extends AbstractValue<V>, S extends Store<S>>
implements UniqueId {
    protected final IdentityHashMap<Node, V> nodeValues;
    protected final IdentityHashMap<Tree, Set<Node>> treeLookup;
    protected final IdentityHashMap<UnaryTree, AssignmentNode> unaryAssignNodeLookup;
    protected final HashMap<Element, V> finalLocalValues;
    protected final IdentityHashMap<Block, TransferInput<V, S>> stores;
    protected final Map<TransferInput<V, S>, IdentityHashMap<Node, TransferResult<V, S>>> analysisCaches;
    static final AtomicLong nextUid = new AtomicLong(0L);
    final transient long uid = nextUid.getAndIncrement();

    @Override
    public long getUid(@UnknownInitialization AnalysisResult<V, S> this) {
        return this.uid;
    }

    protected AnalysisResult(IdentityHashMap<Node, V> nodeValues, IdentityHashMap<Block, TransferInput<V, S>> stores, IdentityHashMap<Tree, Set<Node>> treeLookup, IdentityHashMap<UnaryTree, AssignmentNode> unaryAssignNodeLookup, HashMap<Element, V> finalLocalValues, Map<TransferInput<V, S>, IdentityHashMap<Node, TransferResult<V, S>>> analysisCaches) {
        this.nodeValues = new IdentityHashMap<Node, V>(nodeValues);
        this.treeLookup = new IdentityHashMap<Tree, Set<Node>>(treeLookup);
        this.unaryAssignNodeLookup = new IdentityHashMap<UnaryTree, AssignmentNode>(unaryAssignNodeLookup);
        this.stores = stores;
        this.finalLocalValues = finalLocalValues;
        this.analysisCaches = analysisCaches;
    }

    public AnalysisResult(IdentityHashMap<Node, V> nodeValues, IdentityHashMap<Block, TransferInput<V, S>> stores, IdentityHashMap<Tree, Set<Node>> treeLookup, IdentityHashMap<UnaryTree, AssignmentNode> unaryAssignNodeLookup, HashMap<Element, V> finalLocalValues) {
        this(nodeValues, stores, treeLookup, unaryAssignNodeLookup, finalLocalValues, new IdentityHashMap<TransferInput<V, S>, IdentityHashMap<Node, TransferResult<V, S>>>());
    }

    public AnalysisResult(Map<TransferInput<V, S>, IdentityHashMap<Node, TransferResult<V, S>>> analysisCaches) {
        this(new IdentityHashMap(), new IdentityHashMap<Block, TransferInput<V, S>>(), new IdentityHashMap<Tree, Set<Node>>(), new IdentityHashMap<UnaryTree, AssignmentNode>(), new HashMap(), analysisCaches);
    }

    public void combine(AnalysisResult<V, S> other) {
        this.nodeValues.putAll(other.nodeValues);
        AnalysisResult.mergeTreeLookup(this.treeLookup, other.treeLookup);
        this.unaryAssignNodeLookup.putAll(other.unaryAssignNodeLookup);
        this.stores.putAll(other.stores);
        this.finalLocalValues.putAll(other.finalLocalValues);
    }

    private static void mergeTreeLookup(IdentityHashMap<Tree, Set<Node>> treeLookup, IdentityHashMap<Tree, Set<Node>> otherTreeLookup) {
        for (Map.Entry<Tree, Set<Node>> entry : otherTreeLookup.entrySet()) {
            Set<Node> hit = treeLookup.get(entry.getKey());
            if (hit == null) {
                treeLookup.put(entry.getKey(), entry.getValue());
                continue;
            }
            hit.addAll((Collection<Node>)entry.getValue());
        }
    }

    public HashMap<Element, V> getFinalLocalValues() {
        return this.finalLocalValues;
    }

    public @Nullable V getValue(Node n) {
        return (V)((AbstractValue)this.nodeValues.get(n));
    }

    public @Nullable V getValue(Tree t2) {
        Set<Node> nodes = this.treeLookup.get(t2);
        if (nodes == null) {
            return null;
        }
        AbstractValue merged = null;
        for (Node aNode : nodes) {
            V a = this.getValue(aNode);
            if (merged == null) {
                merged = (AbstractValue)a;
                continue;
            }
            if (a == null) continue;
            merged = merged.leastUpperBound(a);
        }
        return (V)merged;
    }

    public @Nullable Set<Node> getNodesForTree(Tree tree) {
        return this.treeLookup.get(tree);
    }

    public AssignmentNode getAssignForUnaryTree(UnaryTree tree) {
        if (!this.unaryAssignNodeLookup.containsKey(tree)) {
            throw new BugInCF(tree + " is not in unaryAssignNodeLookup");
        }
        return this.unaryAssignNodeLookup.get(tree);
    }

    public @Nullable S getStoreBefore(Tree tree) {
        Set<Node> nodes = this.getNodesForTree(tree);
        if (nodes == null) {
            return null;
        }
        Store merged = null;
        for (Node node : nodes) {
            S s2 = this.getStoreBefore(node);
            if (merged == null) {
                merged = (Store)s2;
                continue;
            }
            if (s2 == null) continue;
            merged = merged.leastUpperBound(s2);
        }
        return (S)merged;
    }

    public @Nullable S getStoreBefore(Node node) {
        return this.runAnalysisFor(node, Analysis.BeforeOrAfter.BEFORE);
    }

    public S getStoreBefore(Block block) {
        TransferInput<V, S> transferInput = this.stores.get(block);
        assert (transferInput != null) : "@AssumeAssertion(nullness): transferInput should be non-null";
        Analysis<V, S, ?> analysis = transferInput.analysis;
        switch (analysis.getDirection()) {
            case FORWARD: {
                return transferInput.getRegularStore();
            }
            case BACKWARD: {
                Node firstNode;
                switch (block.getType()) {
                    case REGULAR_BLOCK: {
                        firstNode = block.getNodes().get(0);
                        break;
                    }
                    case EXCEPTION_BLOCK: {
                        firstNode = ((ExceptionBlock)block).getNode();
                        break;
                    }
                    default: {
                        firstNode = null;
                    }
                }
                if (firstNode == null) {
                    return transferInput.getRegularStore();
                }
                return analysis.runAnalysisFor(firstNode, Analysis.BeforeOrAfter.BEFORE, transferInput, this.nodeValues, this.analysisCaches);
            }
        }
        throw new BugInCF("Unknown direction: " + (Object)((Object)analysis.getDirection()));
    }

    public S getStoreAfter(Block block) {
        TransferInput<V, S> transferInput = this.stores.get(block);
        assert (transferInput != null) : "@AssumeAssertion(nullness): transferInput should be non-null";
        Analysis<V, S, ?> analysis = transferInput.analysis;
        switch (analysis.getDirection()) {
            case FORWARD: {
                Node lastNode = block.getLastNode();
                if (lastNode == null) {
                    return transferInput.getRegularStore();
                }
                return analysis.runAnalysisFor(lastNode, Analysis.BeforeOrAfter.AFTER, transferInput, this.nodeValues, this.analysisCaches);
            }
            case BACKWARD: {
                return transferInput.getRegularStore();
            }
        }
        throw new BugInCF("Unknown direction: " + (Object)((Object)analysis.getDirection()));
    }

    public @Nullable S getStoreAfter(Tree tree) {
        Set<Node> nodes = this.getNodesForTree(tree);
        if (nodes == null) {
            return null;
        }
        Store merged = null;
        for (Node node : nodes) {
            S s2 = this.getStoreAfter(node);
            if (merged == null) {
                merged = (Store)s2;
                continue;
            }
            if (s2 == null) continue;
            merged = merged.leastUpperBound(s2);
        }
        return (S)merged;
    }

    public @Nullable S getStoreAfter(Node node) {
        return this.runAnalysisFor(node, Analysis.BeforeOrAfter.AFTER);
    }

    protected @Nullable S runAnalysisFor(Node node, Analysis.BeforeOrAfter preOrPost) {
        Block block = node.getBlock();
        assert (block != null) : "@AssumeAssertion(nullness): invariant";
        TransferInput<V, S> transferInput = this.stores.get(block);
        if (transferInput == null) {
            return null;
        }
        return AnalysisResult.runAnalysisFor(node, preOrPost, transferInput, this.nodeValues, this.analysisCaches);
    }

    public static <V extends AbstractValue<V>, S extends Store<S>> S runAnalysisFor(Node node, Analysis.BeforeOrAfter preOrPost, TransferInput<V, S> transferInput, IdentityHashMap<Node, V> nodeValues, Map<TransferInput<V, S>, IdentityHashMap<Node, TransferResult<V, S>>> analysisCaches) {
        if (transferInput.analysis == null) {
            throw new BugInCF("Analysis in transferInput cannot be null.");
        }
        return transferInput.analysis.runAnalysisFor(node, preOrPost, transferInput, nodeValues, analysisCaches);
    }

    public String toStringDebug() {
        StringJoiner result = new StringJoiner(String.format("%n  ", new Object[0]), String.format("AnalysisResult{%n  ", new Object[0]), String.format("%n}", new Object[0]));
        result.add("nodeValues = " + AnalysisResult.nodeValuesToString(this.nodeValues));
        result.add("treeLookup = " + AnalysisResult.treeLookupToString(this.treeLookup));
        result.add("unaryAssignNodeLookup = " + this.unaryAssignNodeLookup);
        result.add("finalLocalValues = " + this.finalLocalValues);
        result.add("stores = " + this.stores);
        result.add("analysisCaches = " + this.analysisCaches);
        return result.toString();
    }

    public static <V> String nodeValuesToString(Map<Node, V> nodeValues) {
        if (nodeValues.isEmpty()) {
            return "{}";
        }
        StringJoiner result = new StringJoiner(String.format("%n    ", new Object[0]));
        result.add("{");
        for (Map.Entry<Node, V> entry : nodeValues.entrySet()) {
            Node key = entry.getKey();
            result.add(String.format("%s => %s", key.toStringDebug(), entry.getValue()));
        }
        result.add("}");
        return result.toString();
    }

    public static String treeLookupToString(Map<Tree, Set<Node>> treeLookup) {
        if (treeLookup.isEmpty()) {
            return "{}";
        }
        StringJoiner result = new StringJoiner(String.format("%n    ", new Object[0]));
        result.add("{");
        for (Map.Entry<Tree, Set<Node>> entry : treeLookup.entrySet()) {
            Tree key = entry.getKey();
            result.add(TreeUtils.toStringTruncated(key, 65) + " => " + Node.nodeCollectionToString((Collection<? extends Node>)entry.getValue()));
        }
        result.add("}");
        return result.toString();
    }
}

