/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.nullness;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.nullness.NullnessUtils;
import com.google.errorprone.dataflow.nullnesspropagation.Nullness;
import com.google.errorprone.dataflow.nullnesspropagation.NullnessAnnotations;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.lang.model.type.TypeKind;

@BugPattern(summary="Null is not permitted for this parameter.", severity=BugPattern.SeverityLevel.ERROR)
public final class NullArgumentForNonNullParameter
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewClassTreeMatcher {
    private static final Supplier<Type> JAVA_OPTIONAL_TYPE = Suppliers.typeFromString((String)"java.util.Optional");
    private static final Supplier<Type> GUAVA_OPTIONAL_TYPE = Suppliers.typeFromString((String)"com.google.common.base.Optional");
    private static final Supplier<Type> ARGUMENT_CAPTOR_CLASS = Suppliers.typeFromString((String)"org.mockito.ArgumentCaptor");
    private static final Supplier<Name> OF_NAME = VisitorState.memoize((Supplier & Serializable)state -> state.getName("of"));
    private static final Supplier<Name> FOR_CLASS_NAME = VisitorState.memoize((Supplier & Serializable)state -> state.getName("forClass"));
    private static final Supplier<Name> BUILDER_NAME = VisitorState.memoize((Supplier & Serializable)state -> state.getName("Builder"));
    private static final Supplier<Name> GUAVA_COLLECT_IMMUTABLE_PREFIX = VisitorState.memoize((Supplier & Serializable)state -> state.getName("com.google.common.collect.Immutable"));
    private static final Supplier<Name> GUAVA_GRAPH_IMMUTABLE_PREFIX = VisitorState.memoize((Supplier & Serializable)state -> state.getName("com.google.common.graph.Immutable"));
    private static final Supplier<ImmutableSet<Name>> NULL_MARKED_PACKAGES_WE_TRUST = VisitorState.memoize((Supplier & Serializable)state -> (ImmutableSet)Arrays.stream(new String[]{"com.google.common"}).map(arg_0 -> ((VisitorState)state).getName(arg_0)).collect(ImmutableSet.toImmutableSet()));
    private final boolean beingConservative;

    @Inject
    NullArgumentForNonNullParameter(ErrorProneFlags flags) {
        this.beingConservative = NullnessUtils.nullnessChecksShouldBeConservative(flags);
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return this.match(ASTHelpers.getSymbol((MethodInvocationTree)tree), tree.getArguments(), state);
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        return this.match(ASTHelpers.getSymbol((NewClassTree)tree), tree.getArguments(), state);
    }

    private Description match(Symbol.MethodSymbol methodSymbol, List<? extends ExpressionTree> args, VisitorState state) {
        if (NullnessUtils.hasExtraParameterForEnclosingInstance(methodSymbol)) {
            return Description.NO_MATCH;
        }
        if (methodSymbol.isVarArgs()) {
            return Description.NO_MATCH;
        }
        Streams.forEachPair(args.stream(), methodSymbol.getParameters().stream(), (argTree, paramSymbol) -> {
            if (!NullnessUtils.hasDefinitelyNullBranch(argTree, (Set<Symbol.VarSymbol>)ImmutableSet.of(), (ImmutableSet<javax.lang.model.element.Name>)ImmutableSet.of(), state)) {
                return;
            }
            if (!this.argumentMustBeNonNull((Symbol.VarSymbol)paramSymbol, state)) {
                return;
            }
            state.reportMatch(this.describeMatch((Tree)argTree));
        });
        return Description.NO_MATCH;
    }

    private boolean argumentMustBeNonNull(Symbol.VarSymbol sym, VisitorState state) {
        if (sym.owner.name.equals(FOR_CLASS_NAME.get(state)) && NullArgumentForNonNullParameter.isParameterOfMethodOnType(sym, ARGUMENT_CAPTOR_CLASS, state)) {
            return true;
        }
        if (state.errorProneOptions().isTestOnlyTarget()) {
            return false;
        }
        if (((Type)sym.asType()).isPrimitive()) {
            return true;
        }
        if (sym.owner.name.equals(OF_NAME.get(state)) && (NullArgumentForNonNullParameter.isParameterOfMethodOnType(sym, JAVA_OPTIONAL_TYPE, state) || NullArgumentForNonNullParameter.isParameterOfMethodOnType(sym, GUAVA_OPTIONAL_TYPE, state))) {
            return true;
        }
        if (sym.owner.name.equals(OF_NAME.get(state)) && (NullArgumentForNonNullParameter.isParameterOfMethodOnTypeStartingWith(sym, GUAVA_COLLECT_IMMUTABLE_PREFIX, state) || NullArgumentForNonNullParameter.isParameterOfMethodOnTypeStartingWith(sym, GUAVA_GRAPH_IMMUTABLE_PREFIX, state))) {
            return true;
        }
        if (ASTHelpers.enclosingClass((Symbol)sym).name.equals(BUILDER_NAME.get(state)) && (NullArgumentForNonNullParameter.isParameterOfMethodOnTypeStartingWith(sym, GUAVA_COLLECT_IMMUTABLE_PREFIX, state) || NullArgumentForNonNullParameter.isParameterOfMethodOnTypeStartingWith(sym, GUAVA_GRAPH_IMMUTABLE_PREFIX, state))) {
            return true;
        }
        Nullness nullness = NullnessAnnotations.fromAnnotationsOn((Symbol)sym).orElse(null);
        if (nullness == Nullness.NONNULL && !this.beingConservative) {
            return true;
        }
        if (nullness == Nullness.NULLABLE) {
            return false;
        }
        if (((Type)sym.asType()).getKind() == TypeKind.TYPEVAR) {
            return false;
        }
        return this.enclosingAnnotationDefaultsNonTypeVariablesToNonNull(sym, state);
    }

    private static boolean isParameterOfMethodOnType(Symbol.VarSymbol sym, Supplier<Type> typeSupplier, VisitorState state) {
        Type target = (Type)typeSupplier.get(state);
        return target != null && state.getTypes().isSameType(ASTHelpers.enclosingClass((Symbol)sym).type, target);
    }

    private static boolean isParameterOfMethodOnTypeStartingWith(Symbol.VarSymbol sym, Supplier<Name> nameSupplier, VisitorState state) {
        return ASTHelpers.enclosingClass((Symbol)sym).fullname.startsWith((Name)nameSupplier.get(state));
    }

    private boolean enclosingAnnotationDefaultsNonTypeVariablesToNonNull(Symbol sym, VisitorState state) {
        while (sym != null) {
            if (ASTHelpers.hasAnnotation((Symbol)sym, (String)"com.google.protobuf.Internal$ProtoNonnullApi", (VisitorState)state)) {
                return true;
            }
            if (ASTHelpers.hasAnnotation((Symbol)sym, (String)"org.jspecify.nullness.NullMarked", (VisitorState)state) && this.weTrustNullMarkedOn(sym, state)) {
                return true;
            }
            sym = sym.getEnclosingElement();
        }
        return false;
    }

    private boolean weTrustNullMarkedOn(Symbol sym, VisitorState state) {
        if (!this.beingConservative) {
            return true;
        }
        ImmutableSet packagesWeTrust = (ImmutableSet)NULL_MARKED_PACKAGES_WE_TRUST.get(state);
        sym = ASTHelpers.enclosingPackage((Symbol)sym);
        while (sym != null) {
            if (packagesWeTrust.contains((Object)sym.getQualifiedName())) {
                return true;
            }
            sym = sym.owner;
        }
        return false;
    }
}

