/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.dataflow.nullnesspropagation.Nullness;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.FindIdentifiers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;
import java.util.List;
import java.util.Optional;

public abstract class AbstractReferenceEquality
extends BugChecker
implements BugChecker.BinaryTreeMatcher {
    private static final Matcher<MethodInvocationTree> EQUALS_STATIC_METHODS = Matchers.staticEqualsInvocation();
    private static final Matcher<ExpressionTree> OBJECT_INSTANCE_EQUALS = Matchers.instanceEqualsInvocation();

    protected abstract boolean matchArgument(ExpressionTree var1, VisitorState var2);

    public final Description matchBinary(BinaryTree tree, VisitorState state) {
        switch (tree.getKind()) {
            case EQUAL_TO: 
            case NOT_EQUAL_TO: {
                break;
            }
            default: {
                return Description.NO_MATCH;
            }
        }
        if (tree.getLeftOperand().getKind() == Tree.Kind.NULL_LITERAL || !this.matchArgument(tree.getLeftOperand(), state)) {
            return Description.NO_MATCH;
        }
        if (tree.getRightOperand().getKind() == Tree.Kind.NULL_LITERAL || !this.matchArgument(tree.getRightOperand(), state)) {
            return Description.NO_MATCH;
        }
        Description.Builder builder = this.buildDescription(tree);
        this.addFixes(builder, tree, state);
        return builder.build();
    }

    private static boolean symbolsTypeHasName(Symbol sym, String name) {
        if (sym == null) {
            return false;
        }
        Type type = sym.type;
        if (type == null) {
            return false;
        }
        Symbol.TypeSymbol tsym = type.tsym;
        if (tsym == null) {
            return false;
        }
        Name typeName = tsym.getQualifiedName();
        if (typeName == null) {
            return false;
        }
        return typeName.contentEquals(name);
    }

    protected void addFixes(Description.Builder builder, BinaryTree tree, VisitorState state) {
        ExpressionTree lhs = tree.getLeftOperand();
        ExpressionTree rhs = tree.getRightOperand();
        Optional<Fix> fixToReplaceOrStatement = AbstractReferenceEquality.inOrStatementWithEqualsCheck(state, tree);
        if (fixToReplaceOrStatement.isPresent()) {
            builder.addFix(fixToReplaceOrStatement.get());
            return;
        }
        if (ASTHelpers.constValue((Tree)lhs) == null && ASTHelpers.constValue((Tree)rhs) != null) {
            ExpressionTree tmp = lhs;
            lhs = rhs;
            rhs = tmp;
        }
        String prefix = tree.getKind() == Tree.Kind.NOT_EQUAL_TO ? "!" : "";
        String lhsSource = state.getSourceForNode((Tree)lhs);
        String rhsSource = state.getSourceForNode((Tree)rhs);
        Nullness nullness = AbstractReferenceEquality.getNullness(lhs, state);
        if (nullness != Nullness.NONNULL) {
            Symbol existingObjects = FindIdentifiers.findIdent((String)"Objects", (VisitorState)state, (Kinds.KindSelector)Kinds.KindSelector.TYP);
            ObjectsFix preferredFix = AbstractReferenceEquality.symbolsTypeHasName(existingObjects, ObjectsFix.GUAVA.className) ? ObjectsFix.GUAVA : (AbstractReferenceEquality.symbolsTypeHasName(existingObjects, ObjectsFix.JAVA_UTIL.className) ? ObjectsFix.JAVA_UTIL : (state.isAndroidCompatible() ? ObjectsFix.GUAVA : ObjectsFix.JAVA_UTIL));
            builder.addFix((Fix)preferredFix.fix(tree, prefix, lhsSource, rhsSource));
        }
        if (nullness != Nullness.NULL) {
            builder.addFix((Fix)SuggestedFix.replace((Tree)tree, (String)String.format("%s%s.equals(%s)", prefix, lhs instanceof BinaryTree ? String.format("(%s)", lhsSource) : lhsSource, rhsSource)));
        }
    }

    private static Optional<Fix> inOrStatementWithEqualsCheck(VisitorState state, BinaryTree tree) {
        List<? extends ExpressionTree> arguments;
        if (tree.getKind() == Tree.Kind.NOT_EQUAL_TO) {
            return Optional.empty();
        }
        ExpressionTree lhs = tree.getLeftOperand();
        ExpressionTree rhs = tree.getRightOperand();
        Tree parent = state.getPath().getParentPath().getLeaf();
        if (parent.getKind() != Tree.Kind.CONDITIONAL_OR) {
            return Optional.empty();
        }
        BinaryTree p = (BinaryTree)parent;
        if (p.getLeftOperand() != tree) {
            return Optional.empty();
        }
        ExpressionTree otherExpression = ASTHelpers.stripParentheses((ExpressionTree)p.getRightOperand());
        if (!(otherExpression instanceof MethodInvocationTree)) {
            return Optional.empty();
        }
        MethodInvocationTree other = (MethodInvocationTree)otherExpression;
        if (EQUALS_STATIC_METHODS.matches((Tree)other, state) && AbstractReferenceEquality.treesMatch((arguments = other.getArguments()).get(0), arguments.get(1), lhs, rhs)) {
            return Optional.of(SuggestedFix.replace((Tree)parent, (String)state.getSourceForNode((Tree)otherExpression)));
        }
        if (OBJECT_INSTANCE_EQUALS.matches((Tree)otherExpression, state) && AbstractReferenceEquality.treesMatch(ASTHelpers.getReceiver((ExpressionTree)other), other.getArguments().get(0), lhs, rhs)) {
            return Optional.of(SuggestedFix.replace((Tree)parent, (String)state.getSourceForNode((Tree)otherExpression)));
        }
        return Optional.empty();
    }

    private static Nullness getNullness(ExpressionTree expr, VisitorState state) {
        TreePath pathToExpr = new TreePath(state.getPath(), expr);
        return state.getNullnessAnalysis().getNullness(pathToExpr, state.context);
    }

    private static boolean treesMatch(ExpressionTree lhs1, ExpressionTree rhs1, ExpressionTree lhs2, ExpressionTree rhs2) {
        return ASTHelpers.sameVariable((ExpressionTree)lhs1, (ExpressionTree)lhs2) && ASTHelpers.sameVariable((ExpressionTree)rhs1, (ExpressionTree)rhs2) || ASTHelpers.sameVariable((ExpressionTree)lhs1, (ExpressionTree)rhs2) && ASTHelpers.sameVariable((ExpressionTree)rhs1, (ExpressionTree)lhs2);
    }

    private static enum ObjectsFix {
        JAVA_UTIL("java.util.Objects", "Objects.equals"),
        GUAVA("com.google.common.base.Objects", "Objects.equal");

        private final String className;
        private final String methodName;

        private ObjectsFix(String className, String methodName) {
            this.className = className;
            this.methodName = methodName;
        }

        SuggestedFix fix(BinaryTree tree, String prefix, String lhsSource, String rhsSource) {
            return SuggestedFix.builder().replace((Tree)tree, String.format("%s%s(%s, %s)", prefix, this.methodName, lhsSource, rhsSource)).addImport(this.className).build();
        }
    }
}

