/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.runtime.instrumentation.common.base;

import com.google.monitoring.runtime.instrumentation.checker.nullness.compatqual.NullableDecl;
import com.google.monitoring.runtime.instrumentation.common.annotations.Beta;
import com.google.monitoring.runtime.instrumentation.common.annotations.GwtCompatible;
import com.google.monitoring.runtime.instrumentation.common.base.Absent;
import com.google.monitoring.runtime.instrumentation.common.base.AbstractIterator;
import com.google.monitoring.runtime.instrumentation.common.base.Function;
import com.google.monitoring.runtime.instrumentation.common.base.Preconditions;
import com.google.monitoring.runtime.instrumentation.common.base.Present;
import com.google.monitoring.runtime.instrumentation.common.base.Supplier;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;

@GwtCompatible(serializable=true)
public abstract class Optional<T>
implements Serializable {
    private static final long serialVersionUID = 0L;

    public static <T> Optional<T> absent() {
        return Absent.withType();
    }

    public static <T> Optional<T> of(T reference) {
        return new Present<T>(Preconditions.checkNotNull(reference));
    }

    public static <T> Optional<T> fromNullable(@NullableDecl T nullableReference) {
        return nullableReference == null ? Optional.absent() : new Present<T>(nullableReference);
    }

    Optional() {
    }

    public abstract boolean isPresent();

    public abstract T get();

    public abstract T or(T var1);

    public abstract Optional<T> or(Optional<? extends T> var1);

    @Beta
    public abstract T or(Supplier<? extends T> var1);

    @NullableDecl
    public abstract T orNull();

    public abstract Set<T> asSet();

    public abstract <V> Optional<V> transform(Function<? super T, V> var1);

    public abstract boolean equals(@NullableDecl Object var1);

    public abstract int hashCode();

    public abstract String toString();

    @Beta
    public static <T> Iterable<T> presentInstances(final Iterable<? extends Optional<? extends T>> optionals) {
        Preconditions.checkNotNull(optionals);
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new AbstractIterator<T>(){
                    private final Iterator<? extends Optional<? extends T>> iterator;
                    {
                        this.iterator = Preconditions.checkNotNull(optionals.iterator());
                    }

                    @Override
                    protected T computeNext() {
                        while (this.iterator.hasNext()) {
                            Optional optional = this.iterator.next();
                            if (!optional.isPresent()) continue;
                            return optional.get();
                        }
                        return this.endOfData();
                    }
                };
            }
        };
    }
}

