/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;

@BugPattern(name="NegativeCharLiteral", summary="Casting a negative signed literal to an (unsigned) char might be misleading.", severity=BugPattern.SeverityLevel.WARNING)
public class NegativeCharLiteral
extends BugChecker
implements BugChecker.TypeCastTreeMatcher {
    private static final Matcher<TypeCastTree> isIntegralLiteralCastToChar = Matchers.typeCast((Matcher)Matchers.isSameType((String)"char"), (Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.kindIs((Tree.Kind)Tree.Kind.LONG_LITERAL), Matchers.kindIs((Tree.Kind)Tree.Kind.INT_LITERAL)}));

    public Description matchTypeCast(TypeCastTree tree, VisitorState state) {
        if (!isIntegralLiteralCastToChar.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        long literalValue = ((Number)((LiteralTree)tree.getExpression()).getValue()).longValue();
        if (literalValue >= 0L) {
            return Description.NO_MATCH;
        }
        char castResult = (char)literalValue;
        String replacement = castResult == '\uffff' ? "Character.MAX_VALUE" : String.format("Character.MAX_VALUE - %s", 65535 - castResult);
        return this.describeMatch(tree, (Fix)SuggestedFix.builder().replace((Tree)tree, replacement).build());
    }
}

