/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.bugpatterns.MisusedDateFormat;
import java.util.Optional;

@BugPattern(name="MisusedDayOfYear", summary="Use of 'DD' (day of year) in a date pattern with 'MM' (month of year) is not likely to be intentional, as it would lead to dates like 'March 73rd'.", severity=BugPattern.SeverityLevel.ERROR)
public final class MisusedDayOfYear
extends MisusedDateFormat {
    @Override
    Optional<String> rewriteTo(String pattern) {
        final boolean[] containsD = new boolean[1];
        final boolean[] containsM = new boolean[1];
        MisusedDayOfYear.parseDateFormat(pattern, new MisusedDateFormat.DateFormatConsumer(){

            @Override
            public void consumeLiteral(char literal) {
            }

            @Override
            public void consumeSpecial(char special) {
                if (special == 'D') {
                    containsD[0] = true;
                }
                if (special == 'M') {
                    containsM[0] = true;
                }
            }
        });
        if (containsD[0] && containsM[0]) {
            return Optional.of(MisusedDayOfYear.replaceFormatChar(pattern, 'D', 'd'));
        }
        return Optional.empty();
    }
}

