/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.predicates.TypePredicates;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;

@BugPattern(name="Incomparable", summary="Types contained in sorted collections must implement Comparable.", severity=BugPattern.SeverityLevel.ERROR)
public class Incomparable
extends BugChecker
implements BugChecker.NewClassTreeMatcher {
    private static final Matcher<ExpressionTree> MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.constructor().forClass(TypePredicates.isExactTypeAny((Iterable)ImmutableList.of((Object)"java.util.TreeMap", (Object)"java.util.concurrent.ConcurrentSkipListMap"))).withParameters("java.util.Map", new String[0]), MethodMatchers.constructor().forClass(TypePredicates.isExactTypeAny((Iterable)ImmutableList.of((Object)"java.util.TreeSet", (Object)"java.util.concurrent.ConcurrentSkipListSet"))).withParameters("java.util.Set", new String[0]), MethodMatchers.constructor().forClass(TypePredicates.isExactTypeAny((Iterable)ImmutableList.of((Object)"java.util.TreeMap", (Object)"java.util.TreeSet", (Object)"java.util.concurrent.ConcurrentSkipListMap", (Object)"java.util.concurrent.ConcurrentSkipListSet"))).withNoParameters()});

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        if (!MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        ASTHelpers.TargetType targetType = ASTHelpers.targetType((VisitorState)state);
        Type type = targetType != null ? targetType.type() : ASTHelpers.getType((Tree)tree.getIdentifier());
        List<Type> typeArguments = type.getTypeArguments();
        if (typeArguments.isEmpty()) {
            return Description.NO_MATCH;
        }
        Type keyType = (Type)typeArguments.get(0);
        if (ASTHelpers.isCastable((Type)keyType, (Type)state.getSymtab().comparableType, (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage(String.format("%s does not implement Comparable", keyType)).build();
    }
}

