/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractReferenceEquality;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;

@BugPattern(name="BoxedPrimitiveEquality", summary="Comparison using reference equality instead of value equality. Reference equality of boxed primitive types is usually not useful, as they are value objects, and it is bug-prone, as instances are cached for some values but not others.", severity=BugPattern.SeverityLevel.WARNING)
public class BoxedPrimitiveEquality
extends AbstractReferenceEquality {
    @Override
    protected boolean matchArgument(ExpressionTree tree, VisitorState state) {
        Type type = ASTHelpers.getType((Tree)tree);
        if (type == null) {
            return false;
        }
        switch (state.getTypes().unboxedType(type).getTag()) {
            case BYTE: 
            case CHAR: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: {
                break;
            }
            default: {
                return false;
            }
        }
        Symbol sym = ASTHelpers.getSymbol((Tree)tree);
        return !(sym instanceof Symbol.VarSymbol) || !BoxedPrimitiveEquality.isFinal(sym) || !sym.isStatic();
    }

    public static boolean isFinal(Symbol s) {
        return (s.flags() & 0x10L) == 16L;
    }
}

