/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractToString;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.predicates.TypePredicates;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import java.util.Optional;

@BugPattern(name="AnnotationMirrorToString", summary="AnnotationMirror#toString doesn't use fully qualified type names, prefer auto-common's AnnotationMirrors#toString", severity=BugPattern.SeverityLevel.SUGGESTION)
public class AnnotationMirrorToString
extends AbstractToString {
    private static final TypePredicate TYPE_PREDICATE = TypePredicates.isExactType((String)"javax.lang.model.element.AnnotationMirror");

    @Override
    protected TypePredicate typePredicate() {
        return TYPE_PREDICATE;
    }

    @Override
    protected Optional<Fix> implicitToStringFix(ExpressionTree tree, VisitorState state) {
        return AnnotationMirrorToString.fix(tree, tree, state);
    }

    @Override
    protected Optional<Fix> toStringFix(Tree parent, ExpressionTree tree, VisitorState state) {
        return AnnotationMirrorToString.fix(parent, tree, state);
    }

    private static Optional<Fix> fix(Tree replace, Tree with, VisitorState state) {
        SuggestedFix.Builder fix = SuggestedFix.builder();
        return Optional.of(fix.replace(replace, String.format("%s.toString(%s)", SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)"com.google.auto.common.AnnotationMirrors"), state.getSourceForNode(with))).build());
    }
}

