/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.ZstdCompressCtx;
import com.github.luben.zstd.ZstdDecompressCtx;
import com.github.luben.zstd.ZstdDictCompress;
import com.github.luben.zstd.ZstdDictDecompress;
import com.github.luben.zstd.ZstdException;
import com.github.luben.zstd.util.Native;
import java.nio.ByteBuffer;

public class Zstd {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long compress(byte[] dst, byte[] src, int level, boolean checksumFlag) {
        try (ZstdCompressCtx ctx = new ZstdCompressCtx();){
            ctx.setLevel(level);
            ctx.setChecksum(checksumFlag);
            long l = ctx.compress(dst, src);
            return l;
        }
    }

    public static long compress(byte[] dst, byte[] src, int level) {
        return Zstd.compress(dst, src, level, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long compressByteArray(byte[] dst, int dstOffset, int dstSize, byte[] src, int srcOffset, int srcSize, int level, boolean checksumFlag) {
        try (ZstdCompressCtx ctx = new ZstdCompressCtx();){
            ctx.setLevel(level);
            ctx.setChecksum(checksumFlag);
            long l = ctx.compressByteArray(dst, dstOffset, dstSize, src, srcOffset, srcSize);
            return l;
        }
    }

    public static long compressByteArray(byte[] dst, int dstOffset, int dstSize, byte[] src, int srcOffset, int srcSize, int level) {
        return Zstd.compressByteArray(dst, dstOffset, dstSize, src, srcOffset, srcSize, level, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long compressDirectByteBuffer(ByteBuffer dst, int dstOffset, int dstSize, ByteBuffer src, int srcOffset, int srcSize, int level, boolean checksumFlag) {
        try (ZstdCompressCtx ctx = new ZstdCompressCtx();){
            ctx.setLevel(level);
            ctx.setChecksum(checksumFlag);
            long l = ctx.compressDirectByteBuffer(dst, dstOffset, dstSize, src, srcOffset, srcSize);
            return l;
        }
    }

    public static long compressDirectByteBuffer(ByteBuffer dst, int dstOffset, int dstSize, ByteBuffer src, int srcOffset, int srcSize, int level) {
        return Zstd.compressDirectByteBuffer(dst, dstOffset, dstSize, src, srcOffset, srcSize, level, false);
    }

    public static native long compressUnsafe(long var0, long var2, long var4, long var6, int var8, boolean var9);

    public static long compressUnsafe(long dst, long dstSize, long src, long srcSize, int level) {
        return Zstd.compressUnsafe(dst, dstSize, src, srcSize, level, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long compressUsingDict(byte[] dst, int dstOffset, byte[] src, int srcOffset, int length, byte[] dict, int level) {
        try (ZstdCompressCtx ctx = new ZstdCompressCtx();){
            ctx.setLevel(level);
            ctx.loadDict(dict);
            long l = ctx.compressByteArray(dst, dstOffset, dst.length - dstOffset, src, srcOffset, length);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long compressUsingDict(byte[] dst, int dstOffset, byte[] src, int srcOffset, byte[] dict, int level) {
        try (ZstdCompressCtx ctx = new ZstdCompressCtx();){
            ctx.setLevel(level);
            ctx.loadDict(dict);
            long l = ctx.compressByteArray(dst, dstOffset, dst.length - dstOffset, src, srcOffset, src.length - srcOffset);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long compressDirectByteBufferUsingDict(ByteBuffer dst, int dstOffset, int dstSize, ByteBuffer src, int srcOffset, int srcSize, byte[] dict, int level) {
        try (ZstdCompressCtx ctx = new ZstdCompressCtx();){
            ctx.setLevel(level);
            ctx.loadDict(dict);
            long l = ctx.compressDirectByteBuffer(dst, dstOffset, dstSize, src, srcOffset, srcSize);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long compressFastDict(byte[] dst, int dstOffset, byte[] src, int srcOffset, int length, ZstdDictCompress dict) {
        try (ZstdCompressCtx ctx = new ZstdCompressCtx();){
            ctx.loadDict(dict);
            ctx.setLevel(dict.level());
            long l = ctx.compressByteArray(dst, dstOffset, dst.length - dstOffset, src, srcOffset, length);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long compressFastDict(byte[] dst, int dstOffset, byte[] src, int srcOffset, ZstdDictCompress dict) {
        try (ZstdCompressCtx ctx = new ZstdCompressCtx();){
            ctx.loadDict(dict);
            ctx.setLevel(dict.level());
            long l = ctx.compressByteArray(dst, dstOffset, dst.length - dstOffset, src, srcOffset, src.length - srcOffset);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long compress(byte[] dst, byte[] src, ZstdDictCompress dict) {
        try (ZstdCompressCtx ctx = new ZstdCompressCtx();){
            ctx.loadDict(dict);
            ctx.setLevel(dict.level());
            long l = ctx.compress(dst, src);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long compressDirectByteBufferFastDict(ByteBuffer dst, int dstOffset, int dstSize, ByteBuffer src, int srcOffset, int srcSize, ZstdDictCompress dict) {
        try (ZstdCompressCtx ctx = new ZstdCompressCtx();){
            ctx.loadDict(dict);
            ctx.setLevel(dict.level());
            long l = ctx.compressDirectByteBuffer(dst, dstOffset, dstSize, src, srcOffset, srcSize);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long decompress(byte[] dst, byte[] src) {
        try (ZstdDecompressCtx ctx = new ZstdDecompressCtx();){
            long l = ctx.decompress(dst, src);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long decompressByteArray(byte[] dst, int dstOffset, int dstSize, byte[] src, int srcOffset, int srcSize) {
        try (ZstdDecompressCtx ctx = new ZstdDecompressCtx();){
            long l = ctx.decompressByteArray(dst, dstOffset, dstSize, src, srcOffset, srcSize);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long decompressDirectByteBuffer(ByteBuffer dst, int dstOffset, int dstSize, ByteBuffer src, int srcOffset, int srcSize) {
        try (ZstdDecompressCtx ctx = new ZstdDecompressCtx();){
            long l = ctx.decompressDirectByteBuffer(dst, dstOffset, dstSize, src, srcOffset, srcSize);
            return l;
        }
    }

    public static native long decompressUnsafe(long var0, long var2, long var4, long var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long decompressUsingDict(byte[] dst, int dstOffset, byte[] src, int srcOffset, int length, byte[] dict) {
        try (ZstdDecompressCtx ctx = new ZstdDecompressCtx();){
            ctx.loadDict(dict);
            long l = ctx.decompressByteArray(dst, dstOffset, dst.length - dstOffset, src, srcOffset, length);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long decompressDirectByteBufferUsingDict(ByteBuffer dst, int dstOffset, int dstSize, ByteBuffer src, int srcOffset, int srcSize, byte[] dict) {
        try (ZstdDecompressCtx ctx = new ZstdDecompressCtx();){
            ctx.loadDict(dict);
            long l = ctx.decompressDirectByteBuffer(dst, dstOffset, dstSize, src, srcOffset, srcSize);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long decompressFastDict(byte[] dst, int dstOffset, byte[] src, int srcOffset, int length, ZstdDictDecompress dict) {
        try (ZstdDecompressCtx ctx = new ZstdDecompressCtx();){
            ctx.loadDict(dict);
            long l = ctx.decompressByteArray(dst, dstOffset, dst.length - dstOffset, src, srcOffset, length);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long decompressDirectByteBufferFastDict(ByteBuffer dst, int dstOffset, int dstSize, ByteBuffer src, int srcOffset, int srcSize, ZstdDictDecompress dict) {
        try (ZstdDecompressCtx ctx = new ZstdDecompressCtx();){
            ctx.loadDict(dict);
            long l = ctx.decompressDirectByteBuffer(dst, dstOffset, dstSize, src, srcOffset, srcSize);
            return l;
        }
    }

    public static native int loadDictDecompress(long var0, byte[] var2, int var3);

    public static native int loadFastDictDecompress(long var0, ZstdDictDecompress var2);

    public static native int loadDictCompress(long var0, byte[] var2, int var3);

    public static native int loadFastDictCompress(long var0, ZstdDictCompress var2);

    public static native int setCompressionChecksums(long var0, boolean var2);

    public static native int setCompressionLevel(long var0, int var2);

    public static native int setCompressionLong(long var0, int var2);

    public static native int setCompressionWorkers(long var0, int var2);

    public static long decompressedSize(byte[] src, int srcPosition, int srcSize) {
        if (srcPosition >= src.length) {
            throw new ArrayIndexOutOfBoundsException(srcPosition);
        }
        if (srcPosition + srcSize > src.length) {
            throw new ArrayIndexOutOfBoundsException(srcPosition + srcSize);
        }
        return Zstd.decompressedSize0(src, srcPosition, srcSize);
    }

    private static native long decompressedSize0(byte[] var0, int var1, int var2);

    public static long decompressedSize(byte[] src, int srcPosition) {
        return Zstd.decompressedSize(src, srcPosition, src.length - srcPosition);
    }

    public static long decompressedSize(byte[] src) {
        return Zstd.decompressedSize(src, 0);
    }

    public static native long decompressedDirectByteBufferSize(ByteBuffer var0, int var1, int var2);

    public static native long compressBound(long var0);

    public static native boolean isError(long var0);

    public static native String getErrorName(long var0);

    public static native long getErrorCode(long var0);

    public static native long errNoError();

    public static native long errGeneric();

    public static native long errPrefixUnknown();

    public static native long errVersionUnsupported();

    public static native long errFrameParameterUnsupported();

    public static native long errFrameParameterWindowTooLarge();

    public static native long errCorruptionDetected();

    public static native long errChecksumWrong();

    public static native long errDictionaryCorrupted();

    public static native long errDictionaryWrong();

    public static native long errDictionaryCreationFailed();

    public static native long errParameterUnsupported();

    public static native long errParameterOutOfBound();

    public static native long errTableLogTooLarge();

    public static native long errMaxSymbolValueTooLarge();

    public static native long errMaxSymbolValueTooSmall();

    public static native long errStageWrong();

    public static native long errInitMissing();

    public static native long errMemoryAllocation();

    public static native long errWorkSpaceTooSmall();

    public static native long errDstSizeTooSmall();

    public static native long errSrcSizeWrong();

    public static native long errDstBufferNull();

    public static native long trainFromBuffer(byte[][] var0, byte[] var1, boolean var2);

    public static native long trainFromBufferDirect(ByteBuffer var0, int[] var1, ByteBuffer var2, boolean var3);

    public static native long getDictIdFromFrame(byte[] var0);

    public static native long getDictIdFromFrameBuffer(ByteBuffer var0);

    public static native long getDictIdFromDict(byte[] var0);

    public static long trainFromBuffer(byte[][] samples, byte[] dictBuffer) {
        return Zstd.trainFromBuffer(samples, dictBuffer, false);
    }

    public static long trainFromBufferDirect(ByteBuffer samples, int[] sampleSizes, ByteBuffer dictBuffer) {
        return Zstd.trainFromBufferDirect(samples, sampleSizes, dictBuffer, false);
    }

    public static native int magicNumber();

    public static native int windowLogMin();

    public static native int windowLogMax();

    public static native int chainLogMin();

    public static native int chainLogMax();

    public static native int hashLogMin();

    public static native int hashLogMax();

    public static native int searchLogMin();

    public static native int searchLogMax();

    public static native int searchLengthMin();

    public static native int searchLengthMax();

    public static native int blockSizeMax();

    public static native int defaultCompressionLevel();

    public static native int minCompressionLevel();

    public static native int maxCompressionLevel();

    public static byte[] compress(byte[] src) throws ZstdException {
        return Zstd.compress(src, Zstd.defaultCompressionLevel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compress(byte[] src, int level) throws ZstdException {
        try (ZstdCompressCtx ctx = new ZstdCompressCtx();){
            ctx.setLevel(level);
            byte[] byArray = ctx.compress(src);
            return byArray;
        }
    }

    public static int compress(ByteBuffer dstBuf, ByteBuffer srcBuf) throws ZstdException {
        return Zstd.compress(dstBuf, srcBuf, Zstd.defaultCompressionLevel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int compress(ByteBuffer dstBuf, ByteBuffer srcBuf, int level, boolean checksumFlag) throws ZstdException {
        try (ZstdCompressCtx ctx = new ZstdCompressCtx();){
            ctx.setLevel(level);
            ctx.setChecksum(checksumFlag);
            int n = ctx.compress(dstBuf, srcBuf);
            return n;
        }
    }

    public static int compress(ByteBuffer dstBuf, ByteBuffer srcBuf, int level) throws ZstdException {
        return Zstd.compress(dstBuf, srcBuf, level, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer compress(ByteBuffer srcBuf, int level) throws ZstdException {
        try (ZstdCompressCtx ctx = new ZstdCompressCtx();){
            ctx.setLevel(level);
            ByteBuffer byteBuffer = ctx.compress(srcBuf);
            return byteBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compress(byte[] src, ZstdDictCompress dict) throws ZstdException {
        try (ZstdCompressCtx ctx = new ZstdCompressCtx();){
            ctx.loadDict(dict);
            ctx.setLevel(dict.level());
            byte[] byArray = ctx.compress(src);
            return byArray;
        }
    }

    @Deprecated
    public static long compressUsingDict(byte[] dst, byte[] src, byte[] dict, int level) {
        return Zstd.compressUsingDict(dst, 0, src, 0, src.length, dict, level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compressUsingDict(byte[] src, byte[] dict, int level) throws ZstdException {
        try (ZstdCompressCtx ctx = new ZstdCompressCtx();){
            ctx.loadDict(dict);
            ctx.setLevel(level);
            byte[] byArray = ctx.compress(src);
            return byArray;
        }
    }

    public static long compress(byte[] dst, byte[] src, byte[] dict, int level) {
        return Zstd.compressUsingDict(dst, 0, src, 0, src.length, dict, level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int compress(ByteBuffer dstBuff, ByteBuffer srcBuff, byte[] dict, int level) throws ZstdException {
        try (ZstdCompressCtx ctx = new ZstdCompressCtx();){
            ctx.loadDict(dict);
            ctx.setLevel(level);
            int n = ctx.compress(dstBuff, srcBuff);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer compress(ByteBuffer srcBuff, byte[] dict, int level) throws ZstdException {
        try (ZstdCompressCtx ctx = new ZstdCompressCtx();){
            ctx.loadDict(dict);
            ctx.setLevel(level);
            ByteBuffer byteBuffer = ctx.compress(srcBuff);
            return byteBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int compress(ByteBuffer dstBuff, ByteBuffer srcBuff, ZstdDictCompress dict) throws ZstdException {
        try (ZstdCompressCtx ctx = new ZstdCompressCtx();){
            ctx.loadDict(dict);
            ctx.setLevel(dict.level());
            int n = ctx.compress(dstBuff, srcBuff);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer compress(ByteBuffer srcBuff, ZstdDictCompress dict) throws ZstdException {
        try (ZstdCompressCtx ctx = new ZstdCompressCtx();){
            ctx.loadDict(dict);
            ctx.setLevel(dict.level());
            ByteBuffer byteBuffer = ctx.compress(srcBuff);
            return byteBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decompress(byte[] src, int originalSize) throws ZstdException {
        try (ZstdDecompressCtx ctx = new ZstdDecompressCtx();){
            byte[] byArray = ctx.decompress(src, originalSize);
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int decompress(ByteBuffer dstBuf, ByteBuffer srcBuf) throws ZstdException {
        try (ZstdDecompressCtx ctx = new ZstdDecompressCtx();){
            int n = ctx.decompress(dstBuf, srcBuf);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer decompress(ByteBuffer srcBuf, int originalSize) throws ZstdException {
        try (ZstdDecompressCtx ctx = new ZstdDecompressCtx();){
            ByteBuffer byteBuffer = ctx.decompress(srcBuf, originalSize);
            return byteBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decompress(byte[] src, ZstdDictDecompress dict, int originalSize) throws ZstdException {
        try (ZstdDecompressCtx ctx = new ZstdDecompressCtx();){
            ctx.loadDict(dict);
            byte[] byArray = ctx.decompress(src, originalSize);
            return byArray;
        }
    }

    @Deprecated
    public static long decompressUsingDict(byte[] dst, byte[] src, byte[] dict) {
        return Zstd.decompressUsingDict(dst, 0, src, 0, src.length, dict);
    }

    public static long decompress(byte[] dst, byte[] src, byte[] dict) {
        return Zstd.decompressUsingDict(dst, 0, src, 0, src.length, dict);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decompress(byte[] src, byte[] dict, int originalSize) throws ZstdException {
        try (ZstdDecompressCtx ctx = new ZstdDecompressCtx();){
            ctx.loadDict(dict);
            byte[] byArray = ctx.decompress(src, originalSize);
            return byArray;
        }
    }

    public static long decompressedSize(ByteBuffer srcBuf) {
        return Zstd.decompressedDirectByteBufferSize(srcBuf, srcBuf.position(), srcBuf.limit() - srcBuf.position());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int decompress(ByteBuffer dstBuff, ByteBuffer srcBuff, byte[] dict) throws ZstdException {
        try (ZstdDecompressCtx ctx = new ZstdDecompressCtx();){
            ctx.loadDict(dict);
            int n = ctx.decompress(dstBuff, srcBuff);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer decompress(ByteBuffer srcBuff, byte[] dict, int originalSize) throws ZstdException {
        try (ZstdDecompressCtx ctx = new ZstdDecompressCtx();){
            ctx.loadDict(dict);
            ByteBuffer byteBuffer = ctx.decompress(srcBuff, originalSize);
            return byteBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int decompress(ByteBuffer dstBuff, ByteBuffer srcBuff, ZstdDictDecompress dict) throws ZstdException {
        try (ZstdDecompressCtx ctx = new ZstdDecompressCtx();){
            ctx.loadDict(dict);
            int n = ctx.decompress(dstBuff, srcBuff);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer decompress(ByteBuffer srcBuff, ZstdDictDecompress dict, int originalSize) throws ZstdException {
        try (ZstdDecompressCtx ctx = new ZstdDecompressCtx();){
            ctx.loadDict(dict);
            ByteBuffer byteBuffer = ctx.decompress(srcBuff, originalSize);
            return byteBuffer;
        }
    }

    static final byte[] extractArray(ByteBuffer buffer) {
        if (!buffer.hasArray() || buffer.arrayOffset() != 0) {
            throw new IllegalArgumentException("provided ByteBuffer lacks array or has non-zero arrayOffset");
        }
        return buffer.array();
    }

    static {
        Native.load();
    }
}

