/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.collect.Maps;
import com.google.devtools.build.lib.skyframe.serialization.AutoRegistry;
import com.google.devtools.build.lib.skyframe.serialization.Memoizer;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodecRegistry;
import com.google.devtools.build.lib.skyframe.serialization.SerializationDependencyProvider;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.protobuf.CodedInputStream;
import java.io.IOException;
import javax.annotation.Nullable;

public class DeserializationContext
implements SerializationDependencyProvider {
    private final ObjectCodecRegistry registry;
    private final ImmutableClassToInstanceMap<Object> dependencies;
    @Nullable
    private final Memoizer.Deserializer deserializer;

    private DeserializationContext(ObjectCodecRegistry registry, ImmutableClassToInstanceMap<Object> dependencies, @Nullable Memoizer.Deserializer deserializer) {
        this.registry = registry;
        this.dependencies = dependencies;
        this.deserializer = deserializer;
    }

    @VisibleForTesting
    public DeserializationContext(ObjectCodecRegistry registry, ImmutableClassToInstanceMap<Object> dependencies) {
        this(registry, dependencies, null);
    }

    @VisibleForTesting
    public DeserializationContext(ImmutableClassToInstanceMap<Object> dependencies) {
        this(AutoRegistry.get(), dependencies);
    }

    public <T> T deserialize(CodedInputStream codedIn) throws IOException, SerializationException {
        return this.deserializeInternal(codedIn, null);
    }

    public <T> T deserializeWithAdHocMemoizationStrategy(CodedInputStream codedIn, ObjectCodec.MemoizationStrategy memoizationStrategy) throws IOException, SerializationException {
        return this.deserializeInternal(codedIn, memoizationStrategy);
    }

    private <T> T deserializeInternal(CodedInputStream codedIn, @Nullable ObjectCodec.MemoizationStrategy customMemoizationStrategy) throws IOException, SerializationException {
        int tag = codedIn.readSInt32();
        if (tag == 0) {
            return null;
        }
        if (tag < 0) {
            return (T)this.deserializer.getMemoized(-tag - 1);
        }
        Object constant = this.registry.maybeGetConstantByTag(tag);
        if (constant != null) {
            return (T)constant;
        }
        ObjectCodecRegistry.CodecDescriptor codecDescriptor = this.registry.getCodecDescriptorByTag(tag);
        if (this.deserializer == null) {
            return (T)codecDescriptor.deserialize(this, codedIn);
        }
        ObjectCodec<?> castCodec = codecDescriptor.getCodec();
        ObjectCodec.MemoizationStrategy memoizationStrategy = customMemoizationStrategy != null ? customMemoizationStrategy : castCodec.getStrategy();
        return (T)this.deserializer.deserialize(this, castCodec, memoizationStrategy, codedIn);
    }

    public <T> void registerInitialValue(T initialValue) {
        if (this.deserializer != null) {
            this.deserializer.registerInitialValue(initialValue);
        }
    }

    @Override
    public <T> T getDependency(Class<T> type) {
        return (T)Preconditions.checkNotNull((Object)this.dependencies.getInstance(type), (String)"Missing dependency of type %s", type);
    }

    @CheckReturnValue
    public DeserializationContext getMemoizingContext() {
        if (this.deserializer != null) {
            return this;
        }
        return this.getNewMemoizingContext();
    }

    public DeserializationContext getNewMemoizingContext() {
        return new DeserializationContext(this.registry, this.dependencies, new Memoizer.Deserializer());
    }

    @CheckReturnValue
    public DeserializationContext withDependencyOverrides(ClassToInstanceMap<?> dependencyOverrides) {
        Preconditions.checkState((this.deserializer == null ? 1 : 0) != 0, (Object)"Must only be called on base DeserializationContext");
        return new DeserializationContext(this.registry, (ImmutableClassToInstanceMap<Object>)ImmutableClassToInstanceMap.builder().putAll(Maps.filterKeys(this.dependencies, k -> !dependencyOverrides.containsKey(k))).putAll(dependencyOverrides).build(), null);
    }
}

