/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractToString;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.predicates.TypePredicates;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.FindIdentifiers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;
import java.io.Serializable;
import java.util.Optional;

@BugPattern(name="TreeToString", summary="Tree#toString shouldn't be used for Trees deriving from the code being compiled, as it discards whitespace and comments.", severity=BugPattern.SeverityLevel.ERROR)
public class TreeToString
extends AbstractToString {
    private static final Matcher<ClassTree> IS_BUGCHECKER = Matchers.isSubtypeOf((String)"com.google.errorprone.bugpatterns.BugChecker");
    private static final TypePredicate IS_TREE = TypePredicates.isDescendantOf((String)"com.sun.source.tree.Tree");
    private static final Matcher<ExpressionTree> TREEMAKER_LITERAL_CREATOR = Matchers.instanceMethod().onDescendantOf("com.sun.tools.javac.tree.TreeMaker").named("Literal").withParameters("java.lang.Object", new String[0]);
    private static final Supplier<Type> COM_GOOGLE_ERRORPRONE_VISITORSTATE = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString("com.google.errorprone.VisitorState"));

    private static boolean treeToStringInBugChecker(Type type, VisitorState state) {
        ClassTree enclosingClass = (ClassTree)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), ClassTree.class);
        if (enclosingClass == null || !IS_BUGCHECKER.matches((Tree)enclosingClass, state)) {
            return false;
        }
        return IS_TREE.apply(type, state);
    }

    @Override
    protected TypePredicate typePredicate() {
        return TreeToString::treeToStringInBugChecker;
    }

    @Override
    protected Optional<String> descriptionMessageForDefaultMatch(Type type, VisitorState state) {
        return Optional.of("Tree#toString shouldn't be used.");
    }

    @Override
    protected Optional<Fix> implicitToStringFix(ExpressionTree tree, VisitorState state) {
        return TreeToString.fix(tree, tree, state);
    }

    @Override
    protected Optional<Fix> toStringFix(Tree parent, ExpressionTree tree, VisitorState state) {
        if (!(parent instanceof MethodInvocationTree)) {
            return Optional.empty();
        }
        ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)((ExpressionTree)parent));
        if (receiver == null) {
            return Optional.empty();
        }
        return TreeToString.fix(receiver, parent, state);
    }

    private static Optional<Fix> fix(Tree target, Tree replace, VisitorState state) {
        return FindIdentifiers.findAllIdents((VisitorState)state).stream().filter(s -> ASTHelpers.isSubtype((Type)s.type, (Type)((Type)COM_GOOGLE_ERRORPRONE_VISITORSTATE.get(state)), (VisitorState)state)).findFirst().map(s -> SuggestedFix.replace((Tree)replace, (String)TreeToString.createStringReplacement(state, s, target)));
    }

    private static String createStringReplacement(VisitorState state, Symbol.VarSymbol visitorStateSymbol, Tree target) {
        MethodInvocationTree targetMethodInvocationTree;
        String visitorStateVariable = ((Name)visitorStateSymbol.getSimpleName()).toString();
        if (target instanceof MethodInvocationTree && TREEMAKER_LITERAL_CREATOR.matches((Tree)(targetMethodInvocationTree = (MethodInvocationTree)target), state)) {
            return String.format("%s.getConstantExpression(%s)", visitorStateVariable, state.getSourceForNode((Tree)Iterables.getOnlyElement(targetMethodInvocationTree.getArguments())));
        }
        return String.format("%s.getSourceForNode(%s)", visitorStateVariable, state.getSourceForNode(target));
    }
}

