/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractToString;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.Names;
import java.util.Optional;

@BugPattern(name="ObjectToString", summary="Calling toString on Objects that don't override toString() doesn't provide useful information", severity=BugPattern.SeverityLevel.WARNING)
public class ObjectToString
extends AbstractToString {
    private static boolean finalNoOverrides(Type type, VisitorState state) {
        if (type == null) {
            return false;
        }
        if (!type.isFinal()) {
            return false;
        }
        Types types = state.getTypes();
        Names names = state.getNames();
        Symbol.MethodSymbol toString = (Symbol.MethodSymbol)state.getSymtab().objectType.tsym.members().findFirst(names.toString);
        return Iterables.isEmpty((Iterable)ASTHelpers.scope((Scope)types.membersClosure(type, false)).getSymbolsByName(names.toString, m -> m != toString && m.overrides(toString, type.tsym, types, false)));
    }

    @Override
    protected TypePredicate typePredicate() {
        return ObjectToString::finalNoOverrides;
    }

    @Override
    protected Optional<String> descriptionMessageForDefaultMatch(Type type, VisitorState state) {
        return Optional.of(String.format("%1$s is final and does not override Object.toString, so converting it to a string will print its identity (e.g. `%2$s@4488aabb`) instead of useful information.", SuggestedFixes.prettyType((Type)type, (VisitorState)state), type.tsym.getSimpleName()));
    }

    @Override
    protected Optional<Fix> implicitToStringFix(ExpressionTree tree, VisitorState state) {
        return Optional.empty();
    }

    @Override
    protected Optional<Fix> toStringFix(Tree parent, ExpressionTree tree, VisitorState state) {
        return Optional.empty();
    }
}

