/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.RuntimeVersion;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.ElementKind;

@BugPattern(name="MissingCasesInEnumSwitch", summary="Switches on enum types should either handle all values, or have a default case.", severity=BugPattern.SeverityLevel.WARNING)
public class MissingCasesInEnumSwitch
extends BugChecker
implements BugChecker.SwitchTreeMatcher {
    public static final int MAX_CASES_TO_PRINT = 5;

    public Description matchSwitch(SwitchTree tree, VisitorState state) {
        Type switchType = ASTHelpers.getType((Tree)tree.getExpression());
        if (switchType.asElement().getKind() != ElementKind.ENUM) {
            return Description.NO_MATCH;
        }
        if (tree.getCases().stream().anyMatch(c -> c.getExpression() == null)) {
            return Description.NO_MATCH;
        }
        ImmutableSet handled = (ImmutableSet)tree.getCases().stream().flatMap(MissingCasesInEnumSwitch::getExpressions).filter(IdentifierTree.class::isInstance).map(e -> ((IdentifierTree)e).getName().toString()).collect(ImmutableSet.toImmutableSet());
        Sets.SetView unhandled = Sets.difference((Set)ASTHelpers.enumValues((Symbol.TypeSymbol)switchType.asElement()), (Set)handled);
        if (unhandled.isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage(MissingCasesInEnumSwitch.buildMessage((Set<String>)unhandled)).build();
    }

    private static String buildMessage(Set<String> unhandled) {
        StringBuilder message = new StringBuilder("Non-exhaustive switch; either add a default or handle the remaining cases: ");
        int numberToShow = unhandled.size() > 5 ? 3 : unhandled.size();
        message.append(unhandled.stream().limit(numberToShow).collect(Collectors.joining(", ")));
        if (numberToShow < unhandled.size()) {
            message.append(String.format(", and %d others", unhandled.size() - numberToShow));
        }
        return message.toString();
    }

    private static Stream<? extends ExpressionTree> getExpressions(CaseTree caseTree) {
        try {
            if (RuntimeVersion.isAtLeast12()) {
                return ((List)CaseTree.class.getMethod("getExpressions", new Class[0]).invoke((Object)caseTree, new Object[0])).stream();
            }
            return Stream.of(caseTree.getExpression());
        }
        catch (ReflectiveOperationException e) {
            throw new LinkageError(e.getMessage(), e);
        }
    }
}

