/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.expr;

import android.databinding.tool.expr.ComparisonExpr;
import android.databinding.tool.expr.Dependency;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.expr.ExprModel;
import android.databinding.tool.expr.SymbolExpr;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.solver.ExecutionPath;
import android.databinding.tool.writer.KCode;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public class TernaryExpr
extends Expr {
    TernaryExpr(Expr pred, Expr ifTrue, Expr ifFalse) {
        super(pred, ifTrue, ifFalse);
    }

    public Expr getPred() {
        return this.getChildren().get(0);
    }

    public Expr getIfTrue() {
        return this.getChildren().get(1);
    }

    public Expr getIfFalse() {
        return this.getChildren().get(2);
    }

    @Override
    protected String computeUniqueKey() {
        return TernaryExpr.join(this.getPred(), "?", this.getIfTrue(), ":", this.getIfFalse());
    }

    @Override
    public String getInvertibleError() {
        if (this.getPred().isDynamic()) {
            return "The condition of a ternary operator must be constant: " + this.getPred().toFullCode();
        }
        String trueInvertible = this.getIfTrue().getInvertibleError();
        if (trueInvertible != null) {
            return trueInvertible;
        }
        return this.getIfFalse().getInvertibleError();
    }

    @Override
    public void injectSafeUnboxing(ModelAnalyzer modelAnalyzer, ExprModel model) {
        Expr pred = this.getPred();
        if (pred.getResolvedType().isNullable()) {
            this.safeUnboxChild(model, pred);
        }
        if (!this.getResolvedType().isNullable()) {
            boolean guaranteedNotNull;
            Expr ifTrue = this.getIfTrue();
            Expr ifFalse = this.getIfFalse();
            ComparisonExpr compPredicate = null;
            if (pred instanceof ComparisonExpr) {
                compPredicate = (ComparisonExpr)pred;
            }
            if (ifTrue.getResolvedType().isNullable()) {
                boolean bl = guaranteedNotNull = compPredicate != null && compPredicate.isNotNullCheckFor(ifTrue);
                if (!guaranteedNotNull) {
                    this.safeUnboxChild(model, ifTrue);
                }
            }
            if (ifFalse.getResolvedType().isNullable()) {
                boolean bl = guaranteedNotNull = compPredicate != null && compPredicate.isNullCheckFor(ifFalse);
                if (!guaranteedNotNull) {
                    this.safeUnboxChild(model, ifFalse);
                }
            }
        }
    }

    @Override
    protected ModelClass resolveType(ModelAnalyzer modelAnalyzer) {
        Expr ifTrue = this.getIfTrue();
        Expr ifFalse = this.getIfFalse();
        if (TernaryExpr.isNullLiteral(ifTrue)) {
            return ifFalse.getResolvedType();
        }
        if (TernaryExpr.isNullLiteral(ifFalse)) {
            return ifTrue.getResolvedType();
        }
        return modelAnalyzer.findCommonParentOf(this.getIfTrue().getResolvedType(), this.getIfFalse().getResolvedType());
    }

    private static boolean isNullLiteral(Expr expr) {
        ModelClass type = expr.getResolvedType();
        return type.isObject() && expr instanceof SymbolExpr && "null".equals(((SymbolExpr)expr).getText());
    }

    @Override
    protected List<Dependency> constructDependencies() {
        Expr ifFalseExpr;
        ArrayList<Dependency> deps = new ArrayList<Dependency>();
        Expr predExpr = this.getPred();
        Dependency pred = new Dependency(this, predExpr);
        pred.setMandatory(true);
        deps.add(pred);
        Expr ifTrueExpr = this.getIfTrue();
        if (ifTrueExpr.isDynamic()) {
            deps.add(new Dependency(this, ifTrueExpr, predExpr, true));
        }
        if ((ifFalseExpr = this.getIfFalse()).isDynamic()) {
            deps.add(new Dependency(this, ifFalseExpr, predExpr, false));
        }
        return deps;
    }

    @Override
    public List<ExecutionPath> toExecutionPath(List<ExecutionPath> paths) {
        List<ExecutionPath> executionPaths = this.getPred().toExecutionPath(paths);
        ArrayList<ExecutionPath> result = new ArrayList<ExecutionPath>();
        for (ExecutionPath path : executionPaths) {
            ExecutionPath ifFalse;
            ExecutionPath ifTrue = path.addBranch(this.getPred(), true);
            if (ifTrue != null) {
                result.addAll(this.getIfTrue().toExecutionPath(ifTrue));
            }
            if ((ifFalse = path.addBranch(this.getPred(), false)) == null) continue;
            result.addAll(this.getIfFalse().toExecutionPath(ifFalse));
        }
        return this.addJustMeToExecutionPath(result);
    }

    @Override
    protected BitSet getPredicateInvalidFlags() {
        return this.getPred().getInvalidFlags();
    }

    @Override
    protected KCode generateCode() {
        return new KCode().app("((", this.getPred().toCode()).app(") ? (", this.getIfTrue().toCode()).app(") : (", this.getIfFalse().toCode()).app("))");
    }

    @Override
    public Expr generateInverse(ExprModel model, Expr value, String bindingClassName) {
        Expr pred = this.getPred().cloneToModel(model);
        Expr ifTrue = this.getIfTrue().generateInverse(model, value, bindingClassName);
        Expr ifFalse = this.getIfFalse().generateInverse(model, value, bindingClassName);
        return model.ternary(pred, ifTrue, ifFalse);
    }

    @Override
    public Expr cloneToModel(ExprModel model) {
        return model.ternary(this.getPred().cloneToModel(model), this.getIfTrue().cloneToModel(model), this.getIfFalse().cloneToModel(model));
    }

    @Override
    public boolean isConditional() {
        return true;
    }

    @Override
    public String toString() {
        return this.getPred().toString() + " ? " + this.getIfTrue() + " : " + this.getIfFalse();
    }
}

