/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.errorprone.dataflow.cfg.block;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.checkerframework.errorprone.checker.nullness.qual.Nullable;
import org.checkerframework.errorprone.dataflow.cfg.block.Block;
import org.checkerframework.errorprone.dataflow.cfg.block.BlockImpl;
import org.checkerframework.errorprone.dataflow.cfg.block.RegularBlock;
import org.checkerframework.errorprone.dataflow.cfg.block.SingleSuccessorBlockImpl;
import org.checkerframework.errorprone.dataflow.cfg.node.Node;

public class RegularBlockImpl
extends SingleSuccessorBlockImpl
implements RegularBlock {
    protected final List<Node> contents = new ArrayList<Node>();

    public RegularBlockImpl() {
        super(Block.BlockType.REGULAR_BLOCK);
    }

    public void addNode(Node t2) {
        this.contents.add(t2);
        t2.setBlock(this);
    }

    public void addNodes(List<? extends Node> ts) {
        for (Node node : ts) {
            this.addNode(node);
        }
    }

    @Override
    public List<Node> getContents() {
        return this.getNodes();
    }

    @Override
    public List<Node> getNodes() {
        return Collections.unmodifiableList(this.contents);
    }

    @Override
    public @Nullable Node getLastNode() {
        return this.contents.get(this.contents.size() - 1);
    }

    @Override
    public @Nullable BlockImpl getRegularSuccessor() {
        return this.successor;
    }

    public String toString() {
        return "RegularBlock(" + this.contents + ")";
    }

    @Override
    public boolean isEmpty() {
        return this.contents.isEmpty();
    }
}

