/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.devtools.build.lib.skyframe.serialization.CodecRegisterer;
import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.devtools.build.lib.skyframe.serialization.strings.StringCodec;
import com.google.devtools.build.lib.unsafe.StringUnsafe;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class UnsafeJdk9StringCodec
implements ObjectCodec<String> {
    private final StringUnsafe stringUnsafe = StringUnsafe.getInstance();
    private static final StringCodec stringCodec = new StringCodec();
    private static final UnsafeJdk9StringCodec unsafeCodec = UnsafeJdk9StringCodec.canUseUnsafeCodec() ? new UnsafeJdk9StringCodec() : null;

    @VisibleForTesting
    public static boolean canUseUnsafeCodec() {
        return StringUnsafe.canUse();
    }

    @VisibleForTesting
    public UnsafeJdk9StringCodec() {
    }

    @Override
    public Class<? extends String> getEncodedClass() {
        return String.class;
    }

    @Override
    public ObjectCodec.MemoizationStrategy getStrategy() {
        return ObjectCodec.MemoizationStrategy.DO_NOT_MEMOIZE;
    }

    @Override
    public void serialize(SerializationContext context, String obj, CodedOutputStream codedOut) throws SerializationException, IOException {
        byte coder = this.stringUnsafe.getCoder(obj);
        byte[] value = this.stringUnsafe.getByteArray(obj);
        if (coder == 0) {
            codedOut.writeInt32NoTag(value.length);
        } else if (coder == 1) {
            codedOut.writeInt32NoTag(-value.length);
        } else {
            throw new SerializationException("Unexpected coder value: " + coder + " for " + obj);
        }
        codedOut.writeRawBytes(value);
    }

    @Override
    public String deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
        byte coder;
        int length = codedIn.readInt32();
        if (length >= 0) {
            coder = 0;
        } else {
            coder = 1;
            length = -length;
        }
        byte[] value = codedIn.readRawBytes(length);
        try {
            return this.stringUnsafe.newInstance(value, coder);
        }
        catch (ReflectiveOperationException e) {
            throw new SerializationException("Could not instantiate string: " + Arrays.toString(value) + ", " + coder, e);
        }
    }

    static class SimpleStringCodecRegisterer
    implements CodecRegisterer<StringCodec> {
        SimpleStringCodecRegisterer() {
        }

        @Override
        public Iterable<StringCodec> getCodecsToRegister() {
            return UnsafeJdk9StringCodec.canUseUnsafeCodec() ? ImmutableList.of() : ImmutableList.of((Object)stringCodec);
        }
    }

    static class UnsafeStringCodecRegisterer
    implements CodecRegisterer<UnsafeJdk9StringCodec> {
        UnsafeStringCodecRegisterer() {
        }

        @Override
        public Iterable<? extends ObjectCodec<?>> getCodecsToRegister() {
            return UnsafeJdk9StringCodec.canUseUnsafeCodec() ? ImmutableList.of((Object)unsafeCodec) : ImmutableList.of();
        }
    }
}

