/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.parse;

import com.google.common.base.Verify;
import com.google.turbine.diag.SourceFile;
import com.google.turbine.diag.TurbineError;
import com.google.turbine.parse.Lexer;
import com.google.turbine.parse.Token;
import com.google.turbine.parse.UnicodeEscapePreprocessor;

public class StreamLexer
implements Lexer {
    private final UnicodeEscapePreprocessor reader;
    private char ch;
    private int position;
    private int readFrom;
    private String value = null;
    private String javadoc = null;

    public StreamLexer(UnicodeEscapePreprocessor reader) {
        this.reader = reader;
        this.eat();
    }

    private void saveValue(String value) {
        this.value = value;
    }

    private void readFrom() {
        this.value = null;
        this.readFrom = this.reader.position();
    }

    private void eat() {
        this.ch = this.reader.next();
    }

    @Override
    public String javadoc() {
        String result = this.javadoc;
        this.javadoc = null;
        if (result == null) {
            return null;
        }
        Verify.verify((boolean)result.endsWith("*/"), (String)result, (Object[])new Object[0]);
        return result.substring(0, result.length() - "*/".length());
    }

    @Override
    public String stringValue() {
        if (this.value != null) {
            return this.value;
        }
        return this.reader.readString(this.readFrom, this.reader.position());
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public SourceFile source() {
        return this.reader.source();
    }

    @Override
    public Token next() {
        block57: while (true) {
            this.position = this.reader.position();
            switch (this.ch) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    this.eat();
                    continue block57;
                }
                case '/': {
                    this.eat();
                    switch (this.ch) {
                        case '/': {
                            block58: while (true) {
                                this.eat();
                                switch (this.ch) {
                                    case '\n': 
                                    case '\r': {
                                        this.eat();
                                        continue block57;
                                    }
                                    case '\u001a': {
                                        if (this.reader.done()) {
                                            return Token.EOF;
                                        }
                                        this.eat();
                                        continue block58;
                                    }
                                }
                            }
                        }
                        case '*': {
                            this.eat();
                            boolean sawStar = false;
                            boolean isJavadoc = false;
                            if (this.ch == '*') {
                                this.eat();
                                if (this.ch == '/') {
                                    this.eat();
                                    continue block57;
                                }
                                isJavadoc = true;
                                this.readFrom();
                            }
                            block59: while (true) {
                                switch (this.ch) {
                                    case '*': {
                                        this.eat();
                                        sawStar = true;
                                        continue block59;
                                    }
                                    case '/': {
                                        this.eat();
                                        if (sawStar) {
                                            if (!isJavadoc) continue block57;
                                            this.javadoc = this.stringValue();
                                            continue block57;
                                        }
                                        sawStar = false;
                                        continue block59;
                                    }
                                    case '\u001a': {
                                        if (this.reader.done()) {
                                            throw TurbineError.format(this.reader.source(), this.position, TurbineError.ErrorKind.UNCLOSED_COMMENT, new Object[0]);
                                        }
                                        this.eat();
                                        sawStar = false;
                                        continue block59;
                                    }
                                }
                                this.eat();
                                sawStar = false;
                            }
                        }
                    }
                    if (this.ch == '=') {
                        this.eat();
                        return Token.DIVEQ;
                    }
                    return Token.DIV;
                }
                case '$': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    return this.identifier();
                }
                case '\u001a': {
                    if (!this.reader.done()) {
                        throw this.error(TurbineError.ErrorKind.UNEXPECTED_EOF, new Object[0]);
                    }
                    return Token.EOF;
                }
                case '!': 
                case '%': 
                case '&': 
                case '*': 
                case '+': 
                case '-': 
                case ':': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '^': 
                case '|': 
                case '~': {
                    return this.operator();
                }
                case '(': {
                    this.eat();
                    return Token.LPAREN;
                }
                case ')': {
                    this.eat();
                    return Token.RPAREN;
                }
                case '{': {
                    this.eat();
                    return Token.LBRACE;
                }
                case '}': {
                    this.eat();
                    return Token.RBRACE;
                }
                case '[': {
                    this.eat();
                    return Token.LBRACK;
                }
                case ']': {
                    this.eat();
                    return Token.RBRACK;
                }
                case ';': {
                    this.eat();
                    return Token.SEMI;
                }
                case ',': {
                    this.eat();
                    return Token.COMMA;
                }
                case '@': {
                    this.eat();
                    return Token.AT;
                }
                case '0': {
                    this.readFrom();
                    this.eat();
                    switch (this.ch) {
                        case 'X': 
                        case 'x': {
                            this.eat();
                            return this.hexLiteral();
                        }
                        case 'B': 
                        case 'b': {
                            this.eat();
                            return this.boolLiteral();
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '_': {
                            return this.octalLiteral();
                        }
                        case '.': {
                            this.eat();
                            return this.floatLiteral();
                        }
                        case 'F': 
                        case 'f': {
                            this.eat();
                            return Token.FLOAT_LITERAL;
                        }
                        case 'D': 
                        case 'd': {
                            this.eat();
                            return Token.DOUBLE_LITERAL;
                        }
                        case 'L': 
                        case 'l': {
                            this.eat();
                            return Token.LONG_LITERAL;
                        }
                    }
                    return Token.INT_LITERAL;
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.readFrom();
                    return this.decimalLiteral();
                }
                case '.': {
                    this.readFrom();
                    this.eat();
                    switch (this.ch) {
                        case '.': {
                            this.eat();
                            if (this.ch == '.') {
                                this.eat();
                                return Token.ELLIPSIS;
                            }
                            throw this.error(TurbineError.ErrorKind.UNEXPECTED_INPUT, Character.valueOf(this.ch));
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            return this.floatLiteral();
                        }
                    }
                    return Token.DOT;
                }
                case '\'': {
                    char value;
                    this.eat();
                    switch (this.ch) {
                        case '\\': {
                            this.eat();
                            value = this.escape();
                            break;
                        }
                        case '\'': {
                            throw this.error(TurbineError.ErrorKind.EMPTY_CHARACTER_LITERAL, new Object[0]);
                        }
                        default: {
                            value = this.ch;
                            this.eat();
                        }
                    }
                    if (this.ch == '\'') {
                        this.saveValue(String.valueOf(value));
                        this.eat();
                        return Token.CHAR_LITERAL;
                    }
                    throw this.error(TurbineError.ErrorKind.UNTERMINATED_CHARACTER_LITERAL, new Object[0]);
                }
                case '\"': {
                    this.eat();
                    this.readFrom();
                    StringBuilder sb = new StringBuilder();
                    block60: while (true) {
                        switch (this.ch) {
                            case '\\': {
                                this.eat();
                                sb.append(this.escape());
                                continue block60;
                            }
                            case '\"': {
                                this.saveValue(sb.toString());
                                this.eat();
                                return Token.STRING_LITERAL;
                            }
                            case '\n': {
                                throw this.error(TurbineError.ErrorKind.UNTERMINATED_STRING, new Object[0]);
                            }
                            case '\u001a': {
                                if (!this.reader.done()) break;
                                return Token.EOF;
                            }
                        }
                        sb.append(this.ch);
                        this.eat();
                    }
                }
            }
            break;
        }
        if (Character.isJavaIdentifierStart(this.ch)) {
            return this.identifier();
        }
        throw this.error(TurbineError.ErrorKind.UNEXPECTED_INPUT, Character.valueOf(this.ch));
    }

    private char escape() {
        boolean zeroToThree = false;
        switch (this.ch) {
            case 'b': {
                this.eat();
                return '\b';
            }
            case 't': {
                this.eat();
                return '\t';
            }
            case 'n': {
                this.eat();
                return '\n';
            }
            case 'f': {
                this.eat();
                return '\f';
            }
            case 'r': {
                this.eat();
                return '\r';
            }
            case '\"': {
                this.eat();
                return '\"';
            }
            case '\'': {
                this.eat();
                return '\'';
            }
            case '\\': {
                this.eat();
                return '\\';
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': {
                zeroToThree = true;
            }
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                char value = (char)(this.ch - 48);
                this.eat();
                switch (this.ch) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        value = (char)(value << 3 | this.ch - 48);
                        this.eat();
                        if (!zeroToThree) break;
                        switch (this.ch) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': {
                                value = (char)(value << 3 | this.ch - 48);
                                this.eat();
                                return value;
                            }
                        }
                        return value;
                    }
                }
                return value;
            }
        }
        throw this.error(TurbineError.ErrorKind.UNEXPECTED_INPUT, Character.valueOf(this.ch));
    }

    private Token decimalLiteral() {
        this.readDigits();
        switch (this.ch) {
            case 'E': 
            case 'e': {
                return this.floatLiteral();
            }
            case '.': {
                this.eat();
                return this.floatLiteral();
            }
            case 'F': 
            case 'f': {
                this.eat();
                return Token.FLOAT_LITERAL;
            }
            case 'D': 
            case 'd': {
                this.eat();
                return Token.DOUBLE_LITERAL;
            }
            case 'L': 
            case 'l': {
                this.eat();
                return Token.LONG_LITERAL;
            }
        }
        return Token.INT_LITERAL;
    }

    private Token hexFloatLiteral() {
        this.readHexDigits();
        switch (this.ch) {
            case 'P': 
            case 'p': {
                this.eat();
                this.signedInteger();
                break;
            }
        }
        return this.floatTypeSuffix();
    }

    private Token floatLiteral() {
        if ('0' <= this.ch && this.ch <= '9') {
            this.readDigits();
        }
        switch (this.ch) {
            case 'E': 
            case 'e': {
                this.eat();
                this.signedInteger();
                break;
            }
        }
        return this.floatTypeSuffix();
    }

    private Token floatTypeSuffix() {
        switch (this.ch) {
            case 'D': 
            case 'd': {
                this.eat();
                return Token.DOUBLE_LITERAL;
            }
            case 'F': 
            case 'f': {
                this.eat();
                return Token.FLOAT_LITERAL;
            }
        }
        return Token.DOUBLE_LITERAL;
    }

    private void signedInteger() {
        switch (this.ch) {
            case '+': 
            case '-': {
                this.eat();
                break;
            }
        }
        this.readDigits();
    }

    private void readHexDigits() {
        switch (this.ch) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                this.eat();
                break;
            }
            default: {
                throw this.error(TurbineError.ErrorKind.UNEXPECTED_INPUT, Character.valueOf(this.ch));
            }
        }
        block10: while (true) {
            switch (this.ch) {
                case '_': {
                    do {
                        this.eat();
                    } while (this.ch == '_');
                    switch (this.ch) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': 
                        case 'A': 
                        case 'B': 
                        case 'C': 
                        case 'D': 
                        case 'E': 
                        case 'F': 
                        case 'a': 
                        case 'b': 
                        case 'c': 
                        case 'd': 
                        case 'e': 
                        case 'f': {
                            continue block10;
                        }
                    }
                    throw this.error(TurbineError.ErrorKind.UNEXPECTED_INPUT, Character.valueOf(this.ch));
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    this.eat();
                    continue block10;
                }
            }
            break;
        }
    }

    private void readDigits() {
        if ('0' > this.ch || this.ch > '9') {
            throw this.error(TurbineError.ErrorKind.UNEXPECTED_INPUT, Character.valueOf(this.ch));
        }
        this.eat();
        block4: while (true) {
            switch (this.ch) {
                case '_': {
                    do {
                        this.eat();
                    } while (this.ch == '_');
                    if ('0' <= this.ch && this.ch <= '9') continue block4;
                    throw this.error(TurbineError.ErrorKind.UNEXPECTED_INPUT, Character.valueOf(this.ch));
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.eat();
                    continue block4;
                }
            }
            break;
        }
    }

    private Token boolLiteral() {
        this.readBinaryDigits();
        switch (this.ch) {
            case 'L': 
            case 'l': {
                this.eat();
                return Token.LONG_LITERAL;
            }
        }
        return Token.INT_LITERAL;
    }

    private void readBinaryDigits() {
        switch (this.ch) {
            case '0': 
            case '1': {
                this.eat();
                break;
            }
            default: {
                throw this.error(TurbineError.ErrorKind.UNEXPECTED_INPUT, Character.valueOf(this.ch));
            }
        }
        block10: while (true) {
            switch (this.ch) {
                case '_': {
                    do {
                        this.eat();
                    } while (this.ch == '_');
                    switch (this.ch) {
                        case '0': 
                        case '1': {
                            continue block10;
                        }
                    }
                    throw this.error(TurbineError.ErrorKind.UNEXPECTED_INPUT, Character.valueOf(this.ch));
                }
                case '0': 
                case '1': {
                    this.eat();
                    continue block10;
                }
            }
            break;
        }
    }

    private Token octalLiteral() {
        this.readOctalDigits();
        switch (this.ch) {
            case 'L': 
            case 'l': {
                this.eat();
                return Token.LONG_LITERAL;
            }
        }
        return Token.INT_LITERAL;
    }

    private void readOctalDigits() {
        switch (this.ch) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '_': {
                this.eat();
                break;
            }
            default: {
                throw this.error(TurbineError.ErrorKind.UNEXPECTED_INPUT, Character.valueOf(this.ch));
            }
        }
        block10: while (true) {
            switch (this.ch) {
                case '_': {
                    do {
                        this.eat();
                    } while (this.ch == '_');
                    switch (this.ch) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': {
                            continue block10;
                        }
                    }
                    throw this.error(TurbineError.ErrorKind.UNEXPECTED_INPUT, Character.valueOf(this.ch));
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    this.eat();
                    continue block10;
                }
            }
            break;
        }
    }

    private Token hexLiteral() {
        this.readHexDigits();
        switch (this.ch) {
            case '.': {
                this.eat();
                return this.hexFloatLiteral();
            }
            case 'L': 
            case 'l': {
                this.eat();
                return Token.LONG_LITERAL;
            }
            case 'P': 
            case 'p': {
                this.eat();
                this.signedInteger();
                return this.floatTypeSuffix();
            }
        }
        return Token.INT_LITERAL;
    }

    private Token operator() {
        switch (this.ch) {
            case '=': {
                this.eat();
                if (this.ch == '=') {
                    this.eat();
                    return Token.EQ;
                }
                return Token.ASSIGN;
            }
            case '>': {
                this.eat();
                switch (this.ch) {
                    case '=': {
                        this.eat();
                        return Token.GTE;
                    }
                    case '>': {
                        this.eat();
                        switch (this.ch) {
                            case '>': {
                                this.eat();
                                if (this.ch == '=') {
                                    this.eat();
                                    return Token.GTGTGTE;
                                }
                                return Token.GTGTGT;
                            }
                            case '=': {
                                this.eat();
                                return Token.GTGTE;
                            }
                        }
                        return Token.GTGT;
                    }
                }
                return Token.GT;
            }
            case '<': {
                this.eat();
                switch (this.ch) {
                    case '=': {
                        this.eat();
                        return Token.LTE;
                    }
                    case '<': {
                        this.eat();
                        if (this.ch == '=') {
                            this.eat();
                            return Token.LTLTE;
                        }
                        return Token.LTLT;
                    }
                }
                return Token.LT;
            }
            case '!': {
                this.eat();
                if (this.ch == '=') {
                    this.eat();
                    return Token.NOTEQ;
                }
                return Token.NOT;
            }
            case '~': {
                this.eat();
                return Token.TILDE;
            }
            case '?': {
                this.eat();
                return Token.COND;
            }
            case ':': {
                this.eat();
                if (this.ch == ':') {
                    this.eat();
                    return Token.COLONCOLON;
                }
                return Token.COLON;
            }
            case '-': {
                this.eat();
                switch (this.ch) {
                    case '>': {
                        this.eat();
                        return Token.ARROW;
                    }
                    case '-': {
                        this.eat();
                        return Token.DECR;
                    }
                    case '=': {
                        this.eat();
                        return Token.MINUSEQ;
                    }
                }
                return Token.MINUS;
            }
            case '&': {
                this.eat();
                switch (this.ch) {
                    case '&': {
                        this.eat();
                        return Token.ANDAND;
                    }
                    case '=': {
                        this.eat();
                        return Token.ANDEQ;
                    }
                }
                return Token.AND;
            }
            case '|': {
                this.eat();
                switch (this.ch) {
                    case '=': {
                        this.eat();
                        return Token.OREQ;
                    }
                    case '|': {
                        this.eat();
                        return Token.OROR;
                    }
                }
                return Token.OR;
            }
            case '+': {
                this.eat();
                switch (this.ch) {
                    case '+': {
                        this.eat();
                        return Token.INCR;
                    }
                    case '=': {
                        this.eat();
                        return Token.PLUSEQ;
                    }
                }
                return Token.PLUS;
            }
            case '*': {
                this.eat();
                if (this.ch == '=') {
                    this.eat();
                    return Token.MULTEQ;
                }
                return Token.MULT;
            }
            case '/': {
                throw this.error(TurbineError.ErrorKind.UNEXPECTED_INPUT, Character.valueOf(this.ch));
            }
            case '%': {
                this.eat();
                if (this.ch == '=') {
                    this.eat();
                    return Token.MODEQ;
                }
                return Token.MOD;
            }
            case '^': {
                this.eat();
                if (this.ch == '=') {
                    this.eat();
                    return Token.XOREQ;
                }
                return Token.XOR;
            }
        }
        throw this.error(TurbineError.ErrorKind.UNEXPECTED_INPUT, Character.valueOf(this.ch));
    }

    private Token identifier() {
        this.readFrom();
        this.eat();
        while (Character.isJavaIdentifierPart(this.ch) && (this.ch != '\u001a' || !this.reader.done())) {
            this.eat();
        }
        return StreamLexer.makeIdent(this.stringValue());
    }

    private static Token makeIdent(String s) {
        switch (s) {
            case "abstract": {
                return Token.ABSTRACT;
            }
            case "assert": {
                return Token.ASSERT;
            }
            case "boolean": {
                return Token.BOOLEAN;
            }
            case "break": {
                return Token.BREAK;
            }
            case "byte": {
                return Token.BYTE;
            }
            case "case": {
                return Token.CASE;
            }
            case "catch": {
                return Token.CATCH;
            }
            case "char": {
                return Token.CHAR;
            }
            case "class": {
                return Token.CLASS;
            }
            case "const": {
                return Token.CONST;
            }
            case "continue": {
                return Token.CONTINUE;
            }
            case "default": {
                return Token.DEFAULT;
            }
            case "do": {
                return Token.DO;
            }
            case "double": {
                return Token.DOUBLE;
            }
            case "else": {
                return Token.ELSE;
            }
            case "enum": {
                return Token.ENUM;
            }
            case "extends": {
                return Token.EXTENDS;
            }
            case "final": {
                return Token.FINAL;
            }
            case "finally": {
                return Token.FINALLY;
            }
            case "float": {
                return Token.FLOAT;
            }
            case "for": {
                return Token.FOR;
            }
            case "goto": {
                return Token.GOTO;
            }
            case "if": {
                return Token.IF;
            }
            case "implements": {
                return Token.IMPLEMENTS;
            }
            case "import": {
                return Token.IMPORT;
            }
            case "instanceof": {
                return Token.INSTANCEOF;
            }
            case "int": {
                return Token.INT;
            }
            case "interface": {
                return Token.INTERFACE;
            }
            case "long": {
                return Token.LONG;
            }
            case "native": {
                return Token.NATIVE;
            }
            case "new": {
                return Token.NEW;
            }
            case "package": {
                return Token.PACKAGE;
            }
            case "private": {
                return Token.PRIVATE;
            }
            case "protected": {
                return Token.PROTECTED;
            }
            case "public": {
                return Token.PUBLIC;
            }
            case "return": {
                return Token.RETURN;
            }
            case "short": {
                return Token.SHORT;
            }
            case "static": {
                return Token.STATIC;
            }
            case "strictfp": {
                return Token.STRICTFP;
            }
            case "super": {
                return Token.SUPER;
            }
            case "switch": {
                return Token.SWITCH;
            }
            case "synchronized": {
                return Token.SYNCHRONIZED;
            }
            case "this": {
                return Token.THIS;
            }
            case "throw": {
                return Token.THROW;
            }
            case "throws": {
                return Token.THROWS;
            }
            case "transient": {
                return Token.TRANSIENT;
            }
            case "try": {
                return Token.TRY;
            }
            case "void": {
                return Token.VOID;
            }
            case "volatile": {
                return Token.VOLATILE;
            }
            case "while": {
                return Token.WHILE;
            }
            case "true": {
                return Token.TRUE;
            }
            case "false": {
                return Token.FALSE;
            }
            case "null": {
                return Token.NULL;
            }
        }
        return Token.IDENT;
    }

    private TurbineError error(TurbineError.ErrorKind kind, Object ... args) {
        return TurbineError.format(this.reader.source(), this.reader.position(), kind, args);
    }
}

