/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.dataflow.cfg;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.shaded.dataflow.analysis.AbstractValue;
import org.checkerframework.shaded.dataflow.analysis.Analysis;
import org.checkerframework.shaded.dataflow.analysis.FlowExpressions;
import org.checkerframework.shaded.dataflow.analysis.Store;
import org.checkerframework.shaded.dataflow.analysis.TransferFunction;
import org.checkerframework.shaded.dataflow.cfg.AbstractCFGVisualizer;
import org.checkerframework.shaded.dataflow.cfg.ControlFlowGraph;
import org.checkerframework.shaded.dataflow.cfg.block.Block;
import org.checkerframework.shaded.dataflow.cfg.block.SpecialBlock;
import org.checkerframework.shaded.dataflow.cfg.node.Node;

public class StringCFGVisualizer<A extends AbstractValue<A>, S extends Store<S>, T extends TransferFunction<A, S>>
extends AbstractCFGVisualizer<A, S, T> {
    @Override
    public Map<String, Object> visualize(ControlFlowGraph cfg, Block entry, @Nullable Analysis<A, S, T> analysis) {
        String stringGraph = this.visualizeGraph(cfg, entry, analysis);
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("stringGraph", stringGraph);
        return res;
    }

    @Override
    public String visualizeNodes(Set<Block> blocks, ControlFlowGraph cfg, @Nullable Analysis<A, S, T> analysis) {
        StringBuilder sbStringNodes = new StringBuilder();
        sbStringNodes.append(this.lineSeparator);
        IdentityHashMap<Block, List<Integer>> processOrder = this.getProcessOrder(cfg);
        for (Block v : blocks) {
            String strBlock;
            sbStringNodes.append(v.getId()).append(":").append(this.lineSeparator);
            if (this.verbose) {
                sbStringNodes.append(this.getProcessOrderSimpleString(processOrder.get(v))).append(this.lineSeparator);
            }
            if ((strBlock = this.visualizeBlock(v, analysis)).length() == 0) {
                sbStringNodes.append(this.lineSeparator);
                continue;
            }
            sbStringNodes.append(strBlock).append(this.lineSeparator);
        }
        return sbStringNodes.toString();
    }

    @Override
    protected String addEdge(long sId, long eId, String flowRule) {
        if (this.verbose) {
            return sId + " -> " + eId + " " + flowRule + this.lineSeparator;
        }
        return sId + " -> " + eId + this.lineSeparator;
    }

    @Override
    public String visualizeBlock(Block bb, @Nullable Analysis<A, S, T> analysis) {
        return super.visualizeBlockHelper(bb, analysis, this.lineSeparator);
    }

    @Override
    public String visualizeSpecialBlock(SpecialBlock sbb) {
        return super.visualizeSpecialBlockHelper(sbb, this.lineSeparator);
    }

    @Override
    public String visualizeBlockTransferInput(Block bb, Analysis<A, S, T> analysis) {
        return super.visualizeBlockTransferInputHelper(bb, analysis, this.lineSeparator);
    }

    @Override
    public String visualizeBlockNode(Node t, @Nullable Analysis<A, S, T> analysis) {
        A value;
        StringBuilder sbBlockNode = new StringBuilder();
        sbBlockNode.append(t.toString()).append("   [ ").append(this.getNodeSimpleName(t)).append(" ]");
        if (analysis != null && (value = analysis.getValue(t)) != null) {
            sbBlockNode.append(" > ").append(value.toString());
        }
        return sbBlockNode.toString();
    }

    @Override
    public String visualizeStoreThisVal(A value) {
        return "  this > " + value + this.lineSeparator;
    }

    @Override
    public String visualizeStoreLocalVar(FlowExpressions.LocalVariable localVar, A value) {
        return "  " + localVar + " > " + value + this.lineSeparator;
    }

    @Override
    public String visualizeStoreFieldVals(FlowExpressions.FieldAccess fieldAccess, A value) {
        return "  " + fieldAccess + " > " + value + this.lineSeparator;
    }

    @Override
    public String visualizeStoreArrayVal(FlowExpressions.ArrayAccess arrayValue, A value) {
        return "  " + arrayValue + " > " + value + this.lineSeparator;
    }

    @Override
    public String visualizeStoreMethodVals(FlowExpressions.MethodCall methodCall, A value) {
        return "  " + methodCall + " > " + value + this.lineSeparator;
    }

    @Override
    public String visualizeStoreClassVals(FlowExpressions.ClassName className, A value) {
        return "  " + className + " > " + value + this.lineSeparator;
    }

    @Override
    public String visualizeStoreKeyVal(String keyName, Object value) {
        return "  " + keyName + " = " + value + this.lineSeparator;
    }

    @Override
    public String visualizeStoreHeader(String classCanonicalName) {
        return classCanonicalName + " (" + this.lineSeparator;
    }

    @Override
    public String visualizeStoreFooter() {
        return ")";
    }

    @Override
    public void shutdown() {
    }

    @Override
    protected String visualizeGraphHeader() {
        return "";
    }

    @Override
    protected String visualizeGraphFooter() {
        return "";
    }
}

