/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac.server;

import com.sun.tools.javac.main.Main;
import com.sun.tools.sjavac.Log;
import com.sun.tools.sjavac.Util;
import com.sun.tools.sjavac.server.ServerMain;
import com.sun.tools.sjavac.server.Sjavac;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.nio.file.Path;

public class RequestHandler
extends Thread {
    private final Socket socket;
    private final Sjavac sjavac;

    public RequestHandler(Socket socket, Sjavac sjavac) {
        this.socket = socket;
        this.sjavac = sjavac;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
             PrintWriter out = new PrintWriter(this.socket.getOutputStream(), true);){
            Log.setLogForCurrentThread(new Log(out, out){

                @Override
                protected boolean isLevelLogged(Log.Level l) {
                    return true;
                }

                @Override
                protected void printLogMsg(Log.Level msgLevel, String msg) {
                    Util.getLines(msg).map(line -> msgLevel + ":" + line).forEach(line -> super.printLogMsg(msgLevel, (String)line));
                }
            });
            int n = Integer.parseInt(in.readLine());
            String[] args = new String[n];
            for (int i = 0; i < n; ++i) {
                args[i] = in.readLine();
            }
            this.checkInternalErrorLog();
            Main.Result rc = this.sjavac.compile(args);
            out.println("RC:" + rc.name());
            this.checkInternalErrorLog();
        }
        catch (Exception ex) {
            Log.error(ex);
        }
        finally {
            Log.setLogForCurrentThread(null);
        }
    }

    private void checkInternalErrorLog() {
        Path errorLog = ServerMain.getErrorLog().getLogDestination();
        if (errorLog != null) {
            Log.error("Server has encountered an internal error. See " + errorLog.toAbsolutePath() + " for details.");
        }
    }
}

