/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.auto.value.AutoValue;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.concurrent.UnlockMethod;
import com.google.errorprone.bugpatterns.threadsafety.AutoValue_HeldLockAnalyzer_LockResource;
import com.google.errorprone.bugpatterns.threadsafety.GuardedByBinder;
import com.google.errorprone.bugpatterns.threadsafety.GuardedByExpression;
import com.google.errorprone.bugpatterns.threadsafety.GuardedByFlags;
import com.google.errorprone.bugpatterns.threadsafety.GuardedBySymbolResolver;
import com.google.errorprone.bugpatterns.threadsafety.GuardedByUtils;
import com.google.errorprone.bugpatterns.threadsafety.HeldLockSet;
import com.google.errorprone.bugpatterns.threadsafety.IllegalGuardedBy;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.Modifier;

public class HeldLockAnalyzer {
    private static final String MONITOR_GUARD_CLASS = "com.google.common.util.concurrent.Monitor.Guard";
    private static final ImmutableList<LockResource> LOCK_RESOURCES = ImmutableList.of((Object)LockResource.create("java.util.concurrent.locks.Lock", "lock", "unlock"), (Object)LockResource.create("com.google.common.util.concurrent.Monitor", "enter", "leave"), (Object)LockResource.create("java.util.concurrent.Semaphore", "acquire", "release"));

    public static void analyze(VisitorState state, LockEventListener listener, Predicate<Tree> isSuppressed, GuardedByFlags flags) {
        HeldLockSet locks = HeldLockSet.empty();
        locks = HeldLockAnalyzer.handleMonitorGuards(state, locks, flags);
        new LockScanner(state, listener, isSuppressed, flags).scan(state.getPath(), locks);
    }

    private static HeldLockSet handleMonitorGuards(VisitorState state, HeldLockSet locks, GuardedByFlags flags) {
        JCTree.JCNewClass newClassTree = (JCTree.JCNewClass)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), JCTree.JCNewClass.class);
        if (newClassTree == null) {
            return locks;
        }
        Symbol clazzSym = ASTHelpers.getSymbol((Tree)newClassTree.clazz);
        if (!(clazzSym instanceof Symbol.ClassSymbol)) {
            return locks;
        }
        if (!((Symbol.ClassSymbol)clazzSym).fullname.contentEquals(MONITOR_GUARD_CLASS)) {
            return locks;
        }
        Optional<GuardedByExpression> lockExpression = GuardedByBinder.bindExpression((JCTree.JCExpression)Iterables.getOnlyElement((Iterable)newClassTree.getArguments()), state, flags);
        if (!lockExpression.isPresent()) {
            return locks;
        }
        return locks.plus(lockExpression.get());
    }

    static class ExpectedLockCalculator {
        private static final GuardedByExpression.Factory F = new GuardedByExpression.Factory();

        ExpectedLockCalculator() {
        }

        static Optional<GuardedByExpression> from(JCTree.JCExpression guardedMemberExpression, GuardedByExpression guard, VisitorState state, GuardedByFlags flags) {
            if (ExpectedLockCalculator.isGuardReferenceAbsolute(guard)) {
                return Optional.of(guard);
            }
            Optional<GuardedByExpression> guardedMember = GuardedByBinder.bindExpression(guardedMemberExpression, state, flags);
            if (!guardedMember.isPresent()) {
                return Optional.empty();
            }
            GuardedByExpression memberBase = ((GuardedByExpression.Select)guardedMember.get()).base();
            return Optional.of(ExpectedLockCalculator.helper(guard, memberBase));
        }

        private static boolean isGuardReferenceAbsolute(GuardedByExpression guard) {
            GuardedByExpression instance = guard.kind() == GuardedByExpression.Kind.SELECT ? ExpectedLockCalculator.getSelectInstance(guard) : guard;
            return instance.kind() != GuardedByExpression.Kind.THIS;
        }

        private static GuardedByExpression getSelectInstance(GuardedByExpression guard) {
            if (guard instanceof GuardedByExpression.Select) {
                return ExpectedLockCalculator.getSelectInstance(((GuardedByExpression.Select)guard).base());
            }
            return guard;
        }

        private static GuardedByExpression helper(GuardedByExpression lockExpression, GuardedByExpression memberAccess) {
            switch (lockExpression.kind()) {
                case SELECT: {
                    GuardedByExpression.Select lockSelect = (GuardedByExpression.Select)lockExpression;
                    return F.select(ExpectedLockCalculator.helper(lockSelect.base(), memberAccess), lockSelect.sym());
                }
                case THIS: {
                    return memberAccess;
                }
            }
            throw new IllegalGuardedBy(lockExpression.toString());
        }
    }

    static class AcquiredLockFinder {
        private static final Matcher<ExpressionTree> LOCK_MATCHER = Matchers.anyOf(AcquiredLockFinder.unlockMatchers());

        AcquiredLockFinder() {
        }

        private static Iterable<Matcher<ExpressionTree>> unlockMatchers() {
            return Iterables.transform((Iterable)LOCK_RESOURCES, LockResource::createLockMatcher);
        }

        static Collection<GuardedByExpression> find(Tree tree, VisitorState state, GuardedByFlags flags) {
            return LockOperationFinder.find(tree, state, LOCK_MATCHER, flags);
        }
    }

    static class ReleasedLockFinder {
        private static final Matcher<ExpressionTree> UNLOCK_MATCHER = Matchers.anyOf(ReleasedLockFinder.unlockMatchers());

        ReleasedLockFinder() {
        }

        private static Iterable<Matcher<ExpressionTree>> unlockMatchers() {
            return Iterables.transform((Iterable)LOCK_RESOURCES, LockResource::createUnlockMatcher);
        }

        static Collection<GuardedByExpression> find(Tree tree, VisitorState state, GuardedByFlags flags) {
            return LockOperationFinder.find(tree, state, UNLOCK_MATCHER, flags);
        }
    }

    private static class LockOperationFinder
    extends TreeScanner<Void, Void> {
        private static final String READ_WRITE_LOCK_CLASS = "java.util.concurrent.locks.ReadWriteLock";
        private final Matcher<ExpressionTree> lockOperationMatcher;
        private final GuardedByFlags flags;
        private static final Matcher<ExpressionTree> READ_WRITE_ACCESSOR_MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOf("java.util.concurrent.locks.ReadWriteLock").named("readLock"), MethodMatchers.instanceMethod().onDescendantOf("java.util.concurrent.locks.ReadWriteLock").named("writeLock")});
        private final VisitorState state;
        private final Set<GuardedByExpression> locks = new HashSet<GuardedByExpression>();

        static Collection<GuardedByExpression> find(Tree tree, VisitorState state, Matcher<ExpressionTree> lockOperationMatcher, GuardedByFlags flags) {
            if (tree == null) {
                return Collections.emptyList();
            }
            LockOperationFinder finder = new LockOperationFinder(state, lockOperationMatcher, flags);
            tree.accept(finder, null);
            return finder.locks;
        }

        private LockOperationFinder(VisitorState state, Matcher<ExpressionTree> lockOperationMatcher, GuardedByFlags flags) {
            this.state = state;
            this.lockOperationMatcher = lockOperationMatcher;
            this.flags = flags;
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree tree, Void unused) {
            this.handleReleasedLocks(tree);
            this.handleUnlockAnnotatedMethods(tree);
            return null;
        }

        private void handleReleasedLocks(MethodInvocationTree tree) {
            if (!this.lockOperationMatcher.matches((Tree)tree, this.state)) {
                return;
            }
            Optional<GuardedByExpression> node = GuardedByBinder.bindExpression((JCTree.JCExpression)((Object)tree), this.state, this.flags);
            if (node.isPresent()) {
                GuardedByExpression receiver = ((GuardedByExpression.Select)node.get()).base();
                this.locks.add(receiver);
                if (tree.getMethodSelect() instanceof MemberSelectTree && READ_WRITE_ACCESSOR_MATCHER.matches((Tree)ASTHelpers.getReceiver((ExpressionTree)tree), this.state)) {
                    this.locks.add(((GuardedByExpression.Select)receiver).base());
                }
            }
        }

        private void handleUnlockAnnotatedMethods(MethodInvocationTree tree) {
            UnlockMethod annotation = (UnlockMethod)ASTHelpers.getAnnotation((Tree)tree, UnlockMethod.class);
            if (annotation == null) {
                return;
            }
            for (String lockString : annotation.value()) {
                Optional<GuardedByExpression> lock;
                Optional<GuardedByExpression> guard = GuardedByBinder.bindString(lockString, GuardedBySymbolResolver.from(tree, this.state), this.flags);
                if (!guard.isPresent() || !(lock = ExpectedLockCalculator.from((JCTree.JCExpression)((Object)tree), guard.get(), this.state, this.flags)).isPresent()) continue;
                this.locks.add(lock.get());
            }
        }
    }

    @AutoValue
    static abstract class LockResource {
        LockResource() {
        }

        abstract String className();

        abstract String lockMethod();

        abstract String unlockMethod();

        public Matcher<ExpressionTree> createUnlockMatcher() {
            return MethodMatchers.instanceMethod().onDescendantOf(this.className()).named(this.unlockMethod());
        }

        public Matcher<ExpressionTree> createLockMatcher() {
            return MethodMatchers.instanceMethod().onDescendantOf(this.className()).named(this.lockMethod());
        }

        static LockResource create(String className, String lockMethod, String unlockMethod) {
            return new AutoValue_HeldLockAnalyzer_LockResource(className, lockMethod, unlockMethod);
        }
    }

    private static class LockScanner
    extends TreePathScanner<Void, HeldLockSet> {
        private final VisitorState visitorState;
        private final LockEventListener listener;
        private final Predicate<Tree> isSuppressed;
        private final GuardedByFlags flags;
        private static final GuardedByExpression.Factory F = new GuardedByExpression.Factory();

        private LockScanner(VisitorState visitorState, LockEventListener listener, Predicate<Tree> isSuppressed, GuardedByFlags flags) {
            this.visitorState = visitorState;
            this.listener = listener;
            this.isSuppressed = isSuppressed;
            this.flags = flags;
        }

        @Override
        public Void visitMethod(MethodTree tree, HeldLockSet locks) {
            if (this.isSuppressed.apply((Object)tree)) {
                return null;
            }
            Set<Modifier> mods = tree.getModifiers().getFlags();
            if (mods.contains((Object)Modifier.SYNCHRONIZED)) {
                Symbol owner = ((JCTree.JCMethodDecl)tree).sym.owner;
                GuardedByExpression lock = mods.contains((Object)Modifier.STATIC) ? F.classLiteral(owner) : F.thisliteral();
                locks = locks.plus(lock);
            }
            for (String guard : GuardedByUtils.getGuardValues(tree, this.visitorState)) {
                Optional<GuardedByExpression> bound = GuardedByBinder.bindString(guard, GuardedBySymbolResolver.from(tree, this.visitorState), this.flags);
                if (!bound.isPresent()) continue;
                locks = locks.plus(bound.get());
            }
            return (Void)super.visitMethod(tree, locks);
        }

        @Override
        public Void visitTry(TryTree tree, HeldLockSet locks) {
            this.scan(tree.getResources(), locks);
            List<? extends Tree> resources = tree.getResources();
            this.scan(resources, locks);
            Collection<GuardedByExpression> releasedLocks = ReleasedLockFinder.find(tree.getFinallyBlock(), this.visitorState, this.flags);
            if (resources.isEmpty()) {
                this.scan(tree.getBlock(), locks.plusAll(releasedLocks));
            }
            this.scan(tree.getCatches(), locks.plusAll(releasedLocks));
            this.scan(tree.getFinallyBlock(), locks);
            return null;
        }

        @Override
        public Void visitSynchronized(SynchronizedTree tree, HeldLockSet locks) {
            Optional<GuardedByExpression> lockExpression = GuardedByBinder.bindExpression((JCTree.JCExpression)tree.getExpression(), this.visitorState, this.flags);
            this.scan(tree.getBlock(), lockExpression.isPresent() ? locks.plus(lockExpression.get()) : locks);
            return null;
        }

        @Override
        public Void visitMemberSelect(MemberSelectTree tree, HeldLockSet locks) {
            this.checkMatch(tree, locks);
            return (Void)super.visitMemberSelect(tree, locks);
        }

        @Override
        public Void visitIdentifier(IdentifierTree tree, HeldLockSet locks) {
            this.checkMatch(tree, locks);
            return (Void)super.visitIdentifier(tree, locks);
        }

        @Override
        public Void visitNewClass(NewClassTree tree, HeldLockSet locks) {
            this.scan(tree.getEnclosingExpression(), locks);
            this.scan(tree.getIdentifier(), locks);
            this.scan(tree.getTypeArguments(), locks);
            this.scan(tree.getArguments(), locks);
            return null;
        }

        @Override
        public Void visitLambdaExpression(LambdaExpressionTree node, HeldLockSet heldLockSet) {
            return null;
        }

        @Override
        public Void visitVariable(VariableTree node, HeldLockSet locks) {
            return this.isSuppressed.apply((Object)node) ? null : (Void)super.visitVariable(node, locks);
        }

        @Override
        public Void visitClass(ClassTree node, HeldLockSet locks) {
            return this.isSuppressed.apply((Object)node) ? null : (Void)super.visitClass(node, locks);
        }

        private void checkMatch(ExpressionTree tree, HeldLockSet locks) {
            for (String guardString : GuardedByUtils.getGuardValues(tree, this.visitorState)) {
                GuardedByBinder.bindString(guardString, GuardedBySymbolResolver.from(tree, this.visitorState), this.flags).ifPresent(guard -> {
                    Optional<GuardedByExpression> boundGuard = ExpectedLockCalculator.from((JCTree.JCExpression)tree, guard, this.visitorState, this.flags);
                    if (!boundGuard.isPresent()) {
                        this.listener.handleGuardedAccess(tree, new GuardedByExpression.Factory().error(guardString), locks);
                        return;
                    }
                    this.listener.handleGuardedAccess(tree, boundGuard.get(), locks);
                });
            }
        }
    }

    public static interface LockEventListener {
        public void handleGuardedAccess(ExpressionTree var1, GuardedByExpression var2, HeldLockSet var3);
    }
}

