/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.javadoc;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.javadoc.JavadocTag;
import com.google.errorprone.bugpatterns.javadoc.Utils;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.EndElementTree;
import com.sun.source.doctree.ErroneousTree;
import com.sun.source.doctree.StartElementTree;
import com.sun.source.doctree.UnknownBlockTagTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.DocTreePathScanner;
import com.sun.tools.javac.tree.DCTree;
import com.sun.tools.javac.util.JCDiagnostic;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

@BugPattern(name="InvalidBlockTag", summary="This tag is invalid.", severity=BugPattern.SeverityLevel.WARNING, tags={"Style"}, documentSuppression=false)
public final class InvalidBlockTag
extends BugChecker
implements BugChecker.ClassTreeMatcher,
BugChecker.MethodTreeMatcher,
BugChecker.VariableTreeMatcher {
    private static final String INVALID_TAG_IS_PARAMETER_NAME = "@%1$s is not a valid tag, but is a parameter name. Use {@code %1%s} to refer to parameter names inline.";
    private static final ImmutableSet<String> CODE_TAGS = ImmutableSet.of((Object)"code", (Object)"pre");

    public Description matchClass(ClassTree classTree, VisitorState state) {
        DocTreePath path = Utils.getDocTreePath(state);
        if (path != null) {
            ImmutableSet parameters = ImmutableSet.of();
            new InvalidTagChecker(state, JavadocTag.VALID_CLASS_TAGS, parameters).scan(path, null);
        }
        return Description.NO_MATCH;
    }

    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        DocTreePath path = Utils.getDocTreePath(state);
        if (path != null) {
            ImmutableSet parameters = (ImmutableSet)methodTree.getParameters().stream().map(v -> v.getName().toString()).collect(ImmutableSet.toImmutableSet());
            new InvalidTagChecker(state, JavadocTag.VALID_METHOD_TAGS, parameters).scan(path, null);
        }
        return Description.NO_MATCH;
    }

    public Description matchVariable(VariableTree variableTree, VisitorState state) {
        DocTreePath path = Utils.getDocTreePath(state);
        if (path != null) {
            new InvalidTagChecker(state, JavadocTag.VALID_VARIABLE_TAGS, ImmutableSet.of()).scan(path, null);
        }
        return Description.NO_MATCH;
    }

    private final class InvalidTagChecker
    extends DocTreePathScanner<Void, Void> {
        private final VisitorState state;
        private final ImmutableSet<JavadocTag> validTags;
        private final ImmutableSet<String> parameters;
        private final Set<DocTree> fixedTags = new HashSet<DocTree>();
        private int codeTagNestedDepth = 0;

        private InvalidTagChecker(VisitorState state, ImmutableSet<JavadocTag> validTags, ImmutableSet<String> parameters) {
            this.state = state;
            this.validTags = validTags;
            this.parameters = parameters;
        }

        @Override
        public Void visitStartElement(StartElementTree startElementTree, Void unused) {
            if (CODE_TAGS.contains((Object)startElementTree.getName().toString())) {
                ++this.codeTagNestedDepth;
            }
            return (Void)super.visitStartElement(startElementTree, null);
        }

        @Override
        public Void visitEndElement(EndElementTree endElementTree, Void unused) {
            if (CODE_TAGS.contains((Object)endElementTree.getName().toString())) {
                --this.codeTagNestedDepth;
            }
            return (Void)super.visitEndElement(endElementTree, null);
        }

        @Override
        public Void visitErroneous(ErroneousTree erroneousTree, Void unused) {
            JCDiagnostic diagnostic = ((DCTree.DCErroneous)erroneousTree).diag;
            if (!diagnostic.getCode().equals("compiler.err.dc.bad.inline.tag")) {
                return null;
            }
            JavadocTag tag = JavadocTag.inlineTag(erroneousTree.toString().replace("@", ""));
            SuggestedFix fix = this.validTags.contains((Object)tag) ? Utils.replace(erroneousTree, String.format("{%s}", erroneousTree), this.state) : SuggestedFix.builder().build();
            String message = String.format("%s is not a valid block tag. Should it be an inline tag instead?", erroneousTree);
            this.state.reportMatch(InvalidBlockTag.this.buildDescription(Utils.diagnosticPosition(this.getCurrentPath(), this.state)).setMessage(message).addFix((Fix)fix).build());
            return null;
        }

        @Override
        public Void visitUnknownBlockTag(UnknownBlockTagTree unknownBlockTagTree, Void unused) {
            String tagName = unknownBlockTagTree.getTagName();
            JavadocTag tag = JavadocTag.blockTag(tagName);
            if (JavadocTag.KNOWN_OTHER_TAGS.contains((Object)tag)) {
                return (Void)super.visitUnknownBlockTag(unknownBlockTagTree, null);
            }
            if (this.codeTagNestedDepth > 0) {
                if (this.parentIsErroneousCodeTag()) {
                    String message = String.format("@%s is interpreted as a block tag here, not as a literal. Escaping annotations within {@code } tags is problematic; you may have to avoid using {@code } and escape any HTML entities manually instead.", tagName);
                    this.state.reportMatch(InvalidBlockTag.this.buildDescription(Utils.diagnosticPosition(this.getCurrentPath(), this.state)).setMessage(message).build());
                    this.fixedTags.add(unknownBlockTagTree);
                    return (Void)super.visitUnknownBlockTag(unknownBlockTagTree, null);
                }
                int startPos = Utils.getStartPosition(unknownBlockTagTree, this.state);
                String message = String.format("@%s is not a valid block tag. Did you mean to escape it? Annotations must be escaped even within <pre> and <code>, otherwise they will be interpreted as block tags.", tagName);
                this.state.reportMatch(InvalidBlockTag.this.buildDescription(Utils.diagnosticPosition(this.getCurrentPath(), this.state)).setMessage(message).addFix((Fix)SuggestedFix.replace((int)startPos, (int)(startPos + 1), (String)"{@literal @}")).build());
                this.fixedTags.add(unknownBlockTagTree);
                return (Void)super.visitUnknownBlockTag(unknownBlockTagTree, null);
            }
            if (this.parameters.contains((Object)tagName)) {
                int startPos = Utils.getStartPosition(unknownBlockTagTree, this.state);
                String message = String.format(InvalidBlockTag.INVALID_TAG_IS_PARAMETER_NAME, tagName);
                this.state.reportMatch(InvalidBlockTag.this.buildDescription(Utils.diagnosticPosition(this.getCurrentPath(), this.state)).setMessage(message).addFix((Fix)SuggestedFix.replace((int)startPos, (int)(startPos + 1), (String)"@param ")).build());
                this.fixedTags.add(unknownBlockTagTree);
                return (Void)super.visitUnknownBlockTag(unknownBlockTagTree, null);
            }
            this.reportUnknownTag(unknownBlockTagTree, tag);
            return (Void)super.visitUnknownBlockTag(unknownBlockTagTree, null);
        }

        private boolean parentIsErroneousCodeTag() {
            if (this.getCurrentPath().getParentPath() == null) {
                return false;
            }
            DocTree parentDoc = this.getCurrentPath().getParentPath().getLeaf();
            if (!(parentDoc instanceof DCTree.DCDocComment)) {
                return false;
            }
            DCTree.DCDocComment dcDocComment = (DCTree.DCDocComment)parentDoc;
            return dcDocComment.getFullBody().stream().anyMatch(dc -> dc instanceof DCTree.DCErroneous && ((DCTree.DCErroneous)dc).body.startsWith("{@code"));
        }

        private void reportUnknownTag(DocTree docTree, JavadocTag tag) {
            Optional<String> bestMatch = Utils.getBestMatch(tag.name(), (Iterable)this.validTags.stream().filter(t -> t.type().equals((Object)tag.type())).map(JavadocTag::name).collect(ImmutableSet.toImmutableSet()));
            int pos = Utils.getStartPosition(docTree, this.state) + docTree.toString().indexOf(tag.name());
            String message = String.format("Tag name `%s` is unknown.", tag.name());
            this.state.reportMatch(bestMatch.map(bm -> InvalidBlockTag.this.buildDescription(Utils.diagnosticPosition(this.getCurrentPath(), this.state)).setMessage(message + String.format(" Did you mean tag `%s`?", bm)).addFix((Fix)SuggestedFix.replace((int)pos, (int)(pos + tag.name().length()), (String)bm)).build()).orElse(InvalidBlockTag.this.buildDescription(Utils.diagnosticPosition(this.getCurrentPath(), this.state)).setMessage(message + " If this is a commonly-used custom tag, please click 'not useful' and file a bug.").build()));
            this.fixedTags.add(docTree);
        }

        @Override
        public Void scan(DocTree docTree, Void unused) {
            super.scan(docTree, null);
            if (this.fixedTags.contains(docTree)) {
                return null;
            }
            if (!(docTree instanceof DCTree.DCBlockTag)) {
                return null;
            }
            JavadocTag tag = JavadocTag.blockTag(((DCTree.DCBlockTag)docTree).getTagName());
            if (this.validTags.contains((Object)tag) || JavadocTag.KNOWN_OTHER_TAGS.contains((Object)tag)) {
                return null;
            }
            String message = String.format("The tag @%s is not allowed on this type of element.", tag.name());
            this.state.reportMatch(InvalidBlockTag.this.buildDescription(Utils.diagnosticPosition(this.getCurrentPath(), this.state)).setMessage(message).addFix((Fix)Utils.replace(docTree, "", this.state)).build());
            return null;
        }
    }
}

