/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.collectionincompatibletype;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.collectionincompatibletype.AbstractCollectionIncompatibleTypeMatcher;
import com.google.errorprone.bugpatterns.collectionincompatibletype.BinopMatcher;
import com.google.errorprone.bugpatterns.collectionincompatibletype.MethodArgMatcher;
import com.google.errorprone.bugpatterns.collectionincompatibletype.TypeArgOfMethodArgMatcher;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.predicates.TypePredicates;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import javax.annotation.Nullable;

public final class ContainmentMatchers {
    private static final Matcher<ExpressionTree> FIRST_ORDER_MATCHER = Matchers.anyMethod().onClass(TypePredicates.isDescendantOfAny((Iterable)ImmutableList.of((Object)"java.util.Collection", (Object)"java.util.Dictionary", (Object)"java.util.Map", (Object)"java.util.Collections", (Object)"com.google.common.collect.Sets")));
    private static final ImmutableList<MethodArgMatcher> DIRECT_MATCHERS = ImmutableList.of((Object)new MethodArgMatcher("java.util.Collection", "contains(java.lang.Object)", 0, 0), (Object)new MethodArgMatcher("java.util.Collection", "remove(java.lang.Object)", 0, 0), (Object)new MethodArgMatcher("java.util.Deque", "removeFirstOccurrence(java.lang.Object)", 0, 0), (Object)new MethodArgMatcher("java.util.Deque", "removeLastOccurrence(java.lang.Object)", 0, 0), (Object)new MethodArgMatcher("java.util.Dictionary", "get(java.lang.Object)", 0, 0), (Object)new MethodArgMatcher("java.util.Dictionary", "remove(java.lang.Object)", 0, 0), (Object)new MethodArgMatcher("java.util.List", "indexOf(java.lang.Object)", 0, 0), (Object)new MethodArgMatcher("java.util.List", "lastIndexOf(java.lang.Object)", 0, 0), (Object)new MethodArgMatcher("java.util.Map", "containsKey(java.lang.Object)", 0, 0), (Object)new MethodArgMatcher("java.util.Map", "containsValue(java.lang.Object)", 1, 0), (Object)new MethodArgMatcher("java.util.Map", "get(java.lang.Object)", 0, 0), (Object)new MethodArgMatcher("java.util.Map", "getOrDefault(java.lang.Object,V)", 0, 0), (Object[])new MethodArgMatcher[]{new MethodArgMatcher("java.util.Map", "remove(java.lang.Object)", 0, 0), new MethodArgMatcher("java.util.Stack", "search(java.lang.Object)", 0, 0), new MethodArgMatcher("java.util.Vector", "indexOf(java.lang.Object,int)", 0, 0), new MethodArgMatcher("java.util.Vector", "lastIndexOf(java.lang.Object,int)", 0, 0), new MethodArgMatcher("java.util.Vector", "removeElement(java.lang.Object)", 0, 0)});
    private static final ImmutableList<TypeArgOfMethodArgMatcher> TYPE_ARG_MATCHERS = ImmutableList.of((Object)new TypeArgOfMethodArgMatcher("java.util.Collection", "containsAll(java.util.Collection<?>)", 0, 0, "java.util.Collection", 0), (Object)new TypeArgOfMethodArgMatcher("java.util.Collection", "removeAll(java.util.Collection<?>)", 0, 0, "java.util.Collection", 0), (Object)new TypeArgOfMethodArgMatcher("java.util.Collection", "retainAll(java.util.Collection<?>)", 0, 0, "java.util.Collection", 0));
    private static final ImmutableList<BinopMatcher> STATIC_MATCHERS = ImmutableList.of((Object)new BinopMatcher("java.util.Collection", "java.util.Collections", "disjoint"), (Object)new BinopMatcher("java.util.Set", "com.google.common.collect.Sets", "difference"));
    private static final ImmutableList<AbstractCollectionIncompatibleTypeMatcher> ALL_MATCHERS = ImmutableList.builder().addAll(DIRECT_MATCHERS).addAll(TYPE_ARG_MATCHERS).addAll(STATIC_MATCHERS).build();

    @Nullable
    public static AbstractCollectionIncompatibleTypeMatcher.MatchResult firstNonNullMatchResult(ExpressionTree tree, VisitorState state) {
        if (!FIRST_ORDER_MATCHER.matches((Tree)tree, state)) {
            return null;
        }
        for (AbstractCollectionIncompatibleTypeMatcher matcher : ALL_MATCHERS) {
            AbstractCollectionIncompatibleTypeMatcher.MatchResult result = matcher.matches(tree, state);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private ContainmentMatchers() {
    }
}

