/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;

@BugPattern(name="ImmutableModification", summary="Modifying an immutable collection is guaranteed to throw an exception and leave the collection unmodified", severity=BugPattern.SeverityLevel.ERROR)
public class ImmutableModification
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.MemberReferenceTreeMatcher {
    public static final ImmutableSetMultimap<String, String> ILLEGAL_METHODS_BY_BASE_TYPE = ImmutableSetMultimap.builder().putAll((Object)"com.google.common.collect.ImmutableBiMap", (Object[])new String[]{"forcePut"}).putAll((Object)"com.google.common.collect.ImmutableClassToInstanceMap", (Object[])new String[]{"putInstance"}).putAll((Object)"com.google.common.collect.ImmutableCollection", (Object[])new String[]{"add", "addAll", "clear", "remove", "removeAll", "removeIf", "retainAll"}).putAll((Object)"com.google.common.collect.ImmutableList", (Object[])new String[]{"set", "sort"}).putAll((Object)"com.google.common.collect.ImmutableMap", (Object[])new String[]{"clear", "compute", "computeIfAbsent", "computeIfPresent", "merge", "put", "putAll", "putIfAbsent", "remove", "replace", "replaceAll"}).putAll((Object)"com.google.common.collect.ImmutableMultimap", (Object[])new String[]{"clear", "put", "putAll", "remove", "removeAll", "replaceValues"}).putAll((Object)"com.google.common.collect.ImmutableMultiset", (Object[])new String[]{"setCount"}).putAll((Object)"com.google.common.collect.ImmutableRangeMap", (Object[])new String[]{"clear", "put", "putAll", "remove"}).putAll((Object)"com.google.common.collect.ImmutableRangeSet", (Object[])new String[]{"add", "addAll", "remove", "removeAll"}).putAll((Object)"com.google.common.collect.ImmutableSortedMap", (Object[])new String[]{"pollFirstEntry", "pollLastEntry"}).putAll((Object)"com.google.common.collect.ImmutableSortedSet", (Object[])new String[]{"pollFirst", "pollLast"}).putAll((Object)"com.google.common.collect.ImmutableTable", (Object[])new String[]{"clear", "put", "putAll", "remove"}).putAll((Object)"com.google.common.collect.UnmodifiableIterator", (Object[])new String[]{"remove"}).putAll((Object)"com.google.common.collect.UnmodifiableListIterator", (Object[])new String[]{"add", "set"}).putAll((Object)"com.google.common.collect.Sets.SetView", (Object[])new String[]{"add", "addAll", "clear", "remove", "removeAll", "removeIf", "retainAll"}).build();

    public Description matchMemberReference(MemberReferenceTree tree, VisitorState state) {
        return this.match(tree, ASTHelpers.getSymbol((MemberReferenceTree)tree), state);
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return this.match(tree, ASTHelpers.getSymbol((MethodInvocationTree)tree), state);
    }

    private Description match(ExpressionTree tree, Symbol.MethodSymbol method, VisitorState state) {
        if (method == null) {
            return Description.NO_MATCH;
        }
        ImmutableSet forbiddenTypes = ILLEGAL_METHODS_BY_BASE_TYPE.inverse().get((Object)((Name)method.getSimpleName()).toString());
        if (forbiddenTypes == null) {
            return Description.NO_MATCH;
        }
        Type ownerType = method.owner.type;
        for (String forbiddenType : forbiddenTypes) {
            if (!ASTHelpers.isSubtype((Type)ownerType, (Type)state.getTypeFromString(forbiddenType), (VisitorState)state)) continue;
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }
}

