/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.internal;

import com.android.ide.common.internal.LoggedErrorException;
import com.android.utils.GrabProcessOutput;
import com.android.utils.ILogger;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class CommandLineRunner {
    private final ILogger mLogger;

    public CommandLineRunner(ILogger logger) {
        this.mLogger = logger;
    }

    public void runCmdLine(List<String> command, Map<String, String> envVariableMap) throws IOException, InterruptedException, LoggedErrorException {
        String[] cmdArray = command.toArray(new String[command.size()]);
        this.runCmdLine(cmdArray, envVariableMap);
    }

    public void runCmdLine(List<String> command, CommandLineOutput commandLineOutput, Map<String, String> envVariableMap) throws IOException, InterruptedException, LoggedErrorException {
        String[] cmdArray = command.toArray(new String[command.size()]);
        this.runCmdLine(cmdArray, commandLineOutput, envVariableMap);
    }

    public void runCmdLine(String[] command, Map<String, String> envVariableMap) throws IOException, InterruptedException, LoggedErrorException {
        OutputGrabber grabber = new OutputGrabber();
        this.runCmdLine(command, (CommandLineOutput)grabber, envVariableMap);
    }

    public void runCmdLine(String[] command, CommandLineOutput commandLineOutput, Map<String, String> envVariableMap) throws IOException, InterruptedException, LoggedErrorException {
        Process process;
        int returnCode;
        this.printCommand(command);
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        if (envVariableMap != null) {
            Map<String, String> env = processBuilder.environment();
            for (Map.Entry<String, String> entry : envVariableMap.entrySet()) {
                env.put(entry.getKey(), entry.getValue());
            }
        }
        if ((returnCode = GrabProcessOutput.grabProcessOutput((Process)(process = processBuilder.start()), (GrabProcessOutput.Wait)GrabProcessOutput.Wait.WAIT_FOR_READERS, (GrabProcessOutput.IProcessOutput)commandLineOutput)) != 0) {
            throw new LoggedErrorException(returnCode, commandLineOutput.getErrors(), Joiner.on((char)' ').join((Object[])command));
        }
    }

    private void printCommand(String[] command) {
        this.mLogger.info("command: " + Joiner.on((char)' ').join((Object[])command), new Object[0]);
    }

    private class OutputGrabber
    extends CommandLineOutput {
        private OutputGrabber() {
        }

        public void out(String line) {
            if (line != null) {
                CommandLineRunner.this.mLogger.info(line, new Object[0]);
            }
        }

        @Override
        public void err(String line) {
            super.err(line);
            if (line != null) {
                CommandLineRunner.this.mLogger.error(null, line, new Object[0]);
            }
        }
    }

    public static abstract class CommandLineOutput
    implements GrabProcessOutput.IProcessOutput {
        private final List<String> mErrors = Lists.newArrayList();

        public void err(String line) {
            if (line != null) {
                this.mErrors.add(line);
            }
        }

        public final List<String> getErrors() {
            return this.mErrors;
        }
    }
}

